#if !defined(__file_info_hpp__)
#define __file_info_hpp__



//-----------------------------------------------------------------------------
// file_info is basically a wrapper around libc's lstat function.
class file_info {

public:
	file_info();
	file_info(const string& src);
	file_info(const char* src);

	bool operator< (file_info& rhs);
	bool operator> (file_info& rhs);
	bool operator== (file_info& rhs);

	file_info& operator= (string& rhs);
	file_info& operator= (const char* rhs);

	bool exists;

	path name;

	bool is_dir;
	bool is_hardlink;
	bool is_char_device;
	bool is_block_device;
	bool is_regular_file;
	bool is_pipe;
	bool is_symlink;
	bool is_socket;

	bool is_dangling_symlink;
	string symlink_name;

	struct
	{
		bool owner_r;
		bool owner_w;
		bool owner_x;
		bool group_r;
		bool group_w;
		bool group_x;
		bool other_r;
		bool other_w;
		bool other_x;
		bool suid_x;
		bool sgid_x;
		bool sticky;
	} perm;

	unsigned long serial_nbr;
	unsigned dev_nbr;
	unsigned rdev_nbr;
	unsigned hardlinks;
	unsigned long size;
	long access_time;
	long mod_time;
	long attrib_time;

	unsigned uid;
	string uid_name;
	unsigned gid;
	string gid_name;

protected:
	void init();
	void read_file_info();
};



#endif /* !defined(__file_info_hpp__) */
