module std.c.dirent;

private import gcc.config;
private import std.string;

extern(C) {

struct dirent {
    byte[gcc.config.dirent_d_name_offset] opaque1;
    char[gcc.config.dirent_d_name_size] d_name;
    byte[gcc.config.dirent_remaining_size] opaque2;
}

struct DIR {
    byte[gcc.config.DIR_struct_size] opaque;
}

DIR * opendir(char *);
dirent * readdir(DIR *);
void rewinddir(DIR *);
int closedir(DIR *);

}

char[] readdirD(DIR * dir)
{
    dirent* ent = readdir(dir);
    if (ent)
        return toString(ent.d_name);
    else
        return null;
}
