target=$1
target_cpu=`echo $target | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\1/'`
target_vendor=`echo $target | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\2/'`
target_os=`echo $target | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\3/'`

d_target_os=`echo $target_os | sed 's/^\([A-Za-z_]+\)/\1/'`
case "$d_target_os" in
linux*) d_os_versym=linux ; d_unix=1 ;; 
darwin*) d_os_versym=darwin ; d_unix=1 ;;
*bsd*) d_os_versym=bsd ; d_unix=1 ;;
cygwin*) d_os_versym=cygwin ; d_unix=1 ;;
sysv3*) d_os_versym=sysv3; d_unix=1 ;;
sysv4*) d_os_versym=sysv4; d_unix=1 ;;
*) d_os_versym="$d_target_os"
esac

case "$target_cpu" in
i*86) d_cpu_versym=X86 ;;
*ppc*) d_cpu_versym=PPC ;;
powerpc) d_cpu_versym=PPC ;;
esac

output=""
if test -n "$d_cpu_versym"; then
    output="$output -DD_CPU_VERSYM="\\\"$d_cpu_versym\\\";
fi
if test -n "$d_os_versym"; then
    output="$output -DD_OS_VERSYM="\\\"$d_os_versym\\\";
fi
#if test -n "$d_unix"; then
#   output="$output -DD_OS_VERSYM2="\\\"Unix\\\";
#fi

echo $output
