#!/bin/bash
#
# Generic package build script
#
# $Id: generic-build-script,v 1.24 2004/06/19 19:23:09 igor Exp $
#
# Package maintainers: if the original source is not distributed as a
# (possibly compressed) tarball, set the value of ${src_orig_pkg_name},
# and redefine the unpack() helper function appropriately.
# Also, if the Makefile rule to run the test suite is not "test", change
# the definition of ${test_rule} below.

# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.
# If scriptdir ends in SPECS, then topdir is $scriptdir/..
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export BASEPKG=${PKG}-${VER}
export FULLPKG=${BASEPKG}-${REL}

# determine correct decompression option and tarball filename
export src_orig_pkg_name=
if [ -e "${src_orig_pkg_name}" ] ; then
  export opt_decomp=? # Make sure tar punts if unpack() is not redefined
elif [ -e ${BASEPKG}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_name=${BASEPKG}.tar.bz2
elif [ -e ${BASEPKG}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_name=${BASEPKG}.tar.gz
elif [ -e ${BASEPKG}.tgz ] ; then
  export opt_decomp=z
  export src_orig_pkg_name=${BASEPKG}.tgz
elif [ -e ${BASEPKG}.tar ] ; then
  export opt_decomp=
  export src_orig_pkg_name=${BASEPKG}.tar
else
  echo Cannot find original package.
  exit 1
fi

export src_orig_pkg=${topdir}/${src_orig_pkg_name}

PKG2=libintl3
PKG3=gettext-devel
PKG4=libgettextpo0

# determine correct names for generated files
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${PKG2}-${VER}-${REL}.tar.bz2
export bin_pkg_name3=${PKG3}-${VER}-${REL}.tar.bz2
export bin_pkg_name4=${PKG4}-${VER}-${REL}.tar.bz2

export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export bin_pkg4=${topdir}/${bin_pkg_name4}
export srcdir=${topdir}/${BASEPKG}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check

prefix=/usr
sysconfdir=/etc
localstatedir=/var
pnoslash=`echo $prefix | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
if [ -z "$MY_CFLAGS" ]; then
  MY_CFLAGS="-O2"
fi
if [ -z "$MY_LDFLAGS" ]; then
  MY_LDFLAGS=
fi
alias_path='/usr/share/locale:/usr/local/share/locale:/usr/X11R6/lib/X11/locale'
PKG1_LIST="\
  ${pnoslash}/share/doc/Cygwin/${PKG}-${VER}.README \
  ${pnoslash}/share/doc/${PKG}-${VER}/* \
  ${pnoslash}/share/gettext/ABOUT-NLS \
  ${pnoslash}/bin/gettext.exe \
  ${pnoslash}/bin/ngettext.exe \
  ${pnoslash}/bin/envsubst.exe \
  ${pnoslash}/bin/gettext.sh \
  ${pnoslash}/share/man/man1/gettext.1.gz \
  ${pnoslash}/share/man/man1/ngettext.1.gz \
  ${pnoslash}/share/man/man1/envsubst.1.gz \
  ${pnoslash}/share/doc/gettext/gettext.1.html \
  ${pnoslash}/share/doc/gettext/ngettext.1.html \
  ${pnoslash}/share/doc/gettext/envsubst.1.html \
  ${pnoslash}/share/locale/*/LC_MESSAGES/gettext-runtime.mo \
  ${pnoslash}/lib/libintl.* \
  ${pnoslash}/lib/charset.alias \
  ${pnoslash}/share/locale/locale.alias \
  ${pnoslash}/include/libintl.h \
  ${pnoslash}/share/man/man3/* \
  ${pnoslash}/share/doc/gettext/*.3.html \
  ${pnoslash}/share/doc/gettext/javadoc1/* \
  ${pnoslash}/share/doc/gettext/javadoc2/* \
  ${pnoslash}/share/doc/gettext/csharpdoc/* \
  ${pnoslash}/lib/libasprintf.* \
  ${pnoslash}/include/autosprintf.h \
  ${pnoslash}/share/doc/libasprintf/autosprintf.html \
  ${pnoslash}/share/info/autosprintf.info.gz"
PKG2_LIST="\
  ${pnoslash}/bin/cygintl-*.dll"
PKG4_LIST="\
  ${pnoslash}/bin/cyggettextpo-*.dll \
  ${pnoslash}/bin/cyggettextlib-*.dll \
  ${pnoslash}/bin/cyggettextsrc-*.dll"
PKG3_LIST="\
  ${pnoslash}/share/doc/Cygwin/gettext-devel-0.14.1.README \
  ${pnoslash}/bin/msg*.exe \
  ${pnoslash}/bin/xgettext.exe \
  ${pnoslash}/bin/gettextize \
  ${pnoslash}/bin/autopoint \
  ${pnoslash}/share/man/man1/msg*.1.gz \
  ${pnoslash}/share/man/man1/xgettext.1.gz \
  ${pnoslash}/share/man/man1/gettextize.1.gz \
  ${pnoslash}/share/man/man1/autopoint.1.gz \
  ${pnoslash}/share/doc/gettext/msg*.1.html \
  ${pnoslash}/share/doc/gettext/xgettext.1.html \
  ${pnoslash}/share/doc/gettext/gettextize.1.html \
  ${pnoslash}/share/doc/gettext/autopoint.1.html \
  ${pnoslash}/share/doc/gettext/gettext_*.html \
  ${pnoslash}/share/doc/gettext/examples/* \
  ${pnoslash}/share/info/gettext.info* \
  ${pnoslash}/include/gettext-po.h \
  ${pnoslash}/lib/libgettextlib.* \
  ${pnoslash}/lib/libgettextsrc.* \
  ${pnoslash}/lib/libgettextpo.* \
  ${pnoslash}/lib/gettext/* \
  ${pnoslash}/share/locale/*/LC_MESSAGES/gettext-tools.mo \
  ${pnoslash}/share/gettext/config.rpath \
  ${pnoslash}/share/gettext/mkinstalldirs \
  ${pnoslash}/share/gettext/intl/* \
  ${pnoslash}/share/gettext/po/* \
  ${pnoslash}/share/gettext/projects/* \
  ${pnoslash}/share/gettext/gettext.h \
  ${pnoslash}/share/gettext/msgunfmt.tcl \
  ${pnoslash}/share/gettext/archive.tar.gz \
  ${pnoslash}/share/aclocal/* \
  ${pnoslash}/share/emacs/site-lisp/*"

export install_docs="\
	ABOUT-NLS \
	ANNOUNCE \
	AUTHORS \
	BUG-REPORTS \
	CHANGES \
	CONTRIBUTORS \
	COPYING \
	CREDITS \
	ChangeLog* \
	FAQ \
	HOW-TO-CONTRIBUTE \
	INSTALL \
	KNOWNBUG \
	LEGAL \
	LICENSE \
	NEWS \
	NOTES \
	PROGLIST \
	README \
	THANKS \
	TODO \
"
export install_docs="`for i in ${install_docs}; do echo $i; done | sort -u`"
export test_rule=test
if [ -z "$SIG" ]; then
  export SIG=0	# set to 1 to turn on signing by default
fi

# helper function
# unpacks the original package source archive into ./${BASEPKG}/
# change this if the original package was not tarred
# or if it doesn't unpack to a correct directory
unpack() {
  tar xv${opt_decomp}f "$1"
}

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  unpack ${src_orig_pkg} && \
  cd ${topdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -Z -p0 < ${src_patch} ;\
  fi && \
  mkdirs &&
  cd ${srcdir} && \
  chmod +x gettext-tools/misc/gettextize.in && \
  chmod +x gettext-tools/misc/autopoint.in )
}
conf() {
  (cd ${objdir} && \
  export PATH=/usr/X11R6/bin:/usr/bin:/bin
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure \
  --srcdir=${srcdir} --prefix="${prefix}" \
  --exec-prefix='${prefix}' --sysconfdir="${sysconfdir}" \
  --libdir='${prefix}/lib' --includedir='${prefix}/include' \
  --mandir='${prefix}/share/man' --infodir='${prefix}/share/info' \
  --libexecdir='${sbindir}' --localstatedir="${localstatedir}" \
  --datadir='${prefix}/share' \
  --with-included-gettext --disable-rpath && \
  chmod +x gettext-tools/misc/gettextize && \
  chmod +x gettext-tools/misc/autopoint )
}
reconf() {
  (cd ${topdir} && \
  rm -fr ${objdir} && \
  mkdir -p ${objdir} && \
  conf )
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make aliaspath=${alias_path} )
}
check-rpath() {
  (cd ${objdir}/autoconf-lib-link && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-rpath 2>&1
)}
check-runtime() {
  (cd ${objdir}/gettext-runtime && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-runtime 2>&1
)}
check-tools() {
  (cd ${objdir}/gettext-tools && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} check | tee ${checkfile}-tools 2>&1
)}

check() {
  check-rpath
  check-runtime
  check-tools
}
clean() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  make aliaspath=${alias_path} clean )
}
install() {
  (cd ${objdir} && \
  rm -fr ${instdir}/* && \
  make install alias_path=${alias_path} DESTDIR=${instdir} && \
  (cd ${instdir}${prefix}/bin ; chmod +x *.dll ) && \
  for f in ${prefix}/share/info/dir ${prefix}/info/dir ; do \
    if [ -f ${instdir}${f} ] ; then \
      rm -f ${instdir}${f} ; \
    fi ;\
  done &&\
  for d in ${prefix}/share/doc/${BASEPKG} ${prefix}/share/doc/Cygwin ; do \
    if [ ! -d ${instdir}${d} ] ; then \
      mkdir -p ${instdir}${d} ;\
    fi ;\
  done &&\
  if [ -d ${instdir}${prefix}/share/info ] ; then \
    find ${instdir}${prefix}/share/info -name "*.info" | xargs gzip -q ; \
  fi && \
  if [ -d ${instdir}${prefix}/share/man ] ; then \
    find ${instdir}${prefix}/share/man -name "*.1" -o -name "*.3" -o \
      -name "*.3x" -o -name "*.3pm" -o -name "*.5" -o -name "*.6" -o \
      -name "*.7" -o -name "*.8" | xargs gzip -q ; \
  fi && \
  install_docs="`for i in ${install_docs}; do echo ${srcdir}/$i; done | sort -u`"
  templist="" && \
  for f in ${install_docs} ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${BASEPKG} ; \
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
         ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ] ; then \
    if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
      mkdir -p ${instdir}${sysconfdir}/postinstall ; \
    fi && \
    /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
      ${instdir}${sysconfdir}/postinstall/${PKG3}.sh ; \
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/preremove.sh ] ; then \
    if [ ! -d ${instdir}${sysconfdir}/preremove ]; then \
      mkdir -p ${instdir}${sysconfdir}/preremove ; \
    fi && \
    /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/preremove.sh \
      ${instdir}${sysconfdir}/preremove/${PKG3}.sh ; \
  fi )
}
strip() {
  # maybe: only strip cygintl.  The other dlls are fragile.
  #   find . -name "cygintl*.dll" | xargs strip > /dev/null 2>&1
  (cd ${instdir} && \
  find . -name "*.dll" -or -name "*.exe" | xargs strip 2>&1 ; \
  true )
}
list() {
  (cd ${instdir} && \
  find . -name "*" ! -type d | sed 's%^\.%  %' ; \
  true )
}
depend() {
  (cd ${instdir} && \
  find ${instdir} -name "*.exe" -o -name "*.dll" | xargs cygcheck | \
  sed -e '/\.exe/d' -e 's,\\,/,g' | sort -bu | xargs -n1 cygpath -u \
  | xargs cygcheck -f | sed 's%^%  %' ; \
  true )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} ${PKG1_LIST} 
  tar cvjf ${bin_pkg2} ${PKG2_LIST} 
  tar cvjf ${bin_pkg3} ${PKG3_LIST} 
  tar cvjf ${bin_pkg4} ${PKG4_LIST} 
)}
mkpatch() {
  (cd ${srcdir} && \
  find . -name "autom4te.cache" | xargs rm -rf ; \
  unpack ${src_orig_pkg} && \
  mv ${BASEPKG} ../${BASEPKG}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${BASEPKG}-orig ${BASEPKG} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${BASEPKG}-orig )
}
spkg() {
  (mkpatch && \
  if [ "${SIG}" -eq 1 ] ; then \
    name=${srcinstdir}/${src_patch_name} text="PATCH" sigfile ; \
  fi && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  if [ -e ${src_orig_pkg}.sig ] ; then \
    cp ${src_orig_pkg}.sig ${srcinstdir}/ ; \
  fi && \
  cp $0 ${srcinstdir}/`basename $0` && \
  name=$0 text="SCRIPT" sigfile && \
  if [ "${SIG}" -eq 1 ] ; then \
    cp $0.sig ${srcinstdir}/ ; \
  fi && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir}
}
sigfile() {
  if [ \( "${SIG}" -eq 1 \) -a \( -e $name \) -a \( \( ! -e $name.sig \) -o \( $name -nt $name.sig \) \) ]; then \
    if [ -x /usr/bin/gpg ]; then \
      echo "$text signature need to be updated"; \
      rm -f $name.sig; \
      /usr/bin/gpg --detach-sign $name; \
    else \
      echo "You need the gnupg package installed in order to make signatures."; \
    fi; \
  fi
}
checksig() {
  if [ -x /usr/bin/gpg ]; then \
    if [ -e ${src_orig_pkg}.sig ]; then \
      echo "ORIGINAL PACKAGE signature follows:"; \
      /usr/bin/gpg --verify ${src_orig_pkg}.sig ${src_orig_pkg}; \
    else \
      echo "ORIGINAL PACKAGE signature missing."; \
    fi; \
    if [ -e $0.sig ]; then \
      echo "SCRIPT signature follows:"; \
      /usr/bin/gpg --verify $0.sig $0; \
    else \
      echo "SCRIPT signature missing."; \
    fi; \
    if [ -e ${src_patch}.sig ]; then \
      echo "PATCH signature follows:"; \
      /usr/bin/gpg --verify ${src_patch}.sig ${src_patch}; \
    else \
      echo "PATCH signature missing."; \
    fi; \
  else
    echo "You need the gnupg package installed in order to check signatures." ; \
  fi
}
while test -n "$1" ; do
  case $1 in
    prep)		prep ; STATUS=$? ;;
    mkdirs)		mkdirs ; STATUS=$? ;;
    conf)		conf ; STATUS=$? ;;
    configure)		conf ; STATUS=$? ;;
    reconf)		reconf ; STATUS=$? ;;
    build)		build ; STATUS=$? ;;
    make)		build ; STATUS=$? ;;
    check)		check ; STATUS=$? ;;
    check-rpath)	check-rpath ; STATUS=$? ;;
    check-runtime)	check-runtime ; STATUS=$? ;;
    check-tools)	check-tools ; STATUS=$? ;;
    test)		check ; STATUS=$? ;;
    clean)		clean ; STATUS=$? ;;
    install)		install ; STATUS=$? ;;
    list)		list ; STATUS=$? ;;
    depend)		depend ; STATUS=$? ;;
    strip)		strip ; STATUS=$? ;;
    package)		pkg ; STATUS=$? ;;
    pkg)		pkg ; STATUS=$? ;;
    mkpatch)		mkpatch ; STATUS=$? ;;
    src-package)	spkg ; STATUS=$? ;;
    spkg)		spkg ; STATUS=$? ;;
    finish)		finish ; STATUS=$? ;;
    checksig)		checksig ; STATUS=$? ;;
    first)		mkdirs && spkg && finish ; STATUS=$? ;;
    all)		checksig && prep && conf && build && install && \
			strip && pkg && spkg && finish ; \
			STATUS=$? ;;
    *) echo "Error: bad arguments" ; exit 1 ;;
  esac
  ( exit ${STATUS} ) || exit ${STATUS}
  shift
done

