#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libpng2
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_pkg_name2=${FULLPKG2}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_pkg2=${topdir}/${src_pkg_name2}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs && \
  cd ${srcdir} && \
  for fn in *; do \
    if [ -f ${fn} ] ; then \
      cp ${fn} ${objdir} ;\
    fi;\
  done && \
  if [ ! -d ${objdir}/projects/msvc ] ; then\
    mkdir -p ${objdir}/projects/msvc ;\
  fi;\
  if [ -f ${srcdir}/projects/msvc/png32ms.def ] ; then\
    cp ${srcdir}/projects/msvc/png32ms.def ${objdir}/projects/msvc/png32ms.def ;\
  fi;\
  if [ -f ${srcdir}/scripts/makefile.cygwin ] ; then \
    cp ${srcdir}/scripts/makefile.cygwin ${objdir}/Makefile ;\
  fi ) 
}
conf() {
  echo Configuration successful.
}
build() {
  (cd ${objdir} && \
  make )
}
check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install prefix=${instdir}${prefix} 
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/ANNOUNCE ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
			  ${srcdir}/TODO ${srcdir}/Y2KINFO ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg2} usr/bin/*.dll ;\
  tar cvjf ${bin_pkg} --exclude='usr/bin/*.dll' * )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  cd ${srcdir}/CYGWIN-PATCHES && \
  cp -a libpng2-src ${FULLPKG2} && \
  tar cvjf ${src_pkg2} ${FULLPKG2} && \
  rm -rf ${FULLPKG2} )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
