#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

export PKG=libtool
export VER=1.5a
export REL=1
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e libtool-wrapper-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e libtool-wrapper-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=libtool-wrapper-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=libtool-wrapper-${VER}-${REL}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/libtool-wrapper-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/libtool-wrapper-${VER}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
stableprefix=/usr/autotool/stable
develprefix=/usr/autotool/devel
sysconfdir=${prefix}/etc
path_old=${PATH}

mkdirs() {
  (cd ${srcdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs && \
  export PATH=${path_old}
)}

conf() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  ${srcdir}/configure --build=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --with-devel-prefix=${develprefix} --with-stable-prefix=${stableprefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib && \
  export PATH=${path_old}
)}

build() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make CFLAGS=-O2 && \
  export PATH=${path_old}
)}

check() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 && \
  export PATH=${path_old}
)}

clean() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make clean && \
  export PATH=${path_old}
)}

install() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${objdir} && \
  make install INSTALL=install DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/libtool-wrapper.README \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/AUTHORS ${srcdir}/COPYING ${srcdir}/NEWS \
	 ${instdir}${prefix}/doc/${PKG}-${VER} && \
  export PATH=${path_old}
)}

mkpatch() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${srcdir} && \
  rm -rf autom4te.cache && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  mv libtool-wrapper-${VER} ../libtool-wrapper-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    libtool-wrapper-${VER}-orig libtool-wrapper-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf libtool-wrapper-${VER}-orig && \
  export PATH=${path_old}
)}

strip() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2<&1 
  find . -name "*.dll" | xargs strip >/dev/null 2<&1
  export PATH=${path_old}
)}

pkg() {
  (export PATH=${prefix}/bin:${path_old} && \
  cd ${instdir} && \
  tar cvjf ${bin_pkg} * && \
  export PATH=${path_old}
)}

spkg() {
  (export PATH=${prefix}/bin:${path_old} && \
  mkpatch && \
  (cd $objdir && make dist) && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  export PATH=${path_old}
)}

finish() {
  (export PATH=${prefix}/bin:${path_old} && \
  rm -rf ${srcdir}
  export PATH=${path_old}
)}

case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
export PATH=${path_old}
exit ${STATUS}
