--
--	PostgreSQL code for CHKPASS.
--  Written by D'Arcy J.M. Cain
--  darcy@druid.net
--  http://www.druid.net/darcy/
-- 
--  $PostgreSQL: pgsql-server/contrib/chkpass/chkpass.sql.in,v 1.5 2003/11/29 19:51:19 pgsql Exp $
--
--  best viewed with tabs set to 4
--

--
--	Input and output functions and the type itself:
--

-- Adjust this setting to control where the objects get created.
SET search_path = public;

CREATE FUNCTION chkpass_in(cstring)
	RETURNS chkpass
	AS '$libdir/chkpass'
	LANGUAGE 'c';

CREATE FUNCTION chkpass_out(chkpass)
	RETURNS cstring
	AS '$libdir/chkpass'
	LANGUAGE 'c';

CREATE TYPE chkpass (
	internallength = 16,
	externallength = 13,
	input = chkpass_in,
	output = chkpass_out
);

CREATE FUNCTION raw(chkpass)
	RETURNS text
	AS '$libdir/chkpass', 'chkpass_rout'
	LANGUAGE 'c';

--
--	The various boolean tests:
--

CREATE FUNCTION eq(chkpass, text)
	RETURNS bool
	AS '$libdir/chkpass', 'chkpass_eq'
	LANGUAGE 'c';

CREATE FUNCTION ne(chkpass, text)
	RETURNS bool
	AS '$libdir/chkpass', 'chkpass_ne'
	LANGUAGE 'c';

--
--	Now the operators.  Note how some of the parameters to some
--	of the 'create operator' commands are commented out.  This
--	is because they reference as yet undefined operators, and
--	will be implicitly defined when those are, further down.
--

CREATE OPERATOR = (
	leftarg = chkpass,
	rightarg = text,
	commutator = =,
--	negator = <>,
	procedure = eq
);

CREATE OPERATOR <> (
	leftarg = chkpass,
	rightarg = text,
	negator = =,
	procedure = ne
);

COMMENT ON TYPE chkpass IS 'password type with checks';

--
--	eof
--
