#! /bin/bash

# $Id: build.sh,v 1.14 2004/08/19 11:35:05 jt Exp $

# parse arguments
version=$1
port=$2

# constants
pkg=python

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix

DataDir=$InstallPrefix/share
ManDir=$DataDir/man
DocDir=$DataDir/doc/$pkg-$version
HtmlDocDir=$DocDir/html
PythonDocDir=$DocDir/Python-Docs-$version
CygDocDir=$DataDir/doc/Cygwin
PatchDir=CYGWIN-PATCHES
SrcDocDir=Misc

# configure
configure --prefix=$Prefix --mandir='${prefix}/share/man'

# make
make

# make install
make prefix=$InstallPrefix install

# make executables user writable to guarantee strip succeeds
find $InstallPrefix -name '*.exe' -o -name '*.dll' | xargs chmod u+w

# strip executables
find $InstallPrefix -name '*.exe' -o -name '*.dll' | xargs strip 

# copy README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy Python LICENSE, README, etc. files
mkdir -p $DocDir
TopFiles=(LICENSE README)
DocFiles=(ACKS cheatsheet HISTORY NEWS Porting)
cp ${TopFiles[*]} ${DocFiles[*]/#/$SrcDocDir/} $DocDir

# copy Python HTML documentation
tar -C $DocDir -xjf $PatchDir/html-$version.tar.bz2
mv $PythonDocDir $HtmlDocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
