#!/bin/sh

export work_dir=`pwd`
# make src tar
tar -cvjf uw-imap-2002d-2-src.tar.bz2 uw-imap-2002d-2.sh uw-imap-2002d-2
cd uw-imap-2002d-2

#clean up any previous stuff
/bin/rm /etc/mlock.exe /usr/bin/dmail.exe /usr/bin/mailutil.exe \
	/usr/bin/tmail.exe /usr/sbin/uw-imapd.exe /usr/sbin/uw-ipop2d.exe \
	/usr/sbin/uw-ipop3d.exe
/bin/rm -rf /usr/doc/uw-imap-2002d /usr/doc/Cygwin/uw-imap.README
/bin/rm -rf /etc/preremove/uw-imap-imapd.sh
/bin/rm -rf /etc/postinstall/uw-imap-imapd.sh
/bin/rm -rf /usr/include/c-client /usr/lib/libc-client.a

# build everything with plaintext passwords allowed and with ssl support
make cyg SSLTYPE=unix
# install everything
# executables
cp mlock/mlock.exe /etc/
cp dmail/dmail.exe mailutil/mailutil.exe tmail/tmail.exe /usr/bin/
mkdir /usr/sbin/
cp imapd/imapd.exe /usr/sbin/uw-imapd.exe
cp ipopd/ipop2d.exe /usr/sbin/uw-ipop2d.exe
cp ipopd/ipop3d.exe /usr/sbin/uw-ipop3d.exe
# man pages
mkdir /usr/man/man1/
cp src/dmail/dmail.1 src/mailutil/mailutil.1 src/tmail/tmail.1 /usr/man/man1/
mkdir /usr/man/man8c/
cp src/imapd/imapd.8c /usr/man/man8c/uw-imapd.8c
cp src/ipopd/ipopd.8c /usr/man/man8c/uw-ipopd.8c
# devel
mkdir /usr/include/c-client/
cd c-client
cp c-client.h osdep.h mail.h misc.h rfc822.h nntp.h smtp.h linkage.h \
	env_unix.h fs.h ftl.h nl.h tcp.h flockcyg.h env.h netmsg.h news.h \
	newsrc.h phile.h utf8.h imap4r1.h pop3.h mbox.h mbx.h mh.h mmdf.h mtx.h \
	mx.h tenex.h unix.h linkage.c /usr/include/c-client/
cd ..
cp c-client/c-client.a /usr/lib/libc-client.a
# strip binaries
strip /etc/mlock.exe
strip /usr/bin/dmail.exe
strip /usr/bin/mailutil.exe
strip /usr/bin/tmail.exe
strip /usr/sbin/uw-imapd.exe
strip /usr/sbin/uw-ipop2d.exe
strip /usr/sbin/uw-ipop3d.exe
# put cygwin-specific files in place
cp CYGWIN-PATCHES/uw-imap.README /usr/doc/Cygwin/
mkdir /usr/doc/uw-imap-2002d
cp CPYRIGHT README SUPPORT WARNING CYGWIN-PATCHES/README.cygwin.txt \
docs/RELNOTES docs/Y2K docs/SSLBUILD docs/internal.txt /usr/doc/uw-imap-2002d/
cp CYGWIN-PATCHES/uw-imap-imapd-preremove.sh \
/etc/preremove/uw-imap-imapd.sh
cp CYGWIN-PATCHES/uw-imap-imapd-postinstall.sh \
/etc/postinstall/uw-imap-imapd.sh
cd /
# make tar files
tar -cvhj --file=${work_dir}/uw-imap-2002d-2.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap.tar.incl
tar -cvhj --file=${work_dir}/uw-imap-util-2002d-2.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap-util.tar.incl
tar -cvhj --file=${work_dir}/uw-imap-imapd-2002d-2.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/uw-imap-imapd.tar.incl
tar -cvhj --file=${work_dir}/c-client-2002d-2.tar.bz2 \
	--files-from=${work_dir}/CYGWIN-PATCHES/c-client.tar.incl
cd ${work_dir}
