#!/bin/bash

# Set the path to programs
export PATH=/bin

# Check for differences between old config file and new one.
# Replace old config file with new one if no user differences made
# to the last version.
install_config_file () {
    d=$(dirname $1)
    i=$(basename $1)
    cd $d || return  ## exit 1
    
    # Any user changes since last time?
    changed=0
    if [ -r $i ]; then
        # If so, should ask user what to do, showing this diff ...
	if [ -r $i.cygwin-orig ]; then
	    diff -u $i $i.cygwin-orig ## > /tmp/$i.diff
	    changed=$?
	    ## rm -f /tmp/$i.diff
	# No original version to compare to eh?
	# Hmm.  Better install our own, saving current configuration first.
	elif [ ! -r $i.cygwin-save ]; then
	    cp -f $i $i.cygwin-save
	fi
    fi
    
    # No user changes to previous install, install it
    if [ $changed -eq 0 ]; then
	cp -f $i.cygwin-dist $i
    fi
    
    # Save distributed config file for next time
    cp -f $i.cygwin-dist $i.cygwin-orig
}

fontconfigcnf=/etc/fonts
for i in fonts.conf fonts.dtd local.conf; do
    install_config_file $fontconfigcnf/$i
done


# Create a link to /usr/bin/fontconfig-config
mkdir -p /usr/X11R6/bin
ln -sf /usr/bin/fontconfig-config /usr/X11R6/bin/fontconfig-config
