/*
    cd_ext.h

    Digi proprietary ioctls for setting extended baud rates and
    controlling other custom driver features for EtherLite and 
	SCSI Terminal Server modules.

    Copyright (c) 1992-98 Digi International.  All rights reserved.

    Redistribute freely but retain this copyright notice.  */

#if !defined(cd_ext_h)
# define    cd_ext_h

/* make sure we've got _IOR and _IOW defined */
#if defined(SOLARIS) || defined(SUNOS) || defined(IRIX)
# include <sys/ioccom.h>
#endif

/* define the ioctls */
#if defined(HPUX)
# define    STSSETEXTCTL	    _IOW('T', 119, stsextctl) 
# define    STSGETEXTCTL	    _IOR('T', 118, stsextctl)
#else
# if defined(SUNOS)
#  define   STSSETEXTCTL	    _IOW(T, 20, struct stsextctl)
#  define   STSGETEXTCTL	    _IOR(T, 21, struct stsextctl)
# else
#  define   STSSETEXTCTL	    _IOW('T', 20, struct stsextctl)
#  define   STSGETEXTCTL	    _IOR('T', 21, struct stsextctl)
# endif
#endif

/* structure for setting/getting delay values, extended options */
typedef
struct stsextctl {
    long    x_flags;		    /* various ctl flags */
    int     local_timeout;	    /* local close watchdog (secs) */
    int     nonloc_timeout;	    /* non-local close watchdog (secs) */
    int     dtr_delay;		    /* min DTR deassertion (ticks) */
    int     guard_delay;	    /* min inter-session (ticks) */
    int     local_waitout;	    /* local output wait watchdog (secs) */
    int     nonloc_waitout;	    /* non-local output wait watchdog (secs) */
    char    product_id[16];	    /* ASCII name */
    char    fw_version[5];	    /* firmware rev level */
    u_char  scsi_id;		    /* target ID on SCSI bus */
#if defined(HPUX)
    u_char  bus_id;		    /* bus ID */
#endif
    int     rsrvd[4];		    /* future reserved (zeroed) */
} stsextctl;

/* defs for 'x_flags' field above */
#define XC_ERRLEV   0x000f	    /* error level bits (leave and extra) */
#define XC_LOOP     0x0100	    /* flag for loopback */
#define XC_BAUDEXT  0x00f0	    /* mask for baudrate extension factor */
#define XC_BAUDSHIFT	 4	    /* shift value for baud extension */

#endif	    /* cd_ext_h */

