#!/bin/sh

PWD="`pwd`"
PACKAGE=antiword
VER=0.34
REL=2
SRCDIR=${PACKAGE}-${VER}

# Prepare
tar -xzf ${PACKAGE}-${VER}.tar.gz
cd "${SRCDIR}"
patch -p1<../${PACKAGE}-${VER}-${REL}.patch
ln -sf Makefile.Cygwin Makefile
cp ../*.ico CYGWIN-PATCHES/
mkdir "${PWD}/${PACKAGE}-${VER}/.inst"
DESTDIR="${PWD}/${PACKAGE}-${VER}/.inst"

mv --force CYGWIN-PATCHES/*.txt Resources/

# Build
make
make DESTDIR="${DESTDIR}" global_install

# Docs
mkdir -p "${DESTDIR}/usr/share/doc/${PACKAGE}-${VER}/"
/bin/install -c -m 644 \
	Docs/antiword.php \
	Docs/ChangeLog \
	Docs/COPYING \
	Docs/Emacs \
	Docs/Exmh \
	Docs/FAQ \
	Docs/History \
	Docs/Mozilla \
	Docs/Mutt \
	Docs/Netscape \
	Docs/QandA \
	Docs/ReadMe \
	Docs/testdoc.doc \
	"${DESTDIR}/usr/share/doc/${PACKAGE}-${VER}/"
mkdir -p "${DESTDIR}/usr/share/doc/Cygwin"
/bin/install -c -m 644 CYGWIN-PATCHES/README \
	"${DESTDIR}/usr/share/doc/Cygwin/${PACKAGE}-${VER}-${REL}.README"

# Package
(cd "${DESTDIR}"; tar cjvf "${PWD}/${PACKAGE}-${VER}-${REL}.tar.bz2" usr/ )

# Source package
cd ${PWD}
tar cjvf ${PACKAGE}-${VER}-${REL}-src.tar.bz2 ${PACKAGE}-${VER}-${REL}.patch ${PACKAGE}-${VER}-${REL}.sh ${PACKAGE}-${VER}.tar.gz *.ico

# Finish
#rm -rf ${PACKAGE}-${VER}/
