#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export src_patch_name2=${FULLPKG}.empty
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export src_patch2=${topdir}/${src_patch_name2}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
MY_CFLAGS="-O2 -g"
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

fixup() {
  thedir=$1
  (cd ${thedir}             && \
  patch -p1 < ${src_patch}  && \
  aclocal
  automake --copy
  autoheader
  autoconf
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  fixup ${srcdir}
  cd ${topdir} && \
  patch -p0 < ${src_patch2} 
  mkdirs
)}

conf() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --mandir=${prefix}/share/man --infodir=${prefix}/share/info \
  --libexecdir='${sbindir}' --localstatedir=/var \
  --datadir='${prefix}/share' \
  --with-gdbm --with-tmpdir=/tmp --without-krb4 --without-gssapi \
#  --with-cvs-admin-group=Administrators
)}

build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make
)}

check() {
  (cd ${objdir} && \
  make SHELL="/bin/bash" check | tee ${checkfile} 2>&1 ;
  echo "" >> ${checkfile} 
  echo "---- THE ACTUAL LOG ----" >> ${checkfile}
  echo "" >> ${checkfile}
  cat ${objdir}/src/check.log >> ${checkfile}
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} 
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/NEWS ${srcdir}/README ${srcdir}/FAQ \
           ${srcdir}/MINOR-BUGS ${srcdir}/COPYING ${srcdir}/COPYING.LIB \
           ${srcdir}/BUGS ${srcdir}/AUTHORS \
           ${srcdir}/HACKING ${srcdir}/PROJECTS ${srcdir}/TODO ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README ; \
  fi
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1
  true
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} *
)}

mkpatch() {
  (cd ${srcdir} && \
  rm -rf autom4te.cache ;\
  rm -f config.h.in~
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  temp=`(cd ../${PKG}-${VER}-orig ; pwd)` && \
  fixup $temp
  cd $temp && \
  rm -rf autom4te.cache && \
  rm -f config.h.in~
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name2} ; \
  rm -rf ${PKG}-${VER}-orig
  if test -s ${srcinstdir}/${src_patch_name2} ; then
    echo "${src_patch_name2} is non-empty, and it should be empty." >&2
    echo "Manual intervention required.  If ${src_patch_name2} contains" >&2
    echo "'good' changes, integrate them into ${src_patch_name}" >&2
    /bin/false
  fi
)}

spkg() {
  (mkpatch ;\
  cp ${src_patch} ${srcinstdir}/${src_patch_name} && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}

check-local-pass() {
  (cd ${objdir}/src 
   tests="version basica basicb basicc basic1 deep basic2"
   tests="${tests} files spacefiles commit-readonly"
   tests="${tests} commit-add-missing status"
   # Branching, tagging, removing, adding, multiple directories
   tests="${tests} rdiff rdiff2 diff death death2 rm-update-message rmadd"
   tests="${tests} rmadd2 dirs dirs2 branches branches2 tagc tagf"
   tests="${tests} rcslib multibranch import importb importc"
   tests="${tests} update-p import-after-initial branch-after-import"
   tests="${tests} join join2 join3 join-readonly-conflict"
   tests="${tests} join-admin join-admin-2"
   tests="${tests} new newb conflicts conflicts2 conflicts3"
   tests="${tests} clean"
   # Checking out various places (modules, checkout -d, &c)
   tests="${tests} modules2 modules3 modules4 modules5"
   tests="${tests} mkmodules-temp-file-removal"
   tests="${tests} cvsadm emptydir abspath toplevel toplevel2"
   tests="${tests} checkout_repository"
   # Log messages, error messages.
   tests="${tests} mflag editor errmsg2 adderrmsg opterrmsg"
   # Watches, binary files, history browsing, &c.
   tests="${tests} devcom devcom2 devcom3 watch4 watch5"
   tests="${tests} unedit-without-baserev"
   tests="${tests} ignore ignore-on-branch binfiles binfiles2"
   tests="${tests} mcopy binwrap binwrap2"
   tests="${tests} binwrap3 mwrap taginfo config"
   tests="${tests} serverpatch log log2 logopt ann ann-id"
   # Repository Storage (RCS file format, CVS lock files, creating
   # a repository without "cvs init", &c).
   tests="${tests} crerepos rcs rcs2 rcs3 lockfiles backuprecover"
   # More history browsing, &c.
   tests="${tests} history"
   tests="${tests} big modes modes2 modes3 stamps"
   # PreservePermissions stuff: permissions, symlinks et al.
   # tests="${tests} perms symlinks symlinks2 hardlinks"
   # More tag and branch tests, keywords.
   tests="${tests} sticky keyword keywordlog keywordname keyword2"
   tests="${tests} head tagdate multibranch2 tag8k"
   # "cvs admin", reserved checkouts.
   tests="${tests} admin reserved"
   # Nuts and bolts of diffing/merging (diff library, &c)
   tests="${tests} diffmerge1 diffmerge2"
   # Release of multiple directories
   tests="${tests} release"
   # Multiple root directories and low-level protocol tests.
   tests="${tests} multiroot multiroot2 multiroot3 multiroot4"
   tests="${tests} rmroot reposmv pserver server server2 client"
   tests="${tests} fork commit-d"
   /bin/bash ${srcdir}/src/sanity.sh ${objdir}/src/cvs ${tests} |\
     tee ${checkfile} 2>&1
   cp ${objdir}/src/check.log ${checkfile}.localpass
)}

check-remote-pass() {
  (cd ${objdir}/src 
   tests="version basica basicb basicc basic1 deep basic2"
   tests="${tests} files spacefiles commit-readonly"
   tests="${tests} commit-add-missing status"
   # Branching, tagging, removing, adding, multiple directories
   tests="${tests} rdiff rdiff2 diff death death2 rm-update-message rmadd"
   tests="${tests} rmadd2 dirs dirs2 branches branches2 tagc tagf"
   tests="${tests} rcslib multibranch import importb importc"
   tests="${tests} update-p import-after-initial branch-after-import"
   tests="${tests} join join2 join3"
   tests="${tests} join-readonly-conflict"
   tests="${tests} join-admin join-admin-2"
   tests="${tests} new newb conflicts conflicts2 conflicts3"
   tests="${tests} clean"
   # Checking out various places (modules, checkout -d, &c)
   tests="${tests} modules2 modules3 modules4 modules5"
   tests="${tests} mkmodules-temp-file-removal"
   tests="${tests} cvsadm emptydir abspath toplevel toplevel2"
   tests="${tests} checkout_repository"
   # Log messages, error messages.
   tests="${tests} mflag editor errmsg2 adderrmsg opterrmsg"
   # Watches, binary files, history browsing, &c.
   tests="${tests} devcom devcom2 watch4 watch5"
   tests="${tests} unedit-without-baserev"
   tests="${tests} ignore ignore-on-branch binfiles binfiles2"
   tests="${tests} mcopy binwrap binwrap2"
   tests="${tests} binwrap3 mwrap taginfo config"
   tests="${tests} serverpatch log log2 logopt ann ann-id"
   # Repository Storage (RCS file format, CVS lock files, creating
   # a repository without "cvs init", &c).
   tests="${tests} rcs rcs2 rcs3 lockfiles backuprecover"
   # More history browsing, &c.
   tests="${tests} history"
   tests="${tests} big modes modes2 modes3 stamps"
   # PreservePermissions stuff: permissions, symlinks et al.
   # tests="${tests} perms symlinks symlinks2 hardlinks"
   # More tag and branch tests, keywords.
   tests="${tests} sticky keyword keywordlog keywordname keyword2"
   tests="${tests} head tagdate multibranch2 tag8k"
   # "cvs admin", reserved checkouts.
   tests="${tests} admin reserved"
   # Nuts and bolts of diffing/merging (diff library, &c)
   tests="${tests} diffmerge1 diffmerge2"
   # Release of multiple directories
   tests="${tests} release"
   # Multiple root directories and low-level protocol tests.
   tests="${tests} multiroot multiroot2 multiroot3 multiroot4"
   tests="${tests} rmroot reposmv pserver server server2 client"
   tests="${tests} fork commit-d"
   /bin/bash ${srcdir}/src/sanity.sh -r ${objdir}/src/cvs ${tests} |\
     tee ${checkfile} 2>&1
   cp ${objdir}/src/check.log ${checkfile}.remotepass
)}

check-local-fail() {
  (cd ${objdir}/src 
   tests="         modules"
   tests="${tests} modules6"
   tests="${tests} binfiles3"
   tests="${tests} errmsg1"
   tests="${tests} info"
   rm -f ${checkfile}.localfail
   rm -f ${checkfile}
   for test in ${tests} ; do
     /bin/bash ${srcdir}/src/sanity.sh ${objdir}/src/cvs ${test} |\
       tee -a ${checkfile} 2>&1 ;
     echo "" >> ${checkfile}.localfail
     echo "---- ${test} ----" >> ${checkfile}.localfail
     echo "" >> ${checkfile}.localfail
     cat ${objdir}/src/check.log >> ${checkfile}.localfail
   done
)}

check-remote-fail() {
  (cd ${objdir}/src 
   tests="         modules"
   tests="${tests} modules6"
   tests="${tests} binfiles3"
   tests="${tests} errmsg1"
   tests="${tests} devcom3"
   tests="${tests} crerepos"
   tests="${tests} info"
   rm -f ${checkfile}.remotefail
   rm -f ${checkfile}
   for test in ${tests} ; do
     /bin/bash ${srcdir}/src/sanity.sh -r ${objdir}/src/cvs ${test} |\
       tee -a ${checkfile} 2>&1 ;
     echo "" >> ${checkfile}.remotefail
     echo "---- ${test} ----" >> ${checkfile}.remotefail
     echo "" >> ${checkfile}.remotefail
     cat ${objdir}/src/check.log >> ${checkfile}.remotefail
   done
)}


case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  check-local-pass)	check-local-pass ; STATUS=$? ;;
  check-remote-pass)	check-remote-pass ; STATUS=$? ;;
  check-local-fail)	check-local-fail ; STATUS=$? ;;
  check-remote-fail)	check-remote-fail ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
     STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
