/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassLoader {
    final Map loadedClasses;
    boolean defaultAssertionStatus;
    static final Map systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
    Map packageAssertionStatus;
    static final Map systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
    Map classAssertionStatus;
    private final ClassLoader parent;
    private HashMap definedPackages;
    static final Permission protectionDomainPermission = new RuntimePermission("getProtectionDomain");
    static ProtectionDomain unknownProtectionDomain;
    static ProtectionDomain defaultProtectionDomain;

    private /* synthetic */ void finit$() {
        this.loadedClasses = new HashMap();
        this.defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
        this.definedPackages = new HashMap();
    }

    public final ClassLoader getParent() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            // empty if block
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        return gnu.gcj.runtime.VMClassLoader.instance;
    }

    protected ClassLoader() {
        this(null);
    }

    protected ClassLoader(ClassLoader parent) {
        this.finit$();
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        this.parent = parent;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean link) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            try {
                ClassLoader cl = this.parent;
                if (this.parent == null) {
                    cl = gnu.gcj.runtime.VMClassLoader.instance;
                }
                if (cl != this) {
                    c = cl.loadClass(name, link);
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (link) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected final Class defineClass(byte[] data, int off, int len) throws ClassFormatError {
        return this.defineClass(null, data, off, len, defaultProtectionDomain);
    }

    protected final Class defineClass(String name, byte[] data, int off, int len) throws ClassFormatError {
        return this.defineClass(name, data, off, len, defaultProtectionDomain);
    }

    protected final synchronized Class defineClass(String name, byte[] data, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (data == null || data.length < off + len || off < 0 || len < 0) {
            throw new ClassFormatError("arguments to defineClass are meaningless");
        }
        if (name != null && this.findLoadedClass(name) != null) {
            throw new LinkageError("class " + name + " already loaded");
        }
        if (protectionDomain == null) {
            protectionDomain = defaultProtectionDomain;
        }
        try {
            Class retval = this.defineClass0(name, data, off, len, protectionDomain);
            this.loadedClasses.put(retval.getName(), retval);
            return retval;
        }
        catch (LinkageError x) {
            throw x;
        }
        catch (VirtualMachineError x) {
            throw x;
        }
        catch (Throwable x) {
            InternalError r = new InternalError("Unexpected exception while defining class " + name);
            r.initCause(x);
            throw r;
        }
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5) throws ClassFormatError;

    protected final void resolveClass(Class clazz) {
        ClassLoader.resolveClass0(clazz);
    }

    static void resolveClass0(Class clazz) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            try {
                try {
                    ClassLoader.linkClass0(clazz);
                }
                catch (Throwable x) {
                    LinkageError e;
                    ClassLoader.markClassErrorState0(clazz);
                    if (x instanceof LinkageError) {
                        e = (LinkageError)x;
                    } else if (x instanceof ClassNotFoundException) {
                        e = new NoClassDefFoundError("while resolving class: " + clazz.getName());
                        e.initCause(x);
                    } else {
                        e = new LinkageError("unexpected exception during linking: " + clazz.getName());
                        e.initCause(x);
                    }
                    throw e;
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    private static native void linkClass0(Class var0);

    private static native void markClassErrorState0(Class var0);

    protected Package definePackage(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        if (this.getPackage(name) != null) {
            throw new IllegalArgumentException("Package " + name + " already defined");
        }
        Package p = new Package(name, specTitle, specVendor, specVersion, implTitle, implVendor, implVersion, sealed);
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            Package package_;
            try {
                this.definedPackages.put(name, p);
            }
            finally {
                package_ = null;
            }
            package_ = p;
            return package_;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Package getPackage(String name) {
        Package p = this.parent == null ? null : this.parent.getPackage(name);
        if (p != null) return p;
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            try {
                p = (Package)this.definedPackages.get(name);
                return p;
            }
            finally {
                Package package_ = null;
            }
        }
    }

    protected Package[] getPackages() {
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            Object[] allPackages;
            Object[] objectArray;
            Object[] packages;
            try {
                packages = new Package[this.definedPackages.size()];
                this.definedPackages.values().toArray(packages);
            }
            finally {
                objectArray = null;
            }
            if (this.parent != null) {
                Package[] parentPackages = this.parent.getPackages();
                allPackages = new Package[parentPackages.length + packages.length];
                System.arraycopy(parentPackages, 0, allPackages, 0, parentPackages.length);
                System.arraycopy(packages, 0, allPackages, parentPackages.length, packages.length);
            } else {
                allPackages = packages;
            }
            objectArray = allPackages;
            return objectArray;
        }
    }

    protected String findLibrary(String name) {
        return null;
    }

    protected final Class findSystemClass(String name) throws ClassNotFoundException {
        return gnu.gcj.runtime.VMClassLoader.instance.loadClass(name);
    }

    protected final void setSigners(Class c, Object[] signers) {
    }

    protected final synchronized Class findLoadedClass(String name) {
        return (Class)this.loadedClasses.get(name);
    }

    public static InputStream getSystemResourceAsStream(String name) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(name);
    }

    public static URL getSystemResource(String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    public static Enumeration getSystemResources(String name) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            URL res = this.getResource(name);
            if (res == null) {
                return null;
            }
            return res.openStream();
        }
        catch (IOException x) {
            return null;
        }
    }

    public URL getResource(String name) {
        URL result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResource(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResource(name);
    }

    protected URL findResource(String name) {
        return null;
    }

    public final Enumeration getResources(String name) throws IOException {
        Enumeration result = null;
        ClassLoader delegate = this.parent;
        if (delegate == null) {
            delegate = ClassLoader.getSystemClassLoader();
        }
        if (this != delegate) {
            result = delegate.getResources(name);
        }
        if (result != null) {
            return result;
        }
        return this.findResources(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.defaultAssertionStatus = enabled;
    }

    public synchronized void setPackageAssertionStatus(String name, boolean enabled) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(name, enabled);
    }

    public synchronized void setClassAssertionStatus(String name, boolean enabled) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(name.toString(), enabled);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    static {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        unknownProtectionDomain = new ProtectionDomain(null, permissions);
        CodeSource cs = new CodeSource(null, null);
        defaultProtectionDomain = new ProtectionDomain(cs, Policy.getPolicy().getPermissions(cs));
    }
}

