#!/usr/bin/perl -w

%macro_to_d = ( VOID => 'void',
		INT => 'bint',
		INTPTR => 'bint*',
		LONG => 'blng',
		LONGLONG => 'long',
		UNSIGNED => 'buns',
		PTR => 'void*',
		FLOAT => 'float',
		DOUBLE => 'double',
		LONGDOUBLE => 'real',
		COMPLEXFLOAT => 'cfloat',
		COMPLEXDOUBLE => 'cdouble',
		COMPLEXLONGDOUBLE => 'creal',
		FLOATPTR => 'float*',
		DOUBLEPTR => 'double*',
		LONGDOUBLEPTR => 'real*',
		CONSTPTR => 'void*',
		STRING => 'char*',
		CONSTSTRING => 'char*',
		SIZE => 'size_t',
		PTRMODE => 'void*', # fix
		VALISTARG => 'va_list',
		VALISTREF => 'inout va_list',
		"VAR" => '...'
	      );

$noLongDouble = 0;
if ( $ARGV[0] eq "--no-long-double" ) {
    $noLongDouble = 1;
    shift @ARGV;
}

while (<>) {
    if ( m/^DEF_([_A-Z0-9]+)_BUILTIN\s*\(.*"(.*)",\s*BT_FN_(\S*),/ ) {
	next if ( index($3, "PTR_FN_VOID") != -1 );
	next if ( index($3, "INTMAX") != -1 );
	next if ( index($3, "SSIZE") != -1 );
	$ident = $2;
	next if ( index($ident, "nextwoar") != -1);
	$typespec = $3;
	$typespec =~ s/COMPLEX_([^_]+)/COMPLEX$1/g;
	$typespec =~ s/CONST_([^_]+)/CONST$1/g;
	$typespec =~ s/VALIST_([^_]+)/VALIST$1/g;
	@gosh = split(/_/, $typespec);
	@types = @macro_to_d{ @gosh };
	$uses_ver = 0;

	if ( $noLongDouble ) {
	    foreach $type (@types) {
		if ($type eq "real") {
		    $uses_ver = 1;
		    print "version(HaveLongDouble) {\n";
		    last;
		}
	    }
	}
	
	$ident = "__builtin_" . $ident;
	# print join(' * ', @gosh), "\n";
	print $types[0], ' ', $ident, '(', join(', ', @types[1..$#types]), ");\n";

	if ($uses_ver) {
	    print "} else {\n";
	    print "alias ", substr($ident,0,length($ident)-1), $ident, ";\n";
	    print "}\n";
	}
    }
}
