#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/time.h>
#include <assert.h>

#include "config.h"

#define sympfx ""

const char * D_type_for(unsigned size, int is_unsigned) {
    switch (size) {
    case 1: return is_unsigned ? "ubyte" : "byte";
    case 2: return is_unsigned ? "ushort" : "short";
    case 4: return is_unsigned ? "uint" : "int";
    case 8: return is_unsigned ? "ulong" : "long";
    default:
	assert(0);
	return NULL;
    }     
}

#define CONFIG_INT_TYPE(typename) \
{ \
     char zerobuf[sizeof(typename)]; \
     char neg1buf[sizeof(typename)]; \
     memset(neg1buf, 0x0, sizeof(typename)); \
     memset(neg1buf, 0xff, sizeof(typename)); \
     printf("alias %s %s;\n", \
	 D_type_for(sizeof(typename),*(typename *)neg1buf < *(typename *)zerobuf), \
	 "C"#typename); \
}

void errorExit(const char * msg)
{
    fprintf(stderr, "error: %s\n", msg);
    exit(1);
}

int main() {
    struct dirent de;
    unsigned offset;
    va_list a_valist;

    printf("// from <stdarg.h>\n");
    printf("const size_t va_list_size = %u;\n", sizeof(a_valist));
    printf("\n");
    
    offset = (char*) & de.d_name - (char*) & de;
    printf("\n");
    printf("// from <dirent.h>\n");
    printf("const size_t dirent_d_name_offset = %u;\n", offset);
    printf("const size_t dirent_d_name_size = %u;\n", sizeof(de.d_name));
    printf("const size_t dirent_remaining_size = %u;\n", sizeof(de) - (offset + sizeof(de.d_name)));
    printf("const size_t DIR_struct_size = %u;\n",
#if HAVE_SIZEOF_DIR
	sizeof(DIR)
#else
	0
#endif
	   );
    printf("\n");

    printf("// from <stdio.h>\n");
    printf("const size_t FILE_struct_size = %u;\n",
#if HAVE_SIZEOF_FILE
	sizeof(FILE)
#else
	0
#endif
	   );
#if HAVE_SNPRINTF
    //printf(""); // not sure if this is needed for can just use builtins
#endif
    
    printf("const int " sympfx"EOF = %d;\n", EOF);
    printf("const int " sympfx"FOPEN_MAX = %d;\n", FOPEN_MAX); // HAVE_FOPEN_MAX?
    printf("const int " sympfx"FILENAME_MAX = %d;\n", FILENAME_MAX); // "?
    printf("const int " sympfx"TMP_MAX = %d;\n", TMP_MAX); // "?
    printf("const int " sympfx"L_tmpnam = %d;\n", L_tmpnam);
    printf("\n");
    
    
    printf("// from <sys/types.h>\n");
    CONFIG_INT_TYPE(off_t);
    CONFIG_INT_TYPE(size_t);
    CONFIG_INT_TYPE(time_t);
    
    return 0;
}
