module gcc.configunix;
private import gcc.config;

alias gcc.config.Coff_t off_t;
extern(C) {

enum {
  O_RDONLY = 0,
  O_WRONLY = 1,
  O_RDWR = 2,
  O_NONBLOCK = 16384,
  O_CREAT = 512,
  O_EXCL = 2048,
  O_TRUNC = 1024,
  O_APPEND = 8,
}

alias int time_t;
struct timespec {
    int tv_sec;
    int tv_nsec;
}

static assert(timespec.tv_sec.offset == 0);
static assert(timespec.tv_nsec.offset == 4);


struct timeval {
    int tv_sec;
    int tv_usec;
}

static assert(timeval.tv_sec.offset == 0);
static assert(timeval.tv_usec.offset == 4);


struct tm {
    int tm_sec;
    int tm_min;
    int tm_hour;
    int tm_mday;
    int tm_mon;
    int tm_year;
    int tm_wday;
    int tm_yday;
    int tm_isdst;
}

static assert(tm.tm_sec.offset == 0);
static assert(tm.tm_min.offset == 4);
static assert(tm.tm_hour.offset == 8);
static assert(tm.tm_mday.offset == 12);
static assert(tm.tm_mon.offset == 16);
static assert(tm.tm_year.offset == 20);
static assert(tm.tm_wday.offset == 24);
static assert(tm.tm_yday.offset == 28);
static assert(tm.tm_isdst.offset == 32);


enum {
  S_IFIFO = 4096,
  S_IFCHR = 8192,
  S_IFDIR = 16384,
  S_IFBLK = 24576,
  S_IFREG = 32768,
  S_IFLNK = 40960,
  S_IFSOCK = 49152,
  S_IFMT = 61440,
  S_IRUSR = 256,
  S_IWUSR = 128,
  S_IXUSR = 64,
  S_IRGRP = 32,
  S_IWGRP = 16,
  S_IXGRP = 8,
  S_IROTH = 4,
  S_IWOTH = 2,
  S_IXOTH = 1,
  S_IRWXG = 56,
  S_IRWXO = 7,
}

struct struct_stat {
    uint st_dev;
   ubyte[4] ___pad1;
    ulong st_ino;
    uint st_mode;
    ushort st_nlink;
   ubyte[2] ___pad2;
    uint st_uid;
    uint st_gid;
    uint st_rdev;
   ubyte[4] ___pad3;
    long st_size;
    int st_atime;
   ubyte[4] ___pad4;
    int st_mtime;
   ubyte[4] ___pad5;
    int st_ctime;
   ubyte[4] ___pad6;
    int st_blksize;
   ubyte[4] ___pad7;
    long st_blocks;
}

static assert(struct_stat.st_dev.offset == 0);
static assert(struct_stat.st_ino.offset == 8);
static assert(struct_stat.st_mode.offset == 16);
static assert(struct_stat.st_nlink.offset == 20);
static assert(struct_stat.st_uid.offset == 24);
static assert(struct_stat.st_gid.offset == 28);
static assert(struct_stat.st_rdev.offset == 32);
static assert(struct_stat.st_size.offset == 40);
static assert(struct_stat.st_atime.offset == 48);
static assert(struct_stat.st_mtime.offset == 56);
static assert(struct_stat.st_ctime.offset == 64);
static assert(struct_stat.st_blksize.offset == 72);
static assert(struct_stat.st_blocks.offset == 80);


// from <sys/signal.h>
enum {
  SIGHUP = 1,
  SIGINT = 2,
  SIGQUIT = 3,
  SIGILL = 4,
  SIGABRT = 6,
  SIGIOT = 0,
  SIGBUS = 10,
  SIGFPE = 8,
  SIGKILL = 9,
  SIGUSR1 = 30,
  SIGUSR2 = 31,
  SIGPIPE = 13,
  SIGALRM = 14,
  SIGTERM = 15,
  SIGSTKFLT = 0,
  SIGCHLD = 20,
  SIGCONT = 19,
  SIGSTOP = 17,
  SIGTSTP = 18,
  SIGTTIN = 21,
  SIGTTOU = 22,
  SIGIO = 23,
  SIGPOLL = 23,
  SIGWINCH = 28,
  SIGURG = 16,
  SIGTRAP = 5,
}
enum {
  SA_NOCLDSTOP = 1,
  SA_NOCLDWAIT = 0,
  SA_SIGINFO = 2,
  SA_ONSTACK = 0,
  SA_RESTART = 268435456,
  SA_NODEFER = 1073741824,
  SA_RESETHAND = -2147483648,
}

struct sigset_t { ubyte[4] opaque; }
alias  void function(int) __sighandler_t;
const __sighandler_t SIG_DFL = cast(__sighandler_t) 0;
const __sighandler_t SIG_IGN = cast(__sighandler_t) 1;
const __sighandler_t SIG_ERR = cast(__sighandler_t) -1;

/* siginfo_t is not finished... see gen_unix.c */
struct siginfo_t {
    int si_signo;
    int si_code;
   ubyte[8] ___pad1;
    int si_errno;
}

static assert(siginfo_t.si_signo.offset == 0);
static assert(siginfo_t.si_code.offset == 4);
static assert(siginfo_t.si_errno.offset == 16);


struct sigaction_t {
    union {
        void function(int) sa_handler;
        void function(int, siginfo_t *, void *) sa_sigaction;
    }
    sigset_t sa_mask;
    int sa_flags;
}

static assert(sigaction_t.sa_flags.offset == 8);


// from <sys/mman.h>
extern(D) const void * MAP_FAILED = (void *) -1;
enum { PROT_NONE = 0, PROT_READ = 1, PROT_WRITE = 2, PROT_EXEC = 4 }
enum { MAP_PRIVATE = 0x2, MAP_ANON = 0x20 }

enum {
  EPERM = 1,
  ENOENT = 2,
  ESRCH = 3,
  EINTR = 4,
  ENXIO = 6,
  E2BIG = 7,
  ENOEXEC = 8,
  EBADF = 9,
  ECHILD = 10,
}

struct sem_t { ubyte[4] opaque; }
alias uint pthread_t;
}

extern (C)
{
    int open(char*, int, ...);
    int read(int, void*, size_t);
    int write(int, void*, size_t);
    int close(int);
    off_t lseek(int, off_t, int);
    int fstat(int, struct_stat*);
    int stat(char*, struct_stat*);
    int getErrno();
    int chdir(char*);
    int mkdir(char*, int);
    int rmdir(char*);
    char* getcwd(char*, int);

    int gettimeofday(timeval*, void*);
    time_t time(time_t*);
    tm *localtime(time_t*);

    // version( Unix_Posix_Sempahore ) ?
    int sem_init (sem_t *, int, uint);
    int sem_destroy (sem_t *);
    sem_t * sem_open (char *, int, ...);
    int sem_close(sem_t *);
    int sem_wait(sem_t*);
    int sem_post(sem_t*);
    // there are a few more..

    int sigfillset(sigset_t*);
    int sigdelset(sigset_t*, int);
    int sigaction(int, sigaction_t*, sigaction_t*);
    int sigsuspend(sigset_t*);
    
    // version ( Unix_Pthread )...
    int pthread_create(pthread_t*, void*, void* (*)(void*), void*);
    int pthread_join(pthread_t, void**);
    int pthread_kill(pthread_t, int);
    pthread_t pthread_self();
    int pthread_equal(pthread_t, pthread_t);

    // version ( Unix_Sched )
    void sched_yield();
}
