/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.ByteBufferImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

public final class LongBufferImpl
extends LongBuffer {
    private boolean readOnly;

    public LongBufferImpl(int cap, int off, int lim) {
        super(cap, lim, off, 0);
        this.backing_buffer = new long[cap];
        this.readOnly = false;
    }

    public LongBufferImpl(long[] array, int offset, int length) {
        super(array.length, length, offset, 0);
        this.backing_buffer = array;
        this.readOnly = false;
    }

    public LongBufferImpl(LongBufferImpl copy) {
        super(copy.capacity(), copy.limit(), copy.position(), 0);
        this.backing_buffer = copy.backing_buffer;
        this.readOnly = copy.isReadOnly();
    }

    private static native long[] nio_cast(byte[] var0);

    LongBufferImpl(byte[] copy) {
        super(copy.length, copy.length, 0, 0);
        this.backing_buffer = copy != null ? LongBufferImpl.nio_cast(copy) : null;
        this.readOnly = false;
    }

    private static native byte nio_get_Byte(LongBufferImpl var0, int var1, int var2);

    private static native void nio_put_Byte(LongBufferImpl var0, int var1, int var2, byte var3);

    public ByteBuffer asByteBuffer() {
        ByteBufferImpl res = new ByteBufferImpl(this.backing_buffer);
        res.limit(this.limit() * 1 / 8);
        return res;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public LongBuffer slice() {
        return new LongBufferImpl(this);
    }

    public LongBuffer duplicate() {
        return new LongBufferImpl(this);
    }

    public LongBuffer asReadOnlyBuffer() {
        LongBufferImpl result = new LongBufferImpl(this);
        result.readOnly = true;
        return result;
    }

    public LongBuffer compact() {
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final long get() {
        long e = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return e;
    }

    public final LongBuffer put(long b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = b;
        this.position(this.position() + 1);
        return this;
    }

    public final long get(int index) {
        return this.backing_buffer[index];
    }

    public final LongBuffer put(int index, long b) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = b;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

