#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export PKG2=libgdbm4
export PKG3=libgdbm-devel
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export src_patch_name2=${FULLPKG}.empty
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export src_patch2=${topdir}/${src_patch_name2}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CFLAGS="-O2"
MY_LDFLAGS=
MY_BINOWN=`id | sed -e 's/[()]/ /g' | awk '{print $2}'`
MY_BINGRP=`id | sed -e 's/[()]/ /g' | awk '{print $4}'`

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

fixup() {
  thedir=$1
  (cd ${thedir}             && \
  patch -p1 < ${src_patch}  && \
  rm -f ltconfig ltmain.sh config.guess config.sub
  rm -f install-sh mkinstalldirs missing depcomp
  cp /usr/autotool/devel/share/automake-1.7/install-sh .
  cp /usr/autotool/devel/share/automake-1.7/mkinstalldirs .
  libtoolize --copy --force
  aclocal
  autoheader
  autoconf
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  fixup ${srcdir}
  cd ${topdir} && \
  patch -p0 < ${src_patch2} \
  && mkdirs
  chmod +x ${srcdir}/CYGWIN-PATCHES/convert-gdbm
  chmod +x ${srcdir}/CYGWIN-PATCHES/gdbmtools-1.3.22.shar
)}

conf() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --mandir=${prefix}/share/man --infodir=${prefix}/share/info
)}

build() {
  (cd ${objdir} && \
  make CFLAGS="${CFLAGS}" LDFLAGS="${MY_LDFLAGS}" && \
  make progs CFLAGS="${CFLAGS}" LDFLAGS="${MY_LDFLAGS}" && \
  make info CFLAGS="${CFLAGS}" LDFLAGS="${MY_LDFLAGS}" && \
  ${srcdir}/CYGWIN-PATCHES/gdbmtools-1.3.22.shar && \
  bunzip2 dumpgdbm-1.3.22.exe.bz2 && \
  bunzip2 loadgdbm-1.3.22.exe.bz2
)}

check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install INSTALL_ROOT=${instdir} BINOWN=${MY_BINOWN} BINGRP=${MY_BINGRP} && \
  make install-compat INSTALL_ROOT=${instdir} BINOWN=${MY_BINOWN} BINGRP=${MY_BINGRP} && \
  make install-progs INSTALL_ROOT=${instdir} BINOWN=${MY_BINOWN} BINGRP=${MY_BINGRP} && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  for dirn in ${prefix}/share/doc/${PKG}-${VER} ${prefix}/share/doc/${PKG3}-${VER} \
    ${prefix}/share/doc/Cygwin ; do \
    if [ ! -d ${instdir}${dirn} ] ; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ;\
  done && \
  templist=""; \
  for f in ${srcdir}/COPYING ${srcdir}/README ${srcdir}/NEWS ; do\
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README && \
  /usr/bin/install -m 755 dumpgdbm-1.3.22.exe \
    ${instdir}${prefix}/bin/dumpgdbm-1.3.22.exe && \
  /usr/bin/install -m 755 loadgdbm-1.3.22.exe \
    ${instdir}${prefix}/bin/loadgdbm-1.3.22.exe && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/convert-gdbm \
    ${instdir}${prefix}/bin/convert-gdbm && \
  (cd ${instdir}${prefix}/bin ; \
    cp dumpgdbm.exe dumpgdbm-1.5.2.exe
    cp loadgdbm.exe loadgdbm-1.5.2.exe)
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1 && \
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
)}

mkpatch() {
  (cd ${srcdir} && \
  rm -rf autom4te.cache ;\
  rm -f autoconf.h.in~
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  temp=`(cd ../${PKG}-${VER}-orig ; pwd)` && \
  fixup $temp
  cd $temp && \
  rm -rf autom4te.cache ;\
  rm -f autoconf.h.in~
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig/ ${PKG}-${VER}/ > \
    ${srcinstdir}/${src_patch_name2} ; \
  rm -rf ${PKG}-${VER}-orig
  if test -s ${srcinstdir}/${src_patch_name2} ; then
    echo "${src_patch_name2} is non-empty, and it should be empty." >&2
    echo "Manual intervention required.  If ${src_patch_name2} contains" >&2
    echo "'good' changes, integrate them into ${src_patch_name}" >&2
    /bin/false
  fi
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/lib" \
    --exclude="${pnoslash}/share/doc/${PKG3}*" \
    --exclude="${pnoslash}/share/doc/Cygwin/${PKG3}*" \
    --exclude="${pnoslash}/share/info" \
    --exclude="${pnoslash}/share/man" \
    --exclude="${snoslash}" \
    * ;
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll ;
  tar cvjf ${bin_pkg3} ${pnoslash}/lib \
    ${pnoslash}/include \
    ${pnoslash}/share/doc/${PKG3}* \
    ${pnoslash}/share/doc/Cygwin/${PKG3}* \
    ${pnoslash}/share/info/* \
    ${pnoslash}/share/man/* 
)}

spkg() {
  (mkpatch ;\
  cp ${src_patch} ${srcinstdir}/${src_patch_name} && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)       mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
