#!/bin/sh
# Use this script to patch ncurses 5.3 to 5.3 (20030719)
# Run this script inside the ncurses 5.3 source directory et voila! Updated.

if ( egrep '^NCURSES_MAJOR = 5$' dist.mk >/dev/null 2>&1 \
  && egrep '^NCURSES_MINOR = 3$' dist.mk >/dev/null 2>&1 \
  && egrep '^NCURSES_PATCH = 20021012$' dist.mk >/dev/null 2>&1 )
then
        echo patching...
        rm -f Makefile.glibc
        rm -f README.glibc
        rm -f ncurses/base/lib_insstr.c
        rm -f ncurses/widechar/lib_ins_nwstr.c
        rm -rf sysdeps
else
        echo 'This does not look like ncurses 5.3'
        exit 1
fi

patch -p1 -i $0         # shell command = this script = inputfile for patch
exit

# ------------------------------------------------------------------------------
# ANNOUNCE                                              |   66 
# Ada95/gen/Makefile.in                                 |    9 
# Ada95/src/Makefile.in                                 |    8 
# INSTALL                                               |   88 
# MANIFEST                                              |   27 
# NEWS                                                  |  470 ++
# README                                                |   10 
# aclocal.m4                                            |  457 ++
# announce.html.in                                      |   45 
# c++/Makefile.in                                       |   20 
# c++/cursesmain.cc                                     |   14 
# config.guess                                          |  272 -
# config.sub                                            |   92 
# configure                                             | 2826 +++++++++------
# configure.in                                          |  252 -
# dist.mk                                               |   12 
# doc/html/announce.html                                |   45 
# doc/html/man/captoinfo.1m.html                        |    6 
# doc/html/man/curs_addch.3x.html                       |    8 
# doc/html/man/curs_beep.3x.html                        |    4 
# doc/html/man/curs_deleteln.3x.html                    |    6 
# doc/html/man/curs_extend.3x.html                      |    8 
# doc/html/man/curs_get_wch.3x.html                     |   12 
# doc/html/man/curs_getcchar.3x.html                    |    4 
# doc/html/man/curs_getch.3x.html                       |  198 -
# doc/html/man/curs_getstr.3x.html                      |    6 
# doc/html/man/curs_getyx.3x.html                       |    6 
# doc/html/man/curs_initscr.3x.html                     |    4 
# doc/html/man/curs_inopts.3x.html                      |    8 
# doc/html/man/curs_insch.3x.html                       |    6 
# doc/html/man/curs_mouse.3x.html                       |   40 
# doc/html/man/curs_outopts.3x.html                     |    6 
# doc/html/man/curs_pad.3x.html                         |    8 
# doc/html/man/curs_print.3x.html                       |    4 
# doc/html/man/curs_printw.3x.html                      |   50 
# doc/html/man/curs_scroll.3x.html                      |    4 
# doc/html/man/curs_slk.3x.html                         |    6 
# doc/html/man/curs_termcap.3x.html                     |   80 
# doc/html/man/curs_terminfo.3x.html                    |    4 
# doc/html/man/curs_util.3x.html                        |   28 
# doc/html/man/curs_window.3x.html                      |    4 
# doc/html/man/define_key.3x.html                       |    6 
# doc/html/man/form_field.3x.html                       |    6 
# doc/html/man/form_field_buffer.3x.html                |    4 
# doc/html/man/form_field_just.3x.html                  |    6 
# doc/html/man/form_field_new.3x.html                   |    8 
# doc/html/man/form_field_opts.3x.html                  |    8 
# doc/html/man/form_field_validation.3x.html            |   87 
# doc/html/man/form_fieldtype.3x.html                   |   44 
# doc/html/man/infocmp.1m.html                          |   14 
# doc/html/man/infotocap.1m.html                        |    4 
# doc/html/man/keybound.3x.html                         |   16 
# doc/html/man/menu_driver.3x.html                      |    4 
# doc/html/man/menu_pattern.3x.html                     |    4 
# doc/html/man/ncurses.3x.html                          |   30 
# doc/html/man/panel.3x.html                            |    6 
# doc/html/man/term.5.html                              |    4 
# doc/html/man/term.7.html                              |   28 
# doc/html/man/terminfo.5.html                          |  410 +-
# doc/html/man/tic.1m.html                              |   10 
# doc/html/man/toe.1m.html                              |    6 
# doc/html/man/tput.1.html                              |    4 
# doc/html/man/tset.1.html                              |   78 
# form/Makefile.in                                      |    6 
# form/form.h                                           |    6 
# form/frm_driver.c                                     |   43 
# include/MKkey_defs.sh                                 |    8 
# include/curses.h.in                                   |  131 
# include/curses.tail                                   |    6 
# include/curses.wide                                   |   70 
# include/ncurses_defs                                  |   11 
# include/ncurses_dll.h                                 |   14 
# include/tic.h                                         |   12 
# man/MKterminfo.sh                                     |   10 
# man/captoinfo.1m                                      |   20 
# man/curs_addch.3x                                     |    8 
# man/curs_beep.3x                                      |    6 
# man/curs_deleteln.3x                                  |    6 
# man/curs_extend.3x                                    |   10 
# man/curs_get_wch.3x                                   |   14 
# man/curs_get_wstr.3x                                  |    7 
# man/curs_getcchar.3x                                  |    6 
# man/curs_getch.3x                                     |   10 
# man/curs_getstr.3x                                    |    6 
# man/curs_getyx.3x                                     |   14 
# man/curs_initscr.3x                                   |    6 
# man/curs_inopts.3x                                    |   10 
# man/curs_insch.3x                                     |    6 
# man/curs_mouse.3x                                     |   18 
# man/curs_outopts.3x                                   |    8 
# man/curs_pad.3x                                       |   10 
# man/curs_print.3x                                     |    6 
# man/curs_printw.3x                                    |   14 
# man/curs_scroll.3x                                    |    8 
# man/curs_slk.3x                                       |   14 
# man/curs_termcap.3x                                   |   10 
# man/curs_terminfo.3x                                  |    8 
# man/curs_util.3x                                      |   12 
# man/curs_window.3x                                    |    6 
# man/define_key.3x                                     |    6 
# man/form_field.3x                                     |    6 
# man/form_field_buffer.3x                              |    6 
# man/form_field_just.3x                                |    6 
# man/form_field_new.3x                                 |    6 
# man/form_field_opts.3x                                |    8 
# man/form_field_validation.3x                          |   47 
# man/form_fieldtype.3x                                 |   33 
# man/infocmp.1m                                        |  136 
# man/infotocap.1m                                      |   18 
# man/keybound.3x                                       |   11 
# man/make_sed.sh                                       |    6 
# man/man_db.renames                                    |    3 
# man/manlinks.sed                                      |   40 
# man/menu_driver.3x                                    |    8 
# man/menu_pattern.3x                                   |    6 
# man/ncurses.3x                                        |   16 
# man/panel.3x                                          |    6 
# man/term.5                                            |   20 
# man/term.7                                            |   22 
# man/terminfo.tail                                     |  128 
# man/tic.1m                                            |  104 
# man/toe.1m                                            |   18 
# man/tput.1                                            |   50 
# man/tset.1                                            |   81 
# menu/Makefile.in                                      |    9 
# misc/emx.src                                          |   67 
# misc/run_tic.in                                       |   22 
# misc/shlib                                            |    9 
# misc/terminfo.src                                     |  734 ++--
# mk-1st.awk                                            |   42 
# ncurses-5.3-20030719/doc/html/man/key_defined.3x.html |  119 
# ncurses-5.3-20030719/man/key_defined.3x               |   60 
# ncurses-5.3-20030719/misc/csort                       |   36 
# ncurses-5.3-20030719/ncurses/base/key_defined.c       |   76 
# ncurses-5.3-20030719/ncurses/widechar/charable.c      |   77 
# ncurses-5.3-20030719/ncurses/widechar/lib_slk_wset.c  |  146 
# ncurses-5.3-20030719/test/aclocal.m4                  |  812 ++++
# ncurses-5.3-20030719/test/demo_defkey.c               |  250 +
# ncurses-5.3-20030719/test/demo_forms.c                |  295 +
# ncurses-5.3-20030719/test/demo_keyok.c                |   55 
# ncurses-5.3-20030719/test/demo_menus.c                |   73 
# ncurses-5.3-20030719/test/demo_panels.c               |   33 
# ncurses-5.3-20030719/test/edit_field.c                |  402 ++
# ncurses-5.3-20030719/test/edit_field.h                |   17 
# ncurses-5.3-20030719/test/ins_wide.c                  |  218 +
# ncurses-5.3-20030719/test/inserts.c                   |  162 
# ncurses-5.3-20030719/test/listused.sh                 |  155 
# ncurses/Makefile.in                                   |   20 
# ncurses/base/MKlib_gen.sh                             |   27 
# ncurses/base/define_key.c                             |   15 
# ncurses/base/keybound.c                               |    7 
# ncurses/base/lib_addch.c                              |  129 
# ncurses/base/lib_addstr.c                             |   75 
# ncurses/base/lib_bkgd.c                               |    4 
# ncurses/base/lib_freeall.c                            |   11 
# ncurses/base/lib_getch.c                              |   82 
# ncurses/base/lib_insch.c                              |   99 
# ncurses/base/lib_mouse.c                              |  521 ++
# ncurses/base/lib_newterm.c                            |    9 
# ncurses/base/lib_printw.c                             |   17 
# ncurses/base/lib_set_term.c                           |   17 
# ncurses/base/lib_slk.c                                |   78 
# ncurses/base/lib_slklab.c                             |    6 
# ncurses/base/lib_slkrefr.c                            |    6 
# ncurses/base/lib_slkset.c                             |   30 
# ncurses/base/resizeterm.c                             |   35 
# ncurses/base/safe_sprintf.c                           |   62 
# ncurses/base/tries.c                                  |   23 
# ncurses/base/vsscanf.c                                |    4 
# ncurses/curses.priv.h                                 |  141 
# ncurses/llib-lncurses                                 |  119 
# ncurses/llib-lncursesw                                |  150 
# ncurses/modules                                       |   11 
# ncurses/tinfo/MKkeys_list.sh                          |    6 
# ncurses/tinfo/access.c                                |   31 
# ncurses/tinfo/alloc_entry.c                           |   22 
# ncurses/tinfo/alloc_ttype.c                           |   18 
# ncurses/tinfo/comp_parse.c                            |    9 
# ncurses/tinfo/comp_scan.c                             |   91 
# ncurses/tinfo/free_ttype.c                            |   10 
# ncurses/tinfo/lib_acs.c                               |  147 
# ncurses/tinfo/lib_cur_term.c                          |    9 
# ncurses/tinfo/lib_kernel.c                            |    4 
# ncurses/tinfo/lib_setup.c                             |  251 -
# ncurses/tinfo/lib_termcap.c                           |   10 
# ncurses/tinfo/lib_ti.c                                |   10 
# ncurses/tinfo/lib_tparm.c                             |  391 +-
# ncurses/tinfo/lib_tputs.c                             |    8 
# ncurses/tinfo/lib_ttyflags.c                          |   13 
# ncurses/tinfo/parse_entry.c                           |   25 
# ncurses/tinfo/read_entry.c                            |   59 
# ncurses/tinfo/read_termcap.c                          |   13 
# ncurses/trace/lib_traceatr.c                          |   77 
# ncurses/trace/lib_tracechr.c                          |   35 
# ncurses/trace/trace_buf.c                             |   37 
# ncurses/trace/varargs.c                               |    6 
# ncurses/trace/visbuf.c                                |   55 
# ncurses/tty/lib_mvcur.c                               |  145 
# ncurses/tty/lib_twait.c                               |    4 
# ncurses/tty/tty_update.c                              |  152 
# ncurses/widechar/lib_cchar.c                          |   28 
# ncurses/widechar/lib_get_wstr.c                       |   35 
# ncurses/widechar/lib_ins_wch.c                        |   83 
# ncurses/widechar/lib_unget_wch.c                      |   28 
# ncurses/widechar/lib_wacs.c                           |   15 
# ncurses/widechar/lib_wunctrl.c                        |    8 
# panel/Makefile.in                                     |   11 
# progs/MKtermsort.sh                                   |    6 
# progs/Makefile.in                                     |   19 
# progs/dump_entry.c                                    |   26 
# progs/infocmp.c                                       |   18 
# progs/tic.c                                           |  227 +
# progs/tput.c                                          |   30 
# progs/tset.c                                          |   41 
# tack/Makefile.in                                      |   12 
# tar-copy.sh                                           |   30 
# test/Makefile.in                                      |   54 
# test/README                                           |  601 +++
# test/bs.c                                             |    4 
# test/cardfile.c                                       |   39 
# test/configure                                        | 2860 +++++++++++++---
# test/configure.in                                     |  246 -
# test/gdc.6                                            |    3 
# test/hashtest.c                                       |    4 
# test/keynames.c                                       |    4 
# test/knight.c                                         |    4 
# test/modules                                          |   20 
# test/ncurses.c                                        |  665 +++
# test/railroad.c                                       |    4 
# test/tclock.c                                         |   14 
# test/test.priv.h                                      |   88 
# test/testcurs.c                                       |    3 
# test/testscanw.c                                      |    3 
# test/view.c                                           |   10 
# 234 files changed, 14489 insertions(+), 5320 deletions(-)
# ------------------------------------------------------------------------------
Index: ANNOUNCE
--- ncurses-5.3-20021012/ANNOUNCE	Sat Oct 12 19:36:19 2002
+++ ncurses-5.3-20030719/ANNOUNCE	Sat Oct 19 17:47:00 2002
@@ -23,8 +23,8 @@
    manual pages are provided for the library and tools.
 
    The  ncurses  distribution  is  available via anonymous FTP at the GNU
-   distribution site [1]ftp://ftp.gnu.org/pub/gnu/ncurses.
-   It is also available at [2]ftp://invisible-island.net/ncurses.
+   distribution site [1]ftp://ftp.gnu.org/gnu/ncurses/ .
+   It is also available at [2]ftp://invisible-island.net/ncurses/ .
 
                                  Release Notes
 
@@ -268,60 +268,60 @@
 
    cdk
           Curses Development Kit
-          [3]http://invisible-island.net/cdk.
-          [4]http://www.vexus.ca/CDK.html
+          [3]http://invisible-island.net/cdk/
+          [4]http://www.vexus.ca/products/CDK/
 
    ded
           directory-editor
-          [5]http://invisible-island.net/ded.
+          [5]http://invisible-island.net/ded/
 
    dialog
           the  underlying  application used in Slackware's setup, and the
           basis for similar applications on GNU/Linux.
-          [6]http://invisible-island.net/dialog.
+          [6]http://invisible-island.net/dialog/
 
    lynx
           the character-screen WWW browser
-          [7]http://lynx.isc.org/release.
+          [7]http://lynx.isc.org/release/
 
    Midnight Commander
           file manager
-          [8]www.gnome.org/mc/.
+          [8]http://www.ibiblio.org/mc/
 
    mutt
           mail utility
-          [9]http://www.mutt.org.
+          [9]http://www.mutt.org/
 
    ncftp
           file-transfer utility
-          [10]http://www.ncftp.com.
+          [10]http://www.ncftp.com/
 
    nvi
           New vi versions 1.50 are able to use ncurses versions 1.9.7 and
           later.
-          [11]http://www.bostic.com/vi/.
+          [11]http://www.bostic.com/vi/
 
    tin
           newsreader, supporting color, MIME
-          [12]http://www.tin.org.
+          [12]http://www.tin.org/
 
    taper
           tape archive utility
-          [13]http://members.iinet.net.au/~yusuf/taper/.
+          [13]http://taper.e-survey.net.au/
 
    vh-1.6
           Volks-Hypertext browser for the Jargon File
-          [14]http://www.bg.debian.org/Packages/unstable/text/vh.html.
+          [14]http://www.debian.org/Packages/unstable/text/vh.html
 
    as well as some that use ncurses for the terminfo support alone:
 
    minicom
           terminal emulator
-          [15]http://www.pp.clinet.fi/~walker/minicom.html.
+          [15]http://www.netsonic.fi/~walker/minicom.html
 
    vile
           vi-like-emacs
-          [16]http://invisible-island.net/vile.
+          [16]http://invisible-island.net/vile/
 
    The  ncurses  distribution  includes  a  selection  of  test  programs
    (including a few games).
@@ -342,7 +342,7 @@
    and testing of this package.
 
    Beta  versions  of ncurses and patches to the current release are made
-   available at [23]ftp://invisible-island.net/ncurses.
+   available at [23]ftp://invisible-island.net/ncurses/ .
 
 Future Plans
 
@@ -357,35 +357,35 @@
 
    The  distribution  includes  and uses a version of the terminfo-format
    terminal    description    file    maintained    by    Eric   Raymond.
-   [24]http://earthspace.net/~esr/terminfo.
+   [24]http://www.tuxedo.org/~esr/terminfo/ .
 
    You  can  find  lots  of  information  on  terminal-related topics not
-   covered in the terminfo file at [25]Richard Shuford's archive.
+   covered in the terminfo file at [25]Richard Shuford's archive .
 
 References
 
-   1. ftp://ftp.gnu.org/pub/gnu/ncurses
-   2. ftp://invisible-island.net/ncurses
-   3. http://invisible-island.net/cdk/cdk.html
-   4. http://www.vexus.ca/CDK.html
-   5. http://invisible-island.net/ded/ded.html
-   6. http://invisible-island.net/dialog/dialog.html
+   1. ftp://ftp.gnu.org/gnu/ncurses/
+   2. ftp://invisible-island.net/ncurses/
+   3. http://invisible-island.net/cdk/
+   4. http://www.vexus.ca/products/CDK/
+   5. http://invisible-island.net/ded/
+   6. http://invisible-island.net/dialog/
    7. http://lynx.isc.org/release/
-   8. file://localhost/usr/build/ncurses/ncurses-5.2-20021012/doc/html/www.gnome.org/mc/
+   8. http://www.ibiblio.org/mc/
    9. http://www.mutt.org/
   10. http://www.ncftp.com/
   11. http://www.bostic.com/vi/
   12. http://www.tin.org/
-  13. http://members.iinet.net.au/~yusuf/taper/
-  14. http://www.bg.debian.org/Packages/unstable/text/vh.html
-  15. http://www.pp.clinet.fi/~walker/minicom.html
-  16. http://invisible-island.net/vile/vile.html
+  13. http://taper.e-survey.net.au/
+  14. http://www.debian.org/Packages/unstable/text/vh.html
+  15. http://www.netsonic.fi/~walker/minicom.html
+  16. http://invisible-island.net/vile/
   17. mailto:zmbenhal@netcom.com
-  18. http://www.ccil.org/~esr/home.html
+  18. http://www.tuxedo.org/~esr/
   19. mailto:dickey@herndon4.his.com
   20. http://www.familiepfeifer.de/Contact.aspx?Lang=en
   21. mailto:dickey@herndon4.his.com
   22. mailto:bug-ncurses@gnu.org
-  23. ftp://invisible-island.net/ncurses
-  24. http://earthspace.net/~esr/terminfo
+  23. ftp://invisible-island.net/ncurses/
+  24. http://www.tuxedo.org/~esr/terminfo/
   25. http://www.cs.utk.edu/~shuford/terminal_index.html
Index: Ada95/gen/Makefile.in
--- ncurses-5.3-20021012/Ada95/gen/Makefile.in	Sat Jul 13 08:02:28 2002
+++ ncurses-5.3-20030719/Ada95/gen/Makefile.in	Sat May 10 20:22:04 2003
@@ -1,5 +1,5 @@
 ##############################################################################
-# Copyright (c) 1998 Free Software Foundation, Inc.                          #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -30,7 +30,7 @@
 #  Contact: http://www.familiepfeifer.de/Contact.aspx?Lang=en
 #
 #  Version Control
-#  $Revision: 1.41 $
+#  $Revision: 1.43 $
 #
 .SUFFIXES:
 
@@ -53,6 +53,7 @@
 AWK		= @AWK@
 LN_S		= @LN_S@
 
+CC		= @CC@
 HOST_CC		= @BUILD_CC@
 CFLAGS		= @CFLAGS@
 
@@ -171,9 +172,9 @@
 install \
 install.libs :: $(ADA_OBJECTS)
 	@echo installing package $(ALIB) in $(ADA_OBJECTS)
-	@chmod a-wx $(ADA_SRCDIR)/*.ali
+	@-chmod a-wx $(ADA_SRCDIR)/*.ali
 	@$(top_srcdir)/tar-copy.sh '$(ALIB)[-.]*.ali' $(ADA_SRCDIR) $(ADA_OBJECTS)
-	@chmod u+x $(ADA_SRCDIR)/*.ali
+	@-chmod u+x $(ADA_SRCDIR)/*.ali
 
 uninstall \
 uninstall.libs ::
Index: Ada95/src/Makefile.in
--- ncurses-5.3-20021012/Ada95/src/Makefile.in	Sat Jul 13 08:02:23 2002
+++ ncurses-5.3-20030719/Ada95/src/Makefile.in	Sat May 10 19:42:43 2003
@@ -30,7 +30,7 @@
 #  Contact: http://www.familiepfeifer.de/Contact.aspx?Lang=en
 #
 #  Version Control
-#  $Revision: 1.26 $
+#  $Revision: 1.27 $
 #
 .SUFFIXES:
 
@@ -214,19 +214,19 @@
 
 
 $(ABASE)-terminfo.o: \
-		$(ABASE)-terminfo.ads \
+		$(srcdir)/$(ABASE)-terminfo.ads \
 		$(srcdir)/$(ABASE)-terminfo.adb $(BASEDEPS)
 	$(ADA) $(ADAFLAGS) -c -o $@ $(srcdir)/$(ABASE)-terminfo.adb
 
 
 $(ABASE)-termcap.o: \
-		$(ABASE)-termcap.ads \
+		$(srcdir)/$(ABASE)-termcap.ads \
 		$(srcdir)/$(ABASE)-termcap.adb $(BASEDEPS)
 	$(ADA) $(ADAFLAGS) -c -o $@ $(srcdir)/$(ABASE)-termcap.adb
 
 
 $(ABASE)-putwin.o: \
-		$(ABASE)-putwin.ads \
+		$(srcdir)/$(ABASE)-putwin.ads \
 		$(srcdir)/$(ABASE)-putwin.adb $(BASEDEPS)
 	$(ADA) $(ADAFLAGS) -c -o $@ $(srcdir)/$(ABASE)-putwin.adb
 
Index: INSTALL
Prereq:  1.56 
--- ncurses-5.3-20021012/INSTALL	Sun Sep  1 18:42:11 2002
+++ ncurses-5.3-20030719/INSTALL	Sat Jul 19 17:42:11 2003
@@ -1,4 +1,4 @@
--- $Id: INSTALL,v 1.56 2002/09/01 22:42:11 tom Exp $
+-- $Id: INSTALL,v 1.63 2003/07/19 21:42:11 tom Exp $
 ---------------------------------------------------------------------
              How to install Ncurses/Terminfo on your system
 ---------------------------------------------------------------------
@@ -168,6 +168,11 @@
     databases are SVr4-compatible, but most seem to be.  Exceptions include
     DEC's Digital Unix (formerly known as OSF/1).
 
+    If you run the test programs WITHOUT installing terminfo, ncurses may
+    read the termcap file and cache that in $HOME/.terminfo, which will
+    thereafter be used instead of the terminfo database.  See the comments
+    on "--enable-getcap-cache", to see why this is a Bad Thing.
+
     It is possible to configure ncurses to use other terminfo database formats.
     A few are provided as examples in the include-directory (see --with-caps).
 
@@ -312,10 +317,6 @@
 	Compile without scroll-hints code.  This option is ignored when
 	hashmap scrolling is configured, which is the default.
 
-    --enable-add-ons=DIR...
-	This is used to check if this package is a glibc add-on.  This is used
-	only by the glibc makefiles.
-
     --enable-assertions
 	For testing, compile-in assertion code.  This is used only for a few
 	places where ncurses cannot easily recover by returning an error code.
@@ -454,6 +455,11 @@
     --enable-xmc-glitch
 	Compile-in support experimental xmc (magic cookie) code.
 
+    --with-abi-version=NUM
+	Override the ABI version, which is used in shared library filenames.
+	Normally this is the same as the release version; some ports have
+	special requirements for compatibility.
+
     --with-ada-compiler=CMD
 	Specify the Ada95 compiler command (default "gnatmake")
 
@@ -545,8 +551,12 @@
 	option probably will not work for those configurations.
 
      --with-libtool
-	Generate libraries with libtool.  If this option is selected, then
-	it overrides all other library model specifications.
+	Generate libraries with libtool.  If this option is selected, then it
+	overrides all other library model specifications.  Note that libtool
+	must already be installed, uses makefile rules dependent on GNU make,
+	and does not promise to follow the version numbering convention of
+	other shared libraries on your system.  However, if the --with-shared
+	option does not succeed, you may get better results with this option.
 
     --with-manpage-format=XXX
 	Tell the configure script how you would like to install man-pages.  The
@@ -609,6 +619,9 @@
 	This is normally chosen automatically based on the type of system
 	which you are building on.  We use it for testing the configure script.
 
+    --with-sysmouse
+	use FreeBSD sysmouse interface provide mouse support on the console.
+
     --with-system-type=XXX
 	For testing, override the derived host system-type which is used to
 	decide things such as the linker commands used to build shared
@@ -673,7 +686,7 @@
     you may encounter when building a system with different versions of
     ncurses:
 
-    5.3 (pre-release)
+    5.3 (October 12, 2002)
 	Interface changes:
 
 	+ change type for bool used in headers to NCURSES_BOOL, which usually
@@ -895,31 +908,34 @@
 IF YOU ARE A SYSTEM INTEGRATOR:
 ------------------------------
 
-    Beginning with 1.9.9, the ncurses distribution includes both a tset
-    utility and /usr/share/tabset directory.  If you are installing ncurses,
-    it is no longer either necessary or desirable to install tset-jv.
-
     Configuration and Installation:
 
-	Configure with --prefix=/usr to make the install productions put
-	libraries and headers in the correct locations (overwriting any
-	previous curses libraries and headers).  This will put the terminfo
-	hierarchy under /usr/share/terminfo; you may want to override this with
-	--datadir=/usr/share/misc; terminfo and tabset are installed under the
-	data directory.
-
-	Please configure the ncurses library in a pure-terminfo mode; that
-	is, with the --disable-termcap option.   This will make the ncurses
-	library smaller and faster. The ncurses library includes a termcap
-	emulation that queries the terminfo database, so even applications
-	that use raw termcap to query terminal characteristics will win
-	(providing you recompile and relink them!).
-
-	If you must configure with termcap fallback enabled, you may also
-	wish to use the --enable-getcap option.  This option speeds up
-	termcap-based startups, at the expense of not allowing personal
-	termcap entries to reference the terminfo tree.  See the code in
-	ncurses/tinfo/read_termcap.c for details.
+    	On platforms where ncurses is assumed to be installed in /usr/lib,
+	the configure script uses "/usr" as a default:
+
+		Linux, FreeBSD, NetBSD, OpenBSD, Cygwin
+
+	For other platforms, the default is "/usr/local".  See the discussion
+	of the "--disable-overwrite" option.
+
+	The location of the terminfo is set indirectly by the "--datadir"
+	configure option, e.g., /usr/share/terminfo, given a datadir of
+	/usr/share.  You may want to override this if you are installing
+	ncurses libraries in nonstandard locations, but wish to share the
+	terminfo database.
+
+	Normally the ncurses library is configured in a pure-terminfo mode;
+	that is, with the --disable-termcap option.  This makes the ncurses
+	library smaller and faster.  The ncurses library includes a termcap
+	emulation that queries the terminfo database, so even applications that
+	use raw termcap to query terminal characteristics will win (providing
+	you recompile and relink them!).
+
+	If you must configure with termcap fallback enabled, you may also wish
+	to use the --enable-getcap option.  This speeds up termcap-based
+	startups, at the expense of not allowing personal termcap entries to
+	reference the terminfo tree.  See comments in
+	ncurses/tinfo/read_termcap.c for further details.
 
 	Note that if you have $TERMCAP set, ncurses will use that value
 	to locate termcap data.  In particular, running from xterm will
@@ -939,11 +955,11 @@
 
     Naming the Console Terminal
 
-	In various Linuxes (and possibly elsewhere) there has been a practice
-	of designating the system console driver type as `console'.  Please
-	do not do this any more!  It complicates peoples' lives, because it
-	can mean that several different terminfo entries from different
-	operating systems all logically want to be called `console'.
+	In various systems there has been a practice of designating the system
+	console driver type as `console'.  Please do not do this!  It
+	complicates peoples' lives, because it can mean that several different
+	terminfo entries from different operating systems all logically want to
+	be called `console'.
 
 	Please pick a name unique to your console driver and set that up
 	in the /etc/inittab table or local equivalent.  Send the entry to the
Index: MANIFEST
--- ncurses-5.3-20021012/MANIFEST	Sun Sep  1 18:08:22 2002
+++ ncurses-5.3-20030719/MANIFEST	Sat Jul  5 20:20:54 2003
@@ -166,13 +166,11 @@
 ./Ada95/src/terminal_interface.ads
 ./INSTALL
 ./MANIFEST
-./Makefile.glibc
 ./Makefile.in
 ./Makefile.os2
 ./NEWS
 ./README
 ./README.emx
-./README.glibc
 ./TO-DO
 ./aclocal.m4
 ./announce.html.in
@@ -394,6 +392,7 @@
 ./doc/html/man/form_win.3x.html
 ./doc/html/man/infocmp.1m.html
 ./doc/html/man/infotocap.1m.html
+./doc/html/man/key_defined.3x.html
 ./doc/html/man/keybound.3x.html
 ./doc/html/man/keyok.3x.html
 ./doc/html/man/menu.3x.html
@@ -593,6 +592,7 @@
 ./man/form_win.3x
 ./man/infocmp.1m
 ./man/infotocap.1m
+./man/key_defined.3x
 ./man/keybound.3x
 ./man/keyok.3x
 ./man/make_sed.sh
@@ -673,6 +673,7 @@
 ./misc/chkdef.cmd
 ./misc/cleantic.cmd
 ./misc/cmpdef.cmd
+./misc/csort
 ./misc/emx.src
 ./misc/form.def
 ./misc/form.ref
@@ -706,6 +707,7 @@
 ./ncurses/base/MKunctrl.awk
 ./ncurses/base/README
 ./ncurses/base/define_key.c
+./ncurses/base/key_defined.c
 ./ncurses/base/keybound.c
 ./ncurses/base/keyok.c
 ./ncurses/base/lib_addch.c
@@ -736,7 +738,6 @@
 ./ncurses/base/lib_initscr.c
 ./ncurses/base/lib_insch.c
 ./ncurses/base/lib_insdel.c
-./ncurses/base/lib_insstr.c
 ./ncurses/base/lib_instr.c
 ./ncurses/base/lib_isendwin.c
 ./ncurses/base/lib_leaveok.c
@@ -861,6 +862,7 @@
 ./ncurses/tty/tty_display.h
 ./ncurses/tty/tty_input.h
 ./ncurses/tty/tty_update.c
+./ncurses/widechar/charable.c
 ./ncurses/widechar/lib_box_set.c
 ./ncurses/widechar/lib_cchar.c
 ./ncurses/widechar/lib_erasewchar.c
@@ -869,9 +871,9 @@
 ./ncurses/widechar/lib_hline_set.c
 ./ncurses/widechar/lib_in_wch.c
 ./ncurses/widechar/lib_in_wchnstr.c
-./ncurses/widechar/lib_ins_nwstr.c
 ./ncurses/widechar/lib_ins_wch.c
 ./ncurses/widechar/lib_inwstr.c
+./ncurses/widechar/lib_slk_wset.c
 ./ncurses/widechar/lib_unget_wch.c
 ./ncurses/widechar/lib_vid_attr.c
 ./ncurses/widechar/lib_vline_set.c
@@ -913,12 +915,6 @@
 ./progs/toe.c
 ./progs/tput.c
 ./progs/tset.c
-./sysdeps/unix/sysv/linux/Makefile
-./sysdeps/unix/sysv/linux/alpha/configure
-./sysdeps/unix/sysv/linux/configure
-./sysdeps/unix/sysv/linux/edit_man.sed
-./sysdeps/unix/sysv/linux/edit_man.sh
-./sysdeps/unix/sysv/linux/run_tic.sh
 ./tack/COPYING
 ./tack/HISTORY
 ./tack/Makefile.in
@@ -945,6 +941,7 @@
 ./tar-copy.sh
 ./test/Makefile.in
 ./test/README
+./test/aclocal.m4
 ./test/blue.c
 ./test/bs.6
 ./test/bs.c
@@ -952,8 +949,15 @@
 ./test/cardfile.dat
 ./test/configure
 ./test/configure.in
+./test/demo_defkey.c
+./test/demo_forms.c
+./test/demo_keyok.c
+./test/demo_menus.c
+./test/demo_panels.c
 ./test/ditto.c
 ./test/dots.c
+./test/edit_field.c
+./test/edit_field.h
 ./test/filter.c
 ./test/firework.c
 ./test/firstlast.c
@@ -961,8 +965,11 @@
 ./test/gdc.c
 ./test/hanoi.c
 ./test/hashtest.c
+./test/ins_wide.c
+./test/inserts.c
 ./test/keynames.c
 ./test/knight.c
+./test/listused.sh
 ./test/lrtest.c
 ./test/modules
 ./test/ncurses.c
Index: NEWS
Prereq:  1.714 
--- ncurses-5.3-20021012/NEWS	Sat Oct 12 18:35:42 2002
+++ ncurses-5.3-20030719/NEWS	Sat Jul 19 17:54:13 2003
@@ -1,10 +1,478 @@
--- $Id: NEWS,v 1.714 2002/10/12 22:35:42 tom Exp $
+-- $Id: NEWS,v 1.757 2003/07/19 21:54:13 tom Exp $
 
 This is a log of changes that ncurses has gone through since Zeyd started
 working with Pavel Curtis' original work, pcurses, in 1992.
 
 Changes through 1.9.9e are recorded by Zeyd M. Ben-Halim.
 Changes since 1.9.9e are recorded by Thomas Dickey.
+
+20030719
+	+ use clr_eol in preference to blanks for bce terminals, so select and
+	  paste will have fewer trailing blanks, e.g., when using xterm
+	  (request by Vincent Lefevre).
+	+ correct prototype for wunctrl() in manpage.
+	+ add configure --with-abi-version option (discussion with Charles
+	  Wilson).
+ 	> cygwin changes from Charles Wilson:
+	  + aclocal.m4: on cygwin, use autodetected prefix for import
+	    and static lib, but use "cyg" for DLL.
+	  + include/ncurses_dll.h: correct the comments to reflect current
+	    status of cygwin/mingw port.  Fix compiler warning.
+	  + misc/run_tic.in: ensure that tic.exe can find the uninstalled
+	    DLL, by adding the lib-directory to the PATH variable.
+ 	  + misc/terminfo.src (nxterm|xterm-color): make xterm-color
+ 	    primary instead of nxterm, to match XFree86's xterm.terminfo
+ 	    usage and to prevent circular links.
+ 	    (rxvt): add additional codes from rxvt.org.
+ 	    (rxvt-color): new alias
+ 	    (rxvt-xpm): new alias
+ 	    (rxvt-cygwin): like rxvt, but with special acsc codes.
+ 	    (rxvt-cygwin-native): ditto.  rxvt may be run under XWindows, or
+ 	    with a "native" MSWin GUI.  Each takes different acsc codes,
+ 	    which are both different from the "normal" rxvt's acsc.
+ 	    (cygwin): cygwin-in-cmd.exe window.  Lots of fixes.
+ 	    (cygwinDBG): ditto.
+	  + mk-1st.awk: use "cyg" for the DLL prefix, but "lib" for import
+	    and static libs.
+
+20030712
+	+ update config.guess, config.sub
+	+ add triples for configuring shared libraries with the Debian
+	  GNU/FreeBSD packages (patch by Robert Millan <zeratul2@wanadoo.es>).
+
+20030705
+	+ modify CF_GCC_WARNINGS so it only applies to gcc, not g++.  Some
+	  platforms have installed g++ along with the native C compiler, which
+	  would not accept gcc warning options.
+	+ add -D_XOPEN_SOURCE=500 when configuring with --enable-widec, to
+	  get mbstate_t declaration on HPUX 11.11 (report by David Ellement).
+	+ add _nc_pathlast() to get rid of casts in _nc_basename() calls.
+	+ correct a sign-extension in wadd_wch() and wecho_wchar() from
+	  20030628 (report by Tomohiro KUBOTA).
+	+ work around omission of btowc() and wctob() from wide-character
+	  support (sic) in NetBSD 1.6 using mbtowc() and wctomb() (report by
+	  Gabor Z Papp).
+	+ add portability note to curs_get_wstr.3x (Debian #199957).
+
+20030628
+	+ rewrite wadd_wch() and wecho_wchar() to call waddch() and wechochar()
+	  respectively, to avoid calling waddch_noecho() with wide-character
+	  data, since that function assumes its input is 8-bit data. 
+	  Similarly, modify waddnwstr() to call wadd_wch().
+	+ remove logic from waddnstr() which transformed multibyte character
+	  strings into wide-characters.  Rewrite of waddch_literal() from
+	  20030621 assumes its input is raw multibyte data rather than wide
+	  characters (report by Tomohiro KUBOTA).
+
+20030621
+	+ write getyx() and related 2-return macros in terms of getcury(),
+	  getcurx(), etc.
+	+ modify waddch_literal() in case an application passes bytes of a
+	  multibyte character directly to waddch().  In this case, waddch()
+	  must reassemble the bytes into a wide-character (report by Tomohiro
+	  KUBOTA <kubota@debian.org>).
+
+20030614
+	+ modify waddch_literal() in case a multibyte value occupies more than
+	  two cells.
+	+ modify PutAttrChar() to compute the number of character cells that
+	  are used in multibyte values.  This fixes a problem displaying
+	  double-width characters (report/test by Mitsuru Chinen
+	  <mchinen@yamato.ibm.com>).
+	+ add a null-pointer check for result of keyname() in _tracechar()
+	+ modify _tracechar() to work around glibc sprintf bug.
+
+20030607
+	+ add a call to setlocale() in cursesmain.cc, making demo display
+	  properly in a UTF-8 locale.
+	+ add a fallback definition in curses.priv.h for MB_LEN_MAX (prompted
+	  by discussion with Gabor Z Papp).
+	+ use macros NCURSES_ACS() and NCURSES_WACS() to hide cast needed to
+	  appease -Wchar-subscript with g++ 3.3 (Debian #195732).
+	+ fix a redefinition of $RANLIB in the configure script when libtool
+	  is used, which broke configure on Mac OS X (report by Chris Zubrzycki
+	  <beren@mac.com>).
+	+ simplify ifdef for bool declaration in curses.h.in (suggested by
+	  Albert Chin-A-Young).
+	+ remove configure script check to allow -Wconversion for older
+	  versions of gcc (suggested by Albert Chin-A-Young).
+
+20030531
+	+ regenerated html manpages.
+	+ modify ifdef's in curses.h.in that disabled use of __attribute__()
+	  for g++, since recent versions implement the cases which ncurses uses
+	  (Debian #195230).
+	+ modify _nc_get_token() to handle a case where an entry has no
+	  description, and capabilities begin on the same line as the entry
+	  name.
+	+ fix a typo in ncurses_dll.h reported by gcc 3.3.
+	+ add an entry for key_defined.3x to man_db.renames.
+
+20030524
+	+ modify setcchar() to allow converting control characters to complex
+	  characters (report/test by Mitsuru Chinen <mchinen@yamato.ibm.com>).
+	+ add tkterm entry -TD
+	+ modify parse_entry.c to allow a terminfo entry with a leading
+	  2-character name (report by Don Libes).
+	+ corrected acsc in screen.teraterm, which requires a PC-style mapping.
+	+ fix trace statements in read_entry.c to use lseek() rather than
+	  tell().
+	+ fix signed/unsigned warnings from Sun's compiler (gcc should give
+	  these warnings, but it is unpredictable).
+	+ modify configure script to omit -Winline for gcc 3.3, since that
+	  feature is broken.
+	+ modify manlinks.sed to add a few functions that were overlooked since
+	  they return function pointers:  field_init, field_term, form_init,
+	  form_term, item_init, item_term, menu_init and menu_term.
+
+20030517
+	+ prevent recursion in wgetch() via wgetnstr() if the connection cannot
+	  be switched between cooked/raw modes because it is not a TTY (report
+	  by Wolfgang Gutjahr <gutw@knapp.com>).
+	+ change parameter of define_key() and key_defined() to const (prompted
+	  by Debian #192860).
+	+ add a check in test/configure for ncurses extensions, since there
+	  are some older versions, etc., which would not compile with the
+	  current test programs.
+	+ corrected demo in test/ncurses.c of wgetn_wstr(), which did not
+	  convert wchar_t string to multibyte form before printing it.
+	+ corrections to lib_get_wstr.c:
+	  + null-terminate buffer passed to setcchar(), which occasionally
+	    failed.
+	  + map special characters such as erase- and kill-characters into
+	    key-codes so those will work as expected even if they are not
+	    mentioned in the terminfo.
+	+ modify PUTC() and Charable() macros to make wide-character line
+	  drawing work for POSIX locale on Linux console (cf: 20021221).
+
+20030510
+	+ make typography for program options in manpages consistent (report
+	  by Miloslav Trmac <mitr@volny.cz>).
+	+ correct dependencies in Ada95/src/Makefile.in, so the builds with
+	  "--srcdir" work (report by Warren L Dodge).
+	+ correct missing definition of $(CC) in Ada95/gen/Makefile.in
+	  (reported by Warren L Dodge <warrend@mdhost.cse.tek.com>).
+	+ fix typos and whitespace in manpages (patch by jmc
+	  <jmc@prioris.mini.pw.edu.pl>).
+
+20030503
+	+ fix form_driver() cases for REQ_CLR_EOF, REQ_CLR_EOL, REQ_DEL_CHAR,
+	  REQ_DEL_PREV and REQ_NEW_LINE, which did not ensure the cursor was at
+	  the editing position before making modifications. 
+	+ add test/demo_forms and associated test/edit_field.c demos.
+	+ modify test/configure.in to use test/modules for the list of objects
+	  to compile rather than using the list of programs.
+
+20030419
+	+ modify logic of acsc to use the original character if no mapping is
+	  defined, noting that Solaris does this.
+	+ modify ncurses 'b' test to avoid using the acs_map[] array since
+	  20021231 changes it to no longer contain information from the acsc
+	  string.
+	+ modify makefile rules in c++, progs, tack and test to ensure that
+	  the compiler flags (e.g., $CFLAGS or $CCFLAGS) are used in the link
+	  command (report by Jose Luis Rico Botella <informatica@serpis.com>).
+	+ modify soft-key initialization to use A_REVERSE if A_STANDOUT would
+	  not be shown when colors are used, i.e., if ncv#1 is set in the
+	  terminfo as is done in "screen".
+
+20030412
+	+ add a test for slk_color(), in ncurses.c
+	+ fix some issues reported by valgrind in the slk_set() and slk_wset()
+	  code, from recent rewrite.
+	+ modify ncurses 'E' test to use show previous label via slk_label(),
+	  as in 'e' test.
+	+ modify wide-character versions of NewChar(), NewChar2() macros to
+	  ensure that the whole struct is initialized.
+
+20030405
+	+ modify setupterm() to check if the terminfo and terminal-modes have
+	  already been read.  This ensures that it does not reinvoke
+	  def_prog_mode() when an application calls more than one function,
+	  such as tgetent() and initscr() (report by Olaf Buddenhagen).
+
+20030329
+	+ add 'E' test to ncurses.c, to exercise slk_wset().
+	+ correct handling of carriage-return in wgetn_wstr(), used in demo of
+	  slk_wset().
+	+ first draft of slk_wset() function.
+
+20030322
+	+ improved warnings in tic when suppressing items to fit in termcap's
+	  1023-byte limit.
+	+ built a list in test/README showing which externals are being used
+	  by either programs in the test-directory or via internal library
+	  calls.
+	+ adjust include-options in CF_ETIP_DEFINES to avoid missing
+	  ncurses_dll.h, fixing special definitions that may be needed for
+	  etip.h (reported by Greg Schafer <gschafer@zip.com.au>).
+
+20030315
+	+ minor fixes for cardfile.c, to make it write the updated fields to
+	  a file when ^W is given.
+	+ add/use _nc_trace_bufcat() to eliminate some fixed buffer limits in
+	  trace code.
+
+20030308
+	+ correct a case in _nc_remove_string(), used by define_key(), to avoid
+	  infinite loop if the given string happens to be a substring of other
+	  strings which are assigned to keys (report by John McCutchan).
+	+ add key_defined() function, to tell which keycode a string is bound
+	  to (discussion with John McCutchan <ttb@tentacle.dhs.org>).
+	+ correct keybound(), which reported definitions in the wrong table,
+	  i.e., the list of definitions which are disabled by keyok().
+	+ modify demo_keydef.c to show the details it changes, and to check
+	  for errors.
+
+20030301
+	+ restructured test/configure script, make it work for libncursesw.
+	+ add description of link_fieldtype() to manpage (report by
+	  L Dee Holtsclaw <dee@sunbeltsoft.com>).
+
+20030222
+	+ corrected ifdef's relating to configure check for wchar_t, etc.
+	+ if the output is a socket or other non-tty device, use 1 millisecond
+	  for the cost in mvcur; previously it was 9 milliseconds because the
+	  baudrate was not known.
+	+ in _nc_get_tty_mode(), initialize the TTY buffer on error, since
+	  glibc copies uninitialized data in that case, as noted by valgrind.
+	+ modify tput to use the same parameter analysis as tparm() does, to
+	  provide for user-defined strings, e.g., for xterm title, a
+	  corresponding capability might be
+	  	title=\E]2;%p1%s^G,
+	+ modify MKlib_gen.sh to avoid passing "#" tokens through the C
+	  preprocessor.  This works around Mac OS X's preprocessor, which
+	  insists on adding a blank on each side of the token (report/analysis
+	  by Kevin Murphy <murphy@genome.chop.edu>).
+
+20030215
+	+ add configure check for wchar_t and wint_t types, rather than rely
+	  on preprocessor definitions.  Also work around for gcc fixinclude
+	  bug which creates a shadow copy of curses.h if it sees these symbols
+	  apparently typedef'd.
+	+ if database is disabled, do not generate run_tic.sh
+	+ minor fixes for memory-leak checking when termcap is read.
+
+20030208
+	+ add checking in tic for incomplete line-drawing character mapping.
+	+ update configure script to reflect fix for AC_PROG_GCC_TRADITIONAL,
+	  which is broken in autoconf 2.5x for Mac OS X 10.2.3 (report by
+	  Gerben Wierda <Sherlock@rna.nl>).
+	+ make return value from _nc_printf_string() consistent.  Before,
+	  depending on whether --enable-safe-sprintf was used, it might not be
+	  cached for reallocating.
+
+20030201
+	+ minor fixes for memory-leak checking in lib_tparm.c, hardscroll.c
+	+ correct a potentially-uninitialized value if _read_termtype() does
+	  not read as much data as expected (report by Wolfgang Rohdewald
+	  <wr6@uni.de>).
+	+ correct several places where the aclocal.m4 macros relied on cache
+	  variable names which were incompatible (as usual) between autoconf
+	  2.13 and 2.5x, causing the test for broken-linker to give incorrect
+	  results (reports by Gerben Wierda <Sherlock@rna.nl> and Thomas Esser
+	  <te@dbs.uni-hannover.de>).
+	+ do not try to open gpm mouse driver if standard output is not a tty;
+	  the gpm library does not make this check (from bug report for dialog
+	  by David Oliveira <davidoliveira@develop.prozone.ws>).
+
+20030125
+	+ modified emx.src to correspond more closely to terminfo.src, added
+	  emx-base to the latter -TD
+	+ add configure option for FreeBSD sysmouse, --with-sysmouse, and
+	  implement support for that in lib_mouse.c, lib_getch.c
+
+20030118
+	+ revert 20030105 change to can_clear_with(), does not work for the
+	  case where the update is made on cells which are blanks with
+	  attributes, e.g., reverse.
+	+ improve ifdef's to guard against redefinition of wchar_t and wint_t
+	  in curses.h (report by Urs Jansen).
+
+20030111
+	+ improve mvcur() by checking if it is safe to move when video
+	  attributes are set (msgr), and if not, reset/restore attributes
+	  within that function rather than doing it separately in the GoTo()
+	  function in tty_update.c (suggested by Philippe Blain).
+	+ add a message in run_tic.in to explain more clearly what does not
+	  work when attempting to create a symbolic link for /usr/lib/terminfo
+	  on OS/2 and other platforms with no symbolic links (report by John
+	  Polterak).
+	+ change several sed scripts to avoid using "\+" since it is not a BRE
+	  (basic regular expression).  One instance caused terminfo.5 to be
+	  misformatted on FreeBSD (from a FreeBSD bug report by Kazuo Horikawa
+	  <horikawa@FreeBSD.org>).
+	+ correct misspelled 'wint_t' in curs_get_wch.3x (Michael Elkins).
+
+20030105
+	+ improve description of terminfo operators, especially static/dynamic
+	  variables (comments by Mark I Manning IV <mark4th@earthlink.net>).
+	+ demonstrate use of FIELDTYPE by modifying test/ncurses 'r' test to
+	  use the predefined TYPE_ALPHA field-type, and by defining a
+	  specialized type for the middle initial/name.
+	+ fix MKterminfo.sh, another workaround for POSIXLY_CORRECT misfeature
+	  of sed 4.0
+	> Philippe Blain:
+	+ optimize can_clear_with() a little by testing first if the parameter
+	  is indeed a "blank".
+	+ simplify ClrBottom() a little by allowing it to use clr_eos to clear
+	  sections as small as one line.
+	+ improve ClrToEOL() by checking if clr_eos is available before trying
+	  to use it.
+	+ use tputs() rather than putp() in a few cases in tty_update.c since
+	  the corresponding delays are proportional to the number of lines
+	  affected: repeat_char, clr_eos, change_scroll_region.
+
+20021231
+	+ rewrite of lib_acs.c conflicts with copying of SCREEN acs_map to/from
+	  global acs_map[] array; removed the lines that did the copying.
+
+20021228
+	+ change some overlooked tputs() calls in scrolling code to use putp()
+	  (report by Philippe Blain).
+	+ modify lib_getch.c to avoid recursion via wgetnstr() when the input
+	  is not a tty and consequently mode-changes do not work (report by
+	  <R.Chamberlin@querix.com>).
+	+ rewrote lib_acs.c to allow PutAttrChar() to decide how to render
+	  alternate-characters, i.e., to work with Linux console and UTF-8
+	  locale.
+	+ correct line/column reference in adjust_window(), needed to make
+	  special windows such as curscr track properly when resizing (report
+	  by Lucas Gonze <lgonze@panix.com>).
+	> Philippe Blain:
+	+ correct the value used for blank in ClrBottom() (broken in 20000708).
+	+ correct an off-by-one in GoTo() parameter in _nc_scrolln().
+
+20021221
+	+ change several tputs() calls in scrolling code to use putp(), to
+	  enable padding which may be needed for some terminals (patch by
+	  by Philippe Blain).
+	+ use '%' as sed substitute delimiter in run_tic script to avoid
+	  problems with pathname delimiters such as ':' and '@' (report by John
+	  Polterak).
+	+ implement a workaround so that line-drawing works with screen's
+	  crippled UTF-8 support (tested with 3.9.13).  This only works with
+	  the wide-character support (--enable-widec); the normal library will
+	  simply suppress line-drawing when running in a UTF-8 locale in screen.
+
+20021214
+	+ allow BUILD_CC and related configure script variables to be
+	  overridden from the environment.
+	+ make build-tools variables in ncurses/Makefile.in consistent with
+	  the configure script variables (report by Maciej W Rozycki).
+	+ modify ncurses/modules to allow
+		configure --disable-leaks --disable-ext-funcs
+	  to build (report by Gary Samuelson).
+	+ fix a few places in configure.in which lacked quotes (report by
+	  Gary Samuelson <gary.samuelson@verizon.com>).
+	+ correct handling of multibyte characters in waddch_literal() which
+	  force wrapping because they are started too late on the line (report
+	  by Sam Varshavchik).
+	+ small fix for CF_GNAT_VERSION to ignore the help-message which
+	  gnatmake adds to its version-message.
+	> Maciej W Rozycki <macro@ds2.pg.gda.pl>:
+	+ use AC_CHECK_TOOL to get proper values for AR and LD for cross
+	  compiling.
+	+ use $cross_compiling variable in configure script rather than
+	  comparing $host_alias and $target alias, since "host" is
+	  traditionally misused in autoconf to refer to the target platform.
+	+ change configure --help message to use "build" rather than "host"
+	  when referring to the --with-build-XXX options.
+
+20021206
+	+ modify CF_GNAT_VERSION to print gnatmake's version, and to allow for
+	  possible gnat versions such as 3.2 (report by Chris Lingard
+	  <chris@stockwith.co.uk>).
+	+ modify #define's for CKILL and other default control characters in
+	  tset to use the system's default values if they are defined.
+	+ correct interchanged defaults for kill and interrupt characters
+	  in tset, which caused it to report unnecessarily (Debian #171583).
+	+ repair check for missing C++ compiler, which is broken in autoconf
+	  2.5x by hardcoding it to g++ (report by Martin Mokrejs).
+	+ update config.guess, config.sub (2002-11-30)
+	+ modify configure script to skip --with-shared, etc., when the
+	  --with-libtool option is given, since they would be ignored anyway.
+	+ fix to allow "configure --with-libtool --with-termlib" to build.
+	+ modify configure script to show version number of libtool, to help
+	  with bug reports.  libtool still gets confused if the installed
+	  ncurses libraries are old, since it ignores the -L options at some
+	  point (tested with libtool 1.3.3 and 1.4.3).
+	+ reorder configure script's updating of $CPPFLAGS and $CFLAGS to
+	  prevent -I options in the user's environment from introducing
+	  conflicts with the build -I options (may be related to reports by 
+	  Patrick Ash and George Goffe).
+	+ rename test/define_key.c to test/demo_defkey.c, test/keyok.c to
+	  test/demo_keyok.c to allow building these with libtool.
+
+20021123
+	+ add example program test/define_key.c for define_key().
+	+ add example program test/keyok.c for keyok().
+	+ add example program test/ins_wide.c for wins_wch() and wins_wstr().
+	+ modify wins_wch() and wins_wstr() to interpret tabs by using the
+	  winsch() internal function.
+	+ modify setcchar() to allow for wchar_t input strings that have
+	  more than one spacing character.
+
+20021116
+	+ fix a boundary check in lib_insch.c (patch by Philippe Blain).
+	+ change type for *printw functions from NCURSES_CONST to const
+	  (prompted by comment by Pedro Palhoto Matos <plpm@mega.ist.utl.pt>,
+	  but really from a note on X/Open's website stating that either is
+	  acceptable, and the latter will be used in a future revision).
+	+ add xterm-1002, xterm-1003 terminfo entries to demonstrate changes in
+	  lib_mouse.c (20021026) -TD
+	+ add screen-bce, screen-s entries from screen 3.9.13 (report by
+	  Adam Lazur <zal@debian.org>) -TD
+	+ add mterm terminfo entries -TD
+
+20021109
+	+ split-out useful fragments in terminfo for vt100 and vt220 numeric
+	  keypad, i.e., vt100+keypad, vt100+pfkeys, vt100+fnkeys and
+	  vt220+keypad.  The last as embedded in various entries had ka3 and
+	  kb2 interchanged (report/discussion with Leonard den Ottolander
+	  <leonardjo@hetnet.nl>).
+	+ add check in tic for keypads consistent with vt100 layout.
+	+ improve checks in tic for color capabilities
+
+20021102
+	+ check for missing/empty/illegal terminfo name in _nc_read_entry()
+	  (report by Martin Mokrejs, where $TERM was set to an empty string).
+	+ rewrote lib_insch.c, combining it with lib_insstr.c so both handle
+	  tab and other control characters consistently (report by Philippe
+	  Blain).
+	+ remove an #undef for KEY_EVENT from curses.tail used in the
+	  experimental NCURSES_WGETCH_EVENTS feature.  The #undef confuses
+	  dpkg's build script (Debian #165897).
+	+ fix MKlib_gen.sh, working around the ironically named POSIXLY_CORRECT
+	  feature of GNU sed 4.0 (reported by Ervin Nemeth <airwin@inf.bme.hu>).
+
+20021026
+	+ implement logic in lib_mouse.c to handle position reports which are
+	  generated when XFree86 xterm is initialized with private modes 1002
+	  or 1003.  These are returned to the application as the
+	  REPORT_MOUSE_POSITION mask, which was not implemented.  Tested both
+	  with ncurses 'a' menu (prompted by discussion with Larry Riedel
+	  <Larry@Riedel.org>).
+	+ modify lib_mouse.c to look for "XM" terminfo string, which allows
+	  one to override the escape sequence used to enable/disable mouse
+	  mode.  In particular this works for XFree86 xterm private modes
+	  1002 and 1003.  If "XM" is missing (note that this is an extended
+	  name), lib_mouse uses the conventional private mode 1000.
+	+ correct NOT_LOCAL() macro in lib_mvcur.c to refer to screen_columns
+	  where it used screen_lines (report by Philippe Blain).
+	+ correct makefile rules for the case when both --with-libtool and
+	  --with-gpm are given (report by Mr E_T <troll@logi.net.au>).
+	+ add note to terminfo manpage regarding the differences between
+	  setaf/setab and setf/setb capabilities (report by Pavel Roskin).
+
+20021019
+	+ remove redundant initialization of TABSIZE in newterm(), since it is
+	  already done in setupterm() (report by Philippe Blain).
+	+ add test/inserts.c, to test winnstr() and winsch().
+	+ replace 'sort' in dist.mk with script that sets locale to POSIX.
+	+ update URLs in announce.html.in (patch by Frederic L W Meunier).
+	+ remove glibc add-on files, which are no longer needed (report by
+	  Frederic L W Meunier).
 
 20021012 5.3 release for upload to ftp.gnu.org
 	+ modify ifdef's in etip.h.in to allow the etip.h header to compile
Index: README
Prereq:  1.20 
--- ncurses-5.3-20021012/README	Sat Aug 12 19:31:21 2000
+++ ncurses-5.3-20030719/README	Sat Feb  8 14:36:39 2003
@@ -1,4 +1,4 @@
--- $Id: README,v 1.20 2000/08/12 23:31:21 tom Exp $
+-- $Id: README,v 1.21 2003/02/08 19:36:39 tom Exp $
 -------------------------------------------------------------------------------
 		README file for the ncurses package
 
@@ -42,6 +42,14 @@
 	libform.a          (normal)
 	libform.so         (shared)
 	libform_g.a        (debug enabled)
+
+If you configure using the --enable-widec option, a "w" is appended to the
+library names (e.g., libncursesw.a), and the resulting libraries support
+wide-characters, e.g., via a UTF-8 locale.  The corresponding header files
+are compatible with the non-wide-character configuration; wide-character
+features are provided by ifdef's in the header files.  The wide-character
+library interfaces are not binary-compatible with the non-wide-character
+version.
 
 The ncurses libraries implement the curses API.  The panel, menu and forms
 libraries implement clones of the SVr4 panel, menu and forms APIs.  The source
Index: aclocal.m4
Prereq:  1.285 
--- ncurses-5.3-20021012/aclocal.m4	Sat Sep 21 19:59:01 2002
+++ ncurses-5.3-20030719/aclocal.m4	Sat Jul 19 17:50:04 2003
@@ -1,5 +1,5 @@
 dnl***************************************************************************
-dnl Copyright (c) 1998-2000,2001,2002 Free Software Foundation, Inc.         *
+dnl Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 dnl                                                                          *
 dnl Permission is hereby granted, free of charge, to any person obtaining a  *
 dnl copy of this software and associated documentation files (the            *
@@ -26,22 +26,24 @@
 dnl authorization.                                                           *
 dnl***************************************************************************
 dnl
-dnl Author: Thomas E. Dickey 1996,1997,1998,1999,2000,2001
+dnl Author: Thomas E. Dickey 1995-2003
 dnl
-dnl $Id: aclocal.m4,v 1.285 2002/09/21 23:59:01 tom Exp $
+dnl $Id: aclocal.m4,v 1.310 2003/07/19 21:50:04 tom Exp $
 dnl Macros used in NCURSES auto-configuration script.
 dnl
 dnl See http://invisible-island.net/autoconf/ for additional information.
 dnl
 dnl ---------------------------------------------------------------------------
 dnl ---------------------------------------------------------------------------
+dnl CF_ADA_INCLUDE_DIRS version: 4 updated: 2002/12/01 00:12:15
+dnl -------------------
 dnl Construct the list of include-options for the C programs in the Ada95
 dnl binding.
 AC_DEFUN([CF_ADA_INCLUDE_DIRS],
 [
-ACPPFLAGS="$ACPPFLAGS -I. -I../../include"
+ACPPFLAGS="-I. -I../../include $ACPPFLAGS"
 if test "$srcdir" != "."; then
-	ACPPFLAGS="$ACPPFLAGS -I\$(srcdir)/../../include"
+	ACPPFLAGS="-I\$(srcdir)/../../include $ACPPFLAGS"
 fi
 if test "$GCC" != yes; then
 	ACPPFLAGS="$ACPPFLAGS -I\$(includedir)"
@@ -57,6 +59,8 @@
 AC_SUBST(ACPPFLAGS)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ADD_CFLAGS version: 5 updated: 2002/12/01 00:12:15
+dnl -------------
 dnl Copy non-preprocessor flags to $CFLAGS, preprocessor flags to $CPPFLAGS
 dnl The second parameter if given makes this macro verbose.
 AC_DEFUN([CF_ADD_CFLAGS],
@@ -88,11 +92,13 @@
 
 if test -n "$cf_new_cppflags" ; then
 	ifelse($2,,,[CF_VERBOSE(add to \$CPPFLAGS $cf_new_cppflags)])
-	CPPFLAGS="$CPPFLAGS $cf_new_cppflags"
+	CPPFLAGS="$cf_new_cppflags $CPPFLAGS"
 fi
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ANSI_CC_CHECK version: 9 updated: 2001/12/30 17:53:34
+dnl ----------------
 dnl This is adapted from the macros 'fp_PROG_CC_STDC' and 'fp_C_PROTOTYPES'
 dnl in the sharutils 4.2 distribution.
 AC_DEFUN([CF_ANSI_CC_CHECK],
@@ -143,6 +149,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ANSI_CC_REQD version: 3 updated: 1997/09/06 13:40:44
+dnl ---------------
 dnl For programs that must use an ANSI compiler, obtain compiler options that
 dnl will make it recognize prototypes.  We'll do preprocessor checks in other
 dnl macros, since tools such as unproto can fake prototypes, but only part of
@@ -159,6 +167,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_BOOL_DECL version: 6 updated: 2001/12/02 01:39:28
+dnl ------------
 dnl Test if 'bool' is a builtin type in the configured C++ compiler.  Some
 dnl older compilers (e.g., gcc 2.5.8) don't support 'bool' directly; gcc
 dnl 2.6.3 does, in anticipation of the ANSI C++ standard.
@@ -185,6 +195,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_BOOL_SIZE version: 10 updated: 2002/02/23 20:38:31
+dnl ------------
 dnl Test for the size of 'bool' in the configured C++ compiler (e.g., a type).
 dnl Don't bother looking for bool.h, since it's been deprecated.
 dnl
@@ -251,6 +263,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CFG_DEFAULTS version: 6 updated: 2003/07/12 15:15:19
+dnl ---------------
 dnl Determine the default configuration into which we'll install ncurses.  This
 dnl can be overridden by the user's command-line options.  There's two items to
 dnl look for:
@@ -267,7 +281,7 @@
 if test "x$prefix" = "xNONE" ; then
 	case "$cf_cv_system_name" in
 		# non-vendor systems don't have a conflict
-	openbsd*|netbsd*|freebsd*|linux*|cygwin*)
+	openbsd*|netbsd*|freebsd*|linux*|cygwin*|k*bsd*-gnu)
 		prefix=/usr
 		;;
 	*)	prefix=$ac_default_prefix
@@ -303,6 +317,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CGETENT version: 3 updated: 2000/08/12 23:18:52
+dnl ----------
 dnl Check if the terminal-capability database functions are available.  If not,
 dnl ncurses has a much-reduced version.
 AC_DEFUN([CF_CGETENT],[
@@ -324,6 +340,8 @@
 test "$cf_cv_cgetent" = yes && AC_DEFINE(HAVE_BSD_CGETENT)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CHECK_CACHE version: 7 updated: 2001/12/19 00:50:10
+dnl --------------
 dnl Check if we're accidentally using a cache from a different machine.
 dnl Derive the system name, as a check for reusing the autoconf cache.
 dnl
@@ -354,6 +372,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CHECK_ERRNO version: 9 updated: 2001/12/30 18:03:23
+dnl --------------
 dnl Check for data that is usually declared in <stdio.h> or <errno.h>, e.g.,
 dnl the 'errno' variable.  Define a DECL_xxx symbol if we must declare it
 dnl ourselves.
@@ -383,6 +403,8 @@
 CF_CHECK_EXTERN_DATA($1,int)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CHECK_EXTERN_DATA version: 3 updated: 2001/12/30 18:03:23
+dnl --------------------
 dnl Check for existence of external data in the current set of libraries.  If
 dnl we can modify it, it's real enough.
 dnl $1 = the name to check
@@ -406,6 +428,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CPP_PARAM_INIT version: 4 updated: 2001/04/07 22:31:18
+dnl -----------------
 dnl Check if the C++ compiler accepts duplicate parameter initialization.  This
 dnl is a late feature for the standard and is not in some recent compilers
 dnl (1999/9/11).
@@ -439,6 +463,8 @@
 test "$cf_cv_cpp_param_init" = yes && AC_DEFINE(CPP_HAS_PARAM_INIT)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_CPP_VSCAN_FUNC version: 5 updated: 2001/12/02 01:39:28
+dnl -----------------
 dnl Check if the g++ compiler supports vscan function (not a standard feature).
 AC_DEFUN([CF_CPP_VSCAN_FUNC],
 [
@@ -515,9 +541,13 @@
 esac
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_DIRNAME version: 4 updated: 2002/12/21 19:25:52
+dnl ----------
 dnl "dirname" is not portable, so we fake it with a shell script.
-AC_DEFUN([CF_DIRNAME],[$1=`echo $2 | sed -e 's:/[[^/]]*$::'`])dnl
+AC_DEFUN([CF_DIRNAME],[$1=`echo $2 | sed -e 's%/[[^/]]*$%%'`])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_DIRS_TO_MAKE version: 3 updated: 2002/02/23 20:38:31
+dnl ---------------
 AC_DEFUN([CF_DIRS_TO_MAKE],
 [
 DIRS_TO_MAKE="lib"
@@ -537,12 +567,16 @@
 AC_SUBST(DIRS_TO_MAKE)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ERRNO version: 5 updated: 1997/11/30 12:44:39
+dnl --------
 dnl Check if 'errno' is declared in <errno.h>
 AC_DEFUN([CF_ERRNO],
 [
 CF_CHECK_ERRNO(errno)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ETIP_DEFINES version: 3 updated: 2003/03/22 19:13:43
+dnl ---------------
 dnl Test for conflicting definitions of exception in gcc 2.8.0, etc., between
 dnl math.h and builtin.h, only for ncurses
 AC_DEFUN([CF_ETIP_DEFINES],
@@ -554,7 +588,7 @@
 do
 for cf_excp in "" MATH_EXCEPTION
 do
-	CXXFLAGS="$cf_save_CXXFLAGS -I${srcdir}/c++ -I${srcdir}/menu"
+	CXXFLAGS="$cf_save_CXXFLAGS -I${srcdir}/c++ -I${srcdir}/menu -I${srcdir}/include"
 	test -n "$cf_math" && CXXFLAGS="$CXXFLAGS -DETIP_NEEDS_${cf_math}"
 	test -n "$cf_excp" && CXXFLAGS="$CXXFLAGS -DETIP_NEEDS_${cf_excp}"
 AC_TRY_COMPILE([
@@ -571,6 +605,8 @@
 CXXFLAGS="$cf_save_CXXFLAGS"
 ])
 dnl ---------------------------------------------------------------------------
+dnl CF_FUNC_MEMMOVE version: 5 updated: 2000/08/12 23:18:52
+dnl ---------------
 dnl Check for memmove, or a bcopy that can handle overlapping copy.  If neither
 dnl is found, add our own version of memmove to the list of objects.
 AC_DEFUN([CF_FUNC_MEMMOVE],
@@ -600,6 +636,8 @@
 	fi
 ])])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_FUNC_POLL version: 2 updated: 2000/02/06 01:38:04
+dnl ------------
 dnl See if the poll function really works.  Some platforms have poll(), but
 dnl it does not work for terminals or files.
 AC_DEFUN([CF_FUNC_POLL],[
@@ -627,6 +665,8 @@
 test "$cf_cv_working_poll" = "yes" && AC_DEFINE(HAVE_WORKING_POLL)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_FUNC_TERMIOS version: 2 updated: 2000/07/22 23:37:24
+dnl ---------------
 dnl Some old/broken variations define tcgetattr() only as a macro in
 dnl termio(s).h
 AC_DEFUN([CF_FUNC_TERMIOS],[
@@ -654,6 +694,8 @@
 test "$cf_cv_have_tcgetattr" = yes && AC_DEFINE(HAVE_TCGETATTR)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_FUNC_VSSCANF version: 3 updated: 2001/12/19 00:50:10
+dnl ---------------
 dnl Check for vsscanf() function, which is in c9x but generally not in earlier
 dnl versions of C.  It is in the GNU C library, and can often be simulated by
 dnl other functions.
@@ -697,6 +739,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GCC_ATTRIBUTES version: 9 updated: 2002/12/21 19:25:52
+dnl -----------------
 dnl Test for availability of useful gcc __attribute__ directives to quiet
 dnl compiler warnings.  Though useful, not all are supported -- and contrary
 dnl to documentation, unrecognized directives cause older compilers to barf.
@@ -761,8 +805,6 @@
 		if AC_TRY_EVAL(ac_compile); then
 			test -n "$verbose" && AC_MSG_RESULT(... $cf_attribute)
 			cat conftest.h >>confdefs.h
-#		else
-#			sed -e 's/__attr.*/\/*nothing*\//' conftest.h >>confdefs.h
 		fi
 	done
 else
@@ -772,17 +814,35 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GCC_VERSION version: 2 updated: 2003/05/24 15:01:41
+dnl --------------
+dnl Find version of gcc
+AC_DEFUN([CF_GCC_VERSION],[
+AC_REQUIRE([AC_PROG_CC])
+GCC_VERSION=none
+if test "$GCC" = yes ; then
+	AC_MSG_CHECKING(version of $CC)
+	GCC_VERSION="`${CC} --version|head -1 | sed -e 's/^[[^0-9.]]*//' -e 's/[[^0-9.]].*//'`"
+	test -z "$GCC_VERSION" && GCC_VERSION=unknown
+	AC_MSG_RESULT($GCC_VERSION)
+fi
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_GCC_WARNINGS version: 15 updated: 2003/07/05 18:42:30
+dnl ---------------
 dnl Check if the compiler supports useful warning options.  There's a few that
 dnl we don't use, simply because they're too noisy:
 dnl
 dnl	-Wconversion (useful in older versions of gcc, but not in gcc 2.7.x)
 dnl	-Wredundant-decls (system headers make this too noisy)
 dnl	-Wtraditional (combines too many unrelated messages, only a few useful)
-dnl	-Wwrite-strings (too noisy, but should review occasionally)
+dnl	-Wwrite-strings (too noisy, but should review occasionally).  This
+dnl		is enabled for ncurses using "--enable-const".
 dnl	-pedantic
 dnl
 AC_DEFUN([CF_GCC_WARNINGS],
 [
+AC_REQUIRE([CF_GCC_VERSION])
 if test "$GCC" = yes
 then
 	cat > conftest.$ac_ext <<EOF
@@ -810,8 +870,19 @@
 		CFLAGS="$cf_save_CFLAGS $EXTRA_CFLAGS -$cf_opt"
 		if AC_TRY_EVAL(ac_compile); then
 			test -n "$verbose" && AC_MSG_RESULT(... -$cf_opt)
+			case $cf_opt in #(vi
+			Wcast-qual) #(vi
+				CPPFLAGS="$CPPFLAGS -DXTSTRINGDEFINES"
+				;;
+			Winline) #(vi
+				case $GCC_VERSION in
+				3.3*)
+					CF_VERBOSE(feature is broken in gcc $GCC_VERSION)
+					continue;;
+				esac
+				;;
+			esac
 			EXTRA_CFLAGS="$EXTRA_CFLAGS -$cf_opt"
-			test "$cf_opt" = Wcast-qual && EXTRA_CFLAGS="$EXTRA_CFLAGS -DXTSTRINGDEFINES"
 		fi
 	done
 	rm -f conftest*
@@ -820,6 +891,8 @@
 AC_SUBST(EXTRA_CFLAGS)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GNAT_TRY_RUN version: 2 updated: 1998/07/19 00:25:18
+dnl ---------------
 dnl Verify that a test program compiles and runs with GNAT
 dnl $cf_ada_make is set to the program that compiles/links
 AC_DEFUN([CF_GNAT_TRY_RUN],
@@ -843,21 +916,26 @@
 rm -f conftest*
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GNAT_VERSION version: 10 updated: 2002/12/14 23:56:19
+dnl ---------------
 dnl Verify Version of GNAT.
 AC_DEFUN([CF_GNAT_VERSION],
 [
-cf_cv_gnat_version=`$cf_ada_make -v 2>&1 | grep '[[0-9]].[[0-9]][[0-9]]*' |\
-  sed -e 's/[[^0-9 \.]]//g' | $AWK '{print $[1];}'`
-case $cf_cv_gnat_version in
+AC_MSG_CHECKING(for gnat version)
+cf_gnat_version=`$cf_ada_make -v 2>&1 | grep '[[0-9]].[[0-9]][[0-9]]*' |\
+  sed -e 's/[[^0-9 \.]]//g' | $AWK '{print $[1];}' | head -1`
+AC_MSG_RESULT($cf_gnat_version)
+
+case $cf_gnat_version in
   3.1[[1-9]]*|3.[[2-9]]*|[[4-9]].*)
     cf_cv_prog_gnat_correct=yes
     ;;
-  *) echo Unsupported GNAT version $cf_cv_gnat_version. Required is 3.11 or better. Disabling Ada95 binding.
+  *) echo Unsupported GNAT version $cf_gnat_version. Required is 3.11 or better. Disabling Ada95 binding.
      cf_cv_prog_gnat_correct=no
      ;;
 esac
-case $cf_cv_gnat_version in
-  3.1*|[[4-9]].*)
+case $cf_gnat_version in
+  3.[[1-9]]*|[[4-9]].*)
       cf_compile_generics=generics
       cf_generic_objects="\$(GENOBJS)"
       ;;
@@ -867,6 +945,8 @@
 esac
 ])
 dnl ---------------------------------------------------------------------------
+dnl CF_GNU_SOURCE version: 3 updated: 2000/10/29 23:30:53
+dnl -------------
 dnl Check if we must define _GNU_SOURCE to get a reasonable value for
 dnl _XOPEN_SOURCE, upon which many POSIX definitions depend.  This is a defect
 dnl (or misfeature) of glibc2, which breaks portability of many applications,
@@ -895,6 +975,8 @@
 test "$cf_cv_gnu_source" = yes && CPPFLAGS="$CPPFLAGS -D_GNU_SOURCE"
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GPP_LIBRARY version: 8 updated: 2003/02/02 01:41:46
+dnl --------------
 dnl If we're trying to use g++, test if libg++ is installed (a rather common
 dnl problem :-).  If we have the compiler but no library, we'll be able to
 dnl configure, but won't be able to build the c++ demo program.
@@ -909,7 +991,7 @@
 	cf_gpp_libname=g++
 	;;
 esac
-if test "$ac_cv_prog_gxx" = yes; then
+if test "$GXX" = yes; then
 	AC_MSG_CHECKING([for lib$cf_gpp_libname])
 	cf_save="$LIBS"
 	LIBS="$LIBS -l$cf_gpp_libname"
@@ -937,20 +1019,37 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_GXX_VERSION version: 2 updated: 2003/05/24 14:41:00
+dnl --------------
+dnl Check for version of g++
+AC_DEFUN([CF_GXX_VERSION],[
+AC_REQUIRE([AC_PROG_CPP])
+GXX_VERSION=none
+if test "$GXX" = yes; then
+	AC_MSG_CHECKING(version of g++)
+	GXX_VERSION="`${CXX-g++} --version|head -1`"
+	AC_MSG_RESULT($GXX_VERSION)
+fi
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_HELP_MESSAGE version: 3 updated: 1998/01/14 10:56:23
+dnl ---------------
 dnl Insert text into the help-message, for readability, from AC_ARG_WITH.
 AC_DEFUN([CF_HELP_MESSAGE],
 [AC_DIVERT_HELP([$1])dnl
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_INCLUDE_DIRS version: 4 updated: 2002/12/01 00:12:15
+dnl ---------------
 dnl Construct the list of include-options according to whether we're building
 dnl in the source directory or using '--srcdir=DIR' option.  If we're building
 dnl with gcc, don't append the includedir if it happens to be /usr/include,
 dnl since that usually breaks gcc's shadow-includes.
 AC_DEFUN([CF_INCLUDE_DIRS],
 [
-CPPFLAGS="$CPPFLAGS -I. -I../include"
+CPPFLAGS="-I. -I../include $CPPFLAGS"
 if test "$srcdir" != "."; then
-	CPPFLAGS="$CPPFLAGS -I\$(srcdir)/../include"
+	CPPFLAGS="-I\$(srcdir)/../include $CPPFLAGS"
 fi
 if test "$GCC" != yes; then
 	CPPFLAGS="$CPPFLAGS -I\$(includedir)"
@@ -966,6 +1065,8 @@
 AC_SUBST(CPPFLAGS)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_ISASCII version: 3 updated: 2000/08/12 23:18:52
+dnl ----------
 dnl Check if we have either a function or macro for 'isascii()'.
 AC_DEFUN([CF_ISASCII],
 [
@@ -979,6 +1080,8 @@
 test "$cf_cv_have_isascii" = yes && AC_DEFINE(HAVE_ISASCII)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LIBUTF8 version: 2 updated: 2002/01/19 22:51:32
+dnl ----------
 dnl Check for libutf8
 AC_DEFUN([CF_LIBUTF8],
 [
@@ -998,6 +1101,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LIB_PREFIX version: 7 updated: 2001/01/12 01:23:48
+dnl -------------
 dnl Compute the library-prefix for the given host system
 dnl $1 = variable to set
 AC_DEFUN([CF_LIB_PREFIX],
@@ -1011,6 +1116,8 @@
 	AC_SUBST(LIB_PREFIX)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LIB_RULES version: 29 updated: 2003/07/19 16:05:52
+dnl ------------
 dnl Append definitions and rules for the given models to the subdirectory
 dnl Makefiles, and the recursion rule for the top-level Makefile.  If the
 dnl subdirectory is a library-source directory, modify the LIBRARIES list in
@@ -1054,8 +1161,10 @@
 				esac
 			fi
 			# cygwin needs import library, and has unique naming convention
+			# use autodetected ${cf_prefix} for import lib and static lib, but
+			# use 'cyg' prefix for shared lib.
 			if test $cf_cv_shlib_version = cygdll ; then
-				SHARED_LIB="../lib/${cf_prefix}${cf_dir}\$(ABI_VERSION).dll"
+				SHARED_LIB="../lib/cyg${cf_dir}\$(ABI_VERSION).dll"
 				IMPORT_LIB="../lib/${cf_prefix}${cf_dir}.dll.a"
 				LIBS_TO_MAKE="$LIBS_TO_MAKE \$(SHARED_LIB) \$(IMPORT_LIB)"
 				continue
@@ -1070,7 +1179,7 @@
 			termlib+*) #(vi
 				;;
 			*) #(vi
-				cf_item=`echo $LIBS_TO_MAKE |sed -e s/$LIB_NAME/$TINFO_NAME/g`
+				cf_item=`echo $LIBS_TO_MAKE |sed -e s%$LIB_NAME%$TINFO_NAME%g`
 				LIBS_TO_MAKE="$cf_item $LIBS_TO_MAKE"
 				;;
 			esac
@@ -1128,7 +1237,7 @@
 				ldconfig="$LDCONFIG" \
 				overwrite=$WITH_OVERWRITE \
 				depend="$cf_depend" \
-				target="$target" \
+				host="$host" \
 				$srcdir/$cf_dir/modules >>$cf_dir/Makefile
 			for cf_subdir2 in $cf_subdirs lib
 			do
@@ -1364,6 +1473,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LIB_SUFFIX version: 12 updated: 2002/01/20 01:43:41
+dnl -------------
 dnl Compute the library file-suffix from the given model name
 dnl $1 = model name
 dnl $2 = variable to set
@@ -1387,6 +1498,8 @@
 	test -n "$LIB_SUFFIX" && $2="${LIB_SUFFIX}[$]{$2}"
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LIB_TYPE version: 4 updated: 2000/10/20 22:57:49
+dnl -----------
 dnl Compute the string to append to -library from the given model name
 dnl $1 = model name
 dnl $2 = variable to set
@@ -1403,6 +1516,8 @@
 	test -n "$LIB_SUFFIX" && $2="${LIB_SUFFIX}[$]{$2}"
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LINK_DATAONLY version: 6 updated: 2003/02/02 01:41:46
+dnl ----------------
 dnl Some systems have a non-ANSI linker that doesn't pull in modules that have
 dnl only data (i.e., no functions), for example NeXT.  On those systems we'll
 dnl have to provide wrappers for global tables to ensure they're linked
@@ -1418,7 +1533,7 @@
 EOF
 	if AC_TRY_EVAL(ac_compile) ; then
 		mv conftest.o data.o && \
-		( $AR $AR_OPTS conftest.a data.o ) 2>&5 1>/dev/null
+		( $AR $AR_OPTS conftest.a data.o ) 2>&AC_FD_CC 1>/dev/null
 	fi
 	rm -f conftest.$ac_ext data.o
 	cat >conftest.$ac_ext <<EOF
@@ -1437,10 +1552,10 @@
 EOF
 	if AC_TRY_EVAL(ac_compile); then
 		mv conftest.o func.o && \
-		( $AR $AR_OPTS conftest.a func.o ) 2>&5 1>/dev/null
+		( $AR $AR_OPTS conftest.a func.o ) 2>&AC_FD_CC 1>/dev/null
 	fi
 	rm -f conftest.$ac_ext func.o
-	( eval $ac_cv_prog_RANLIB conftest.a ) 2>&5 >/dev/null
+	( eval $RANLIB conftest.a ) 2>&AC_FD_CC >/dev/null
 	cf_saveLIBS="$LIBS"
 	LIBS="conftest.a $LIBS"
 	AC_TRY_RUN([
@@ -1464,6 +1579,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_LINK_FUNCS version: 5 updated: 2003/02/02 01:41:46
+dnl -------------
 dnl Most Unix systems have both link and symlink, a few don't have symlink.
 dnl A few non-Unix systems implement symlink, but not link.
 dnl A few non-systems implement neither (or have nonfunctional versions).
@@ -1473,7 +1590,7 @@
 	remove \
 	unlink )
 
-if test "$ac_cv_prog_cc_cross" = yes ; then
+if test "$cross_compiling" = yes ; then
 	AC_CHECK_FUNCS( \
 		link \
 		symlink )
@@ -1519,6 +1636,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MAKEFLAGS version: 9 updated: 2001/12/30 18:17:27
+dnl ------------
 dnl Some 'make' programs support $(MAKEFLAGS), some $(MFLAGS), to pass 'make'
 dnl options to lower-levels.  It's very useful for "make -n" -- if we have it.
 dnl (GNU 'make' does both, something POSIX 'make', which happens to make the
@@ -1556,6 +1675,8 @@
 AC_SUBST(cf_cv_makeflags)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MAKE_TAGS version: 2 updated: 2000/10/04 09:18:40
+dnl ------------
 dnl Generate tags/TAGS targets for makefiles.  Do not generate TAGS if we have
 dnl a monocase filesystem.
 AC_DEFUN([CF_MAKE_TAGS],[
@@ -1583,6 +1704,8 @@
 AC_SUBST(MAKE_LOWER_TAGS)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MANPAGE_FORMAT version: 6 updated: 2002/01/19 22:51:32
+dnl -----------------
 dnl Option to allow user to override automatic configuration of manpage format.
 dnl There are several special cases.
 AC_DEFUN([CF_MANPAGE_FORMAT],
@@ -1635,6 +1758,8 @@
 AC_MSG_RESULT($MANPAGE_FORMAT)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MANPAGE_RENAMES version: 6 updated: 2002/01/19 22:51:32
+dnl ------------------
 dnl The Debian people have their own naming convention for manpages.  This
 dnl option lets us override the name of the file containing renaming, or
 dnl disable it altogether.
@@ -1680,6 +1805,8 @@
 AC_SUBST(MANPAGE_RENAMES)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MANPAGE_SYMLINKS version: 3 updated: 2002/01/19 22:51:32
+dnl -------------------
 dnl Some people expect each tool to make all aliases for manpages in the
 dnl man-directory.  This accommodates the older, less-capable implementations
 dnl of 'man', and is optional.
@@ -1695,6 +1822,8 @@
 AC_MSG_RESULT($MANPAGE_SYMLINKS)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MANPAGE_TBL version: 3 updated: 2002/01/19 22:51:32
+dnl --------------
 dnl This option causes manpages to be run through tbl(1) to generate tables
 dnl correctly.
 AC_DEFUN([CF_MANPAGE_TBL],
@@ -1709,6 +1838,8 @@
 AC_MSG_RESULT($MANPAGE_TBL)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MAN_PAGES version: 23 updated: 2002/12/21 22:46:07
+dnl ------------
 dnl Try to determine if the man-pages on the system are compressed, and if
 dnl so, what format is used.  Use this information to construct a script that
 dnl will install man-pages.
@@ -1888,7 +2019,7 @@
   ;;
 esac
 cat >>man/edit_man.sh <<CF_EOF
-	suffix=\`basename \$target | sed -e 's/^[[^.]]*//'\`
+	suffix=\`basename \$target | sed -e 's%^[[^.]]*%%'\`
 	if test \$verb = installing ; then
 		echo \$verb \$target
 		\$INSTALL_DATA \$TMP \$target
@@ -1947,6 +2078,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MATH_LIB version: 5 updated: 2000/05/28 01:39:10
+dnl -----------
 dnl Checks for libraries.  At least one UNIX system, Apple Macintosh
 dnl Rhapsody 5.5, does not have -lm.  We cannot use the simpler
 dnl AC_CHECK_LIB(m,sin), because that fails for C++.
@@ -1969,37 +2102,8 @@
 fi
 ])
 dnl ---------------------------------------------------------------------------
-dnl Check if mbstate_t is declared, and if so, which header file.
-AC_DEFUN([CF_MBSTATE_T],
-[
-# This is needed on Tru64 5.0 to declare mbstate_t
-AC_CACHE_CHECK(if we must include wchar.h to declare mbstate_t,cf_cv_mbstate_t,[
-AC_TRY_COMPILE([
-#include <stdlib.h>
-#ifdef HAVE_LIBUTF8_H
-#include <libutf8.h>
-#endif],
-	[mbstate_t state],
-	[cf_cv_mbstate_t=no],
-	[AC_TRY_COMPILE([
-#include <stdlib.h>
-#include <wchar.h>
-#ifdef HAVE_LIBUTF8_H
-#include <libutf8.h>
-#endif],
-	[mbstate_t value],
-	[cf_cv_mbstate_t=yes],
-	[cf_cv_mbstate_t=unknown])])])
-
-if test "$cf_cv_mbstate_t" = yes ; then
-	AC_DEFINE(NEED_WCHAR_H)
-fi
-
-if test "$cf_cv_mbstate_t" != unknown ; then
-	AC_DEFINE(HAVE_MBSTATE_T)
-fi
-])dnl
-dnl ---------------------------------------------------------------------------
+dnl CF_MIXEDCASE_FILENAMES version: 2 updated: 2000/10/04 09:18:40
+dnl ----------------------
 dnl Check if the file-system supports mixed-case filenames.  If we're able to
 dnl create a lowercase name and see it as uppercase, it doesn't support that.
 AC_DEFUN([CF_MIXEDCASE_FILENAMES],
@@ -2017,6 +2121,8 @@
 test "$cf_cv_mixedcase" = yes && AC_DEFINE(MIXEDCASE_FILENAMES)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_MKSTEMP version: 3 updated: 2001/11/08 20:59:59
+dnl ----------
 dnl Check for a working mkstemp.  This creates two files, checks that they are
 dnl successfully created and distinct (AmigaOS apparently fails on the last).
 AC_DEFUN([CF_MKSTEMP],[
@@ -2065,6 +2171,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_OBJ_SUBDIR version: 4 updated: 2002/02/23 20:38:31
+dnl -------------
 dnl Compute the object-directory name from the given model name
 AC_DEFUN([CF_OBJ_SUBDIR],
 [
@@ -2083,6 +2191,8 @@
 	esac
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_PATHSEP version: 3 updated: 2001/01/12 01:23:53
+dnl ----------
 dnl Provide a value for the $PATH and similar separator
 AC_DEFUN([CF_PATHSEP],
 [
@@ -2094,6 +2204,8 @@
 	AC_SUBST(PATHSEP)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_PATH_SYNTAX version: 9 updated: 2002/09/17 23:03:38
+dnl --------------
 dnl Check the argument to see that it looks like a pathname.  Rewrite it if it
 dnl begins with one of the prefix/exec_prefix variables, and then again if the
 dnl result begins with 'NONE'.  This is necessary to work around autoconf's
@@ -2123,6 +2235,8 @@
 esac
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_PROG_EXT version: 8 updated: 2002/12/21 19:25:52
+dnl -----------
 dnl Compute $PROG_EXT, used for non-Unix ports, such as OS/2 EMX.
 AC_DEFUN([CF_PROG_EXT],
 [
@@ -2134,7 +2248,7 @@
     CFLAGS="$CFLAGS -Zmt"
     CPPFLAGS="$CPPFLAGS -D__ST_MT_ERRNO__"
     CXXFLAGS="$CXXFLAGS -Zmt"
-    LDFLAGS=`echo "$LDFLAGS -Zmt -Zcrtdll" | sed "s/-Zexe//g"`
+    LDFLAGS=`echo "$LDFLAGS -Zmt -Zcrtdll" | sed -e "s%-Zexe%%g"`
     PROG_EXT=".exe"
     ;;
 cygwin*)
@@ -2145,6 +2259,8 @@
 test -n "$PROG_EXT" && AC_DEFINE_UNQUOTED(PROG_EXT,"$PROG_EXT")
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_PROG_INSTALL version: 5 updated: 2002/12/21 22:46:07
+dnl ---------------
 dnl Force $INSTALL to be an absolute-path.  Otherwise, edit_man.sh and the
 dnl misc/tabset install won't work properly.  Usually this happens only when
 dnl using the fallback mkinstalldirs script
@@ -2156,11 +2272,13 @@
 *)
   CF_DIRNAME(cf_dir,$INSTALL)
   test -z "$cf_dir" && cf_dir=.
-  INSTALL=`cd $cf_dir && pwd`/`echo $INSTALL | sed -e 's:^.*/::'`
+  INSTALL=`cd $cf_dir && pwd`/`echo $INSTALL | sed -e 's%^.*/%%'`
   ;;
 esac
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_REGEX version: 3 updated: 1997/11/01 14:26:01
+dnl --------
 dnl Attempt to determine if we've got one of the flavors of regular-expression
 dnl code that we can support.
 AC_DEFUN([CF_REGEX],
@@ -2193,6 +2311,8 @@
 esac
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SHARED_OPTS version: 29 updated: 2003/07/12 15:15:19
+dnl --------------
 dnl Attempt to determine the appropriate CC/LD options for creating a shared
 dnl library.
 dnl
@@ -2303,7 +2423,7 @@
 		MK_SHARED_LIB='$(LD) -shared -rdata_shared -soname `basename $[@]` -o $[@]'
 		cf_cv_rm_so_locs=yes
 		;;
-	linux*|gnu*)
+	linux*|gnu*|k*bsd*-gnu)
 		if test "$DFT_LWR_MODEL" = "shared" ; then
 			LOCAL_LDFLAGS="-Wl,-rpath,`pwd`/lib"
 			LOCAL_LDFLAGS2="$LOCAL_LDFLAGS"
@@ -2364,7 +2484,7 @@
 		;;
 	sco3.2v5*)  # (also uw2* and UW7) hops 13-Apr-98
 		# tested with osr5.0.5
-		if test "$ac_cv_prog_gcc" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-belf -KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -dy -G -h `basename $[@] .$(REL_VERSION)`.$(ABI_VERSION) -o [$]@'
@@ -2378,7 +2498,7 @@
 		;;
 	sunos4*)
 		# tested with SunOS 4.1.1 and gcc 2.7.0
-		if test "$ac_cv_prog_gcc" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -assert pure-text -o $[@]'
@@ -2386,7 +2506,7 @@
 		;;
 	solaris2*)
 		# tested with SunOS 5.5.1 (solaris 2.5.1) and gcc 2.7.2
-		if test "$ac_cv_prog_gcc" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -dy -G -h `basename $[@] .$(REL_VERSION)`.$(ABI_VERSION) -o $[@]'
@@ -2402,7 +2522,7 @@
 		;;
 	sysv5uw7*|unix_sv*)
 		# tested with UnixWare 7.1.0 (gcc 2.95.2 and cc)
-		if test "$ac_cv_prog_gcc" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -d y -G -o [$]@'
@@ -2449,6 +2569,8 @@
 	AC_SUBST(INSTALL_LIB)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SIZECHANGE version: 8 updated: 2000/11/04 12:22:16
+dnl -------------
 dnl Check for definitions & structures needed for window size-changing
 dnl FIXME: check that this works with "snake" (HP-UX 10.x)
 AC_DEFUN([CF_SIZECHANGE],
@@ -2517,6 +2639,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SRC_MODULES version: 14 updated: 2002/01/19 22:51:32
+dnl --------------
 dnl For each parameter, test if the source-directory exists, and if it contains
 dnl a 'modules' file.  If so, add to the list $cf_cv_src_modules which we'll
 dnl use in CF_LIB_RULES.
@@ -2614,6 +2738,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_STDCPP_LIBRARY version: 5 updated: 2000/08/12 23:18:52
+dnl -----------------
 dnl Check for -lstdc++, which is GNU's standard C++ library.
 AC_DEFUN([CF_STDCPP_LIBRARY],
 [
@@ -2642,10 +2768,14 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_STRIP_G_OPT version: 3 updated: 2002/12/21 19:25:52
+dnl --------------
 dnl	Remove "-g" option from the compiler options
 AC_DEFUN([CF_STRIP_G_OPT],
-[$1=`echo ${$1} | sed -e 's/-g //' -e 's/-g$//'`])dnl
+[$1=`echo ${$1} | sed -e 's%-g %%' -e 's%-g$%%'`])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_STRUCT_SIGACTION version: 3 updated: 2000/08/12 23:18:52
+dnl -------------------
 dnl Check if we need _POSIX_SOURCE defined to use struct sigaction.  We'll only
 dnl do this if we've found the sigaction function.
 dnl
@@ -2671,6 +2801,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_STRUCT_TERMIOS version: 5 updated: 2000/11/04 12:22:46
+dnl -----------------
 dnl Some machines require _POSIX_SOURCE to completely define struct termios.
 dnl If so, define SVR4_TERMIO
 AC_DEFUN([CF_STRUCT_TERMIOS],[
@@ -2705,6 +2837,8 @@
 fi
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SUBST version: 2 updated: 1997/09/06 23:41:28
+dnl --------
 dnl	Shorthand macro for substituting things that the user may override
 dnl	with an environment variable.
 dnl
@@ -2721,6 +2855,8 @@
 $2=${cf_cv_subst_$2}
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SUBST_NCURSES_VERSION version: 7 updated: 2003/06/07 16:22:51
+dnl ------------------------
 dnl Get the version-number for use in shared-library naming, etc.
 AC_DEFUN([CF_SUBST_NCURSES_VERSION],
 [
@@ -2739,12 +2875,13 @@
 dnl We need these values in the generated makefiles
 AC_SUBST(cf_cv_rel_version)
 AC_SUBST(cf_cv_abi_version)
-AC_SUBST(cf_cv_cc_bool_type)
 AC_SUBST(cf_cv_builtin_bool)
 AC_SUBST(cf_cv_header_stdbool_h)
 AC_SUBST(cf_cv_type_of_bool)dnl
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_SYS_TIME_SELECT version: 4 updated: 2000/10/04 09:18:40
+dnl ------------------
 dnl Check if we can include <sys/time.h> with <sys/select.h>; this breaks on
 dnl older SCO configurations.
 AC_DEFUN([CF_SYS_TIME_SELECT],
@@ -2766,6 +2903,8 @@
 test "$cf_cv_sys_time_select" = yes && AC_DEFINE(HAVE_SYS_TIME_SELECT)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_TYPEOF_CHTYPE version: 4 updated: 2000/10/04 09:18:40
+dnl ----------------
 dnl Determine the type we should use for chtype (and attr_t, which is treated
 dnl as the same thing).  We want around 32 bits, so on most machines want a
 dnl long, but on newer 64-bit machines, probably want an int.  If we're using
@@ -2835,6 +2974,8 @@
 
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_TYPE_SIGACTION version: 3 updated: 2000/08/12 23:18:52
+dnl -----------------
 dnl
 AC_DEFUN([CF_TYPE_SIGACTION],
 [
@@ -2849,6 +2990,8 @@
 test "$cf_cv_type_sigaction" = yes && AC_DEFINE(HAVE_TYPE_SIGACTION)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_UNSIGNED_LITERALS version: 2 updated: 1998/02/07 22:10:16
+dnl --------------------
 dnl Test if the compiler supports 'U' and 'L' suffixes.  Only old compilers
 dnl won't, but they're still there.
 AC_DEFUN([CF_UNSIGNED_LITERALS],
@@ -2862,6 +3005,8 @@
 AC_MSG_RESULT($cf_cv_unsigned_literals)
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_UPPER version: 5 updated: 2001/01/29 23:40:59
+dnl --------
 dnl Make an uppercase version of a variable
 dnl $1=uppercase($2)
 AC_DEFUN([CF_UPPER],
@@ -2869,11 +3014,151 @@
 $1=`echo "$2" | sed y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%`
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_VERBOSE version: 2 updated: 1997/09/05 10:45:14
+dnl ----------
 dnl Use AC_VERBOSE w/o the warnings
 AC_DEFUN([CF_VERBOSE],
 [test -n "$verbose" && echo "	$1" 1>&AC_FD_MSG
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_WCHAR_TYPE version: 1 updated: 2003/03/22 19:13:43
+dnl -------------
+dnl Check if type wide-character type $1 is declared, and if so, which header
+dnl file is needed.  The second parameter is used to set a shell variable when
+dnl the type is not found.  The first parameter sets a shell variable for the
+dnl opposite sense.
+AC_DEFUN([CF_WCHAR_TYPE],
+[
+# This is needed on Tru64 5.0 to declare $1
+AC_CACHE_CHECK(if we must include wchar.h to declare $1,cf_cv_$1,[
+AC_TRY_COMPILE([
+#include <stdlib.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif],
+	[$1 state],
+	[cf_cv_$1=no],
+	[AC_TRY_COMPILE([
+#include <stdlib.h>
+#include <wchar.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif],
+	[$1 value],
+	[cf_cv_$1=yes],
+	[cf_cv_$1=unknown])])])
+
+if test "$cf_cv_$1" = yes ; then
+	AC_DEFINE(NEED_WCHAR_H)
+	NEED_WCHAR_H=1
+fi
+
+ifelse($2,,,[
+# if we do not find $1 in either place, use substitution to provide a fallback.
+if test "$cf_cv_$1" = unknown ; then
+	$2=1
+fi
+])
+ifelse($3,,,[
+# if we find $1 in either place, use substitution to provide a fallback.
+if test "$cf_cv_$1" != unknown ; then
+	$3=1
+fi
+])
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_WITH_DBMALLOC version: 2 updated: 2002/12/29 21:11:45
+dnl ----------------
+dnl Configure-option for dbmalloc
+AC_DEFUN([CF_WITH_DBMALLOC],[
+AC_MSG_CHECKING(if you want to link with dbmalloc for testing)
+AC_ARG_WITH(dbmalloc,
+	[  --with-dbmalloc         test: use Conor Cahill's dbmalloc library],
+	[with_dbmalloc=$withval],
+	[with_dbmalloc=no])
+AC_MSG_RESULT($with_dbmalloc)
+if test $with_dbmalloc = yes ; then
+	AC_CHECK_LIB(dbmalloc,debug_malloc)
+fi
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_WITH_DMALLOC version: 2 updated: 2002/12/29 21:11:45
+dnl ---------------
+dnl Configure-option for dmalloc
+AC_DEFUN([CF_WITH_DMALLOC],[
+AC_MSG_CHECKING(if you want to link with dmalloc for testing)
+AC_ARG_WITH(dmalloc,
+	[  --with-dmalloc          test: use Gray Watson's dmalloc library],
+	[with_dmalloc=$withval],
+	[with_dmalloc=no])
+AC_MSG_RESULT($with_dmalloc)
+if test $with_dmalloc = yes ; then
+	AC_CHECK_LIB(dmalloc,dmalloc_debug)
+fi
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_WITH_LIBTOOL version: 6 updated: 2003/06/07 17:05:45
+dnl ---------------
+dnl Provide a configure option to incorporate libtool.  Define several useful
+dnl symbols for the makefile rules.
+AC_DEFUN([CF_WITH_LIBTOOL],
+[
+LIBTOOL=
+LIB_CREATE='$(AR) -cr'
+LIB_OBJECT='$(OBJECTS)'
+LIB_SUFFIX=.a
+LIB_INSTALL=
+LIB_UNINSTALL=
+LIB_PREP="$RANLIB"
+
+AC_MSG_CHECKING(if you want to build libraries with libtool)
+AC_ARG_WITH(libtool,
+	[  --with-libtool          generate libraries with libtool],
+	[with_libtool=$withval],
+	[with_libtool=no])
+AC_MSG_RESULT($with_libtool)
+if test "$with_libtool" = "yes"; then
+	AC_PATH_PROG(LIBTOOL,libtool)
+	if test -z "$LIBTOOL" ; then
+		AC_MSG_ERROR(Cannot find libtool)
+	fi
+
+	LIB_CREATE='$(LIBTOOL) --mode=link $(CC) -rpath $(DESTDIR)$(libdir) -version-info `cut -f1 $(srcdir)/VERSION` -o'
+	LIB_OBJECT='$(OBJECTS:.o=.lo)'
+	LIB_SUFFIX=.la
+	LIB_INSTALL='$(LIBTOOL) --mode=install'
+	LIB_UNINSTALL='$(LIBTOOL) --mode=uninstall'
+	LIB_PREP=:
+
+	# Show the version of libtool
+	AC_MSG_CHECKING(version of libtool)
+
+	# Save the version in a cache variable - this is not entirely a good
+	# thing, but the version string from libtool is very ugly, and for
+	# bug reports it might be useful to have the original string.
+	cf_cv_libtool_version=`$LIBTOOL --version 2>&1 | sed -e 's/^[[^1-9]]*//' -e 's/[[^0-9.]].*//'`
+	AC_MSG_RESULT($cf_cv_libtool_version)
+	if test -z "$cf_cv_libtool_version" ; then
+		AC_MSG_ERROR(This is not libtool)
+	fi
+else
+	LIBTOOL=""
+fi
+
+test -z "$LIBTOOL" && ECHO_LT=
+
+AC_SUBST(LIBTOOL)
+AC_SUBST(LIB_CREATE)
+AC_SUBST(LIB_OBJECT)
+AC_SUBST(LIB_SUFFIX)
+AC_SUBST(LIB_INSTALL)
+AC_SUBST(LIB_UNINSTALL)
+AC_SUBST(LIB_PREP)
+
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_WITH_PATH version: 6 updated: 1998/10/11 00:40:17
+dnl ------------
 dnl Wrapper for AC_ARG_WITH to ensure that user supplies a pathname, not just
 dnl defaulting to yes/no.
 dnl
@@ -2891,6 +3176,8 @@
 AC_SUBST($3)dnl
 ])dnl
 dnl ---------------------------------------------------------------------------
+dnl CF_WITH_PATHLIST version: 5 updated: 2001/12/10 01:28:30
+dnl ----------------
 dnl Process an option specifying a list of colon-separated paths.
 dnl
 dnl $1 = option name
@@ -2929,4 +3216,34 @@
 eval '$3="$cf_dst_path"'
 AC_SUBST($3)dnl
 
+])dnl
+dnl ---------------------------------------------------------------------------
+dnl CF_WITH_SYSMOUSE version: 2 updated: 2003/03/22 19:13:43
+dnl ----------------
+dnl If we can compile with sysmouse, make it available unless it is not wanted.
+AC_DEFUN([CF_WITH_SYSMOUSE],[
+# not everyone has "test -c"
+if test -c /dev/sysmouse 2>/dev/null ; then
+AC_MSG_CHECKING(if you want to use sysmouse)
+AC_ARG_WITH(sysmouse,
+	[  --with-sysmouse         use sysmouse (FreeBSD console)],
+	[cf_with_sysmouse=$withval],
+	[cf_with_sysmouse=maybe])
+	if test "$cf_with_sysmouse" != no ; then
+	AC_TRY_COMPILE([
+#include <osreldate.h>
+#if (__FreeBSD_version >= 400017)
+#include <sys/consio.h>
+#include <sys/fbio.h>
+#else
+#include <machine/console.h>
+#endif
+],[
+	struct mouse_info the_mouse;
+	ioctl(0, CONS_MOUSECTL, &the_mouse);
+],[cf_with_sysmouse=yes],[cf_with_sysmouse=no])
+	fi
+AC_MSG_RESULT($cf_with_sysmouse)
+test "$cf_with_sysmouse" = yes && AC_DEFINE(USE_SYSMOUSE)
+fi
 ])dnl
Index: announce.html.in
Prereq:  1.44 
--- ncurses-5.3-20021012/announce.html.in	Sat Oct 12 19:35:32 2002
+++ ncurses-5.3-20030719/announce.html.in	Sat Oct 19 17:46:46 2002
@@ -1,11 +1,12 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 3.0//EN">
 <!--
-  $Id: announce.html.in,v 1.44 2002/10/12 23:35:32 tom Exp $
+  $Id: announce.html.in,v 1.48 2002/10/19 21:46:46 tom Exp $
 -->
 <HTML>
 <HEAD>
-<TITLE>Announcing ncurses @VERSION@ Pre-Release</TITLE>
+<TITLE>Announcing ncurses @VERSION@</TITLE>
 <link rev=made href="mailto:bug-ncurses@gnu.org">
+<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
 </HEAD>
 <BODY>
 
@@ -35,9 +36,9 @@
 
 The ncurses distribution is available via anonymous FTP at
 the GNU distribution site
-<A HREF="ftp://ftp.gnu.org/pub/gnu/ncurses">ftp://ftp.gnu.org/pub/gnu/ncurses</A>.
+<A HREF="ftp://ftp.gnu.org/gnu/ncurses/">ftp://ftp.gnu.org/gnu/ncurses/</A>&nbsp;.
 <br>It is also available at
-<A HREF="ftp://invisible-island.net/ncurses">ftp://invisible-island.net/ncurses</A>.
+<A HREF="ftp://invisible-island.net/ncurses/">ftp://invisible-island.net/ncurses/</A>&nbsp;.
 
 <H1>Release Notes</H1>
 
@@ -317,61 +318,61 @@
 <DT> cdk
 <DD> Curses Development Kit
 <br>
-<A HREF="http://invisible-island.net/cdk/cdk.html">http://invisible-island.net/cdk</A>.
+<A HREF="http://invisible-island.net/cdk/">http://invisible-island.net/cdk/</A>
 <br>
-<A HREF="http://www.vexus.ca/CDK.html">http://www.vexus.ca/CDK.html</a>
+<A HREF="http://www.vexus.ca/products/CDK/">http://www.vexus.ca/products/CDK/</a>
 <DT> ded
 <DD> directory-editor
 <br>
-<A HREF="http://invisible-island.net/ded/ded.html">http://invisible-island.net/ded</A>.
+<A HREF="http://invisible-island.net/ded/">http://invisible-island.net/ded/</A>
 <DT> dialog
 <DD> the underlying application used in Slackware's setup, and the basis
 for similar applications on GNU/Linux.
 <br>
-<A HREF="http://invisible-island.net/dialog/dialog.html">http://invisible-island.net/dialog</A>.
+<A HREF="http://invisible-island.net/dialog/">http://invisible-island.net/dialog/</A>
 <DT> lynx
 <DD> the character-screen WWW browser
 <br>
-<A HREF="http://lynx.isc.org/release/">http://lynx.isc.org/release</A>.
+<A HREF="http://lynx.isc.org/release/">http://lynx.isc.org/release/</A>
 <DT> Midnight Commander
 <DD> file manager
 <br>
-<A HREF="www.gnome.org/mc/">www.gnome.org/mc/</A>.
+<A HREF="http://www.ibiblio.org/mc/">http://www.ibiblio.org/mc/</A>
 <DT> mutt
 <DD> mail utility
 <br>
-<A HREF="http://www.mutt.org">http://www.mutt.org</A>.
+<A HREF="http://www.mutt.org/">http://www.mutt.org/</A>
 <DT> ncftp
 <DD> file-transfer utility
 <br>
-<A HREF="http://www.ncftp.com">http://www.ncftp.com</A>.
+<A HREF="http://www.ncftp.com/">http://www.ncftp.com/</A>
 <DT> nvi
 <DD> New vi versions 1.50 are able to use ncurses versions 1.9.7 and later.
 <br>
-<A HREF="http://www.bostic.com/vi/">http://www.bostic.com/vi/</A>.
+<A HREF="http://www.bostic.com/vi/">http://www.bostic.com/vi/</A>
 <DT> tin
 <DD> newsreader, supporting color, MIME
 <br>
-<A HREF="http://www.tin.org">http://www.tin.org</A>.
+<A HREF="http://www.tin.org/">http://www.tin.org/</A>
 <DT> taper
 <DD> tape archive utility
 <br>
-<A HREF="http://members.iinet.net.au/~yusuf/taper/">http://members.iinet.net.au/~yusuf/taper/</A>.
+<A HREF="http://taper.e-survey.net.au/">http://taper.e-survey.net.au/</A>
 <DT> vh-1.6
 <DD> Volks-Hypertext browser for the Jargon File
 <br>
-<A HREF="http://www.bg.debian.org/Packages/unstable/text/vh.html">http://www.bg.debian.org/Packages/unstable/text/vh.html</A>.
+<A HREF="http://www.debian.org/Packages/unstable/text/vh.html">http://www.debian.org/Packages/unstable/text/vh.html</A>
 </DL>
 as well as some that use ncurses for the terminfo support alone:
 <DL>
 <DT> minicom
 <DD> terminal emulator
 <br>
-<A HREF="http://www.pp.clinet.fi/~walker/minicom.html">http://www.pp.clinet.fi/~walker/minicom.html</A>.
+<A HREF="http://www.netsonic.fi/~walker/minicom.html">http://www.netsonic.fi/~walker/minicom.html</A>
 <DT> vile
 <DD> vi-like-emacs
 <br>
-<A HREF="http://invisible-island.net/vile/vile.html">http://invisible-island.net/vile</A>.
+<A HREF="http://invisible-island.net/vile/">http://invisible-island.net/vile/</A>
 </DL>
 <P>
 
@@ -382,7 +383,7 @@
 
 The original developers of ncurses are <A
 HREF="mailto:zmbenhal@netcom.com">Zeyd Ben-Halim</A> and
-<A HREF="http://www.ccil.org/~esr/home.html">Eric S. Raymond</A>.
+<A HREF="http://www.tuxedo.org/~esr/">Eric S. Raymond</A>.
 Ongoing work is being done by
 <A HREF="mailto:dickey@herndon4.his.com">Thomas Dickey</A>
 and
@@ -404,7 +405,7 @@
 testing of this package.<P>
 
 Beta versions of ncurses and patches to the current release are made available at
-<A HREF="ftp://invisible-island.net/ncurses">ftp://invisible-island.net/ncurses</A>.
+<A HREF="ftp://invisible-island.net/ncurses/">ftp://invisible-island.net/ncurses/</A>&nbsp;.
 
 <H2>Future Plans</H2>
 <UL>
@@ -418,12 +419,12 @@
 
 The distribution includes and uses a version of the terminfo-format
 terminal description file maintained by Eric Raymond.
-<A HREF="http://earthspace.net/~esr/terminfo">http://earthspace.net/~esr/terminfo</A>.<P>
+<A HREF="http://www.tuxedo.org/~esr/terminfo/">http://www.tuxedo.org/~esr/terminfo/</A>&nbsp;.<P>
 
 You can find lots of information on terminal-related topics
 not covered in the terminfo file at
 <A HREF="http://www.cs.utk.edu/~shuford/terminal_index.html">Richard Shuford's
-archive</A>.
+archive</A>&nbsp;.
 </BODY>
 </HTML>
 <!--
Index: c++/Makefile.in
Prereq:  1.64 
--- ncurses-5.3-20021012/c++/Makefile.in	Sat Jan 19 15:25:31 2002
+++ ncurses-5.3-20030719/c++/Makefile.in	Sat Jun  7 17:09:50 2003
@@ -1,6 +1,6 @@
-# $Id: Makefile.in,v 1.64 2002/01/19 20:25:31 NIIBE.Yutaka Exp $
+# $Id: Makefile.in,v 1.68 2003/06/07 21:09:50 tom Exp $
 ##############################################################################
-# Copyright (c) 1998,1999,2000,2001,2002 Free Software Foundation, Inc.      #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -58,7 +58,7 @@
 
 CXX_AR		= @CXX_AR@
 CXX_AR_OPTS	= @CXX_AR_OPTS@
-RANLIB		= @RANLIB@
+RANLIB		= @LIB_PREP@
 
 CXX		= @CXX@
 CPP		= @CPP@
@@ -84,6 +84,8 @@
 ABI_VERSION	= @cf_cv_abi_version@
 
 LINK		= @LINK_PROGS@ $(LIBTOOL) $(CXX) @CXXLDFLAGS@
+SHLIB_DIRS	= -L../lib
+SHLIB_LIST	= $(SHLIB_DIRS) -lncurses@LIB_SUFFIX@ @SHLIB_LIST@
 
 LIBROOT		= ncurses++
 
@@ -102,11 +104,11 @@
 LDFLAGS		= @TEST_ARGS@ @LDFLAGS@ \
 	@LD_MODEL@ @LIBS@ @EXTRA_LIBS@ @LOCAL_LDFLAGS@ $(CXXLIBS)
 
-LDFLAGS_LIBTOOL	= $(LDFLAGS)
-LDFLAGS_NORMAL	= $(LDFLAGS)
-LDFLAGS_DEBUG	= $(LDFLAGS) @CC_G_OPT@
-LDFLAGS_PROFILE	= $(LDFLAGS) -pg
-LDFLAGS_SHARED	= $(LDFLAGS) @LD_SHARED_OPTS@
+LDFLAGS_LIBTOOL	= $(LDFLAGS) $(CFLAGS_LIBTOOL)
+LDFLAGS_NORMAL	= $(LDFLAGS) $(CFLAGS_NORMAL)
+LDFLAGS_DEBUG	= $(LDFLAGS) $(CFLAGS_DEBUG)
+LDFLAGS_PROFILE	= $(LDFLAGS) $(CFLAGS_PROFILE)
+LDFLAGS_SHARED	= $(LDFLAGS) $(CFLAGS_SHARED) @LD_SHARED_OPTS@
 
 LDFLAGS_DEFAULT	= $(LINK_@DFT_UPR_MODEL@) $(LDFLAGS_@DFT_UPR_MODEL@)
 
@@ -142,7 +144,7 @@
 ../lib/$(LIBNAME_LIBTOOL) : $(LIB_OBJS)
 	cd ../lib && $(LIBTOOL) $(CXX) -o $(LIBNAME) $(LIB_OBJS:.o=.lo) \
 		-rpath $(INSTALL_PREFIX)$(libdir) \
-		-version-info $(NCURSES_MAJOR):$(NCURSES_MINOR)
+		-version-info $(NCURSES_MAJOR):$(NCURSES_MINOR) $(SHLIB_LIST)
 
 OBJS_DEMO = $(MODEL)/demo.o
 
Index: c++/cursesmain.cc
Prereq:  1.9 
--- ncurses-5.3-20021012/c++/cursesmain.cc	Sat Jul  6 11:47:52 2002
+++ ncurses-5.3-20030719/c++/cursesmain.cc	Sat Jun  7 19:39:54 2003
@@ -1,6 +1,6 @@
 // * this is for making emacs happy: -*-Mode: C++;-*-
 /****************************************************************************
- * Copyright (c) 1998,2001 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -35,14 +35,22 @@
 #include "internal.h"
 #include "cursesapp.h"
 
-MODULE_ID("$Id: cursesmain.cc,v 1.9 2002/07/06 15:47:52 juergen Exp $")
+MODULE_ID("$Id: cursesmain.cc,v 1.10 2003/06/07 23:39:54 tom Exp $")
+
+#if HAVE_LOCALE_H
+#include <locale.h>
+#else
+#define setlocale(name,string) /* nothing */
+#endif
 
 /* This is the default implementation of main() for a NCursesApplication.
  * You only have to instantiate a static NCursesApplication object in your
  * main application source file and link this module with your application.
- */ 
+ */
 int main(int argc, char* argv[])
 {
+  setlocale(LC_ALL, "");
+
   NCursesApplication* A = NCursesApplication::getApplication();
   if (!A)
     return(1);
Index: config.guess
--- ncurses-5.3-20021012/config.guess	Sat Aug 31 15:53:33 2002
+++ ncurses-5.3-20030719/config.guess	Sat Jul 12 15:09:50 2003
@@ -1,9 +1,9 @@
 #! /bin/sh
 # Attempt to guess a canonical system name.
 #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
-#   2000, 2001, 2002 Free Software Foundation, Inc.
+#   2000, 2001, 2002, 2003 Free Software Foundation, Inc.
 
-timestamp='2002-08-23'
+timestamp='2003-07-02'
 
 # This file is free software; you can redistribute it and/or modify it
 # under the terms of the GNU General Public License as published by
@@ -98,30 +98,32 @@
 # Historically, `CC_FOR_BUILD' used to be named `HOST_CC'. We still
 # use `HOST_CC' if defined, but it is deprecated.
 
-# This shell variable is my proudest work .. or something. --bje
+# Portable tmp directory creation inspired by the Autoconf team.
 
-set_cc_for_build='tmpdir=${TMPDIR-/tmp}/config-guess-$$ ;
-(old=`umask` && umask 077 && mkdir $tmpdir && umask $old && unset old)
-   || (echo "$me: cannot create $tmpdir" >&2 && exit 1) ;
-dummy=$tmpdir/dummy ;
-files="$dummy.c $dummy.o $dummy.rel $dummy" ;
-trap '"'"'rm -f $files; rmdir $tmpdir; exit 1'"'"' 1 2 15 ;
+set_cc_for_build='
+trap "exitcode=\$?; (rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null) && exit \$exitcode" 0 ;
+trap "rm -f \$tmpfiles 2>/dev/null; rmdir \$tmp 2>/dev/null; exit 1" 1 2 13 15 ;
+: ${TMPDIR=/tmp} ;
+ { tmp=`(umask 077 && mktemp -d -q "$TMPDIR/cgXXXXXX") 2>/dev/null` && test -n "$tmp" && test -d "$tmp" ; } ||
+ { test -n "$RANDOM" && tmp=$TMPDIR/cg$$-$RANDOM && (umask 077 && mkdir $tmp) ; } ||
+ { tmp=$TMPDIR/cg-$$ && (umask 077 && mkdir $tmp) && echo "Warning: creating insecure temp directory" >&2 ; } ||
+ { echo "$me: cannot create a temporary directory in $TMPDIR" >&2 ; exit 1 ; } ;
+dummy=$tmp/dummy ;
+tmpfiles="$dummy.c $dummy.o $dummy.rel $dummy" ;
 case $CC_FOR_BUILD,$HOST_CC,$CC in
  ,,)    echo "int x;" > $dummy.c ;
 	for c in cc gcc c89 c99 ; do
-	  if ($c $dummy.c -c -o $dummy.o) >/dev/null 2>&1 ; then
+	  if ($c -c -o $dummy.o $dummy.c) >/dev/null 2>&1 ; then
 	     CC_FOR_BUILD="$c"; break ;
 	  fi ;
 	done ;
-	rm -f $files ;
 	if test x"$CC_FOR_BUILD" = x ; then
 	  CC_FOR_BUILD=no_compiler_found ;
 	fi
 	;;
  ,,*)   CC_FOR_BUILD=$CC ;;
  ,*,*)  CC_FOR_BUILD=$HOST_CC ;;
-esac ;
-unset files'
+esac ;'
 
 # This is needed to find uname on a Pyramid OSx when run in the BSD universe.
 # (ghazi@noc.rutgers.edu 1994-08-24)
@@ -178,7 +180,18 @@
 		;;
 	esac
 	# The OS release
-	release=`echo ${UNAME_RELEASE}|sed -e 's/[-_].*/\./'`
+	# Debian GNU/NetBSD machines have a different userland, and
+	# thus, need a distinct triplet. However, they do not need
+	# kernel version information, so it can be replaced with a
+	# suitable tag, in the style of linux-gnu.
+	case "${UNAME_VERSION}" in
+	    Debian*)
+		release='-gnu'
+		;;
+	    *)
+		release=`echo ${UNAME_RELEASE}|sed -e 's/[-_].*/\./'`
+		;;
+	esac
 	# Since CPU_TYPE-MANUFACTURER-KERNEL-OPERATING_SYSTEM:
 	# contains redundant information, the shorter form:
 	# CPU_TYPE-MANUFACTURER-OPERATING_SYSTEM is used.
@@ -227,68 +240,52 @@
 	if test $UNAME_RELEASE = "V4.0"; then
 		UNAME_RELEASE=`/usr/sbin/sizer -v | awk '{print $3}'`
 	fi
+	# According to Compaq, /usr/sbin/psrinfo has been available on
+	# OSF/1 and Tru64 systems produced since 1995.  I hope that
+	# covers most systems running today.  This code pipes the CPU
+	# types through head -n 1, so we only detect the type of CPU 0.
+	ALPHA_CPU_TYPE=`/usr/sbin/psrinfo -v | sed -n -e 's/^  The alpha \(.*\) processor.*$/\1/p' | head -n 1`
+	case "$ALPHA_CPU_TYPE" in
+	    "EV4 (21064)")
+		UNAME_MACHINE="alpha" ;;
+	    "EV4.5 (21064)")
+		UNAME_MACHINE="alpha" ;;
+	    "LCA4 (21066/21068)")
+		UNAME_MACHINE="alpha" ;;
+	    "EV5 (21164)")
+		UNAME_MACHINE="alphaev5" ;;
+	    "EV5.6 (21164A)")
+		UNAME_MACHINE="alphaev56" ;;
+	    "EV5.6 (21164PC)")
+		UNAME_MACHINE="alphapca56" ;;
+	    "EV5.7 (21164PC)")
+		UNAME_MACHINE="alphapca57" ;;
+	    "EV6 (21264)")
+		UNAME_MACHINE="alphaev6" ;;
+	    "EV6.7 (21264A)")
+		UNAME_MACHINE="alphaev67" ;;
+	    "EV6.8CB (21264C)")
+		UNAME_MACHINE="alphaev68" ;;
+	    "EV6.8AL (21264B)")
+		UNAME_MACHINE="alphaev68" ;;
+	    "EV6.8CX (21264D)")
+		UNAME_MACHINE="alphaev68" ;;
+	    "EV6.9A (21264/EV69A)")
+		UNAME_MACHINE="alphaev69" ;;
+	    "EV7 (21364)")
+		UNAME_MACHINE="alphaev7" ;;
+	    "EV7.9 (21364A)")
+		UNAME_MACHINE="alphaev79" ;;
+	esac
 	# A Vn.n version is a released version.
 	# A Tn.n version is a released field test version.
 	# A Xn.n version is an unreleased experimental baselevel.
 	# 1.2 uses "1.2" for uname -r.
-	eval $set_cc_for_build
-	cat <<EOF >$dummy.s
-	.data
-\$Lformat:
-	.byte 37,100,45,37,120,10,0	# "%d-%x\n"
-
-	.text
-	.globl main
-	.align 4
-	.ent main
-main:
-	.frame \$30,16,\$26,0
-	ldgp \$29,0(\$27)
-	.prologue 1
-	.long 0x47e03d80 # implver \$0
-	lda \$2,-1
-	.long 0x47e20c21 # amask \$2,\$1
-	lda \$16,\$Lformat
-	mov \$0,\$17
-	not \$1,\$18
-	jsr \$26,printf
-	ldgp \$29,0(\$26)
-	mov 0,\$16
-	jsr \$26,exit
-	.end main
-EOF
-	$CC_FOR_BUILD $dummy.s -o $dummy 2>/dev/null
-	if test "$?" = 0 ; then
-		case `$dummy` in
-			0-0)
-				UNAME_MACHINE="alpha"
-				;;
-			1-0)
-				UNAME_MACHINE="alphaev5"
-				;;
-			1-1)
-				UNAME_MACHINE="alphaev56"
-				;;
-			1-101)
-				UNAME_MACHINE="alphapca56"
-				;;
-			2-303)
-				UNAME_MACHINE="alphaev6"
-				;;
-			2-307)
-				UNAME_MACHINE="alphaev67"
-				;;
-			2-1307)
-				UNAME_MACHINE="alphaev68"
-				;;
-			3-1307)
-				UNAME_MACHINE="alphaev7"
-				;;
-		esac
-	fi
-	rm -f $dummy.s $dummy && rmdir $tmpdir
 	echo ${UNAME_MACHINE}-dec-osf`echo ${UNAME_RELEASE} | sed -e 's/^[VTX]//' | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
 	exit 0 ;;
+    Alpha*:OpenVMS:*:*)
+	echo alpha-hp-vms
+	exit 0 ;;
     Alpha\ *:Windows_NT*:*)
 	# How do we know it's Interix rather than the generic POSIX subsystem?
 	# Should we change UNAME_MACHINE based on the output of uname instead
@@ -327,6 +324,9 @@
     NILE*:*:*:dcosx)
 	echo pyramid-pyramid-svr4
 	exit 0 ;;
+    DRS?6000:unix:4.0:6*)
+	echo sparc-icl-nx6
+	exit 0 ;;
     DRS?6000:UNIX_SV:4.2*:7*)
 	case `/usr/bin/uname -p` in
 	    sparc) echo sparc-icl-nx7 && exit 0 ;;
@@ -437,10 +437,9 @@
 	  exit (-1);
 	}
 EOF
-	$CC_FOR_BUILD $dummy.c -o $dummy \
+	$CC_FOR_BUILD -o $dummy $dummy.c \
 	  && $dummy `echo "${UNAME_RELEASE}" | sed -n 's/\([0-9]*\).*/\1/p'` \
-	  && rm -f $dummy.c $dummy && rmdir $tmpdir && exit 0
-	rm -f $dummy.c $dummy && rmdir $tmpdir
+	  && exit 0
 	echo mips-mips-riscos${UNAME_RELEASE}
 	exit 0 ;;
     Motorola:PowerMAX_OS:*:*)
@@ -449,7 +448,7 @@
     Motorola:*:4.3:PL8-*)
 	echo powerpc-harris-powermax
 	exit 0 ;;
-    Night_Hawk:*:*:PowerMAX_OS)
+    Night_Hawk:*:*:PowerMAX_OS | Synergy:PowerMAX_OS:*:*)
 	echo powerpc-harris-powermax
 	exit 0 ;;
     Night_Hawk:Power_UNIX:*:*)
@@ -524,8 +523,7 @@
 			exit(0);
 			}
 EOF
-		$CC_FOR_BUILD $dummy.c -o $dummy && $dummy && rm -f $dummy.c $dummy && rmdir $tmpdir && exit 0
-		rm -f $dummy.c $dummy && rmdir $tmpdir
+		$CC_FOR_BUILD -o $dummy $dummy.c && $dummy && exit 0
 		echo rs6000-ibm-aix3.2.5
 	elif grep bos324 /usr/include/stdio.h >/dev/null 2>&1; then
 		echo rs6000-ibm-aix3.2.4
@@ -623,11 +621,21 @@
                   exit (0);
               }
 EOF
-		    (CCOPTS= $CC_FOR_BUILD $dummy.c -o $dummy 2>/dev/null) && HP_ARCH=`$dummy`
-		    if test -z "$HP_ARCH"; then HP_ARCH=hppa; fi
-		    rm -f $dummy.c $dummy && rmdir $tmpdir
+		    (CCOPTS= $CC_FOR_BUILD -o $dummy $dummy.c 2>/dev/null) && HP_ARCH=`$dummy`
+		    test -z "$HP_ARCH" && HP_ARCH=hppa
 		fi ;;
 	esac
+	if [ ${HP_ARCH} = "hppa2.0w" ]
+	then
+	    # avoid double evaluation of $set_cc_for_build
+	    test -n "$CC_FOR_BUILD" || eval $set_cc_for_build
+	    if echo __LP64__ | (CCOPTS= $CC_FOR_BUILD -E -) | grep __LP64__ >/dev/null
+	    then
+		HP_ARCH="hppa2.0w"
+	    else
+		HP_ARCH="hppa64"
+	    fi
+	fi
 	echo ${HP_ARCH}-hp-hpux${HPUX_REV}
 	exit 0 ;;
     ia64:HP-UX:*:*)
@@ -661,8 +669,7 @@
 	  exit (0);
 	}
 EOF
-	$CC_FOR_BUILD $dummy.c -o $dummy && $dummy && rm -f $dummy.c $dummy && rmdir $tmpdir && exit 0
-	rm -f $dummy.c $dummy && rmdir $tmpdir
+	$CC_FOR_BUILD -o $dummy $dummy.c && $dummy && exit 0
 	echo unknown-hitachi-hiuxwe2
 	exit 0 ;;
     9000/7??:4.3bsd:*:* | 9000/8?[79]:4.3bsd:*:* )
@@ -720,15 +727,15 @@
     CRAY*TS:*:*:*)
 	echo t90-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
 	exit 0 ;;
-    CRAY*T3D:*:*:*)
-	echo alpha-cray-unicosmk${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
-	exit 0 ;;
     CRAY*T3E:*:*:*)
 	echo alphaev5-cray-unicosmk${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
 	exit 0 ;;
     CRAY*SV1:*:*:*)
 	echo sv1-cray-unicos${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/'
 	exit 0 ;;
+    *:UNICOS/mp:*:*)
+	echo nv1-cray-unicosmp${UNAME_RELEASE} | sed -e 's/\.[^.]*$/.X/' 
+	exit 0 ;;
     F30[01]:UNIX_System_V:*:* | F700:UNIX_System_V:*:*)
 	FUJITSU_PROC=`uname -m | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz'`
         FUJITSU_SYS=`uname -p | tr 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' 'abcdefghijklmnopqrstuvwxyz' | sed -e 's/\///'`
@@ -744,7 +751,7 @@
     *:BSD/OS:*:*)
 	echo ${UNAME_MACHINE}-unknown-bsdi${UNAME_RELEASE}
 	exit 0 ;;
-    *:FreeBSD:*:*)
+    *:FreeBSD:*:*|*:GNU/FreeBSD:*:*)
 	# Determine whether the default compiler uses glibc.
 	eval $set_cc_for_build
 	sed 's/^	//' << EOF >$dummy.c
@@ -756,8 +763,10 @@
 	#endif
 EOF
 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^LIBC=`
-	rm -f $dummy.c && rmdir $tmpdir
-	echo ${UNAME_MACHINE}-unknown-freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`${LIBC:+-$LIBC}
+	# GNU/FreeBSD systems have a "k" prefix to indicate we are using
+	# FreeBSD's kernel, but not the complete OS.
+	case ${LIBC} in gnu) kernel_only='k' ;; esac
+	echo ${UNAME_MACHINE}-unknown-${kernel_only}freebsd`echo ${UNAME_RELEASE}|sed -e 's/[-(].*//'`${LIBC:+-$LIBC}
 	exit 0 ;;
     i*:CYGWIN*:*)
 	echo ${UNAME_MACHINE}-pc-cygwin
@@ -768,14 +777,17 @@
     i*:PW*:*)
 	echo ${UNAME_MACHINE}-pc-pw32
 	exit 0 ;;
-    x86:Interix*:3*)
-	echo i386-pc-interix3
+    x86:Interix*:[34]*)
+	echo i586-pc-interix${UNAME_RELEASE}|sed -e 's/\..*//'
+	exit 0 ;;
+    [345]86:Windows_95:* | [345]86:Windows_98:* | [345]86:Windows_NT:*)
+	echo i${UNAME_MACHINE}-pc-mks
 	exit 0 ;;
     i*:Windows_NT*:* | Pentium*:Windows_NT*:*)
 	# How do we know it's Interix rather than the generic POSIX subsystem?
 	# It also conflicts with pre-2.0 versions of AT&T UWIN. Should we
 	# UNAME_MACHINE based on the output of uname instead of i386?
-	echo i386-pc-interix
+	echo i586-pc-interix
 	exit 0 ;;
     i*:UWIN*:*)
 	echo ${UNAME_MACHINE}-pc-uwin
@@ -795,6 +807,9 @@
     arm*:Linux:*:*)
 	echo ${UNAME_MACHINE}-unknown-linux-gnu
 	exit 0 ;;
+    cris:Linux:*:*)
+	echo cris-axis-linux-gnu
+	exit 0 ;;
     ia64:Linux:*:*)
 	echo ${UNAME_MACHINE}-unknown-linux-gnu
 	exit 0 ;;
@@ -818,8 +833,26 @@
 	#endif
 EOF
 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^CPU=`
-	rm -f $dummy.c && rmdir $tmpdir
-	test x"${CPU}" != x && echo "${CPU}-pc-linux-gnu" && exit 0
+	test x"${CPU}" != x && echo "${CPU}-unknown-linux-gnu" && exit 0
+	;;
+    mips64:Linux:*:*)
+	eval $set_cc_for_build
+	sed 's/^	//' << EOF >$dummy.c
+	#undef CPU
+	#undef mips64
+	#undef mips64el
+	#if defined(__MIPSEL__) || defined(__MIPSEL) || defined(_MIPSEL) || defined(MIPSEL)
+	CPU=mips64el
+	#else
+	#if defined(__MIPSEB__) || defined(__MIPSEB) || defined(_MIPSEB) || defined(MIPSEB)
+	CPU=mips64
+	#else
+	CPU=
+	#endif
+	#endif
+EOF
+	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^CPU=`
+	test x"${CPU}" != x && echo "${CPU}-unknown-linux-gnu" && exit 0
 	;;
     ppc:Linux:*:*)
 	echo powerpc-unknown-linux-gnu
@@ -855,6 +888,9 @@
     s390:Linux:*:* | s390x:Linux:*:*)
 	echo ${UNAME_MACHINE}-ibm-linux
 	exit 0 ;;
+    sh64*:Linux:*:*)
+    	echo ${UNAME_MACHINE}-unknown-linux-gnu
+	exit 0 ;;
     sh*:Linux:*:*)
 	echo ${UNAME_MACHINE}-unknown-linux-gnu
 	exit 0 ;;
@@ -914,7 +950,6 @@
 	#endif
 EOF
 	eval `$CC_FOR_BUILD -E $dummy.c 2>/dev/null | grep ^LIBC=`
-	rm -f $dummy.c && rmdir $tmpdir
 	test x"${LIBC}" != x && echo "${UNAME_MACHINE}-pc-linux-${LIBC}" && exit 0
 	test x"${TENTATIVE}" != x && echo "${TENTATIVE}" && exit 0
 	;;
@@ -932,6 +967,23 @@
         # Use sysv4.2uw... so that sysv4* matches it.
 	echo ${UNAME_MACHINE}-pc-sysv4.2uw${UNAME_VERSION}
 	exit 0 ;;
+    i*86:OS/2:*:*)
+	# If we were able to find `uname', then EMX Unix compatibility
+	# is probably installed.
+	echo ${UNAME_MACHINE}-pc-os2-emx
+	exit 0 ;;
+    i*86:XTS-300:*:STOP)
+	echo ${UNAME_MACHINE}-unknown-stop
+	exit 0 ;;
+    i*86:atheos:*:*)
+	echo ${UNAME_MACHINE}-unknown-atheos
+	exit 0 ;;
+    i*86:LynxOS:2.*:* | i*86:LynxOS:3.[01]*:* | i*86:LynxOS:4.0*:*)
+	echo i386-unknown-lynxos${UNAME_RELEASE}
+	exit 0 ;;
+    i*86:*DOS:*:*)
+	echo ${UNAME_MACHINE}-pc-msdosdjgpp
+	exit 0 ;;
     i*86:*:4.*:* | i*86:SYSTEM_V:4.*:*)
 	UNAME_REL=`echo ${UNAME_RELEASE} | sed 's/\/MP$//'`
 	if grep Novell /usr/include/link.h >/dev/null 2>/dev/null; then
@@ -966,9 +1018,6 @@
 		echo ${UNAME_MACHINE}-pc-sysv32
 	fi
 	exit 0 ;;
-    i*86:*DOS:*:*)
-	echo ${UNAME_MACHINE}-pc-msdosdjgpp
-	exit 0 ;;
     pc:*:*:*)
 	# Left here for compatibility:
         # uname -m prints for DJGPP always 'pc', but it prints nothing about
@@ -995,9 +1044,12 @@
     mc68k:UNIX:SYSTEM5:3.51m)
 	echo m68k-convergent-sysv
 	exit 0 ;;
+    M680?0:D-NIX:5.3:*)
+	echo m68k-diab-dnix
+	exit 0 ;;
     M68*:*:R3V[567]*:*)
 	test -r /sysV68 && echo 'm68k-motorola-sysv' && exit 0 ;;
-    3[34]??:*:4.0:3.0 | 3[34]??A:*:4.0:3.0 | 3[34]??,*:*:4.0:3.0 | 3[34]??/*:*:4.0:3.0 | 4400:*:4.0:3.0 | 4850:*:4.0:3.0 | SKA40:*:4.0:3.0)
+    3[34]??:*:4.0:3.0 | 3[34]??A:*:4.0:3.0 | 3[34]??,*:*:4.0:3.0 | 3[34]??/*:*:4.0:3.0 | 4400:*:4.0:3.0 | 4850:*:4.0:3.0 | SKA40:*:4.0:3.0 | SDS2:*:4.0:3.0 | SHG2:*:4.0:3.0)
 	OS_REL=''
 	test -r /etc/.relid \
 	&& OS_REL=.`sed -n 's/[^ ]* [^ ]* \([0-9][0-9]\).*/\1/p' < /etc/.relid`
@@ -1014,9 +1066,6 @@
     mc68030:UNIX_System_V:4.*:*)
 	echo m68k-atari-sysv4
 	exit 0 ;;
-    i*86:LynxOS:2.*:* | i*86:LynxOS:3.[01]*:* | i*86:LynxOS:4.0*:*)
-	echo i386-unknown-lynxos${UNAME_RELEASE}
-	exit 0 ;;
     TSUNAMI:LynxOS:2.*:*)
 	echo sparc-unknown-lynxos${UNAME_RELEASE}
 	exit 0 ;;
@@ -1098,7 +1147,11 @@
 	echo ${UNAME_MACHINE}-apple-rhapsody${UNAME_RELEASE}
 	exit 0 ;;
     *:Darwin:*:*)
-	echo `uname -p`-apple-darwin${UNAME_RELEASE}
+	case `uname -p` in
+	    *86) UNAME_PROCESSOR=i686 ;;
+	    powerpc) UNAME_PROCESSOR=powerpc ;;
+	esac
+	echo ${UNAME_PROCESSOR}-apple-darwin${UNAME_RELEASE}
 	exit 0 ;;
     *:procnto*:*:* | *:QNX:[0123456789]*:*)
 	UNAME_PROCESSOR=`uname -p`
@@ -1111,7 +1164,7 @@
     *:QNX:*:4*)
 	echo i386-pc-qnx
 	exit 0 ;;
-    NSR-[GKLNPTVW]:NONSTOP_KERNEL:*:*)
+    NSR-[DGKLNPTVW]:NONSTOP_KERNEL:*:*)
 	echo nsr-tandem-nsk${UNAME_RELEASE}
 	exit 0 ;;
     *:NonStop-UX:*:*)
@@ -1134,11 +1187,6 @@
 	fi
 	echo ${UNAME_MACHINE}-unknown-plan9
 	exit 0 ;;
-    i*86:OS/2:*:*)
-	# If we were able to find `uname', then EMX Unix compatibility
-	# is probably installed.
-	echo ${UNAME_MACHINE}-pc-os2-emx
-	exit 0 ;;
     *:TOPS-10:*:*)
 	echo pdp10-unknown-tops10
 	exit 0 ;;
@@ -1157,11 +1205,8 @@
     *:ITS:*:*)
 	echo pdp10-unknown-its
 	exit 0 ;;
-    i*86:XTS-300:*:STOP)
-	echo ${UNAME_MACHINE}-unknown-stop
-	exit 0 ;;
-    i*86:atheos:*:*)
-	echo ${UNAME_MACHINE}-unknown-atheos
+    SEI:*:*:SEIUX)
+        echo mips-sei-seiux${UNAME_RELEASE}
 	exit 0 ;;
 esac
 
@@ -1283,8 +1328,7 @@
 }
 EOF
 
-$CC_FOR_BUILD $dummy.c -o $dummy 2>/dev/null && $dummy && rm -f $dummy.c $dummy && rmdir $tmpdir && exit 0
-rm -f $dummy.c $dummy && rmdir $tmpdir
+$CC_FOR_BUILD -o $dummy $dummy.c 2>/dev/null && $dummy && exit 0
 
 # Apollos put the system type in the environment.
 
Index: config.sub
--- ncurses-5.3-20021012/config.sub	Sat Aug 31 15:53:19 2002
+++ ncurses-5.3-20030719/config.sub	Sat Jul 12 15:10:05 2003
@@ -1,9 +1,9 @@
 #! /bin/sh
 # Configuration validation subroutine script.
 #   Copyright (C) 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999,
-#   2000, 2001, 2002 Free Software Foundation, Inc.
+#   2000, 2001, 2002, 2003 Free Software Foundation, Inc.
 
-timestamp='2002-08-22'
+timestamp='2003-07-04'
 
 # This file is (in principle) common to ALL GNU software.
 # The presence of a machine in this file suggests that SOME GNU software
@@ -118,7 +118,7 @@
 # Here we must recognize all the valid KERNEL-OS combinations.
 maybe_os=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\2/'`
 case $maybe_os in
-  nto-qnx* | linux-gnu* | freebsd*-gnu* | storm-chaos* | os2-emx* | windows32-* | rtmk-nova*)
+  nto-qnx* | linux-gnu* | kfreebsd*-gnu* | netbsd*-gnu* | storm-chaos* | os2-emx* | rtmk-nova*)
     os=-$maybe_os
     basic_machine=`echo $1 | sed 's/^\(.*\)-\([^-]*-[^-]*\)$/\1/'`
     ;;
@@ -245,21 +245,23 @@
 	| mips64vr4300 | mips64vr4300el \
 	| mips64vr5000 | mips64vr5000el \
 	| mipsisa32 | mipsisa32el \
+	| mipsisa32r2 | mipsisa32r2el \
 	| mipsisa64 | mipsisa64el \
 	| mipsisa64sb1 | mipsisa64sb1el \
 	| mipsisa64sr71k | mipsisa64sr71kel \
 	| mipstx39 | mipstx39el \
 	| mn10200 | mn10300 \
+	| msp430 \
 	| ns16k | ns32k \
 	| openrisc | or32 \
 	| pdp10 | pdp11 | pj | pjl \
 	| powerpc | powerpc64 | powerpc64le | powerpcle | ppcbe \
 	| pyramid \
-	| sh | sh[1234] | sh3e | sh[34]eb | shbe | shle | sh[1234]le | sh3ele \
+	| sh | sh[1234] | sh[23]e | sh[34]eb | shbe | shle | sh[1234]le | sh3ele \
 	| sh64 | sh64le \
 	| sparc | sparc64 | sparc86x | sparclet | sparclite | sparcv9 | sparcv9b \
 	| strongarm \
-	| tahoe | thumb | tic80 | tron \
+	| tahoe | thumb | tic4x | tic80 | tron \
 	| v850 | v850e \
 	| we32k \
 	| x86 | xscale | xstormy16 | xtensa \
@@ -294,7 +296,7 @@
 	| arm-*  | armbe-* | armle-* | armeb-* | armv*-* \
 	| avr-* \
 	| bs2000-* \
-	| c[123]* | c30-* | [cjt]90-* | c54x-* \
+	| c[123]* | c30-* | [cjt]90-* | c4x-* | c54x-* | c55x-* | c6x-* \
 	| clipper-* | cydra-* \
 	| d10v-* | d30v-* | dlx-* \
 	| elxsi-* \
@@ -315,21 +317,25 @@
 	| mips64vr4300-* | mips64vr4300el-* \
 	| mips64vr5000-* | mips64vr5000el-* \
 	| mipsisa32-* | mipsisa32el-* \
+	| mipsisa32r2-* | mipsisa32r2el-* \
 	| mipsisa64-* | mipsisa64el-* \
 	| mipsisa64sb1-* | mipsisa64sb1el-* \
 	| mipsisa64sr71k-* | mipsisa64sr71kel-* \
-	| mipstx39 | mipstx39el \
-	| none-* | np1-* | ns16k-* | ns32k-* \
+	| mipstx39-* | mipstx39el-* \
+	| msp430-* \
+	| none-* | np1-* | nv1-* | ns16k-* | ns32k-* \
 	| orion-* \
 	| pdp10-* | pdp11-* | pj-* | pjl-* | pn-* | power-* \
 	| powerpc-* | powerpc64-* | powerpc64le-* | powerpcle-* | ppcbe-* \
 	| pyramid-* \
 	| romp-* | rs6000-* \
-	| sh-* | sh[1234]-* | sh3e-* | sh[34]eb-* | shbe-* \
+	| sh-* | sh[1234]-* | sh[23]e-* | sh[34]eb-* | shbe-* \
 	| shle-* | sh[1234]le-* | sh3ele-* | sh64-* | sh64le-* \
 	| sparc-* | sparc64-* | sparc86x-* | sparclet-* | sparclite-* \
 	| sparcv9-* | sparcv9b-* | strongarm-* | sv1-* | sx?-* \
-	| tahoe-* | thumb-* | tic30-* | tic54x-* | tic80-* | tron-* \
+	| tahoe-* | thumb-* \
+	| tic30-* | tic4x-* | tic54x-* | tic55x-* | tic6x-* | tic80-* \
+	| tron-* \
 	| v850-* | v850e-* | vax-* \
 	| we32k-* \
 	| x86-* | x86_64-* | xps100-* | xscale-* | xstormy16-* \
@@ -367,6 +373,9 @@
 		basic_machine=a29k-none
 		os=-bsd
 		;;
+	amd64)
+		basic_machine=x86_64-pc
+		;;
 	amdahl)
 		basic_machine=580-amdahl
 		os=-sysv
@@ -716,6 +725,10 @@
 	np1)
 		basic_machine=np1-gould
 		;;
+	nv1)
+		basic_machine=nv1-cray
+		os=-unicosmp
+		;;
 	nsr-tandem)
 		basic_machine=nsr-tandem
 		;;
@@ -758,18 +771,24 @@
 	pentiumpro | p6 | 6x86 | athlon | athlon_*)
 		basic_machine=i686-pc
 		;;
-	pentiumii | pentium2)
+	pentiumii | pentium2 | pentiumiii | pentium3)
 		basic_machine=i686-pc
 		;;
+	pentium4)
+		basic_machine=i786-pc
+		;;
 	pentium-* | p5-* | k5-* | k6-* | nexgen-* | viac3-*)
 		basic_machine=i586-`echo $basic_machine | sed 's/^[^-]*-//'`
 		;;
 	pentiumpro-* | p6-* | 6x86-* | athlon-*)
 		basic_machine=i686-`echo $basic_machine | sed 's/^[^-]*-//'`
 		;;
-	pentiumii-* | pentium2-*)
+	pentiumii-* | pentium2-* | pentiumiii-* | pentium3-*)
 		basic_machine=i686-`echo $basic_machine | sed 's/^[^-]*-//'`
 		;;
+	pentium4-*)
+		basic_machine=i786-`echo $basic_machine | sed 's/^[^-]*-//'`
+		;;
 	pn)
 		basic_machine=pn-gould
 		;;
@@ -828,6 +847,10 @@
 	sb1el)
 		basic_machine=mipsisa64sb1el-unknown
 		;;
+	sei)
+		basic_machine=mips-sei
+		os=-seiux
+		;;
 	sequent)
 		basic_machine=i386-sequent
 		;;
@@ -835,6 +858,9 @@
 		basic_machine=sh-hitachi
 		os=-hms
 		;;
+	sh64)
+		basic_machine=sh64-unknown
+		;;
 	sparclite-wrs | simso-wrs)
 		basic_machine=sparclite-wrs
 		os=-vxworks
@@ -901,10 +927,6 @@
 		basic_machine=i386-sequent
 		os=-dynix
 		;;
-	t3d)
-		basic_machine=alpha-cray
-		os=-unicos
-		;;
 	t3e)
 		basic_machine=alphaev5-cray
 		os=-unicos
@@ -917,6 +939,14 @@
 		basic_machine=tic54x-unknown
 		os=-coff
 		;;
+	tic55x | c55x*)
+		basic_machine=tic55x-unknown
+		os=-coff
+		;;
+	tic6x | c6x*)
+		basic_machine=tic6x-unknown
+		os=-coff
+		;;
 	tx39)
 		basic_machine=mipstx39-unknown
 		;;
@@ -973,10 +1003,6 @@
 		basic_machine=hppa1.1-winbond
 		os=-proelf
 		;;
-	windows32)
-		basic_machine=i386-pc
-		os=-windows32-msvcrt
-		;;
 	xps | xps100)
 		basic_machine=xps100-honeywell
 		;;
@@ -1023,7 +1049,7 @@
 	we32k)
 		basic_machine=we32k-att
 		;;
-	sh3 | sh4 | sh3eb | sh4eb | sh[1234]le | sh3ele)
+	sh3 | sh4 | sh[34]eb | sh[1234]le | sh[23]ele)
 		basic_machine=sh-unknown
 		;;
 	sh64)
@@ -1047,10 +1073,6 @@
 	pmac | pmac-mpw)
 		basic_machine=powerpc-apple
 		;;
-	c4x*)
-		basic_machine=c4x-none
-		os=-coff
-		;;
 	*-unknown)
 		# Make sure to match an already-canonicalized machine name.
 		;;
@@ -1106,18 +1128,19 @@
 	      | -aos* \
 	      | -nindy* | -vxsim* | -vxworks* | -ebmon* | -hms* | -mvs* \
 	      | -clix* | -riscos* | -uniplus* | -iris* | -rtu* | -xenix* \
-	      | -hiux* | -386bsd* | -netbsd* | -openbsd* | -freebsd* | -riscix* \
+	      | -hiux* | -386bsd* | -netbsd* | -openbsd* | -kfreebsd* | -freebsd* | -riscix* \
 	      | -lynxos* | -bosx* | -nextstep* | -cxux* | -aout* | -elf* | -oabi* \
 	      | -ptx* | -coff* | -ecoff* | -winnt* | -domain* | -vsta* \
 	      | -udi* | -eabi* | -lites* | -ieee* | -go32* | -aux* \
 	      | -chorusos* | -chorusrdb* \
 	      | -cygwin* | -pe* | -psos* | -moss* | -proelf* | -rtems* \
 	      | -mingw32* | -linux-gnu* | -uxpv* | -beos* | -mpeix* | -udk* \
-	      | -interix* | -uwin* | -rhapsody* | -darwin* | -opened* \
+	      | -interix* | -uwin* | -mks* | -rhapsody* | -darwin* | -opened* \
 	      | -openstep* | -oskit* | -conix* | -pw32* | -nonstopux* \
 	      | -storm-chaos* | -tops10* | -tenex* | -tops20* | -its* \
 	      | -os2* | -vos* | -palmos* | -uclinux* | -nucleus* \
-	      | -morphos* | -superux* | -rtmk* | -rtmk-nova* | -windiss* | -powermax*)
+	      | -morphos* | -superux* | -rtmk* | -rtmk-nova* | -windiss* \
+	      | -powermax* | -dnix* | -nx6 | -nx7 | -sei*)
 	# Remember, each alternative MUST END IN *, to match a version number.
 		;;
 	-qnx*)
@@ -1129,8 +1152,10 @@
 			;;
 		esac
 		;;
+	-nto-qnx*)
+		;;
 	-nto*)
-		os=-nto-qnx
+		os=`echo $os | sed -e 's|nto|nto-qnx|'`
 		;;
 	-sim | -es1800* | -hms* | -xray | -os68k* | -none* | -v88r* \
 	      | -windows* | -osx | -abug | -netware* | -os9* | -beos* \
@@ -1224,6 +1249,12 @@
 	-*mint | -mint[0-9]* | -*MiNT | -MiNT[0-9]*)
 		os=-mint
 		;;
+	-aros*)
+		os=-aros
+		;;
+	-kaos*)
+		os=-kaos
+		;;
 	-none)
 		;;
 	*)
@@ -1255,6 +1286,9 @@
 	arm*-semi)
 		os=-aout
 		;;
+    c4x-* | tic4x-*)
+        os=-coff
+        ;;
 	# This must come before the *-dec entry.
 	pdp10-*)
 		os=-tops20
Index: configure
--- ncurses-5.3-20021012/configure	Sat Sep 21 20:49:14 2002
+++ ncurses-5.3-20030719/configure	Sat Jul 19 17:57:56 2003
@@ -1,7 +1,7 @@
 #! /bin/sh
-# From configure.in Revision: 1.274 .
+# From configure.in Revision: 1.294 .
 # Guess values for system-dependent variables and create Makefiles.
-# Generated by Autoconf 2.52.20011227.
+# Generated by Autoconf 2.52.20030208.
 #
 # Copyright 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001
 # Free Software Foundation, Inc.
@@ -655,13 +655,13 @@
   --disable-FEATURE       do not include FEATURE (same as --enable-FEATURE=no)
   --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
 
+  --with-abi-version=XXX  override derived ABI version
   --with-system-type=XXX  test: override derived host system-type
-  --enable-add-ons=DIR... used to check if we are a glibc add-on.
-  --with-build-cc=XXX     if cross-compiling, the host C compiler (\$BUILD_CC)
-  --with-build-cflags=XXX if cross-compiling, the host C compiler-flags
-  --with-build-cppflags=XXX if cross-compiling, the host C preprocessor-flags
-  --with-build-ldflags=XXX if cross-compiling, the host linker-flags
-  --with-build-libs=XXX   if cross-compiling, the host libraries
+  --with-build-cc=XXX     if cross-compiling, the build C compiler (\$BUILD_CC)
+  --with-build-cflags=XXX if cross-compiling, the build C compiler-flags
+  --with-build-cppflags=XXX if cross-compiling, the build C preprocessor-flags
+  --with-build-ldflags=XXX if cross-compiling, the build linker-flags
+  --with-build-libs=XXX   if cross-compiling, the build libraries
   --without-cxx           do not adjust ncurses bool to match C++
   --without-cxx-binding   do not build C++ binding and demo
   --without-ada           suppress check for Ada95, don't build demo
@@ -678,6 +678,7 @@
   --with-dbmalloc         test: use Conor Cahill's dbmalloc library
   --with-dmalloc          test: use Gray Watson's dmalloc library
   --with-gpm              use Alessandro Rubini's GPM library
+  --with-sysmouse         use sysmouse (FreeBSD console)
   --enable-rpath          use rpath option when generating shared libraries
   --with-shlib-version=X  Specify rel or abi version for shared libs
 Fine-Tuning Your Configuration:
@@ -806,7 +807,7 @@
 running configure, to aid debugging if configure makes a mistake.
 
 It was created by $as_me, which was
-generated by GNU Autoconf 2.52.20011227.  Invocation command line was
+generated by GNU Autoconf 2.52.20030208.  Invocation command line was
 
   $ $0 $@
 
@@ -930,7 +931,7 @@
 fi
 for ac_site_file in $CONFIG_SITE; do
   if test -r "$ac_site_file"; then
-    { echo "$as_me:933: loading site script $ac_site_file" >&5
+    { echo "$as_me:934: loading site script $ac_site_file" >&5
 echo "$as_me: loading site script $ac_site_file" >&6;}
     cat "$ac_site_file" >&5
     . "$ac_site_file"
@@ -941,7 +942,7 @@
   # Some versions of bash will fail to source /dev/null (special
   # files actually), so we avoid doing that.
   if test -f "$cache_file"; then
-    { echo "$as_me:944: loading cache $cache_file" >&5
+    { echo "$as_me:945: loading cache $cache_file" >&5
 echo "$as_me: loading cache $cache_file" >&6;}
     case $cache_file in
       [\\/]* | ?:[\\/]* ) . $cache_file;;
@@ -949,7 +950,7 @@
     esac
   fi
 else
-  { echo "$as_me:952: creating cache $cache_file" >&5
+  { echo "$as_me:953: creating cache $cache_file" >&5
 echo "$as_me: creating cache $cache_file" >&6;}
   >$cache_file
 fi
@@ -965,21 +966,21 @@
   eval ac_new_val="\$ac_env_${ac_var}_value"
   case $ac_old_set,$ac_new_set in
     set,)
-      { echo "$as_me:968: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&5
+      { echo "$as_me:969: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&5
 echo "$as_me: error: \`$ac_var' was set to \`$ac_old_val' in the previous run" >&2;}
       ac_cache_corrupted=: ;;
     ,set)
-      { echo "$as_me:972: error: \`$ac_var' was not set in the previous run" >&5
+      { echo "$as_me:973: error: \`$ac_var' was not set in the previous run" >&5
 echo "$as_me: error: \`$ac_var' was not set in the previous run" >&2;}
       ac_cache_corrupted=: ;;
     ,);;
     *)
       if test "x$ac_old_val" != "x$ac_new_val"; then
-        { echo "$as_me:978: error: \`$ac_var' has changed since the previous run:" >&5
+        { echo "$as_me:979: error: \`$ac_var' has changed since the previous run:" >&5
 echo "$as_me: error: \`$ac_var' has changed since the previous run:" >&2;}
-        { echo "$as_me:980:   former value:  $ac_old_val" >&5
+        { echo "$as_me:981:   former value:  $ac_old_val" >&5
 echo "$as_me:   former value:  $ac_old_val" >&2;}
-        { echo "$as_me:982:   current value: $ac_new_val" >&5
+        { echo "$as_me:983:   current value: $ac_new_val" >&5
 echo "$as_me:   current value: $ac_new_val" >&2;}
         ac_cache_corrupted=:
       fi;;
@@ -998,9 +999,9 @@
   fi
 done
 if $ac_cache_corrupted; then
-  { echo "$as_me:1001: error: changes in the environment can compromise the build" >&5
+  { echo "$as_me:1002: error: changes in the environment can compromise the build" >&5
 echo "$as_me: error: changes in the environment can compromise the build" >&2;}
-  { { echo "$as_me:1003: error: run \`make distclean' and/or \`rm $cache_file' and start over" >&5
+  { { echo "$as_me:1004: error: run \`make distclean' and/or \`rm $cache_file' and start over" >&5
 echo "$as_me: error: run \`make distclean' and/or \`rm $cache_file' and start over" >&2;}
    { (exit 1); exit 1; }; }
 fi
@@ -1020,10 +1021,10 @@
 echo "#! $SHELL" >conftest.sh
 echo  "exit 0"   >>conftest.sh
 chmod +x conftest.sh
-if { (echo "$as_me:1023: PATH=\".;.\"; conftest.sh") >&5
+if { (echo "$as_me:1024: PATH=\".;.\"; conftest.sh") >&5
   (PATH=".;."; conftest.sh) 2>&5
   ac_status=$?
-  echo "$as_me:1026: \$? = $ac_status" >&5
+  echo "$as_me:1027: \$? = $ac_status" >&5
   (exit $ac_status); }; then
   ac_path_separator=';'
 else
@@ -1040,9 +1041,17 @@
 cf_cv_abi_version=${NCURSES_MAJOR}
 cf_cv_rel_version=${NCURSES_MAJOR}.${NCURSES_MINOR}
 cf_cv_timestamp=`date`
-echo "$as_me:1043: result: Configuring NCURSES $cf_cv_rel_version ABI $cf_cv_abi_version ($cf_cv_timestamp)" >&5
+echo "$as_me:1044: result: Configuring NCURSES $cf_cv_rel_version ABI $cf_cv_abi_version ($cf_cv_timestamp)" >&5
 echo "${ECHO_T}Configuring NCURSES $cf_cv_rel_version ABI $cf_cv_abi_version ($cf_cv_timestamp)" >&6
 
+# Check whether --with-abi-version or --without-abi-version was given.
+if test "${with_abi_version+set}" = set; then
+  withval="$with_abi_version"
+  { echo "$as_me:1050: WARNING: overriding ABI version to $withval" >&5
+echo "$as_me: WARNING: overriding ABI version to $withval" >&2;}
+ cf_cv_abi_version=$withval
+fi;
+
 ac_aux_dir=
 for ac_dir in $srcdir $srcdir/.. $srcdir/../..; do
   if test -f $ac_dir/install-sh; then
@@ -1060,7 +1069,7 @@
   fi
 done
 if test -z "$ac_aux_dir"; then
-  { { echo "$as_me:1063: error: cannot find install-sh or install.sh in $srcdir $srcdir/.. $srcdir/../.." >&5
+  { { echo "$as_me:1072: error: cannot find install-sh or install.sh in $srcdir $srcdir/.. $srcdir/../.." >&5
 echo "$as_me: error: cannot find install-sh or install.sh in $srcdir $srcdir/.. $srcdir/../.." >&2;}
    { (exit 1); exit 1; }; }
 fi
@@ -1070,11 +1079,11 @@
 
 # Make sure we can run config.sub.
 $ac_config_sub sun4 >/dev/null 2>&1 ||
-  { { echo "$as_me:1073: error: cannot run $ac_config_sub" >&5
+  { { echo "$as_me:1082: error: cannot run $ac_config_sub" >&5
 echo "$as_me: error: cannot run $ac_config_sub" >&2;}
    { (exit 1); exit 1; }; }
 
-echo "$as_me:1077: checking build system type" >&5
+echo "$as_me:1086: checking build system type" >&5
 echo $ECHO_N "checking build system type... $ECHO_C" >&6
 if test "${ac_cv_build+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1083,23 +1092,23 @@
 test -z "$ac_cv_build_alias" &&
   ac_cv_build_alias=`$ac_config_guess`
 test -z "$ac_cv_build_alias" &&
-  { { echo "$as_me:1086: error: cannot guess build type; you must specify one" >&5
+  { { echo "$as_me:1095: error: cannot guess build type; you must specify one" >&5
 echo "$as_me: error: cannot guess build type; you must specify one" >&2;}
    { (exit 1); exit 1; }; }
 ac_cv_build=`$ac_config_sub $ac_cv_build_alias` ||
-  { { echo "$as_me:1090: error: $ac_config_sub $ac_cv_build_alias failed." >&5
+  { { echo "$as_me:1099: error: $ac_config_sub $ac_cv_build_alias failed." >&5
 echo "$as_me: error: $ac_config_sub $ac_cv_build_alias failed." >&2;}
    { (exit 1); exit 1; }; }
 
 fi
-echo "$as_me:1095: result: $ac_cv_build" >&5
+echo "$as_me:1104: result: $ac_cv_build" >&5
 echo "${ECHO_T}$ac_cv_build" >&6
 build=$ac_cv_build
 build_cpu=`echo $ac_cv_build | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\1/'`
 build_vendor=`echo $ac_cv_build | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\2/'`
 build_os=`echo $ac_cv_build | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\3/'`
 
-echo "$as_me:1102: checking host system type" >&5
+echo "$as_me:1111: checking host system type" >&5
 echo $ECHO_N "checking host system type... $ECHO_C" >&6
 if test "${ac_cv_host+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1108,12 +1117,12 @@
 test -z "$ac_cv_host_alias" &&
   ac_cv_host_alias=$ac_cv_build_alias
 ac_cv_host=`$ac_config_sub $ac_cv_host_alias` ||
-  { { echo "$as_me:1111: error: $ac_config_sub $ac_cv_host_alias failed" >&5
+  { { echo "$as_me:1120: error: $ac_config_sub $ac_cv_host_alias failed" >&5
 echo "$as_me: error: $ac_config_sub $ac_cv_host_alias failed" >&2;}
    { (exit 1); exit 1; }; }
 
 fi
-echo "$as_me:1116: result: $ac_cv_host" >&5
+echo "$as_me:1125: result: $ac_cv_host" >&5
 echo "${ECHO_T}$ac_cv_host" >&6
 host=$ac_cv_host
 host_cpu=`echo $ac_cv_host | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\1/'`
@@ -1121,7 +1130,7 @@
 host_os=`echo $ac_cv_host | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\3/'`
 
 if test -f $srcdir/config.guess ; then
-	echo "$as_me:1124: checking target system type" >&5
+	echo "$as_me:1133: checking target system type" >&5
 echo $ECHO_N "checking target system type... $ECHO_C" >&6
 if test "${ac_cv_target+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1130,12 +1139,12 @@
 test "x$ac_cv_target_alias" = "x" &&
   ac_cv_target_alias=$ac_cv_host_alias
 ac_cv_target=`$ac_config_sub $ac_cv_target_alias` ||
-  { { echo "$as_me:1133: error: $ac_config_sub $ac_cv_target_alias failed" >&5
+  { { echo "$as_me:1142: error: $ac_config_sub $ac_cv_target_alias failed" >&5
 echo "$as_me: error: $ac_config_sub $ac_cv_target_alias failed" >&2;}
    { (exit 1); exit 1; }; }
 
 fi
-echo "$as_me:1138: result: $ac_cv_target" >&5
+echo "$as_me:1147: result: $ac_cv_target" >&5
 echo "${ECHO_T}$ac_cv_target" >&6
 target=$ac_cv_target
 target_cpu=`echo $ac_cv_target | sed 's/^\([^-]*\)-\([^-]*\)-\(.*\)$/\1/'`
@@ -1166,13 +1175,13 @@
 fi
 
 test -z "$system_name" && system_name="$cf_cv_system_name"
-test -n "$cf_cv_system_name" && echo "$as_me:1169: result: Configuring for $cf_cv_system_name" >&5
+test -n "$cf_cv_system_name" && echo "$as_me:1178: result: Configuring for $cf_cv_system_name" >&5
 echo "${ECHO_T}Configuring for $cf_cv_system_name" >&6
 
 if test ".$system_name" != ".$cf_cv_system_name" ; then
-	echo "$as_me:1173: result: Cached system name ($system_name) does not agree with actual ($cf_cv_system_name)" >&5
+	echo "$as_me:1182: result: Cached system name ($system_name) does not agree with actual ($cf_cv_system_name)" >&5
 echo "${ECHO_T}Cached system name ($system_name) does not agree with actual ($cf_cv_system_name)" >&6
-	{ { echo "$as_me:1175: error: \"Please remove config.cache and try again.\"" >&5
+	{ { echo "$as_me:1184: error: \"Please remove config.cache and try again.\"" >&5
 echo "$as_me: error: \"Please remove config.cache and try again.\"" >&2;}
    { (exit 1); exit 1; }; }
 fi
@@ -1180,62 +1189,33 @@
 # Check whether --with-system-type or --without-system-type was given.
 if test "${with_system_type+set}" = set; then
   withval="$with_system_type"
-  { echo "$as_me:1183: WARNING: overriding system type to $withval" >&5
+  { echo "$as_me:1192: WARNING: overriding system type to $withval" >&5
 echo "$as_me: WARNING: overriding system type to $withval" >&2;}
  cf_cv_system_name=$withval
 fi;
 
-# We need a configure script only when compiling as part of GNU C library.
-# Here we have to generate one of the files we need while compiling.
-#
-# The only problem is that users of the package might think they have to
-# run configure themself and find it irritating when nothing happens.
-#
-# So we try here to find out whether we are called from the glibc configure
-# or by a user.
-#
-
-# Check whether --enable-add-ons or --disable-add-ons was given.
-if test "${enable_add_ons+set}" = set; then
-  enableval="$enable_add_ons"
-  glibc_add_on=yes
-else
-  glibc_add_on=
-fi;
-
-if test x"$glibc_add_on" = "xyes" ; then
-  rm -f $srcdir/Banner
-  # We are in glibc.
-  rm -f $srcdir/Makefile
-  cp $srcdir/Makefile.glibc $srcdir/Makefile
-  echo "ncurses `grep \"^[ 	]*ncurses-version[ 	]*=.*$\" \
-		$srcdir/Makefile | sed -e \
-		's/^[ 	]*ncurses-version[ 	]*=[ 	]*\([^	^ ]*\)[ 	]*$/\1/'`" > $srcdir/Banner
-  exit 0
-fi
-
 ###	Save the given $CFLAGS to allow user-override.
 cf_user_CFLAGS="$CFLAGS"
 
 ###	Default install-location
 
-echo "$as_me:1222: checking for prefix" >&5
+echo "$as_me:1202: checking for prefix" >&5
 echo $ECHO_N "checking for prefix... $ECHO_C" >&6
 if test "x$prefix" = "xNONE" ; then
 	case "$cf_cv_system_name" in
 		# non-vendor systems don't have a conflict
-	openbsd*|netbsd*|freebsd*|linux*|cygwin*)
+	openbsd*|netbsd*|freebsd*|linux*|cygwin*|k*bsd*-gnu)
 		prefix=/usr
 		;;
 	*)	prefix=$ac_default_prefix
 		;;
 	esac
 fi
-echo "$as_me:1234: result: $prefix" >&5
+echo "$as_me:1214: result: $prefix" >&5
 echo "${ECHO_T}$prefix" >&6
 
 if test "x$prefix" = "xNONE" ; then
-echo "$as_me:1238: checking for default include-directory" >&5
+echo "$as_me:1218: checking for default include-directory" >&5
 echo $ECHO_N "checking for default include-directory... $ECHO_C" >&6
 test -n "$verbose" && echo 1>&6
 for cf_symbol in \
@@ -1258,7 +1238,7 @@
 	fi
 	test -n "$verbose"  && echo "	tested $cf_dir" 1>&6
 done
-echo "$as_me:1261: result: $includedir" >&5
+echo "$as_me:1241: result: $includedir" >&5
 echo "${ECHO_T}$includedir" >&6
 fi
 
@@ -1271,7 +1251,7 @@
 if test -n "$ac_tool_prefix"; then
   # Extract the first word of "${ac_tool_prefix}gcc", so it can be a program name with args.
 set dummy ${ac_tool_prefix}gcc; ac_word=$2
-echo "$as_me:1274: checking for $ac_word" >&5
+echo "$as_me:1254: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1286,7 +1266,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_CC="${ac_tool_prefix}gcc"
-echo "$as_me:1289: found $ac_dir/$ac_word" >&5
+echo "$as_me:1269: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1294,10 +1274,10 @@
 fi
 CC=$ac_cv_prog_CC
 if test -n "$CC"; then
-  echo "$as_me:1297: result: $CC" >&5
+  echo "$as_me:1277: result: $CC" >&5
 echo "${ECHO_T}$CC" >&6
 else
-  echo "$as_me:1300: result: no" >&5
+  echo "$as_me:1280: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1306,7 +1286,7 @@
   ac_ct_CC=$CC
   # Extract the first word of "gcc", so it can be a program name with args.
 set dummy gcc; ac_word=$2
-echo "$as_me:1309: checking for $ac_word" >&5
+echo "$as_me:1289: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_ac_ct_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1321,7 +1301,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_ac_ct_CC="gcc"
-echo "$as_me:1324: found $ac_dir/$ac_word" >&5
+echo "$as_me:1304: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1329,10 +1309,10 @@
 fi
 ac_ct_CC=$ac_cv_prog_ac_ct_CC
 if test -n "$ac_ct_CC"; then
-  echo "$as_me:1332: result: $ac_ct_CC" >&5
+  echo "$as_me:1312: result: $ac_ct_CC" >&5
 echo "${ECHO_T}$ac_ct_CC" >&6
 else
-  echo "$as_me:1335: result: no" >&5
+  echo "$as_me:1315: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1345,7 +1325,7 @@
   if test -n "$ac_tool_prefix"; then
   # Extract the first word of "${ac_tool_prefix}cc", so it can be a program name with args.
 set dummy ${ac_tool_prefix}cc; ac_word=$2
-echo "$as_me:1348: checking for $ac_word" >&5
+echo "$as_me:1328: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1360,7 +1340,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_CC="${ac_tool_prefix}cc"
-echo "$as_me:1363: found $ac_dir/$ac_word" >&5
+echo "$as_me:1343: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1368,10 +1348,10 @@
 fi
 CC=$ac_cv_prog_CC
 if test -n "$CC"; then
-  echo "$as_me:1371: result: $CC" >&5
+  echo "$as_me:1351: result: $CC" >&5
 echo "${ECHO_T}$CC" >&6
 else
-  echo "$as_me:1374: result: no" >&5
+  echo "$as_me:1354: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1380,7 +1360,7 @@
   ac_ct_CC=$CC
   # Extract the first word of "cc", so it can be a program name with args.
 set dummy cc; ac_word=$2
-echo "$as_me:1383: checking for $ac_word" >&5
+echo "$as_me:1363: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_ac_ct_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1395,7 +1375,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_ac_ct_CC="cc"
-echo "$as_me:1398: found $ac_dir/$ac_word" >&5
+echo "$as_me:1378: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1403,10 +1383,10 @@
 fi
 ac_ct_CC=$ac_cv_prog_ac_ct_CC
 if test -n "$ac_ct_CC"; then
-  echo "$as_me:1406: result: $ac_ct_CC" >&5
+  echo "$as_me:1386: result: $ac_ct_CC" >&5
 echo "${ECHO_T}$ac_ct_CC" >&6
 else
-  echo "$as_me:1409: result: no" >&5
+  echo "$as_me:1389: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1419,7 +1399,7 @@
 if test -z "$CC"; then
   # Extract the first word of "cc", so it can be a program name with args.
 set dummy cc; ac_word=$2
-echo "$as_me:1422: checking for $ac_word" >&5
+echo "$as_me:1402: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1439,7 +1419,7 @@
   continue
 fi
 ac_cv_prog_CC="cc"
-echo "$as_me:1442: found $ac_dir/$ac_word" >&5
+echo "$as_me:1422: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1461,10 +1441,10 @@
 fi
 CC=$ac_cv_prog_CC
 if test -n "$CC"; then
-  echo "$as_me:1464: result: $CC" >&5
+  echo "$as_me:1444: result: $CC" >&5
 echo "${ECHO_T}$CC" >&6
 else
-  echo "$as_me:1467: result: no" >&5
+  echo "$as_me:1447: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1475,7 +1455,7 @@
   do
     # Extract the first word of "$ac_tool_prefix$ac_prog", so it can be a program name with args.
 set dummy $ac_tool_prefix$ac_prog; ac_word=$2
-echo "$as_me:1478: checking for $ac_word" >&5
+echo "$as_me:1458: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1490,7 +1470,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_CC="$ac_tool_prefix$ac_prog"
-echo "$as_me:1493: found $ac_dir/$ac_word" >&5
+echo "$as_me:1473: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1498,10 +1478,10 @@
 fi
 CC=$ac_cv_prog_CC
 if test -n "$CC"; then
-  echo "$as_me:1501: result: $CC" >&5
+  echo "$as_me:1481: result: $CC" >&5
 echo "${ECHO_T}$CC" >&6
 else
-  echo "$as_me:1504: result: no" >&5
+  echo "$as_me:1484: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1514,7 +1494,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:1517: checking for $ac_word" >&5
+echo "$as_me:1497: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_ac_ct_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -1529,7 +1509,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_ac_ct_CC="$ac_prog"
-echo "$as_me:1532: found $ac_dir/$ac_word" >&5
+echo "$as_me:1512: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -1537,10 +1517,10 @@
 fi
 ac_ct_CC=$ac_cv_prog_ac_ct_CC
 if test -n "$ac_ct_CC"; then
-  echo "$as_me:1540: result: $ac_ct_CC" >&5
+  echo "$as_me:1520: result: $ac_ct_CC" >&5
 echo "${ECHO_T}$ac_ct_CC" >&6
 else
-  echo "$as_me:1543: result: no" >&5
+  echo "$as_me:1523: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -1552,32 +1532,32 @@
 
 fi
 
-test -z "$CC" && { { echo "$as_me:1555: error: no acceptable cc found in \$PATH" >&5
+test -z "$CC" && { { echo "$as_me:1535: error: no acceptable cc found in \$PATH" >&5
 echo "$as_me: error: no acceptable cc found in \$PATH" >&2;}
    { (exit 1); exit 1; }; }
 
 # Provide some information about the compiler.
-echo "$as_me:1560:" \
+echo "$as_me:1540:" \
      "checking for C compiler version" >&5
 ac_compiler=`set X $ac_compile; echo $2`
-{ (eval echo "$as_me:1563: \"$ac_compiler --version </dev/null >&5\"") >&5
+{ (eval echo "$as_me:1543: \"$ac_compiler --version </dev/null >&5\"") >&5
   (eval $ac_compiler --version </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:1566: \$? = $ac_status" >&5
+  echo "$as_me:1546: \$? = $ac_status" >&5
   (exit $ac_status); }
-{ (eval echo "$as_me:1568: \"$ac_compiler -v </dev/null >&5\"") >&5
+{ (eval echo "$as_me:1548: \"$ac_compiler -v </dev/null >&5\"") >&5
   (eval $ac_compiler -v </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:1571: \$? = $ac_status" >&5
+  echo "$as_me:1551: \$? = $ac_status" >&5
   (exit $ac_status); }
-{ (eval echo "$as_me:1573: \"$ac_compiler -V </dev/null >&5\"") >&5
+{ (eval echo "$as_me:1553: \"$ac_compiler -V </dev/null >&5\"") >&5
   (eval $ac_compiler -V </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:1576: \$? = $ac_status" >&5
+  echo "$as_me:1556: \$? = $ac_status" >&5
   (exit $ac_status); }
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 1580 "configure"
+#line 1560 "configure"
 #include "confdefs.h"
 
 int
@@ -1593,13 +1573,13 @@
 # Try to create an executable without -o first, disregard a.out.
 # It will help us diagnose broken compilers, and finding out an intuition
 # of exeext.
-echo "$as_me:1596: checking for C compiler default output" >&5
+echo "$as_me:1576: checking for C compiler default output" >&5
 echo $ECHO_N "checking for C compiler default output... $ECHO_C" >&6
 ac_link_default=`echo "$ac_link" | sed 's/ -o *conftest[^ ]*//'`
-if { (eval echo "$as_me:1599: \"$ac_link_default\"") >&5
+if { (eval echo "$as_me:1579: \"$ac_link_default\"") >&5
   (eval $ac_link_default) 2>&5
   ac_status=$?
-  echo "$as_me:1602: \$? = $ac_status" >&5
+  echo "$as_me:1582: \$? = $ac_status" >&5
   (exit $ac_status); }; then
   # Find the output, starting from the most likely.  This scheme is
 # not robust to junk in `.', hence go to wildcards (a.*) only as a last
@@ -1622,34 +1602,34 @@
 else
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
-{ { echo "$as_me:1625: error: C compiler cannot create executables" >&5
+{ { echo "$as_me:1605: error: C compiler cannot create executables" >&5
 echo "$as_me: error: C compiler cannot create executables" >&2;}
    { (exit 77); exit 77; }; }
 fi
 
 ac_exeext=$ac_cv_exeext
-echo "$as_me:1631: result: $ac_file" >&5
+echo "$as_me:1611: result: $ac_file" >&5
 echo "${ECHO_T}$ac_file" >&6
 
 # Check the compiler produces executables we can run.  If not, either
 # the compiler is broken, or we cross compile.
-echo "$as_me:1636: checking whether the C compiler works" >&5
+echo "$as_me:1616: checking whether the C compiler works" >&5
 echo $ECHO_N "checking whether the C compiler works... $ECHO_C" >&6
 # FIXME: These cross compiler hacks should be removed for Autoconf 3.0
 # If not cross compiling, check that we can run a simple program.
 if test "$cross_compiling" != yes; then
   if { ac_try='./$ac_file'
-  { (eval echo "$as_me:1642: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1622: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1645: \$? = $ac_status" >&5
+  echo "$as_me:1625: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
     cross_compiling=no
   else
     if test "$cross_compiling" = maybe; then
 	cross_compiling=yes
     else
-	{ { echo "$as_me:1652: error: cannot run C compiled programs.
+	{ { echo "$as_me:1632: error: cannot run C compiled programs.
 If you meant to cross compile, use \`--host'." >&5
 echo "$as_me: error: cannot run C compiled programs.
 If you meant to cross compile, use \`--host'." >&2;}
@@ -1657,24 +1637,24 @@
     fi
   fi
 fi
-echo "$as_me:1660: result: yes" >&5
+echo "$as_me:1640: result: yes" >&5
 echo "${ECHO_T}yes" >&6
 
 rm -f a.out a.exe conftest$ac_cv_exeext
 ac_clean_files=$ac_clean_files_save
 # Check the compiler produces executables we can run.  If not, either
 # the compiler is broken, or we cross compile.
-echo "$as_me:1667: checking whether we are cross compiling" >&5
+echo "$as_me:1647: checking whether we are cross compiling" >&5
 echo $ECHO_N "checking whether we are cross compiling... $ECHO_C" >&6
-echo "$as_me:1669: result: $cross_compiling" >&5
+echo "$as_me:1649: result: $cross_compiling" >&5
 echo "${ECHO_T}$cross_compiling" >&6
 
-echo "$as_me:1672: checking for executable suffix" >&5
+echo "$as_me:1652: checking for executable suffix" >&5
 echo $ECHO_N "checking for executable suffix... $ECHO_C" >&6
-if { (eval echo "$as_me:1674: \"$ac_link\"") >&5
+if { (eval echo "$as_me:1654: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:1677: \$? = $ac_status" >&5
+  echo "$as_me:1657: \$? = $ac_status" >&5
   (exit $ac_status); }; then
   # If both `conftest.exe' and `conftest' are `present' (well, observable)
 # catch `conftest.exe'.  For instance with Cygwin, `ls conftest' will
@@ -1690,25 +1670,25 @@
   esac
 done
 else
-  { { echo "$as_me:1693: error: cannot compute EXEEXT: cannot compile and link" >&5
+  { { echo "$as_me:1673: error: cannot compute EXEEXT: cannot compile and link" >&5
 echo "$as_me: error: cannot compute EXEEXT: cannot compile and link" >&2;}
    { (exit 1); exit 1; }; }
 fi
 
 rm -f conftest$ac_cv_exeext
-echo "$as_me:1699: result: $ac_cv_exeext" >&5
+echo "$as_me:1679: result: $ac_cv_exeext" >&5
 echo "${ECHO_T}$ac_cv_exeext" >&6
 
 rm -f conftest.$ac_ext
 EXEEXT=$ac_cv_exeext
 ac_exeext=$EXEEXT
-echo "$as_me:1705: checking for object suffix" >&5
+echo "$as_me:1685: checking for object suffix" >&5
 echo $ECHO_N "checking for object suffix... $ECHO_C" >&6
 if test "${ac_cv_objext+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 1711 "configure"
+#line 1691 "configure"
 #include "confdefs.h"
 
 int
@@ -1720,10 +1700,10 @@
 }
 _ACEOF
 rm -f conftest.o conftest.obj
-if { (eval echo "$as_me:1723: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1703: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1726: \$? = $ac_status" >&5
+  echo "$as_me:1706: \$? = $ac_status" >&5
   (exit $ac_status); }; then
   for ac_file in `(ls conftest.o conftest.obj; ls conftest.*) 2>/dev/null`; do
   case $ac_file in
@@ -1735,24 +1715,24 @@
 else
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
-{ { echo "$as_me:1738: error: cannot compute OBJEXT: cannot compile" >&5
+{ { echo "$as_me:1718: error: cannot compute OBJEXT: cannot compile" >&5
 echo "$as_me: error: cannot compute OBJEXT: cannot compile" >&2;}
    { (exit 1); exit 1; }; }
 fi
 
 rm -f conftest.$ac_cv_objext conftest.$ac_ext
 fi
-echo "$as_me:1745: result: $ac_cv_objext" >&5
+echo "$as_me:1725: result: $ac_cv_objext" >&5
 echo "${ECHO_T}$ac_cv_objext" >&6
 OBJEXT=$ac_cv_objext
 ac_objext=$OBJEXT
-echo "$as_me:1749: checking whether we are using the GNU C compiler" >&5
+echo "$as_me:1729: checking whether we are using the GNU C compiler" >&5
 echo $ECHO_N "checking whether we are using the GNU C compiler... $ECHO_C" >&6
 if test "${ac_cv_c_compiler_gnu+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 1755 "configure"
+#line 1735 "configure"
 #include "confdefs.h"
 
 int
@@ -1767,16 +1747,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:1770: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1750: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1773: \$? = $ac_status" >&5
+  echo "$as_me:1753: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:1776: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1756: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1779: \$? = $ac_status" >&5
+  echo "$as_me:1759: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_compiler_gnu=yes
 else
@@ -1788,19 +1768,19 @@
 ac_cv_c_compiler_gnu=$ac_compiler_gnu
 
 fi
-echo "$as_me:1791: result: $ac_cv_c_compiler_gnu" >&5
+echo "$as_me:1771: result: $ac_cv_c_compiler_gnu" >&5
 echo "${ECHO_T}$ac_cv_c_compiler_gnu" >&6
 GCC=`test $ac_compiler_gnu = yes && echo yes`
 ac_test_CFLAGS=${CFLAGS+set}
 ac_save_CFLAGS=$CFLAGS
 CFLAGS="-g"
-echo "$as_me:1797: checking whether $CC accepts -g" >&5
+echo "$as_me:1777: checking whether $CC accepts -g" >&5
 echo $ECHO_N "checking whether $CC accepts -g... $ECHO_C" >&6
 if test "${ac_cv_prog_cc_g+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 1803 "configure"
+#line 1783 "configure"
 #include "confdefs.h"
 
 int
@@ -1812,16 +1792,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:1815: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1795: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1818: \$? = $ac_status" >&5
+  echo "$as_me:1798: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:1821: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1801: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1824: \$? = $ac_status" >&5
+  echo "$as_me:1804: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_prog_cc_g=yes
 else
@@ -1831,7 +1811,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:1834: result: $ac_cv_prog_cc_g" >&5
+echo "$as_me:1814: result: $ac_cv_prog_cc_g" >&5
 echo "${ECHO_T}$ac_cv_prog_cc_g" >&6
 if test "$ac_test_CFLAGS" = set; then
   CFLAGS=$ac_save_CFLAGS
@@ -1858,16 +1838,16 @@
 #endif
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:1861: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1841: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1864: \$? = $ac_status" >&5
+  echo "$as_me:1844: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:1867: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1847: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1870: \$? = $ac_status" >&5
+  echo "$as_me:1850: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   for ac_declaration in \
    ''\
@@ -1879,7 +1859,7 @@
    'void exit (int);'
 do
   cat >conftest.$ac_ext <<_ACEOF
-#line 1882 "configure"
+#line 1862 "configure"
 #include "confdefs.h"
 #include <stdlib.h>
 $ac_declaration
@@ -1892,16 +1872,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:1895: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1875: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1898: \$? = $ac_status" >&5
+  echo "$as_me:1878: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:1901: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1881: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1904: \$? = $ac_status" >&5
+  echo "$as_me:1884: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   :
 else
@@ -1911,7 +1891,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
   cat >conftest.$ac_ext <<_ACEOF
-#line 1914 "configure"
+#line 1894 "configure"
 #include "confdefs.h"
 $ac_declaration
 int
@@ -1923,16 +1903,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:1926: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:1906: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:1929: \$? = $ac_status" >&5
+  echo "$as_me:1909: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:1932: \"$ac_try\"") >&5
+  { (eval echo "$as_me:1912: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:1935: \$? = $ac_status" >&5
+  echo "$as_me:1915: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   break
 else
@@ -1961,22 +1941,23 @@
 
 GCC_VERSION=none
 if test "$GCC" = yes ; then
-	echo "$as_me:1964: checking version of gcc" >&5
-echo $ECHO_N "checking version of gcc... $ECHO_C" >&6
-	GCC_VERSION="`${CC} --version|head -1`"
-	echo "$as_me:1967: result: $GCC_VERSION" >&5
+	echo "$as_me:1944: checking version of $CC" >&5
+echo $ECHO_N "checking version of $CC... $ECHO_C" >&6
+	GCC_VERSION="`${CC} --version|head -1 | sed -e 's/^[^0-9.]*//' -e 's/[^0-9.].*//'`"
+	test -z "$GCC_VERSION" && GCC_VERSION=unknown
+	echo "$as_me:1948: result: $GCC_VERSION" >&5
 echo "${ECHO_T}$GCC_VERSION" >&6
 fi
 
 # If we're cross-compiling, allow the user to override the tools and their
-# options.  The configure script is oriented toward identifying the target
-# compiler, etc., but we need a host compiler to generate parts of the source.
-BUILD_CC='$(CC)'
-BUILD_CFLAGS='$(CFLAGS)'
-BUILD_CPPFLAGS='$(CPPFLAGS)'
-BUILD_LDFLAGS='$(LDFLAGS)'
-BUILD_LIBS='$(LIBS)'
-if test "$host_alias" != "$target_alias" ; then
+# options.  The configure script is oriented toward identifying the host
+# compiler, etc., but we need a build compiler to generate parts of the source.
+: ${BUILD_CC:='$(CC)'}
+: ${BUILD_CFLAGS:='$(CFLAGS)'}
+: ${BUILD_CPPFLAGS:='$(CPPFLAGS)'}
+: ${BUILD_LDFLAGS:='$(LDFLAGS)'}
+: ${BUILD_LIBS:='$(LIBS)'}
+if test "$cross_compiling" = yes ; then
 
 # Check whether --with-build-cc or --without-build-cc was given.
 if test "${with_build_cc+set}" = set; then
@@ -1987,7 +1968,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:1990: checking for $ac_word" >&5
+echo "$as_me:1971: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_BUILD_CC+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2002,7 +1983,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_BUILD_CC="$ac_prog"
-echo "$as_me:2005: found $ac_dir/$ac_word" >&5
+echo "$as_me:1986: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -2010,10 +1991,10 @@
 fi
 BUILD_CC=$ac_cv_prog_BUILD_CC
 if test -n "$BUILD_CC"; then
-  echo "$as_me:2013: result: $BUILD_CC" >&5
+  echo "$as_me:1994: result: $BUILD_CC" >&5
 echo "${ECHO_T}$BUILD_CC" >&6
 else
-  echo "$as_me:2016: result: no" >&5
+  echo "$as_me:1997: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -2052,7 +2033,7 @@
 ac_compile='$CC -c $CFLAGS $CPPFLAGS conftest.$ac_ext >&5'
 ac_link='$CC -o conftest$ac_exeext $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
 ac_compiler_gnu=$ac_cv_c_compiler_gnu
-echo "$as_me:2055: checking how to run the C preprocessor" >&5
+echo "$as_me:2036: checking how to run the C preprocessor" >&5
 echo $ECHO_N "checking how to run the C preprocessor... $ECHO_C" >&6
 # On Suns, sometimes $CPP names a directory.
 if test -n "$CPP" && test -d "$CPP"; then
@@ -2073,18 +2054,18 @@
   # On the NeXT, cc -E runs the code through the compiler's parser,
   # not just through cpp. "Syntax error" is here to catch this case.
   cat >conftest.$ac_ext <<_ACEOF
-#line 2076 "configure"
+#line 2057 "configure"
 #include "confdefs.h"
 #include <assert.h>
                      Syntax error
 _ACEOF
-if { (eval echo "$as_me:2081: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:2062: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:2087: \$? = $ac_status" >&5
+  echo "$as_me:2068: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -2107,17 +2088,17 @@
   # OK, works on sane cases.  Now check whether non-existent headers
   # can be detected and how.
   cat >conftest.$ac_ext <<_ACEOF
-#line 2110 "configure"
+#line 2091 "configure"
 #include "confdefs.h"
 #include <ac_nonexistent.h>
 _ACEOF
-if { (eval echo "$as_me:2114: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:2095: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:2120: \$? = $ac_status" >&5
+  echo "$as_me:2101: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -2154,7 +2135,7 @@
 else
   ac_cv_prog_CPP=$CPP
 fi
-echo "$as_me:2157: result: $CPP" >&5
+echo "$as_me:2138: result: $CPP" >&5
 echo "${ECHO_T}$CPP" >&6
 ac_preproc_ok=false
 for ac_c_preproc_warn_flag in '' yes
@@ -2164,18 +2145,18 @@
   # On the NeXT, cc -E runs the code through the compiler's parser,
   # not just through cpp. "Syntax error" is here to catch this case.
   cat >conftest.$ac_ext <<_ACEOF
-#line 2167 "configure"
+#line 2148 "configure"
 #include "confdefs.h"
 #include <assert.h>
                      Syntax error
 _ACEOF
-if { (eval echo "$as_me:2172: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:2153: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:2178: \$? = $ac_status" >&5
+  echo "$as_me:2159: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -2198,17 +2179,17 @@
   # OK, works on sane cases.  Now check whether non-existent headers
   # can be detected and how.
   cat >conftest.$ac_ext <<_ACEOF
-#line 2201 "configure"
+#line 2182 "configure"
 #include "confdefs.h"
 #include <ac_nonexistent.h>
 _ACEOF
-if { (eval echo "$as_me:2205: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:2186: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:2211: \$? = $ac_status" >&5
+  echo "$as_me:2192: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -2236,7 +2217,7 @@
 if $ac_preproc_ok; then
   :
 else
-  { { echo "$as_me:2239: error: C preprocessor \"$CPP\" fails sanity check" >&5
+  { { echo "$as_me:2220: error: C preprocessor \"$CPP\" fails sanity check" >&5
 echo "$as_me: error: C preprocessor \"$CPP\" fails sanity check" >&2;}
    { (exit 1); exit 1; }; }
 fi
@@ -2248,17 +2229,17 @@
 ac_compiler_gnu=$ac_cv_c_compiler_gnu
 
 if test $ac_cv_c_compiler_gnu = yes; then
-    echo "$as_me:2251: checking whether $CC needs -traditional" >&5
+    echo "$as_me:2232: checking whether $CC needs -traditional" >&5
 echo $ECHO_N "checking whether $CC needs -traditional... $ECHO_C" >&6
 if test "${ac_cv_prog_gcc_traditional+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
     ac_pattern="Autoconf.*'x'"
   cat >conftest.$ac_ext <<_ACEOF
-#line 2258 "configure"
+#line 2239 "configure"
 #include "confdefs.h"
 #include <sgtty.h>
-Autoconf TIOCGETP
+int Autoconf = TIOCGETP;
 _ACEOF
 if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
   egrep "$ac_pattern" >/dev/null 2>&1; then
@@ -2270,10 +2251,10 @@
 
   if test $ac_cv_prog_gcc_traditional = no; then
     cat >conftest.$ac_ext <<_ACEOF
-#line 2273 "configure"
+#line 2254 "configure"
 #include "confdefs.h"
 #include <termio.h>
-Autoconf TCGETA
+int Autoconf = TCGETA;
 _ACEOF
 if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
   egrep "$ac_pattern" >/dev/null 2>&1; then
@@ -2283,19 +2264,19 @@
 
   fi
 fi
-echo "$as_me:2286: result: $ac_cv_prog_gcc_traditional" >&5
+echo "$as_me:2267: result: $ac_cv_prog_gcc_traditional" >&5
 echo "${ECHO_T}$ac_cv_prog_gcc_traditional" >&6
   if test $ac_cv_prog_gcc_traditional = yes; then
     CC="$CC -traditional"
   fi
 fi
 
-echo "$as_me:2293: checking for POSIXized ISC" >&5
+echo "$as_me:2274: checking for POSIXized ISC" >&5
 echo $ECHO_N "checking for POSIXized ISC... $ECHO_C" >&6
 if test -d /etc/conf/kconfig.d &&
    grep _POSIX_VERSION /usr/include/sys/unistd.h >/dev/null 2>&1
 then
-  echo "$as_me:2298: result: yes" >&5
+  echo "$as_me:2279: result: yes" >&5
 echo "${ECHO_T}yes" >&6
   ISC=yes # If later tests want to check for ISC.
 
@@ -2309,12 +2290,12 @@
     CC="$CC -Xp"
   fi
 else
-  echo "$as_me:2312: result: no" >&5
+  echo "$as_me:2293: result: no" >&5
 echo "${ECHO_T}no" >&6
   ISC=
 fi
 
-echo "$as_me:2317: checking for ${CC-cc} option to accept ANSI C" >&5
+echo "$as_me:2298: checking for ${CC-cc} option to accept ANSI C" >&5
 echo $ECHO_N "checking for ${CC-cc} option to accept ANSI C... $ECHO_C" >&6
 if test "${cf_cv_ansi_cc+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2366,11 +2347,11 @@
 
 if test -n "$cf_new_cppflags" ; then
 
-	CPPFLAGS="$CPPFLAGS $cf_new_cppflags"
+	CPPFLAGS="$cf_new_cppflags $CPPFLAGS"
 fi
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 2373 "configure"
+#line 2354 "configure"
 #include "confdefs.h"
 
 #ifndef CC_HAS_PROTOS
@@ -2391,16 +2372,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:2394: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:2375: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:2397: \$? = $ac_status" >&5
+  echo "$as_me:2378: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:2400: \"$ac_try\"") >&5
+  { (eval echo "$as_me:2381: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:2403: \$? = $ac_status" >&5
+  echo "$as_me:2384: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_ansi_cc="$cf_arg"; break
 else
@@ -2413,7 +2394,7 @@
 CPPFLAGS="$cf_save_CPPFLAGS"
 
 fi
-echo "$as_me:2416: result: $cf_cv_ansi_cc" >&5
+echo "$as_me:2397: result: $cf_cv_ansi_cc" >&5
 echo "${ECHO_T}$cf_cv_ansi_cc" >&6
 
 if test "$cf_cv_ansi_cc" != "no"; then
@@ -2446,7 +2427,7 @@
 
 if test -n "$cf_new_cppflags" ; then
 
-	CPPFLAGS="$CPPFLAGS $cf_new_cppflags"
+	CPPFLAGS="$cf_new_cppflags $CPPFLAGS"
 fi
 
 else
@@ -2458,7 +2439,7 @@
 fi
 
 if test "$cf_cv_ansi_cc" = "no"; then
-	{ { echo "$as_me:2461: error: Your compiler does not appear to recognize prototypes.
+	{ { echo "$as_me:2442: error: Your compiler does not appear to recognize prototypes.
 You have the following choices:
 	a. adjust your compiler options
 	b. get an up-to-date compiler
@@ -2478,7 +2459,7 @@
     CFLAGS="$CFLAGS -Zmt"
     CPPFLAGS="$CPPFLAGS -D__ST_MT_ERRNO__"
     CXXFLAGS="$CXXFLAGS -Zmt"
-    LDFLAGS=`echo "$LDFLAGS -Zmt -Zcrtdll" | sed "s/-Zexe//g"`
+    LDFLAGS=`echo "$LDFLAGS -Zmt -Zcrtdll" | sed -e "s%-Zexe%%g"`
     PROG_EXT=".exe"
     ;;
 cygwin*)
@@ -2497,7 +2478,7 @@
 *) LDPATH=$PATH:/sbin:/usr/sbin
   # Extract the first word of "ldconfig", so it can be a program name with args.
 set dummy ldconfig; ac_word=$2
-echo "$as_me:2500: checking for $ac_word" >&5
+echo "$as_me:2481: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_path_LDCONFIG+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2514,7 +2495,7 @@
   test -z "$ac_dir" && ac_dir=.
   if $as_executable_p "$ac_dir/$ac_word"; then
    ac_cv_path_LDCONFIG="$ac_dir/$ac_word"
-   echo "$as_me:2517: found $ac_dir/$ac_word" >&5
+   echo "$as_me:2498: found $ac_dir/$ac_word" >&5
    break
 fi
 done
@@ -2525,17 +2506,17 @@
 LDCONFIG=$ac_cv_path_LDCONFIG
 
 if test -n "$LDCONFIG"; then
-  echo "$as_me:2528: result: $LDCONFIG" >&5
+  echo "$as_me:2509: result: $LDCONFIG" >&5
 echo "${ECHO_T}$LDCONFIG" >&6
 else
-  echo "$as_me:2531: result: no" >&5
+  echo "$as_me:2512: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
   ;;
 esac
 
-echo "$as_me:2538: checking if you want to ensure bool is consistent with C++" >&5
+echo "$as_me:2519: checking if you want to ensure bool is consistent with C++" >&5
 echo $ECHO_N "checking if you want to ensure bool is consistent with C++... $ECHO_C" >&6
 
 # Check whether --with-cxx or --without-cxx was given.
@@ -2545,12 +2526,13 @@
 else
   cf_with_cxx=yes
 fi;
-echo "$as_me:2548: result: $cf_with_cxx" >&5
+echo "$as_me:2529: result: $cf_with_cxx" >&5
 echo "${ECHO_T}$cf_with_cxx" >&6
 if test "X$cf_with_cxx" = Xno ; then
 	CXX=""
 	GXX=""
 else
+	# with autoconf 2.13, we can change the error to a warning:
 		ac_ext=cc
 ac_cpp='$CXXCPP $CPPFLAGS'
 ac_compile='$CXX -c $CXXFLAGS $CPPFLAGS conftest.$ac_ext >&5'
@@ -2561,7 +2543,7 @@
   do
     # Extract the first word of "$ac_tool_prefix$ac_prog", so it can be a program name with args.
 set dummy $ac_tool_prefix$ac_prog; ac_word=$2
-echo "$as_me:2564: checking for $ac_word" >&5
+echo "$as_me:2546: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_CXX+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2576,7 +2558,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_CXX="$ac_tool_prefix$ac_prog"
-echo "$as_me:2579: found $ac_dir/$ac_word" >&5
+echo "$as_me:2561: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -2584,10 +2566,10 @@
 fi
 CXX=$ac_cv_prog_CXX
 if test -n "$CXX"; then
-  echo "$as_me:2587: result: $CXX" >&5
+  echo "$as_me:2569: result: $CXX" >&5
 echo "${ECHO_T}$CXX" >&6
 else
-  echo "$as_me:2590: result: no" >&5
+  echo "$as_me:2572: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -2600,7 +2582,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:2603: checking for $ac_word" >&5
+echo "$as_me:2585: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_ac_ct_CXX+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2615,7 +2597,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_ac_ct_CXX="$ac_prog"
-echo "$as_me:2618: found $ac_dir/$ac_word" >&5
+echo "$as_me:2600: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -2623,10 +2605,10 @@
 fi
 ac_ct_CXX=$ac_cv_prog_ac_ct_CXX
 if test -n "$ac_ct_CXX"; then
-  echo "$as_me:2626: result: $ac_ct_CXX" >&5
+  echo "$as_me:2608: result: $ac_ct_CXX" >&5
 echo "${ECHO_T}$ac_ct_CXX" >&6
 else
-  echo "$as_me:2629: result: no" >&5
+  echo "$as_me:2611: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -2638,32 +2620,32 @@
 fi
 
 # Provide some information about the compiler.
-echo "$as_me:2641:" \
+echo "$as_me:2623:" \
      "checking for C++ compiler version" >&5
 ac_compiler=`set X $ac_compile; echo $2`
-{ (eval echo "$as_me:2644: \"$ac_compiler --version </dev/null >&5\"") >&5
+{ (eval echo "$as_me:2626: \"$ac_compiler --version </dev/null >&5\"") >&5
   (eval $ac_compiler --version </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:2647: \$? = $ac_status" >&5
+  echo "$as_me:2629: \$? = $ac_status" >&5
   (exit $ac_status); }
-{ (eval echo "$as_me:2649: \"$ac_compiler -v </dev/null >&5\"") >&5
+{ (eval echo "$as_me:2631: \"$ac_compiler -v </dev/null >&5\"") >&5
   (eval $ac_compiler -v </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:2652: \$? = $ac_status" >&5
+  echo "$as_me:2634: \$? = $ac_status" >&5
   (exit $ac_status); }
-{ (eval echo "$as_me:2654: \"$ac_compiler -V </dev/null >&5\"") >&5
+{ (eval echo "$as_me:2636: \"$ac_compiler -V </dev/null >&5\"") >&5
   (eval $ac_compiler -V </dev/null >&5) 2>&5
   ac_status=$?
-  echo "$as_me:2657: \$? = $ac_status" >&5
+  echo "$as_me:2639: \$? = $ac_status" >&5
   (exit $ac_status); }
 
-echo "$as_me:2660: checking whether we are using the GNU C++ compiler" >&5
+echo "$as_me:2642: checking whether we are using the GNU C++ compiler" >&5
 echo $ECHO_N "checking whether we are using the GNU C++ compiler... $ECHO_C" >&6
 if test "${ac_cv_cxx_compiler_gnu+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 2666 "configure"
+#line 2648 "configure"
 #include "confdefs.h"
 
 int
@@ -2678,16 +2660,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:2681: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:2663: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:2684: \$? = $ac_status" >&5
+  echo "$as_me:2666: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:2687: \"$ac_try\"") >&5
+  { (eval echo "$as_me:2669: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:2690: \$? = $ac_status" >&5
+  echo "$as_me:2672: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_compiler_gnu=yes
 else
@@ -2699,19 +2681,19 @@
 ac_cv_cxx_compiler_gnu=$ac_compiler_gnu
 
 fi
-echo "$as_me:2702: result: $ac_cv_cxx_compiler_gnu" >&5
+echo "$as_me:2684: result: $ac_cv_cxx_compiler_gnu" >&5
 echo "${ECHO_T}$ac_cv_cxx_compiler_gnu" >&6
 GXX=`test $ac_compiler_gnu = yes && echo yes`
 ac_test_CXXFLAGS=${CXXFLAGS+set}
 ac_save_CXXFLAGS=$CXXFLAGS
 CXXFLAGS="-g"
-echo "$as_me:2708: checking whether $CXX accepts -g" >&5
+echo "$as_me:2690: checking whether $CXX accepts -g" >&5
 echo $ECHO_N "checking whether $CXX accepts -g... $ECHO_C" >&6
 if test "${ac_cv_prog_cxx_g+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 2714 "configure"
+#line 2696 "configure"
 #include "confdefs.h"
 
 int
@@ -2723,16 +2705,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:2726: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:2708: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:2729: \$? = $ac_status" >&5
+  echo "$as_me:2711: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:2732: \"$ac_try\"") >&5
+  { (eval echo "$as_me:2714: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:2735: \$? = $ac_status" >&5
+  echo "$as_me:2717: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_prog_cxx_g=yes
 else
@@ -2742,7 +2724,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:2745: result: $ac_cv_prog_cxx_g" >&5
+echo "$as_me:2727: result: $ac_cv_prog_cxx_g" >&5
 echo "${ECHO_T}$ac_cv_prog_cxx_g" >&6
 if test "$ac_test_CXXFLAGS" = set; then
   CXXFLAGS=$ac_save_CXXFLAGS
@@ -2769,7 +2751,7 @@
    'void exit (int);'
 do
   cat >conftest.$ac_ext <<_ACEOF
-#line 2772 "configure"
+#line 2754 "configure"
 #include "confdefs.h"
 #include <stdlib.h>
 $ac_declaration
@@ -2782,16 +2764,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:2785: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:2767: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:2788: \$? = $ac_status" >&5
+  echo "$as_me:2770: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:2791: \"$ac_try\"") >&5
+  { (eval echo "$as_me:2773: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:2794: \$? = $ac_status" >&5
+  echo "$as_me:2776: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   :
 else
@@ -2801,7 +2783,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
   cat >conftest.$ac_ext <<_ACEOF
-#line 2804 "configure"
+#line 2786 "configure"
 #include "confdefs.h"
 $ac_declaration
 int
@@ -2813,16 +2795,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:2816: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:2798: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:2819: \$? = $ac_status" >&5
+  echo "$as_me:2801: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:2822: \"$ac_try\"") >&5
+  { (eval echo "$as_me:2804: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:2825: \$? = $ac_status" >&5
+  echo "$as_me:2807: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   break
 else
@@ -2844,26 +2826,72 @@
 ac_link='$CC -o conftest$ac_exeext $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
 ac_compiler_gnu=$ac_cv_c_compiler_gnu
 
+		# autoconf 2.5x removed the error - by hardcoding it to g++.
+	if test "$CXX" = "g++" ; then
+		# Extract the first word of "g++", so it can be a program name with args.
+set dummy g++; ac_word=$2
+echo "$as_me:2833: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_path_CXX+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+  case $CXX in
+  [\\/]* | ?:[\\/]*)
+  ac_cv_path_CXX="$CXX" # Let the user override the test with a path.
+  ;;
+  *)
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  if $as_executable_p "$ac_dir/$ac_word"; then
+   ac_cv_path_CXX="$ac_dir/$ac_word"
+   echo "$as_me:2850: found $ac_dir/$ac_word" >&5
+   break
+fi
+done
+
+  ;;
+esac
+fi
+CXX=$ac_cv_path_CXX
+
+if test -n "$CXX"; then
+  echo "$as_me:2861: result: $CXX" >&5
+echo "${ECHO_T}$CXX" >&6
+else
+  echo "$as_me:2864: result: no" >&5
+echo "${ECHO_T}no" >&6
+fi
+
+	fi
+	if test "$CXX" = "g++" ; then
+		{ echo "$as_me:2870: WARNING: ignoring hardcoded g++" >&5
+echo "$as_me: WARNING: ignoring hardcoded g++" >&2;}
+		cf_with_cxx=no; CXX=""; GXX="";
 	fi
+fi
 
 GXX_VERSION=none
 if test "$GXX" = yes; then
-	echo "$as_me:2851: checking version of g++" >&5
+	echo "$as_me:2878: checking version of g++" >&5
 echo $ECHO_N "checking version of g++... $ECHO_C" >&6
 	GXX_VERSION="`${CXX-g++} --version|head -1`"
-	echo "$as_me:2854: result: $GXX_VERSION" >&5
+	echo "$as_me:2881: result: $GXX_VERSION" >&5
 echo "${ECHO_T}$GXX_VERSION" >&6
-	case $GXX_VERSION in
-	1*|2.[0-6]*)
-		GXX=""; CXX=""; ac_cv_cxx_compiler_gnu=no
-		cf_cxx_library=no
-		{ echo "$as_me:2860: WARNING: templates do not work" >&5
-echo "$as_me: WARNING: templates do not work" >&2;}
-		;;
-	esac
 fi
 
-echo "$as_me:2866: checking if you want to build C++ binding and demo" >&5
+case $GXX_VERSION in
+1*|2.[0-6]*)
+	GXX=""; CXX=""; ac_cv_cxx_compiler_gnu=no
+	cf_cxx_library=no
+	{ echo "$as_me:2889: WARNING: templates do not work" >&5
+echo "$as_me: WARNING: templates do not work" >&2;}
+	;;
+esac
+
+echo "$as_me:2894: checking if you want to build C++ binding and demo" >&5
 echo $ECHO_N "checking if you want to build C++ binding and demo... $ECHO_C" >&6
 
 # Check whether --with-cxx-binding or --without-cxx-binding was given.
@@ -2873,10 +2901,10 @@
 else
   cf_with_cxx_binding=$cf_with_cxx
 fi;
-echo "$as_me:2876: result: $cf_with_cxx_binding" >&5
+echo "$as_me:2904: result: $cf_with_cxx_binding" >&5
 echo "${ECHO_T}$cf_with_cxx_binding" >&6
 
-echo "$as_me:2879: checking if you want to build with Ada95" >&5
+echo "$as_me:2907: checking if you want to build with Ada95" >&5
 echo $ECHO_N "checking if you want to build with Ada95... $ECHO_C" >&6
 
 # Check whether --with-ada or --without-ada was given.
@@ -2886,10 +2914,10 @@
 else
   cf_with_ada=yes
 fi;
-echo "$as_me:2889: result: $cf_with_ada" >&5
+echo "$as_me:2917: result: $cf_with_ada" >&5
 echo "${ECHO_T}$cf_with_ada" >&6
 
-echo "$as_me:2892: checking if you want to build programs such as tic" >&5
+echo "$as_me:2920: checking if you want to build programs such as tic" >&5
 echo $ECHO_N "checking if you want to build programs such as tic... $ECHO_C" >&6
 
 # Check whether --with-progs or --without-progs was given.
@@ -2899,10 +2927,10 @@
 else
   cf_with_progs=yes
 fi;
-echo "$as_me:2902: result: $cf_with_progs" >&5
+echo "$as_me:2930: result: $cf_with_progs" >&5
 echo "${ECHO_T}$cf_with_progs" >&6
 
-echo "$as_me:2905: checking if you wish to install curses.h" >&5
+echo "$as_me:2933: checking if you wish to install curses.h" >&5
 echo $ECHO_N "checking if you wish to install curses.h... $ECHO_C" >&6
 
 # Check whether --with-curses-h or --without-curses-h was given.
@@ -2912,7 +2940,7 @@
 else
   with_curses_h=yes
 fi;
-echo "$as_me:2915: result: $with_curses_h" >&5
+echo "$as_me:2943: result: $with_curses_h" >&5
 echo "${ECHO_T}$with_curses_h" >&6
 
 modules_to_build="ncurses"
@@ -2938,7 +2966,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:2941: checking for $ac_word" >&5
+echo "$as_me:2969: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_AWK+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -2953,7 +2981,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_AWK="$ac_prog"
-echo "$as_me:2956: found $ac_dir/$ac_word" >&5
+echo "$as_me:2984: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -2961,17 +2989,17 @@
 fi
 AWK=$ac_cv_prog_AWK
 if test -n "$AWK"; then
-  echo "$as_me:2964: result: $AWK" >&5
+  echo "$as_me:2992: result: $AWK" >&5
 echo "${ECHO_T}$AWK" >&6
 else
-  echo "$as_me:2967: result: no" >&5
+  echo "$as_me:2995: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
   test -n "$AWK" && break
 done
 
-echo "$as_me:2974: checking whether ${MAKE-make} sets \${MAKE}" >&5
+echo "$as_me:3002: checking whether ${MAKE-make} sets \${MAKE}" >&5
 echo $ECHO_N "checking whether ${MAKE-make} sets \${MAKE}... $ECHO_C" >&6
 set dummy ${MAKE-make}; ac_make=`echo "$2" | sed 'y,./+-,__p_,'`
 if eval "test \"\${ac_cv_prog_make_${ac_make}_set+set}\" = set"; then
@@ -2991,11 +3019,11 @@
 rm -f conftest.make
 fi
 if eval "test \"`echo '$ac_cv_prog_make_'${ac_make}_set`\" = yes"; then
-  echo "$as_me:2994: result: yes" >&5
+  echo "$as_me:3022: result: yes" >&5
 echo "${ECHO_T}yes" >&6
   SET_MAKE=
 else
-  echo "$as_me:2998: result: no" >&5
+  echo "$as_me:3026: result: no" >&5
 echo "${ECHO_T}no" >&6
   SET_MAKE="MAKE=${MAKE-make}"
 fi
@@ -3012,7 +3040,7 @@
 # AFS /usr/afsws/bin/install, which mishandles nonexistent args
 # SVR4 /usr/ucb/install, which tries to use the nonexistent group "staff"
 # ./install, which can be erroneously created by make from ./install.sh.
-echo "$as_me:3015: checking for a BSD compatible install" >&5
+echo "$as_me:3043: checking for a BSD compatible install" >&5
 echo $ECHO_N "checking for a BSD compatible install... $ECHO_C" >&6
 if test -z "$INSTALL"; then
 if test "${ac_cv_path_install+set}" = set; then
@@ -3061,7 +3089,7 @@
     INSTALL=$ac_install_sh
   fi
 fi
-echo "$as_me:3064: result: $INSTALL" >&5
+echo "$as_me:3092: result: $INSTALL" >&5
 echo "${ECHO_T}$INSTALL" >&6
 
 # Use test -z because SunOS4 sh mishandles braces in ${var-val}.
@@ -3076,13 +3104,13 @@
 /*)
   ;;
 *)
-  cf_dir=`echo $INSTALL | sed -e 's:/[^/]*$::'`
+  cf_dir=`echo $INSTALL | sed -e 's%/[^/]*$%%'`
   test -z "$cf_dir" && cf_dir=.
-  INSTALL=`cd $cf_dir && pwd`/`echo $INSTALL | sed -e 's:^.*/::'`
+  INSTALL=`cd $cf_dir && pwd`/`echo $INSTALL | sed -e 's%^.*/%%'`
   ;;
 esac
 
-echo "$as_me:3085: checking for long file names" >&5
+echo "$as_me:3113: checking for long file names" >&5
 echo $ECHO_N "checking for long file names... $ECHO_C" >&6
 if test "${ac_cv_sys_long_file_names+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3121,7 +3149,7 @@
   rm -rf $ac_xdir 2>/dev/null
 done
 fi
-echo "$as_me:3124: result: $ac_cv_sys_long_file_names" >&5
+echo "$as_me:3152: result: $ac_cv_sys_long_file_names" >&5
 echo "${ECHO_T}$ac_cv_sys_long_file_names" >&6
 if test $ac_cv_sys_long_file_names = yes; then
 
@@ -3131,7 +3159,7 @@
 
 fi
 
-echo "$as_me:3134: checking if filesystem supports mixed-case filenames" >&5
+echo "$as_me:3162: checking if filesystem supports mixed-case filenames" >&5
 echo $ECHO_N "checking if filesystem supports mixed-case filenames... $ECHO_C" >&6
 if test "${cf_cv_mixedcase+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3147,27 +3175,27 @@
 	rm -f conftest CONFTEST
 
 fi
-echo "$as_me:3150: result: $cf_cv_mixedcase" >&5
+echo "$as_me:3178: result: $cf_cv_mixedcase" >&5
 echo "${ECHO_T}$cf_cv_mixedcase" >&6
 test "$cf_cv_mixedcase" = yes && cat >>confdefs.h <<\EOF
 #define MIXEDCASE_FILENAMES 1
 EOF
 
-echo "$as_me:3156: checking whether ln -s works" >&5
+echo "$as_me:3184: checking whether ln -s works" >&5
 echo $ECHO_N "checking whether ln -s works... $ECHO_C" >&6
 LN_S=$as_ln_s
 if test "$LN_S" = "ln -s"; then
-  echo "$as_me:3160: result: yes" >&5
+  echo "$as_me:3188: result: yes" >&5
 echo "${ECHO_T}yes" >&6
 else
-  echo "$as_me:3163: result: no, using $LN_S" >&5
+  echo "$as_me:3191: result: no, using $LN_S" >&5
 echo "${ECHO_T}no, using $LN_S" >&6
 fi
 
 if test -n "$ac_tool_prefix"; then
   # Extract the first word of "${ac_tool_prefix}ranlib", so it can be a program name with args.
 set dummy ${ac_tool_prefix}ranlib; ac_word=$2
-echo "$as_me:3170: checking for $ac_word" >&5
+echo "$as_me:3198: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_RANLIB+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3182,7 +3210,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_RANLIB="${ac_tool_prefix}ranlib"
-echo "$as_me:3185: found $ac_dir/$ac_word" >&5
+echo "$as_me:3213: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3190,10 +3218,10 @@
 fi
 RANLIB=$ac_cv_prog_RANLIB
 if test -n "$RANLIB"; then
-  echo "$as_me:3193: result: $RANLIB" >&5
+  echo "$as_me:3221: result: $RANLIB" >&5
 echo "${ECHO_T}$RANLIB" >&6
 else
-  echo "$as_me:3196: result: no" >&5
+  echo "$as_me:3224: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -3202,7 +3230,7 @@
   ac_ct_RANLIB=$RANLIB
   # Extract the first word of "ranlib", so it can be a program name with args.
 set dummy ranlib; ac_word=$2
-echo "$as_me:3205: checking for $ac_word" >&5
+echo "$as_me:3233: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_ac_ct_RANLIB+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3217,7 +3245,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_ac_ct_RANLIB="ranlib"
-echo "$as_me:3220: found $ac_dir/$ac_word" >&5
+echo "$as_me:3248: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3226,10 +3254,10 @@
 fi
 ac_ct_RANLIB=$ac_cv_prog_ac_ct_RANLIB
 if test -n "$ac_ct_RANLIB"; then
-  echo "$as_me:3229: result: $ac_ct_RANLIB" >&5
+  echo "$as_me:3257: result: $ac_ct_RANLIB" >&5
 echo "${ECHO_T}$ac_ct_RANLIB" >&6
 else
-  echo "$as_me:3232: result: no" >&5
+  echo "$as_me:3260: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -3240,7 +3268,7 @@
 
 # Extract the first word of "ctags", so it can be a program name with args.
 set dummy ctags; ac_word=$2
-echo "$as_me:3243: checking for $ac_word" >&5
+echo "$as_me:3271: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_MAKE_LOWER_TAGS+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3255,7 +3283,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_MAKE_LOWER_TAGS="yes"
-echo "$as_me:3258: found $ac_dir/$ac_word" >&5
+echo "$as_me:3286: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3264,17 +3292,17 @@
 fi
 MAKE_LOWER_TAGS=$ac_cv_prog_MAKE_LOWER_TAGS
 if test -n "$MAKE_LOWER_TAGS"; then
-  echo "$as_me:3267: result: $MAKE_LOWER_TAGS" >&5
+  echo "$as_me:3295: result: $MAKE_LOWER_TAGS" >&5
 echo "${ECHO_T}$MAKE_LOWER_TAGS" >&6
 else
-  echo "$as_me:3270: result: no" >&5
+  echo "$as_me:3298: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
 if test "$cf_cv_mixedcase" = yes ; then
 	# Extract the first word of "etags", so it can be a program name with args.
 set dummy etags; ac_word=$2
-echo "$as_me:3277: checking for $ac_word" >&5
+echo "$as_me:3305: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_MAKE_UPPER_TAGS+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3289,7 +3317,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_MAKE_UPPER_TAGS="yes"
-echo "$as_me:3292: found $ac_dir/$ac_word" >&5
+echo "$as_me:3320: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3298,10 +3326,10 @@
 fi
 MAKE_UPPER_TAGS=$ac_cv_prog_MAKE_UPPER_TAGS
 if test -n "$MAKE_UPPER_TAGS"; then
-  echo "$as_me:3301: result: $MAKE_UPPER_TAGS" >&5
+  echo "$as_me:3329: result: $MAKE_UPPER_TAGS" >&5
 echo "${ECHO_T}$MAKE_UPPER_TAGS" >&6
 else
-  echo "$as_me:3304: result: no" >&5
+  echo "$as_me:3332: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -3325,7 +3353,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:3328: checking for $ac_word" >&5
+echo "$as_me:3356: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_LINT+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3340,7 +3368,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_LINT="$ac_prog"
-echo "$as_me:3343: found $ac_dir/$ac_word" >&5
+echo "$as_me:3371: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3348,10 +3376,10 @@
 fi
 LINT=$ac_cv_prog_LINT
 if test -n "$LINT"; then
-  echo "$as_me:3351: result: $LINT" >&5
+  echo "$as_me:3379: result: $LINT" >&5
 echo "${ECHO_T}$LINT" >&6
 else
-  echo "$as_me:3354: result: no" >&5
+  echo "$as_me:3382: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -3362,7 +3390,7 @@
 do
   # Extract the first word of "$ac_prog", so it can be a program name with args.
 set dummy $ac_prog; ac_word=$2
-echo "$as_me:3365: checking for $ac_word" >&5
+echo "$as_me:3393: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_MAN+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3377,7 +3405,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_MAN="$ac_prog"
-echo "$as_me:3380: found $ac_dir/$ac_word" >&5
+echo "$as_me:3408: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -3385,54 +3413,172 @@
 fi
 MAN=$ac_cv_prog_MAN
 if test -n "$MAN"; then
-  echo "$as_me:3388: result: $MAN" >&5
+  echo "$as_me:3416: result: $MAN" >&5
 echo "${ECHO_T}$MAN" >&6
 else
-  echo "$as_me:3391: result: no" >&5
+  echo "$as_me:3419: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
   test -n "$MAN" && break
 done
 
-if test "${cf_cv_subst_LD+set}" = set; then
+if test -n "$ac_tool_prefix"; then
+  # Extract the first word of "${ac_tool_prefix}ld", so it can be a program name with args.
+set dummy ${ac_tool_prefix}ld; ac_word=$2
+echo "$as_me:3429: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_prog_LD+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
+  if test -n "$LD"; then
+  ac_cv_prog_LD="$LD" # Let the user override the test.
+else
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  $as_executable_p "$ac_dir/$ac_word" || continue
+ac_cv_prog_LD="${ac_tool_prefix}ld"
+echo "$as_me:3444: found $ac_dir/$ac_word" >&5
+break
+done
 
-echo "$as_me:3402: checking for loader (symbol LD)" >&5
-echo $ECHO_N "checking for loader (symbol LD)... $ECHO_C" >&6
-test -z "$LD" && LD=ld
-echo "$as_me:3405: result: $LD" >&5
+fi
+fi
+LD=$ac_cv_prog_LD
+if test -n "$LD"; then
+  echo "$as_me:3452: result: $LD" >&5
 echo "${ECHO_T}$LD" >&6
+else
+  echo "$as_me:3455: result: no" >&5
+echo "${ECHO_T}no" >&6
+fi
 
-cf_cv_subst_LD=$LD
+fi
+if test -z "$ac_cv_prog_LD"; then
+  ac_ct_LD=$LD
+  # Extract the first word of "ld", so it can be a program name with args.
+set dummy ld; ac_word=$2
+echo "$as_me:3464: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_prog_ac_ct_LD+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+  if test -n "$ac_ct_LD"; then
+  ac_cv_prog_ac_ct_LD="$ac_ct_LD" # Let the user override the test.
+else
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  $as_executable_p "$ac_dir/$ac_word" || continue
+ac_cv_prog_ac_ct_LD="ld"
+echo "$as_me:3479: found $ac_dir/$ac_word" >&5
+break
+done
+
+  test -z "$ac_cv_prog_ac_ct_LD" && ac_cv_prog_ac_ct_LD="ld"
+fi
+fi
+ac_ct_LD=$ac_cv_prog_ac_ct_LD
+if test -n "$ac_ct_LD"; then
+  echo "$as_me:3488: result: $ac_ct_LD" >&5
+echo "${ECHO_T}$ac_ct_LD" >&6
+else
+  echo "$as_me:3491: result: no" >&5
+echo "${ECHO_T}no" >&6
 fi
 
-LD=${cf_cv_subst_LD}
+  LD=$ac_ct_LD
+else
+  LD="$ac_cv_prog_LD"
+fi
 
-if test "${cf_cv_subst_AR+set}" = set; then
+if test -n "$ac_tool_prefix"; then
+  # Extract the first word of "${ac_tool_prefix}ar", so it can be a program name with args.
+set dummy ${ac_tool_prefix}ar; ac_word=$2
+echo "$as_me:3503: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_prog_AR+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
+  if test -n "$AR"; then
+  ac_cv_prog_AR="$AR" # Let the user override the test.
+else
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  $as_executable_p "$ac_dir/$ac_word" || continue
+ac_cv_prog_AR="${ac_tool_prefix}ar"
+echo "$as_me:3518: found $ac_dir/$ac_word" >&5
+break
+done
 
-echo "$as_me:3417: checking for archiver (symbol AR)" >&5
-echo $ECHO_N "checking for archiver (symbol AR)... $ECHO_C" >&6
-test -z "$AR" && AR=ar
-echo "$as_me:3420: result: $AR" >&5
+fi
+fi
+AR=$ac_cv_prog_AR
+if test -n "$AR"; then
+  echo "$as_me:3526: result: $AR" >&5
 echo "${ECHO_T}$AR" >&6
+else
+  echo "$as_me:3529: result: no" >&5
+echo "${ECHO_T}no" >&6
+fi
+
+fi
+if test -z "$ac_cv_prog_AR"; then
+  ac_ct_AR=$AR
+  # Extract the first word of "ar", so it can be a program name with args.
+set dummy ar; ac_word=$2
+echo "$as_me:3538: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_prog_ac_ct_AR+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+  if test -n "$ac_ct_AR"; then
+  ac_cv_prog_ac_ct_AR="$ac_ct_AR" # Let the user override the test.
+else
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  $as_executable_p "$ac_dir/$ac_word" || continue
+ac_cv_prog_ac_ct_AR="ar"
+echo "$as_me:3553: found $ac_dir/$ac_word" >&5
+break
+done
 
-cf_cv_subst_AR=$AR
+  test -z "$ac_cv_prog_ac_ct_AR" && ac_cv_prog_ac_ct_AR="ar"
+fi
+fi
+ac_ct_AR=$ac_cv_prog_ac_ct_AR
+if test -n "$ac_ct_AR"; then
+  echo "$as_me:3562: result: $ac_ct_AR" >&5
+echo "${ECHO_T}$ac_ct_AR" >&6
+else
+  echo "$as_me:3565: result: no" >&5
+echo "${ECHO_T}no" >&6
 fi
 
-AR=${cf_cv_subst_AR}
+  AR=$ac_ct_AR
+else
+  AR="$ac_cv_prog_AR"
+fi
 
 if test "${cf_cv_subst_AR_OPTS+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
-echo "$as_me:3432: checking for archiver options (symbol AR_OPTS)" >&5
+echo "$as_me:3578: checking for archiver options (symbol AR_OPTS)" >&5
 echo $ECHO_N "checking for archiver options (symbol AR_OPTS)... $ECHO_C" >&6
 test -z "$AR_OPTS" && AR_OPTS=rv
-echo "$as_me:3435: result: $AR_OPTS" >&5
+echo "$as_me:3581: result: $AR_OPTS" >&5
 echo "${ECHO_T}$AR_OPTS" >&6
 
 cf_cv_subst_AR_OPTS=$AR_OPTS
@@ -3440,7 +3586,7 @@
 
 AR_OPTS=${cf_cv_subst_AR_OPTS}
 
-echo "$as_me:3443: checking for makeflags variable" >&5
+echo "$as_me:3589: checking for makeflags variable" >&5
 echo $ECHO_N "checking for makeflags variable... $ECHO_C" >&6
 if test "${cf_cv_makeflags+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3473,10 +3619,10 @@
 	rm -f cf_makeflags.tmp
 
 fi
-echo "$as_me:3476: result: $cf_cv_makeflags" >&5
+echo "$as_me:3622: result: $cf_cv_makeflags" >&5
 echo "${ECHO_T}$cf_cv_makeflags" >&6
 
-echo "$as_me:3479: checking if you have specified an install-prefix" >&5
+echo "$as_me:3625: checking if you have specified an install-prefix" >&5
 echo $ECHO_N "checking if you have specified an install-prefix... $ECHO_C" >&6
 
 # Check whether --with-install-prefix or --without-install-prefix was given.
@@ -3489,7 +3635,7 @@
 		;;
 	esac
 fi;
-echo "$as_me:3492: result: $DESTDIR" >&5
+echo "$as_me:3638: result: $DESTDIR" >&5
 echo "${ECHO_T}$DESTDIR" >&6
 
 ###############################################################################
@@ -3499,7 +3645,15 @@
 ### shared, for example.
 cf_list_models=""
 
-echo "$as_me:3502: checking if you want to build libraries with libtool" >&5
+LIBTOOL=
+LIB_CREATE='$(AR) -cr'
+LIB_OBJECT='$(OBJECTS)'
+LIB_SUFFIX=.a
+LIB_INSTALL=
+LIB_UNINSTALL=
+LIB_PREP="$RANLIB"
+
+echo "$as_me:3656: checking if you want to build libraries with libtool" >&5
 echo $ECHO_N "checking if you want to build libraries with libtool... $ECHO_C" >&6
 
 # Check whether --with-libtool or --without-libtool was given.
@@ -3509,16 +3663,87 @@
 else
   with_libtool=no
 fi;
-echo "$as_me:3512: result: $with_libtool" >&5
+echo "$as_me:3666: result: $with_libtool" >&5
 echo "${ECHO_T}$with_libtool" >&6
 if test "$with_libtool" = "yes"; then
-	cf_list_models="$cf_list_models libtool"
-	test -z "$LIBTOOL" && LIBTOOL=libtool
+	# Extract the first word of "libtool", so it can be a program name with args.
+set dummy libtool; ac_word=$2
+echo "$as_me:3671: checking for $ac_word" >&5
+echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
+if test "${ac_cv_path_LIBTOOL+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+  case $LIBTOOL in
+  [\\/]* | ?:[\\/]*)
+  ac_cv_path_LIBTOOL="$LIBTOOL" # Let the user override the test with a path.
+  ;;
+  *)
+  ac_save_IFS=$IFS; IFS=$ac_path_separator
+ac_dummy="$PATH"
+for ac_dir in $ac_dummy; do
+  IFS=$ac_save_IFS
+  test -z "$ac_dir" && ac_dir=.
+  if $as_executable_p "$ac_dir/$ac_word"; then
+   ac_cv_path_LIBTOOL="$ac_dir/$ac_word"
+   echo "$as_me:3688: found $ac_dir/$ac_word" >&5
+   break
+fi
+done
+
+  ;;
+esac
+fi
+LIBTOOL=$ac_cv_path_LIBTOOL
+
+if test -n "$LIBTOOL"; then
+  echo "$as_me:3699: result: $LIBTOOL" >&5
+echo "${ECHO_T}$LIBTOOL" >&6
+else
+  echo "$as_me:3702: result: no" >&5
+echo "${ECHO_T}no" >&6
+fi
+
+	if test -z "$LIBTOOL" ; then
+		{ { echo "$as_me:3707: error: Cannot find libtool" >&5
+echo "$as_me: error: Cannot find libtool" >&2;}
+   { (exit 1); exit 1; }; }
+	fi
+
+	LIB_CREATE='$(LIBTOOL) --mode=link $(CC) -rpath $(DESTDIR)$(libdir) -version-info `cut -f1 $(srcdir)/VERSION` -o'
+	LIB_OBJECT='$(OBJECTS:.o=.lo)'
+	LIB_SUFFIX=.la
+	LIB_INSTALL='$(LIBTOOL) --mode=install'
+	LIB_UNINSTALL='$(LIBTOOL) --mode=uninstall'
+	LIB_PREP=:
+
+	# Show the version of libtool
+	echo "$as_me:3720: checking version of libtool" >&5
+echo $ECHO_N "checking version of libtool... $ECHO_C" >&6
+
+	# Save the version in a cache variable - this is not entirely a good
+	# thing, but the version string from libtool is very ugly, and for
+	# bug reports it might be useful to have the original string.
+	cf_cv_libtool_version=`$LIBTOOL --version 2>&1 | sed -e 's/^[^1-9]*//' -e 's/[^0-9.].*//'`
+	echo "$as_me:3727: result: $cf_cv_libtool_version" >&5
+echo "${ECHO_T}$cf_cv_libtool_version" >&6
+	if test -z "$cf_cv_libtool_version" ; then
+		{ { echo "$as_me:3730: error: This is not libtool" >&5
+echo "$as_me: error: This is not libtool" >&2;}
+   { (exit 1); exit 1; }; }
+	fi
 else
 	LIBTOOL=""
 fi
 
-echo "$as_me:3521: checking if you want to build shared libraries" >&5
+test -z "$LIBTOOL" && ECHO_LT=
+
+if test "$with_libtool" = "yes" ; then
+
+cf_list_models="$cf_list_models libtool"
+
+else
+
+echo "$as_me:3746: checking if you want to build shared libraries" >&5
 echo $ECHO_N "checking if you want to build shared libraries... $ECHO_C" >&6
 
 # Check whether --with-shared or --without-shared was given.
@@ -3528,11 +3753,11 @@
 else
   with_shared=no
 fi;
-echo "$as_me:3531: result: $with_shared" >&5
+echo "$as_me:3756: result: $with_shared" >&5
 echo "${ECHO_T}$with_shared" >&6
 test "$with_shared" = "yes" && cf_list_models="$cf_list_models shared"
 
-echo "$as_me:3535: checking if you want to build static libraries" >&5
+echo "$as_me:3760: checking if you want to build static libraries" >&5
 echo $ECHO_N "checking if you want to build static libraries... $ECHO_C" >&6
 
 # Check whether --with-normal or --without-normal was given.
@@ -3542,11 +3767,11 @@
 else
   with_normal=yes
 fi;
-echo "$as_me:3545: result: $with_normal" >&5
+echo "$as_me:3770: result: $with_normal" >&5
 echo "${ECHO_T}$with_normal" >&6
 test "$with_normal" = "yes" && cf_list_models="$cf_list_models normal"
 
-echo "$as_me:3549: checking if you want to build debug libraries" >&5
+echo "$as_me:3774: checking if you want to build debug libraries" >&5
 echo $ECHO_N "checking if you want to build debug libraries... $ECHO_C" >&6
 
 # Check whether --with-debug or --without-debug was given.
@@ -3556,11 +3781,11 @@
 else
   with_debug=yes
 fi;
-echo "$as_me:3559: result: $with_debug" >&5
+echo "$as_me:3784: result: $with_debug" >&5
 echo "${ECHO_T}$with_debug" >&6
 test "$with_debug" = "yes" && cf_list_models="$cf_list_models debug"
 
-echo "$as_me:3563: checking if you want to build profiling libraries" >&5
+echo "$as_me:3788: checking if you want to build profiling libraries" >&5
 echo $ECHO_N "checking if you want to build profiling libraries... $ECHO_C" >&6
 
 # Check whether --with-profile or --without-profile was given.
@@ -3570,25 +3795,27 @@
 else
   with_profile=no
 fi;
-echo "$as_me:3573: result: $with_profile" >&5
+echo "$as_me:3798: result: $with_profile" >&5
 echo "${ECHO_T}$with_profile" >&6
 test "$with_profile" = "yes" && cf_list_models="$cf_list_models profile"
 
+fi
+
 ###############################################################################
 
-echo "$as_me:3579: checking for specified models" >&5
+echo "$as_me:3806: checking for specified models" >&5
 echo $ECHO_N "checking for specified models... $ECHO_C" >&6
 test -z "$cf_list_models" && cf_list_models=normal
 test "$with_libtool" = "yes" && cf_list_models=libtool
-echo "$as_me:3583: result: $cf_list_models" >&5
+echo "$as_me:3810: result: $cf_list_models" >&5
 echo "${ECHO_T}$cf_list_models" >&6
 
 ### Use the first model as the default, and save its suffix for use in building
 ### up test-applications.
-echo "$as_me:3588: checking for default model" >&5
+echo "$as_me:3815: checking for default model" >&5
 echo $ECHO_N "checking for default model... $ECHO_C" >&6
-DFT_LWR_MODEL=`echo $cf_list_models | $AWK '{print $1}'`
-echo "$as_me:3591: result: $DFT_LWR_MODEL" >&5
+DFT_LWR_MODEL=`echo "$cf_list_models" | $AWK '{print $1}'`
+echo "$as_me:3818: result: $DFT_LWR_MODEL" >&5
 echo "${ECHO_T}$DFT_LWR_MODEL" >&6
 
 DFT_UPR_MODEL=`echo "$DFT_LWR_MODEL" | sed y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%`
@@ -3612,7 +3839,7 @@
 
 ###############################################################################
 
-echo "$as_me:3615: checking if you want to build a separate terminfo library" >&5
+echo "$as_me:3842: checking if you want to build a separate terminfo library" >&5
 echo $ECHO_N "checking if you want to build a separate terminfo library... $ECHO_C" >&6
 
 # Check whether --with-termlib or --without-termlib was given.
@@ -3622,11 +3849,12 @@
 else
   with_termlib=no
 fi;
-echo "$as_me:3625: result: $with_termlib" >&5
+echo "$as_me:3852: result: $with_termlib" >&5
 echo "${ECHO_T}$with_termlib" >&6
 
 ### Checks for special libraries, must be done up-front.
-echo "$as_me:3629: checking if you want to link with dbmalloc for testing" >&5
+
+echo "$as_me:3857: checking if you want to link with dbmalloc for testing" >&5
 echo $ECHO_N "checking if you want to link with dbmalloc for testing... $ECHO_C" >&6
 
 # Check whether --with-dbmalloc or --without-dbmalloc was given.
@@ -3636,11 +3864,11 @@
 else
   with_dbmalloc=no
 fi;
-echo "$as_me:3639: result: $with_dbmalloc" >&5
+echo "$as_me:3867: result: $with_dbmalloc" >&5
 echo "${ECHO_T}$with_dbmalloc" >&6
-if test "$with_dbmalloc" = yes ; then
+if test $with_dbmalloc = yes ; then
 
-echo "$as_me:3643: checking for debug_malloc in -ldbmalloc" >&5
+echo "$as_me:3871: checking for debug_malloc in -ldbmalloc" >&5
 echo $ECHO_N "checking for debug_malloc in -ldbmalloc... $ECHO_C" >&6
 if test "${ac_cv_lib_dbmalloc_debug_malloc+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3648,7 +3876,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-ldbmalloc  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 3651 "configure"
+#line 3879 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -3667,16 +3895,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:3670: \"$ac_link\"") >&5
+if { (eval echo "$as_me:3898: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:3673: \$? = $ac_status" >&5
+  echo "$as_me:3901: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:3676: \"$ac_try\"") >&5
+  { (eval echo "$as_me:3904: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:3679: \$? = $ac_status" >&5
+  echo "$as_me:3907: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_dbmalloc_debug_malloc=yes
 else
@@ -3687,7 +3915,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:3690: result: $ac_cv_lib_dbmalloc_debug_malloc" >&5
+echo "$as_me:3918: result: $ac_cv_lib_dbmalloc_debug_malloc" >&5
 echo "${ECHO_T}$ac_cv_lib_dbmalloc_debug_malloc" >&6
 if test $ac_cv_lib_dbmalloc_debug_malloc = yes; then
   cat >>confdefs.h <<EOF
@@ -3700,7 +3928,7 @@
 
 fi
 
-echo "$as_me:3703: checking if you want to link with dmalloc for testing" >&5
+echo "$as_me:3931: checking if you want to link with dmalloc for testing" >&5
 echo $ECHO_N "checking if you want to link with dmalloc for testing... $ECHO_C" >&6
 
 # Check whether --with-dmalloc or --without-dmalloc was given.
@@ -3710,11 +3938,11 @@
 else
   with_dmalloc=no
 fi;
-echo "$as_me:3713: result: $with_dmalloc" >&5
+echo "$as_me:3941: result: $with_dmalloc" >&5
 echo "${ECHO_T}$with_dmalloc" >&6
-if test "$with_dmalloc" = yes ; then
+if test $with_dmalloc = yes ; then
 
-echo "$as_me:3717: checking for dmalloc_debug in -ldmalloc" >&5
+echo "$as_me:3945: checking for dmalloc_debug in -ldmalloc" >&5
 echo $ECHO_N "checking for dmalloc_debug in -ldmalloc... $ECHO_C" >&6
 if test "${ac_cv_lib_dmalloc_dmalloc_debug+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3722,7 +3950,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-ldmalloc  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 3725 "configure"
+#line 3953 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -3741,16 +3969,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:3744: \"$ac_link\"") >&5
+if { (eval echo "$as_me:3972: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:3747: \$? = $ac_status" >&5
+  echo "$as_me:3975: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:3750: \"$ac_try\"") >&5
+  { (eval echo "$as_me:3978: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:3753: \$? = $ac_status" >&5
+  echo "$as_me:3981: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_dmalloc_dmalloc_debug=yes
 else
@@ -3761,7 +3989,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:3764: result: $ac_cv_lib_dmalloc_dmalloc_debug" >&5
+echo "$as_me:3992: result: $ac_cv_lib_dmalloc_dmalloc_debug" >&5
 echo "${ECHO_T}$ac_cv_lib_dmalloc_dmalloc_debug" >&6
 if test $ac_cv_lib_dmalloc_dmalloc_debug = yes; then
   cat >>confdefs.h <<EOF
@@ -3775,7 +4003,7 @@
 fi
 
 SHLIB_LIST=""
-echo "$as_me:3778: checking if you want to link with the gpm mouse library" >&5
+echo "$as_me:4006: checking if you want to link with the gpm mouse library" >&5
 echo $ECHO_N "checking if you want to link with the gpm mouse library... $ECHO_C" >&6
 
 # Check whether --with-gpm or --without-gpm was given.
@@ -3785,10 +4013,10 @@
 else
   with_gpm=no
 fi;
-echo "$as_me:3788: result: $with_gpm" >&5
+echo "$as_me:4016: result: $with_gpm" >&5
 echo "${ECHO_T}$with_gpm" >&6
 if test "$with_gpm" = yes ; then
-	echo "$as_me:3791: checking for Gpm_Open in -lgpm" >&5
+	echo "$as_me:4019: checking for Gpm_Open in -lgpm" >&5
 echo $ECHO_N "checking for Gpm_Open in -lgpm... $ECHO_C" >&6
 if test "${ac_cv_lib_gpm_Gpm_Open+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -3796,7 +4024,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-lgpm  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 3799 "configure"
+#line 4027 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -3815,16 +4043,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:3818: \"$ac_link\"") >&5
+if { (eval echo "$as_me:4046: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:3821: \$? = $ac_status" >&5
+  echo "$as_me:4049: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:3824: \"$ac_try\"") >&5
+  { (eval echo "$as_me:4052: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:3827: \$? = $ac_status" >&5
+  echo "$as_me:4055: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_gpm_Gpm_Open=yes
 else
@@ -3835,7 +4063,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:3838: result: $ac_cv_lib_gpm_Gpm_Open" >&5
+echo "$as_me:4066: result: $ac_cv_lib_gpm_Gpm_Open" >&5
 echo "${ECHO_T}$ac_cv_lib_gpm_Gpm_Open" >&6
 if test $ac_cv_lib_gpm_Gpm_Open = yes; then
 
@@ -3848,23 +4076,23 @@
 for ac_header in gpm.h
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:3851: checking for $ac_header" >&5
+echo "$as_me:4079: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 3857 "configure"
+#line 4085 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:3861: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:4089: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:3867: \$? = $ac_status" >&5
+  echo "$as_me:4095: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -3883,7 +4111,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:3886: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:4114: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -3894,12 +4122,76 @@
 done
 
 else
-  { echo "$as_me:3897: WARNING: Cannot link with gpm library - read the FAQ" >&5
+  { echo "$as_me:4125: WARNING: Cannot link with gpm library - read the FAQ" >&5
 echo "$as_me: WARNING: Cannot link with gpm library - read the FAQ" >&2;}
 fi
 
 fi
 
+# not everyone has "test -c"
+if test -c /dev/sysmouse 2>/dev/null ; then
+echo "$as_me:4133: checking if you want to use sysmouse" >&5
+echo $ECHO_N "checking if you want to use sysmouse... $ECHO_C" >&6
+
+# Check whether --with-sysmouse or --without-sysmouse was given.
+if test "${with_sysmouse+set}" = set; then
+  withval="$with_sysmouse"
+  cf_with_sysmouse=$withval
+else
+  cf_with_sysmouse=maybe
+fi;
+	if test "$cf_with_sysmouse" != no ; then
+	cat >conftest.$ac_ext <<_ACEOF
+#line 4145 "configure"
+#include "confdefs.h"
+
+#include <osreldate.h>
+#if (__FreeBSD_version >= 400017)
+#include <sys/consio.h>
+#include <sys/fbio.h>
+#else
+#include <machine/console.h>
+#endif
+
+int
+main ()
+{
+
+	struct mouse_info the_mouse;
+	ioctl(0, CONS_MOUSECTL, &the_mouse);
+
+  ;
+  return 0;
+}
+_ACEOF
+rm -f conftest.$ac_objext
+if { (eval echo "$as_me:4168: \"$ac_compile\"") >&5
+  (eval $ac_compile) 2>&5
+  ac_status=$?
+  echo "$as_me:4171: \$? = $ac_status" >&5
+  (exit $ac_status); } &&
+         { ac_try='test -s conftest.$ac_objext'
+  { (eval echo "$as_me:4174: \"$ac_try\"") >&5
+  (eval $ac_try) 2>&5
+  ac_status=$?
+  echo "$as_me:4177: \$? = $ac_status" >&5
+  (exit $ac_status); }; }; then
+  cf_with_sysmouse=yes
+else
+  echo "$as_me: failed program was:" >&5
+cat conftest.$ac_ext >&5
+cf_with_sysmouse=no
+fi
+rm -f conftest.$ac_objext conftest.$ac_ext
+	fi
+echo "$as_me:4187: result: $cf_with_sysmouse" >&5
+echo "${ECHO_T}$cf_with_sysmouse" >&6
+test "$cf_with_sysmouse" = yes && cat >>confdefs.h <<\EOF
+#define USE_SYSMOUSE 1
+EOF
+
+fi
+
 if test X"$CC_G_OPT" = X"" ; then
 	CC_G_OPT='-g'
 	test -n "$GCC" && test "${ac_cv_prog_cc_g}" != yes && CC_G_OPT=''
@@ -3910,7 +4202,7 @@
 	test -n "$GXX" && test "${ac_cv_prog_cxx_g}" != yes && CXX_G_OPT=''
 fi
 
-echo "$as_me:3913: checking for default loader flags" >&5
+echo "$as_me:4205: checking for default loader flags" >&5
 echo $ECHO_N "checking for default loader flags... $ECHO_C" >&6
 case $DFT_LWR_MODEL in
 libtool) LD_MODEL=''   ;;
@@ -3919,10 +4211,10 @@
 profile) LD_MODEL='-pg';;
 shared)  LD_MODEL=''   ;;
 esac
-echo "$as_me:3922: result: $LD_MODEL" >&5
+echo "$as_me:4214: result: $LD_MODEL" >&5
 echo "${ECHO_T}$LD_MODEL" >&6
 
-echo "$as_me:3925: checking if rpath option should be used" >&5
+echo "$as_me:4217: checking if rpath option should be used" >&5
 echo $ECHO_N "checking if rpath option should be used... $ECHO_C" >&6
 
 # Check whether --enable-rpath or --disable-rpath was given.
@@ -3932,7 +4224,7 @@
 else
   cf_cv_ld_rpath=no
 fi;
-echo "$as_me:3935: result: $cf_cv_ld_rpath" >&5
+echo "$as_me:4227: result: $cf_cv_ld_rpath" >&5
 echo "${ECHO_T}$cf_cv_ld_rpath" >&6
 
 	LOCAL_LDFLAGS=
@@ -3942,7 +4234,7 @@
 
 	cf_cv_do_symlinks=no
 
-	echo "$as_me:3945: checking if release/abi version should be used for shared libs" >&5
+	echo "$as_me:4237: checking if release/abi version should be used for shared libs" >&5
 echo $ECHO_N "checking if release/abi version should be used for shared libs... $ECHO_C" >&6
 
 # Check whether --with-shlib-version or --without-shlib-version was given.
@@ -3957,7 +4249,7 @@
 		cf_cv_shlib_version=$withval
 		;;
 	*)
-		{ { echo "$as_me:3960: error: option value must be one of: rel, abi, auto or no" >&5
+		{ { echo "$as_me:4252: error: option value must be one of: rel, abi, auto or no" >&5
 echo "$as_me: error: option value must be one of: rel, abi, auto or no" >&2;}
    { (exit 1); exit 1; }; }
 		;;
@@ -3966,7 +4258,7 @@
 else
   cf_cv_shlib_version=auto
 fi;
-	echo "$as_me:3969: result: $cf_cv_shlib_version" >&5
+	echo "$as_me:4261: result: $cf_cv_shlib_version" >&5
 echo "${ECHO_T}$cf_cv_shlib_version" >&6
 
 	cf_cv_rm_so_locs=no
@@ -3975,14 +4267,14 @@
 	CC_SHARED_OPTS=
 	if test "$GCC" = yes
 	then
-		echo "$as_me:3978: checking which $CC option to use" >&5
+		echo "$as_me:4270: checking which $CC option to use" >&5
 echo $ECHO_N "checking which $CC option to use... $ECHO_C" >&6
 		cf_save_CFLAGS="$CFLAGS"
 		for CC_SHARED_OPTS in -fPIC -fpic ''
 		do
 			CFLAGS="$cf_save_CFLAGS $CC_SHARED_OPTS"
 			cat >conftest.$ac_ext <<_ACEOF
-#line 3985 "configure"
+#line 4277 "configure"
 #include "confdefs.h"
 #include <stdio.h>
 int
@@ -3994,16 +4286,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:3997: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:4289: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:4000: \$? = $ac_status" >&5
+  echo "$as_me:4292: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:4003: \"$ac_try\"") >&5
+  { (eval echo "$as_me:4295: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4006: \$? = $ac_status" >&5
+  echo "$as_me:4298: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   break
 else
@@ -4012,7 +4304,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 		done
-		echo "$as_me:4015: result: $CC_SHARED_OPTS" >&5
+		echo "$as_me:4307: result: $CC_SHARED_OPTS" >&5
 echo "${ECHO_T}$CC_SHARED_OPTS" >&6
 		CFLAGS="$cf_save_CFLAGS"
 	fi
@@ -4061,7 +4353,7 @@
 		MK_SHARED_LIB='$(LD) -shared -rdata_shared -soname `basename $@` -o $@'
 		cf_cv_rm_so_locs=yes
 		;;
-	linux*|gnu*)
+	linux*|gnu*|k*bsd*-gnu)
 		if test "$DFT_LWR_MODEL" = "shared" ; then
 			LOCAL_LDFLAGS="-Wl,-rpath,`pwd`/lib"
 			LOCAL_LDFLAGS2="$LOCAL_LDFLAGS"
@@ -4122,7 +4414,7 @@
 		;;
 	sco3.2v5*)  # (also uw2* and UW7) hops 13-Apr-98
 		# tested with osr5.0.5
-		if test "$ac_cv_c_compiler_gnu" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-belf -KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -dy -G -h `basename $@ .$(REL_VERSION)`.$(ABI_VERSION) -o $@'
@@ -4136,7 +4428,7 @@
 		;;
 	sunos4*)
 		# tested with SunOS 4.1.1 and gcc 2.7.0
-		if test "$ac_cv_c_compiler_gnu" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -assert pure-text -o $@'
@@ -4144,7 +4436,7 @@
 		;;
 	solaris2*)
 		# tested with SunOS 5.5.1 (solaris 2.5.1) and gcc 2.7.2
-		if test "$ac_cv_c_compiler_gnu" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -dy -G -h `basename $@ .$(REL_VERSION)`.$(ABI_VERSION) -o $@'
@@ -4160,7 +4452,7 @@
 		;;
 	sysv5uw7*|unix_sv*)
 		# tested with UnixWare 7.1.0 (gcc 2.95.2 and cc)
-		if test "$ac_cv_c_compiler_gnu" != yes; then
+		if test "$GCC" != yes; then
 			CC_SHARED_OPTS='-KPIC'
 		fi
 		MK_SHARED_LIB='$(LD) -d y -G -o $@'
@@ -4179,7 +4471,7 @@
 			test "$cf_cv_do_symlinks" = no && cf_cv_do_symlinks=yes
 			;;
 		*)
-			{ echo "$as_me:4182: WARNING: ignored --with-shlib-version" >&5
+			{ echo "$as_me:4474: WARNING: ignored --with-shlib-version" >&5
 echo "$as_me: WARNING: ignored --with-shlib-version" >&2;}
 			;;
 		esac
@@ -4187,12 +4479,12 @@
 	esac
 
 	if test -n "$cf_ld_rpath_opt" ; then
-		echo "$as_me:4190: checking if we need a space after rpath option" >&5
+		echo "$as_me:4482: checking if we need a space after rpath option" >&5
 echo $ECHO_N "checking if we need a space after rpath option... $ECHO_C" >&6
 		cf_save_LIBS="$LIBS"
 		LIBS="$LIBS ${cf_ld_rpath_opt}$libdir"
 		cat >conftest.$ac_ext <<_ACEOF
-#line 4195 "configure"
+#line 4487 "configure"
 #include "confdefs.h"
 
 int
@@ -4204,16 +4496,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:4207: \"$ac_link\"") >&5
+if { (eval echo "$as_me:4499: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:4210: \$? = $ac_status" >&5
+  echo "$as_me:4502: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:4213: \"$ac_try\"") >&5
+  { (eval echo "$as_me:4505: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4216: \$? = $ac_status" >&5
+  echo "$as_me:4508: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_rpath_space=no
 else
@@ -4223,7 +4515,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 		LIBS="$cf_save_LIBS"
-		echo "$as_me:4226: result: $cf_rpath_space" >&5
+		echo "$as_me:4518: result: $cf_rpath_space" >&5
 echo "${ECHO_T}$cf_rpath_space" >&6
 		test "$cf_rpath_space" = yes && cf_ld_rpath_opt="$cf_ld_rpath_opt "
 		MK_SHARED_LIB="$MK_SHARED_LIB $cf_ld_rpath_opt\$(libdir)"
@@ -4232,7 +4524,7 @@
 if test "$CC_SHARED_OPTS" = "unknown"; then
 	for model in $cf_list_models; do
 		if test "$model" = "shared"; then
-			{ { echo "$as_me:4235: error: Shared libraries are not supported in this version" >&5
+			{ { echo "$as_me:4527: error: Shared libraries are not supported in this version" >&5
 echo "$as_me: error: Shared libraries are not supported in this version" >&2;}
    { (exit 1); exit 1; }; }
 		fi
@@ -4242,7 +4534,7 @@
 ###############################################################################
 
 ###	use option --disable-overwrite to leave out the link to -lcurses
-echo "$as_me:4245: checking if you wish to install ncurses overwriting curses" >&5
+echo "$as_me:4537: checking if you wish to install ncurses overwriting curses" >&5
 echo $ECHO_N "checking if you wish to install ncurses overwriting curses... $ECHO_C" >&6
 
 # Check whether --enable-overwrite or --disable-overwrite was given.
@@ -4252,10 +4544,10 @@
 else
   if test "$prefix" = "/usr" ; then with_overwrite=yes; else with_overwrite=no; fi
 fi;
-echo "$as_me:4255: result: $with_overwrite" >&5
+echo "$as_me:4547: result: $with_overwrite" >&5
 echo "${ECHO_T}$with_overwrite" >&6
 
-echo "$as_me:4258: checking if external terminfo-database is used" >&5
+echo "$as_me:4550: checking if external terminfo-database is used" >&5
 echo $ECHO_N "checking if external terminfo-database is used... $ECHO_C" >&6
 
 # Check whether --enable-database or --disable-database was given.
@@ -4265,7 +4557,7 @@
 else
   use_database=yes
 fi;
-echo "$as_me:4268: result: $use_database" >&5
+echo "$as_me:4560: result: $use_database" >&5
 echo "${ECHO_T}$use_database" >&6
 
 case $host_os in #(vi
@@ -4287,7 +4579,7 @@
 #define USE_DATABASE 1
 EOF
 
-	echo "$as_me:4290: checking which terminfo source-file will be installed" >&5
+	echo "$as_me:4582: checking which terminfo source-file will be installed" >&5
 echo $ECHO_N "checking which terminfo source-file will be installed... $ECHO_C" >&6
 
 # Check whether --enable-database or --disable-database was given.
@@ -4295,11 +4587,11 @@
   enableval="$enable_database"
   TERMINFO_SRC=$withval
 fi;
-	echo "$as_me:4298: result: $TERMINFO_SRC" >&5
+	echo "$as_me:4590: result: $TERMINFO_SRC" >&5
 echo "${ECHO_T}$TERMINFO_SRC" >&6
 fi
 
-echo "$as_me:4302: checking for list of fallback descriptions" >&5
+echo "$as_me:4594: checking for list of fallback descriptions" >&5
 echo $ECHO_N "checking for list of fallback descriptions... $ECHO_C" >&6
 
 # Check whether --with-fallbacks or --without-fallbacks was given.
@@ -4309,9 +4601,9 @@
 else
   with_fallback=
 fi;
-echo "$as_me:4312: result: $with_fallback" >&5
+echo "$as_me:4604: result: $with_fallback" >&5
 echo "${ECHO_T}$with_fallback" >&6
-FALLBACK_LIST=`echo $with_fallback|sed -e 's/,/ /g'`
+FALLBACK_LIST=`echo "$with_fallback" | sed -e 's/,/ /g'`
 
 MAKE_TERMINFO=
 if test "$use_database" = no ; then
@@ -4319,7 +4611,7 @@
 	MAKE_TERMINFO="#"
 else
 
-echo "$as_me:4322: checking for list of terminfo directories" >&5
+echo "$as_me:4614: checking for list of terminfo directories" >&5
 echo $ECHO_N "checking for list of terminfo directories... $ECHO_C" >&6
 
 # Check whether --with-terminfo-dirs or --without-terminfo-dirs was given.
@@ -4353,7 +4645,7 @@
   cf_src_path=`echo $cf_src_path | sed -e s%NONE%$ac_default_prefix%`
   ;;
 *)
-  { { echo "$as_me:4356: error: expected a pathname, not \"$cf_src_path\"" >&5
+  { { echo "$as_me:4648: error: expected a pathname, not \"$cf_src_path\"" >&5
 echo "$as_me: error: expected a pathname, not \"$cf_src_path\"" >&2;}
    { (exit 1); exit 1; }; }
   ;;
@@ -4366,13 +4658,13 @@
 
 eval 'TERMINFO_DIRS="$cf_dst_path"'
 
-echo "$as_me:4369: result: $TERMINFO_DIRS" >&5
+echo "$as_me:4661: result: $TERMINFO_DIRS" >&5
 echo "${ECHO_T}$TERMINFO_DIRS" >&6
 test -n "$TERMINFO_DIRS" && cat >>confdefs.h <<EOF
 #define TERMINFO_DIRS "$TERMINFO_DIRS"
 EOF
 
-echo "$as_me:4375: checking for default terminfo directory" >&5
+echo "$as_me:4667: checking for default terminfo directory" >&5
 echo $ECHO_N "checking for default terminfo directory... $ECHO_C" >&6
 
 # Check whether --with-default-terminfo-dir or --without-default-terminfo-dir was given.
@@ -4401,7 +4693,7 @@
   withval=`echo $withval | sed -e s%NONE%$ac_default_prefix%`
   ;;
 *)
-  { { echo "$as_me:4404: error: expected a pathname, not \"$withval\"" >&5
+  { { echo "$as_me:4696: error: expected a pathname, not \"$withval\"" >&5
 echo "$as_me: error: expected a pathname, not \"$withval\"" >&2;}
    { (exit 1); exit 1; }; }
   ;;
@@ -4409,7 +4701,7 @@
 
 eval TERMINFO="$withval"
 
-echo "$as_me:4412: result: $TERMINFO" >&5
+echo "$as_me:4704: result: $TERMINFO" >&5
 echo "${ECHO_T}$TERMINFO" >&6
 cat >>confdefs.h <<EOF
 #define TERMINFO "$TERMINFO"
@@ -4419,7 +4711,7 @@
 
 ###	use option --disable-big-core to make tic run on small machines
 ###	We need 4Mb, check if we can allocate 50% more than that.
-echo "$as_me:4422: checking if big-core option selected" >&5
+echo "$as_me:4714: checking if big-core option selected" >&5
 echo $ECHO_N "checking if big-core option selected... $ECHO_C" >&6
 
 # Check whether --enable-big-core or --disable-big-core was given.
@@ -4431,7 +4723,7 @@
   with_big_core=no
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 4434 "configure"
+#line 4726 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -4445,15 +4737,15 @@
 }
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:4448: \"$ac_link\"") >&5
+if { (eval echo "$as_me:4740: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:4451: \$? = $ac_status" >&5
+  echo "$as_me:4743: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:4453: \"$ac_try\"") >&5
+  { (eval echo "$as_me:4745: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4456: \$? = $ac_status" >&5
+  echo "$as_me:4748: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   with_big_core=yes
 else
@@ -4465,14 +4757,14 @@
 rm -f core core.* *.core conftest$ac_exeext conftest.$ac_objext conftest.$ac_ext
 fi
 fi;
-echo "$as_me:4468: result: $with_big_core" >&5
+echo "$as_me:4760: result: $with_big_core" >&5
 echo "${ECHO_T}$with_big_core" >&6
 test "$with_big_core" = "yes" && cat >>confdefs.h <<\EOF
 #define HAVE_BIG_CORE 1
 EOF
 
 ###	use option --enable-termcap to compile in the termcap fallback support
-echo "$as_me:4475: checking if you want termcap-fallback support" >&5
+echo "$as_me:4767: checking if you want termcap-fallback support" >&5
 echo $ECHO_N "checking if you want termcap-fallback support... $ECHO_C" >&6
 
 # Check whether --enable-termcap or --disable-termcap was given.
@@ -4482,13 +4774,13 @@
 else
   with_termcap=no
 fi;
-echo "$as_me:4485: result: $with_termcap" >&5
+echo "$as_me:4777: result: $with_termcap" >&5
 echo "${ECHO_T}$with_termcap" >&6
 
 if test "$with_termcap" != "yes" ; then
 	if test "$use_database" = no ; then
-		if test -z $with_fallback ; then
-			{ { echo "$as_me:4491: error: You have disabled the database w/o specifying fallbacks" >&5
+		if test -z "$with_fallback" ; then
+			{ { echo "$as_me:4783: error: You have disabled the database w/o specifying fallbacks" >&5
 echo "$as_me: error: You have disabled the database w/o specifying fallbacks" >&2;}
    { (exit 1); exit 1; }; }
 		fi
@@ -4503,7 +4795,7 @@
 #define USE_TERMCAP 1
 EOF
 
-echo "$as_me:4506: checking for list of termcap files" >&5
+echo "$as_me:4798: checking for list of termcap files" >&5
 echo $ECHO_N "checking for list of termcap files... $ECHO_C" >&6
 
 # Check whether --with-termpath or --without-termpath was given.
@@ -4537,7 +4829,7 @@
   cf_src_path=`echo $cf_src_path | sed -e s%NONE%$ac_default_prefix%`
   ;;
 *)
-  { { echo "$as_me:4540: error: expected a pathname, not \"$cf_src_path\"" >&5
+  { { echo "$as_me:4832: error: expected a pathname, not \"$cf_src_path\"" >&5
 echo "$as_me: error: expected a pathname, not \"$cf_src_path\"" >&2;}
    { (exit 1); exit 1; }; }
   ;;
@@ -4550,14 +4842,14 @@
 
 eval 'TERMPATH="$cf_dst_path"'
 
-echo "$as_me:4553: result: $TERMPATH" >&5
+echo "$as_me:4845: result: $TERMPATH" >&5
 echo "${ECHO_T}$TERMPATH" >&6
 test -n "$TERMPATH" && cat >>confdefs.h <<EOF
 #define TERMPATH "$TERMPATH"
 EOF
 
 ###	use option --enable-getcap to use a hacked getcap for reading termcaps
-echo "$as_me:4560: checking if fast termcap-loader is needed" >&5
+echo "$as_me:4852: checking if fast termcap-loader is needed" >&5
 echo $ECHO_N "checking if fast termcap-loader is needed... $ECHO_C" >&6
 
 # Check whether --enable-getcap or --disable-getcap was given.
@@ -4567,13 +4859,13 @@
 else
   with_getcap=no
 fi;
-echo "$as_me:4570: result: $with_getcap" >&5
+echo "$as_me:4862: result: $with_getcap" >&5
 echo "${ECHO_T}$with_getcap" >&6
 test "$with_getcap" = "yes" && cat >>confdefs.h <<\EOF
 #define USE_GETCAP 1
 EOF
 
-echo "$as_me:4576: checking if translated termcaps will be cached in ~/.terminfo" >&5
+echo "$as_me:4868: checking if translated termcaps will be cached in ~/.terminfo" >&5
 echo $ECHO_N "checking if translated termcaps will be cached in ~/.terminfo... $ECHO_C" >&6
 
 # Check whether --enable-getcap-cache or --disable-getcap-cache was given.
@@ -4583,7 +4875,7 @@
 else
   with_getcap_cache=no
 fi;
-echo "$as_me:4586: result: $with_getcap_cache" >&5
+echo "$as_me:4878: result: $with_getcap_cache" >&5
 echo "${ECHO_T}$with_getcap_cache" >&6
 test "$with_getcap_cache" = "yes" && cat >>confdefs.h <<\EOF
 #define USE_GETCAP_CACHE 1
@@ -4599,13 +4891,13 @@
 	unlink
 do
 as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
-echo "$as_me:4602: checking for $ac_func" >&5
+echo "$as_me:4894: checking for $ac_func" >&5
 echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6
 if eval "test \"\${$as_ac_var+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 4608 "configure"
+#line 4900 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char $ac_func (); below.  */
@@ -4636,16 +4928,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:4639: \"$ac_link\"") >&5
+if { (eval echo "$as_me:4931: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:4642: \$? = $ac_status" >&5
+  echo "$as_me:4934: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:4645: \"$ac_try\"") >&5
+  { (eval echo "$as_me:4937: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4648: \$? = $ac_status" >&5
+  echo "$as_me:4940: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   eval "$as_ac_var=yes"
 else
@@ -4655,7 +4947,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:4658: result: `eval echo '${'$as_ac_var'}'`" >&5
+echo "$as_me:4950: result: `eval echo '${'$as_ac_var'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_var'}'`" >&6
 if test `eval echo '${'$as_ac_var'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -4665,20 +4957,20 @@
 fi
 done
 
-if test "$ac_cv_prog_cc_cross" = yes ; then
+if test "$cross_compiling" = yes ; then
 
 for ac_func in \
 		link \
 		symlink
 do
 as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
-echo "$as_me:4675: checking for $ac_func" >&5
+echo "$as_me:4967: checking for $ac_func" >&5
 echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6
 if eval "test \"\${$as_ac_var+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 4681 "configure"
+#line 4973 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char $ac_func (); below.  */
@@ -4709,16 +5001,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:4712: \"$ac_link\"") >&5
+if { (eval echo "$as_me:5004: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:4715: \$? = $ac_status" >&5
+  echo "$as_me:5007: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:4718: \"$ac_try\"") >&5
+  { (eval echo "$as_me:5010: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4721: \$? = $ac_status" >&5
+  echo "$as_me:5013: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   eval "$as_ac_var=yes"
 else
@@ -4728,7 +5020,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:4731: result: `eval echo '${'$as_ac_var'}'`" >&5
+echo "$as_me:5023: result: `eval echo '${'$as_ac_var'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_var'}'`" >&6
 if test `eval echo '${'$as_ac_var'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -4739,7 +5031,7 @@
 done
 
 else
-	echo "$as_me:4742: checking if link/symlink functions work" >&5
+	echo "$as_me:5034: checking if link/symlink functions work" >&5
 echo $ECHO_N "checking if link/symlink functions work... $ECHO_C" >&6
 if test "${cf_cv_link_funcs+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -4752,7 +5044,7 @@
 			eval 'ac_cv_func_'$cf_func'=error'
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 4755 "configure"
+#line 5047 "configure"
 #include "confdefs.h"
 
 #include <sys/types.h>
@@ -4782,15 +5074,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:4785: \"$ac_link\"") >&5
+if { (eval echo "$as_me:5077: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:4788: \$? = $ac_status" >&5
+  echo "$as_me:5080: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:4790: \"$ac_try\"") >&5
+  { (eval echo "$as_me:5082: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:4793: \$? = $ac_status" >&5
+  echo "$as_me:5085: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
 
 			cf_cv_link_funcs="$cf_cv_link_funcs $cf_func"
@@ -4808,7 +5100,7 @@
 		test -z "$cf_cv_link_funcs" && cf_cv_link_funcs=no
 
 fi
-echo "$as_me:4811: result: $cf_cv_link_funcs" >&5
+echo "$as_me:5103: result: $cf_cv_link_funcs" >&5
 echo "${ECHO_T}$cf_cv_link_funcs" >&6
 	test "$ac_cv_func_link"    = yes && cat >>confdefs.h <<\EOF
 #define HAVE_LINK 1
@@ -4824,27 +5116,27 @@
 with_symlinks=no
 
 if test "$ac_cv_func_link" != yes ; then
-    echo "$as_me:4827: checking if tic should use symbolic links" >&5
+    echo "$as_me:5119: checking if tic should use symbolic links" >&5
 echo $ECHO_N "checking if tic should use symbolic links... $ECHO_C" >&6
     if test "$ac_cv_func_symlink" = yes ; then
     	with_symlinks=yes
     else
     	with_symlinks=no
     fi
-    echo "$as_me:4834: result: $with_symlinks" >&5
+    echo "$as_me:5126: result: $with_symlinks" >&5
 echo "${ECHO_T}$with_symlinks" >&6
 elif test "$ac_cv_func_symlink" != yes ; then
-    echo "$as_me:4837: checking if tic should use hard links" >&5
+    echo "$as_me:5129: checking if tic should use hard links" >&5
 echo $ECHO_N "checking if tic should use hard links... $ECHO_C" >&6
     if test "$ac_cv_func_link" = yes ; then
     	with_links=yes
     else
     	with_links=no
     fi
-    echo "$as_me:4844: result: $with_links" >&5
+    echo "$as_me:5136: result: $with_links" >&5
 echo "${ECHO_T}$with_links" >&6
 else
-    echo "$as_me:4847: checking if tic should use symbolic links" >&5
+    echo "$as_me:5139: checking if tic should use symbolic links" >&5
 echo $ECHO_N "checking if tic should use symbolic links... $ECHO_C" >&6
 
 # Check whether --enable-symlinks or --disable-symlinks was given.
@@ -4854,7 +5146,7 @@
 else
   with_symlinks=no
 fi;
-    echo "$as_me:4857: result: $with_symlinks" >&5
+    echo "$as_me:5149: result: $with_symlinks" >&5
 echo "${ECHO_T}$with_symlinks" >&6
 fi
 
@@ -4867,7 +5159,7 @@
 EOF
 
 ###   use option --enable-broken-linker to force on use of broken-linker support
-echo "$as_me:4870: checking if you want broken-linker support code" >&5
+echo "$as_me:5162: checking if you want broken-linker support code" >&5
 echo $ECHO_N "checking if you want broken-linker support code... $ECHO_C" >&6
 
 # Check whether --enable-broken_linker or --disable-broken_linker was given.
@@ -4877,7 +5169,7 @@
 else
   with_broken_linker=$BROKEN_LINKER
 fi;
-echo "$as_me:4880: result: $with_broken_linker" >&5
+echo "$as_me:5172: result: $with_broken_linker" >&5
 echo "${ECHO_T}$with_broken_linker" >&6
 
 BROKEN_LINKER=0
@@ -4887,7 +5179,7 @@
 EOF
 
 	BROKEN_LINKER=1
-elif test $DFT_LWR_MODEL = shared ; then
+elif test "$DFT_LWR_MODEL" = shared ; then
 	case $cf_cv_system_name in #(vi
 	cygwin*)
 		cat >>confdefs.h <<\EOF
@@ -4902,7 +5194,7 @@
 fi
 
 ###   use option --with-bool to override bool's type
-echo "$as_me:4905: checking for type of bool" >&5
+echo "$as_me:5197: checking for type of bool" >&5
 echo $ECHO_N "checking for type of bool... $ECHO_C" >&6
 
 # Check whether --with-bool or --without-bool was given.
@@ -4912,11 +5204,11 @@
 else
   NCURSES_BOOL=auto
 fi;
-echo "$as_me:4915: result: $NCURSES_BOOL" >&5
+echo "$as_me:5207: result: $NCURSES_BOOL" >&5
 echo "${ECHO_T}$NCURSES_BOOL" >&6
 
 ###   use option --with-ospeed to override ospeed's type
-echo "$as_me:4919: checking for type of ospeed" >&5
+echo "$as_me:5211: checking for type of ospeed" >&5
 echo $ECHO_N "checking for type of ospeed... $ECHO_C" >&6
 
 # Check whether --with-ospeed or --without-ospeed was given.
@@ -4926,11 +5218,11 @@
 else
   NCURSES_OSPEED=short
 fi;
-echo "$as_me:4929: result: $NCURSES_OSPEED" >&5
+echo "$as_me:5221: result: $NCURSES_OSPEED" >&5
 echo "${ECHO_T}$NCURSES_OSPEED" >&6
 
 ###   use option --enable-bsdpad to have tputs process BSD-style prefix padding
-echo "$as_me:4933: checking if tputs should process BSD-style prefix padding" >&5
+echo "$as_me:5225: checking if tputs should process BSD-style prefix padding" >&5
 echo $ECHO_N "checking if tputs should process BSD-style prefix padding... $ECHO_C" >&6
 
 # Check whether --enable-bsdpad or --disable-bsdpad was given.
@@ -4940,14 +5232,14 @@
 else
   with_bsdpad=no
 fi;
-echo "$as_me:4943: result: $with_bsdpad" >&5
+echo "$as_me:5235: result: $with_bsdpad" >&5
 echo "${ECHO_T}$with_bsdpad" >&6
 test "$with_bsdpad" = yes && cat >>confdefs.h <<\EOF
 #define BSD_TPUTS 1
 EOF
 
 ### Enable compiling-in rcs id's
-echo "$as_me:4950: checking if RCS identifiers should be compiled-in" >&5
+echo "$as_me:5242: checking if RCS identifiers should be compiled-in" >&5
 echo $ECHO_N "checking if RCS identifiers should be compiled-in... $ECHO_C" >&6
 
 # Check whether --with-rcs-ids or --without-rcs-ids was given.
@@ -4957,7 +5249,7 @@
 else
   with_rcs_ids=no
 fi;
-echo "$as_me:4960: result: $with_rcs_ids" >&5
+echo "$as_me:5252: result: $with_rcs_ids" >&5
 echo "${ECHO_T}$with_rcs_ids" >&6
 test "$with_rcs_ids" = yes && cat >>confdefs.h <<\EOF
 #define USE_RCS_IDS 1
@@ -4965,7 +5257,7 @@
 
 ###############################################################################
 
-echo "$as_me:4968: checking format of man-pages" >&5
+echo "$as_me:5260: checking format of man-pages" >&5
 echo $ECHO_N "checking format of man-pages... $ECHO_C" >&6
 
 # Check whether --with-manpage-format or --without-manpage-format was given.
@@ -5008,15 +5300,15 @@
   IFS="$ac_save_ifs"
   ;;
 .*) # (vi
-  { echo "$as_me:5011: WARNING: Unexpected manpage-format" >&5
+  { echo "$as_me:5303: WARNING: Unexpected manpage-format" >&5
 echo "$as_me: WARNING: Unexpected manpage-format" >&2;}
   ;;
 esac
 
-echo "$as_me:5016: result: $MANPAGE_FORMAT" >&5
+echo "$as_me:5308: result: $MANPAGE_FORMAT" >&5
 echo "${ECHO_T}$MANPAGE_FORMAT" >&6
 
-echo "$as_me:5019: checking for manpage renaming" >&5
+echo "$as_me:5311: checking for manpage renaming" >&5
 echo $ECHO_N "checking for manpage renaming... $ECHO_C" >&6
 
 # Check whether --with-manpage-renames or --without-manpage-renames was given.
@@ -5044,7 +5336,7 @@
   if test -f $srcdir/man/$MANPAGE_RENAMES ; then
     MANPAGE_RENAMES=`cd $srcdir/man && pwd`/$MANPAGE_RENAMES
   elif test ! -f $MANPAGE_RENAMES ; then
-    { { echo "$as_me:5047: error: not a filename: $MANPAGE_RENAMES" >&5
+    { { echo "$as_me:5339: error: not a filename: $MANPAGE_RENAMES" >&5
 echo "$as_me: error: not a filename: $MANPAGE_RENAMES" >&2;}
    { (exit 1); exit 1; }; }
   fi
@@ -5058,10 +5350,10 @@
   fi
 fi
 
-echo "$as_me:5061: result: $MANPAGE_RENAMES" >&5
+echo "$as_me:5353: result: $MANPAGE_RENAMES" >&5
 echo "${ECHO_T}$MANPAGE_RENAMES" >&6
 
-echo "$as_me:5064: checking for manpage symlinks" >&5
+echo "$as_me:5356: checking for manpage symlinks" >&5
 echo $ECHO_N "checking for manpage symlinks... $ECHO_C" >&6
 
 # Check whether --with-manpage-symlinks or --without-manpage-symlinks was given.
@@ -5072,10 +5364,10 @@
   MANPAGE_SYMLINKS=yes
 fi;
 
-echo "$as_me:5075: result: $MANPAGE_SYMLINKS" >&5
+echo "$as_me:5367: result: $MANPAGE_SYMLINKS" >&5
 echo "${ECHO_T}$MANPAGE_SYMLINKS" >&6
 
-echo "$as_me:5078: checking for manpage tbl" >&5
+echo "$as_me:5370: checking for manpage tbl" >&5
 echo $ECHO_N "checking for manpage tbl... $ECHO_C" >&6
 
 # Check whether --with-manpage-tbl or --without-manpage-tbl was given.
@@ -5086,7 +5378,7 @@
   MANPAGE_TBL=no
 fi;
 
-echo "$as_me:5089: result: $MANPAGE_TBL" >&5
+echo "$as_me:5381: result: $MANPAGE_TBL" >&5
 echo "${ECHO_T}$MANPAGE_TBL" >&6
 
   if test "$prefix" = "NONE" ; then
@@ -5257,7 +5549,7 @@
   ;;
 esac
 cat >>man/edit_man.sh <<CF_EOF
-	suffix=\`basename \$target | sed -e 's/^[^.]*//'\`
+	suffix=\`basename \$target | sed -e 's%^[^.]*%%'\`
 	if test \$verb = installing ; then
 		echo \$verb \$target
 		\$INSTALL_DATA \$TMP \$target
@@ -5317,7 +5609,7 @@
 ###############################################################################
 
 ### Note that some functions (such as const) are normally disabled anyway.
-echo "$as_me:5320: checking if you want to build with function extensions" >&5
+echo "$as_me:5612: checking if you want to build with function extensions" >&5
 echo $ECHO_N "checking if you want to build with function extensions... $ECHO_C" >&6
 
 # Check whether --enable-ext-funcs or --disable-ext-funcs was given.
@@ -5327,7 +5619,7 @@
 else
   with_ext_funcs=yes
 fi;
-echo "$as_me:5330: result: $with_ext_funcs" >&5
+echo "$as_me:5622: result: $with_ext_funcs" >&5
 echo "${ECHO_T}$with_ext_funcs" >&6
 if test "$with_ext_funcs" = yes ; then
 	NCURSES_EXT_FUNCS=1
@@ -5344,6 +5636,10 @@
 EOF
 
 	cat >>confdefs.h <<\EOF
+#define HAVE_RESIZE_TERM 1
+EOF
+
+	cat >>confdefs.h <<\EOF
 #define HAVE_USE_DEFAULT_COLORS 1
 EOF
 
@@ -5360,7 +5656,7 @@
 fi
 
 ###   use option --enable-const to turn on use of const beyond that in XSI.
-echo "$as_me:5363: checking for extended use of const keyword" >&5
+echo "$as_me:5659: checking for extended use of const keyword" >&5
 echo $ECHO_N "checking for extended use of const keyword... $ECHO_C" >&6
 
 # Check whether --enable-const or --disable-const was given.
@@ -5370,14 +5666,14 @@
 else
   with_ext_const=no
 fi;
-echo "$as_me:5373: result: $with_ext_const" >&5
+echo "$as_me:5669: result: $with_ext_const" >&5
 echo "${ECHO_T}$with_ext_const" >&6
 NCURSES_CONST='/*nothing*/'
 if test "$with_ext_const" = yes ; then
 	NCURSES_CONST=const
 fi
 
-echo "$as_me:5380: checking if you want \$NCURSES_NO_PADDING code" >&5
+echo "$as_me:5676: checking if you want \$NCURSES_NO_PADDING code" >&5
 echo $ECHO_N "checking if you want \$NCURSES_NO_PADDING code... $ECHO_C" >&6
 
 # Check whether --enable-no-padding or --disable-no-padding was given.
@@ -5387,14 +5683,14 @@
 else
   with_no_padding=$with_ext_funcs
 fi;
-echo "$as_me:5390: result: $with_no_padding" >&5
+echo "$as_me:5686: result: $with_no_padding" >&5
 echo "${ECHO_T}$with_no_padding" >&6
 test "$with_no_padding" = yes && cat >>confdefs.h <<\EOF
 #define NCURSES_NO_PADDING 1
 EOF
 
 ###   use option --enable-sigwinch to turn on use of SIGWINCH logic
-echo "$as_me:5397: checking if you want SIGWINCH handler" >&5
+echo "$as_me:5693: checking if you want SIGWINCH handler" >&5
 echo $ECHO_N "checking if you want SIGWINCH handler... $ECHO_C" >&6
 
 # Check whether --enable-sigwinch or --disable-sigwinch was given.
@@ -5404,14 +5700,14 @@
 else
   with_sigwinch=$with_ext_funcs
 fi;
-echo "$as_me:5407: result: $with_sigwinch" >&5
+echo "$as_me:5703: result: $with_sigwinch" >&5
 echo "${ECHO_T}$with_sigwinch" >&6
 test "$with_sigwinch" = yes && cat >>confdefs.h <<\EOF
 #define USE_SIGWINCH 1
 EOF
 
 ###   use option --enable-tcap-names to allow user to define new capabilities
-echo "$as_me:5414: checking if you want user-definable terminal capabilities like termcap" >&5
+echo "$as_me:5710: checking if you want user-definable terminal capabilities like termcap" >&5
 echo $ECHO_N "checking if you want user-definable terminal capabilities like termcap... $ECHO_C" >&6
 
 # Check whether --enable-tcap-names or --disable-tcap-names was given.
@@ -5421,7 +5717,7 @@
 else
   with_tcap_names=$with_ext_funcs
 fi;
-echo "$as_me:5424: result: $with_tcap_names" >&5
+echo "$as_me:5720: result: $with_tcap_names" >&5
 echo "${ECHO_T}$with_tcap_names" >&6
 NCURSES_XNAMES=0
 test "$with_tcap_names" = yes && NCURSES_XNAMES=1
@@ -5429,7 +5725,7 @@
 ###############################################################################
 # These options are relatively safe to experiment with.
 
-echo "$as_me:5432: checking if you want all development code" >&5
+echo "$as_me:5728: checking if you want all development code" >&5
 echo $ECHO_N "checking if you want all development code... $ECHO_C" >&6
 
 # Check whether --with-develop or --without-develop was given.
@@ -5439,11 +5735,11 @@
 else
   with_develop=no
 fi;
-echo "$as_me:5442: result: $with_develop" >&5
+echo "$as_me:5738: result: $with_develop" >&5
 echo "${ECHO_T}$with_develop" >&6
 
 ###   use option --enable-hard-tabs to turn on use of hard-tabs optimize
-echo "$as_me:5446: checking if you want hard-tabs code" >&5
+echo "$as_me:5742: checking if you want hard-tabs code" >&5
 echo $ECHO_N "checking if you want hard-tabs code... $ECHO_C" >&6
 
 # Check whether --enable-hard-tabs or --disable-hard-tabs was given.
@@ -5453,13 +5749,13 @@
 else
   with_hardtabs=$with_develop
 fi;
-echo "$as_me:5456: result: $with_hardtabs" >&5
+echo "$as_me:5752: result: $with_hardtabs" >&5
 echo "${ECHO_T}$with_hardtabs" >&6
 test "$with_hardtabs" = yes && cat >>confdefs.h <<\EOF
 #define USE_HARD_TABS 1
 EOF
 
-echo "$as_me:5462: checking if you want to use restrict environment when running as root" >&5
+echo "$as_me:5758: checking if you want to use restrict environment when running as root" >&5
 echo $ECHO_N "checking if you want to use restrict environment when running as root... $ECHO_C" >&6
 
 # Check whether --enable-root-environ or --disable-root-environ was given.
@@ -5469,14 +5765,14 @@
 else
   with_root_environ=yes
 fi;
-echo "$as_me:5472: result: $with_root_environ" >&5
+echo "$as_me:5768: result: $with_root_environ" >&5
 echo "${ECHO_T}$with_root_environ" >&6
 test "$with_root_environ" = yes && cat >>confdefs.h <<\EOF
 #define USE_ROOT_ENVIRON 1
 EOF
 
 ###   use option --enable-xmc-glitch to turn on use of magic-cookie optimize
-echo "$as_me:5479: checking if you want limited support for xmc" >&5
+echo "$as_me:5775: checking if you want limited support for xmc" >&5
 echo $ECHO_N "checking if you want limited support for xmc... $ECHO_C" >&6
 
 # Check whether --enable-xmc-glitch or --disable-xmc-glitch was given.
@@ -5486,7 +5782,7 @@
 else
   with_xmc_glitch=$with_develop
 fi;
-echo "$as_me:5489: result: $with_xmc_glitch" >&5
+echo "$as_me:5785: result: $with_xmc_glitch" >&5
 echo "${ECHO_T}$with_xmc_glitch" >&6
 test "$with_xmc_glitch" = yes && cat >>confdefs.h <<\EOF
 #define USE_XMC_SUPPORT 1
@@ -5495,7 +5791,7 @@
 ###############################################################################
 # These are just experimental, probably should not be in a package:
 
-echo "$as_me:5498: checking if you do not want to assume colors are white-on-black" >&5
+echo "$as_me:5794: checking if you do not want to assume colors are white-on-black" >&5
 echo $ECHO_N "checking if you do not want to assume colors are white-on-black... $ECHO_C" >&6
 
 # Check whether --enable-assumed-color or --disable-assumed-color was given.
@@ -5505,14 +5801,14 @@
 else
   with_assumed_color=yes
 fi;
-echo "$as_me:5508: result: $with_assumed_color" >&5
+echo "$as_me:5804: result: $with_assumed_color" >&5
 echo "${ECHO_T}$with_assumed_color" >&6
 test "$with_assumed_color" = yes && cat >>confdefs.h <<\EOF
 #define USE_ASSUMED_COLOR 1
 EOF
 
 ###   use option --enable-hashmap to turn on use of hashmap scrolling logic
-echo "$as_me:5515: checking if you want hashmap scrolling-optimization code" >&5
+echo "$as_me:5811: checking if you want hashmap scrolling-optimization code" >&5
 echo $ECHO_N "checking if you want hashmap scrolling-optimization code... $ECHO_C" >&6
 
 # Check whether --enable-hashmap or --disable-hashmap was given.
@@ -5522,14 +5818,14 @@
 else
   with_hashmap=yes
 fi;
-echo "$as_me:5525: result: $with_hashmap" >&5
+echo "$as_me:5821: result: $with_hashmap" >&5
 echo "${ECHO_T}$with_hashmap" >&6
 test "$with_hashmap" = yes && cat >>confdefs.h <<\EOF
 #define USE_HASHMAP 1
 EOF
 
 ###   use option --enable-colorfgbg to turn on use of $COLORFGBG environment
-echo "$as_me:5532: checking if you want colorfgbg code" >&5
+echo "$as_me:5828: checking if you want colorfgbg code" >&5
 echo $ECHO_N "checking if you want colorfgbg code... $ECHO_C" >&6
 
 # Check whether --enable-colorfgbg or --disable-colorfgbg was given.
@@ -5539,13 +5835,13 @@
 else
   with_colorfgbg=no
 fi;
-echo "$as_me:5542: result: $with_colorfgbg" >&5
+echo "$as_me:5838: result: $with_colorfgbg" >&5
 echo "${ECHO_T}$with_colorfgbg" >&6
 test "$with_colorfgbg" = yes && cat >>confdefs.h <<\EOF
 #define USE_COLORFGBG 1
 EOF
 
-echo "$as_me:5548: checking if you want experimental safe-sprintf code" >&5
+echo "$as_me:5844: checking if you want experimental safe-sprintf code" >&5
 echo $ECHO_N "checking if you want experimental safe-sprintf code... $ECHO_C" >&6
 
 # Check whether --enable-safe-sprintf or --disable-safe-sprintf was given.
@@ -5555,7 +5851,7 @@
 else
   with_safe_sprintf=no
 fi;
-echo "$as_me:5558: result: $with_safe_sprintf" >&5
+echo "$as_me:5854: result: $with_safe_sprintf" >&5
 echo "${ECHO_T}$with_safe_sprintf" >&6
 test "$with_safe_sprintf" = yes && cat >>confdefs.h <<\EOF
 #define USE_SAFE_SPRINTF 1
@@ -5564,7 +5860,7 @@
 ###   use option --disable-scroll-hints to turn off use of scroll-hints scrolling logic
 # when hashmap is used scroll hints are useless
 if test "$with_hashmap" = no ; then
-echo "$as_me:5567: checking if you want to experiment without scrolling-hints code" >&5
+echo "$as_me:5863: checking if you want to experiment without scrolling-hints code" >&5
 echo $ECHO_N "checking if you want to experiment without scrolling-hints code... $ECHO_C" >&6
 
 # Check whether --enable-scroll-hints or --disable-scroll-hints was given.
@@ -5574,7 +5870,7 @@
 else
   with_scroll_hints=yes
 fi;
-echo "$as_me:5577: result: $with_scroll_hints" >&5
+echo "$as_me:5873: result: $with_scroll_hints" >&5
 echo "${ECHO_T}$with_scroll_hints" >&6
 test "$with_scroll_hints" = yes && cat >>confdefs.h <<\EOF
 #define USE_SCROLL_HINTS 1
@@ -5585,8 +5881,17 @@
 ###   use option --enable-widec to turn on use of wide-character support
 NCURSES_CH_T=chtype
 NCURSES_LIBUTF8=0
+
+NEED_WCHAR_H=0
 NCURSES_MBSTATE_T=0
-echo "$as_me:5589: checking if you want experimental wide-character code" >&5
+NCURSES_WCHAR_T=0
+NCURSES_WINT_T=0
+
+# use these variables to work around a defect in gcc's fixincludes.
+NCURSES_OK_WCHAR_T=
+NCURSES_OK_WINT_T=
+
+echo "$as_me:5894: checking if you want experimental wide-character code" >&5
 echo $ECHO_N "checking if you want experimental wide-character code... $ECHO_C" >&6
 
 # Check whether --enable-widec or --disable-widec was given.
@@ -5596,7 +5901,7 @@
 else
   with_widec=no
 fi;
-echo "$as_me:5599: result: $with_widec" >&5
+echo "$as_me:5904: result: $with_widec" >&5
 echo "${ECHO_T}$with_widec" >&6
 if test "$with_widec" = yes ; then
 	LIB_SUFFIX="w${LIB_SUFFIX}"
@@ -5604,19 +5909,23 @@
 #define USE_WIDEC_SUPPORT 1
 EOF
 
-	CPPFLAGS="$CPPFLAGS -D_XOPEN_SOURCE_EXTENDED"
+	CPPFLAGS="$CPPFLAGS -D_XOPEN_SOURCE=500 -D_XOPEN_SOURCE_EXTENDED"
 	# with_overwrite=no
 	NCURSES_CH_T=cchar_t
-	echo "$as_me:5610: checking for putwc" >&5
-echo $ECHO_N "checking for putwc... $ECHO_C" >&6
-if test "${ac_cv_func_putwc+set}" = set; then
+
+for ac_func in putwc btowc wctob mbtowc wctomb
+do
+as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
+echo "$as_me:5919: checking for $ac_func" >&5
+echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6
+if eval "test \"\${$as_ac_var+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 5616 "configure"
+#line 5925 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
-    which can conflict with char putwc (); below.  */
+    which can conflict with char $ac_func (); below.  */
 #include <assert.h>
 /* Override any gcc2 internal prototype to avoid an error.  */
 #ifdef __cplusplus
@@ -5624,7 +5933,7 @@
 #endif
 /* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
-char putwc ();
+char $ac_func ();
 char (*f) ();
 
 int
@@ -5633,10 +5942,10 @@
 /* The GNU C library defines this for functions which it implements
     to always fail with ENOSYS.  Some functions are actually named
     something starting with __ and the normal name is an alias.  */
-#if defined (__stub_putwc) || defined (__stub___putwc)
+#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
 choke me
 #else
-f = putwc;
+f = $ac_func;
 #endif
 
   ;
@@ -5644,31 +5953,38 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:5647: \"$ac_link\"") >&5
+if { (eval echo "$as_me:5956: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:5650: \$? = $ac_status" >&5
+  echo "$as_me:5959: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:5653: \"$ac_try\"") >&5
+  { (eval echo "$as_me:5962: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:5656: \$? = $ac_status" >&5
+  echo "$as_me:5965: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
-  ac_cv_func_putwc=yes
+  eval "$as_ac_var=yes"
 else
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
-ac_cv_func_putwc=no
+eval "$as_ac_var=no"
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:5666: result: $ac_cv_func_putwc" >&5
-echo "${ECHO_T}$ac_cv_func_putwc" >&6
+echo "$as_me:5975: result: `eval echo '${'$as_ac_var'}'`" >&5
+echo "${ECHO_T}`eval echo '${'$as_ac_var'}'`" >&6
+if test `eval echo '${'$as_ac_var'}'` = yes; then
+  cat >>confdefs.h <<EOF
+#define `echo "HAVE_$ac_func" | $as_tr_cpp` 1
+EOF
 
-if test "$ac_cv_func_putwc" != yes ; then
+fi
+done
 
-echo "$as_me:5671: checking for putwc in libutf8" >&5
+	if test "$ac_cv_func_putwc" != yes ; then
+
+echo "$as_me:5987: checking for putwc in libutf8" >&5
 echo $ECHO_N "checking for putwc in libutf8... $ECHO_C" >&6
 if test "${cf_cv_libutf8+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -5677,7 +5993,7 @@
 	cf_save_LIBS="$LIBS"
 	LIBS="-lutf8 $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 5680 "configure"
+#line 5996 "configure"
 #include "confdefs.h"
 
 #include <libutf8.h>
@@ -5690,16 +6006,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:5693: \"$ac_link\"") >&5
+if { (eval echo "$as_me:6009: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:5696: \$? = $ac_status" >&5
+  echo "$as_me:6012: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:5699: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6015: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:5702: \$? = $ac_status" >&5
+  echo "$as_me:6018: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_libutf8=yes
 else
@@ -5711,7 +6027,7 @@
 	LIBS="$cf_save_LIBS"
 
 fi
-echo "$as_me:5714: result: $cf_cv_libutf8" >&5
+echo "$as_me:6030: result: $cf_cv_libutf8" >&5
 echo "${ECHO_T}$cf_cv_libutf8" >&6
 
 if test "$cf_cv_libutf8" = yes ; then
@@ -5722,20 +6038,20 @@
 	LIBS="-lutf8 $LIBS"
 fi
 
-	if test "$cf_cv_libutf8" = yes ; then
-		NCURSES_LIBUTF8=1
+		if test "$cf_cv_libutf8" = yes ; then
+			NCURSES_LIBUTF8=1
+		fi
 	fi
-fi
 
 # This is needed on Tru64 5.0 to declare mbstate_t
-echo "$as_me:5731: checking if we must include wchar.h to declare mbstate_t" >&5
+echo "$as_me:6047: checking if we must include wchar.h to declare mbstate_t" >&5
 echo $ECHO_N "checking if we must include wchar.h to declare mbstate_t... $ECHO_C" >&6
 if test "${cf_cv_mbstate_t+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 5738 "configure"
+#line 6054 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -5751,23 +6067,23 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:5754: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:6070: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:5757: \$? = $ac_status" >&5
+  echo "$as_me:6073: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:5760: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6076: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:5763: \$? = $ac_status" >&5
+  echo "$as_me:6079: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_mbstate_t=no
 else
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
 cat >conftest.$ac_ext <<_ACEOF
-#line 5770 "configure"
+#line 6086 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -5784,16 +6100,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:5787: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:6103: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:5790: \$? = $ac_status" >&5
+  echo "$as_me:6106: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:5793: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6109: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:5796: \$? = $ac_status" >&5
+  echo "$as_me:6112: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_mbstate_t=yes
 else
@@ -5805,7 +6121,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:5808: result: $cf_cv_mbstate_t" >&5
+echo "$as_me:6124: result: $cf_cv_mbstate_t" >&5
 echo "${ECHO_T}$cf_cv_mbstate_t" >&6
 
 if test "$cf_cv_mbstate_t" = yes ; then
@@ -5813,21 +6129,215 @@
 #define NEED_WCHAR_H 1
 EOF
 
+	NEED_WCHAR_H=1
 fi
 
-if test "$cf_cv_mbstate_t" != unknown ; then
+# if we do not find mbstate_t in either place, use substitution to provide a fallback.
+if test "$cf_cv_mbstate_t" = unknown ; then
+	NCURSES_MBSTATE_T=1
+fi
+
+# This is needed on Tru64 5.0 to declare wchar_t
+echo "$as_me:6141: checking if we must include wchar.h to declare wchar_t" >&5
+echo $ECHO_N "checking if we must include wchar.h to declare wchar_t... $ECHO_C" >&6
+if test "${cf_cv_wchar_t+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+
+cat >conftest.$ac_ext <<_ACEOF
+#line 6148 "configure"
+#include "confdefs.h"
+
+#include <stdlib.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif
+int
+main ()
+{
+wchar_t state
+  ;
+  return 0;
+}
+_ACEOF
+rm -f conftest.$ac_objext
+if { (eval echo "$as_me:6164: \"$ac_compile\"") >&5
+  (eval $ac_compile) 2>&5
+  ac_status=$?
+  echo "$as_me:6167: \$? = $ac_status" >&5
+  (exit $ac_status); } &&
+         { ac_try='test -s conftest.$ac_objext'
+  { (eval echo "$as_me:6170: \"$ac_try\"") >&5
+  (eval $ac_try) 2>&5
+  ac_status=$?
+  echo "$as_me:6173: \$? = $ac_status" >&5
+  (exit $ac_status); }; }; then
+  cf_cv_wchar_t=no
+else
+  echo "$as_me: failed program was:" >&5
+cat conftest.$ac_ext >&5
+cat >conftest.$ac_ext <<_ACEOF
+#line 6180 "configure"
+#include "confdefs.h"
+
+#include <stdlib.h>
+#include <wchar.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif
+int
+main ()
+{
+wchar_t value
+  ;
+  return 0;
+}
+_ACEOF
+rm -f conftest.$ac_objext
+if { (eval echo "$as_me:6197: \"$ac_compile\"") >&5
+  (eval $ac_compile) 2>&5
+  ac_status=$?
+  echo "$as_me:6200: \$? = $ac_status" >&5
+  (exit $ac_status); } &&
+         { ac_try='test -s conftest.$ac_objext'
+  { (eval echo "$as_me:6203: \"$ac_try\"") >&5
+  (eval $ac_try) 2>&5
+  ac_status=$?
+  echo "$as_me:6206: \$? = $ac_status" >&5
+  (exit $ac_status); }; }; then
+  cf_cv_wchar_t=yes
+else
+  echo "$as_me: failed program was:" >&5
+cat conftest.$ac_ext >&5
+cf_cv_wchar_t=unknown
+fi
+rm -f conftest.$ac_objext conftest.$ac_ext
+fi
+rm -f conftest.$ac_objext conftest.$ac_ext
+fi
+echo "$as_me:6218: result: $cf_cv_wchar_t" >&5
+echo "${ECHO_T}$cf_cv_wchar_t" >&6
+
+if test "$cf_cv_wchar_t" = yes ; then
 	cat >>confdefs.h <<\EOF
-#define HAVE_MBSTATE_T 1
+#define NEED_WCHAR_H 1
 EOF
 
+	NEED_WCHAR_H=1
 fi
 
-	if test $cf_cv_mbstate_t = yes ; then
-		NCURSES_MBSTATE_T=1
-	fi
+# if we do not find wchar_t in either place, use substitution to provide a fallback.
+if test "$cf_cv_wchar_t" = unknown ; then
+	NCURSES_WCHAR_T=1
+fi
+
+# if we find wchar_t in either place, use substitution to provide a fallback.
+if test "$cf_cv_wchar_t" != unknown ; then
+	NCURSES_OK_WCHAR_T=1
 fi
 
-echo "$as_me:5830: checking for terminal capabilities file" >&5
+# This is needed on Tru64 5.0 to declare wint_t
+echo "$as_me:6240: checking if we must include wchar.h to declare wint_t" >&5
+echo $ECHO_N "checking if we must include wchar.h to declare wint_t... $ECHO_C" >&6
+if test "${cf_cv_wint_t+set}" = set; then
+  echo $ECHO_N "(cached) $ECHO_C" >&6
+else
+
+cat >conftest.$ac_ext <<_ACEOF
+#line 6247 "configure"
+#include "confdefs.h"
+
+#include <stdlib.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif
+int
+main ()
+{
+wint_t state
+  ;
+  return 0;
+}
+_ACEOF
+rm -f conftest.$ac_objext
+if { (eval echo "$as_me:6263: \"$ac_compile\"") >&5
+  (eval $ac_compile) 2>&5
+  ac_status=$?
+  echo "$as_me:6266: \$? = $ac_status" >&5
+  (exit $ac_status); } &&
+         { ac_try='test -s conftest.$ac_objext'
+  { (eval echo "$as_me:6269: \"$ac_try\"") >&5
+  (eval $ac_try) 2>&5
+  ac_status=$?
+  echo "$as_me:6272: \$? = $ac_status" >&5
+  (exit $ac_status); }; }; then
+  cf_cv_wint_t=no
+else
+  echo "$as_me: failed program was:" >&5
+cat conftest.$ac_ext >&5
+cat >conftest.$ac_ext <<_ACEOF
+#line 6279 "configure"
+#include "confdefs.h"
+
+#include <stdlib.h>
+#include <wchar.h>
+#ifdef HAVE_LIBUTF8_H
+#include <libutf8.h>
+#endif
+int
+main ()
+{
+wint_t value
+  ;
+  return 0;
+}
+_ACEOF
+rm -f conftest.$ac_objext
+if { (eval echo "$as_me:6296: \"$ac_compile\"") >&5
+  (eval $ac_compile) 2>&5
+  ac_status=$?
+  echo "$as_me:6299: \$? = $ac_status" >&5
+  (exit $ac_status); } &&
+         { ac_try='test -s conftest.$ac_objext'
+  { (eval echo "$as_me:6302: \"$ac_try\"") >&5
+  (eval $ac_try) 2>&5
+  ac_status=$?
+  echo "$as_me:6305: \$? = $ac_status" >&5
+  (exit $ac_status); }; }; then
+  cf_cv_wint_t=yes
+else
+  echo "$as_me: failed program was:" >&5
+cat conftest.$ac_ext >&5
+cf_cv_wint_t=unknown
+fi
+rm -f conftest.$ac_objext conftest.$ac_ext
+fi
+rm -f conftest.$ac_objext conftest.$ac_ext
+fi
+echo "$as_me:6317: result: $cf_cv_wint_t" >&5
+echo "${ECHO_T}$cf_cv_wint_t" >&6
+
+if test "$cf_cv_wint_t" = yes ; then
+	cat >>confdefs.h <<\EOF
+#define NEED_WCHAR_H 1
+EOF
+
+	NEED_WCHAR_H=1
+fi
+
+# if we do not find wint_t in either place, use substitution to provide a fallback.
+if test "$cf_cv_wint_t" = unknown ; then
+	NCURSES_WINT_T=1
+fi
+
+# if we find wint_t in either place, use substitution to provide a fallback.
+if test "$cf_cv_wint_t" != unknown ; then
+	NCURSES_OK_WINT_T=1
+fi
+
+fi
+
+echo "$as_me:6340: checking for terminal capabilities file" >&5
 echo $ECHO_N "checking for terminal capabilities file... $ECHO_C" >&6
 
 # Check whether --with-caps or --without-caps was given.
@@ -5838,13 +6348,13 @@
   TERMINFO_CAPS=Caps
 fi;
 test -f ${srcdir}/include/${TERMINFO_CAPS} || TERMINFO_CAPS=Caps
-echo "$as_me:5841: result: $TERMINFO_CAPS" >&5
+echo "$as_me:6351: result: $TERMINFO_CAPS" >&5
 echo "${ECHO_T}$TERMINFO_CAPS" >&6
 
 ###############################################################################
 
 ###	use option --disable-echo to suppress full display compiling commands
-echo "$as_me:5847: checking if you want to display full commands during build" >&5
+echo "$as_me:6357: checking if you want to display full commands during build" >&5
 echo $ECHO_N "checking if you want to display full commands during build... $ECHO_C" >&6
 
 # Check whether --enable-echo or --disable-echo was given.
@@ -5860,11 +6370,11 @@
 	ECHO_LINK='@ echo linking $@ ... ;'
 	test -n "$LIBTOOL" && LIBTOOL="$LIBTOOL --silent"
 fi
-echo "$as_me:5863: result: $with_echo" >&5
+echo "$as_me:6373: result: $with_echo" >&5
 echo "${ECHO_T}$with_echo" >&6
 
 ###	use option --enable-warnings to turn on all gcc warnings
-echo "$as_me:5867: checking if you want to see compiler warnings" >&5
+echo "$as_me:6377: checking if you want to see compiler warnings" >&5
 echo $ECHO_N "checking if you want to see compiler warnings... $ECHO_C" >&6
 
 # Check whether --enable-warnings or --disable-warnings was given.
@@ -5872,7 +6382,7 @@
   enableval="$enable_warnings"
   with_warnings=$enableval
 fi;
-echo "$as_me:5875: result: $with_warnings" >&5
+echo "$as_me:6385: result: $with_warnings" >&5
 echo "${ECHO_T}$with_warnings" >&6
 
 if test -n "$with_warnings"; then
@@ -5881,10 +6391,10 @@
 if test "$GCC" = yes
 then
 	cat > conftest.$ac_ext <<EOF
-#line 5884 "configure"
+#line 6394 "configure"
 int main(int argc, char *argv[]) { return (argv[argc-1] == 0) ; }
 EOF
-	{ echo "$as_me:5887: checking for $CC warning options..." >&5
+	{ echo "$as_me:6397: checking for $CC warning options..." >&5
 echo "$as_me: checking for $CC warning options..." >&6;}
 	cf_save_CFLAGS="$CFLAGS"
 	EXTRA_CFLAGS="-W -Wall"
@@ -5904,15 +6414,27 @@
 		Wundef $cf_warn_CONST
 	do
 		CFLAGS="$cf_save_CFLAGS $EXTRA_CFLAGS -$cf_opt"
-		if { (eval echo "$as_me:5907: \"$ac_compile\"") >&5
+		if { (eval echo "$as_me:6417: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:5910: \$? = $ac_status" >&5
+  echo "$as_me:6420: \$? = $ac_status" >&5
   (exit $ac_status); }; then
-			test -n "$verbose" && echo "$as_me:5912: result: ... -$cf_opt" >&5
+			test -n "$verbose" && echo "$as_me:6422: result: ... -$cf_opt" >&5
 echo "${ECHO_T}... -$cf_opt" >&6
+			case $cf_opt in #(vi
+			Wcast-qual) #(vi
+				CPPFLAGS="$CPPFLAGS -DXTSTRINGDEFINES"
+				;;
+			Winline) #(vi
+				case $GCC_VERSION in
+				3.3*)
+					test -n "$verbose" && echo "	feature is broken in gcc $GCC_VERSION" 1>&6
+
+					continue;;
+				esac
+				;;
+			esac
 			EXTRA_CFLAGS="$EXTRA_CFLAGS -$cf_opt"
-			test "$cf_opt" = Wcast-qual && EXTRA_CFLAGS="$EXTRA_CFLAGS -DXTSTRINGDEFINES"
 		fi
 	done
 	rm -f conftest*
@@ -5939,10 +6461,10 @@
 EOF
 if test "$GCC" = yes
 then
-	{ echo "$as_me:5942: checking for $CC __attribute__ directives..." >&5
+	{ echo "$as_me:6464: checking for $CC __attribute__ directives..." >&5
 echo "$as_me: checking for $CC __attribute__ directives..." >&6;}
 cat > conftest.$ac_ext <<EOF
-#line 5945 "configure"
+#line 6467 "configure"
 #include "confdefs.h"
 #include "conftest.h"
 #include "conftest.i"
@@ -5980,16 +6502,14 @@
 EOF
 			;;
 		esac
-		if { (eval echo "$as_me:5983: \"$ac_compile\"") >&5
+		if { (eval echo "$as_me:6505: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:5986: \$? = $ac_status" >&5
+  echo "$as_me:6508: \$? = $ac_status" >&5
   (exit $ac_status); }; then
-			test -n "$verbose" && echo "$as_me:5988: result: ... $cf_attribute" >&5
+			test -n "$verbose" && echo "$as_me:6510: result: ... $cf_attribute" >&5
 echo "${ECHO_T}... $cf_attribute" >&6
 			cat conftest.h >>confdefs.h
-#		else
-#			sed -e 's/__attr.*/\/*nothing*\//' conftest.h >>confdefs.h
 		fi
 	done
 else
@@ -5999,7 +6519,7 @@
 fi
 
 ###	use option --enable-assertions to turn on generation of assertion code
-echo "$as_me:6002: checking if you want to enable runtime assertions" >&5
+echo "$as_me:6522: checking if you want to enable runtime assertions" >&5
 echo $ECHO_N "checking if you want to enable runtime assertions... $ECHO_C" >&6
 
 # Check whether --enable-assertions or --disable-assertions was given.
@@ -6009,7 +6529,7 @@
 else
   with_assertions=no
 fi;
-echo "$as_me:6012: result: $with_assertions" >&5
+echo "$as_me:6532: result: $with_assertions" >&5
 echo "${ECHO_T}$with_assertions" >&6
 if test -n "$GCC"
 then
@@ -6062,13 +6582,13 @@
 fi;
 
 ###	Checks for libraries.
-echo "$as_me:6065: checking for gettimeofday" >&5
+echo "$as_me:6585: checking for gettimeofday" >&5
 echo $ECHO_N "checking for gettimeofday... $ECHO_C" >&6
 if test "${ac_cv_func_gettimeofday+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6071 "configure"
+#line 6591 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char gettimeofday (); below.  */
@@ -6099,16 +6619,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6102: \"$ac_link\"") >&5
+if { (eval echo "$as_me:6622: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6105: \$? = $ac_status" >&5
+  echo "$as_me:6625: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6108: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6628: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6111: \$? = $ac_status" >&5
+  echo "$as_me:6631: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_func_gettimeofday=yes
 else
@@ -6118,7 +6638,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:6121: result: $ac_cv_func_gettimeofday" >&5
+echo "$as_me:6641: result: $ac_cv_func_gettimeofday" >&5
 echo "${ECHO_T}$ac_cv_func_gettimeofday" >&6
 if test $ac_cv_func_gettimeofday = yes; then
   cat >>confdefs.h <<\EOF
@@ -6127,7 +6647,7 @@
 
 else
 
-echo "$as_me:6130: checking for gettimeofday in -lbsd" >&5
+echo "$as_me:6650: checking for gettimeofday in -lbsd" >&5
 echo $ECHO_N "checking for gettimeofday in -lbsd... $ECHO_C" >&6
 if test "${ac_cv_lib_bsd_gettimeofday+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -6135,7 +6655,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-lbsd  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 6138 "configure"
+#line 6658 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -6154,16 +6674,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6157: \"$ac_link\"") >&5
+if { (eval echo "$as_me:6677: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6160: \$? = $ac_status" >&5
+  echo "$as_me:6680: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6163: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6683: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6166: \$? = $ac_status" >&5
+  echo "$as_me:6686: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_bsd_gettimeofday=yes
 else
@@ -6174,7 +6694,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:6177: result: $ac_cv_lib_bsd_gettimeofday" >&5
+echo "$as_me:6697: result: $ac_cv_lib_bsd_gettimeofday" >&5
 echo "${ECHO_T}$ac_cv_lib_bsd_gettimeofday" >&6
 if test $ac_cv_lib_bsd_gettimeofday = yes; then
   cat >>confdefs.h <<\EOF
@@ -6186,14 +6706,14 @@
 
 fi
 
-echo "$as_me:6189: checking if -lm needed for math functions" >&5
+echo "$as_me:6709: checking if -lm needed for math functions" >&5
 echo $ECHO_N "checking if -lm needed for math functions... $ECHO_C" >&6
 if test "${cf_cv_need_libm+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 6196 "configure"
+#line 6716 "configure"
 #include "confdefs.h"
 
 	#include <stdio.h>
@@ -6208,16 +6728,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6211: \"$ac_link\"") >&5
+if { (eval echo "$as_me:6731: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6214: \$? = $ac_status" >&5
+  echo "$as_me:6734: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6217: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6737: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6220: \$? = $ac_status" >&5
+  echo "$as_me:6740: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_need_libm=no
 else
@@ -6227,7 +6747,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:6230: result: $cf_cv_need_libm" >&5
+echo "$as_me:6750: result: $cf_cv_need_libm" >&5
 echo "${ECHO_T}$cf_cv_need_libm" >&6
 if test "$cf_cv_need_libm" = yes
 then
@@ -6236,14 +6756,14 @@
 
 ###	Checks for header files.
 
-echo "$as_me:6239: checking if we must define _GNU_SOURCE" >&5
+echo "$as_me:6759: checking if we must define _GNU_SOURCE" >&5
 echo $ECHO_N "checking if we must define _GNU_SOURCE... $ECHO_C" >&6
 if test "${cf_cv_gnu_source+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 6246 "configure"
+#line 6766 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 int
@@ -6258,16 +6778,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:6261: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:6781: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:6264: \$? = $ac_status" >&5
+  echo "$as_me:6784: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:6267: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6787: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6270: \$? = $ac_status" >&5
+  echo "$as_me:6790: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_gnu_source=no
 else
@@ -6276,7 +6796,7 @@
 cf_save="$CPPFLAGS"
 	 CPPFLAGS="$CPPFLAGS -D_GNU_SOURCE"
 	 cat >conftest.$ac_ext <<_ACEOF
-#line 6279 "configure"
+#line 6799 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 int
@@ -6291,16 +6811,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:6294: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:6814: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:6297: \$? = $ac_status" >&5
+  echo "$as_me:6817: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:6300: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6820: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6303: \$? = $ac_status" >&5
+  echo "$as_me:6823: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_gnu_source=no
 else
@@ -6315,17 +6835,17 @@
 rm -f conftest.$ac_objext conftest.$ac_ext
 
 fi
-echo "$as_me:6318: result: $cf_cv_gnu_source" >&5
+echo "$as_me:6838: result: $cf_cv_gnu_source" >&5
 echo "${ECHO_T}$cf_cv_gnu_source" >&6
 test "$cf_cv_gnu_source" = yes && CPPFLAGS="$CPPFLAGS -D_GNU_SOURCE"
 
-echo "$as_me:6322: checking for ANSI C header files" >&5
+echo "$as_me:6842: checking for ANSI C header files" >&5
 echo $ECHO_N "checking for ANSI C header files... $ECHO_C" >&6
 if test "${ac_cv_header_stdc+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6328 "configure"
+#line 6848 "configure"
 #include "confdefs.h"
 #include <stdlib.h>
 #include <stdarg.h>
@@ -6333,13 +6853,13 @@
 #include <float.h>
 
 _ACEOF
-if { (eval echo "$as_me:6336: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:6856: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:6342: \$? = $ac_status" >&5
+  echo "$as_me:6862: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -6361,7 +6881,7 @@
 if test $ac_cv_header_stdc = yes; then
   # SunOS 4.x string.h does not declare mem*, contrary to ANSI.
   cat >conftest.$ac_ext <<_ACEOF
-#line 6364 "configure"
+#line 6884 "configure"
 #include "confdefs.h"
 #include <string.h>
 
@@ -6379,7 +6899,7 @@
 if test $ac_cv_header_stdc = yes; then
   # ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
   cat >conftest.$ac_ext <<_ACEOF
-#line 6382 "configure"
+#line 6902 "configure"
 #include "confdefs.h"
 #include <stdlib.h>
 
@@ -6400,7 +6920,7 @@
   :
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6403 "configure"
+#line 6923 "configure"
 #include "confdefs.h"
 #include <ctype.h>
 #if ((' ' & 0x0FF) == 0x020)
@@ -6426,15 +6946,15 @@
 }
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:6429: \"$ac_link\"") >&5
+if { (eval echo "$as_me:6949: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6432: \$? = $ac_status" >&5
+  echo "$as_me:6952: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:6434: \"$ac_try\"") >&5
+  { (eval echo "$as_me:6954: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6437: \$? = $ac_status" >&5
+  echo "$as_me:6957: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   :
 else
@@ -6447,7 +6967,7 @@
 fi
 fi
 fi
-echo "$as_me:6450: result: $ac_cv_header_stdc" >&5
+echo "$as_me:6970: result: $ac_cv_header_stdc" >&5
 echo "${ECHO_T}$ac_cv_header_stdc" >&6
 if test $ac_cv_header_stdc = yes; then
 
@@ -6460,13 +6980,13 @@
 ac_header_dirent=no
 for ac_hdr in dirent.h sys/ndir.h sys/dir.h ndir.h; do
   as_ac_Header=`echo "ac_cv_header_dirent_$ac_hdr" | $as_tr_sh`
-echo "$as_me:6463: checking for $ac_hdr that defines DIR" >&5
+echo "$as_me:6983: checking for $ac_hdr that defines DIR" >&5
 echo $ECHO_N "checking for $ac_hdr that defines DIR... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6469 "configure"
+#line 6989 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 #include <$ac_hdr>
@@ -6481,16 +7001,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:6484: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7004: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:6487: \$? = $ac_status" >&5
+  echo "$as_me:7007: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:6490: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7010: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6493: \$? = $ac_status" >&5
+  echo "$as_me:7013: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   eval "$as_ac_Header=yes"
 else
@@ -6500,7 +7020,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:6503: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:7023: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -6513,7 +7033,7 @@
 done
 # Two versions of opendir et al. are in -ldir and -lx on SCO Xenix.
 if test $ac_header_dirent = dirent.h; then
-  echo "$as_me:6516: checking for opendir in -ldir" >&5
+  echo "$as_me:7036: checking for opendir in -ldir" >&5
 echo $ECHO_N "checking for opendir in -ldir... $ECHO_C" >&6
 if test "${ac_cv_lib_dir_opendir+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -6521,7 +7041,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-ldir  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 6524 "configure"
+#line 7044 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -6540,16 +7060,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6543: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7063: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6546: \$? = $ac_status" >&5
+  echo "$as_me:7066: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6549: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7069: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6552: \$? = $ac_status" >&5
+  echo "$as_me:7072: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_dir_opendir=yes
 else
@@ -6560,14 +7080,14 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:6563: result: $ac_cv_lib_dir_opendir" >&5
+echo "$as_me:7083: result: $ac_cv_lib_dir_opendir" >&5
 echo "${ECHO_T}$ac_cv_lib_dir_opendir" >&6
 if test $ac_cv_lib_dir_opendir = yes; then
   LIBS="$LIBS -ldir"
 fi
 
 else
-  echo "$as_me:6570: checking for opendir in -lx" >&5
+  echo "$as_me:7090: checking for opendir in -lx" >&5
 echo $ECHO_N "checking for opendir in -lx... $ECHO_C" >&6
 if test "${ac_cv_lib_x_opendir+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -6575,7 +7095,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-lx  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 6578 "configure"
+#line 7098 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -6594,16 +7114,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6597: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7117: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6600: \$? = $ac_status" >&5
+  echo "$as_me:7120: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6603: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7123: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6606: \$? = $ac_status" >&5
+  echo "$as_me:7126: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_x_opendir=yes
 else
@@ -6614,7 +7134,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:6617: result: $ac_cv_lib_x_opendir" >&5
+echo "$as_me:7137: result: $ac_cv_lib_x_opendir" >&5
 echo "${ECHO_T}$ac_cv_lib_x_opendir" >&6
 if test $ac_cv_lib_x_opendir = yes; then
   LIBS="$LIBS -lx"
@@ -6622,13 +7142,13 @@
 
 fi
 
-echo "$as_me:6625: checking whether time.h and sys/time.h may both be included" >&5
+echo "$as_me:7145: checking whether time.h and sys/time.h may both be included" >&5
 echo $ECHO_N "checking whether time.h and sys/time.h may both be included... $ECHO_C" >&6
 if test "${ac_cv_header_time+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6631 "configure"
+#line 7151 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 #include <sys/time.h>
@@ -6644,16 +7164,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:6647: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7167: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:6650: \$? = $ac_status" >&5
+  echo "$as_me:7170: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:6653: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7173: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6656: \$? = $ac_status" >&5
+  echo "$as_me:7176: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_header_time=yes
 else
@@ -6663,7 +7183,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:6666: result: $ac_cv_header_time" >&5
+echo "$as_me:7186: result: $ac_cv_header_time" >&5
 echo "${ECHO_T}$ac_cv_header_time" >&6
 if test $ac_cv_header_time = yes; then
 
@@ -6673,14 +7193,14 @@
 
 fi
 
-echo "$as_me:6676: checking for regular-expression headers" >&5
+echo "$as_me:7196: checking for regular-expression headers" >&5
 echo $ECHO_N "checking for regular-expression headers... $ECHO_C" >&6
 if test "${cf_cv_regex+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 6683 "configure"
+#line 7203 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 #include <regex.h>
@@ -6698,16 +7218,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6701: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7221: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6704: \$? = $ac_status" >&5
+  echo "$as_me:7224: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6707: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7227: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6710: \$? = $ac_status" >&5
+  echo "$as_me:7230: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_regex="regex.h"
 else
@@ -6715,7 +7235,7 @@
 cat conftest.$ac_ext >&5
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 6718 "configure"
+#line 7238 "configure"
 #include "confdefs.h"
 #include <regexp.h>
 int
@@ -6730,16 +7250,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6733: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7253: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6736: \$? = $ac_status" >&5
+  echo "$as_me:7256: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6739: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7259: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6742: \$? = $ac_status" >&5
+  echo "$as_me:7262: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_regex="regexp.h"
 else
@@ -6749,7 +7269,7 @@
 		cf_save_LIBS="$LIBS"
 		LIBS="-lgen $LIBS"
 		cat >conftest.$ac_ext <<_ACEOF
-#line 6752 "configure"
+#line 7272 "configure"
 #include "confdefs.h"
 #include <regexpr.h>
 int
@@ -6764,16 +7284,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6767: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7287: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6770: \$? = $ac_status" >&5
+  echo "$as_me:7290: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6773: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7293: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6776: \$? = $ac_status" >&5
+  echo "$as_me:7296: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_regex="regexpr.h"
 else
@@ -6789,7 +7309,7 @@
 
 fi
 
-echo "$as_me:6792: result: $cf_cv_regex" >&5
+echo "$as_me:7312: result: $cf_cv_regex" >&5
 echo "${ECHO_T}$cf_cv_regex" >&6
 case $cf_cv_regex in
 	regex.h)   cat >>confdefs.h <<\EOF
@@ -6825,23 +7345,23 @@
 
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:6828: checking for $ac_header" >&5
+echo "$as_me:7348: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 6834 "configure"
+#line 7354 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:6838: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:7358: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:6844: \$? = $ac_status" >&5
+  echo "$as_me:7364: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -6860,7 +7380,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:6863: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:7383: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -6874,7 +7394,7 @@
 # Note: even non-Posix ISC needs <sys/bsdtypes.h> to declare fd_set
 if test "$ISC" = yes ; then
 
-echo "$as_me:6877: checking for main in -lcposix" >&5
+echo "$as_me:7397: checking for main in -lcposix" >&5
 echo $ECHO_N "checking for main in -lcposix... $ECHO_C" >&6
 if test "${ac_cv_lib_cposix_main+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -6882,7 +7402,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-lcposix  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 6885 "configure"
+#line 7405 "configure"
 #include "confdefs.h"
 
 int
@@ -6894,16 +7414,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6897: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7417: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6900: \$? = $ac_status" >&5
+  echo "$as_me:7420: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6903: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7423: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6906: \$? = $ac_status" >&5
+  echo "$as_me:7426: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_cposix_main=yes
 else
@@ -6914,7 +7434,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:6917: result: $ac_cv_lib_cposix_main" >&5
+echo "$as_me:7437: result: $ac_cv_lib_cposix_main" >&5
 echo "${ECHO_T}$ac_cv_lib_cposix_main" >&6
 if test $ac_cv_lib_cposix_main = yes; then
   cat >>confdefs.h <<EOF
@@ -6925,7 +7445,7 @@
 
 fi
 
-	echo "$as_me:6928: checking for bzero in -linet" >&5
+	echo "$as_me:7448: checking for bzero in -linet" >&5
 echo $ECHO_N "checking for bzero in -linet... $ECHO_C" >&6
 if test "${ac_cv_lib_inet_bzero+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -6933,7 +7453,7 @@
   ac_check_lib_save_LIBS=$LIBS
 LIBS="-linet  $LIBS"
 cat >conftest.$ac_ext <<_ACEOF
-#line 6936 "configure"
+#line 7456 "configure"
 #include "confdefs.h"
 
 /* Override any gcc2 internal prototype to avoid an error.  */
@@ -6952,16 +7472,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:6955: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7475: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:6958: \$? = $ac_status" >&5
+  echo "$as_me:7478: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:6961: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7481: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:6964: \$? = $ac_status" >&5
+  echo "$as_me:7484: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_lib_inet_bzero=yes
 else
@@ -6972,21 +7492,21 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 LIBS=$ac_check_lib_save_LIBS
 fi
-echo "$as_me:6975: result: $ac_cv_lib_inet_bzero" >&5
+echo "$as_me:7495: result: $ac_cv_lib_inet_bzero" >&5
 echo "${ECHO_T}$ac_cv_lib_inet_bzero" >&6
 if test $ac_cv_lib_inet_bzero = yes; then
   LIBS="$LIBS -linet"
 fi
 fi
 
-echo "$as_me:6982: checking if sys/time.h works with sys/select.h" >&5
+echo "$as_me:7502: checking if sys/time.h works with sys/select.h" >&5
 echo $ECHO_N "checking if sys/time.h works with sys/select.h... $ECHO_C" >&6
 if test "${cf_cv_sys_time_select+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 6989 "configure"
+#line 7509 "configure"
 #include "confdefs.h"
 
 #include <sys/types.h>
@@ -7006,16 +7526,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7009: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7529: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7012: \$? = $ac_status" >&5
+  echo "$as_me:7532: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7015: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7535: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7018: \$? = $ac_status" >&5
+  echo "$as_me:7538: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_sys_time_select=yes
 else
@@ -7027,7 +7547,7 @@
 
 fi
 
-echo "$as_me:7030: result: $cf_cv_sys_time_select" >&5
+echo "$as_me:7550: result: $cf_cv_sys_time_select" >&5
 echo "${ECHO_T}$cf_cv_sys_time_select" >&6
 test "$cf_cv_sys_time_select" = yes && cat >>confdefs.h <<\EOF
 #define HAVE_SYS_TIME_SELECT 1
@@ -7040,7 +7560,7 @@
 ac_link='$CC -o conftest$ac_exeext $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
 ac_compiler_gnu=$ac_cv_c_compiler_gnu
 
-echo "$as_me:7043: checking for $CC option to accept ANSI C" >&5
+echo "$as_me:7563: checking for $CC option to accept ANSI C" >&5
 echo $ECHO_N "checking for $CC option to accept ANSI C... $ECHO_C" >&6
 if test "${ac_cv_prog_cc_stdc+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -7048,7 +7568,7 @@
   ac_cv_prog_cc_stdc=no
 ac_save_CC=$CC
 cat >conftest.$ac_ext <<_ACEOF
-#line 7051 "configure"
+#line 7571 "configure"
 #include "confdefs.h"
 #include <stdarg.h>
 #include <stdio.h>
@@ -7097,16 +7617,16 @@
 do
   CC="$ac_save_CC $ac_arg"
   rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7100: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7620: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7103: \$? = $ac_status" >&5
+  echo "$as_me:7623: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7106: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7626: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7109: \$? = $ac_status" >&5
+  echo "$as_me:7629: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_prog_cc_stdc=$ac_arg
 break
@@ -7123,21 +7643,21 @@
 
 case "x$ac_cv_prog_cc_stdc" in
   x|xno)
-    echo "$as_me:7126: result: none needed" >&5
+    echo "$as_me:7646: result: none needed" >&5
 echo "${ECHO_T}none needed" >&6 ;;
   *)
-    echo "$as_me:7129: result: $ac_cv_prog_cc_stdc" >&5
+    echo "$as_me:7649: result: $ac_cv_prog_cc_stdc" >&5
 echo "${ECHO_T}$ac_cv_prog_cc_stdc" >&6
     CC="$CC $ac_cv_prog_cc_stdc" ;;
 esac
 
-echo "$as_me:7134: checking for an ANSI C-conforming const" >&5
+echo "$as_me:7654: checking for an ANSI C-conforming const" >&5
 echo $ECHO_N "checking for an ANSI C-conforming const... $ECHO_C" >&6
 if test "${ac_cv_c_const+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7140 "configure"
+#line 7660 "configure"
 #include "confdefs.h"
 
 int
@@ -7195,16 +7715,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7198: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7718: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7201: \$? = $ac_status" >&5
+  echo "$as_me:7721: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7204: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7724: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7207: \$? = $ac_status" >&5
+  echo "$as_me:7727: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_c_const=yes
 else
@@ -7214,7 +7734,7 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:7217: result: $ac_cv_c_const" >&5
+echo "$as_me:7737: result: $ac_cv_c_const" >&5
 echo "${ECHO_T}$ac_cv_c_const" >&6
 if test $ac_cv_c_const = no; then
 
@@ -7224,7 +7744,7 @@
 
 fi
 
-echo "$as_me:7227: checking for inline" >&5
+echo "$as_me:7747: checking for inline" >&5
 echo $ECHO_N "checking for inline... $ECHO_C" >&6
 if test "${ac_cv_c_inline+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -7232,7 +7752,7 @@
   ac_cv_c_inline=no
 for ac_kw in inline __inline__ __inline; do
   cat >conftest.$ac_ext <<_ACEOF
-#line 7235 "configure"
+#line 7755 "configure"
 #include "confdefs.h"
 #ifndef __cplusplus
 static $ac_kw int static_foo () {return 0; }
@@ -7241,16 +7761,16 @@
 
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7244: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7764: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7247: \$? = $ac_status" >&5
+  echo "$as_me:7767: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7250: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7770: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7253: \$? = $ac_status" >&5
+  echo "$as_me:7773: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_c_inline=$ac_kw; break
 else
@@ -7261,7 +7781,7 @@
 done
 
 fi
-echo "$as_me:7264: result: $ac_cv_c_inline" >&5
+echo "$as_me:7784: result: $ac_cv_c_inline" >&5
 echo "${ECHO_T}$ac_cv_c_inline" >&6
 case $ac_cv_c_inline in
   inline | yes) ;;
@@ -7280,14 +7800,14 @@
 #define CC_HAS_INLINE_FUNCS 1
 EOF
 
-echo "$as_me:7283: checking if unsigned literals are legal" >&5
+echo "$as_me:7803: checking if unsigned literals are legal" >&5
 echo $ECHO_N "checking if unsigned literals are legal... $ECHO_C" >&6
 if test "${cf_cv_unsigned_literals+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 7290 "configure"
+#line 7810 "configure"
 #include "confdefs.h"
 
 int
@@ -7299,16 +7819,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7302: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7822: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7305: \$? = $ac_status" >&5
+  echo "$as_me:7825: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7308: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7828: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7311: \$? = $ac_status" >&5
+  echo "$as_me:7831: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_unsigned_literals=yes
 else
@@ -7320,10 +7840,10 @@
 
 fi
 
-echo "$as_me:7323: result: $cf_cv_unsigned_literals" >&5
+echo "$as_me:7843: result: $cf_cv_unsigned_literals" >&5
 echo "${ECHO_T}$cf_cv_unsigned_literals" >&6
 
-echo "$as_me:7326: checking for type of chtype" >&5
+echo "$as_me:7846: checking for type of chtype" >&5
 echo $ECHO_N "checking for type of chtype... $ECHO_C" >&6
 if test "${cf_cv_typeof_chtype+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -7333,7 +7853,7 @@
   cf_cv_typeof_chtype=long
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7336 "configure"
+#line 7856 "configure"
 #include "confdefs.h"
 
 #ifdef USE_WIDEC_SUPPORT
@@ -7380,15 +7900,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:7383: \"$ac_link\"") >&5
+if { (eval echo "$as_me:7903: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7386: \$? = $ac_status" >&5
+  echo "$as_me:7906: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:7388: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7908: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7391: \$? = $ac_status" >&5
+  echo "$as_me:7911: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_typeof_chtype=`cat cf_test.out`
 else
@@ -7403,7 +7923,7 @@
 
 fi
 
-echo "$as_me:7406: result: $cf_cv_typeof_chtype" >&5
+echo "$as_me:7926: result: $cf_cv_typeof_chtype" >&5
 echo "${ECHO_T}$cf_cv_typeof_chtype" >&6
 
 cat >>confdefs.h <<EOF
@@ -7416,14 +7936,14 @@
 
 ###	Checks for external-data
 
-echo "$as_me:7419: checking if external errno is declared" >&5
+echo "$as_me:7939: checking if external errno is declared" >&5
 echo $ECHO_N "checking if external errno is declared... $ECHO_C" >&6
 if test "${cf_cv_dcl_errno+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
     cat >conftest.$ac_ext <<_ACEOF
-#line 7426 "configure"
+#line 7946 "configure"
 #include "confdefs.h"
 
 #ifdef HAVE_STDLIB_H
@@ -7441,16 +7961,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7444: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:7964: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7447: \$? = $ac_status" >&5
+  echo "$as_me:7967: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7450: \"$ac_try\"") >&5
+  { (eval echo "$as_me:7970: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7453: \$? = $ac_status" >&5
+  echo "$as_me:7973: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_dcl_errno=yes
 else
@@ -7461,7 +7981,7 @@
 rm -f conftest.$ac_objext conftest.$ac_ext
 
 fi
-echo "$as_me:7464: result: $cf_cv_dcl_errno" >&5
+echo "$as_me:7984: result: $cf_cv_dcl_errno" >&5
 echo "${ECHO_T}$cf_cv_dcl_errno" >&6
 
 if test "$cf_cv_dcl_errno" = no ; then
@@ -7476,14 +7996,14 @@
 
 # It's possible (for near-UNIX clones) that the data doesn't exist
 
-echo "$as_me:7479: checking if external errno exists" >&5
+echo "$as_me:7999: checking if external errno exists" >&5
 echo $ECHO_N "checking if external errno exists... $ECHO_C" >&6
 if test "${cf_cv_have_errno+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
     cat >conftest.$ac_ext <<_ACEOF
-#line 7486 "configure"
+#line 8006 "configure"
 #include "confdefs.h"
 
 #undef errno
@@ -7498,16 +8018,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:7501: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8021: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7504: \$? = $ac_status" >&5
+  echo "$as_me:8024: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:7507: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8027: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7510: \$? = $ac_status" >&5
+  echo "$as_me:8030: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_have_errno=yes
 else
@@ -7518,7 +8038,7 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 
 fi
-echo "$as_me:7521: result: $cf_cv_have_errno" >&5
+echo "$as_me:8041: result: $cf_cv_have_errno" >&5
 echo "${ECHO_T}$cf_cv_have_errno" >&6
 
 if test "$cf_cv_have_errno" = yes ; then
@@ -7531,7 +8051,7 @@
 
 fi
 
-echo "$as_me:7534: checking if data-only library module links" >&5
+echo "$as_me:8054: checking if data-only library module links" >&5
 echo $ECHO_N "checking if data-only library module links... $ECHO_C" >&6
 if test "${cf_cv_link_dataonly+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -7539,20 +8059,20 @@
 
 	rm -f conftest.a
 	cat >conftest.$ac_ext <<EOF
-#line 7542 "configure"
+#line 8062 "configure"
 int	testdata[3] = { 123, 456, 789 };
 EOF
-	if { (eval echo "$as_me:7545: \"$ac_compile\"") >&5
+	if { (eval echo "$as_me:8065: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7548: \$? = $ac_status" >&5
+  echo "$as_me:8068: \$? = $ac_status" >&5
   (exit $ac_status); } ; then
 		mv conftest.o data.o && \
 		( $AR $AR_OPTS conftest.a data.o ) 2>&5 1>/dev/null
 	fi
 	rm -f conftest.$ac_ext data.o
 	cat >conftest.$ac_ext <<EOF
-#line 7555 "configure"
+#line 8075 "configure"
 int	testfunc()
 {
 #if defined(NeXT)
@@ -7565,23 +8085,23 @@
 #endif
 }
 EOF
-	if { (eval echo "$as_me:7568: \"$ac_compile\"") >&5
+	if { (eval echo "$as_me:8088: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7571: \$? = $ac_status" >&5
+  echo "$as_me:8091: \$? = $ac_status" >&5
   (exit $ac_status); }; then
 		mv conftest.o func.o && \
 		( $AR $AR_OPTS conftest.a func.o ) 2>&5 1>/dev/null
 	fi
 	rm -f conftest.$ac_ext func.o
-	( eval $ac_cv_prog_RANLIB conftest.a ) 2>&5 >/dev/null
+	( eval $RANLIB conftest.a ) 2>&5 >/dev/null
 	cf_saveLIBS="$LIBS"
 	LIBS="conftest.a $LIBS"
 	if test "$cross_compiling" = yes; then
   cf_cv_link_dataonly=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7584 "configure"
+#line 8104 "configure"
 #include "confdefs.h"
 
 	int main()
@@ -7592,15 +8112,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:7595: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8115: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7598: \$? = $ac_status" >&5
+  echo "$as_me:8118: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:7600: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8120: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7603: \$? = $ac_status" >&5
+  echo "$as_me:8123: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_link_dataonly=yes
 else
@@ -7615,7 +8135,7 @@
 
 fi
 
-echo "$as_me:7618: result: $cf_cv_link_dataonly" >&5
+echo "$as_me:8138: result: $cf_cv_link_dataonly" >&5
 echo "${ECHO_T}$cf_cv_link_dataonly" >&6
 
 if test "$cf_cv_link_dataonly" = no ; then
@@ -7652,13 +8172,13 @@
 
 do
 as_ac_var=`echo "ac_cv_func_$ac_func" | $as_tr_sh`
-echo "$as_me:7655: checking for $ac_func" >&5
+echo "$as_me:8175: checking for $ac_func" >&5
 echo $ECHO_N "checking for $ac_func... $ECHO_C" >&6
 if eval "test \"\${$as_ac_var+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7661 "configure"
+#line 8181 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char $ac_func (); below.  */
@@ -7689,16 +8209,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:7692: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8212: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7695: \$? = $ac_status" >&5
+  echo "$as_me:8215: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:7698: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8218: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7701: \$? = $ac_status" >&5
+  echo "$as_me:8221: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   eval "$as_ac_var=yes"
 else
@@ -7708,7 +8228,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:7711: result: `eval echo '${'$as_ac_var'}'`" >&5
+echo "$as_me:8231: result: `eval echo '${'$as_ac_var'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_var'}'`" >&6
 if test `eval echo '${'$as_ac_var'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -7720,14 +8240,14 @@
 
 if test "$with_getcap" = "yes" ; then
 
-echo "$as_me:7723: checking for terminal-capability database functions" >&5
+echo "$as_me:8243: checking for terminal-capability database functions" >&5
 echo $ECHO_N "checking for terminal-capability database functions... $ECHO_C" >&6
 if test "${cf_cv_cgetent+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 7730 "configure"
+#line 8250 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -7747,16 +8267,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:7750: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8270: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7753: \$? = $ac_status" >&5
+  echo "$as_me:8273: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:7756: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8276: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7759: \$? = $ac_status" >&5
+  echo "$as_me:8279: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_cgetent=yes
 else
@@ -7768,7 +8288,7 @@
 
 fi
 
-echo "$as_me:7771: result: $cf_cv_cgetent" >&5
+echo "$as_me:8291: result: $cf_cv_cgetent" >&5
 echo "${ECHO_T}$cf_cv_cgetent" >&6
 test "$cf_cv_cgetent" = yes && cat >>confdefs.h <<\EOF
 #define HAVE_BSD_CGETENT 1
@@ -7776,14 +8296,14 @@
 
 fi
 
-echo "$as_me:7779: checking for isascii" >&5
+echo "$as_me:8299: checking for isascii" >&5
 echo $ECHO_N "checking for isascii... $ECHO_C" >&6
 if test "${cf_cv_have_isascii+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 7786 "configure"
+#line 8306 "configure"
 #include "confdefs.h"
 #include <ctype.h>
 int
@@ -7795,16 +8315,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:7798: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8318: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:7801: \$? = $ac_status" >&5
+  echo "$as_me:8321: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:7804: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8324: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7807: \$? = $ac_status" >&5
+  echo "$as_me:8327: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_have_isascii=yes
 else
@@ -7815,17 +8335,17 @@
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 
 fi
-echo "$as_me:7818: result: $cf_cv_have_isascii" >&5
+echo "$as_me:8338: result: $cf_cv_have_isascii" >&5
 echo "${ECHO_T}$cf_cv_have_isascii" >&6
 test "$cf_cv_have_isascii" = yes && cat >>confdefs.h <<\EOF
 #define HAVE_ISASCII 1
 EOF
 
 if test "$ac_cv_func_sigaction" = yes; then
-echo "$as_me:7825: checking whether sigaction needs _POSIX_SOURCE" >&5
+echo "$as_me:8345: checking whether sigaction needs _POSIX_SOURCE" >&5
 echo $ECHO_N "checking whether sigaction needs _POSIX_SOURCE... $ECHO_C" >&6
 cat >conftest.$ac_ext <<_ACEOF
-#line 7828 "configure"
+#line 8348 "configure"
 #include "confdefs.h"
 
 #include <sys/types.h>
@@ -7839,16 +8359,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7842: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:8362: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7845: \$? = $ac_status" >&5
+  echo "$as_me:8365: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7848: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8368: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7851: \$? = $ac_status" >&5
+  echo "$as_me:8371: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   sigact_bad=no
 else
@@ -7856,7 +8376,7 @@
 cat conftest.$ac_ext >&5
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 7859 "configure"
+#line 8379 "configure"
 #include "confdefs.h"
 
 #define _POSIX_SOURCE
@@ -7871,16 +8391,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:7874: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:8394: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:7877: \$? = $ac_status" >&5
+  echo "$as_me:8397: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:7880: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8400: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:7883: \$? = $ac_status" >&5
+  echo "$as_me:8403: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   sigact_bad=yes
 	 cat >>confdefs.h <<\EOF
@@ -7895,7 +8415,7 @@
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
-echo "$as_me:7898: result: $sigact_bad" >&5
+echo "$as_me:8418: result: $sigact_bad" >&5
 echo "${ECHO_T}$sigact_bad" >&6
 fi
 
@@ -7906,23 +8426,23 @@
 
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:7909: checking for $ac_header" >&5
+echo "$as_me:8429: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7915 "configure"
+#line 8435 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:7919: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:8439: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:7925: \$? = $ac_status" >&5
+  echo "$as_me:8445: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -7941,7 +8461,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:7944: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:8464: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -7956,23 +8476,23 @@
 for ac_header in sys/termio.h
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:7959: checking for $ac_header" >&5
+echo "$as_me:8479: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 7965 "configure"
+#line 8485 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:7969: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:8489: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:7975: \$? = $ac_status" >&5
+  echo "$as_me:8495: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -7991,7 +8511,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:7994: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:8514: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -8009,10 +8529,10 @@
 	*)	termios_bad=maybe ;;
 	esac
 	if test "$termios_bad" = maybe ; then
-	echo "$as_me:8012: checking whether termios.h needs _POSIX_SOURCE" >&5
+	echo "$as_me:8532: checking whether termios.h needs _POSIX_SOURCE" >&5
 echo $ECHO_N "checking whether termios.h needs _POSIX_SOURCE... $ECHO_C" >&6
 	cat >conftest.$ac_ext <<_ACEOF
-#line 8015 "configure"
+#line 8535 "configure"
 #include "confdefs.h"
 #include <termios.h>
 int
@@ -8024,16 +8544,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:8027: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:8547: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:8030: \$? = $ac_status" >&5
+  echo "$as_me:8550: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:8033: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8553: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8036: \$? = $ac_status" >&5
+  echo "$as_me:8556: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   termios_bad=no
 else
@@ -8041,7 +8561,7 @@
 cat conftest.$ac_ext >&5
 
 		cat >conftest.$ac_ext <<_ACEOF
-#line 8044 "configure"
+#line 8564 "configure"
 #include "confdefs.h"
 
 #define _POSIX_SOURCE
@@ -8055,16 +8575,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:8058: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:8578: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:8061: \$? = $ac_status" >&5
+  echo "$as_me:8581: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:8064: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8584: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8067: \$? = $ac_status" >&5
+  echo "$as_me:8587: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   termios_bad=unknown
 else
@@ -8079,19 +8599,19 @@
 
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
-	echo "$as_me:8082: result: $termios_bad" >&5
+	echo "$as_me:8602: result: $termios_bad" >&5
 echo "${ECHO_T}$termios_bad" >&6
 	fi
 fi
 
-echo "$as_me:8087: checking for tcgetattr" >&5
+echo "$as_me:8607: checking for tcgetattr" >&5
 echo $ECHO_N "checking for tcgetattr... $ECHO_C" >&6
 if test "${cf_cv_have_tcgetattr+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 8094 "configure"
+#line 8614 "configure"
 #include "confdefs.h"
 
 #include <sys/types.h>
@@ -8119,16 +8639,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8122: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8642: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8125: \$? = $ac_status" >&5
+  echo "$as_me:8645: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8128: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8648: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8131: \$? = $ac_status" >&5
+  echo "$as_me:8651: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_have_tcgetattr=yes
 else
@@ -8138,20 +8658,20 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:8141: result: $cf_cv_have_tcgetattr" >&5
+echo "$as_me:8661: result: $cf_cv_have_tcgetattr" >&5
 echo "${ECHO_T}$cf_cv_have_tcgetattr" >&6
 test "$cf_cv_have_tcgetattr" = yes && cat >>confdefs.h <<\EOF
 #define HAVE_TCGETATTR 1
 EOF
 
-echo "$as_me:8147: checking for vsscanf function or workaround" >&5
+echo "$as_me:8667: checking for vsscanf function or workaround" >&5
 echo $ECHO_N "checking for vsscanf function or workaround... $ECHO_C" >&6
 if test "${cf_cv_func_vsscanf+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 8154 "configure"
+#line 8674 "configure"
 #include "confdefs.h"
 
 #include <stdarg.h>
@@ -8167,16 +8687,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8170: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8690: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8173: \$? = $ac_status" >&5
+  echo "$as_me:8693: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8176: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8696: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8179: \$? = $ac_status" >&5
+  echo "$as_me:8699: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_func_vsscanf=vsscanf
 else
@@ -8184,7 +8704,7 @@
 cat conftest.$ac_ext >&5
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 8187 "configure"
+#line 8707 "configure"
 #include "confdefs.h"
 
 #include <stdarg.h>
@@ -8206,16 +8726,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8209: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8729: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8212: \$? = $ac_status" >&5
+  echo "$as_me:8732: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8215: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8735: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8218: \$? = $ac_status" >&5
+  echo "$as_me:8738: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_func_vsscanf=vfscanf
 else
@@ -8223,7 +8743,7 @@
 cat conftest.$ac_ext >&5
 
 cat >conftest.$ac_ext <<_ACEOF
-#line 8226 "configure"
+#line 8746 "configure"
 #include "confdefs.h"
 
 #include <stdarg.h>
@@ -8245,16 +8765,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8248: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8768: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8251: \$? = $ac_status" >&5
+  echo "$as_me:8771: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8254: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8774: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8257: \$? = $ac_status" >&5
+  echo "$as_me:8777: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_func_vsscanf=_doscan
 else
@@ -8269,7 +8789,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:8272: result: $cf_cv_func_vsscanf" >&5
+echo "$as_me:8792: result: $cf_cv_func_vsscanf" >&5
 echo "${ECHO_T}$cf_cv_func_vsscanf" >&6
 
 case $cf_cv_func_vsscanf in #(vi
@@ -8287,7 +8807,7 @@
 ;;
 esac
 
-echo "$as_me:8290: checking for working mkstemp" >&5
+echo "$as_me:8810: checking for working mkstemp" >&5
 echo $ECHO_N "checking for working mkstemp... $ECHO_C" >&6
 if test "${cf_cv_func_mkstemp+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -8295,13 +8815,13 @@
 
 rm -f conftest*
 if test "$cross_compiling" = yes; then
-  echo "$as_me:8298: checking for mkstemp" >&5
+  echo "$as_me:8818: checking for mkstemp" >&5
 echo $ECHO_N "checking for mkstemp... $ECHO_C" >&6
 if test "${ac_cv_func_mkstemp+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8304 "configure"
+#line 8824 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char mkstemp (); below.  */
@@ -8332,16 +8852,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8335: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8855: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8338: \$? = $ac_status" >&5
+  echo "$as_me:8858: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8341: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8861: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8344: \$? = $ac_status" >&5
+  echo "$as_me:8864: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_func_mkstemp=yes
 else
@@ -8351,12 +8871,12 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:8354: result: $ac_cv_func_mkstemp" >&5
+echo "$as_me:8874: result: $ac_cv_func_mkstemp" >&5
 echo "${ECHO_T}$ac_cv_func_mkstemp" >&6
 
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8359 "configure"
+#line 8879 "configure"
 #include "confdefs.h"
 
 #include <sys/types.h>
@@ -8394,15 +8914,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:8397: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8917: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8400: \$? = $ac_status" >&5
+  echo "$as_me:8920: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:8402: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8922: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8405: \$? = $ac_status" >&5
+  echo "$as_me:8925: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_func_mkstemp=yes
 
@@ -8417,7 +8937,7 @@
 fi
 
 fi
-echo "$as_me:8420: result: $cf_cv_func_mkstemp" >&5
+echo "$as_me:8940: result: $cf_cv_func_mkstemp" >&5
 echo "${ECHO_T}$cf_cv_func_mkstemp" >&6
 if test "$cf_cv_func_mkstemp" = yes ; then
 	cat >>confdefs.h <<\EOF
@@ -8434,21 +8954,21 @@
 fi
 
 if test "$cross_compiling" = yes ; then
-	{ echo "$as_me:8437: WARNING: cross compiling: assume setvbuf params not reversed" >&5
+	{ echo "$as_me:8957: WARNING: cross compiling: assume setvbuf params not reversed" >&5
 echo "$as_me: WARNING: cross compiling: assume setvbuf params not reversed" >&2;}
 else
-	echo "$as_me:8440: checking whether setvbuf arguments are reversed" >&5
+	echo "$as_me:8960: checking whether setvbuf arguments are reversed" >&5
 echo $ECHO_N "checking whether setvbuf arguments are reversed... $ECHO_C" >&6
 if test "${ac_cv_func_setvbuf_reversed+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   if test "$cross_compiling" = yes; then
-  { { echo "$as_me:8446: error: cannot run test program while cross compiling" >&5
+  { { echo "$as_me:8966: error: cannot run test program while cross compiling" >&5
 echo "$as_me: error: cannot run test program while cross compiling" >&2;}
    { (exit 1); exit 1; }; }
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8451 "configure"
+#line 8971 "configure"
 #include "confdefs.h"
 #include <stdio.h>
 /* If setvbuf has the reversed format, exit 0. */
@@ -8465,15 +8985,15 @@
 }
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:8468: \"$ac_link\"") >&5
+if { (eval echo "$as_me:8988: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8471: \$? = $ac_status" >&5
+  echo "$as_me:8991: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:8473: \"$ac_try\"") >&5
+  { (eval echo "$as_me:8993: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8476: \$? = $ac_status" >&5
+  echo "$as_me:8996: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_func_setvbuf_reversed=yes
 else
@@ -8486,7 +9006,7 @@
 fi
 rm -f core core.* *.core
 fi
-echo "$as_me:8489: result: $ac_cv_func_setvbuf_reversed" >&5
+echo "$as_me:9009: result: $ac_cv_func_setvbuf_reversed" >&5
 echo "${ECHO_T}$ac_cv_func_setvbuf_reversed" >&6
 if test $ac_cv_func_setvbuf_reversed = yes; then
 
@@ -8497,13 +9017,13 @@
 fi
 
 fi
-echo "$as_me:8500: checking return type of signal handlers" >&5
+echo "$as_me:9020: checking return type of signal handlers" >&5
 echo $ECHO_N "checking return type of signal handlers... $ECHO_C" >&6
 if test "${ac_cv_type_signal+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8506 "configure"
+#line 9026 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 #include <signal.h>
@@ -8525,16 +9045,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:8528: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:9048: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:8531: \$? = $ac_status" >&5
+  echo "$as_me:9051: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:8534: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9054: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8537: \$? = $ac_status" >&5
+  echo "$as_me:9057: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_type_signal=void
 else
@@ -8544,21 +9064,21 @@
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
-echo "$as_me:8547: result: $ac_cv_type_signal" >&5
+echo "$as_me:9067: result: $ac_cv_type_signal" >&5
 echo "${ECHO_T}$ac_cv_type_signal" >&6
 
 cat >>confdefs.h <<EOF
 #define RETSIGTYPE $ac_cv_type_signal
 EOF
 
-echo "$as_me:8554: checking for type sigaction_t" >&5
+echo "$as_me:9074: checking for type sigaction_t" >&5
 echo $ECHO_N "checking for type sigaction_t... $ECHO_C" >&6
 if test "${cf_cv_type_sigaction+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 8561 "configure"
+#line 9081 "configure"
 #include "confdefs.h"
 
 #include <signal.h>
@@ -8571,16 +9091,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:8574: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:9094: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:8577: \$? = $ac_status" >&5
+  echo "$as_me:9097: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:8580: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9100: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8583: \$? = $ac_status" >&5
+  echo "$as_me:9103: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_type_sigaction=yes
 else
@@ -8591,13 +9111,13 @@
 rm -f conftest.$ac_objext conftest.$ac_ext
 fi
 
-echo "$as_me:8594: result: $cf_cv_type_sigaction" >&5
+echo "$as_me:9114: result: $cf_cv_type_sigaction" >&5
 echo "${ECHO_T}$cf_cv_type_sigaction" >&6
 test "$cf_cv_type_sigaction" = yes && cat >>confdefs.h <<\EOF
 #define HAVE_TYPE_SIGACTION 1
 EOF
 
-echo "$as_me:8600: checking declaration of size-change" >&5
+echo "$as_me:9120: checking declaration of size-change" >&5
 echo $ECHO_N "checking declaration of size-change... $ECHO_C" >&6
 if test "${cf_cv_sizechange+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -8612,7 +9132,7 @@
     CPPFLAGS="$cf_save_CPPFLAGS"
     test -n "$cf_opts" && CPPFLAGS="$CPPFLAGS -D$cf_opts"
     cat >conftest.$ac_ext <<_ACEOF
-#line 8615 "configure"
+#line 9135 "configure"
 #include "confdefs.h"
 #include <sys/types.h>
 #ifdef HAVE_TERMIOS_H
@@ -8656,16 +9176,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:8659: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:9179: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:8662: \$? = $ac_status" >&5
+  echo "$as_me:9182: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:8665: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9185: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8668: \$? = $ac_status" >&5
+  echo "$as_me:9188: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_sizechange=yes
 else
@@ -8684,7 +9204,7 @@
 done
 
 fi
-echo "$as_me:8687: result: $cf_cv_sizechange" >&5
+echo "$as_me:9207: result: $cf_cv_sizechange" >&5
 echo "${ECHO_T}$cf_cv_sizechange" >&6
 if test "$cf_cv_sizechange" != no ; then
 	cat >>confdefs.h <<\EOF
@@ -8701,13 +9221,13 @@
 	esac
 fi
 
-echo "$as_me:8704: checking for memmove" >&5
+echo "$as_me:9224: checking for memmove" >&5
 echo $ECHO_N "checking for memmove... $ECHO_C" >&6
 if test "${ac_cv_func_memmove+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8710 "configure"
+#line 9230 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char memmove (); below.  */
@@ -8738,16 +9258,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8741: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9261: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8744: \$? = $ac_status" >&5
+  echo "$as_me:9264: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8747: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9267: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8750: \$? = $ac_status" >&5
+  echo "$as_me:9270: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_func_memmove=yes
 else
@@ -8757,19 +9277,19 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:8760: result: $ac_cv_func_memmove" >&5
+echo "$as_me:9280: result: $ac_cv_func_memmove" >&5
 echo "${ECHO_T}$ac_cv_func_memmove" >&6
 if test $ac_cv_func_memmove = yes; then
   :
 else
 
-echo "$as_me:8766: checking for bcopy" >&5
+echo "$as_me:9286: checking for bcopy" >&5
 echo $ECHO_N "checking for bcopy... $ECHO_C" >&6
 if test "${ac_cv_func_bcopy+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8772 "configure"
+#line 9292 "configure"
 #include "confdefs.h"
 /* System header to define __stub macros and hopefully few prototypes,
     which can conflict with char bcopy (); below.  */
@@ -8800,16 +9320,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:8803: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9323: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8806: \$? = $ac_status" >&5
+  echo "$as_me:9326: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:8809: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9329: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8812: \$? = $ac_status" >&5
+  echo "$as_me:9332: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   ac_cv_func_bcopy=yes
 else
@@ -8819,11 +9339,11 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 fi
-echo "$as_me:8822: result: $ac_cv_func_bcopy" >&5
+echo "$as_me:9342: result: $ac_cv_func_bcopy" >&5
 echo "${ECHO_T}$ac_cv_func_bcopy" >&6
 if test $ac_cv_func_bcopy = yes; then
 
-	echo "$as_me:8826: checking if bcopy does overlapping moves" >&5
+	echo "$as_me:9346: checking if bcopy does overlapping moves" >&5
 echo $ECHO_N "checking if bcopy does overlapping moves... $ECHO_C" >&6
 if test "${cf_cv_good_bcopy+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -8833,7 +9353,7 @@
   cf_cv_good_bcopy=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8836 "configure"
+#line 9356 "configure"
 #include "confdefs.h"
 
 int main() {
@@ -8847,15 +9367,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:8850: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9370: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8853: \$? = $ac_status" >&5
+  echo "$as_me:9373: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:8855: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9375: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8858: \$? = $ac_status" >&5
+  echo "$as_me:9378: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_good_bcopy=yes
 else
@@ -8868,7 +9388,7 @@
 fi
 
 fi
-echo "$as_me:8871: result: $cf_cv_good_bcopy" >&5
+echo "$as_me:9391: result: $cf_cv_good_bcopy" >&5
 echo "${ECHO_T}$cf_cv_good_bcopy" >&6
 
 else
@@ -8889,7 +9409,7 @@
 
 fi
 
-echo "$as_me:8892: checking if poll really works" >&5
+echo "$as_me:9412: checking if poll really works" >&5
 echo $ECHO_N "checking if poll really works... $ECHO_C" >&6
 if test "${cf_cv_working_poll+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -8899,7 +9419,7 @@
   cf_cv_working_poll=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8902 "configure"
+#line 9422 "configure"
 #include "confdefs.h"
 
 #include <stdio.h>
@@ -8920,15 +9440,15 @@
 }
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:8923: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9443: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:8926: \$? = $ac_status" >&5
+  echo "$as_me:9446: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:8928: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9448: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:8931: \$? = $ac_status" >&5
+  echo "$as_me:9451: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_working_poll=yes
 else
@@ -8940,34 +9460,36 @@
 rm -f core core.* *.core conftest$ac_exeext conftest.$ac_objext conftest.$ac_ext
 fi
 fi
-echo "$as_me:8943: result: $cf_cv_working_poll" >&5
+echo "$as_me:9463: result: $cf_cv_working_poll" >&5
 echo "${ECHO_T}$cf_cv_working_poll" >&6
 test "$cf_cv_working_poll" = "yes" && cat >>confdefs.h <<\EOF
 #define HAVE_WORKING_POLL 1
 EOF
 
 if test -z "$cf_user_CFLAGS" ; then
-	CFLAGS=`echo ${CFLAGS} | sed -e 's/-g //' -e 's/-g$//'`
-	CXXFLAGS=`echo ${CXXFLAGS} | sed -e 's/-g //' -e 's/-g$//'`
+	CFLAGS=`echo ${CFLAGS} | sed -e 's%-g %%' -e 's%-g$%%'`
+	CXXFLAGS=`echo ${CXXFLAGS} | sed -e 's%-g %%' -e 's%-g$%%'`
 fi
 
-echo "$as_me:8954: checking for stdbool.h" >&5
+# Just in case, check if the C compiler has a bool type.
+
+echo "$as_me:9476: checking for stdbool.h" >&5
 echo $ECHO_N "checking for stdbool.h... $ECHO_C" >&6
 if test "${ac_cv_header_stdbool_h+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 8960 "configure"
+#line 9482 "configure"
 #include "confdefs.h"
 #include <stdbool.h>
 _ACEOF
-if { (eval echo "$as_me:8964: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9486: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:8970: \$? = $ac_status" >&5
+  echo "$as_me:9492: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_c_preproc_warn_flag
@@ -8986,7 +9508,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:8989: result: $ac_cv_header_stdbool_h" >&5
+echo "$as_me:9511: result: $ac_cv_header_stdbool_h" >&5
 echo "${ECHO_T}$ac_cv_header_stdbool_h" >&6
 if test $ac_cv_header_stdbool_h = yes; then
   cf_cv_header_stdbool_h=1
@@ -8994,14 +9516,14 @@
   cf_cv_header_stdbool_h=0
 fi
 
-echo "$as_me:8997: checking for builtin bool type" >&5
+echo "$as_me:9519: checking for builtin bool type" >&5
 echo $ECHO_N "checking for builtin bool type... $ECHO_C" >&6
-if test "${cf_cv_cc_bool_type+set}" = set; then
+if test "${cv_cv_cc_bool_type+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 9004 "configure"
+#line 9526 "configure"
 #include "confdefs.h"
 
 #include <stdio.h>
@@ -9016,34 +9538,35 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:9019: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:9541: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:9022: \$? = $ac_status" >&5
+  echo "$as_me:9544: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:9025: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9547: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9028: \$? = $ac_status" >&5
+  echo "$as_me:9550: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
-  cf_cv_cc_bool_type=1
+  cv_cv_cc_bool_type=1
 else
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
-cf_cv_cc_bool_type=0
+cv_cv_cc_bool_type=0
 fi
 rm -f conftest.$ac_objext conftest.$ac_ext
 
 fi
 
-if test "$cf_cv_cc_bool_type" = 1
-then	echo "$as_me:9041: result: yes" >&5
+if test "$cv_cv_cc_bool_type" = 1
+then	echo "$as_me:9563: result: yes" >&5
 echo "${ECHO_T}yes" >&6
-else	echo "$as_me:9043: result: no" >&5
+else	echo "$as_me:9565: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
+# Check for C++ compiler characteristics (and ensure that it's there!)
 if test -n "$CXX" ; then
 	ac_ext=cc
 ac_cpp='$CXXCPP $CPPFLAGS'
@@ -9060,7 +9583,7 @@
 	cf_stdcpp_libname=stdc++
 	;;
 esac
-echo "$as_me:9063: checking for library $cf_stdcpp_libname" >&5
+echo "$as_me:9586: checking for library $cf_stdcpp_libname" >&5
 echo $ECHO_N "checking for library $cf_stdcpp_libname... $ECHO_C" >&6
 if test "${cf_cv_libstdcpp+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -9069,7 +9592,7 @@
 	cf_save="$LIBS"
 	LIBS="$LIBS -l$cf_stdcpp_libname"
 cat >conftest.$ac_ext <<_ACEOF
-#line 9072 "configure"
+#line 9595 "configure"
 #include "confdefs.h"
 
 #include <strstream.h>
@@ -9085,16 +9608,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:9088: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9611: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9091: \$? = $ac_status" >&5
+  echo "$as_me:9614: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:9094: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9617: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9097: \$? = $ac_status" >&5
+  echo "$as_me:9620: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_libstdcpp=yes
 else
@@ -9106,7 +9629,7 @@
 	LIBS="$cf_save"
 
 fi
-echo "$as_me:9109: result: $cf_cv_libstdcpp" >&5
+echo "$as_me:9632: result: $cf_cv_libstdcpp" >&5
 echo "${ECHO_T}$cf_cv_libstdcpp" >&6
 test "$cf_cv_libstdcpp" = yes && CXXLIBS="$CXXLIBS -l$cf_stdcpp_libname"
 fi
@@ -9126,13 +9649,13 @@
 	cf_gpp_libname=g++
 	;;
 esac
-if test "$ac_cv_cxx_compiler_gnu" = yes; then
-	echo "$as_me:9130: checking for lib$cf_gpp_libname" >&5
+if test "$GXX" = yes; then
+	echo "$as_me:9653: checking for lib$cf_gpp_libname" >&5
 echo $ECHO_N "checking for lib$cf_gpp_libname... $ECHO_C" >&6
 	cf_save="$LIBS"
 	LIBS="$LIBS -l$cf_gpp_libname"
 	cat >conftest.$ac_ext <<_ACEOF
-#line 9135 "configure"
+#line 9658 "configure"
 #include "confdefs.h"
 
 #include <$cf_gpp_libname/builtin.h>
@@ -9146,16 +9669,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:9149: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9672: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9152: \$? = $ac_status" >&5
+  echo "$as_me:9675: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:9155: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9678: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9158: \$? = $ac_status" >&5
+  echo "$as_me:9681: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cxx_library=yes
 	 CXXLIBS="$CXXLIBS -l$cf_gpp_libname"
@@ -9174,7 +9697,7 @@
   echo "$as_me: failed program was:" >&5
 cat conftest.$ac_ext >&5
 cat >conftest.$ac_ext <<_ACEOF
-#line 9177 "configure"
+#line 9700 "configure"
 #include "confdefs.h"
 
 #include <builtin.h>
@@ -9188,16 +9711,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:9191: \"$ac_link\"") >&5
+if { (eval echo "$as_me:9714: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9194: \$? = $ac_status" >&5
+  echo "$as_me:9717: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:9197: \"$ac_try\"") >&5
+  { (eval echo "$as_me:9720: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9200: \$? = $ac_status" >&5
+  echo "$as_me:9723: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cxx_library=yes
 	 CXXLIBS="$CXXLIBS -l$cf_gpp_libname"
@@ -9214,7 +9737,7 @@
 fi
 rm -f conftest.$ac_objext conftest$ac_exeext conftest.$ac_ext
 	LIBS="$cf_save"
-	echo "$as_me:9217: result: $cf_cxx_library" >&5
+	echo "$as_me:9740: result: $cf_cxx_library" >&5
 echo "${ECHO_T}$cf_cxx_library" >&6
 fi
 
@@ -9229,7 +9752,7 @@
 ac_compile='$CXX -c $CXXFLAGS $CPPFLAGS conftest.$ac_ext >&5'
 ac_link='$CXX -o conftest$ac_exeext $CXXFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS >&5'
 ac_compiler_gnu=$ac_cv_cxx_compiler_gnu
-echo "$as_me:9232: checking how to run the C++ preprocessor" >&5
+echo "$as_me:9755: checking how to run the C++ preprocessor" >&5
 echo $ECHO_N "checking how to run the C++ preprocessor... $ECHO_C" >&6
 if test -z "$CXXCPP"; then
   if test "${ac_cv_prog_CXXCPP+set}" = set; then
@@ -9246,18 +9769,18 @@
   # On the NeXT, cc -E runs the code through the compiler's parser,
   # not just through cpp. "Syntax error" is here to catch this case.
   cat >conftest.$ac_ext <<_ACEOF
-#line 9249 "configure"
+#line 9772 "configure"
 #include "confdefs.h"
 #include <assert.h>
                      Syntax error
 _ACEOF
-if { (eval echo "$as_me:9254: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9777: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9260: \$? = $ac_status" >&5
+  echo "$as_me:9783: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9280,17 +9803,17 @@
   # OK, works on sane cases.  Now check whether non-existent headers
   # can be detected and how.
   cat >conftest.$ac_ext <<_ACEOF
-#line 9283 "configure"
+#line 9806 "configure"
 #include "confdefs.h"
 #include <ac_nonexistent.h>
 _ACEOF
-if { (eval echo "$as_me:9287: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9810: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9293: \$? = $ac_status" >&5
+  echo "$as_me:9816: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9327,7 +9850,7 @@
 else
   ac_cv_prog_CXXCPP=$CXXCPP
 fi
-echo "$as_me:9330: result: $CXXCPP" >&5
+echo "$as_me:9853: result: $CXXCPP" >&5
 echo "${ECHO_T}$CXXCPP" >&6
 ac_preproc_ok=false
 for ac_cxx_preproc_warn_flag in '' yes
@@ -9337,18 +9860,18 @@
   # On the NeXT, cc -E runs the code through the compiler's parser,
   # not just through cpp. "Syntax error" is here to catch this case.
   cat >conftest.$ac_ext <<_ACEOF
-#line 9340 "configure"
+#line 9863 "configure"
 #include "confdefs.h"
 #include <assert.h>
                      Syntax error
 _ACEOF
-if { (eval echo "$as_me:9345: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9868: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9351: \$? = $ac_status" >&5
+  echo "$as_me:9874: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9371,17 +9894,17 @@
   # OK, works on sane cases.  Now check whether non-existent headers
   # can be detected and how.
   cat >conftest.$ac_ext <<_ACEOF
-#line 9374 "configure"
+#line 9897 "configure"
 #include "confdefs.h"
 #include <ac_nonexistent.h>
 _ACEOF
-if { (eval echo "$as_me:9378: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9901: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9384: \$? = $ac_status" >&5
+  echo "$as_me:9907: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9409,7 +9932,7 @@
 if $ac_preproc_ok; then
   :
 else
-  { { echo "$as_me:9412: error: C++ preprocessor \"$CXXCPP\" fails sanity check" >&5
+  { { echo "$as_me:9935: error: C++ preprocessor \"$CXXCPP\" fails sanity check" >&5
 echo "$as_me: error: C++ preprocessor \"$CXXCPP\" fails sanity check" >&2;}
    { (exit 1); exit 1; }; }
 fi
@@ -9423,23 +9946,23 @@
 for ac_header in typeinfo
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:9426: checking for $ac_header" >&5
+echo "$as_me:9949: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 9432 "configure"
+#line 9955 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:9436: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:9959: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9442: \$? = $ac_status" >&5
+  echo "$as_me:9965: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9458,7 +9981,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:9461: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:9984: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -9468,23 +9991,23 @@
 fi
 done
 
-echo "$as_me:9471: checking for stdbool.h" >&5
+echo "$as_me:9994: checking for stdbool.h" >&5
 echo $ECHO_N "checking for stdbool.h... $ECHO_C" >&6
 if test "${ac_cv_header_stdbool_h+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 9477 "configure"
+#line 10000 "configure"
 #include "confdefs.h"
 #include <stdbool.h>
 _ACEOF
-if { (eval echo "$as_me:9481: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:10004: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9487: \$? = $ac_status" >&5
+  echo "$as_me:10010: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9503,7 +10026,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:9506: result: $ac_cv_header_stdbool_h" >&5
+echo "$as_me:10029: result: $ac_cv_header_stdbool_h" >&5
 echo "${ECHO_T}$ac_cv_header_stdbool_h" >&6
 if test $ac_cv_header_stdbool_h = yes; then
   cf_cv_header_stdbool_h=1
@@ -9511,14 +10034,14 @@
   cf_cv_header_stdbool_h=0
 fi
 
-echo "$as_me:9514: checking for builtin bool type" >&5
+echo "$as_me:10037: checking for builtin bool type" >&5
 echo $ECHO_N "checking for builtin bool type... $ECHO_C" >&6
 if test "${cf_cv_builtin_bool+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
 
 	cat >conftest.$ac_ext <<_ACEOF
-#line 9521 "configure"
+#line 10044 "configure"
 #include "confdefs.h"
 
 #include <stdio.h>
@@ -9533,16 +10056,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:9536: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:10059: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:9539: \$? = $ac_status" >&5
+  echo "$as_me:10062: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:9542: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10065: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9545: \$? = $ac_status" >&5
+  echo "$as_me:10068: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_builtin_bool=1
 else
@@ -9555,13 +10078,13 @@
 fi
 
 if test "$cf_cv_builtin_bool" = 1
-then	echo "$as_me:9558: result: yes" >&5
+then	echo "$as_me:10081: result: yes" >&5
 echo "${ECHO_T}yes" >&6
-else	echo "$as_me:9560: result: no" >&5
+else	echo "$as_me:10083: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
-echo "$as_me:9564: checking for size of bool" >&5
+echo "$as_me:10087: checking for size of bool" >&5
 echo $ECHO_N "checking for size of bool... $ECHO_C" >&6
 if test "${cf_cv_type_of_bool+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -9572,7 +10095,7 @@
   cf_cv_type_of_bool=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 9575 "configure"
+#line 10098 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -9614,15 +10137,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:9617: \"$ac_link\"") >&5
+if { (eval echo "$as_me:10140: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9620: \$? = $ac_status" >&5
+  echo "$as_me:10143: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:9622: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10145: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9625: \$? = $ac_status" >&5
+  echo "$as_me:10148: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_type_of_bool=`cat cf_test.out`
 		 if test -z "$cf_cv_type_of_bool"; then
@@ -9640,18 +10163,18 @@
 fi
 
 	rm -f cf_test.out
-echo "$as_me:9643: result: $cf_cv_type_of_bool" >&5
+echo "$as_me:10166: result: $cf_cv_type_of_bool" >&5
 echo "${ECHO_T}$cf_cv_type_of_bool" >&6
 if test "$cf_cv_type_of_bool" = unknown ; then
 	case .$NCURSES_BOOL in #(vi
 	.auto|.) NCURSES_BOOL=unsigned;;
 	esac
-	{ echo "$as_me:9649: WARNING: Assuming $NCURSES_BOOL for type of bool" >&5
+	{ echo "$as_me:10172: WARNING: Assuming $NCURSES_BOOL for type of bool" >&5
 echo "$as_me: WARNING: Assuming $NCURSES_BOOL for type of bool" >&2;}
 	cf_cv_type_of_bool=$NCURSES_BOOL
 fi
 
-echo "$as_me:9654: checking for special defines needed for etip.h" >&5
+echo "$as_me:10177: checking for special defines needed for etip.h" >&5
 echo $ECHO_N "checking for special defines needed for etip.h... $ECHO_C" >&6
 cf_save_CXXFLAGS="$CXXFLAGS"
 cf_result="none"
@@ -9659,11 +10182,11 @@
 do
 for cf_excp in "" MATH_EXCEPTION
 do
-	CXXFLAGS="$cf_save_CXXFLAGS -I${srcdir}/c++ -I${srcdir}/menu"
+	CXXFLAGS="$cf_save_CXXFLAGS -I${srcdir}/c++ -I${srcdir}/menu -I${srcdir}/include"
 	test -n "$cf_math" && CXXFLAGS="$CXXFLAGS -DETIP_NEEDS_${cf_math}"
 	test -n "$cf_excp" && CXXFLAGS="$CXXFLAGS -DETIP_NEEDS_${cf_excp}"
 cat >conftest.$ac_ext <<_ACEOF
-#line 9666 "configure"
+#line 10189 "configure"
 #include "confdefs.h"
 
 #include <etip.h.in>
@@ -9677,16 +10200,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext
-if { (eval echo "$as_me:9680: \"$ac_compile\"") >&5
+if { (eval echo "$as_me:10203: \"$ac_compile\"") >&5
   (eval $ac_compile) 2>&5
   ac_status=$?
-  echo "$as_me:9683: \$? = $ac_status" >&5
+  echo "$as_me:10206: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest.$ac_objext'
-  { (eval echo "$as_me:9686: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10209: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9689: \$? = $ac_status" >&5
+  echo "$as_me:10212: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
 
 	test -n "$cf_math" && cat >>confdefs.h <<EOF
@@ -9707,12 +10230,12 @@
 rm -f conftest.$ac_objext conftest.$ac_ext
 done
 done
-echo "$as_me:9710: result: $cf_result" >&5
+echo "$as_me:10233: result: $cf_result" >&5
 echo "${ECHO_T}$cf_result" >&6
 CXXFLAGS="$cf_save_CXXFLAGS"
 
 if test -n "$CXX"; then
-echo "$as_me:9715: checking if $CXX accepts parameter initialization" >&5
+echo "$as_me:10238: checking if $CXX accepts parameter initialization" >&5
 echo $ECHO_N "checking if $CXX accepts parameter initialization... $ECHO_C" >&6
 if test "${cf_cv_cpp_param_init+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -9728,7 +10251,7 @@
   cf_cv_cpp_param_init=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 9731 "configure"
+#line 10254 "configure"
 #include "confdefs.h"
 
 class TEST {
@@ -9747,15 +10270,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:9750: \"$ac_link\"") >&5
+if { (eval echo "$as_me:10273: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9753: \$? = $ac_status" >&5
+  echo "$as_me:10276: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:9755: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10278: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9758: \$? = $ac_status" >&5
+  echo "$as_me:10281: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_cpp_param_init=yes
 else
@@ -9773,7 +10296,7 @@
 ac_compiler_gnu=$ac_cv_cxx_compiler_gnu
 
 fi
-echo "$as_me:9776: result: $cf_cv_cpp_param_init" >&5
+echo "$as_me:10299: result: $cf_cv_cpp_param_init" >&5
 echo "${ECHO_T}$cf_cv_cpp_param_init" >&6
 fi
 test "$cf_cv_cpp_param_init" = yes && cat >>confdefs.h <<\EOF
@@ -9791,23 +10314,23 @@
 for ac_header in strstream.h
 do
 as_ac_Header=`echo "ac_cv_header_$ac_header" | $as_tr_sh`
-echo "$as_me:9794: checking for $ac_header" >&5
+echo "$as_me:10317: checking for $ac_header" >&5
 echo $ECHO_N "checking for $ac_header... $ECHO_C" >&6
 if eval "test \"\${$as_ac_Header+set}\" = set"; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 9800 "configure"
+#line 10323 "configure"
 #include "confdefs.h"
 #include <$ac_header>
 _ACEOF
-if { (eval echo "$as_me:9804: \"$ac_cpp conftest.$ac_ext\"") >&5
+if { (eval echo "$as_me:10327: \"$ac_cpp conftest.$ac_ext\"") >&5
   (eval $ac_cpp conftest.$ac_ext) 2>conftest.er1
   ac_status=$?
   egrep -v '^ *\+' conftest.er1 >conftest.err
   rm -f conftest.er1
   cat conftest.err >&5
-  echo "$as_me:9810: \$? = $ac_status" >&5
+  echo "$as_me:10333: \$? = $ac_status" >&5
   (exit $ac_status); } >/dev/null; then
   if test -s conftest.err; then
     ac_cpp_err=$ac_cxx_preproc_warn_flag
@@ -9826,7 +10349,7 @@
 fi
 rm -f conftest.err conftest.$ac_ext
 fi
-echo "$as_me:9829: result: `eval echo '${'$as_ac_Header'}'`" >&5
+echo "$as_me:10352: result: `eval echo '${'$as_ac_Header'}'`" >&5
 echo "${ECHO_T}`eval echo '${'$as_ac_Header'}'`" >&6
 if test `eval echo '${'$as_ac_Header'}'` = yes; then
   cat >>confdefs.h <<EOF
@@ -9836,7 +10359,7 @@
 fi
 done
 
-echo "$as_me:9839: checking if $CXX supports vscan function" >&5
+echo "$as_me:10362: checking if $CXX supports vscan function" >&5
 echo $ECHO_N "checking if $CXX supports vscan function... $ECHO_C" >&6
 if test "${cf_cv_cpp_vscan_func+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -9850,7 +10373,7 @@
 	strstream_cast)	cf_vscan_defs=USE_STRSTREAM_VSCAN_CAST ;;
 	esac
 	cat >conftest.$ac_ext <<_ACEOF
-#line 9853 "configure"
+#line 10376 "configure"
 #include "confdefs.h"
 
 #include <stdio.h>
@@ -9895,16 +10418,16 @@
 }
 _ACEOF
 rm -f conftest.$ac_objext conftest$ac_exeext
-if { (eval echo "$as_me:9898: \"$ac_link\"") >&5
+if { (eval echo "$as_me:10421: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:9901: \$? = $ac_status" >&5
+  echo "$as_me:10424: \$? = $ac_status" >&5
   (exit $ac_status); } &&
          { ac_try='test -s conftest$ac_exeext'
-  { (eval echo "$as_me:9904: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10427: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:9907: \$? = $ac_status" >&5
+  echo "$as_me:10430: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_cpp_vscan_func=$cf_vscan_func; break
 else
@@ -9917,7 +10440,7 @@
 	done
 
 fi
-echo "$as_me:9920: result: $cf_cv_cpp_vscan_func" >&5
+echo "$as_me:10443: result: $cf_cv_cpp_vscan_func" >&5
 echo "${ECHO_T}$cf_cv_cpp_vscan_func" >&6
 
 ac_ext=cc
@@ -9999,7 +10522,7 @@
 	else
 		if test "$cf_cv_header_stdbool_h" = 1 ; then
 
-echo "$as_me:10002: checking for size of bool" >&5
+echo "$as_me:10525: checking for size of bool" >&5
 echo $ECHO_N "checking for size of bool... $ECHO_C" >&6
 if test "${cf_cv_type_of_bool+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -10010,7 +10533,7 @@
   cf_cv_type_of_bool=unknown
 else
   cat >conftest.$ac_ext <<_ACEOF
-#line 10013 "configure"
+#line 10536 "configure"
 #include "confdefs.h"
 
 #include <stdlib.h>
@@ -10052,15 +10575,15 @@
 
 _ACEOF
 rm -f conftest$ac_exeext
-if { (eval echo "$as_me:10055: \"$ac_link\"") >&5
+if { (eval echo "$as_me:10578: \"$ac_link\"") >&5
   (eval $ac_link) 2>&5
   ac_status=$?
-  echo "$as_me:10058: \$? = $ac_status" >&5
+  echo "$as_me:10581: \$? = $ac_status" >&5
   (exit $ac_status); } && { ac_try='./conftest$ac_exeext'
-  { (eval echo "$as_me:10060: \"$ac_try\"") >&5
+  { (eval echo "$as_me:10583: \"$ac_try\"") >&5
   (eval $ac_try) 2>&5
   ac_status=$?
-  echo "$as_me:10063: \$? = $ac_status" >&5
+  echo "$as_me:10586: \$? = $ac_status" >&5
   (exit $ac_status); }; }; then
   cf_cv_type_of_bool=`cat cf_test.out`
 		 if test -z "$cf_cv_type_of_bool"; then
@@ -10078,35 +10601,54 @@
 fi
 
 	rm -f cf_test.out
-echo "$as_me:10081: result: $cf_cv_type_of_bool" >&5
+echo "$as_me:10604: result: $cf_cv_type_of_bool" >&5
 echo "${ECHO_T}$cf_cv_type_of_bool" >&6
 if test "$cf_cv_type_of_bool" = unknown ; then
 	case .$NCURSES_BOOL in #(vi
 	.auto|.) NCURSES_BOOL=unsigned;;
 	esac
-	{ echo "$as_me:10087: WARNING: Assuming $NCURSES_BOOL for type of bool" >&5
+	{ echo "$as_me:10610: WARNING: Assuming $NCURSES_BOOL for type of bool" >&5
 echo "$as_me: WARNING: Assuming $NCURSES_BOOL for type of bool" >&2;}
 	cf_cv_type_of_bool=$NCURSES_BOOL
 fi
 
 		else
-			echo "$as_me:10093: checking for fallback type of bool" >&5
+			echo "$as_me:10616: checking for fallback type of bool" >&5
 echo $ECHO_N "checking for fallback type of bool... $ECHO_C" >&6
 			case "$host_cpu" in #(vi
 			i?86)	cf_cv_type_of_bool=char	;; #(vi
 			*)	cf_cv_type_of_bool=int	;;
 			esac
-			echo "$as_me:10099: result: $cf_cv_type_of_bool" >&5
+			echo "$as_me:10622: result: $cf_cv_type_of_bool" >&5
 echo "${ECHO_T}$cf_cv_type_of_bool" >&6
 		fi
 	fi
 fi
 
+# If the C compiler did not declare bool, and we did not determine that the C++
+# compiler does not declare bool, turn on an ifdef in curses.h that makes the
+# ncurses library use the same type as C++ bool.  Note that this allows one to
+# specify the type of bool in a configure-script option and postpone
+# integration with the C++ compiler provided that the types are compatible.
+USE_CXX_BOOL=1
+if test $cv_cv_cc_bool_type = 1
+then
+	# oops: C has a bool.  Unlikely, but C++ could differ.
+	USE_CXX_BOOL=0
+elif test $cf_cv_builtin_bool = 0
+then
+	# C++ has no bool
+	USE_CXX_BOOL=0
+else
+	# this is the normal case
+	USE_CXX_BOOL='!defined(__cplusplus)'
+fi
+
 if test "$cf_with_ada" != "no" ; then
 cf_ada_make=gnatmake
 # Extract the first word of "$cf_ada_make", so it can be a program name with args.
 set dummy $cf_ada_make; ac_word=$2
-echo "$as_me:10109: checking for $ac_word" >&5
+echo "$as_me:10651: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_gnat_exists+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -10121,7 +10663,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_gnat_exists="yes"
-echo "$as_me:10124: found $ac_dir/$ac_word" >&5
+echo "$as_me:10666: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -10130,10 +10672,10 @@
 fi
 gnat_exists=$ac_cv_prog_gnat_exists
 if test -n "$gnat_exists"; then
-  echo "$as_me:10133: result: $gnat_exists" >&5
+  echo "$as_me:10675: result: $gnat_exists" >&5
 echo "${ECHO_T}$gnat_exists" >&6
 else
-  echo "$as_me:10136: result: no" >&5
+  echo "$as_me:10678: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -10141,18 +10683,23 @@
    cf_ada_make=
 else
 
-cf_cv_gnat_version=`$cf_ada_make -v 2>&1 | grep '[0-9].[0-9][0-9]*' |\
-  sed -e 's/[^0-9 \.]//g' | $AWK '{print $1;}'`
-case $cf_cv_gnat_version in
+echo "$as_me:10686: checking for gnat version" >&5
+echo $ECHO_N "checking for gnat version... $ECHO_C" >&6
+cf_gnat_version=`$cf_ada_make -v 2>&1 | grep '[0-9].[0-9][0-9]*' |\
+  sed -e 's/[^0-9 \.]//g' | $AWK '{print $1;}' | head -1`
+echo "$as_me:10690: result: $cf_gnat_version" >&5
+echo "${ECHO_T}$cf_gnat_version" >&6
+
+case $cf_gnat_version in
   3.1[1-9]*|3.[2-9]*|[4-9].*)
     cf_cv_prog_gnat_correct=yes
     ;;
-  *) echo Unsupported GNAT version $cf_cv_gnat_version. Required is 3.11 or better. Disabling Ada95 binding.
+  *) echo Unsupported GNAT version $cf_gnat_version. Required is 3.11 or better. Disabling Ada95 binding.
      cf_cv_prog_gnat_correct=no
      ;;
 esac
-case $cf_cv_gnat_version in
-  3.1*|[4-9].*)
+case $cf_gnat_version in
+  3.[1-9]*|[4-9].*)
       cf_compile_generics=generics
       cf_generic_objects="\$(GENOBJS)"
       ;;
@@ -10163,7 +10710,7 @@
 
    # Extract the first word of "m4", so it can be a program name with args.
 set dummy m4; ac_word=$2
-echo "$as_me:10166: checking for $ac_word" >&5
+echo "$as_me:10713: checking for $ac_word" >&5
 echo $ECHO_N "checking for $ac_word... $ECHO_C" >&6
 if test "${ac_cv_prog_M4_exists+set}" = set; then
   echo $ECHO_N "(cached) $ECHO_C" >&6
@@ -10178,7 +10725,7 @@
   test -z "$ac_dir" && ac_dir=.
   $as_executable_p "$ac_dir/$ac_word" || continue
 ac_cv_prog_M4_exists="yes"
-echo "$as_me:10181: found $ac_dir/$ac_word" >&5
+echo "$as_me:10728: found $ac_dir/$ac_word" >&5
 break
 done
 
@@ -10187,10 +10734,10 @@
 fi
 M4_exists=$ac_cv_prog_M4_exists
 if test -n "$M4_exists"; then
-  echo "$as_me:10190: result: $M4_exists" >&5
+  echo "$as_me:10737: result: $M4_exists" >&5
 echo "${ECHO_T}$M4_exists" >&6
 else
-  echo "$as_me:10193: result: no" >&5
+  echo "$as_me:10740: result: no" >&5
 echo "${ECHO_T}no" >&6
 fi
 
@@ -10199,7 +10746,7 @@
       echo Ada95 binding required program m4 not found. Ada95 binding disabled.
    fi
    if test "$cf_cv_prog_gnat_correct" = yes; then
-      echo "$as_me:10202: checking if GNAT works" >&5
+      echo "$as_me:10749: checking if GNAT works" >&5
 echo $ECHO_N "checking if GNAT works... $ECHO_C" >&6
 
 rm -f conftest*
@@ -10227,7 +10774,7 @@
 fi
 rm -f conftest*
 
-      echo "$as_me:10230: result: $cf_cv_prog_gnat_correct" >&5
+      echo "$as_me:10777: result: $cf_cv_prog_gnat_correct" >&5
 echo "${ECHO_T}$cf_cv_prog_gnat_correct" >&6
    fi
 fi
@@ -10270,7 +10817,7 @@
   withval=`echo $withval | sed -e s%NONE%$ac_default_prefix%`
   ;;
 *)
-  { { echo "$as_me:10273: error: expected a pathname, not \"$withval\"" >&5
+  { { echo "$as_me:10820: error: expected a pathname, not \"$withval\"" >&5
 echo "$as_me: error: expected a pathname, not \"$withval\"" >&2;}
    { (exit 1); exit 1; }; }
   ;;
@@ -10304,7 +10851,7 @@
   withval=`echo $withval | sed -e s%NONE%$ac_default_prefix%`
   ;;
 *)
-  { { echo "$as_me:10307: error: expected a pathname, not \"$withval\"" >&5
+  { { echo "$as_me:10854: error: expected a pathname, not \"$withval\"" >&5
 echo "$as_me: error: expected a pathname, not \"$withval\"" >&2;}
    { (exit 1); exit 1; }; }
   ;;
@@ -10315,25 +10862,9 @@
 fi
 fi
 
-### It's not possible to appease gcc 2.6.3's conversion-warnings if we're
-### using a 'char' for bools.  gcc 2.7.0's conversion-warnings are broken too
-### badly to consider using for development purposes, but 2.5.8 is okay.
-if test -n "$with_warnings"; then
-	case $GCC_VERSION in
-	2.6.3)
-		if test "$cf_cv_type_of_bool" != "char"; then
-			EXTRA_CFLAGS="$EXTRA_CFLAGS -Wconversion"
-		fi
-		;;
-	2.5*)
-		EXTRA_CFLAGS="$EXTRA_CFLAGS -Wconversion"
-		;;
-	esac
-fi
-
 ### Construct the library-subsets, if any, from this set of keywords:
 ### none, base, ext_funcs, termlib.
-echo "$as_me:10336: checking for library subsets" >&5
+echo "$as_me:10867: checking for library subsets" >&5
 echo $ECHO_N "checking for library subsets... $ECHO_C" >&6
 if test "$with_termlib" = yes ; then
 	LIB_SUBSETS="termlib "
@@ -10343,7 +10874,7 @@
 LIB_SUBSETS="${LIB_SUBSETS}base"
 test "$with_widec" = yes && LIB_SUBSETS="${LIB_SUBSETS}+widechar"
 test "$with_ext_funcs" = yes && LIB_SUBSETS="${LIB_SUBSETS}+ext_funcs"
-echo "$as_me:10346: result: $LIB_SUBSETS" >&5
+echo "$as_me:10877: result: $LIB_SUBSETS" >&5
 echo "${ECHO_T}$LIB_SUBSETS" >&6
 
 LIB_TRACING=DEBUG
@@ -10357,9 +10888,9 @@
 
 ### Construct the list of include-directories to be generated
 
-CPPFLAGS="$CPPFLAGS -I. -I../include"
+CPPFLAGS="-I. -I../include $CPPFLAGS"
 if test "$srcdir" != "."; then
-	CPPFLAGS="$CPPFLAGS -I\$(srcdir)/../include"
+	CPPFLAGS="-I\$(srcdir)/../include $CPPFLAGS"
 fi
 if test "$GCC" != yes; then
 	CPPFLAGS="$CPPFLAGS -I\$(includedir)"
@@ -10373,9 +10904,9 @@
 	fi
 fi
 
-ACPPFLAGS="$ACPPFLAGS -I. -I../../include"
+ACPPFLAGS="-I. -I../../include $ACPPFLAGS"
 if test "$srcdir" != "."; then
-	ACPPFLAGS="$ACPPFLAGS -I\$(srcdir)/../../include"
+	ACPPFLAGS="-I\$(srcdir)/../../include $ACPPFLAGS"
 fi
 if test "$GCC" != yes; then
 	ACPPFLAGS="$ACPPFLAGS -I\$(includedir)"
@@ -10390,7 +10921,7 @@
 fi
 
 ### Build up pieces for makefile rules
-echo "$as_me:10393: checking default library suffix" >&5
+echo "$as_me:10924: checking default library suffix" >&5
 echo $ECHO_N "checking default library suffix... $ECHO_C" >&6
 
 	case $DFT_LWR_MODEL in
@@ -10401,10 +10932,10 @@
 	shared)  DFT_ARG_SUFFIX=''   ;;
 	esac
 	test -n "$LIB_SUFFIX" && DFT_ARG_SUFFIX="${LIB_SUFFIX}${DFT_ARG_SUFFIX}"
-echo "$as_me:10404: result: $DFT_ARG_SUFFIX" >&5
+echo "$as_me:10935: result: $DFT_ARG_SUFFIX" >&5
 echo "${ECHO_T}$DFT_ARG_SUFFIX" >&6
 
-echo "$as_me:10407: checking default library-dependency suffix" >&5
+echo "$as_me:10938: checking default library-dependency suffix" >&5
 echo $ECHO_N "checking default library-dependency suffix... $ECHO_C" >&6
 
 	case $DFT_LWR_MODEL in
@@ -10428,10 +10959,10 @@
 		;;
 	esac
 fi
-echo "$as_me:10431: result: $DFT_DEP_SUFFIX" >&5
+echo "$as_me:10962: result: $DFT_DEP_SUFFIX" >&5
 echo "${ECHO_T}$DFT_DEP_SUFFIX" >&6
 
-echo "$as_me:10434: checking default object directory" >&5
+echo "$as_me:10965: checking default object directory" >&5
 echo $ECHO_N "checking default object directory... $ECHO_C" >&6
 
 	case $DFT_LWR_MODEL in
@@ -10447,11 +10978,12 @@
 			DFT_OBJ_SUBDIR='obj_s' ;;
 		esac
 	esac
-echo "$as_me:10450: result: $DFT_OBJ_SUBDIR" >&5
+echo "$as_me:10981: result: $DFT_OBJ_SUBDIR" >&5
 echo "${ECHO_T}$DFT_OBJ_SUBDIR" >&6
 
 # libtool thinks it can make c++ shared libraries (perhaps only g++)
-echo "$as_me:10454: checking c++ library-dependency suffix" >&5
+if test "$cf_with_cxx" = yes ; then
+echo "$as_me:10986: checking c++ library-dependency suffix" >&5
 echo $ECHO_N "checking c++ library-dependency suffix... $ECHO_C" >&6
 if test "$with_libtool" = "yes"; then
 	CXX_LIB_SUFFIX=$DFT_DEP_SUFFIX
@@ -10472,18 +11004,22 @@
 	esac
 	test -n "$LIB_SUFFIX" && CXX_LIB_SUFFIX="${LIB_SUFFIX}${CXX_LIB_SUFFIX}"
 fi
-echo "$as_me:10475: result: $CXX_LIB_SUFFIX" >&5
+echo "$as_me:11007: result: $CXX_LIB_SUFFIX" >&5
 echo "${ECHO_T}$CXX_LIB_SUFFIX" >&6
 
+fi
+
 TINFO_LIST="$SHLIB_LIST"
-test "$with_termlib" = yes && SHLIB_LIST="$SHLIB_LIST -ltinfo${LIB_SUFFIX}"
+if test "$with_libtool" != yes ; then
+	test "$with_termlib" = yes && SHLIB_LIST="$SHLIB_LIST -ltinfo${LIB_SUFFIX}"
+fi
 
-echo "$as_me:10481: checking where we will install curses.h" >&5
+echo "$as_me:11017: checking where we will install curses.h" >&5
 echo $ECHO_N "checking where we will install curses.h... $ECHO_C" >&6
 test "$with_overwrite" = no && \
 test "x$includedir" = 'x${prefix}/include' && \
 	includedir='$(prefix)/include/ncurses'${LIB_SUFFIX}
-echo "$as_me:10486: result: $includedir" >&5
+echo "$as_me:11022: result: $includedir" >&5
 echo "${ECHO_T}$includedir" >&6
 
 ### Resolve a conflict between normal and wide-curses by forcing applications
@@ -10491,7 +11027,7 @@
 if test "$with_overwrite" != no ; then
 if test "$NCURSES_LIBUTF8" = 1 ; then
 	NCURSES_LIBUTF8='defined(HAVE_LIBUTF8_H)'
-	{ echo "$as_me:10494: WARNING: Wide-character applications must define HAVE_LIBUTF8_H to include curses.h" >&5
+	{ echo "$as_me:11030: WARNING: Wide-character applications must define HAVE_LIBUTF8_H to include curses.h" >&5
 echo "$as_me: WARNING: Wide-character applications must define HAVE_LIBUTF8_H to include curses.h" >&2;}
 fi
 fi
@@ -10509,10 +11045,15 @@
 PROG_DEPS="$TEST_DEPS"
 PROG_ARGS="$TEST_ARGS"
 
+### predefined stuff for the test programs
+cat >>confdefs.h <<\EOF
+#define HAVE_SLK_COLOR 1
+EOF
+
 ### Construct the list of subdirectories for which we'll customize makefiles
 ### with the appropriate compile-rules.
 
-echo "$as_me:10515: checking for src modules" >&5
+echo "$as_me:11056: checking for src modules" >&5
 echo $ECHO_N "checking for src modules... $ECHO_C" >&6
 
 # dependencies and linker-arguments for test-programs
@@ -10572,7 +11113,7 @@
 		fi
 	fi
 done
-echo "$as_me:10575: result: $cf_cv_src_modules" >&5
+echo "$as_me:11116: result: $cf_cv_src_modules" >&5
 echo "${ECHO_T}$cf_cv_src_modules" >&6
 TEST_ARGS="-L${LIB_DIR} $TEST_ARGS"
 
@@ -10641,10 +11182,40 @@
 EOF
 
 ### Now that we're done running tests, add the compiler-warnings, if any
-CFLAGS="$CFLAGS $EXTRA_CFLAGS"
+
+cf_new_cflags=
+cf_new_cppflags=
+for cf_add_cflags in $EXTRA_CFLAGS
+do
+	case $cf_add_cflags in #(vi
+	-undef|-nostdinc*|-I*|-D*|-U*|-E|-P|-C) #(vi
+		case "$CPPFLAGS" in
+		*$cf_add_cflags) #(vi
+			;;
+		*) #(vi
+			cf_new_cppflags="$cf_new_cppflags $cf_add_cflags"
+			;;
+		esac
+		;;
+	*)
+		cf_new_cflags="$cf_new_cflags $cf_add_cflags"
+		;;
+	esac
+done
+
+if test -n "$cf_new_cflags" ; then
+
+	CFLAGS="$CFLAGS $cf_new_cflags"
+fi
+
+if test -n "$cf_new_cppflags" ; then
+
+	CPPFLAGS="$cf_new_cppflags $CPPFLAGS"
+fi
 
 ################################################################################
-ac_config_files="$ac_config_files include/MKterm.h.awk include/curses.head:include/curses.h.in include/termcap.h include/unctrl.h misc/run_tic.sh:misc/run_tic.in $SUB_MAKEFILES Makefile"
+test "$use_database" = yes && SUB_MAKEFILES="$SUB_MAKEFILES misc/run_tic.sh:misc/run_tic.in"
+ac_config_files="$ac_config_files include/MKterm.h.awk include/curses.head:include/curses.h.in include/termcap.h include/unctrl.h $SUB_MAKEFILES Makefile"
 ac_config_commands="$ac_config_commands default"
 cat >confcache <<\_ACEOF
 # This file is a shell script that caches the results of configure
@@ -10725,7 +11296,7 @@
 : ${CONFIG_STATUS=./config.status}
 ac_clean_files_save=$ac_clean_files
 ac_clean_files="$ac_clean_files $CONFIG_STATUS"
-{ echo "$as_me:10728: creating $CONFIG_STATUS" >&5
+{ echo "$as_me:11299: creating $CONFIG_STATUS" >&5
 echo "$as_me: creating $CONFIG_STATUS" >&6;}
 cat >$CONFIG_STATUS <<_ACEOF
 #! $SHELL
@@ -10857,7 +11428,7 @@
 cat >>$CONFIG_STATUS <<EOF
 ac_cs_version="\\
 config.status
-configured by $0, generated by GNU Autoconf 2.52.20011227,
+configured by $0, generated by GNU Autoconf 2.52.20030208,
   with options \\"`echo "$ac_configure_args" | sed 's/[\\""\`\$]/\\\\&/g'`\\"
 
 Copyright 1992, 1993, 1994, 1995, 1996, 1998, 1999, 2000, 2001
@@ -10901,7 +11472,7 @@
     echo "$ac_cs_version"; exit 0 ;;
   --he | --h)
     # Conflict between --help and --header
-    { { echo "$as_me:10904: error: ambiguous option: $1
+    { { echo "$as_me:11475: error: ambiguous option: $1
 Try \`$0 --help' for more information." >&5
 echo "$as_me: error: ambiguous option: $1
 Try \`$0 --help' for more information." >&2;}
@@ -10920,7 +11491,7 @@
     ac_need_defaults=false;;
 
   # This is an error.
-  -*) { { echo "$as_me:10923: error: unrecognized option: $1
+  -*) { { echo "$as_me:11494: error: unrecognized option: $1
 Try \`$0 --help' for more information." >&5
 echo "$as_me: error: unrecognized option: $1
 Try \`$0 --help' for more information." >&2;}
@@ -10939,7 +11510,7 @@
 ## Running config.status.  ##
 ## ----------------------- ##
 
-This file was extended by $as_me 2.52.20011227, executed with
+This file was extended by $as_me 2.52.20030208, executed with
   CONFIG_FILES    = $CONFIG_FILES
   CONFIG_HEADERS  = $CONFIG_HEADERS
   CONFIG_LINKS    = $CONFIG_LINKS
@@ -10982,7 +11553,7 @@
 cf_cv_shlib_version_infix="$cf_cv_shlib_version_infix"
 cf_cv_system_name="$cf_cv_system_name"
 cf_with_cxx_binding="$cf_with_cxx_binding"
-target="$target"
+host="$host"
 
 EOF
 
@@ -10995,12 +11566,11 @@
   "include/curses.head" ) CONFIG_FILES="$CONFIG_FILES include/curses.head:include/curses.h.in" ;;
   "include/termcap.h" ) CONFIG_FILES="$CONFIG_FILES include/termcap.h" ;;
   "include/unctrl.h" ) CONFIG_FILES="$CONFIG_FILES include/unctrl.h" ;;
-  "misc/run_tic.sh" ) CONFIG_FILES="$CONFIG_FILES misc/run_tic.sh:misc/run_tic.in" ;;
   "$SUB_MAKEFILES" ) CONFIG_FILES="$CONFIG_FILES $SUB_MAKEFILES" ;;
   "Makefile" ) CONFIG_FILES="$CONFIG_FILES Makefile" ;;
   "default" ) CONFIG_COMMANDS="$CONFIG_COMMANDS default" ;;
   "include/ncurses_cfg.h" ) CONFIG_HEADERS="$CONFIG_HEADERS include/ncurses_cfg.h:include/ncurses_cfg.hin" ;;
-  *) { { echo "$as_me:11003: error: invalid argument: $ac_config_target" >&5
+  *) { { echo "$as_me:11573: error: invalid argument: $ac_config_target" >&5
 echo "$as_me: error: invalid argument: $ac_config_target" >&2;}
    { (exit 1); exit 1; }; };;
   esac
@@ -11087,7 +11657,6 @@
 s,@NCURSES_PATCH@,$NCURSES_PATCH,;t t
 s,@cf_cv_rel_version@,$cf_cv_rel_version,;t t
 s,@cf_cv_abi_version@,$cf_cv_abi_version,;t t
-s,@cf_cv_cc_bool_type@,$cf_cv_cc_bool_type,;t t
 s,@cf_cv_builtin_bool@,$cf_cv_builtin_bool,;t t
 s,@cf_cv_header_stdbool_h@,$cf_cv_header_stdbool_h,;t t
 s,@cf_cv_type_of_bool@,$cf_cv_type_of_bool,;t t
@@ -11135,18 +11704,25 @@
 s,@MAN@,$MAN,;t t
 s,@LINT_OPTS@,$LINT_OPTS,;t t
 s,@LD@,$LD,;t t
+s,@ac_ct_LD@,$ac_ct_LD,;t t
 s,@AR@,$AR,;t t
+s,@ac_ct_AR@,$ac_ct_AR,;t t
 s,@AR_OPTS@,$AR_OPTS,;t t
 s,@cf_cv_makeflags@,$cf_cv_makeflags,;t t
 s,@DESTDIR@,$DESTDIR,;t t
 s,@cf_list_models@,$cf_list_models,;t t
 s,@LIBTOOL@,$LIBTOOL,;t t
+s,@LIB_CREATE@,$LIB_CREATE,;t t
+s,@LIB_OBJECT@,$LIB_OBJECT,;t t
+s,@LIB_SUFFIX@,$LIB_SUFFIX,;t t
+s,@LIB_INSTALL@,$LIB_INSTALL,;t t
+s,@LIB_UNINSTALL@,$LIB_UNINSTALL,;t t
+s,@LIB_PREP@,$LIB_PREP,;t t
 s,@DFT_LWR_MODEL@,$DFT_LWR_MODEL,;t t
 s,@DFT_UPR_MODEL@,$DFT_UPR_MODEL,;t t
 s,@TINFO_NAME@,$TINFO_NAME,;t t
 s,@LIB_NAME@,$LIB_NAME,;t t
 s,@LIB_PREFIX@,$LIB_PREFIX,;t t
-s,@LIB_SUFFIX@,$LIB_SUFFIX,;t t
 s,@CC_G_OPT@,$CC_G_OPT,;t t
 s,@CXX_G_OPT@,$CXX_G_OPT,;t t
 s,@LD_MODEL@,$LD_MODEL,;t t
@@ -11175,7 +11751,12 @@
 s,@NCURSES_XNAMES@,$NCURSES_XNAMES,;t t
 s,@NCURSES_CH_T@,$NCURSES_CH_T,;t t
 s,@NCURSES_LIBUTF8@,$NCURSES_LIBUTF8,;t t
+s,@NEED_WCHAR_H@,$NEED_WCHAR_H,;t t
 s,@NCURSES_MBSTATE_T@,$NCURSES_MBSTATE_T,;t t
+s,@NCURSES_WCHAR_T@,$NCURSES_WCHAR_T,;t t
+s,@NCURSES_WINT_T@,$NCURSES_WINT_T,;t t
+s,@NCURSES_OK_WCHAR_T@,$NCURSES_OK_WCHAR_T,;t t
+s,@NCURSES_OK_WINT_T@,$NCURSES_OK_WINT_T,;t t
 s,@TERMINFO_CAPS@,$TERMINFO_CAPS,;t t
 s,@ECHO_LINK@,$ECHO_LINK,;t t
 s,@EXTRA_CFLAGS@,$EXTRA_CFLAGS,;t t
@@ -11188,6 +11769,7 @@
 s,@CXX_AR@,$CXX_AR,;t t
 s,@CXX_AR_OPTS@,$CXX_AR_OPTS,;t t
 s,@CXXLIBS@,$CXXLIBS,;t t
+s,@USE_CXX_BOOL@,$USE_CXX_BOOL,;t t
 s,@gnat_exists@,$gnat_exists,;t t
 s,@M4_exists@,$M4_exists,;t t
 s,@cf_ada_make@,$cf_ada_make,;t t
@@ -11326,7 +11908,7 @@
   esac
 
   if test x"$ac_file" != x-; then
-    { echo "$as_me:11329: creating $ac_file" >&5
+    { echo "$as_me:11911: creating $ac_file" >&5
 echo "$as_me: creating $ac_file" >&6;}
     rm -f "$ac_file"
   fi
@@ -11344,7 +11926,7 @@
       -) echo $tmp/stdin ;;
       [\\/$]*)
          # Absolute (can't be DOS-style, as IFS=:)
-         test -f "$f" || { { echo "$as_me:11347: error: cannot find input file: $f" >&5
+         test -f "$f" || { { echo "$as_me:11929: error: cannot find input file: $f" >&5
 echo "$as_me: error: cannot find input file: $f" >&2;}
    { (exit 1); exit 1; }; }
          echo $f;;
@@ -11357,7 +11939,7 @@
            echo $srcdir/$f
          else
            # /dev/null tree
-           { { echo "$as_me:11360: error: cannot find input file: $f" >&5
+           { { echo "$as_me:11942: error: cannot find input file: $f" >&5
 echo "$as_me: error: cannot find input file: $f" >&2;}
    { (exit 1); exit 1; }; }
          fi;;
@@ -11423,7 +12005,7 @@
   * )   ac_file_in=$ac_file.in ;;
   esac
 
-  test x"$ac_file" != x- && { echo "$as_me:11426: creating $ac_file" >&5
+  test x"$ac_file" != x- && { echo "$as_me:12008: creating $ac_file" >&5
 echo "$as_me: creating $ac_file" >&6;}
 
   # First look for the input files in the build tree, otherwise in the
@@ -11434,7 +12016,7 @@
       -) echo $tmp/stdin ;;
       [\\/$]*)
          # Absolute (can't be DOS-style, as IFS=:)
-         test -f "$f" || { { echo "$as_me:11437: error: cannot find input file: $f" >&5
+         test -f "$f" || { { echo "$as_me:12019: error: cannot find input file: $f" >&5
 echo "$as_me: error: cannot find input file: $f" >&2;}
    { (exit 1); exit 1; }; }
          echo $f;;
@@ -11447,7 +12029,7 @@
            echo $srcdir/$f
          else
            # /dev/null tree
-           { { echo "$as_me:11450: error: cannot find input file: $f" >&5
+           { { echo "$as_me:12032: error: cannot find input file: $f" >&5
 echo "$as_me: error: cannot find input file: $f" >&2;}
    { (exit 1); exit 1; }; }
          fi;;
@@ -11505,7 +12087,7 @@
   rm -f $tmp/in
   if test x"$ac_file" != x-; then
     if cmp -s $ac_file $tmp/config.h 2>/dev/null; then
-      { echo "$as_me:11508: $ac_file is unchanged" >&5
+      { echo "$as_me:12090: $ac_file is unchanged" >&5
 echo "$as_me: $ac_file is unchanged" >&6;}
     else
       ac_dir=`$as_expr X"$ac_file" : 'X\(.*[^/]\)//*[^/][^/]*/*$' \| \
@@ -11608,8 +12190,10 @@
 				esac
 			fi
 			# cygwin needs import library, and has unique naming convention
+			# use autodetected ${cf_prefix} for import lib and static lib, but
+			# use 'cyg' prefix for shared lib.
 			if test $cf_cv_shlib_version = cygdll ; then
-				SHARED_LIB="../lib/${cf_prefix}${cf_dir}\$(ABI_VERSION).dll"
+				SHARED_LIB="../lib/cyg${cf_dir}\$(ABI_VERSION).dll"
 				IMPORT_LIB="../lib/${cf_prefix}${cf_dir}.dll.a"
 				LIBS_TO_MAKE="$LIBS_TO_MAKE \$(SHARED_LIB) \$(IMPORT_LIB)"
 				continue
@@ -11624,7 +12208,7 @@
 			termlib+*) #(vi
 				;;
 			*) #(vi
-				cf_item=`echo $LIBS_TO_MAKE |sed -e s/$LIB_NAME/$TINFO_NAME/g`
+				cf_item=`echo $LIBS_TO_MAKE |sed -e s%$LIB_NAME%$TINFO_NAME%g`
 				LIBS_TO_MAKE="$cf_item $LIBS_TO_MAKE"
 				;;
 			esac
@@ -11710,7 +12294,7 @@
 				ldconfig="$LDCONFIG" \
 				overwrite=$WITH_OVERWRITE \
 				depend="$cf_depend" \
-				target="$target" \
+				host="$host" \
 				$srcdir/$cf_dir/modules >>$cf_dir/Makefile
 			for cf_subdir2 in $cf_subdirs lib
 			do
Index: configure.in
Prereq:  1.274 
--- ncurses-5.3-20021012/configure.in	Sat Sep 14 20:11:28 2002
+++ ncurses-5.3-20030719/configure.in	Sat Jul 19 17:39:47 2003
@@ -1,5 +1,5 @@
 dnl***************************************************************************
-dnl Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+dnl Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 dnl                                                                          *
 dnl Permission is hereby granted, free of charge, to any person obtaining a  *
 dnl copy of this software and associated documentation files (the            *
@@ -28,50 +28,29 @@
 dnl
 dnl Author: Thomas E. Dickey 1995-on
 dnl
-dnl $Id: configure.in,v 1.274 2002/09/15 00:11:28 tom Exp $
+dnl $Id: configure.in,v 1.294 2003/07/19 21:39:47 tom Exp $
 dnl Process this file with autoconf to produce a configure script.
 dnl
 dnl See http://invisible-island.net/autoconf/ for additional information.
 dnl
 dnl ---------------------------------------------------------------------------
 AC_PREREQ(2.13.20020210)
-AC_REVISION($Revision: 1.274 $)
+AC_REVISION($Revision: 1.294 $)
 AC_INIT(ncurses/base/lib_initscr.c)
 AC_CONFIG_HEADER(include/ncurses_cfg.h:include/ncurses_cfg.hin)
 
 CF_SUBST_NCURSES_VERSION
+AC_ARG_WITH(abi-version,
+[  --with-abi-version=XXX  override derived ABI version],
+[AC_MSG_WARN(overriding ABI version to $withval)
+ cf_cv_abi_version=$withval])
+
 CF_CHECK_CACHE([AC_CANONICAL_SYSTEM])
 AC_ARG_WITH(system-type,
 [  --with-system-type=XXX  test: override derived host system-type],
 [AC_MSG_WARN(overriding system type to $withval)
  cf_cv_system_name=$withval])
 
-# We need a configure script only when compiling as part of GNU C library.
-# Here we have to generate one of the files we need while compiling.
-#
-# The only problem is that users of the package might think they have to
-# run configure themself and find it irritating when nothing happens.
-#
-# So we try here to find out whether we are called from the glibc configure
-# or by a user.
-#
-dnl Check if we are a drop-in addition to glibc.
-AC_ARG_ENABLE(add-ons, dnl
-[  --enable-add-ons=DIR... used to check if we are a glibc add-on.],
-		[glibc_add_on=yes],
-		[glibc_add_on=])
-
-if test x"$glibc_add_on" = "xyes" ; then
-  rm -f $srcdir/Banner
-  # We are in glibc.
-  rm -f $srcdir/Makefile
-  cp $srcdir/Makefile.glibc $srcdir/Makefile
-  echo "ncurses `grep \"^[[ 	]]*ncurses-version[[ 	]]*=.*$\" \
-		$srcdir/Makefile | sed -e \
-		's/^[[ 	]]*ncurses-version[[ 	]]*=[[ 	]]*\([[^	^ ]]*\)[[ 	]]*$/\1/'`" > $srcdir/Banner
-  exit 0
-fi
-
 ###	Save the given $CFLAGS to allow user-override.
 cf_user_CFLAGS="$CFLAGS"
 
@@ -80,37 +59,32 @@
 
 ###	Checks for programs.
 AC_PROG_CC
-GCC_VERSION=none
-if test "$GCC" = yes ; then
-	AC_MSG_CHECKING(version of gcc)
-	GCC_VERSION="`${CC} --version|head -1`"
-	AC_MSG_RESULT($GCC_VERSION)
-fi
+CF_GCC_VERSION
 
 # If we're cross-compiling, allow the user to override the tools and their
-# options.  The configure script is oriented toward identifying the target
-# compiler, etc., but we need a host compiler to generate parts of the source.
-BUILD_CC='$(CC)'
-BUILD_CFLAGS='$(CFLAGS)'
-BUILD_CPPFLAGS='$(CPPFLAGS)'
-BUILD_LDFLAGS='$(LDFLAGS)'
-BUILD_LIBS='$(LIBS)'
-if test "$host_alias" != "$target_alias" ; then
+# options.  The configure script is oriented toward identifying the host
+# compiler, etc., but we need a build compiler to generate parts of the source.
+: ${BUILD_CC:='$(CC)'}
+: ${BUILD_CFLAGS:='$(CFLAGS)'}
+: ${BUILD_CPPFLAGS:='$(CPPFLAGS)'}
+: ${BUILD_LDFLAGS:='$(LDFLAGS)'}
+: ${BUILD_LIBS:='$(LIBS)'}
+if test "$cross_compiling" = yes ; then
 	AC_ARG_WITH(build-cc,
-		[  --with-build-cc=XXX     if cross-compiling, the host C compiler (\$BUILD_CC)],
+		[  --with-build-cc=XXX     if cross-compiling, the build C compiler (\$BUILD_CC)],
 		[BUILD_CC="$withval"],
 		[AC_CHECK_PROGS(BUILD_CC, $CC gcc cc)])
 	AC_ARG_WITH(build-cflags,
-		[  --with-build-cflags=XXX if cross-compiling, the host C compiler-flags],
+		[  --with-build-cflags=XXX if cross-compiling, the build C compiler-flags],
 		[BUILD_CFLAGS="$withval"])
 	AC_ARG_WITH(build-cppflags,
-		[  --with-build-cppflags=XXX if cross-compiling, the host C preprocessor-flags],
+		[  --with-build-cppflags=XXX if cross-compiling, the build C preprocessor-flags],
 		[BUILD_CPPFLAGS="$withval"])
 	AC_ARG_WITH(build-ldflags,
-		[  --with-build-ldflags=XXX if cross-compiling, the host linker-flags],
+		[  --with-build-ldflags=XXX if cross-compiling, the build linker-flags],
 		[BUILD_LDFLAGS="$withval"])
 	AC_ARG_WITH(build-libs,
-		[  --with-build-libs=XXX   if cross-compiling, the host libraries],
+		[  --with-build-libs=XXX   if cross-compiling, the build libraries],
 		[BUILD_LIBS="$withval"])
 fi
 AC_SUBST(BUILD_CC)
@@ -148,26 +122,31 @@
 	CXX=""
 	GXX=""
 else
+	# with autoconf 2.13, we can change the error to a warning:
 	pushdef([AC_MSG_ERROR],
-		[AC_MSG_RESULT([You don't have any C++ compiler, too bad]); dnl
+		[AC_MSG_RESULT(no)
+		 AC_MSG_WARN([You don't have any C++ compiler, too bad])
 		cf_with_cxx=no; CXX=""; GXX="";])dnl
 	AC_PROG_CXX
 	popdef([AC_MSG_ERROR])dnl
+	# autoconf 2.5x removed the error - by hardcoding it to g++.
+	if test "$CXX" = "g++" ; then
+		AC_PATH_PROG(CXX,g++)
+	fi
+	if test "$CXX" = "g++" ; then
+		AC_MSG_WARN(ignoring hardcoded g++)
+		cf_with_cxx=no; CXX=""; GXX="";
+	fi
 fi
 
-GXX_VERSION=none
-if test "$GXX" = yes; then
-	AC_MSG_CHECKING(version of g++)
-	GXX_VERSION="`${CXX-g++} --version|head -1`"
-	AC_MSG_RESULT($GXX_VERSION)
-	case $GXX_VERSION in
-	1*|2.[[0-6]]*)
-		GXX=""; CXX=""; ac_cv_prog_gxx=no
-		cf_cxx_library=no
-		AC_MSG_WARN(templates do not work)
-		;;
-	esac
-fi
+CF_GXX_VERSION
+case $GXX_VERSION in
+1*|2.[[0-6]]*)
+	GXX=""; CXX=""; ac_cv_prog_gxx=no
+	cf_cxx_library=no
+	AC_MSG_WARN(templates do not work)
+	;;
+esac
 
 AC_MSG_CHECKING(if you want to build C++ binding and demo)
 AC_ARG_WITH(cxx-binding,
@@ -217,8 +196,8 @@
 AC_SUBST(LINT_OPTS)
 
 dnl These are standard among *NIX systems, but not when cross-compiling
-CF_SUBST(loader,LD,ld)
-CF_SUBST(archiver,AR,ar)
+AC_CHECK_TOOL(LD, ld, ld)
+AC_CHECK_TOOL(AR, ar, ar)
 CF_SUBST(archiver options,AR_OPTS,rv)
 
 CF_MAKEFLAGS
@@ -247,19 +226,12 @@
 cf_list_models=""
 AC_SUBST(cf_list_models)dnl	the complete list of models ("normal debug")
 
-AC_MSG_CHECKING(if you want to build libraries with libtool)
-AC_ARG_WITH(libtool,
-	[  --with-libtool          generate libraries with libtool],
-	[with_libtool=$withval],
-	[with_libtool=no])
-AC_MSG_RESULT($with_libtool)
-if test "$with_libtool" = "yes"; then
-	cf_list_models="$cf_list_models libtool"
-	test -z "$LIBTOOL" && LIBTOOL=libtool
+CF_WITH_LIBTOOL
+if test "$with_libtool" = "yes" ; then
+
+cf_list_models="$cf_list_models libtool"
+
 else
-	LIBTOOL=""
-fi
-AC_SUBST(LIBTOOL)
 
 AC_MSG_CHECKING(if you want to build shared libraries)
 AC_ARG_WITH(shared,
@@ -293,6 +265,8 @@
 AC_MSG_RESULT($with_profile)
 test "$with_profile" = "yes" && cf_list_models="$cf_list_models profile"
 
+fi
+
 ###############################################################################
 
 AC_MSG_CHECKING(for specified models)
@@ -305,7 +279,7 @@
 ### Use the first model as the default, and save its suffix for use in building
 ### up test-applications.
 AC_MSG_CHECKING(for default model)
-DFT_LWR_MODEL=`echo $cf_list_models | $AWK '{print $1}'`
+DFT_LWR_MODEL=`echo "$cf_list_models" | $AWK '{print $1}'`
 AC_MSG_RESULT($DFT_LWR_MODEL)
 
 CF_UPPER(DFT_UPR_MODEL,$DFT_LWR_MODEL)dnl
@@ -337,25 +311,8 @@
 AC_MSG_RESULT($with_termlib)
 
 ### Checks for special libraries, must be done up-front.
-AC_MSG_CHECKING(if you want to link with dbmalloc for testing)
-AC_ARG_WITH(dbmalloc,
-	[  --with-dbmalloc         test: use Conor Cahill's dbmalloc library],
-	[with_dbmalloc=$withval],
-	[with_dbmalloc=no])
-AC_MSG_RESULT($with_dbmalloc)
-if test "$with_dbmalloc" = yes ; then
-	AC_CHECK_LIB(dbmalloc,debug_malloc)
-fi
-
-AC_MSG_CHECKING(if you want to link with dmalloc for testing)
-AC_ARG_WITH(dmalloc,
-	[  --with-dmalloc          test: use Gray Watson's dmalloc library],
-	[with_dmalloc=$withval],
-	[with_dmalloc=no])
-AC_MSG_RESULT($with_dmalloc)
-if test "$with_dmalloc" = yes ; then
-	AC_CHECK_LIB(dmalloc,dmalloc_debug)
-fi
+CF_WITH_DBMALLOC
+CF_WITH_DMALLOC
 
 SHLIB_LIST=""
 AC_MSG_CHECKING(if you want to link with the gpm mouse library)
@@ -373,6 +330,8 @@
 	],AC_MSG_WARN(Cannot link with gpm library - read the FAQ))
 fi
 
+CF_WITH_SYSMOUSE
+
 dnl Not all ports of gcc support the -g option
 
 if test X"$CC_G_OPT" = X"" ; then
@@ -458,7 +417,7 @@
 	[with_fallback=$withval],
 	[with_fallback=])
 AC_MSG_RESULT($with_fallback)
-FALLBACK_LIST=`echo $with_fallback|sed -e 's/,/ /g'`
+FALLBACK_LIST=`echo "$with_fallback" | sed -e 's/,/ /g'`
 AC_SUBST(FALLBACK_LIST)
 
 MAKE_TERMINFO=
@@ -522,7 +481,7 @@
 
 if test "$with_termcap" != "yes" ; then
 	if test "$use_database" = no ; then
-		if test -z $with_fallback ; then
+		if test -z "$with_fallback" ; then
 			AC_ERROR(You have disabled the database w/o specifying fallbacks)
 		fi
 	fi
@@ -604,7 +563,7 @@
 if test "$with_broken_linker" = yes ; then
 	AC_DEFINE(BROKEN_LINKER)
 	BROKEN_LINKER=1
-elif test $DFT_LWR_MODEL = shared ; then
+elif test "$DFT_LWR_MODEL" = shared ; then
 	case $cf_cv_system_name in #(vi
 	cygwin*)
 		AC_DEFINE(BROKEN_LINKER)
@@ -669,6 +628,7 @@
 	AC_DEFINE(HAVE_CURSES_VERSION)
 	AC_DEFINE(HAVE_HAS_KEY)
 	AC_DEFINE(HAVE_RESIZETERM)
+	AC_DEFINE(HAVE_RESIZE_TERM)
 	AC_DEFINE(HAVE_USE_DEFAULT_COLORS)
 	AC_DEFINE(HAVE_WRESIZE)
 	AC_DEFINE(NCURSES_EXT_FUNCS)
@@ -807,7 +767,16 @@
 ###   use option --enable-widec to turn on use of wide-character support
 NCURSES_CH_T=chtype
 NCURSES_LIBUTF8=0
+
+NEED_WCHAR_H=0
 NCURSES_MBSTATE_T=0
+NCURSES_WCHAR_T=0
+NCURSES_WINT_T=0
+
+# use these variables to work around a defect in gcc's fixincludes.
+NCURSES_OK_WCHAR_T=
+NCURSES_OK_WINT_T=
+
 AC_MSG_CHECKING(if you want experimental wide-character code)
 AC_ARG_ENABLE(widec,
 	[  --enable-widec          compile with experimental wide-char/UTF-8 code],
@@ -817,24 +786,30 @@
 if test "$with_widec" = yes ; then
 	LIB_SUFFIX="w${LIB_SUFFIX}"
 	AC_DEFINE(USE_WIDEC_SUPPORT)
-	CPPFLAGS="$CPPFLAGS -D_XOPEN_SOURCE_EXTENDED"
+	CPPFLAGS="$CPPFLAGS -D_XOPEN_SOURCE=500 -D_XOPEN_SOURCE_EXTENDED"
 	# with_overwrite=no
 	NCURSES_CH_T=cchar_t
-	AC_CHECK_FUNC(putwc)
-if test "$ac_cv_func_putwc" != yes ; then
-	CF_LIBUTF8
-	if test "$cf_cv_libutf8" = yes ; then
-		NCURSES_LIBUTF8=1
-	fi
-fi
-	CF_MBSTATE_T
-	if test $cf_cv_mbstate_t = yes ; then
-		NCURSES_MBSTATE_T=1
+	AC_CHECK_FUNCS(putwc btowc wctob mbtowc wctomb)
+	if test "$ac_cv_func_putwc" != yes ; then
+		CF_LIBUTF8
+		if test "$cf_cv_libutf8" = yes ; then
+			NCURSES_LIBUTF8=1
+		fi
 	fi
+	CF_WCHAR_TYPE(mbstate_t, NCURSES_MBSTATE_T)
+	CF_WCHAR_TYPE(wchar_t,   NCURSES_WCHAR_T,   NCURSES_OK_WCHAR_T)
+	CF_WCHAR_TYPE(wint_t,    NCURSES_WINT_T,    NCURSES_OK_WINT_T)
 fi
 AC_SUBST(NCURSES_CH_T)
 AC_SUBST(NCURSES_LIBUTF8)
+
+AC_SUBST(NEED_WCHAR_H)
 AC_SUBST(NCURSES_MBSTATE_T)
+AC_SUBST(NCURSES_WCHAR_T)
+AC_SUBST(NCURSES_WINT_T)
+
+AC_SUBST(NCURSES_OK_WCHAR_T)
+AC_SUBST(NCURSES_OK_WINT_T)
 
 AC_MSG_CHECKING(for terminal capabilities file)
 AC_ARG_WITH(caps,
@@ -1027,8 +1002,10 @@
 	CF_STRIP_G_OPT(CXXFLAGS)
 fi
 
-dnl Check for C++ compiler characteristics (and ensure that it's there!)
-CF_BOOL_DECL(cf_cv_cc_bool_type)
+# Just in case, check if the C compiler has a bool type.
+CF_BOOL_DECL(cv_cv_cc_bool_type)
+
+# Check for C++ compiler characteristics (and ensure that it's there!)
 if test -n "$CXX" ; then
 	AC_LANG_CPLUSPLUS
 	CF_STDCPP_LIBRARY
@@ -1105,6 +1082,26 @@
 fi
 AC_SUBST(CXXLIBS)
 
+# If the C compiler did not declare bool, and we did not determine that the C++
+# compiler does not declare bool, turn on an ifdef in curses.h that makes the
+# ncurses library use the same type as C++ bool.  Note that this allows one to
+# specify the type of bool in a configure-script option and postpone
+# integration with the C++ compiler provided that the types are compatible.
+USE_CXX_BOOL=1
+if test $cv_cv_cc_bool_type = 1
+then
+	# oops: C has a bool.  Unlikely, but C++ could differ.
+	USE_CXX_BOOL=0
+elif test $cf_cv_builtin_bool = 0
+then
+	# C++ has no bool
+	USE_CXX_BOOL=0
+else
+	# this is the normal case
+	USE_CXX_BOOL='!defined(__cplusplus)'
+fi
+AC_SUBST(USE_CXX_BOOL)
+
 CF_HELP_MESSAGE(Ada95 Binding Options:)
 
 dnl Check for availability of GNU Ada Translator (GNAT).
@@ -1169,22 +1166,6 @@
 fi
 fi
 
-### It's not possible to appease gcc 2.6.3's conversion-warnings if we're
-### using a 'char' for bools.  gcc 2.7.0's conversion-warnings are broken too
-### badly to consider using for development purposes, but 2.5.8 is okay.
-if test -n "$with_warnings"; then
-	case $GCC_VERSION in
-	2.6.3)
-		if test "$cf_cv_type_of_bool" != "char"; then
-			EXTRA_CFLAGS="$EXTRA_CFLAGS -Wconversion"
-		fi
-		;;
-	2.5*)
-		EXTRA_CFLAGS="$EXTRA_CFLAGS -Wconversion"
-		;;
-	esac
-fi
-
 ### Construct the library-subsets, if any, from this set of keywords:
 ### none, base, ext_funcs, termlib.
 AC_MSG_CHECKING(for library subsets)
@@ -1236,6 +1217,7 @@
 AC_MSG_RESULT($DFT_OBJ_SUBDIR)
 
 # libtool thinks it can make c++ shared libraries (perhaps only g++)
+if test "$cf_with_cxx" = yes ; then
 AC_MSG_CHECKING(c++ library-dependency suffix)
 if test "$with_libtool" = "yes"; then
 	CXX_LIB_SUFFIX=$DFT_DEP_SUFFIX
@@ -1244,9 +1226,12 @@
 fi
 AC_MSG_RESULT($CXX_LIB_SUFFIX)
 AC_SUBST(CXX_LIB_SUFFIX)
+fi
 
 TINFO_LIST="$SHLIB_LIST"
-test "$with_termlib" = yes && SHLIB_LIST="$SHLIB_LIST -ltinfo${LIB_SUFFIX}"
+if test "$with_libtool" != yes ; then
+	test "$with_termlib" = yes && SHLIB_LIST="$SHLIB_LIST -ltinfo${LIB_SUFFIX}"
+fi
 
 AC_MSG_CHECKING(where we will install curses.h)
 test "$with_overwrite" = no && \
@@ -1280,6 +1265,9 @@
 PROG_DEPS="$TEST_DEPS"
 PROG_ARGS="$TEST_ARGS"
 
+### predefined stuff for the test programs
+AC_DEFINE(HAVE_SLK_COLOR)
+
 ### Construct the list of subdirectories for which we'll customize makefiles
 ### with the appropriate compile-rules.
 
@@ -1289,15 +1277,15 @@
 AC_DEFINE_UNQUOTED(NCURSES_PATHSEP,'$PATHSEP')
 
 ### Now that we're done running tests, add the compiler-warnings, if any
-CFLAGS="$CFLAGS $EXTRA_CFLAGS"
+CF_ADD_CFLAGS($EXTRA_CFLAGS)
 
 ################################################################################
+test "$use_database" = yes && SUB_MAKEFILES="$SUB_MAKEFILES misc/run_tic.sh:misc/run_tic.in"
 AC_OUTPUT( \
 	include/MKterm.h.awk \
 	include/curses.head:include/curses.h.in \
 	include/termcap.h \
 	include/unctrl.h \
-	misc/run_tic.sh:misc/run_tic.in \
 	$SUB_MAKEFILES \
 	Makefile,[
 CF_LIB_RULES
@@ -1329,7 +1317,7 @@
 cf_cv_shlib_version_infix="$cf_cv_shlib_version_infix"
 cf_cv_system_name="$cf_cv_system_name"
 cf_with_cxx_binding="$cf_with_cxx_binding"
-target="$target"
+host="$host"
 
 ],cat)dnl
 ${MAKE-make} preinstall
Index: dist.mk
Prereq:  1.327 
--- ncurses-5.3-20021012/dist.mk	Sat Oct 12 19:27:36 2002
+++ ncurses-5.3-20030719/dist.mk	Sat Jul 19 07:37:27 2003
@@ -1,4 +1,4 @@
-# $Id: dist.mk,v 1.327 2002/10/12 23:27:36 tom Exp $
+# $Id: dist.mk,v 1.369 2003/07/19 11:37:27 tom Exp $
 # Makefile for creating ncurses distributions.
 #
 # This only needs to be used directly as a makefile by developers, but
@@ -10,7 +10,7 @@
 # These define the major/minor/patch versions of ncurses.
 NCURSES_MAJOR = 5
 NCURSES_MINOR = 3
-NCURSES_PATCH = 20021012
+NCURSES_PATCH = 20030719
 
 # We don't append the patch to the version, since this only applies to releases
 VERSION = $(NCURSES_MAJOR).$(NCURSES_MINOR)
@@ -68,7 +68,7 @@
 	@echo 's/<\/B>/<\/STRONG>/g' >> subst.tmp
 	@echo 's/<I>/<EM>/g'         >> subst.tmp
 	@echo 's/<\/I>/<\/EM>/g'     >> subst.tmp
-	@sort < subst.tmp | uniq > subst.sed
+	@misc/csort < subst.tmp | uniq > subst.sed
 	@echo '/<\/TITLE>/a\' >> subst.sed
 	@echo '<link rev=made href="mailto:bug-ncurses@gnu.org">\' >> subst.sed
 	@echo '<meta http-equiv="Content-Type" content="text\/html; charset=iso-8859-1">' >> subst.sed
@@ -97,7 +97,7 @@
 	@sed -e "\%./doc/html/man/%d" < MANIFEST > MANIFEST.tmp
 	@find ./doc/html/man -type f -print >> MANIFEST.tmp
 	@chmod u+w MANIFEST
-	@sort -u < MANIFEST.tmp > MANIFEST
+	@misc/csort -u < MANIFEST.tmp > MANIFEST
 	@rm -f MANIFEST.tmp
 
 #
@@ -110,7 +110,7 @@
 	  (cd ./Ada95/gen ; make html) ;\
 	  sed -e "\%./doc/html/ada/%d" < MANIFEST > MANIFEST.tmp ;\
 	  find ./doc/html/ada -type f -print >> MANIFEST.tmp ;\
-	  sort -u < MANIFEST.tmp > MANIFEST ;\
+	  misc/csort -u < MANIFEST.tmp > MANIFEST ;\
 	  rm -f MANIFEST.tmp ;\
 	fi
 
@@ -128,7 +128,7 @@
 MANIFEST:
 	-rm -f $@
 	touch $@
-	find . -type f -print |sort | fgrep -v .lsm |fgrep -v .spec >$@
+	find . -type f -print |misc/csort | fgrep -v .lsm |fgrep -v .spec >$@
 
 TAGS:
 	etags */*.[ch]
Index: doc/html/announce.html
Prereq:  1.41 
--- ncurses-5.3-20021012/doc/html/announce.html	Sat Oct 12 19:35:53 2002
+++ ncurses-5.3-20030719/doc/html/announce.html	Sat Oct 19 17:47:00 2002
@@ -1,11 +1,12 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 3.0//EN">
 <!--
-  $Id: announce.html,v 1.41 2002/10/12 23:35:53 tom Exp $
+  $Id: announce.html,v 1.42 2002/10/19 21:47:00 tom Exp $
 -->
 <HTML>
 <HEAD>
-<TITLE>Announcing ncurses 5.3 Pre-Release</TITLE>
+<TITLE>Announcing ncurses 5.3</TITLE>
 <link rev=made href="mailto:bug-ncurses@gnu.org">
+<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
 </HEAD>
 <BODY>
 
@@ -35,9 +36,9 @@
 
 The ncurses distribution is available via anonymous FTP at
 the GNU distribution site
-<A HREF="ftp://ftp.gnu.org/pub/gnu/ncurses">ftp://ftp.gnu.org/pub/gnu/ncurses</A>.
+<A HREF="ftp://ftp.gnu.org/gnu/ncurses/">ftp://ftp.gnu.org/gnu/ncurses/</A>&nbsp;.
 <br>It is also available at
-<A HREF="ftp://invisible-island.net/ncurses">ftp://invisible-island.net/ncurses</A>.
+<A HREF="ftp://invisible-island.net/ncurses/">ftp://invisible-island.net/ncurses/</A>&nbsp;.
 
 <H1>Release Notes</H1>
 
@@ -317,61 +318,61 @@
 <DT> cdk
 <DD> Curses Development Kit
 <br>
-<A HREF="http://invisible-island.net/cdk/cdk.html">http://invisible-island.net/cdk</A>.
+<A HREF="http://invisible-island.net/cdk/">http://invisible-island.net/cdk/</A>
 <br>
-<A HREF="http://www.vexus.ca/CDK.html">http://www.vexus.ca/CDK.html</a>
+<A HREF="http://www.vexus.ca/products/CDK/">http://www.vexus.ca/products/CDK/</a>
 <DT> ded
 <DD> directory-editor
 <br>
-<A HREF="http://invisible-island.net/ded/ded.html">http://invisible-island.net/ded</A>.
+<A HREF="http://invisible-island.net/ded/">http://invisible-island.net/ded/</A>
 <DT> dialog
 <DD> the underlying application used in Slackware's setup, and the basis
 for similar applications on GNU/Linux.
 <br>
-<A HREF="http://invisible-island.net/dialog/dialog.html">http://invisible-island.net/dialog</A>.
+<A HREF="http://invisible-island.net/dialog/">http://invisible-island.net/dialog/</A>
 <DT> lynx
 <DD> the character-screen WWW browser
 <br>
-<A HREF="http://lynx.isc.org/release/">http://lynx.isc.org/release</A>.
+<A HREF="http://lynx.isc.org/release/">http://lynx.isc.org/release/</A>
 <DT> Midnight Commander
 <DD> file manager
 <br>
-<A HREF="www.gnome.org/mc/">www.gnome.org/mc/</A>.
+<A HREF="http://www.ibiblio.org/mc/">http://www.ibiblio.org/mc/</A>
 <DT> mutt
 <DD> mail utility
 <br>
-<A HREF="http://www.mutt.org">http://www.mutt.org</A>.
+<A HREF="http://www.mutt.org/">http://www.mutt.org/</A>
 <DT> ncftp
 <DD> file-transfer utility
 <br>
-<A HREF="http://www.ncftp.com">http://www.ncftp.com</A>.
+<A HREF="http://www.ncftp.com/">http://www.ncftp.com/</A>
 <DT> nvi
 <DD> New vi versions 1.50 are able to use ncurses versions 1.9.7 and later.
 <br>
-<A HREF="http://www.bostic.com/vi/">http://www.bostic.com/vi/</A>.
+<A HREF="http://www.bostic.com/vi/">http://www.bostic.com/vi/</A>
 <DT> tin
 <DD> newsreader, supporting color, MIME
 <br>
-<A HREF="http://www.tin.org">http://www.tin.org</A>.
+<A HREF="http://www.tin.org/">http://www.tin.org/</A>
 <DT> taper
 <DD> tape archive utility
 <br>
-<A HREF="http://members.iinet.net.au/~yusuf/taper/">http://members.iinet.net.au/~yusuf/taper/</A>.
+<A HREF="http://taper.e-survey.net.au/">http://taper.e-survey.net.au/</A>
 <DT> vh-1.6
 <DD> Volks-Hypertext browser for the Jargon File
 <br>
-<A HREF="http://www.bg.debian.org/Packages/unstable/text/vh.html">http://www.bg.debian.org/Packages/unstable/text/vh.html</A>.
+<A HREF="http://www.debian.org/Packages/unstable/text/vh.html">http://www.debian.org/Packages/unstable/text/vh.html</A>
 </DL>
 as well as some that use ncurses for the terminfo support alone:
 <DL>
 <DT> minicom
 <DD> terminal emulator
 <br>
-<A HREF="http://www.pp.clinet.fi/~walker/minicom.html">http://www.pp.clinet.fi/~walker/minicom.html</A>.
+<A HREF="http://www.netsonic.fi/~walker/minicom.html">http://www.netsonic.fi/~walker/minicom.html</A>
 <DT> vile
 <DD> vi-like-emacs
 <br>
-<A HREF="http://invisible-island.net/vile/vile.html">http://invisible-island.net/vile</A>.
+<A HREF="http://invisible-island.net/vile/">http://invisible-island.net/vile/</A>
 </DL>
 <P>
 
@@ -382,7 +383,7 @@
 
 The original developers of ncurses are <A
 HREF="mailto:zmbenhal@netcom.com">Zeyd Ben-Halim</A> and
-<A HREF="http://www.ccil.org/~esr/home.html">Eric S. Raymond</A>.
+<A HREF="http://www.tuxedo.org/~esr/">Eric S. Raymond</A>.
 Ongoing work is being done by
 <A HREF="mailto:dickey@herndon4.his.com">Thomas Dickey</A>
 and
@@ -404,7 +405,7 @@
 testing of this package.<P>
 
 Beta versions of ncurses and patches to the current release are made available at
-<A HREF="ftp://invisible-island.net/ncurses">ftp://invisible-island.net/ncurses</A>.
+<A HREF="ftp://invisible-island.net/ncurses/">ftp://invisible-island.net/ncurses/</A>&nbsp;.
 
 <H2>Future Plans</H2>
 <UL>
@@ -418,12 +419,12 @@
 
 The distribution includes and uses a version of the terminfo-format
 terminal description file maintained by Eric Raymond.
-<A HREF="http://earthspace.net/~esr/terminfo">http://earthspace.net/~esr/terminfo</A>.<P>
+<A HREF="http://www.tuxedo.org/~esr/terminfo/">http://www.tuxedo.org/~esr/terminfo/</A>&nbsp;.<P>
 
 You can find lots of information on terminal-related topics
 not covered in the terminfo file at
 <A HREF="http://www.cs.utk.edu/~shuford/terminal_index.html">Richard Shuford's
-archive</A>.
+archive</A>&nbsp;.
 </BODY>
 </HTML>
 <!--
Index: doc/html/man/captoinfo.1m.html
--- ncurses-5.3-20021012/doc/html/man/captoinfo.1m.html	Sat Jun 22 17:25:15 2002
+++ ncurses-5.3-20030719/doc/html/man/captoinfo.1m.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: captoinfo.1m,v 1.16 2000/08/13 01:56:49 tom Exp @
+  * @Id: captoinfo.1m,v 1.17 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -192,7 +192,7 @@
        mode.  You can use other <EM>tic</EM> options such as <STRONG>-f</STRONG> and  <STRONG>-x</STRONG>.
 
        The  trace  option isn't identical to SVr4's.  Under SVr4,
-       instead of following the -v with  a  trace  level  n,  you
+       instead of following the <STRONG>-v</STRONG> with  a  trace  level  n,  you
        repeat it n times.
 
 
Index: doc/html/man/curs_addch.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_addch.3x.html	Sat Aug 31 17:59:20 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_addch.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_addch.3x,v 1.20 2002/08/10 22:12:36 tom Exp @
+  * @Id: curs_addch.3x,v 1.21 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -77,7 +77,7 @@
        sor one character left; at the left edge of  a  window  it
        does  nothing.   Newline  does  a <STRONG>clrtoeol</STRONG>, then moves the
        cursor to  the  window  left  margin  on  the  next  line,
-       scrolling  the window if on the last line).  Tabs are con-
+       scrolling  the  window if on the last line.  Tabs are con-
        sidered to be at every eighth column.   The  tab  interval
        may be altered by setting the <STRONG>TABSIZE</STRONG> variable.
 
@@ -91,7 +91,7 @@
        passed to <STRONG>addch</STRONG> or related functions by logical-ORing them
        into  the  character.   (Thus, text, including attributes,
        can be copied from one place to  another  using  <STRONG>inch</STRONG>  and
-       <STRONG>addch</STRONG>.).   See the <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG> page for values of prede-
+       <STRONG>addch</STRONG>.)   See  the <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG> page for values of prede-
        fined video attribute constants that can be usefully OR'ed
        into characters.
 
Index: doc/html/man/curs_beep.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_beep.3x.html	Sat Jun 22 17:25:17 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_beep.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998 Free Software Foundation, Inc.                        *
+  * Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_beep.3x,v 1.7 1998/03/11 21:12:53 juergen Exp @
+  * @Id: curs_beep.3x,v 1.8 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_deleteln.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_deleteln.3x.html	Sat Jun 22 17:25:19 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_deleteln.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_deleteln.3x,v 1.7 2000/11/11 20:43:20 Bernhard.Rosenkraenzer Exp @
+  * @Id: curs_deleteln.3x,v 1.8 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -73,7 +73,7 @@
        and  move  the remaining lines up.  The bottom <EM>n</EM> lines are
        cleared.  The current cursor position remains the same.
 
-       The <STRONG>insertln</STRONG> and <STRONG>winsertln</STRONG> routines, insert a  blank  line
+       The <STRONG>insertln</STRONG> and <STRONG>winsertln</STRONG> routines insert  a  blank  line
        above the current line and the bottom line is lost.
 
 
Index: doc/html/man/curs_extend.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_extend.3x.html	Sat Jun 22 17:25:19 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_extend.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * authorization.                                                           *
   ****************************************************************************
   * Author: Thomas E. Dickey &lt;dickey@clark.net&gt; 1999
-  * @Id: curs_extend.3x,v 1.9 2002/02/16 22:39:04 tom Exp @
+  * @Id: curs_extend.3x,v 1.11 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -70,10 +70,10 @@
        standard names which may be  compiled  into  the  terminfo
        description, i.e., via the terminfo or termcap interfaces.
        Normally these names are  available  for  use,  since  the
-       essential  descision is made by using the <STRONG>-x</STRONG> option of <EM>tic</EM>
+       essential  decision  is made by using the <STRONG>-x</STRONG> option of <EM>tic</EM>
        to compile extended terminal definitions.  However you can
        disable  this  feature  to  ensure compatiblity with other
-       implementations of curses
+       implementations of curses.
 
 
 </PRE>
Index: doc/html/man/curs_get_wch.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_get_wch.3x.html	Sat Jun 22 17:25:19 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_get_wch.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 2002 Free Software Foundation, Inc.                        *
+  * Copyright (c) 2002,2003 Free Software Foundation, Inc.                   *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_get_wch.3x,v 1.3 2002/05/18 21:48:53 tom Exp @
+  * @Id: curs_get_wch.3x,v 1.5 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -52,10 +52,10 @@
 <H2>SYNOPSIS</H2><PRE>
        <STRONG>#include</STRONG> <STRONG>&lt;curses.h&gt;</STRONG>
 
-       <STRONG>int</STRONG> <STRONG>get_wch(win_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
-       <STRONG>int</STRONG> <STRONG>wget_wch(WINDOW</STRONG> <STRONG>*</STRONG><EM>win</EM><STRONG>,</STRONG> <STRONG>win_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
-       <STRONG>int</STRONG> <STRONG>mvget_wch(int</STRONG> <EM>y</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>x</EM><STRONG>,</STRONG> <STRONG>win_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
-       <STRONG>int</STRONG> <STRONG>mvwget_wch(WINDOW</STRONG> <STRONG>*</STRONG><EM>win</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>y</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>x</EM><STRONG>,</STRONG> <STRONG>win_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
+       <STRONG>int</STRONG> <STRONG>get_wch(wint_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
+       <STRONG>int</STRONG> <STRONG>wget_wch(WINDOW</STRONG> <STRONG>*</STRONG><EM>win</EM><STRONG>,</STRONG> <STRONG>wint_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
+       <STRONG>int</STRONG> <STRONG>mvget_wch(int</STRONG> <EM>y</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>x</EM><STRONG>,</STRONG> <STRONG>wint_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
+       <STRONG>int</STRONG> <STRONG>mvwget_wch(WINDOW</STRONG> <STRONG>*</STRONG><EM>win</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>y</EM><STRONG>,</STRONG> <STRONG>int</STRONG> <EM>x</EM><STRONG>,</STRONG> <STRONG>wint_t</STRONG> <STRONG>*</STRONG><EM>wch</EM><STRONG>);</STRONG>
        <STRONG>int</STRONG> <STRONG>unget_wch(const</STRONG> <STRONG>wchar_t</STRONG> <EM>wch</EM><STRONG>);</STRONG>
 
 
Index: doc/html/man/curs_getcchar.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_getcchar.3x.html	Sat Jun 22 17:25:20 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_getcchar.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 2001,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_getcchar.3x,v 1.6 2002/03/24 01:08:55 tom Exp @
+  * @Id: curs_getcchar.3x,v 1.7 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_getch.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_getch.3x.html	Sat Jun 22 17:25:20 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_getch.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_getch.3x,v 1.21 2002/03/17 14:36:21 tom Exp @
+  * @Id: curs_getch.3x,v 1.22 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -89,7 +89,7 @@
        token for that function key is returned instead of the raw
        characters.    Possible   function  keys  are  defined  in
        <STRONG>&lt;curses.h&gt;</STRONG> as macros with  values  outside  the  range  of
-       8-bit  characters  whose  names  begin  with <STRONG>KEY_.</STRONG> Thus, a
+       8-bit  characters  whose  names  begin  with <STRONG>KEY_</STRONG>. Thus, a
        variable intended to hold the return value of  a  function
        key must be of short size or larger.
 
@@ -114,103 +114,103 @@
        that  not  all  of  these are necessarily supported on any
        particular terminal.
 
-           <EM>Name</EM>            <EM>Key</EM> <EM>name</EM>
+            <EM>Name</EM>            <EM>Key</EM> <EM>name</EM>
 
-           KEY_BREAK       Break key
-           KEY_DOWN        The four arrow keys ...
-           KEY_UP
-           KEY_LEFT
-           KEY_RIGHT
-           KEY_HOME        Home key (upward+left arrow)
-           KEY_BACKSPACE   Backspace
-           KEY_F0          Function keys; space for 64  keys
-                           is reserved.
-           KEY_F(<EM>n</EM>)        For 0 &lt;= <EM>n</EM> &lt;= 63
-           KEY_DL          Delete line
-           KEY_IL          Insert line
-           KEY_DC          Delete character
-           KEY_IC          Insert char or enter insert mode
-           KEY_EIC         Exit insert char mode
-           KEY_CLEAR       Clear screen
-           KEY_EOS         Clear to end of screen
-           KEY_EOL         Clear to end of line
-           KEY_SF          Scroll 1 line forward
-           KEY_SR          Scroll 1 line backward (reverse)
-           KEY_NPAGE       Next page
-           KEY_PPAGE       Previous page
-           KEY_STAB        Set tab
-           KEY_CTAB        Clear tab
-           KEY_CATAB       Clear all tabs
-           KEY_ENTER       Enter or send
-           KEY_SRESET      Soft (partial) reset
-           KEY_RESET       Reset or hard reset
-           KEY_PRINT       Print or copy
-           KEY_LL          Home down or bottom (lower left).
-           KEY_A1          Upper left of keypad
-           KEY_A3          Upper right of keypad
-           KEY_B2          Center of keypad
-           KEY_C1          Lower left of keypad
-           KEY_C3          Lower right of keypad
-           KEY_BTAB        Back tab key
-           KEY_BEG         Beg(inning) key
-           KEY_CANCEL      Cancel key
-
-           KEY_CLOSE       Close key
-           KEY_COMMAND     Cmd (command) key
-           KEY_COPY        Copy key
-           KEY_CREATE      Create key
-           KEY_END         End key
-           KEY_EXIT        Exit key
-           KEY_FIND        Find key
-           KEY_HELP        Help key
-           KEY_MARK        Mark key
-           KEY_MESSAGE     Message key
-           KEY_MOUSE       Mouse event read
-           KEY_MOVE        Move key
-           KEY_NEXT        Next object key
-           KEY_OPEN        Open key
-           KEY_OPTIONS     Options key
-           KEY_PREVIOUS    Previous object key
-           KEY_REDO        Redo key
-           KEY_REFERENCE   Ref(erence) key
-           KEY_REFRESH     Refresh key
-           KEY_REPLACE     Replace key
-           KEY_RESIZE      Screen resized
-           KEY_RESTART     Restart key
-           KEY_RESUME      Resume key
-           KEY_SAVE        Save key
-           KEY_SBEG        Shifted beginning key
-           KEY_SCANCEL     Shifted cancel key
-           KEY_SCOMMAND    Shifted command key
-           KEY_SCOPY       Shifted copy key
-           KEY_SCREATE     Shifted create key
-           KEY_SDC         Shifted delete char key
-           KEY_SDL         Shifted delete line key
-           KEY_SELECT      Select key
-           KEY_SEND        Shifted end key
-           KEY_SEOL        Shifted clear line key
-           KEY_SEXIT       Shifted exit key
-           KEY_SFIND       Shifted find key
-           KEY_SHELP       Shifted help key
-           KEY_SHOME       Shifted home key
-           KEY_SIC         Shifted input key
-           KEY_SLEFT       Shifted left arrow key
-           KEY_SMESSAGE    Shifted message key
-           KEY_SMOVE       Shifted move key
-           KEY_SNEXT       Shifted next key
-           KEY_SOPTIONS    Shifted options key
-           KEY_SPREVIOUS   Shifted prev key
-           KEY_SPRINT      Shifted print key
-           KEY_SREDO       Shifted redo key
-           KEY_SREPLACE    Shifted replace key
-           KEY_SRIGHT      Shifted right arrow
-           KEY_SRSUME      Shifted resume key
-           KEY_SSAVE       Shifted save key
-           KEY_SSUSPEND    Shifted suspend key
-           KEY_SUNDO       Shifted undo key
+            KEY_BREAK       Break key
+            KEY_DOWN        The four arrow keys ...
+            KEY_UP
+            KEY_LEFT
+            KEY_RIGHT
+            KEY_HOME        Home key (upward+left arrow)
+            KEY_BACKSPACE   Backspace
+            KEY_F0          Function keys; space for 64 keys
+                            is reserved.
+            KEY_F(<EM>n</EM>)        For 0 &lt;= <EM>n</EM> &lt;= 63
+            KEY_DL          Delete line
+            KEY_IL          Insert line
+            KEY_DC          Delete character
+            KEY_IC          Insert char or enter insert mode
+            KEY_EIC         Exit insert char mode
+            KEY_CLEAR       Clear screen
+            KEY_EOS         Clear to end of screen
+            KEY_EOL         Clear to end of line
+            KEY_SF          Scroll 1 line forward
+            KEY_SR          Scroll 1 line backward (reverse)
+            KEY_NPAGE       Next page
+            KEY_PPAGE       Previous page
+            KEY_STAB        Set tab
+            KEY_CTAB        Clear tab
+            KEY_CATAB       Clear all tabs
+            KEY_ENTER       Enter or send
+            KEY_SRESET      Soft (partial) reset
+            KEY_RESET       Reset or hard reset
+            KEY_PRINT       Print or copy
+            KEY_LL          Home down or bottom (lower left)
+            KEY_A1          Upper left of keypad
+            KEY_A3          Upper right of keypad
+            KEY_B2          Center of keypad
+            KEY_C1          Lower left of keypad
+            KEY_C3          Lower right of keypad
+            KEY_BTAB        Back tab key
+            KEY_BEG         Beg(inning) key
+            KEY_CANCEL      Cancel key
+
+            KEY_CLOSE       Close key
+            KEY_COMMAND     Cmd (command) key
+            KEY_COPY        Copy key
+            KEY_CREATE      Create key
+            KEY_END         End key
+            KEY_EXIT        Exit key
+            KEY_FIND        Find key
+            KEY_HELP        Help key
+            KEY_MARK        Mark key
+            KEY_MESSAGE     Message key
+            KEY_MOUSE       Mouse event read
+            KEY_MOVE        Move key
+            KEY_NEXT        Next object key
+            KEY_OPEN        Open key
+            KEY_OPTIONS     Options key
+            KEY_PREVIOUS    Previous object key
+            KEY_REDO        Redo key
+            KEY_REFERENCE   Ref(erence) key
+            KEY_REFRESH     Refresh key
+            KEY_REPLACE     Replace key
+            KEY_RESIZE      Screen resized
+            KEY_RESTART     Restart key
+            KEY_RESUME      Resume key
+            KEY_SAVE        Save key
+            KEY_SBEG        Shifted beginning key
+            KEY_SCANCEL     Shifted cancel key
+            KEY_SCOMMAND    Shifted command key
+            KEY_SCOPY       Shifted copy key
+            KEY_SCREATE     Shifted create key
+            KEY_SDC         Shifted delete char key
+            KEY_SDL         Shifted delete line key
+            KEY_SELECT      Select key
+            KEY_SEND        Shifted end key
+            KEY_SEOL        Shifted clear line key
+            KEY_SEXIT       Shifted exit key
+            KEY_SFIND       Shifted find key
+            KEY_SHELP       Shifted help key
+            KEY_SHOME       Shifted home key
+            KEY_SIC         Shifted input key
+            KEY_SLEFT       Shifted left arrow key
+            KEY_SMESSAGE    Shifted message key
+            KEY_SMOVE       Shifted move key
+            KEY_SNEXT       Shifted next key
+            KEY_SOPTIONS    Shifted options key
+            KEY_SPREVIOUS   Shifted prev key
+            KEY_SPRINT      Shifted print key
+            KEY_SREDO       Shifted redo key
+            KEY_SREPLACE    Shifted replace key
+            KEY_SRIGHT      Shifted right arrow
+            KEY_SRSUME      Shifted resume key
+            KEY_SSAVE       Shifted save key
+            KEY_SSUSPEND    Shifted suspend key
+            KEY_SUNDO       Shifted undo key
 
-           KEY_SUSPEND     Suspend key
-           KEY_UNDO        Undo key
+            KEY_SUSPEND     Suspend key
+            KEY_UNDO        Undo key
 
        Keypad is arranged like this:
 
@@ -247,7 +247,7 @@
        according  to  whether  they treat these control keys spe-
        cially (and ignore the terminfo), or use the terminfo def-
        initions.   <STRONG>Ncurses</STRONG>  uses  the terminfo definition.  If it
-       says that  KEY_ENTER  is  control/M,  <STRONG>getch</STRONG>,  will  return
+       says  that  KEY_ENTER  is  control/M,  <STRONG>getch</STRONG>  will  return
        KEY_ENTER when you press control/M.
 
        When  using  <STRONG>getch</STRONG>, <STRONG>wgetch</STRONG>, <STRONG>mvgetch</STRONG>, or <STRONG>mvwgetch</STRONG>, nocbreak
Index: doc/html/man/curs_getstr.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_getstr.3x.html	Sat Jun 22 17:37:28 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_getstr.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_getstr.3x,v 1.11 2002/04/13 22:14:30 tom Exp @
+  * @Id: curs_getstr.3x,v 1.12 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -109,7 +109,7 @@
        SVr3  and early SVr4 curses implementations did not reject
        function keys; the SVr4.0 documentation claimed that "spe-
        cial  keys"  (such  as  function keys, "home" key, "clear"
-       key, <EM>etc</EM>.) are interpreted" without  giving  details.   It
+       key, <EM>etc</EM>.) are "interpreted", without giving details.   It
        lied.   In  fact,  the  `character'  value appended to the
        string by those implementations was  predictable  but  not
        useful  (being,  in  fact, the low-order eight bits of the
Index: doc/html/man/curs_getyx.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_getyx.3x.html	Sat Oct 12 19:27:50 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_getyx.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_getyx.3x,v 1.8 2002/09/21 19:00:38 tom Exp @
+  * @Id: curs_getyx.3x,v 1.10 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -74,7 +74,7 @@
 
 </PRE>
 <H2>RETURN VALUE</H2><PRE>
-       The return values of these  macros  are  undefined  (<EM>i</EM>.<EM>e</EM>.,
+       The return values of these  macros  are  undefined  (i.e.,
        they  should not be used as the right-hand side of assign-
        ment statements).
 
Index: doc/html/man/curs_initscr.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_initscr.3x.html	Sat Jul 27 20:39:31 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_initscr.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_initscr.3x,v 1.11 2002/07/20 14:51:04 tom Exp @
+  * @Id: curs_initscr.3x,v 1.12 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_inopts.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_inopts.3x.html	Sat Aug 31 17:59:27 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_inopts.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2001 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_inopts.3x,v 1.9 2002/08/10 22:29:49 tom Exp @
+  * @Id: curs_inopts.3x,v 1.10 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -172,9 +172,9 @@
 
        The <STRONG>timeout</STRONG> and <STRONG>wtimeout</STRONG> routines  set  blocking  or  non-
        blocking  read  for a given window.  If <EM>delay</EM> is negative,
-       blocking  read  is  used  (<EM>i</EM>.<EM>e</EM>.,  waits  indefinitely  for
+       blocking  read  is  used  (i.e.,  waits  indefinitely  for
        input).   If <EM>delay</EM> is zero, then non-blocking read is used
-       (<EM>i</EM>.<EM>e</EM>., read returns <STRONG>ERR</STRONG> if no input is waiting).  If <EM>delay</EM>
+       (i.e., read returns <STRONG>ERR</STRONG> if no input is waiting).  If <EM>delay</EM>
        is  positive, then read blocks for <EM>delay</EM> milliseconds, and
        returns <STRONG>ERR</STRONG> if there is still no input.  Hence, these rou-
        tines  provide the same functionality as <STRONG>nodelay</STRONG>, plus the
Index: doc/html/man/curs_insch.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_insch.3x.html	Sat Jun 22 17:25:23 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_insch.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_insch.3x,v 1.7 2000/07/01 19:57:21 tom Exp @
+  * @Id: curs_insch.3x,v 1.8 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -59,7 +59,7 @@
 
 </PRE>
 <H2>DESCRIPTION</H2><PRE>
-       These routines, insert the character <EM>ch</EM> before the charac-
+       These routines insert the character <EM>ch</EM> before the  charac-
        ter  under the cursor.  All characters to the right of the
        cursor are moved one space to the right, with  the  possi-
        bility  of the rightmost character on the line being lost.
Index: doc/html/man/curs_mouse.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_mouse.3x.html	Sat Jul 27 20:39:34 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_mouse.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_mouse.3x,v 1.20 2002/07/20 14:52:14 tom Exp @
+  * @Id: curs_mouse.3x,v 1.22 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -213,29 +213,36 @@
        than  xterm  and  there  is  no gpm daemon running on your
        machine, mouse events will not be visible  to  <STRONG><A HREF="ncurses.3x.html">ncurses(3x)</A></STRONG>
        (and the <STRONG>wmousemask</STRONG> function will always return <STRONG>0</STRONG>).
+       If  the  terminfo entry contains a <STRONG>XM</STRONG> string, this is used
+       in the xterm mouse driver to control the way the  terminal
+       is initialized for mouse operation.  The default, if <STRONG>XM</STRONG> is
+       not found, corresponds to private mode 1000 of xterm:
+
+           \E[?1000%?%p1%{1}%=%th%el%;
+
        The z member in the event structure is not presently used.
-       It is intended for use with touch screens  (which  may  be
+       It  is  intended  for use with touch screens (which may be
        pressure-sensitive)   or   with   3D-mice/trackballs/power
        gloves.
 
 
 </PRE>
 <H2>BUGS</H2><PRE>
-       Mouse events under xterm will not in fact be ignored  dur-
-       ing  cooked mode, if they have been enabled by <STRONG>wmousemask</STRONG>.
-       Instead, the xterm mouse report sequence  will  appear  in
+       Mouse  events under xterm will not in fact be ignored dur-
+       ing cooked mode, if they have been enabled by  <STRONG>wmousemask</STRONG>.
+       Instead,  the  xterm  mouse report sequence will appear in
        the string read.
 
        Mouse events under xterm will not be detected correctly in
-       a window with its keypad bit off, since  they  are  inter-
-       preted  as  a  variety  of  function  key.   Your terminfo
-       description must have <STRONG>kmous</STRONG> set to "\E[M"  (the  beginning
+       a  window  with  its keypad bit off, since they are inter-
+       preted as  a  variety  of  function  key.   Your  terminfo
+       description  must  have <STRONG>kmous</STRONG> set to "\E[M" (the beginning
        of the response from xterm for mouse clicks).
 
-       Because  there  are  no  standard  terminal responses that
-       would serve to identify terminals which support the  xterm
-       mouse  protocol,  <STRONG>ncurses</STRONG> assumes that if your $TERM envi-
-       ronment variable contains "xterm", or <STRONG>kmous</STRONG> is defined  in
+       Because there are  no  standard  terminal  responses  that
+       would  serve to identify terminals which support the xterm
+       mouse protocol, <STRONG>ncurses</STRONG> assumes that if your  $TERM  envi-
+       ronment  variable contains "xterm", or <STRONG>kmous</STRONG> is defined in
        the terminal description, then the terminal may send mouse
        events.
 
@@ -243,13 +250,6 @@
 </PRE>
 <H2>SEE ALSO</H2><PRE>
        <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>.
-
-
-
-
-
-
-
 
 
 
Index: doc/html/man/curs_outopts.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_outopts.3x.html	Sat Jun 22 17:25:25 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_outopts.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2001 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_outopts.3x,v 1.17 2001/10/14 00:50:30 tom Exp @
+  * @Id: curs_outopts.3x,v 1.18 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -100,7 +100,7 @@
 
        If  <STRONG>immedok</STRONG> is called with <STRONG>TRUE</STRONG> <STRONG>as</STRONG> <STRONG>argument</STRONG>, any change in
        the window image, such  as  the  ones  caused  by  <STRONG>waddch,</STRONG>
-       <STRONG>wclrtobot,</STRONG> <STRONG>wscrl</STRONG>, <EM>etc</EM>., automatically cause a call to <STRONG>wre-</STRONG>
+       <STRONG>wclrtobot,</STRONG> <STRONG>wscrl</STRONG>, etc., automatically cause a call to <STRONG>wre-</STRONG>
        <STRONG>fresh</STRONG>.  However, it may degrade performance  considerably,
        due  to  repeated  calls  to  <STRONG>wrefresh</STRONG>.  It is disabled by
        default.
Index: doc/html/man/curs_pad.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_pad.3x.html	Sat Jun 22 17:25:25 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_pad.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_pad.3x,v 1.9 2000/07/04 22:38:13 tom Exp @
+  * @Id: curs_pad.3x,v 1.10 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -70,7 +70,7 @@
        sarily associated with a particular part  of  the  screen.
        Pads can be used when a large window is needed, and only a
        part of the window will be on  the  screen  at  one  time.
-       Automatic refreshes of pads (<EM>e</EM>.<EM>g</EM>., from scrolling or echo-
+       Automatic refreshes of pads (e.g., from scrolling or echo-
        ing of input) do not occur.  It is not legal to call  <STRONG>wre-</STRONG>
        <STRONG>fresh</STRONG>  with a <EM>pad</EM> as an argument; the routines <STRONG>prefresh</STRONG> or
        <STRONG>pnoutrefresh</STRONG> should be called instead.   Note  that  these
@@ -106,7 +106,7 @@
        The <STRONG>pechochar</STRONG> routine is functionally equivalent to a call
        to  <STRONG>addch</STRONG>  followed by a call to <STRONG>refresh</STRONG>, a call to <STRONG>waddch</STRONG>
        followed by a call to <STRONG>wrefresh</STRONG>, or a call to  <STRONG>waddch</STRONG>  fol-
-       lowed  by  a  call  to <STRONG>prefresh.</STRONG> The knowledge that only a
+       lowed  by  a  call  to <STRONG>prefresh</STRONG>. The knowledge that only a
        single character is being output is taken into  considera-
        tion  and, for non-control characters, a considerable per-
        formance gain  might  be  seen  by  using  these  routines
Index: doc/html/man/curs_print.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_print.3x.html	Sat Jun 22 17:25:26 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_print.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_print.3x,v 1.5 2002/02/16 22:39:04 tom Exp @
+  * @Id: curs_print.3x,v 1.6 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_printw.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_printw.3x.html	Sat Jul 27 20:39:35 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_printw.3x.html	Sat Jan 11 21:02:48 2003
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_printw.3x,v 1.12 2002/07/20 15:01:43 tom Exp @
+  * @Id: curs_printw.3x,v 1.13 2002/11/16 22:28:57 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -51,54 +51,54 @@
 <H2>SYNOPSIS</H2><PRE>
        <STRONG>#include</STRONG> <STRONG>&lt;curses.h&gt;</STRONG>
 
-       <STRONG>int</STRONG> <STRONG>printw(char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
-       <STRONG>int</STRONG> <STRONG>wprintw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
-       <STRONG>int</STRONG> <STRONG>mvprintw(int</STRONG> <STRONG>y,</STRONG> <STRONG>int</STRONG> <STRONG>x,</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
-       <STRONG>int</STRONG> <STRONG>mvwprintw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>int</STRONG> <STRONG>y,</STRONG> <STRONG>int</STRONG> <STRONG>x,</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
-       <STRONG>int</STRONG> <STRONG>vwprintw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>va_list</STRONG> <STRONG>varglist);</STRONG>
-       <STRONG>int</STRONG> <STRONG>vw_printw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>va_list</STRONG> <STRONG>varglist);</STRONG>
+       <STRONG>int</STRONG> <STRONG>printw(const</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
+       <STRONG>int</STRONG> <STRONG>wprintw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>const</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
+       <STRONG>int</STRONG> <STRONG>mvprintw(int</STRONG> <STRONG>y,</STRONG> <STRONG>int</STRONG> <STRONG>x,</STRONG> <STRONG>const</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>...);</STRONG>
+       <STRONG>int</STRONG> <STRONG>mvwprintw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>int</STRONG> <STRONG>y,</STRONG> <STRONG>int</STRONG> <STRONG>x,</STRONG> <STRONG>const</STRONG> <STRONG>char</STRONG>  <STRONG>*fmt,</STRONG>
+       <STRONG>...);</STRONG>
+       <STRONG>int</STRONG>  <STRONG>vwprintw(WINDOW</STRONG>  <STRONG>*win,</STRONG>  <STRONG>const</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG> <STRONG>va_list</STRONG> <STRONG>var-</STRONG>
+       <STRONG>glist);</STRONG>
+       <STRONG>int</STRONG> <STRONG>vw_printw(WINDOW</STRONG> <STRONG>*win,</STRONG> <STRONG>const</STRONG> <STRONG>char</STRONG> <STRONG>*fmt,</STRONG>  <STRONG>va_list</STRONG>  <STRONG>var-</STRONG>
+       <STRONG>glist);</STRONG>
 
 
 </PRE>
 <H2>DESCRIPTION</H2><PRE>
-       The <STRONG>printw</STRONG>, <STRONG>wprintw</STRONG>, <STRONG>mvprintw</STRONG> and <STRONG>mvwprintw</STRONG>  routines  are
-       analogous  to  <STRONG>printf</STRONG>  [see  <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>].   In effect, the
+       The  <STRONG>printw</STRONG>,  <STRONG>wprintw</STRONG>, <STRONG>mvprintw</STRONG> and <STRONG>mvwprintw</STRONG> routines are
+       analogous to <STRONG>printf</STRONG>  [see  <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>].   In  effect,  the
        string that would be output by <STRONG>printf</STRONG> is output instead as
        though <STRONG>waddstr</STRONG> were used on the given window.
 
-       The  <STRONG>vwprintw</STRONG>  and  <STRONG>wv_printw</STRONG>  routines  are  analogous to
-       <STRONG>vprintf</STRONG> [see <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>] and perform  a  <STRONG>wprintw</STRONG>  using  a
-       variable  argument list.  The third argument is a <STRONG>va_list</STRONG>,
-       a  pointer  to  a  list  of  arguments,  as   defined   in
+       The <STRONG>vwprintw</STRONG>  and  <STRONG>wv_printw</STRONG>  routines  are  analogous  to
+       <STRONG>vprintf</STRONG>  [see  <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>]  and  perform a <STRONG>wprintw</STRONG> using a
+       variable argument list.  The third argument is a  <STRONG>va_list</STRONG>,
+       a   pointer   to  a  list  of  arguments,  as  defined  in
        <STRONG>&lt;stdarg.h&gt;</STRONG>.
 
 
 </PRE>
 <H2>RETURN VALUE</H2><PRE>
-       Routines  that  return  an integer return <STRONG>ERR</STRONG> upon failure
-       and <STRONG>OK</STRONG> (SVr4 only specifies "an integer value  other  than
+       Routines that return an integer return  <STRONG>ERR</STRONG>  upon  failure
+       and  <STRONG>OK</STRONG>  (SVr4 only specifies "an integer value other than
        <STRONG>ERR</STRONG>") upon successful completion.
 
 
 </PRE>
 <H2>PORTABILITY</H2><PRE>
-       The  XSI  Curses  standard,  Issue 4 describes these func-
-       tions.  The function <STRONG>vwprintw</STRONG> is marked TO  BE  WITHDRAWN,
-       and  is  to  be replaced by a function <STRONG>vw_printw</STRONG> using the
+       The XSI Curses standard, Issue  4  describes  these  func-
+       tions.   The  function <STRONG>vwprintw</STRONG> is marked TO BE WITHDRAWN,
+       and is to be replaced by a function  <STRONG>vw_printw</STRONG>  using  the
        <STRONG>&lt;stdarg.h&gt;</STRONG> interface.  The Single Unix Specification, Ver-
-       sion  2  states  that  <STRONG>vw_printw</STRONG>  is preferred to <STRONG>vwprintw</STRONG>
-       since the latter  requires  including  <STRONG>&lt;varargs.h&gt;</STRONG>,  which
-       cannot  be  used  in  the  same  file as <STRONG>&lt;stdarg.h&gt;</STRONG>.  This
-       implementation uses  <STRONG>&lt;stdarg.h&gt;</STRONG>  for  both,  because  that
+       sion 2 states that <STRONG>vw_printw</STRONG>   is  preferred  to  <STRONG>vwprintw</STRONG>
+       since  the  latter  requires  including <STRONG>&lt;varargs.h&gt;</STRONG>, which
+       cannot be used in  the  same  file  as  <STRONG>&lt;stdarg.h&gt;</STRONG>.   This
+       implementation  uses  <STRONG>&lt;stdarg.h&gt;</STRONG>  for  both,  because that
        header is included in <STRONG>&lt;curses.h</STRONG>&gt;.
 
 
 </PRE>
 <H2>SEE ALSO</H2><PRE>
        <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>, <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>, <STRONG>vprintf(3S)</STRONG>
-
-
-
 
 
 
Index: doc/html/man/curs_scroll.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_scroll.3x.html	Sat Jun 22 17:25:27 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_scroll.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_scroll.3x,v 1.9 2001/10/14 00:51:56 tom Exp @
+  * @Id: curs_scroll.3x,v 1.10 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_slk.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_slk.3x.html	Sat Jun 22 17:25:27 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_slk.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_slk.3x,v 1.11 2001/03/03 21:05:41 Todd.C.Miller Exp @
+  * @Id: curs_slk.3x,v 1.12 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -115,7 +115,7 @@
        The  <STRONG>slk_clear</STRONG>  routine  clears  the  soft labels from the
        screen.
 
-       The <STRONG>slk_restore</STRONG> routine, restores the soft labels  to  the
+       The <STRONG>slk_restore</STRONG> routine restores the soft  labels  to  the
        screen after a <STRONG>slk_clear</STRONG> has been performed.
 
        The  <STRONG>slk_touch</STRONG>  routine  forces  all the soft labels to be
Index: doc/html/man/curs_termcap.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_termcap.3x.html	Sat Jun 22 17:25:28 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_termcap.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_termcap.3x,v 1.16 2002/02/16 19:26:41 tom Exp @
+  * @Id: curs_termcap.3x,v 1.18 2003/02/08 22:25:47 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -136,32 +136,86 @@
        will put out a literal "50" rather than  busy-waiting  for
        50 milliseconds.  Cope with it.
 
+       Note  that termcap has nothing analogous to terminfo's <STRONG>sgr</STRONG>
+       string.  One consequence of this is that termcap  applica-
+       tions  assume me (terminfo <STRONG>sgr0</STRONG>) does not reset the alter-
+       nate character set.  This implementation checks  for,  and
+       modifies the data shown to the termcap interface to accom-
+       modate termcap's limitation in this respect.
+
 
 </PRE>
 <H2>PORTABILITY</H2><PRE>
-       The  XSI  Curses  standard,  Issue 4 describes these func-
-       tions.  However, they are marked TO BE WITHDRAWN  and  may
+       The XSI Curses standard, Issue  4  describes  these  func-
+       tions.   However,  they are marked TO BE WITHDRAWN and may
        be removed in future versions.
 
-       Neither  the  XSI  Curses  standard nor the SVr4 man pages
-       documented the return values of <STRONG>tgetent</STRONG> correctly,  though
-       all  three were in fact returned ever since SVr1.  In par-
-       ticular, an omission in the XSI Curses  documentation  has
-       been  misinterpreted  to  mean  that <STRONG>tgetent</STRONG> returns <STRONG>OK</STRONG> or
+       Neither the XSI Curses standard nor  the  SVr4  man  pages
+       documented  the return values of <STRONG>tgetent</STRONG> correctly, though
+       all three were in fact returned ever since SVr1.  In  par-
+       ticular,  an  omission in the XSI Curses documentation has
+       been misinterpreted to mean that  <STRONG>tgetent</STRONG>  returns  <STRONG>OK</STRONG>  or
        <STRONG>ERR</STRONG>.  Because the purpose of these functions is to provide
-       compatibility  with  the <EM>termcap</EM> library, that is a defect
+       compatibility with the <EM>termcap</EM> library, that is  a  defect
        in XCurses, Issue 4, Version 2 rather than in ncurses.
 
-       External variables are provided  for  support  of  certain
-       termcap  applications.  However, termcap applications' use
+       External  variables  are  provided  for support of certain
+       termcap applications.  However, termcap applications'  use
        of those variables is poorly documented, e.g., not distin-
-       guishing  between  input  and output.  In particular, some
+       guishing between input and output.   In  particular,  some
        applications are reported to declare and/or modify <STRONG>ospeed</STRONG>.
 
 
 </PRE>
 <H2>SEE ALSO</H2><PRE>
        <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>, <STRONG><A HREF="terminfo.5.html">terminfo(5)</A></STRONG>, <STRONG><A HREF="putc.3S.html">putc(3S)</A></STRONG>.
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
 </PRE>
 <HR>
 <ADDRESS>
Index: doc/html/man/curs_terminfo.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_terminfo.3x.html	Sat Jul 27 20:39:37 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_terminfo.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_terminfo.3x,v 1.16 2002/07/20 16:05:19 tom Exp @
+  * @Id: curs_terminfo.3x,v 1.17 2003/05/10 20:22:01 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/curs_util.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_util.3x.html	Sat Oct 12 19:27:58 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_util.3x.html	Sat Jan 11 21:02:51 2003
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_util.3x,v 1.9 2002/09/01 19:44:37 tom Exp @
+  * @Id: curs_util.3x,v 1.10 2002/12/21 22:21:37 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -110,17 +110,18 @@
        The <STRONG>delay_output</STRONG> routine inserts an <EM>ms</EM>  millisecond  pause
        in  output.   This  routine should not be used extensively
        because padding characters are  used  rather  than  a  CPU
-       pause.
+       pause.   If  no  padding character is specified, this uses
+       <STRONG>napms</STRONG> to perform the delay.
 
-       The  <STRONG>flushinp</STRONG>  routine  throws away any typeahead that has
-       been typed by the user and has not yet been  read  by  the
+       The <STRONG>flushinp</STRONG> routine throws away any  typeahead  that  has
+       been  typed  by  the user and has not yet been read by the
        program.
 
 
 </PRE>
 <H2>RETURN VALUE</H2><PRE>
-       Except  for  <STRONG>flushinp</STRONG>,  routines  that  return  an integer
-       return <STRONG>ERR</STRONG> upon failure and <STRONG>OK</STRONG> (SVr4  specifies  only  "an
+       Except for  <STRONG>flushinp</STRONG>,  routines  that  return  an  integer
+       return  <STRONG>ERR</STRONG>  upon  failure and <STRONG>OK</STRONG> (SVr4 specifies only "an
        integer value other than <STRONG>ERR</STRONG>") upon successful completion.
 
        <STRONG>flushinp</STRONG> always returns <STRONG>OK</STRONG>.
@@ -130,22 +131,21 @@
 
 </PRE>
 <H2>PORTABILITY</H2><PRE>
-       The XSI Curses standard, Issue  4  describes  these  func-
-       tions.   It  states  that <STRONG>unctrl</STRONG> and <STRONG>wunctrl</STRONG> will return a
-       null pointer if unsuccessful,  but  does  not  define  any
+       The  XSI  Curses  standard,  Issue 4 describes these func-
+       tions.  It states that <STRONG>unctrl</STRONG> and <STRONG>wunctrl</STRONG>  will  return  a
+       null  pointer  if  unsuccessful,  but  does not define any
        error conditions.
 
        The SVr4 documentation describes the action of <STRONG>filter</STRONG> only
-       in the vaguest terms.  The  description  here  is  adapted
-       from  the  XSI Curses standard (which erroneously fails to
+       in  the  vaguest  terms.   The description here is adapted
+       from the XSI Curses standard (which erroneously  fails  to
        describe the disabling of <STRONG>cuu</STRONG>).
 
 
 </PRE>
 <H2>SEE ALSO</H2><PRE>
-       <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>, <STRONG><A HREF="curs_initscr.3x.html">curs_initscr(3x)</A></STRONG>, <STRONG><A HREF="curs_scr_dump.3x.html">curs_scr_dump(3x)</A></STRONG>.
-
-
+       <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>,       <STRONG><A HREF="curs_initscr.3x.html">curs_initscr(3x)</A></STRONG>,       <STRONG><A HREF="curs_kernel.3x.html">curs_kernel(3x)</A></STRONG>,
+       <STRONG><A HREF="curs_scr_dump.3x.html">curs_scr_dump(3x)</A></STRONG>.
 
 
 
Index: doc/html/man/curs_window.3x.html
--- ncurses-5.3-20021012/doc/html/man/curs_window.3x.html	Sat Jun 22 17:25:29 2002
+++ ncurses-5.3-20030719/doc/html/man/curs_window.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: curs_window.3x,v 1.9 2000/07/01 20:08:37 tom Exp @
+  * @Id: curs_window.3x,v 1.10 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/define_key.3x.html
--- ncurses-5.3-20021012/doc/html/man/define_key.3x.html	Sat Jun 22 17:25:29 2002
+++ ncurses-5.3-20030719/doc/html/man/define_key.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * authorization.                                                           *
   ****************************************************************************
   * Author: Thomas E. Dickey &lt;dickey@clark.net&gt; 1997
-  * @Id: define_key.3x,v 1.8 2002/02/16 22:39:52 tom Exp @
+  * @Id: define_key.3x,v 1.9 2003/05/17 23:25:11 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -51,7 +51,7 @@
 <H2>SYNOPSIS</H2><PRE>
        <STRONG>#include</STRONG> <STRONG>&lt;curses.h&gt;</STRONG>
 
-       <STRONG>int</STRONG> <STRONG>define_key(char</STRONG> <STRONG>*definition,</STRONG> <STRONG>int</STRONG> <STRONG>keycode);</STRONG>
+       <STRONG>int</STRONG> <STRONG>define_key(const</STRONG> <STRONG>char</STRONG> <STRONG>*definition,</STRONG> <STRONG>int</STRONG> <STRONG>keycode);</STRONG>
 
 
 </PRE>
Index: doc/html/man/form_field.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field.3x.html	Sat Jun 22 17:25:31 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998 Free Software Foundation, Inc.                        *
+  * Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field.3x,v 1.5 1998/11/29 01:05:52 Rick.Ohnemus Exp @
+  * @Id: form_field.3x,v 1.6 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -69,7 +69,7 @@
        The  function  <STRONG>field_count</STRONG>  returns the count of fields in
        <EM>form</EM>.
 
-       The function <STRONG>move_field</STRONG> move the given field  (which  must
+       The function <STRONG>move_field</STRONG> moves the given field (which  must
        be disconnected) to a specified location on the screen.
 
 
Index: doc/html/man/form_field_buffer.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field_buffer.3x.html	Sat Jun 22 17:25:31 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field_buffer.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field_buffer.3x,v 1.9 2002/01/19 22:48:23 tom Exp @
+  * @Id: form_field_buffer.3x,v 1.10 2003/05/10 20:22:01 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/form_field_just.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field_just.3x.html	Sat Jun 22 17:25:32 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field_just.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field_just.3x,v 1.6 2002/01/19 22:48:41 tom Exp @
+  * @Id: form_field_just.3x,v 1.7 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -68,7 +68,7 @@
        The  function <STRONG>field_just</STRONG> returns one of: NO_JUSTIFICATION,
        JUSTIFY_RIGHT, JUSTIFY_LEFT, or JUSTIFY_CENTER.
 
-       The function <STRONG>set_field_just</STRONG> return one of the following:
+       The function <STRONG>set_field_just</STRONG> returns one of the following:
 
        <STRONG>E_OK</STRONG> The routine succeeded.
 
Index: doc/html/man/form_field_new.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field_new.3x.html	Sat Jun 22 17:25:32 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field_new.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field_new.3x,v 1.11 2002/02/16 22:39:52 tom Exp @
+  * @Id: form_field_new.3x,v 1.12 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -115,8 +115,8 @@
 
        It  may be unwise to count on the set of attributes copied
        by  <STRONG><A HREF="dup_field.3x.html">dup_field(3x)</A></STRONG>  being  portable;  the  System  V  forms
-       library  documents  are  not  very  explicit  on what gets
-       copied and was not.
+       library  documents  are  not very explicit about what gets
+       copied and what doesn't.
 
 
 </PRE>
Index: doc/html/man/form_field_opts.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field_opts.3x.html	Sat Jun 22 17:25:32 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field_opts.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998 Free Software Foundation, Inc.                        *
+  * Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field_opts.3x,v 1.7 1998/11/29 01:06:54 Rick.Ohnemus Exp @
+  * @Id: form_field_opts.3x,v 1.8 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -75,7 +75,7 @@
 
        O_VISIBLE
             The  field is displayed.  If this option is off, dis-
-            play of the field is suppressed,
+            play of the field is suppressed.
 
        O_ACTIVE
             The field is  visited  during  processing.   If  this
@@ -98,7 +98,7 @@
             at the first position.
 
        O_AUTOSKIP
-            Skip to the next field when this one fills
+            Skip to the next field when this one fills.
 
 
        O_NULLOK
Index: doc/html/man/form_field_validation.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_field_validation.3x.html	Sat Jun 22 17:25:33 2002
+++ ncurses-5.3-20030719/doc/html/man/form_field_validation.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_field_validation.3x,v 1.12 2002/02/16 22:39:52 tom Exp @
+  * @Id: form_field_validation.3x,v 1.14 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -53,12 +53,20 @@
        FIELDTYPE *field_type(const FIELD *field);
        void *field_arg(const FIELD *field);
 
+       FIELDTYPE *TYPE_ALNUM;
+       FIELDTYPE *TYPE_ALPHA;
+       FIELDTYPE *TYPE_ENUM;
+       FIELDTYPE *TYPE_INTEGER;
+       FIELDTYPE *TYPE_NUMERIC;
+       FIELDTYPE *TYPE_REGEXP;
+       FIELDTYPE *TYPE_IPV4;
+
 
 </PRE>
 <H2>DESCRIPTION</H2><PRE>
        The  function  <STRONG>set_field_type</STRONG>  declares  a data type for a
        given form field.  This is the type checked by  validation
-       functions.  The types are as follows:
+       functions.  The predefined types are as follows:
 
        TYPE_ALNUM
             Alphanumeric  data.  Requires a third <STRONG>int</STRONG> argument, a
@@ -78,7 +86,7 @@
             than  one  list  elements  with  that prefix). Please
             notice that the string list is  not  copied,  only  a
             reference to it is stored in the field. So you should
-            avoid to use a list that lives in automatic variables
+            avoid using a list that lives in automatic  variables
             on the stack.
 
        TYPE_INTEGER
@@ -86,9 +94,9 @@
             Requires a third <STRONG>int</STRONG> argument controlling the  preci-
             sion,  a  fourth  <STRONG>long</STRONG>  argument constraining minimum
             value, and a fifth <STRONG>long</STRONG> constraining  maximum  value.
-            If  the  maximum  value  is less or equal the minimum
-            value, the range is simply  ignored.  On  return  the
-            field  buffer  is  formatted  according to the <STRONG>printf</STRONG>
+            If  the  maximum  value  is less than or equal to the
+            minimum value, the range is simply ignored. On return
+            the field buffer is formatted according to the <STRONG>printf</STRONG>
             format  specification  ".*ld",  where  the   '*'   is
             replaced  by  the precision argument.  For details of
             the precision handling see <STRONG>printf's</STRONG> man-page.
@@ -98,47 +106,48 @@
             Requires  a third <STRONG>int</STRONG> argument controlling the preci-
             sion, a fourth <STRONG>double</STRONG> argument  constraining  minimum
             value, and a fifth <STRONG>double</STRONG> constraining maximum value.
-            If your system supports locale's, the  decimal  point
+            If your system supports locales,  the  decimal  point
             character  to  be  used  must be the one specified by
-            your locale.  If the maximum value is less  or  equal
-            the  minimum  value,  the range is simply ignored. On
-            return the field buffer is formatted according to the
-            <STRONG>printf</STRONG>  format  specification ".*f", where the '*' is
-            replaced by the precision argument.  For  details  of
-            the precision handling see <STRONG>printf's</STRONG> man-page.
+            your locale.  If the maximum value is  less  than  or
+            equal  to  the  minimum  value,  the  range is simply
+            ignored. On return  the  field  buffer  is  formatted
+            according  to  the <STRONG>printf</STRONG> format specification ".*f",
+            where the '*' is replaced by the precision  argument.
+            For  details  of  the precision handling see <STRONG>printf's</STRONG>
+            man-page.
 
        TYPE_REGEXP
-            Regular  expression data.  Requires a regular expres-
-            sion <STRONG>(char</STRONG> <STRONG>*)</STRONG> third argument; the data  is  valid  if
-            the  regular  expression matches it.  Regular expres-
-            sions  are  in  the   format   of   <STRONG><A HREF="regcomp.3x.html">regcomp(3x)</A></STRONG>   and
-            <STRONG><A HREF="regexec.3x.html">regexec(3x)</A></STRONG>.  Please  notice that the regular expres-
-            sion must match the whole  field.  If  you  have  for
-            example  an  eight  character  wide  field, a regular
-            expression "^[0-9]*$" always means that you  have  to
-            fill  all eight positions with digits. If you want to
-            allow fewer digits, you may use for example  "^[0-9]*
+            Regular expression data.  Requires a regular  expres-
+            sion  <STRONG>(char</STRONG>  <STRONG>*)</STRONG>  third argument; the data is valid if
+            the regular expression matches it.   Regular  expres-
+            sions   are   in   the   format  of  <STRONG><A HREF="regcomp.3x.html">regcomp(3x)</A></STRONG>  and
+            <STRONG><A HREF="regexec.3x.html">regexec(3x)</A></STRONG>. Please notice that the  regular  expres-
+            sion  must  match  the  whole  field. If you have for
+            example an eight  character  wide  field,  a  regular
+            expression  "^[0-9]*$"  always means that you have to
+            fill all eight positions with digits. If you want  to
+            allow  fewer digits, you may use for example "^[0-9]*
             *$" which is good for trailing spaces (up to an empty
-            field), or "^ *[0-9]* *$" which is good  for  leading
+            field),  or  "^ *[0-9]* *$" which is good for leading
             and trailing spaces around the digits.
 
        TYPE_IPV4
             An Internet Protocol Version 4 address. This requires
-            no additional argument. It is checked whether or  not
-            the  buffer  has  the form a.b.c.d, where a,b,c and d
+            no  additional argument. It is checked whether or not
+            the buffer has the form a.b.c.d, where  a,b,c  and  d
             are numbers between 0 and 255. Trailing blanks in the
-            buffer  are  ignored. The address itself is not vali-
+            buffer are ignored. The address itself is  not  vali-
             dated. Please note that this is an ncurses extension.
-            This  field type may not be available in other curses
+            This field type may not be available in other  curses
             implementations.
 
-            It is possible to set up new programmer-defined field
-            types.  See the <STRONG><A HREF="form_fieldtype.3x.html">form_fieldtype(3x)</A></STRONG> manual page.
+       It  is  possible  to  set  up new programmer-defined field
+       types.  See the <STRONG><A HREF="form_fieldtype.3x.html">form_fieldtype(3x)</A></STRONG> manual page.
 
 
 </PRE>
 <H2>RETURN VALUE</H2><PRE>
-       The  functions  <STRONG>field_type</STRONG>  and  <STRONG>field_arg</STRONG>  return <STRONG>NULL</STRONG> on
+       The functions <STRONG>field_type</STRONG>  and  <STRONG>field_arg</STRONG>  return  <STRONG>NULL</STRONG>  on
        error. The function <STRONG>set_field_type</STRONG> returns one of the fol-
        lowing:
 
@@ -148,6 +157,7 @@
             System error occurred (see <STRONG>errno</STRONG>).
 
 
+
 </PRE>
 <H2>SEE ALSO</H2><PRE>
        <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>, <STRONG><A HREF="form.3x.html">form(3x)</A></STRONG>.
@@ -161,23 +171,14 @@
 
 </PRE>
 <H2>PORTABILITY</H2><PRE>
-       These routines emulate the System V forms  library.   They
+       These  routines  emulate the System V forms library.  They
        were not supported on Version 7 or BSD versions.
 
 
 </PRE>
 <H2>AUTHORS</H2><PRE>
-       Juergen  Pfeifer.   Manual  pages  and  adaptation for new
+       Juergen Pfeifer.  Manual  pages  and  adaptation  for  new
        curses by Eric S. Raymond.
-
-
-
-
-
-
-
-
-
 
 
 
Index: doc/html/man/form_fieldtype.3x.html
--- ncurses-5.3-20021012/doc/html/man/form_fieldtype.3x.html	Sat Jun 22 17:25:33 2002
+++ ncurses-5.3-20030719/doc/html/man/form_fieldtype.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: form_fieldtype.3x,v 1.9 2001/08/04 20:36:25 William.Setzer Exp @
+  * @Id: form_fieldtype.3x,v 1.12 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -72,11 +72,11 @@
        The function <STRONG>new_fieldtype</STRONG> creates a new field type usable
        for data validation.  You supply it  with  <EM>field</EM><STRONG>_</STRONG><EM>check</EM>,  a
        predicate  to check the validity of an entered data string
-       whenever the user attempt to leave a field.  The (FIELD *)
-       argument  is passed in so the validation predicate can see
-       the field's buffer, sizes and other attributes; the second
-       argument  is an argument-block structure, about which more
-       below.
+       whenever the user attempts to leave a field.   The  (FIELD
+       *)  argument  is passed in so the validation predicate can
+       see the field's buffer, sizes and  other  attributes;  the
+       second  argument  is  an  argument-block  structure, about
+       which more below.
 
        You also supply <STRONG>new_fieldtype</STRONG> with <EM>char</EM><STRONG>_</STRONG><EM>check</EM>, a  function
        to  validate input characters as they are entered; it will
@@ -86,20 +86,24 @@
        The  function <STRONG>free_fieldtype</STRONG> frees the space allocated for
        a given validation type.
 
-       The function <STRONG>set_fieldtype</STRONG> associates  three  storage-man-
-       agement functions with a field type.  The <EM>mak</EM><STRONG>_</STRONG><EM>arg</EM> function
-       is automatically applied to the list of arguments you give
-       <STRONG>set_field_type</STRONG>  when  attaching validation to a field; its
-       job is to bundle these into  an  allocated  argument-block
-       object which can later be passed to validation predicated.
-       The other two hook arguments should copy  and  free  argu-
-       ment-block  structures.   They  will be used by the forms-
-       driver code. You must supply  the  <EM>mak</EM><STRONG>_</STRONG><EM>arg</EM>  function,  the
-       other  two  are optional, you may supply NULL for them. In
-       this case it is assumed,  that  <EM>mak</EM><STRONG>_</STRONG><EM>arg</EM>  doesn't  allocate
+       The function <STRONG>set_fieldtype_arg</STRONG> associates  three  storage-
+       management  functions  with  a  field  type.  The <EM>make</EM><STRONG>_</STRONG><EM>arg</EM>
+       function is automatically applied to the list of arguments
+       you  give  <STRONG>set_field_type</STRONG>  when  attaching validation to a
+       field; its job is to bundle these into an allocated  argu-
+       ment-block  object which can later be passed to validation
+       predicated.  The other two hook arguments should copy  and
+       free  argument-block structures.  They will be used by the
+       forms-driver code.  You must supply the <EM>make</EM><STRONG>_</STRONG><EM>arg</EM> function,
+       the  other two are optional, you may supply NULL for them.
+       In this case it is assumed that <EM>make</EM><STRONG>_</STRONG><EM>arg</EM> does not allocate
        memory  but simply loads the argument into a single scalar
        value.
 
+       The function <STRONG>link_fieldtype</STRONG> creates a new field type  from
+       the  two  given  types.   They are connected by an logical
+       'OR'.
+
        The   form    driver    requests    <STRONG>REQ_NEXT_CHOICE</STRONG>    and
        <STRONG>REQ_PREV_CHOICE</STRONG> assume that the possible values of a field
        form an ordered set, and provide the forms user with a way
@@ -155,10 +159,6 @@
 <H2>AUTHORS</H2><PRE>
        Juergen  Pfeifer.   Manual  pages  and  adaptation for new
        curses by Eric S. Raymond.
-
-
-
-
 
 
 
Index: doc/html/man/infocmp.1m.html
--- ncurses-5.3-20021012/doc/html/man/infocmp.1m.html	Sat Oct 12 19:28:05 2002
+++ ncurses-5.3-20030719/doc/html/man/infocmp.1m.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: infocmp.1m,v 1.30 2002/10/05 21:22:21 tom Exp @
+  * @Id: infocmp.1m,v 1.33 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -313,8 +313,8 @@
 
             An   SGR0  designates  an  empty  highlight  sequence
             (equivalent to {SGR:NORMAL}).
-       -
-       l    Set output format to terminfo.
+
+       <STRONG>-l</STRONG>   Set output format to terminfo.
 
        <STRONG>-p</STRONG>   Ignore padding specifications when comparing strings.
 
@@ -387,13 +387,13 @@
 
        The <STRONG>-r</STRONG> option's notion of `termcap' capabilities is System
        V Release 4's.  Actual BSD curses  versions  will  have  a
-       more  restricted  set.  To see only the 4.4BSD set, use -r
-       -RBSD.
+       more  restricted  set.  To see only the 4.4BSD set, use <STRONG>-r</STRONG>
+       <STRONG>-RBSD</STRONG>.
 
 
 </PRE>
 <H2>BUGS</H2><PRE>
-       The -F option of <STRONG><A HREF="infocmp.1m.html">infocmp(1m)</A></STRONG> should be a <STRONG><A HREF="toe.1m.html">toe(1m)</A></STRONG> mode.
+       The <STRONG>-F</STRONG> option of <STRONG><A HREF="infocmp.1m.html">infocmp(1m)</A></STRONG> should be a <STRONG><A HREF="toe.1m.html">toe(1m)</A></STRONG> mode.
 
 
 </PRE>
Index: doc/html/man/infotocap.1m.html
--- ncurses-5.3-20021012/doc/html/man/infotocap.1m.html	Sat Jun 22 17:25:36 2002
+++ ncurses-5.3-20030719/doc/html/man/infotocap.1m.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1999,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1999-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: infotocap.1m,v 1.3 2000/08/13 01:56:03 tom Exp @
+  * @Id: infotocap.1m,v 1.4 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/key_defined.3x.html
--- /dev/null	Tue Jun  3 10:49:35 2003
+++ ncurses-5.3-20030719/doc/html/man/key_defined.3x.html	Sat May 31 19:04:20 2003
@@ -0,0 +1,119 @@
+<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
+<!-- 
+  ****************************************************************************
+  * Copyright (c) 2003 Free Software Foundation, Inc.                        *
+  *                                                                          *
+  * Permission is hereby granted, free of charge, to any person obtaining a  *
+  * copy of this software and associated documentation files (the            *
+  * "Software"), to deal in the Software without restriction, including      *
+  * without limitation the rights to use, copy, modify, merge, publish,      *
+  * distribute, distribute with modifications, sublicense, and/or sell       *
+  * copies of the Software, and to permit persons to whom the Software is    *
+  * furnished to do so, subject to the following conditions:                 *
+  *                                                                          *
+  * The above copyright notice and this permission notice shall be included  *
+  * in all copies or substantial portions of the Software.                   *
+  *                                                                          *
+  * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
+  * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
+  * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
+  * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
+  * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
+  * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
+  * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
+  *                                                                          *
+  * Except as contained in this notice, the name(s) of the above copyright   *
+  * holders shall not be used in advertising or otherwise to promote the     *
+  * sale, use or other dealings in this Software without prior written       *
+  * authorization.                                                           *
+  ****************************************************************************
+  * Author: Thomas E. Dickey 2003
+  * @Id: key_defined.3x,v 1.2 2003/05/17 23:24:45 tom Exp @
+-->
+<HTML>
+<HEAD>
+<TITLE>key_defined 3x</TITLE>
+<link rev=made href="mailto:bug-ncurses@gnu.org">
+<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
+</HEAD>
+<BODY>
+<H1>key_defined 3x</H1>
+<HR>
+<PRE>
+<!-- Manpage converted by man2html 3.0.1 -->
+
+</PRE>
+<H2>NAME</H2><PRE>
+       <STRONG>define_key</STRONG> - define a keycode
+
+
+</PRE>
+<H2>SYNOPSIS</H2><PRE>
+       <STRONG>#include</STRONG> <STRONG>&lt;curses.h&gt;</STRONG>
+
+       <STRONG>int</STRONG> <STRONG>key_defined(const</STRONG> <STRONG>char</STRONG> <STRONG>*definition);</STRONG>
+
+
+</PRE>
+<H2>DESCRIPTION</H2><PRE>
+       This is an extension to the curses library.  It permits an
+       application to determine if a string is currently bound to
+       any keycode.
+
+
+</PRE>
+<H2>RETURN VALUE</H2><PRE>
+       If  the  string  is bound to a keycode, its value (greater
+       than zero) is returned.  If no keycode is bound,  zero  is
+       returned.   If  the  string  conflicts with longer strings
+       which are bound to keys, -1 is returned.
+
+
+</PRE>
+<H2>PORTABILITY</H2><PRE>
+       These routines are specific to  ncurses.   They  were  not
+       supported  on  Version 7, BSD or System V implementations.
+       It is recommended that any code depending on them be  con-
+       ditioned using NCURSES_VERSION.
+
+
+</PRE>
+<H2>SEE ALSO</H2><PRE>
+       <STRONG><A HREF="define_key.3x.html">define_key(3x)</A></STRONG>.
+
+
+</PRE>
+<H2>AUTHOR</H2><PRE>
+       Thomas Dickey.
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+
+</PRE>
+<HR>
+<ADDRESS>
+Man(1) output converted with
+<a href="http://www.oac.uci.edu/indiv/ehood/man2html.html">man2html</a>
+</ADDRESS>
+</BODY>
+</HTML>
Index: doc/html/man/keybound.3x.html
--- ncurses-5.3-20021012/doc/html/man/keybound.3x.html	Sat Jun 22 17:25:36 2002
+++ ncurses-5.3-20030719/doc/html/man/keybound.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1999,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * authorization.                                                           *
   ****************************************************************************
   * Author: Thomas E. Dickey &lt;dickey@clark.net&gt; 1999
-  * @Id: keybound.3x,v 1.3 2002/02/16 22:30:36 tom Exp @
+  * @Id: keybound.3x,v 1.4 2003/03/08 19:08:33 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -63,10 +63,12 @@
 
 </PRE>
 <H2>RETURN VALUE</H2><PRE>
-       The  keycode  must  be  greater  than  zero,  else NULL is
-       returned.  If it does not correspond  to  a  defined  key,
-       then  NULL is returned.  Otherwise, the function returns a
-       string, which must be freed by the caller.
+       The <EM>keycode</EM> parameter must be greater than zero, else NULL
+       is returned.  If it does not correspond to a defined  key,
+       then  NULL  is  returned.   The <EM>count</EM> parameter is used to
+       allow the application to iterate through multiple  defini-
+       tions,  counting from zero.  When successful, the function
+       returns a string which must be freed by the caller.
 
 
 </PRE>
@@ -85,8 +87,6 @@
 </PRE>
 <H2>AUTHOR</H2><PRE>
        Thomas Dickey.
-
-
 
 
 
Index: doc/html/man/menu_driver.3x.html
--- ncurses-5.3-20021012/doc/html/man/menu_driver.3x.html	Sat Jun 22 17:25:37 2002
+++ ncurses-5.3-20030719/doc/html/man/menu_driver.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: menu_driver.3x,v 1.10 2002/02/16 22:40:59 tom Exp @
+  * @Id: menu_driver.3x,v 1.11 2003/05/10 20:22:01 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/menu_pattern.3x.html
--- ncurses-5.3-20021012/doc/html/man/menu_pattern.3x.html	Sat Jun 22 17:25:39 2002
+++ ncurses-5.3-20030719/doc/html/man/menu_pattern.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: menu_pattern.3x,v 1.7 2002/02/16 22:40:59 tom Exp @
+  * @Id: menu_pattern.3x,v 1.8 2003/05/10 20:22:01 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/ncurses.3x.html
--- ncurses-5.3-20021012/doc/html/man/ncurses.3x.html	Sat Aug 31 17:59:48 2002
+++ ncurses-5.3-20030719/doc/html/man/ncurses.3x.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998,1999,2001,2002 Free Software Foundation, Inc.         *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: ncurses.3x,v 1.63 2002/08/10 21:56:07 tom Exp @
+  * @Id: ncurses.3x,v 1.66 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -354,6 +354,7 @@
               is_linetouched          <STRONG><A HREF="curs_touch.3x.html">curs_touch(3x)</A></STRONG>
               is_wintouched           <STRONG><A HREF="curs_touch.3x.html">curs_touch(3x)</A></STRONG>
               isendwin                <STRONG><A HREF="curs_initscr.3x.html">curs_initscr(3x)</A></STRONG>
+              key_defined             <STRONG><A HREF="key_defined.3x.html">key_defined(3x)</A></STRONG>*
               key_name                <STRONG><A HREF="curs_util.3x.html">curs_util(3x)</A></STRONG>
               keybound                <STRONG><A HREF="keybound.3x.html">keybound(3x)</A></STRONG>*
               keyname                 <STRONG><A HREF="curs_util.3x.html">curs_util(3x)</A></STRONG>
@@ -369,8 +370,8 @@
               mouseinterval           <STRONG><A HREF="curs_mouse.3x.html">curs_mouse(3x)</A></STRONG>*
               mousemask               <STRONG><A HREF="curs_mouse.3x.html">curs_mouse(3x)</A></STRONG>*
               move                    <STRONG><A HREF="curs_move.3x.html">curs_move(3x)</A></STRONG>
-              mvadd_wch               <STRONG><A HREF="curs_add_wch.3x.html">curs_add_wch(3x)</A></STRONG>
 
+              mvadd_wch               <STRONG><A HREF="curs_add_wch.3x.html">curs_add_wch(3x)</A></STRONG>
               mvadd_wchnstr           <STRONG><A HREF="curs_add_wchstr.3x.html">curs_add_wchstr(3x)</A></STRONG>
               mvadd_wchstr            <STRONG><A HREF="curs_add_wchstr.3x.html">curs_add_wchstr(3x)</A></STRONG>
               mvaddch                 <STRONG><A HREF="curs_addch.3x.html">curs_addch(3x)</A></STRONG>
@@ -423,8 +424,8 @@
               mvwaddstr               <STRONG><A HREF="curs_addstr.3x.html">curs_addstr(3x)</A></STRONG>
               mvwaddwstr              <STRONG><A HREF="curs_addwstr.3x.html">curs_addwstr(3x)</A></STRONG>
               mvwchgat                <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG>
-              mvwdelch                <STRONG><A HREF="curs_delch.3x.html">curs_delch(3x)</A></STRONG>
 
+              mvwdelch                <STRONG><A HREF="curs_delch.3x.html">curs_delch(3x)</A></STRONG>
               mvwget_wch              <STRONG><A HREF="curs_get_wch.3x.html">curs_get_wch(3x)</A></STRONG>
               mvwget_wstr             <STRONG><A HREF="curs_get_wstr.3x.html">curs_get_wstr(3x)</A></STRONG>
               mvwgetch                <STRONG><A HREF="curs_getch.3x.html">curs_getch(3x)</A></STRONG>
@@ -477,8 +478,8 @@
               putwin                  <STRONG><A HREF="curs_util.3x.html">curs_util(3x)</A></STRONG>
               qiflush                 <STRONG><A HREF="curs_inopts.3x.html">curs_inopts(3x)</A></STRONG>
               raw                     <STRONG><A HREF="curs_inopts.3x.html">curs_inopts(3x)</A></STRONG>
-              redrawwin               <STRONG><A HREF="curs_refresh.3x.html">curs_refresh(3x)</A></STRONG>
 
+              redrawwin               <STRONG><A HREF="curs_refresh.3x.html">curs_refresh(3x)</A></STRONG>
               refresh                 <STRONG><A HREF="curs_refresh.3x.html">curs_refresh(3x)</A></STRONG>
               reset_prog_mode         <STRONG><A HREF="curs_kernel.3x.html">curs_kernel(3x)</A></STRONG>
               reset_shell_mode        <STRONG><A HREF="curs_kernel.3x.html">curs_kernel(3x)</A></STRONG>
@@ -531,8 +532,8 @@
               tgetflag                <STRONG><A HREF="curs_termcap.3x.html">curs_termcap(3x)</A></STRONG>
               tgetnum                 <STRONG><A HREF="curs_termcap.3x.html">curs_termcap(3x)</A></STRONG>
               tgetstr                 <STRONG><A HREF="curs_termcap.3x.html">curs_termcap(3x)</A></STRONG>
-              tgoto                   <STRONG><A HREF="curs_termcap.3x.html">curs_termcap(3x)</A></STRONG>
 
+              tgoto                   <STRONG><A HREF="curs_termcap.3x.html">curs_termcap(3x)</A></STRONG>
               tigetflag               <STRONG><A HREF="curs_terminfo.3x.html">curs_terminfo(3x)</A></STRONG>
               tigetnum                <STRONG><A HREF="curs_terminfo.3x.html">curs_terminfo(3x)</A></STRONG>
               tigetstr                <STRONG><A HREF="curs_terminfo.3x.html">curs_terminfo(3x)</A></STRONG>
@@ -585,8 +586,8 @@
               wbkgrndset              <STRONG><A HREF="curs_bkgrnd.3x.html">curs_bkgrnd(3x)</A></STRONG>
               wborder                 <STRONG><A HREF="curs_border.3x.html">curs_border(3x)</A></STRONG>
               wborder_set             <STRONG><A HREF="curs_border_set.3x.html">curs_border_set(3x)</A></STRONG>
-              wchgat                  <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG>
 
+              wchgat                  <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG>
               wclear                  <STRONG><A HREF="curs_clear.3x.html">curs_clear(3x)</A></STRONG>
               wclrtobot               <STRONG><A HREF="curs_clear.3x.html">curs_clear(3x)</A></STRONG>
               wclrtoeol               <STRONG><A HREF="curs_clear.3x.html">curs_clear(3x)</A></STRONG>
@@ -639,8 +640,8 @@
               wstandout               <STRONG><A HREF="curs_attr.3x.html">curs_attr(3x)</A></STRONG>
               wsyncdown               <STRONG><A HREF="curs_window.3x.html">curs_window(3x)</A></STRONG>
               wsyncup                 <STRONG><A HREF="curs_window.3x.html">curs_window(3x)</A></STRONG>
-              wtimeout                <STRONG><A HREF="curs_inopts.3x.html">curs_inopts(3x)</A></STRONG>
 
+              wtimeout                <STRONG><A HREF="curs_inopts.3x.html">curs_inopts(3x)</A></STRONG>
               wtouchln                <STRONG><A HREF="curs_touch.3x.html">curs_touch(3x)</A></STRONG>
               wunctrl                 <STRONG><A HREF="curs_util.3x.html">curs_util(3x)</A></STRONG>
               wvline                  <STRONG><A HREF="curs_border.3x.html">curs_border(3x)</A></STRONG>
@@ -655,9 +656,9 @@
        descriptions.
 
        All  macros  return  the  value  of  the <STRONG>w</STRONG> version, except
-       <STRONG>setscrreg</STRONG>, <STRONG>wsetscrreg</STRONG>,  <STRONG>getyx</STRONG>,  <STRONG>getbegyx</STRONG>,  <STRONG>getmaxyx</STRONG>.   The
+       <STRONG>setscrreg</STRONG>, <STRONG>wsetscrreg</STRONG>, <STRONG>getyx</STRONG>, <STRONG>getbegyx</STRONG>, and <STRONG>getmaxyx</STRONG>.  The
        return  values  of <STRONG>setscrreg</STRONG>, <STRONG>wsetscrreg</STRONG>, <STRONG>getyx</STRONG>, <STRONG>getbegyx</STRONG>,
-       and <STRONG>getmaxyx</STRONG> are undefined (<EM>i</EM>.<EM>e</EM>., these should not be used
+       and <STRONG>getmaxyx</STRONG> are undefined (i.e., these should not be used
        as the right-hand side of assignment statements).
 
        Routines that return pointers return <STRONG>NULL</STRONG> on error.
@@ -674,7 +675,7 @@
             The debugging library checks this environment  symbol
             when the application has redirected output to a file.
             The symbol's numeric value is used for the  baudrate.
-            If  no value is found <STRONG>ncurses</STRONG> uses 9600.  This allows
+            If no value is found, <STRONG>ncurses</STRONG> uses 9600.  This allows
             testers to construct repeatable test-cases that  take
             into account costs that depend on baudrate.
 
@@ -698,7 +699,6 @@
             host  which  does  not honor NAWS (Negotiations About
             Window Size), or because you are temporarily  running
             as another user.
-
             Either  COLUMNS  or  LINES  symbols  may be specified
             independently.  This is mainly useful  to  circumvent
             legacy  misfeatures  of  terminal descriptions, e.g.,
@@ -838,7 +838,7 @@
             The complete list of directories in order follows:
 
             -  the last directory to which <STRONG>ncurses</STRONG> wrote, if any,
-               is searched first.
+               is searched first
 
             -  the directory specified by the TERMINFO symbol
 
@@ -910,8 +910,8 @@
        The <STRONG>ncurses</STRONG> library extends the fixed set of function  key
        capabilities  of  terminals  by  allowing  the application
        designer to define additional key  sequences  at  runtime.
-       See  the  <STRONG><A HREF="define_key.3x.html">define_key(3x)</A></STRONG>  and  <STRONG><A HREF="keyok.3x.html">keyok(3x)</A></STRONG>  manual pages for
-       details.
+       See  the  <STRONG><A HREF="define_key.3x.html">define_key(3x)</A></STRONG>  <STRONG><A HREF="key_defined.3x.html">key_defined(3x)</A></STRONG>,  and  <STRONG><A HREF="keyok.3x.html">keyok(3x)</A></STRONG>
+       manual pages for details.
 
        The  <STRONG>ncurses</STRONG>  library  can  exploit  the  capabilities  of
        terminals  which  implement the ISO-6429 SGR 39 and SGR 49
Index: doc/html/man/panel.3x.html
--- ncurses-5.3-20021012/doc/html/man/panel.3x.html	Sat Jun 22 17:25:43 2002
+++ ncurses-5.3-20030719/doc/html/man/panel.3x.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998 Free Software Foundation, Inc.                        *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: panel.3x,v 1.10 2000/08/13 01:56:47 tom Exp @
+  * @Id: panel.3x,v 1.11 2003/05/17 22:44:09 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -81,7 +81,7 @@
        of the stack.
 
        A window is associated with every panel.  The  panel  rou-
-       tines  enable you to create, move, hides, and show panels,
+       tines  enable  you to create, move, hide, and show panels,
        as well as position a panel at any desired location in the
        stack.
 
Index: doc/html/man/term.5.html
--- ncurses-5.3-20021012/doc/html/man/term.5.html	Sat Aug 31 17:59:49 2002
+++ ncurses-5.3-20030719/doc/html/man/term.5.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: term.5,v 1.14 2002/08/10 21:59:37 tom Exp @
+  * @Id: term.5,v 1.15 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/term.7.html
--- ncurses-5.3-20021012/doc/html/man/term.7.html	Sat Jun 22 17:25:44 2002
+++ ncurses-5.3-20030719/doc/html/man/term.7.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: term.7,v 1.13 2002/04/20 16:50:47 tom Exp @
+  * @Id: term.7,v 1.14 2003/05/10 20:33:49 jmc Exp @
 -->
 <HTML>
 <HEAD>
@@ -126,10 +126,10 @@
        ters or digits.  You need to avoid using punctuation char-
        acters  in  root  names,  because they are used and inter-
        preted as filenames and shell meta-characters (such as  !,
-       $, *, ? etc.) embedded in them may cause odd and unhelpful
-       behavior.  The slash (/), or any other character that  may
-       be  interpreted  by  anyone's file system (\, $, [, ]), is
-       especially dangerous  (terminfo  is  platform-independent,
+       $,  *, ?, etc.) embedded in them may cause odd and unhelp-
+       ful behavior.  The slash (/), or any other character  that
+       may  be  interpreted by anyone's file system (\, $, [, ]),
+       is especially dangerous (terminfo is platform-independent,
        and  choosing  names with special characters could someday
        make life difficult for users of a future port).  The  dot
        (.)  character  is  relatively safe as long as there is at
@@ -169,23 +169,23 @@
             another that has this suffix and uses  magic  cookies
             to support multiple attributes.
 
-       -am  Enable auto-margin (right-margin wraparound)
+       -am  Enable auto-margin (right-margin wraparound).
 
-       -m   Mono mode - suppress color support
+       -m   Mono mode - suppress color support.
 
        -na  No  arrow keys - termcap ignores arrow keys which are
             actually there on the terminal, so the user  can  use
             the arrow keys locally.
 
-       -nam No auto-margin - suppress am capability
+       -nam No auto-margin - suppress am capability.
 
-       -nl  No labels - suppress soft labels
+       -nl  No labels - suppress soft labels.
 
-       -nsl No status line - suppress status line
+       -nsl No status line - suppress status line.
 
        -pp  Has a printer port which is used.
 
-       -rv  Terminal in reverse video mode (black on white)
+       -rv  Terminal in reverse video mode (black on white).
 
        -s   Enable status line.
 
@@ -223,10 +223,10 @@
             compiled terminal capability data base
 
        /etc/inittab
-            tty line initialization (AT&amp;T-like UNIXes).
+            tty line initialization (AT&amp;T-like UNIXes)
 
        /etc/ttys
-            tty line initialization (BSD-like UNIXes).
+            tty line initialization (BSD-like UNIXes)
 
 
 </PRE>
Index: doc/html/man/terminfo.5.html
--- ncurses-5.3-20021012/doc/html/man/terminfo.5.html	Sat Aug 31 17:59:51 2002
+++ ncurses-5.3-20030719/doc/html/man/terminfo.5.html	Sat Jan 11 21:03:08 2003
@@ -34,7 +34,7 @@
   ****************************************************************************
   * @Id: terminfo.head,v 1.10 2002/08/17 23:37:10 tom Exp @
   * Head of terminfo man page ends here
-  * @Id: terminfo.tail,v 1.35 2002/04/20 16:49:33 tom Exp @
+  * @Id: terminfo.tail,v 1.38 2003/01/05 22:47:05 tom Exp @
   * Beginning of terminfo.tail file
   *.TH
 -->
@@ -1221,38 +1221,75 @@
        The parameter mechanism uses a stack and special  <STRONG>%</STRONG>  codes
        to  manipulate  it.  Typically a sequence will push one of
        the parameters onto the stack and then print  it  in  some
-       format.  Often more complex operations are necessary.
+       format.   Print  (e.g.,  "%d")  is  a special case.  Other
+       operations, including "%t"  pop  their  operand  from  the
+       stack.  It is noted that more complex operations are often
+       necessary, e.g., in the <STRONG>sgr</STRONG> string.
 
        The <STRONG>%</STRONG> encodings have the following meanings:
 
-            %%        outputs `%'
-            %<EM>[[</EM>:<EM>]flags][width[.precision]][</EM>doxXs<EM>]</EM>
-                      as in <STRONG>printf</STRONG>, flags are [-+#] and space
-            %c        print pop() like %c in printf()
-            %s        print pop() like %s in printf()
-
-            %p[1-9]   push <EM>i</EM>'th parm
-            %P[a-z]   set dynamic variable [a-z] to pop()
-            %g[a-z]   get dynamic variable [a-z] and push it
-            %P[A-Z]   set static variable [a-z] to pop()
-            %g[A-Z]   get static variable [a-z] and push it
-            %'<EM>c</EM>'      char constant <EM>c</EM>
-            %{<EM>nn</EM>}     integer constant <EM>nn</EM>
-            %l        push strlen(pop)
-
-            %+ %- %* %/ %m
-                      arithmetic (%m is mod): push(pop() op pop())
-            %&amp; %| %^  bit operations: push(pop() op pop())
-            %= %&gt; %&lt;  logical operations: push(pop() op pop())
-            %A, %O    logical and &amp; or operations (for conditionals)
-            %! %~     unary operations push(op pop())
-            %i        add 1 to first two parameters (for ANSI terminals)
-
-            %? expr %t thenpart %e elsepart %;
-                      if-then-else, %e elsepart is optional.
-                      else-if's are possible a la Algol 68:
-                      %? c1 %t b1 %e c2 %t b2 %e c3 %t b3 %e c4 %t b4 %e %;
-                      ci are conditions, bi are bodies.
+
+       %%   outputs `%'
+
+       %<EM>[[</EM>:<EM>]flags][width[.precision]][</EM>doxXs<EM>]</EM>
+            as in <STRONG>printf</STRONG>, flags are [-+#] and space
+
+       %c   print pop() like %c in <STRONG>printf</STRONG>
+
+       %s   print pop() like %s in <STRONG>printf</STRONG>
+
+       %p[1-9]
+            push <EM>i</EM>'th parameter
+
+       %P[a-z]
+            set dynamic variable [a-z] to pop()
+
+
+       %g[a-z]
+            get dynamic variable [a-z] and push it
+
+       %P[A-Z]
+            set static variable [a-z] to pop()
+
+       %g[A-Z]
+            get static variable [a-z] and push it
+
+            The terms  "static"  and  "dynamic"  are  misleading.
+            Historically,  these are simply two different sets of
+            variables, whose values are not reset  between  calls
+            to  <STRONG>tparm</STRONG>.   However,  that fact is not documented in
+            other implementations.  Relying on it will  adversely
+            impact portability to other implementations.
+
+       %'<EM>c</EM>' char constant <EM>c</EM>
+
+       %{<EM>nn</EM>}
+            integer constant <EM>nn</EM>
+
+       %l   push strlen(pop)
+
+       %+ %- %* %/ %m
+            arithmetic (%m is mod): push(pop() op pop())
+
+       %&amp; %| %^
+            bit operations: push(pop() op pop())
+
+       %= %&gt; %&lt;
+            logical operations: push(pop() op pop())
+
+       %A, %O
+            logical and &amp; or operations (for conditionals)
+
+       %! %~
+            unary operations push(op pop())
+
+       %i   add 1 to first two parameters (for ANSI terminals)
+
+       %? <EM>expr</EM> %t <EM>thenpart</EM> %e <EM>elsepart</EM> %;
+            if-then-else, %e <EM>elsepart</EM> is optional.  else-if's are
+            possible a la Algol 68:
+            %? c1 %t b1 %e c2 %t b2 %e c3 %t b3 %e c4 %t b4 %e %;
+            ci are conditions, bi are bodies.
 
        Binary operations are in postfix form with the operands in
        the usual order.  That  is,  to  get  x-5  one  would  use
@@ -1531,6 +1568,7 @@
 
            <STRONG>tparm</STRONG> <STRONG>parameter</STRONG>   <STRONG>attribute</STRONG>    <STRONG>escape</STRONG> <STRONG>sequence</STRONG>
 
+
            none              none         \E[0m
            p1                standout     \E[0;1;7m
            p2                underline    \E[0;4m
@@ -1568,7 +1606,6 @@
          ;5         if p4               %?%p4%|%t;5%;
          ;7         if p1 or p3         %?%p1%p3%|%t;7%;
          ;8         if p7               %?%p7%|%t;8%;
-
          m          always              m
          ^N or ^O   if p9 ^N, else ^O   %?%p9%t^N%e^O%;
 
@@ -1622,170 +1659,168 @@
        <STRONG>rmkx</STRONG>.  Otherwise the keypad is assumed to always transmit.
        The  codes  sent by the left arrow, right arrow, up arrow,
        down arrow, and home keys can be given  as  <STRONG>kcub1,</STRONG>  <STRONG>kcuf1,</STRONG>
-       <STRONG>kcuu1,</STRONG>  <STRONG>kcud1,</STRONG>  and  <STRONG>khome</STRONG>  respectively.   If  there  are
-       function keys such as f0, f1, ...,  f10,  the  codes  they
-       send  can  be given as <STRONG>kf0,</STRONG> <STRONG>kf1,</STRONG> <STRONG>...,</STRONG> <STRONG>kf10</STRONG>.  If these keys
-       have labels other than the default  f0  through  f10,  the
-       labels  can  be  given  as <STRONG>lf0,</STRONG> <STRONG>lf1,</STRONG> <STRONG>...,</STRONG> <STRONG>lf10</STRONG>.  The codes
-       transmitted by certain other special keys  can  be  given:
-       <STRONG>kll</STRONG>  (home  down), <STRONG>kbs</STRONG> (backspace), <STRONG>ktbc</STRONG> (clear all tabs),
-       <STRONG>kctab</STRONG> (clear the tab stop in  this  column),  <STRONG>kclr</STRONG>  (clear
-       screen  or  erase  key),  <STRONG>kdch1</STRONG>  (delete  character), <STRONG>kdl1</STRONG>
-       (delete line), <STRONG>krmir</STRONG> (exit insert mode), <STRONG>kel</STRONG> (clear to end
-       of  line),  <STRONG>ked</STRONG>  (clear  to  end of screen), <STRONG>kich1</STRONG> (insert
-       character or enter insert mode), <STRONG>kil1</STRONG> (insert  line),  <STRONG>knp</STRONG>
-       (next  page),  <STRONG>kpp</STRONG>  (previous  page),  <STRONG>kind</STRONG>  (scroll  for-
-       ward/down), <STRONG>kri</STRONG> (scroll backward/up), <STRONG>khts</STRONG> (set a tab stop
-       in  this column).  In addition, if the keypad has a 3 by 3
-       array of keys including the four  arrow  keys,  the  other
-       five  keys  can  be  given as <STRONG>ka1</STRONG>, <STRONG>ka3</STRONG>, <STRONG>kb2</STRONG>, <STRONG>kc1</STRONG>, and <STRONG>kc3</STRONG>.
-       These keys are useful when the effects of a 3 by 3  direc-
-       tional pad are needed.
-
-       Strings  to  program  function keys can be given as <STRONG>pfkey</STRONG>,
-       <STRONG>pfloc</STRONG>, and <STRONG>pfx</STRONG>.  A string to program screen labels  should
-       be  specified  as  <STRONG>pln</STRONG>.   Each  of these strings takes two
-       parameters: the function key number to program (from 0  to
-       10)  and the string to program it with.  Function key num-
-       bers out of this range may program  undefined  keys  in  a
-       terminal  dependent  manner.   The  difference between the
-       capabilities is that <STRONG>pfkey</STRONG> causes pressing the  given  key
-       to  be the same as the user typing the given string; <STRONG>pfloc</STRONG>
+       <STRONG>kcuu1,</STRONG>  <STRONG>kcud1,</STRONG> and <STRONG>khome</STRONG> respectively.  If there are func-
+       tion keys such as f0, f1, ..., f10, the  codes  they  send
+       can  be  given as <STRONG>kf0,</STRONG> <STRONG>kf1,</STRONG> <STRONG>...,</STRONG> <STRONG>kf10</STRONG>.  If these keys have
+       labels other than the default f0 through f10,  the  labels
+       can  be given as <STRONG>lf0,</STRONG> <STRONG>lf1,</STRONG> <STRONG>...,</STRONG> <STRONG>lf10</STRONG>.  The codes transmit-
+       ted by certain other special keys can be given: <STRONG>kll</STRONG>  (home
+       down),  <STRONG>kbs</STRONG>  (backspace),  <STRONG>ktbc</STRONG>  (clear  all  tabs), <STRONG>kctab</STRONG>
+       (clear the tab stop in this column), <STRONG>kclr</STRONG> (clear screen or
+       erase  key), <STRONG>kdch1</STRONG> (delete character), <STRONG>kdl1</STRONG> (delete line),
+       <STRONG>krmir</STRONG> (exit insert mode), <STRONG>kel</STRONG> (clear to end of line),  <STRONG>ked</STRONG>
+       (clear to end of screen), <STRONG>kich1</STRONG> (insert character or enter
+       insert mode), <STRONG>kil1</STRONG> (insert line),  <STRONG>knp</STRONG>  (next  page),  <STRONG>kpp</STRONG>
+       (previous  page),  <STRONG>kind</STRONG> (scroll forward/down), <STRONG>kri</STRONG> (scroll
+       backward/up), <STRONG>khts</STRONG> (set a tab stop in  this  column).   In
+       addition, if the keypad has a 3 by 3 array of keys includ-
+       ing the four arrow keys, the other five keys can be  given
+       as  <STRONG>ka1</STRONG>,  <STRONG>ka3</STRONG>,  <STRONG>kb2</STRONG>,  <STRONG>kc1</STRONG>, and <STRONG>kc3</STRONG>.  These keys are useful
+       when the effects of a 3 by 3 directional pad are needed.
+       Strings to program function keys can be  given  as  <STRONG>pfkey</STRONG>,
+       <STRONG>pfloc</STRONG>,  and <STRONG>pfx</STRONG>.  A string to program screen labels should
+       be specified as <STRONG>pln</STRONG>.  Each  of  these  strings  takes  two
+       parameters:  the function key number to program (from 0 to
+       10) and the string to program it with.  Function key  num-
+       bers  out  of  this  range may program undefined keys in a
+       terminal dependent manner.   The  difference  between  the
+       capabilities  is  that <STRONG>pfkey</STRONG> causes pressing the given key
+       to be the same as the user typing the given string;  <STRONG>pfloc</STRONG>
        causes the string to be executed by the terminal in local;
-       and  <STRONG>pfx</STRONG>  causes  the string to be transmitted to the com-
+       and <STRONG>pfx</STRONG> causes the string to be transmitted  to  the  com-
        puter.
 
        The capabilities <STRONG>nlab</STRONG>, <STRONG>lw</STRONG> and <STRONG>lh</STRONG> define the number of pro-
-       grammable  screen  labels  and their width and height.  If
-       there are commands to turn the labels  on  and  off,  give
-       them  in <STRONG>smln</STRONG> and <STRONG>rmln</STRONG>.  <STRONG>smln</STRONG> is normally output after one
+       grammable screen labels and their width  and  height.   If
+       there  are  commands  to  turn the labels on and off, give
+       them in <STRONG>smln</STRONG> and <STRONG>rmln</STRONG>.  <STRONG>smln</STRONG> is normally output after  one
        or more pln sequences to make sure that the change becomes
        visible.
 
 
    <STRONG>Tabs</STRONG> <STRONG>and</STRONG> <STRONG>Initialization</STRONG>
-       If  the terminal has hardware tabs, the command to advance
-       to the next tab stop can be given as <STRONG>ht</STRONG>  (usually  control
-       I).   A  ``back-tab''  command which moves leftward to the
+       If the terminal has hardware tabs, the command to  advance
+       to  the  next tab stop can be given as <STRONG>ht</STRONG> (usually control
+       I).  A ``back-tab'' command which moves  leftward  to  the
        preceding tab stop can be given as <STRONG>cbt</STRONG>.  By convention, if
-       the  teletype  modes indicate that tabs are being expanded
-       by the computer rather than being sent  to  the  terminal,
-       programs  should  not  use <STRONG>ht</STRONG> or <STRONG>cbt</STRONG> even if they are pre-
-       sent, since the user may not have the tab  stops  properly
-       set.   If  the  terminal  has hardware tabs which are ini-
+       the teletype modes indicate that tabs are  being  expanded
+       by  the  computer  rather than being sent to the terminal,
+       programs should not use <STRONG>ht</STRONG> or <STRONG>cbt</STRONG> even if  they  are  pre-
+       sent,  since  the user may not have the tab stops properly
+       set.  If the terminal has hardware  tabs  which  are  ini-
        tially set every <EM>n</EM> spaces when the terminal is powered up,
-       the  numeric  parameter <STRONG>it</STRONG> is given, showing the number of
-       spaces the tabs are set to.  This is normally used by  the
-       <EM>tset</EM>  command  to  determine  whether  to set the mode for
-       hardware tab expansion, and whether to set the tab  stops.
-       If  the  terminal  has tab stops that can be saved in non-
-       volatile memory, the terminfo description can assume  that
+       the numeric parameter <STRONG>it</STRONG> is given, showing the  number  of
+       spaces  the tabs are set to.  This is normally used by the
+       <EM>tset</EM> command to determine whether  to  set  the  mode  for
+       hardware  tab expansion, and whether to set the tab stops.
+       If the terminal has tab stops that can be  saved  in  non-
+       volatile  memory, the terminfo description can assume that
        they are properly set.
 
-       Other  capabilities include <STRONG>is1</STRONG>, <STRONG>is2</STRONG>, and <STRONG>is3</STRONG>, initializa-
-       tion strings for the terminal, <STRONG>iprog</STRONG>, the path name  of  a
-       program  to be run to initialize the terminal, and <STRONG>if</STRONG>, the
-       name of a file  containing  long  initialization  strings.
-       These  strings are expected to set the terminal into modes
-       consistent with the  rest  of  the  terminfo  description.
+       Other capabilities include <STRONG>is1</STRONG>, <STRONG>is2</STRONG>, and <STRONG>is3</STRONG>,  initializa-
+       tion  strings  for the terminal, <STRONG>iprog</STRONG>, the path name of a
+       program to be run to initialize the terminal, and <STRONG>if</STRONG>,  the
+       name  of  a  file  containing long initialization strings.
+       These strings are expected to set the terminal into  modes
+       consistent  with  the  rest  of  the terminfo description.
        They are normally sent to the terminal, by the <EM>init</EM> option
-       of the <EM>tput</EM> program, each time the  user  logs  in.   They
-       will  be  printed  in the following order: run the program
-       <STRONG>iprog</STRONG>; output <STRONG>is1</STRONG>; <STRONG>is2</STRONG>; set the margins  using  <STRONG>mgc</STRONG>,  <STRONG>smgl</STRONG>
-       and  <STRONG>smgr</STRONG>;  set tabs using <STRONG>tbc</STRONG> and <STRONG>hts</STRONG>; print the file <STRONG>if</STRONG>;
+       of  the  <EM>tput</EM>  program,  each time the user logs in.  They
+       will be printed in the following order:  run  the  program
+       <STRONG>iprog</STRONG>;  output  <STRONG>is1</STRONG>;  <STRONG>is2</STRONG>; set the margins using <STRONG>mgc</STRONG>, <STRONG>smgl</STRONG>
+       and <STRONG>smgr</STRONG>; set tabs using <STRONG>tbc</STRONG> and <STRONG>hts</STRONG>; print the  file  <STRONG>if</STRONG>;
        and finally output <STRONG>is3</STRONG>.
 
-       Most initialization is done with  <STRONG>is2</STRONG>.   Special  terminal
+       Most  initialization  is  done with <STRONG>is2</STRONG>.  Special terminal
        modes can be set up without duplicating strings by putting
-       the common sequences in <STRONG>is2</STRONG> and special cases in  <STRONG>is1</STRONG>  and
-       <STRONG>is3</STRONG>.   A pair of sequences that does a harder reset from a
-       totally unknown state can be  analogously  given  as  <STRONG>rs1</STRONG>,
-       <STRONG>rs2</STRONG>,  <STRONG>rf</STRONG>, and <STRONG>rs3</STRONG>, analogous to <STRONG>is2</STRONG> and <STRONG>if</STRONG>.  These strings
-       are output by the <EM>reset</EM> program, which is  used  when  the
-       terminal  gets into a wedged state.  Commands are normally
-       placed in <STRONG>rs1</STRONG>, <STRONG>rs2</STRONG> <STRONG>rs3</STRONG> and <STRONG>rf</STRONG> only if they produce  annoy-
-       ing  effects on the screen and are not necessary when log-
-       ging in.  For example, the command to set the  vt100  into
-       80-column  mode  would  normally  be  part  of <STRONG>is2</STRONG>, but it
-       causes an annoying glitch of the screen and  is  not  nor-
-       mally  needed  since the terminal is usually already in 80
+       the  common  sequences in <STRONG>is2</STRONG> and special cases in <STRONG>is1</STRONG> and
+       <STRONG>is3</STRONG>.  A pair of sequences that does a harder reset from  a
+       totally  unknown  state  can  be analogously given as <STRONG>rs1</STRONG>,
+       <STRONG>rs2</STRONG>, <STRONG>rf</STRONG>, and <STRONG>rs3</STRONG>, analogous to <STRONG>is2</STRONG> and <STRONG>if</STRONG>.  These  strings
+       are  output  by  the <EM>reset</EM> program, which is used when the
+       terminal gets into a wedged state.  Commands are  normally
+       placed  in <STRONG>rs1</STRONG>, <STRONG>rs2</STRONG> <STRONG>rs3</STRONG> and <STRONG>rf</STRONG> only if they produce annoy-
+       ing effects on the screen and are not necessary when  log-
+       ging  in.   For example, the command to set the vt100 into
+       80-column mode would normally  be  part  of  <STRONG>is2</STRONG>,  but  it
+       causes  an  annoying  glitch of the screen and is not nor-
+       mally needed since the terminal is usually already  in  80
        column mode.
 
        If there are commands to set and clear tab stops, they can
-       be  given  as <STRONG>tbc</STRONG> (clear all tab stops) and <STRONG>hts</STRONG> (set a tab
-       stop in the current column of every row).  If a more  com-
-       plex  sequence  is  needed  to  set  the  tabs than can be
-       described by this, the sequence can be placed  in  <STRONG>is2</STRONG>  or
+       be given as <STRONG>tbc</STRONG> (clear all tab stops) and <STRONG>hts</STRONG> (set  a  tab
+       stop  in the current column of every row).  If a more com-
+       plex sequence is needed  to  set  the  tabs  than  can  be
+       described  by  this,  the sequence can be placed in <STRONG>is2</STRONG> or
        <STRONG>if</STRONG>.
 
    <STRONG>Delays</STRONG> <STRONG>and</STRONG> <STRONG>Padding</STRONG>
-       Many  older  and  slower  terminals  don't  support either
+       Many older  and  slower  terminals  don't  support  either
        XON/XOFF or DTR handshaking, including hard copy terminals
-       and  some  very  archaic CRTs (including, for example, DEC
-       VT100s).  These may require padding characters after  cer-
+       and some very archaic CRTs (including,  for  example,  DEC
+       VT100s).   These may require padding characters after cer-
        tain cursor motions and screen changes.
 
        If the terminal uses xon/xoff handshaking for flow control
-       (that is, it automatically emits ^S back to the host  when
+       (that  is, it automatically emits ^S back to the host when
        its input buffers are close to full), set <STRONG>xon</STRONG>.  This capa-
-       bility suppresses the emission of padding.  You  can  also
-       set  it for memory-mapped console devices effectively that
-       don't have a  speed  limit.   Padding  information  should
-       still  be  included so that routines can make better deci-
+       bility  suppresses  the emission of padding.  You can also
+       set it for memory-mapped console devices effectively  that
+       don't  have  a  speed  limit.   Padding information should
+       still be included so that routines can make  better  deci-
        sions about relative costs, but actual pad characters will
        not be transmitted.
 
-       If  <STRONG>pb</STRONG> (padding baud rate) is given, padding is suppressed
-       at baud rates below the value of <STRONG>pb</STRONG>.  If the entry has  no
-       padding  baud rate, then whether padding is emitted or not
+       If <STRONG>pb</STRONG> (padding baud rate) is given, padding is  suppressed
+       at  baud rates below the value of <STRONG>pb</STRONG>.  If the entry has no
+       padding baud rate, then whether padding is emitted or  not
        is completely controlled by <STRONG>xon</STRONG>.
 
-       If the terminal requires other than a null (zero)  charac-
-       ter  as  a  pad,  then this can be given as <STRONG>pad</STRONG>.  Only the
+       If  the terminal requires other than a null (zero) charac-
+       ter as a pad, then this can be given  as  <STRONG>pad</STRONG>.   Only  the
        first character of the <STRONG>pad</STRONG> string is used.
 
 
    <STRONG>Status</STRONG> <STRONG>Lines</STRONG>
-       Some terminals have an extra `status line'  which  is  not
-       normally  used  by  software  (and thus not counted in the
+       Some  terminals  have  an extra `status line' which is not
+       normally used by software (and thus  not  counted  in  the
        terminal's <STRONG>lines</STRONG> capability).
 
-       The simplest case  is  a  status  line  which  is  cursor-
-       addressable  but  not part of the main scrolling region on
-       the screen; the Heathkit H19 has a  status  line  of  this
-       kind,  as  would  a 24-line VT100 with a 23-line scrolling
-       region set up on initialization.  This situation is  indi-
+       The  simplest  case  is  a  status  line  which is cursor-
+       addressable but not part of the main scrolling  region  on
+       the  screen;  the  Heathkit  H19 has a status line of this
+       kind, as would a 24-line VT100 with  a  23-line  scrolling
+       region  set up on initialization.  This situation is indi-
        cated by the <STRONG>hs</STRONG> capability.
 
        Some terminals with status lines need special sequences to
-       access the status line.   These  may  be  expressed  as  a
+       access  the  status  line.   These  may  be expressed as a
        string with single parameter <STRONG>tsl</STRONG> which takes the cursor to
-       a given zero-origin column on the status line.  The  capa-
+       a  given zero-origin column on the status line.  The capa-
        bility <STRONG>fsl</STRONG> must return to the main-screen cursor positions
-       before the last <STRONG>tsl</STRONG>.  You may need  to  embed  the  string
-       values  of <STRONG>sc</STRONG> (save cursor) and <STRONG>rc</STRONG> (restore cursor) in <STRONG>tsl</STRONG>
+       before  the  last  <STRONG>tsl</STRONG>.   You may need to embed the string
+       values of <STRONG>sc</STRONG> (save cursor) and <STRONG>rc</STRONG> (restore cursor) in  <STRONG>tsl</STRONG>
        and <STRONG>fsl</STRONG> to accomplish this.
 
-       The status line is normally assumed to be the  same  width
-       as  the width of the terminal.  If this is untrue, you can
+       The  status  line is normally assumed to be the same width
+       as the width of the terminal.  If this is untrue, you  can
        specify it with the numeric capability <STRONG>wsl</STRONG>.
 
-       A command to erase or blank the status line may be  speci-
+       A  command to erase or blank the status line may be speci-
        fied as <STRONG>dsl</STRONG>.
 
-       The   boolean   capability  <STRONG>eslok</STRONG>  specifies  that  escape
+       The  boolean  capability  <STRONG>eslok</STRONG>  specifies   that   escape
        sequences, tabs, etc., work ordinarily in the status line.
 
-       The  <STRONG>ncurses</STRONG>  implementation does not yet use any of these
-       capabilities.  They are documented here in case they  ever
+       The <STRONG>ncurses</STRONG> implementation does not yet use any  of  these
+       capabilities.   They are documented here in case they ever
        become important.
 
 
    <STRONG>Line</STRONG> <STRONG>Graphics</STRONG>
-       Many  terminals  have  alternate character sets useful for
-       forms-drawing.  Terminfo and <STRONG>curses</STRONG> build in  support  for
-       the  drawing  characters supported by the VT100, with some
-       characters from the AT&amp;T  4410v1  added.   This  alternate
+       Many terminals have alternate character  sets  useful  for
+       forms-drawing.   Terminfo  and <STRONG>curses</STRONG> build in support for
+       the drawing characters supported by the VT100,  with  some
+       characters  from  the  AT&amp;T  4410v1 added.  This alternate
        character set may be specified by the <STRONG>acsc</STRONG> capability.
 
                 <STRONG>Glyph</STRONG>             <STRONG>ACS</STRONG>            <STRONG>Ascii</STRONG>      <STRONG>VT100</STRONG>
@@ -1803,6 +1838,7 @@
        greater-than-or-equal-to   ACS_GEQUAL     &gt;          z
        greek pi                   ACS_PI         *          {
        horizontal line            ACS_HLINE      -          q
+
        lantern symbol             ACS_LANTERN    #          i
        large plus or crossover    ACS_PLUS       +          n
        less-than-or-equal-to      ACS_LEQUAL     &lt;          y
@@ -1823,59 +1859,59 @@
        upper right corner         ACS_URCORNER   +          k
        vertical line              ACS_VLINE      |          x
 
-       The  best  way to define a new device's graphics set is to
-       add a column to a copy of this table  for  your  terminal,
-       giving   the   character   which   (when  emitted  between
-       <STRONG>smacs</STRONG>/<STRONG>rmacs</STRONG> switches) will be rendered as the  correspond-
-       ing  graphic.  Then read off the VT100/your terminal char-
-       acter pairs right to left in sequence;  these  become  the
+       The best way to define a new device's graphics set  is  to
+       add  a  column  to a copy of this table for your terminal,
+       giving  the  character   which   (when   emitted   between
+       <STRONG>smacs</STRONG>/<STRONG>rmacs</STRONG>  switches) will be rendered as the correspond-
+       ing graphic.  Then read off the VT100/your terminal  char-
+       acter  pairs  right  to left in sequence; these become the
        ACSC string.
 
 
    <STRONG>Color</STRONG> <STRONG>Handling</STRONG>
-       Most  color  terminals are either `Tektronix-like' or `HP-
-       like'.  Tektronix-like terminals have a predefined set  of
-       N  colors  (where N usually 8), and can set character-cell
+       Most color terminals are either `Tektronix-like'  or  `HP-
+       like'.   Tektronix-like terminals have a predefined set of
+       N colors (where N usually 8), and can  set  character-cell
        foreground and background characters independently, mixing
-       them  into  N  * N color-pairs.  On HP-like terminals, the
+       them into N * N color-pairs.  On  HP-like  terminals,  the
        use must set each color pair up separately (foreground and
-       background  are  not  independently  settable).   Up  to M
-       color-pairs may be  set  up  from  2*M  different  colors.
+       background are  not  independently  settable).   Up  to  M
+       color-pairs  may  be  set  up  from  2*M different colors.
        ANSI-compatible terminals are Tektronix-like.
 
        Some basic color capabilities are independent of the color
        method.  The numeric capabilities <STRONG>colors</STRONG> and <STRONG>pairs</STRONG> specify
-       the  maximum numbers of colors and color-pairs that can be
-       displayed simultaneously.  The <STRONG>op</STRONG> (original  pair)  string
-       resets  foreground  and background colors to their default
-       values for the terminal.  The <STRONG>oc</STRONG> string resets all  colors
-       or  color-pairs  to their default values for the terminal.
-       Some terminals  (including  many  PC  terminal  emulators)
-       erase  screen  areas  with  the  current  background color
-       rather than the power-up default background; these  should
+       the maximum numbers of colors and color-pairs that can  be
+       displayed  simultaneously.   The <STRONG>op</STRONG> (original pair) string
+       resets foreground and background colors to  their  default
+       values  for the terminal.  The <STRONG>oc</STRONG> string resets all colors
+       or color-pairs to their default values for  the  terminal.
+       Some  terminals  (including  many  PC  terminal emulators)
+       erase screen  areas  with  the  current  background  color
+       rather  than the power-up default background; these should
        have the boolean capability <STRONG>bce</STRONG>.
 
-       To  change the current foreground or background color on a
-       Tektronix-type terminal, use <STRONG>setaf</STRONG> (set  ANSI  foreground)
-       and  <STRONG>setab</STRONG>  (set ANSI background) or <STRONG>setf</STRONG> (set foreground)
-       and <STRONG>setb</STRONG> (set background).  These take one parameter,  the
+       To change the current foreground or background color on  a
+       Tektronix-type  terminal,  use <STRONG>setaf</STRONG> (set ANSI foreground)
+       and <STRONG>setab</STRONG> (set ANSI background) or <STRONG>setf</STRONG>  (set  foreground)
+       and  <STRONG>setb</STRONG> (set background).  These take one parameter, the
        color  number.   The  SVr4  documentation  describes  only
-       <STRONG>setaf</STRONG>/<STRONG>setab</STRONG>; the XPG4 draft says  that  "If  the  terminal
+       <STRONG>setaf</STRONG>/<STRONG>setab</STRONG>;  the  XPG4  draft  says that "If the terminal
        supports ANSI escape sequences to set background and fore-
-       ground, they should be coded as <STRONG>setaf</STRONG> and  <STRONG>setab</STRONG>,  respec-
-       tively.   If  the terminal supports other escape sequences
-       to set background and foreground, they should be coded  as
-       <STRONG>setf</STRONG>  and  <STRONG>setb</STRONG>, respectively.  The <EM>vidputs()</EM> function and
-       the refresh functions use <STRONG>setaf</STRONG>  and  <STRONG>setab</STRONG>  if  they  are
+       ground,  they  should be coded as <STRONG>setaf</STRONG> and <STRONG>setab</STRONG>, respec-
+       tively.  If the terminal supports other  escape  sequences
+       to  set background and foreground, they should be coded as
+       <STRONG>setf</STRONG> and <STRONG>setb</STRONG>, respectively.  The <EM>vidputs()</EM>  function  and
+       the  refresh  functions  use  <STRONG>setaf</STRONG>  and <STRONG>setab</STRONG> if they are
        defined."
 
-       The  <STRONG>setaf</STRONG>/<STRONG>setab</STRONG>  and <STRONG>setf</STRONG>/<STRONG>setb</STRONG> capabilities take a single
-       numeric argument each.  Argument values 0-7  are  portably
-       defined  as  follows  (the  middle  column is the symbolic
-       #define available in the header for the <STRONG>curses</STRONG> or  <STRONG>ncurses</STRONG>
-       libraries).  The terminal hardware is free to map these as
-       it likes, but the RGB values indicate normal locations  in
-       color space.
+       The <STRONG>setaf</STRONG>/<STRONG>setab</STRONG> and <STRONG>setf</STRONG>/<STRONG>setb</STRONG> capabilities take  a  single
+       numeric argument each.  Argument values 0-7 of <STRONG>setaf</STRONG>/<STRONG>setab</STRONG>
+       are portably defined as follows (the middle column is  the
+       symbolic #define available in the header for the <STRONG>curses</STRONG> or
+       <STRONG>ncurses</STRONG> libraries).  The terminal hardware is free to  map
+       these  as  it  likes,  but  the RGB values indicate normal
+       locations in color space.
 
              <STRONG>Color</STRONG>       <STRONG>#define</STRONG>       <STRONG>Value</STRONG>       <STRONG>RGB</STRONG>
              black     <STRONG>COLOR_BLACK</STRONG>       0     0, 0, 0
@@ -1887,6 +1923,21 @@
              cyan      <STRONG>COLOR_CYAN</STRONG>        6     0,max,max
              white     <STRONG>COLOR_WHITE</STRONG>       7     max,max,max
 
+       The argument values of <STRONG>setf</STRONG>/<STRONG>setb</STRONG>  historically  correspond
+       to a different mapping, i.e.,
+             <STRONG>Color</STRONG>       <STRONG>#define</STRONG>       <STRONG>Value</STRONG>       <STRONG>RGB</STRONG>
+             black     <STRONG>COLOR_BLACK</STRONG>       0     0, 0, 0
+             blue      <STRONG>COLOR_BLUE</STRONG>        1     0,0,max
+             green     <STRONG>COLOR_GREEN</STRONG>       2     0,max,0
+             cyan      <STRONG>COLOR_CYAN</STRONG>        3     0,max,max
+             red       <STRONG>COLOR_RED</STRONG>         4     max,0,0
+             magenta   <STRONG>COLOR_MAGENTA</STRONG>     5     max,0,max
+             yellow    <STRONG>COLOR_YELLOW</STRONG>      6     max,max,0
+             white     <STRONG>COLOR_WHITE</STRONG>       7     max,max,max
+       It is important to not confuse the two sets of color capa-
+       bilities; otherwise red/blue will be interchanged  on  the
+       display.
+
        On  an  HP-like terminal, use <STRONG>scp</STRONG> with a color-pair number
        parameter to set which color pair is current.
 
@@ -2005,7 +2056,6 @@
        text,  including  <STRONG>mc4</STRONG>,  is  transparently  passed  to  the
        printer while an <STRONG>mc5p</STRONG> is in effect.
 
-
    <STRONG>Glitches</STRONG> <STRONG>and</STRONG> <STRONG>Braindamage</STRONG>
        Hazeltine terminals, which do not allow `~' characters  to
        be displayed should indicate <STRONG>hz</STRONG>.
@@ -2055,6 +2105,7 @@
        A capability can be canceled by placing <STRONG>xx@</STRONG> to the left of
        the  use  reference that imports it, where <EM>xx</EM> is the capa-
        bility.  For example, the entry
+
                    2621-nl, smkx@, rmkx@, use=2621,
 
        defines a 2621-nl that does not  have  the  <STRONG>smkx</STRONG>  or  <STRONG>rmkx</STRONG>
@@ -2222,16 +2273,19 @@
                                 descriptions
 
 
-
 </PRE>
 <H2>SEE ALSO</H2><PRE>
        <STRONG><A HREF="tic.1m.html">tic(1m)</A></STRONG>, <STRONG><A HREF="ncurses.3x.html">curses(3x)</A></STRONG>, <STRONG><A HREF="printf.3S.html">printf(3S)</A></STRONG>, <STRONG><A HREF="term.5.html">term(5)</A></STRONG>.
 
 
+
 </PRE>
 <H2>AUTHORS</H2><PRE>
        Zeyd  M.  Ben-Halim,  Eric  S.  Raymond, Thomas E. Dickey.
        Based on pcurses by Pavel Curtis.
+
+
+
 
 
 
Index: doc/html/man/tic.1m.html
--- ncurses-5.3-20021012/doc/html/man/tic.1m.html	Sat Oct 12 19:28:15 2002
+++ ncurses-5.3-20030719/doc/html/man/tic.1m.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: tic.1m,v 1.33 2002/10/05 20:06:13 tom Exp @
+  * @Id: tic.1m,v 1.35 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -85,7 +85,7 @@
               entries as user-defined names.
 
        <STRONG>-C</STRONG>     Force source translation to termcap format.   Note:
-              this  differs  from the -C option of <STRONG><A HREF="infocmp.1m.html">infocmp(1m)</A></STRONG> in
+              this  differs  from the <STRONG>-C</STRONG> option of <STRONG><A HREF="infocmp.1m.html">infocmp(1m)</A></STRONG> in
               that it does not merely translate capability names,
               but  also  translates  terminfo  strings to termcap
               format.  Capabilities that are not translatable are
@@ -110,7 +110,7 @@
               it.  The option value is interpreted as a file con-
               taining  the  list  if  it  contains a '/'.  (Note:
               depending on how tic was compiled, this option  may
-              require -I or -C.)
+              require <STRONG>-I</STRONG> or <STRONG>-C</STRONG>.)
 
        <STRONG>-f</STRONG>     Display  complex  terminfo  strings  which  contain
               if/then/else/endif expressions indented  for  read-
@@ -277,7 +277,7 @@
 
        The  <STRONG>-C</STRONG>,  <STRONG>-G</STRONG>,  <STRONG>-I</STRONG>, <STRONG>-N</STRONG>, <STRONG>-R</STRONG>, <STRONG>-T</STRONG>, <STRONG>-V</STRONG>, <STRONG>-a</STRONG>, <STRONG>-e</STRONG>, <STRONG>-f</STRONG>, <STRONG>-g</STRONG>, <STRONG>-o</STRONG>, <STRONG>-r</STRONG>,
        <STRONG>-s</STRONG>, <STRONG>-t</STRONG> and <STRONG>-x</STRONG> options are not supported under  SVr4.   The
-       SVr4 -c mode does not report bad use links.
+       SVr4 <STRONG>-c</STRONG> mode does not report bad use links.
 
        System  V does not compile entries to or read entries from
        your <EM>$HOME/.terminfo</EM> directory unless TERMINFO is  explic-
Index: doc/html/man/toe.1m.html
--- ncurses-5.3-20021012/doc/html/man/toe.1m.html	Sat Jun 22 17:25:46 2002
+++ ncurses-5.3-20030719/doc/html/man/toe.1m.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: toe.1m,v 1.10 2000/08/19 18:51:05 tom Exp @
+  * @Id: toe.1m,v 1.12 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -57,7 +57,7 @@
        primary name with descriptions.   File  arguments  specify
        the  directories  to  be scanned; if no such arguments are
        given, your default terminfo directory is scanned.  If you
-       also  specify  the  -h  option, a directory header will be
+       also  specify  the  <STRONG>-h</STRONG>  option, a directory header will be
        issued as each directory is entered.
 
        There are other options intended for use by terminfo  file
Index: doc/html/man/tput.1.html
--- ncurses-5.3-20021012/doc/html/man/tput.1.html	Sat Oct 12 19:28:16 2002
+++ ncurses-5.3-20030719/doc/html/man/tput.1.html	Sat May 31 19:03:58 2003
@@ -2,7 +2,7 @@
 <!-- 
   * t
   ****************************************************************************
-  * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+  * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: tput.1,v 1.18 2002/10/12 13:53:20 tom Exp @
+  * @Id: tput.1,v 1.20 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
Index: doc/html/man/tset.1.html
--- ncurses-5.3-20021012/doc/html/man/tset.1.html	Sat Jun 22 17:25:47 2002
+++ ncurses-5.3-20030719/doc/html/man/tset.1.html	Sat May 31 19:03:58 2003
@@ -1,7 +1,7 @@
 <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
 <!-- 
   ****************************************************************************
-  * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+  * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
   *                                                                          *
   * Permission is hereby granted, free of charge, to any person obtaining a  *
   * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
   * sale, use or other dealings in this Software without prior written       *
   * authorization.                                                           *
   ****************************************************************************
-  * @Id: tset.1,v 1.12 2000/09/09 20:33:07 tom Exp @
+  * @Id: tset.1,v 1.13 2003/05/11 00:32:53 tom Exp @
 -->
 <HTML>
 <HEAD>
@@ -73,7 +73,7 @@
        4. The default terminal type, ``unknown''.
 
        If  the  terminal  type  was not specified on the command-
-       line, the -m option mappings are then applied  (see  below
+       line, the <STRONG>-m</STRONG> option mappings are then applied  (see  below
        for  more information).  Then, if the terminal type begins
        with a question mark (``?''), the  user  is  prompted  for
        confirmation of the terminal type.  An empty response con-
@@ -108,36 +108,36 @@
 
        The options are as follows:
 
-       -q   The  terminal  type is displayed to the standard out-
+       <STRONG>-q</STRONG>   The  terminal  type is displayed to the standard out-
             put, and the terminal is not initialized in any  way.
             The option `-' by itself is equivalent but archaic.
 
-       -e   Set the erase character to <EM>ch</EM>.
+       <STRONG>-e</STRONG>   Set the erase character to <EM>ch</EM>.
 
-       -I   Do  not  send  the  terminal  or  tab  initialization
+       <STRONG>-I</STRONG>   Do  not  send  the  terminal  or  tab  initialization
             strings to the terminal.
 
-       -Q   Don't display any values for the erase, interrupt and
+       <STRONG>-Q</STRONG>   Don't display any values for the erase, interrupt and
             line kill characters.
 
        <STRONG>-V</STRONG>   reports the version of ncurses which was used in this
             program, and exits.
 
-       -i   Set the interrupt character to <EM>ch</EM>.
+       <STRONG>-i</STRONG>   Set the interrupt character to <EM>ch</EM>.
 
-       -k   Set the line kill character to <EM>ch</EM>.
+       <STRONG>-k</STRONG>   Set the line kill character to <EM>ch</EM>.
 
-       -m   Specify a mapping from a port  type  to  a  terminal.
+       <STRONG>-m</STRONG>   Specify a mapping from a port  type  to  a  terminal.
             See below for more information.
 
-       -r   Print the terminal type to the standard error output.
+       <STRONG>-r</STRONG>   Print the terminal type to the standard error output.
 
-       -s   Print the sequence of shell  commands  to  initialize
+       <STRONG>-s</STRONG>   Print the sequence of shell  commands  to  initialize
             the environment variable <STRONG>TERM</STRONG> to the standard output.
             See the section below on setting the environment  for
             details.
 
-       The arguments for the -e, -i, and -k options may either be
+       The arguments for the <STRONG>-e</STRONG>, <STRONG>-i</STRONG>, and <STRONG>-k</STRONG> options may either be
        entered as actual characters or by using the  `hat'  nota-
        tion, i.e. control-h may be specified as ``^H'' or ``^h''.
 
@@ -146,9 +146,9 @@
 <H2>SETTING THE ENVIRONMENT</H2><PRE>
        It is often desirable  to  enter  the  terminal  type  and
        information  about  the  terminal's  capabilities into the
-       shell's environment.  This is done using the -s option.
+       shell's environment.  This is done using the <STRONG>-s</STRONG> option.
 
-       When the -s option is specified, the commands to enter the
+       When the <STRONG>-s</STRONG> option is specified, the commands to enter the
        information  into  the  shell's environment are written to
        the standard output.  If the <STRONG>SHELL</STRONG> environmental  variable
        ends in ``csh'', the commands are for <STRONG>csh</STRONG>, otherwise, they
@@ -171,12 +171,12 @@
        often desirable to provide information about the  type  of
        terminal used on such ports.
 
-       The  purpose  of  the -m option is to map from some set of
+       The  purpose  of  the <STRONG>-m</STRONG> option is to map from some set of
        conditions to a terminal type, that is, to tell <STRONG>tset</STRONG>  ``If
        I'm  on this port at a particular speed, guess that I'm on
        that kind of terminal''.
 
-       The argument to the -m option consists of an optional port
+       The argument to the <STRONG>-m</STRONG> option consists of an optional port
        type, an optional operator, an optional baud rate specifi-
        cation, an optional colon (``:'') character and a terminal
        type.   The port type is a string (delimited by either the
@@ -189,7 +189,7 @@
        terminal).  The terminal type is a string.
 
        If the terminal type is not specified on the command line,
-       the  -m mappings are applied to the terminal type.  If the
+       the  <STRONG>-m</STRONG> mappings are applied to the terminal type.  If the
        port type and baud rate match the  mapping,  the  terminal
        type  specified  in the mapping replaces the current type.
        If more than one mapping is specified, the first  applica-
@@ -213,9 +213,9 @@
        user will be queried on a default port as to whether  they
        are actually using an xterm terminal.
 
-       No  whitespace  characters  are permitted in the -m option
+       No  whitespace  characters  are permitted in the <STRONG>-m</STRONG> option
        argument.  Also, to avoid problems  with  meta-characters,
-       it  is  suggested  that  the  entire -m option argument be
+       it  is  suggested  that  the  entire <STRONG>-m</STRONG> option argument be
        placed within single quote characters, and that <STRONG>csh</STRONG>  users
        insert  a  backslash character (``\'') before any exclama-
        tion marks (``!'').
@@ -238,8 +238,8 @@
        important  use).   This implementation behaves like 4.4BSD
        tset, with a few exceptions specified here.
 
-       The -S option of BSD tset no longer works;  it  prints  an
-       error message to stderr and dies.  The -s option only sets
+       The <STRONG>-S</STRONG> option of BSD tset no longer works;  it  prints  an
+       error message to stderr and dies.  The <STRONG>-s</STRONG> option only sets
        <STRONG>TERM</STRONG>, not <STRONG>TERMCAP</STRONG>.  Both these  changes  are  because  the
        <STRONG>TERMCAP</STRONG>  variable  is  no longer supported under terminfo-
        based <STRONG>ncurses</STRONG>, which makes <STRONG>tset</STRONG> <STRONG>-S</STRONG> useless (we made it die
@@ -250,28 +250,28 @@
        ning  with  an  upper-case letter) set the terminal to use
        upper-case only.  This feature has been omitted.
 
-       The -A, -E, -h, -u and -v options were  deleted  from  the
-       <STRONG>tset</STRONG>  utility  in  4.4BSD. None of them were documented in
-       4.3BSD and all are of limited utility at best. The -a, -d,
-       and -p options are similarly not documented or useful, but
-       were retained as they appear to be in widespread use.   It
-       is  strongly  recommended  that  any  usage of these three
-       options be changed to use the -m option instead.   The  -n
-       option  remains, but has no effect.  The -adnp options are
-       therefore omitted from the usage summary above.
-
-       It is still permissible to specify  the  -e,  -i,  and  -k
-       options  without arguments, although it is strongly recom-
-       mended that such usage be fixed to explicitly specify  the
+       The <STRONG>-A</STRONG>, <STRONG>-E</STRONG>, <STRONG>-h</STRONG>, <STRONG>-u</STRONG> and <STRONG>-v</STRONG> options were  deleted  from  the
+       <STRONG>tset</STRONG>  utility  in 4.4BSD.  None of them were documented in
+       4.3BSD and all are of limited utility at best.  The <STRONG>-a</STRONG>, -,
+       and                                                      -
+       options are similarly not documented or useful,  but  were
+       retained  as  they  appear to be in widespread use.  It is
+       strongly recommended that any usage of these three options
+       be  changed  to  use the <STRONG>-m</STRONG> option instead.  The -n option
+       remains, but has no effect.  The <STRONG>-adnp</STRONG> options are  there-
+       fore omitted from the usage summary above.
+
+       It  is  still  permissible  to  specify the <STRONG>-e</STRONG>, <STRONG>-i</STRONG>, and <STRONG>-k</STRONG>
+       options without arguments, although it is strongly  recom-
+       mended  that such usage be fixed to explicitly specify the
        character.
 
-       As  of  4.4BSD,  executing <STRONG>tset</STRONG> as <STRONG>reset</STRONG> no longer implies
-       the -Q option.  Also, the interaction between the - option
+       As of 4.4BSD, executing <STRONG>tset</STRONG> as <STRONG>reset</STRONG>  no  longer  implies
+       the <STRONG>-Q</STRONG> option.  Also, the interaction between the - option
        and the <EM>terminal</EM> argument in some historic implementations
        of <STRONG>tset</STRONG> has been removed.
 
 
-
 </PRE>
 <H2>ENVIRONMENT</H2><PRE>
        The <STRONG>tset</STRONG> command uses the <STRONG>SHELL</STRONG> and <STRONG>TERM</STRONG> environment vari-
@@ -281,7 +281,7 @@
 </PRE>
 <H2>FILES</H2><PRE>
        /etc/ttys
-            system  port  name  to terminal type mapping database
+            system port name to terminal  type  mapping  database
             (BSD versions only).
 
        /usr/share/terminfo
Index: form/Makefile.in
Prereq:  1.36 
--- ncurses-5.3-20021012/form/Makefile.in	Sat Jan 19 20:49:17 2002
+++ ncurses-5.3-20030719/form/Makefile.in	Sat Jun  7 17:09:50 2003
@@ -1,6 +1,6 @@
-# $Id: Makefile.in,v 1.36 2002/01/20 01:49:17 tom Exp $
+# $Id: Makefile.in,v 1.38 2003/06/07 21:09:50 tom Exp $
 ##############################################################################
-# Copyright (c) 1998,1999,2000,2001,2002 Free Software Foundation, Inc.      #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -97,7 +97,7 @@
 REL_VERSION	= @cf_cv_rel_version@
 ABI_VERSION	= @cf_cv_abi_version@
 
-RANLIB		= @RANLIB@
+RANLIB		= @LIB_PREP@
 
 IMPORT_LIB	= @IMPORT_LIB@
 SHARED_LIB	= @SHARED_LIB@
Index: form/form.h
--- ncurses-5.3-20021012/form/form.h	Sat Jul 13 07:35:08 2002
+++ ncurses-5.3-20030719/form/form.h	Sat May  3 17:59:32 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -31,6 +31,8 @@
  *   Contact: http://www.familiepfeifer.de/Contact.aspx?Lang=en             *
  ****************************************************************************/
 
+/* $Id: form.h,v 0.15 2003/05/03 21:59:32 tom Exp $ */
+
 #ifndef FORM_H
 #define FORM_H
 
@@ -208,7 +210,7 @@
 #define REQ_DEL_CHAR	 (KEY_MAX + 34)	/* delete char at cursor	*/
 #define REQ_DEL_PREV	 (KEY_MAX + 35)	/* delete char before cursor	*/
 #define REQ_DEL_LINE	 (KEY_MAX + 36)	/* delete line at cursor	*/
-#define REQ_DEL_WORD	 (KEY_MAX + 37)	/* delete line at cursor	*/
+#define REQ_DEL_WORD	 (KEY_MAX + 37)	/* delete word at cursor	*/
 #define REQ_CLR_EOL	 (KEY_MAX + 38)	/* clear to end of line		*/
 #define REQ_CLR_EOF	 (KEY_MAX + 39)	/* clear to end of field	*/
 #define REQ_CLR_FIELD	 (KEY_MAX + 40)	/* clear entire field		*/
Index: form/frm_driver.c
Prereq:  1.39 
--- ncurses-5.3-20021012/form/frm_driver.c	Sat Jul  6 11:33:27 2002
+++ ncurses-5.3-20030719/form/frm_driver.c	Sat May  3 19:05:21 2003
@@ -32,7 +32,7 @@
  ****************************************************************************/
 #include "form.priv.h"
 
-MODULE_ID("$Id: frm_driver.c,v 1.39 2002/07/06 15:33:27 juergen Exp $")
+MODULE_ID("$Id: frm_driver.c,v 1.42 2003/05/03 23:05:21 tom Exp $")
 
 /*----------------------------------------------------------------------------
   This is the core module of the form library. It contains the majority
@@ -42,7 +42,7 @@
   all the functions in this module depends on some others in the module,
   so it makes no sense to split them into separate files because they
   will always be linked together. The only acceptable concern is turnaround
-  time for this module, but now we have all Pentiums or Riscs, so what!
+  time for this module, but now we have all Pentiums or RISCs, so what!
 
   The driver routines are grouped into nine generic categories:
 
@@ -55,10 +55,10 @@
    c)   Intra-Field Navigation     ( all functions prefixed by IFN_ )
         The current position in the current field is changed. 
    d)   Vertical Scrolling         ( all functions prefixed by VSC_ )
-        Esseantially this is a specialization of Intra-Field navigation.
+        Essentially this is a specialization of Intra-Field navigation.
         It has to check for a multi-line field.
    e)   Horizontal Scrolling       ( all functions prefixed by HSC_ )
-        Esseantially this is a specialization of Intra-Field navigation.
+        Essentially this is a specialization of Intra-Field navigation.
         It has to check for a single-line field.
    f)   Field Editing              ( all functions prefixed by FE_ )
         The content of the current field is changed
@@ -79,11 +79,11 @@
 
 /*
 Some options that may effect compatibility in behavior to SVr4 forms,
-but they are here to allow a more intuitive and user friendly behaviour of
+but they are here to allow a more intuitive and user friendly behavior of
 our form implementation. This doesn't affect the API, so we feel it is
 uncritical.
 
-The initial implementation tries to stay very close with the behaviour
+The initial implementation tries to stay very close with the behavior
 of the original SVr4 implementation, although in some areas it is quite
 clear that this isn't the most appropriate way. As far as possible this
 sources will allow you to build a forms lib that behaves quite similar
@@ -91,9 +91,9 @@
 Perhaps at some time we will make this configurable at runtime.
 */
 
-/* Implement a more user-friendly previous/next word behaviour */
+/* Implement a more user-friendly previous/next word behavior */
 #define FRIENDLY_PREV_NEXT_WORD (1)
-/* Fix the wrong behaviour for forms with all fields inactive */
+/* Fix the wrong behavior for forms with all fields inactive */
 #define FIX_FORM_INACTIVE_BUG (1)
 /* Allow dynamic field growth also when navigating past the end */
 #define GROW_IF_NAVIGATE (1)
@@ -918,7 +918,7 @@
 |   
 |   Description   :  Propagate the Synchronize_Field function to all linked
 |                    fields. The first error that occurs in the sequence
-|                    of updates is the returnvalue.
+|                    of updates is the return value.
 |
 |   Return Values :  E_OK                - success
 |                    E_BAD_ARGUMENT      - invalid field pointer 
@@ -1012,7 +1012,7 @@
 |   
 |   Description   :  If a fields options have changed, this routine is
 |                    called to propagate these changes to the screen and
-|                    to really change the behaviour of the field.
+|                    to really change the behavior of the field.
 |
 |   Return Values :  E_OK                - success
 |                    E_BAD_ARGUMENT      - invalid field pointer 
@@ -1089,7 +1089,7 @@
 	      (!single_line_field && (field->drows < field->maxgrow)))
 	    {
 	      field->status |= _MAY_GROW;
-	      /* a field with justification now changes its behaviour,
+	      /* a field with justification now changes its behavior,
 		 so we must redisplay it */
 	      if (single_line_field                 &&
 		  (field->just != NO_JUSTIFICATION) &&
@@ -2141,7 +2141,7 @@
   int res = E_REQUEST_DENIED;
 
   /* We have to deal here with the specific case of the overloaded 
-     behaviour of New_Line and Delete_Previous requests.
+     behavior of New_Line and Delete_Previous requests.
      They may end up in navigational requests if we are on the first
      character in a field. But navigation is also allowed on non-
      editable fields.
@@ -2205,6 +2205,7 @@
 	{
 	  if (!(form->opts & O_NL_OVERLOAD))
 	    return(E_REQUEST_DENIED);
+	  wmove(form->w,form->currow,form->curcol);
 	  wclrtoeol(form->w);
 	  /* we have to set this here, although it is also
 	     handled in the generic routine. The reason is,
@@ -2221,6 +2222,7 @@
 		 a single-line field */
 	      return(E_SYSTEM_ERROR);
 	    }
+	  wmove(form->w,form->currow,form->curcol);
 	  wclrtoeol(form->w);
 	  form->currow++;
 	  form->curcol = 0;
@@ -2248,6 +2250,7 @@
 	  
 	  bp= Address_Of_Current_Position_In_Buffer(form);
 	  t = After_End_Of_Data(bp,field->dcols - form->curcol);
+	  wmove(form->w,form->currow,form->curcol);
 	  wclrtoeol(form->w);
 	  form->currow++;
 	  form->curcol=0;
@@ -2338,6 +2341,7 @@
 +--------------------------------------------------------------------------*/
 static int FE_Delete_Character(FORM * form)
 {
+  wmove(form->w,form->currow,form->curcol);
   wdelch(form->w);
   return E_OK;
 }
@@ -2378,6 +2382,7 @@
       if ((int)(this_end-this_line) > 
 	  (field->cols-(int)(prev_end-prev_line))) 
 	return E_REQUEST_DENIED;
+      wmove(form->w,form->currow,form->curcol);
       wdeleteln(form->w);
       Adjust_Cursor_Position(form,prev_end);
       wmove(form->w,form->currow,form->curcol);
@@ -2455,20 +2460,22 @@
 +--------------------------------------------------------------------------*/
 static int FE_Clear_To_End_Of_Line(FORM * form)
 {
+  wmove(form->w,form->currow,form->curcol);
   wclrtoeol(form->w);
   return E_OK;
 }
 
 /*---------------------------------------------------------------------------
 |   Facility      :  libnform  
-|   Function      :  static int FE_Clear_To_End_Of_Form(FORM * form)
+|   Function      :  static int FE_Clear_To_End_Of_Field(FORM * form)
 |   
-|   Description   :  Clear to end of form.
+|   Description   :  Clear to end of field.
 |
 |   Return Values :  E_OK   - success
 +--------------------------------------------------------------------------*/
-static int FE_Clear_To_End_Of_Form(FORM * form)
+static int FE_Clear_To_End_Of_Field(FORM * form)
 {
+  wmove(form->w,form->currow,form->curcol);
   wclrtobot(form->w);
   return E_OK;
 }
@@ -3053,7 +3060,7 @@
 |                                           int (* const fct) (FORM *),
 |                                           FORM * form)
 |   
-|   Description   :  Generic behaviour for changing the current field, the
+|   Description   :  Generic behavior for changing the current field, the
 |                    field is left and a new field is entered. So the field
 |                    must be validated and the field init/term hooks must
 |                    be called.
@@ -3366,7 +3373,7 @@
 |                                               int (* const fct) (FORM *),
 |                                               FORM * form)
 |   
-|   Description   :  Generic behaviour for changing a page. This means
+|   Description   :  Generic behavior for changing a page. This means
 |                    that the field is left and a new field is entered.
 |                    So the field must be validated and the field init/term
 |                    hooks must be called. Because also the page is changed,
@@ -3598,7 +3605,7 @@
   { REQ_DEL_LINE     |ID_FE  ,FE_Delete_Line},
   { REQ_DEL_WORD     |ID_FE  ,FE_Delete_Word},
   { REQ_CLR_EOL      |ID_FE  ,FE_Clear_To_End_Of_Line},
-  { REQ_CLR_EOF      |ID_FE  ,FE_Clear_To_End_Of_Form},
+  { REQ_CLR_EOF      |ID_FE  ,FE_Clear_To_End_Of_Field},
   { REQ_CLR_FIELD    |ID_FE  ,FE_Clear_Field},
   
   { REQ_OVL_MODE     |ID_EM  ,EM_Overlay_Mode},
Index: include/MKkey_defs.sh
Prereq:  1.10 
--- ncurses-5.3-20021012/include/MKkey_defs.sh	Sat Sep 28 19:32:16 2002
+++ ncurses-5.3-20030719/include/MKkey_defs.sh	Sat Jan 11 17:20:40 2003
@@ -1,7 +1,7 @@
 #! /bin/sh
-# $Id: MKkey_defs.sh,v 1.10 2002/09/28 23:32:16 tom Exp $
+# $Id: MKkey_defs.sh,v 1.11 2003/01/11 22:20:40 tom Exp $
 ##############################################################################
-# Copyright (c) 2001,2002 Free Software Foundation, Inc.                     #
+# Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -49,10 +49,10 @@
 if sort -k 6 $DATA >$data 2>/dev/null
 then
 	# POSIX
-	sed -e 's/[	]\+/	/g' < $DATA |sort -n -k 6 >$data
+	sed -e 's/[	][	]*/	/g' < $DATA |sort -n -k 6 >$data
 else
 	# SunOS (and SVr4, marked as obsolete but still recognized)
-	sed -e 's/[	]\+/	/g' < $DATA |sort -n +5 >$data
+	sed -e 's/[	][	]*/	/g' < $DATA |sort -n +5 >$data
 fi
 
 # add keys that we generate automatically:
Index: include/curses.h.in
Prereq:  1.134 
--- ncurses-5.3-20021012/include/curses.h.in	Sat Sep 28 11:08:06 2002
+++ ncurses-5.3-20030719/include/curses.h.in	Sun Jun 15 19:42:18 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -32,7 +32,7 @@
  *     and: Thomas E. Dickey 1996-on                                        *
  ****************************************************************************/
 
-/* $Id: curses.h.in,v 1.134 2002/09/28 15:08:06 tom Exp $ */
+/* $Id: curses.h.in,v 1.145 2003/06/15 23:42:18 tom Exp $ */
 
 #ifndef __NCURSES_H
 #define __NCURSES_H
@@ -125,7 +125,7 @@
 
 typedef @cf_cv_type_of_bool@ NCURSES_BOOL;
 
-#if (!defined(__cplusplus) || !@cf_cv_builtin_bool@) && (!@cf_cv_cc_bool_type@)
+#if @USE_CXX_BOOL@ /* !__cplusplus, etc. */
 
 #if @cf_cv_header_stdbool_h@
 #include <stdbool.h>
@@ -136,7 +136,7 @@
 #if @cf_cv_header_stdbool_h@
 #define bool NCURSES_BOOL
 #else
-typedef @cf_cv_type_of_bool@ bool;
+typedef NCURSES_BOOL bool;
 #endif
 
 #endif /* !__cplusplus, etc. */
@@ -189,45 +189,47 @@
 extern NCURSES_EXPORT_VAR(chtype) acs_map[];
 #endif
 
+#define NCURSES_ACS(c)	(acs_map[(unsigned char)c])
+
 /* VT100 symbols begin here */
-#define ACS_ULCORNER	(acs_map['l'])	/* upper left corner */
-#define ACS_LLCORNER	(acs_map['m'])	/* lower left corner */
-#define ACS_URCORNER	(acs_map['k'])	/* upper right corner */
-#define ACS_LRCORNER	(acs_map['j'])	/* lower right corner */
-#define ACS_LTEE	(acs_map['t'])	/* tee pointing right */
-#define ACS_RTEE	(acs_map['u'])	/* tee pointing left */
-#define ACS_BTEE	(acs_map['v'])	/* tee pointing up */
-#define ACS_TTEE	(acs_map['w'])	/* tee pointing down */
-#define ACS_HLINE	(acs_map['q'])	/* horizontal line */
-#define ACS_VLINE	(acs_map['x'])	/* vertical line */
-#define ACS_PLUS	(acs_map['n'])	/* large plus or crossover */
-#define ACS_S1		(acs_map['o'])	/* scan line 1 */
-#define ACS_S9		(acs_map['s'])	/* scan line 9 */
-#define ACS_DIAMOND	(acs_map['`'])	/* diamond */
-#define ACS_CKBOARD	(acs_map['a'])	/* checker board (stipple) */
-#define ACS_DEGREE	(acs_map['f'])	/* degree symbol */
-#define ACS_PLMINUS	(acs_map['g'])	/* plus/minus */
-#define ACS_BULLET	(acs_map['~'])	/* bullet */
+#define ACS_ULCORNER	NCURSES_ACS('l') /* upper left corner */
+#define ACS_LLCORNER	NCURSES_ACS('m') /* lower left corner */
+#define ACS_URCORNER	NCURSES_ACS('k') /* upper right corner */
+#define ACS_LRCORNER	NCURSES_ACS('j') /* lower right corner */
+#define ACS_LTEE	NCURSES_ACS('t') /* tee pointing right */
+#define ACS_RTEE	NCURSES_ACS('u') /* tee pointing left */
+#define ACS_BTEE	NCURSES_ACS('v') /* tee pointing up */
+#define ACS_TTEE	NCURSES_ACS('w') /* tee pointing down */
+#define ACS_HLINE	NCURSES_ACS('q') /* horizontal line */
+#define ACS_VLINE	NCURSES_ACS('x') /* vertical line */
+#define ACS_PLUS	NCURSES_ACS('n') /* large plus or crossover */
+#define ACS_S1		NCURSES_ACS('o') /* scan line 1 */
+#define ACS_S9		NCURSES_ACS('s') /* scan line 9 */
+#define ACS_DIAMOND	NCURSES_ACS('`') /* diamond */
+#define ACS_CKBOARD	NCURSES_ACS('a') /* checker board (stipple) */
+#define ACS_DEGREE	NCURSES_ACS('f') /* degree symbol */
+#define ACS_PLMINUS	NCURSES_ACS('g') /* plus/minus */
+#define ACS_BULLET	NCURSES_ACS('~') /* bullet */
 /* Teletype 5410v1 symbols begin here */
-#define ACS_LARROW	(acs_map[','])	/* arrow pointing left */
-#define ACS_RARROW	(acs_map['+'])	/* arrow pointing right */
-#define ACS_DARROW	(acs_map['.'])	/* arrow pointing down */
-#define ACS_UARROW	(acs_map['-'])	/* arrow pointing up */
-#define ACS_BOARD	(acs_map['h'])	/* board of squares */
-#define ACS_LANTERN	(acs_map['i'])	/* lantern symbol */
-#define ACS_BLOCK	(acs_map['0'])	/* solid square block */
+#define ACS_LARROW	NCURSES_ACS(',') /* arrow pointing left */
+#define ACS_RARROW	NCURSES_ACS('+') /* arrow pointing right */
+#define ACS_DARROW	NCURSES_ACS('.') /* arrow pointing down */
+#define ACS_UARROW	NCURSES_ACS('-') /* arrow pointing up */
+#define ACS_BOARD	NCURSES_ACS('h') /* board of squares */
+#define ACS_LANTERN	NCURSES_ACS('i') /* lantern symbol */
+#define ACS_BLOCK	NCURSES_ACS('0') /* solid square block */
 /*
  * These aren't documented, but a lot of System Vs have them anyway
  * (you can spot pprryyzz{{||}} in a lot of AT&T terminfo strings).
  * The ACS_names may not match AT&T's, our source didn't know them.
  */
-#define ACS_S3		(acs_map['p'])	/* scan line 3 */
-#define ACS_S7		(acs_map['r'])	/* scan line 7 */
-#define ACS_LEQUAL	(acs_map['y'])	/* less/equal */
-#define ACS_GEQUAL	(acs_map['z'])	/* greater/equal */
-#define ACS_PI		(acs_map['{'])	/* Pi */
-#define ACS_NEQUAL	(acs_map['|'])	/* not equal */
-#define ACS_STERLING	(acs_map['}'])	/* UK pound sign */
+#define ACS_S3		NCURSES_ACS('p') /* scan line 3 */
+#define ACS_S7		NCURSES_ACS('r') /* scan line 7 */
+#define ACS_LEQUAL	NCURSES_ACS('y') /* less/equal */
+#define ACS_GEQUAL	NCURSES_ACS('z') /* greater/equal */
+#define ACS_PI		NCURSES_ACS('{') /* Pi */
+#define ACS_NEQUAL	NCURSES_ACS('|') /* not equal */
+#define ACS_STERLING	NCURSES_ACS('}') /* UK pound sign */
 
 /*
  * Line drawing ACS names are of the form ACS_trbl, where t is the top, r
@@ -286,20 +288,19 @@
 #undef mblen
 #endif
 #include <libutf8.h>
-#define _WCHAR_T
-#define _WINT_T
 #endif
 
-#if @NCURSES_MBSTATE_T@
+#if @NEED_WCHAR_H@
 #include <wchar.h>		/* ...to get mbstate_t, etc. */
 #endif
 
-#ifndef _WCHAR_T
-typedef unsigned long wchar_t;
-#endif /* _WCHAR_T */
-#ifndef _WINT_T
-typedef long int wint_t;
-#endif /* _WINT_T */
+#if @NCURSES_WCHAR_T@
+typedef unsigned short wchar_t@NCURSES_OK_WCHAR_T@;
+#endif
+
+#if @NCURSES_WINT_T@
+typedef unsigned int wint_t@NCURSES_OK_WCHAR_T@;
+#endif
 
 #define CCHARW_MAX	5
 typedef struct
@@ -388,7 +389,8 @@
 extern NCURSES_EXPORT(char *) keybound (int, int);
 extern NCURSES_EXPORT(const char *) curses_version (void);
 extern NCURSES_EXPORT(int) assume_default_colors (int, int);
-extern NCURSES_EXPORT(int) define_key (char *, int);
+extern NCURSES_EXPORT(int) define_key (const char *, int);
+extern NCURSES_EXPORT(int) key_defined (const char *);
 extern NCURSES_EXPORT(int) keyok (int, bool);
 extern NCURSES_EXPORT(int) resize_term (int, int);
 extern NCURSES_EXPORT(int) resizeterm (int, int);
@@ -451,24 +453,14 @@
  * GCC (and some other compilers) define '__attribute__'; we're using this
  * macro to alert the compiler to flag inconsistencies in printf/scanf-like
  * function calls.  Just in case '__attribute__' isn't defined, make a dummy.
- * G++ doesn't accept it anyway.
+ * Old versions of G++ do not accept it anyway, at least not consistently with
+ * GCC.
  */
-#if !defined(__GNUC__) && !defined(__attribute__)
+#if !(defined(__GNUC__) || defined(__GNUG__) || defined(__attribute__))
 #define __attribute__(p) /* nothing */
 #endif
 
 /*
- * For g++, turn off our macros that use __attribute__ (g++ recognizes some
- * of them, but not at the same version levels as gcc).
- */
-#ifdef __cplusplus
-#undef GCC_NORETURN
-#undef GCC_PRINTF
-#undef GCC_SCANF
-#undef GCC_UNUSED
-#endif
-
-/*
  * We cannot define these in ncurses_cfg.h, since they require parameters to be
  * passed (that's non-portable).
  */
@@ -609,7 +601,7 @@
 extern NCURSES_EXPORT(int) mvinsnstr (int, int, const char *, int);	/* generated */
 extern NCURSES_EXPORT(int) mvinsstr (int, int, const char *);		/* generated */
 extern NCURSES_EXPORT(int) mvinstr (int, int, char *);			/* generated */
-extern NCURSES_EXPORT(int) mvprintw (int,int, NCURSES_CONST char *,...)	/* implemented */
+extern NCURSES_EXPORT(int) mvprintw (int,int, const char *,...)		/* implemented */
 		GCC_PRINTFLIKE(3,4);
 extern NCURSES_EXPORT(int) mvscanw (int,int, NCURSES_CONST char *,...)	/* implemented */
 		GCC_SCANFLIKE(3,4);
@@ -634,7 +626,7 @@
 extern NCURSES_EXPORT(int) mvwinsnstr (WINDOW *, int, int, const char *, int);	/* generated */
 extern NCURSES_EXPORT(int) mvwinsstr (WINDOW *, int, int, const char *);		/* generated */
 extern NCURSES_EXPORT(int) mvwinstr (WINDOW *, int, int, char *);		/* generated */
-extern NCURSES_EXPORT(int) mvwprintw (WINDOW*,int,int, NCURSES_CONST char *,...)	/* implemented */
+extern NCURSES_EXPORT(int) mvwprintw (WINDOW*,int,int, const char *,...)	/* implemented */
 		GCC_PRINTFLIKE(4,5);
 extern NCURSES_EXPORT(int) mvwscanw (WINDOW *,int,int, NCURSES_CONST char *,...)	/* implemented */
 		GCC_SCANFLIKE(4,5);
@@ -658,7 +650,7 @@
 extern NCURSES_EXPORT(int) pechochar (WINDOW *, const chtype);		/* implemented */
 extern NCURSES_EXPORT(int) pnoutrefresh (WINDOW*,int,int,int,int,int,int);/* implemented */
 extern NCURSES_EXPORT(int) prefresh (WINDOW *,int,int,int,int,int,int);	/* implemented */
-extern NCURSES_EXPORT(int) printw (NCURSES_CONST char *,...)		/* implemented */
+extern NCURSES_EXPORT(int) printw (const char *,...)			/* implemented */
 		GCC_PRINTFLIKE(1,2);
 extern NCURSES_EXPORT(int) putp (const char *);				/* implemented */
 extern NCURSES_EXPORT(int) putwin (WINDOW *, FILE *);			/* implemented */
@@ -720,8 +712,8 @@
 extern NCURSES_EXPORT(int) vidattr (chtype);				/* implemented */
 extern NCURSES_EXPORT(int) vidputs (chtype, int (*)(int));		/* implemented */
 extern NCURSES_EXPORT(int) vline (chtype, int);				/* generated */
-extern NCURSES_EXPORT(int) vwprintw (WINDOW *, NCURSES_CONST char *,va_list);	/* implemented */
-extern NCURSES_EXPORT(int) vw_printw (WINDOW *, NCURSES_CONST char *,va_list);	/* generated */
+extern NCURSES_EXPORT(int) vwprintw (WINDOW *, const char *,va_list);	/* implemented */
+extern NCURSES_EXPORT(int) vw_printw (WINDOW *, const char *,va_list);	/* generated */
 extern NCURSES_EXPORT(int) vwscanw (WINDOW *, NCURSES_CONST char *,va_list);	/* implemented */
 extern NCURSES_EXPORT(int) vw_scanw (WINDOW *, NCURSES_CONST char *,va_list);	/* generated */
 extern NCURSES_EXPORT(int) waddch (WINDOW *, const chtype);		/* implemented */
@@ -765,7 +757,7 @@
 extern NCURSES_EXPORT(int) winstr (WINDOW *, char *);			/* generated */
 extern NCURSES_EXPORT(int) wmove (WINDOW *,int,int);			/* implemented */
 extern NCURSES_EXPORT(int) wnoutrefresh (WINDOW *);			/* implemented */
-extern NCURSES_EXPORT(int) wprintw (WINDOW *, NCURSES_CONST char *,...)	/* implemented */
+extern NCURSES_EXPORT(int) wprintw (WINDOW *, const char *,...)		/* implemented */
 		GCC_PRINTFLIKE(2,3);
 extern NCURSES_EXPORT(int) wredrawln (WINDOW *,int,int);		/* implemented */
 extern NCURSES_EXPORT(int) wrefresh (WINDOW *);				/* implemented */
@@ -831,10 +823,11 @@
 #define nocrmode()		nocbreak()
 #define gettmode()
 
-#define getyx(win,y,x)   	(y = (win)?(win)->_cury:ERR, x = (win)?(win)->_curx:ERR)
-#define getbegyx(win,y,x)	(y = (win)?(win)->_begy:ERR, x = (win)?(win)->_begx:ERR)
-#define getmaxyx(win,y,x)	(y = (win)?((win)->_maxy + 1):ERR, x = (win)?((win)->_maxx + 1):ERR)
-#define getparyx(win,y,x)	(y = (win)?(win)->_pary:ERR, x = (win)?(win)->_parx:ERR)
+#define getyx(win,y,x)   	(y = getcury(win), x = getcurx(win))
+#define getbegyx(win,y,x)	(y = getbegy(win), x = getbegx(win))
+#define getmaxyx(win,y,x)	(y = getmaxy(win), x = getmaxx(win))
+#define getparyx(win,y,x)	(y = getpary(win), x = getparx(win))
+
 #define getsyx(y,x) do { if(newscr->_leaveok) (y)=(x)=-1; \
 			 else getyx(newscr,(y),(x)); \
 		    } while(0)
Index: include/curses.tail
Prereq:  1.7 
--- ncurses-5.3-20021012/include/curses.tail	Sat Oct 12 11:46:02 2002
+++ ncurses-5.3-20030719/include/curses.tail	Sat Nov  2 15:26:26 2002
@@ -1,4 +1,4 @@
-/* $Id: curses.tail,v 1.7 2002/10/12 15:46:02 tom Exp $ */
+/* $Id: curses.tail,v 1.8 2002/11/02 20:26:26 tom Exp $ */
 
 /* mouse interface */
 #define NCURSES_MOUSE_VERSION	1
@@ -119,10 +119,6 @@
 #define OPTIMIZE_HASHMAP	0x02	/* diff hashing to detect scrolls */
 #define OPTIMIZE_SCROLL		0x04	/* scroll optimization */
 #define OPTIMIZE_ALL		0xff	/* enable all optimizations (dflt) */
-#endif
-
-#ifndef NCURSES_WGETCH_EVENTS
-#undef KEY_EVENT
 #endif
 
 #ifdef __cplusplus
Index: include/curses.wide
Prereq:  1.25 
--- ncurses-5.3-20021012/include/curses.wide	Sat Aug 31 13:48:53 2002
+++ ncurses-5.3-20030719/include/curses.wide	Sat Jun  7 17:59:37 2003
@@ -1,21 +1,23 @@
 
 #ifdef _XOPEN_SOURCE_EXTENDED
 
-/* $Id: curses.wide,v 1.25 2002/08/31 17:48:53 tom Exp $ */
+/* $Id: curses.wide,v 1.27 2003/06/07 21:59:37 tom Exp $ */
 
 extern NCURSES_EXPORT_VAR(cchar_t *) _nc_wacs;
 
-#define WACS_BSSB	(&_nc_wacs['l'])
-#define WACS_SSBB	(&_nc_wacs['m'])
-#define WACS_BBSS	(&_nc_wacs['k'])
-#define WACS_SBBS	(&_nc_wacs['j'])
-#define WACS_SBSS	(&_nc_wacs['u'])
-#define WACS_SSSB	(&_nc_wacs['t'])
-#define WACS_SSBS	(&_nc_wacs['v'])
-#define WACS_BSSS	(&_nc_wacs['w'])
-#define WACS_BSBS	(&_nc_wacs['q'])
-#define WACS_SBSB	(&_nc_wacs['x'])
-#define WACS_SSSS	(&_nc_wacs['n'])
+#define NCURSES_WACS(c)	(&_nc_wacs[(unsigned char)c])
+
+#define WACS_BSSB	NCURSES_WACS('l')
+#define WACS_SSBB	NCURSES_WACS('m')
+#define WACS_BBSS	NCURSES_WACS('k')
+#define WACS_SBBS	NCURSES_WACS('j')
+#define WACS_SBSS	NCURSES_WACS('u')
+#define WACS_SSSB	NCURSES_WACS('t')
+#define WACS_SSBS	NCURSES_WACS('v')
+#define WACS_BSSS	NCURSES_WACS('w')
+#define WACS_BSBS	NCURSES_WACS('q')
+#define WACS_SBSB	NCURSES_WACS('x')
+#define WACS_SSSS	NCURSES_WACS('n')
 
 #define WACS_ULCORNER	WACS_BSSB
 #define WACS_LLCORNER	WACS_SSBB
@@ -29,31 +31,31 @@
 #define WACS_VLINE	WACS_SBSB
 #define WACS_PLUS	WACS_SSSS
 
-#define WACS_S1		(&_nc_wacs['o']) /* scan line 1 */
-#define WACS_S9 	(&_nc_wacs['s']) /* scan line 9 */
-#define WACS_DIAMOND	(&_nc_wacs['`']) /* diamond */
-#define WACS_CKBOARD	(&_nc_wacs['a']) /* checker board */
-#define WACS_DEGREE	(&_nc_wacs['f']) /* degree symbol */
-#define WACS_PLMINUS	(&_nc_wacs['g']) /* plus/minus */
-#define WACS_BULLET	(&_nc_wacs['~']) /* bullet */
+#define WACS_S1		NCURSES_WACS('o') /* scan line 1 */
+#define WACS_S9 	NCURSES_WACS('s') /* scan line 9 */
+#define WACS_DIAMOND	NCURSES_WACS('`') /* diamond */
+#define WACS_CKBOARD	NCURSES_WACS('a') /* checker board */
+#define WACS_DEGREE	NCURSES_WACS('f') /* degree symbol */
+#define WACS_PLMINUS	NCURSES_WACS('g') /* plus/minus */
+#define WACS_BULLET	NCURSES_WACS('~') /* bullet */
 
 	/* Teletype 5410v1 symbols */
-#define WACS_LARROW	(&_nc_wacs[',']) /* arrow left */
-#define WACS_RARROW	(&_nc_wacs['+']) /* arrow right */
-#define WACS_DARROW	(&_nc_wacs['.']) /* arrow down */
-#define WACS_UARROW	(&_nc_wacs['-']) /* arrow up */
-#define WACS_BOARD	(&_nc_wacs['h']) /* board of squares */
-#define WACS_LANTERN	(&_nc_wacs['i']) /* lantern symbol */
-#define WACS_BLOCK	(&_nc_wacs['0']) /* solid square block */
+#define WACS_LARROW	NCURSES_WACS(',') /* arrow left */
+#define WACS_RARROW	NCURSES_WACS('+') /* arrow right */
+#define WACS_DARROW	NCURSES_WACS('.') /* arrow down */
+#define WACS_UARROW	NCURSES_WACS('-') /* arrow up */
+#define WACS_BOARD	NCURSES_WACS('h') /* board of squares */
+#define WACS_LANTERN	NCURSES_WACS('i') /* lantern symbol */
+#define WACS_BLOCK	NCURSES_WACS('0') /* solid square block */
 
 	/* ncurses extensions */
-#define WACS_S3		(&_nc_wacs['p']) /* scan line 3 */
-#define WACS_S7		(&_nc_wacs['r']) /* scan line 7 */
-#define WACS_LEQUAL	(&_nc_wacs['y']) /* less/equal */
-#define WACS_GEQUAL	(&_nc_wacs['z']) /* greater/equal */
-#define WACS_PI		(&_nc_wacs['{']) /* Pi */
-#define WACS_NEQUAL	(&_nc_wacs['|']) /* not equal */
-#define WACS_STERLING	(&_nc_wacs['}']) /* UK pound sign */
+#define WACS_S3		NCURSES_WACS('p') /* scan line 3 */
+#define WACS_S7		NCURSES_WACS('r') /* scan line 7 */
+#define WACS_LEQUAL	NCURSES_WACS('y') /* less/equal */
+#define WACS_GEQUAL	NCURSES_WACS('z') /* greater/equal */
+#define WACS_PI		NCURSES_WACS('{') /* Pi */
+#define WACS_NEQUAL	NCURSES_WACS('|') /* not equal */
+#define WACS_STERLING	NCURSES_WACS('}') /* UK pound sign */
 
 /*
  * Function prototypes for wide-character operations.
@@ -129,7 +131,7 @@
 extern NCURSES_EXPORT(int) mvwvline_set (WINDOW *, int,int, const cchar_t *,int); /* generated:WIDEC */
 extern NCURSES_EXPORT(int) pecho_wchar (WINDOW *, const cchar_t *);	/* missing */
 extern NCURSES_EXPORT(int) setcchar (cchar_t *, const wchar_t *, const attr_t, short, const void *);	/* implemented */
-extern NCURSES_EXPORT(int) slk_wset (int, const wchar_t *, int);	/* missing */
+extern NCURSES_EXPORT(int) slk_wset (int, const wchar_t *, int);	/* implemented */
 extern NCURSES_EXPORT(attr_t) term_attrs (void);			/* implemented */
 extern NCURSES_EXPORT(int) unget_wch (const wchar_t);			/* implemented */
 extern NCURSES_EXPORT(int) vid_attr (attr_t, short, void *);		/* implemented */
Index: include/ncurses_defs
Prereq:  1.15 
--- ncurses-5.3-20021012/include/ncurses_defs	Sat Aug 24 19:13:43 2002
+++ ncurses-5.3-20030719/include/ncurses_defs	Sat Jul  5 11:14:30 2003
@@ -1,6 +1,6 @@
-# $Id: ncurses_defs,v 1.15 2002/08/24 23:13:43 tom Exp $
+# $Id: ncurses_defs,v 1.18 2003/07/05 15:14:30 tom Exp $
 ##############################################################################
-# Copyright (c) 2000-2001,2002 Free Software Foundation, Inc.                #
+# Copyright (c) 2000-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -45,6 +45,7 @@
 GCC_UNUSED	/* nothing */
 HAVE_BIG_CORE
 HAVE_BSD_CGETENT
+HAVE_BTOWC 
 HAVE_BUILTIN_H
 HAVE_DIRENT_H
 HAVE_ERRNO
@@ -72,6 +73,7 @@
 HAVE_LINK
 HAVE_LOCALE_H
 HAVE_LONG_FILE_NAMES
+HAVE_MBTOWC
 HAVE_MEMCCPY
 HAVE_MENU_H
 HAVE_MKSTEMP
@@ -81,6 +83,7 @@
 HAVE_POLL
 HAVE_POLL_H
 HAVE_PURIFY
+HAVE_PUTWC 
 HAVE_REGEXPR_H_FUNCS
 HAVE_REGEXP_H_FUNCS
 HAVE_REGEX_H_FUNCS
@@ -93,6 +96,7 @@
 HAVE_SIGACTION
 HAVE_SIGVEC
 HAVE_SIZECHANGE
+HAVE_SLK_COLOR
 HAVE_STRDUP
 HAVE_STRSTR
 HAVE_SYMLINK
@@ -121,6 +125,8 @@
 HAVE_VFSCANF
 HAVE_VSNPRINTF
 HAVE_VSSCANF
+HAVE_WCTOB 
+HAVE_WCTOMB
 HAVE_WORKING_POLL
 HAVE_WRESIZE
 HAVE__DOSCAN
@@ -160,6 +166,7 @@
 USE_STRSTREAM_VSCAN
 USE_STRSTREAM_VSCAN_CAST
 USE_SYMLINKS
+USE_SYSMOUSE
 USE_TERMCAP
 USE_WIDEC_SUPPORT
 USE_XMC_SUPPORT
Index: include/ncurses_dll.h
Prereq:  1.2 
--- ncurses-5.3-20021012/include/ncurses_dll.h	Sat Dec  8 20:36:34 2001
+++ ncurses-5.3-20030719/include/ncurses_dll.h	Sat Jul 19 14:44:32 2003
@@ -1,10 +1,14 @@
-/* $Id: ncurses_dll.h,v 1.2 2001/12/09 01:36:34 tom Exp $ */
+/* $Id: ncurses_dll.h,v 1.4 2003/07/19 18:44:32 Charles.Wilson Exp $ */
 
 #ifndef NCURSES_DLL_H_incl
 #define NCURSES_DLL_H_incl 1
 
-#undef NCURSES_DLL	/* cygwin dll not implemented */
-#define NCURSES_STATIC	/* cygwin dll not implemented */
+/* no longer needed on cygwin or mingw, thanks to auto-import       */
+/* but this structure may be useful at some point for an MSVC build */
+/* so, for now unconditionally define the important flags           */
+/* "the right way" for proper static and dll+auto-import behavior   */
+#undef NCURSES_DLL
+#define NCURSES_STATIC
 
 #if defined(__CYGWIN__)
 #  if defined(NCURSES_DLL)
@@ -14,8 +18,8 @@
 #  endif
 #  undef NCURSES_IMPEXP
 #  undef NCURSES_API
-#  undef NCURSES_EXPORT(type)
-#  undef NCURSES_EXPORT_VAR(type)
+#  undef NCURSES_EXPORT
+#  undef NCURSES_EXPORT_VAR
 #  if defined(NCURSES_DLL)
 /* building a DLL */
 #    define NCURSES_IMPEXP __declspec(dllexport)
Index: include/tic.h
Prereq:  1.42 
--- ncurses-5.3-20021012/include/tic.h	Sat Oct 12 11:46:15 2002
+++ ncurses-5.3-20030719/include/tic.h	Sat Jul  5 15:23:29 2003
@@ -32,7 +32,7 @@
  ****************************************************************************/
 
 /*
- * $Id: tic.h,v 1.42 2002/10/12 15:46:15 tom Exp $
+ * $Id: tic.h,v 1.44 2003/07/05 19:23:29 tom Exp $
  *	tic.h - Global variables and structures for the terminfo
  *			compiler.
  */
@@ -203,8 +203,6 @@
 	const char	*source;
 };
 
-extern NCURSES_EXPORT_VAR(int) _nc_tparm_err;
-
 extern NCURSES_EXPORT_VAR(const struct name_table_entry * const) _nc_info_hash_table[];
 extern NCURSES_EXPORT_VAR(const struct name_table_entry * const) _nc_cap_hash_table[];
 
@@ -241,6 +239,7 @@
 #endif
 
 /* access.c */
+extern NCURSES_EXPORT(unsigned) _nc_pathlast (const char *);
 extern NCURSES_EXPORT(char *) _nc_basename (char *);
 extern NCURSES_EXPORT(char *) _nc_rootname (char *);
 
@@ -283,6 +282,13 @@
 /* captoinfo.c: capability conversion */
 extern NCURSES_EXPORT(char *) _nc_captoinfo (const char *, const char *, int const);
 extern NCURSES_EXPORT(char *) _nc_infotocap (const char *, const char *, int const);
+
+/* lib_tparm.c */
+#define NUM_PARM 9
+
+extern NCURSES_EXPORT_VAR(int) _nc_tparm_err;
+
+extern NCURSES_EXPORT(int) _nc_tparm_analyze(const char *string, char *p_is_s[NUM_PARM], int *popcount);
 
 /* lib_tputs.c */
 extern NCURSES_EXPORT_VAR(int) _nc_nulls_sent;		/* Add one for every null sent */
Index: man/MKterminfo.sh
Prereq:  1.10 
--- ncurses-5.3-20021012/man/MKterminfo.sh	Sat Jun 29 16:04:28 2002
+++ ncurses-5.3-20030719/man/MKterminfo.sh	Sat Jan 11 16:42:12 2003
@@ -1,10 +1,10 @@
 #!/bin/sh
-# $Id: MKterminfo.sh,v 1.10 2002/06/29 20:04:28 tom Exp $
+# $Id: MKterminfo.sh,v 1.12 2003/01/11 21:42:12 tom Exp $
 #
 # MKterminfo.sh -- generate terminfo.5 from Caps tabular data
 #
 #***************************************************************************
-# Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+# Copyright (c) 1998,2002,2003 Free Software Foundation, Inc.              *
 #                                                                          *
 # Permission is hereby granted, free of charge, to any person obtaining a  *
 # copy of this software and associated documentation files (the            *
@@ -69,11 +69,11 @@
 
 sed -n <$caps "\
 /%%-STOP-HERE-%%/q
-/^#%/s///p
+/^#%/s/#%//p
 /^#/d
-s/[	]\+/	/g
+s/[	][	]*/	/g
 s/$/T}/
-s/	[A-Z0-9_()\-]\+	[0-9\-]\+	[Y\-][B\-][C\-][G\-][EK\-]\**	/	T{/
+s/	[A-Z0-9_()\-][A-Z0-9_()\-]*	[0-9\-][0-9\-]*	[Y\-][B\-][C\-][G\-][EK\-]\**	/	T{/
 s/	bool	/	/p
 s/	num	/	/p
 s/	str	/	/p
Index: man/captoinfo.1m
Prereq:  1.16 
--- ncurses-5.3-20021012/man/captoinfo.1m	Sat Aug 12 21:56:49 2000
+++ ncurses-5.3-20030719/man/captoinfo.1m	Sat May 10 20:32:53 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,14 +27,14 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: captoinfo.1m,v 1.16 2000/08/13 01:56:49 tom Exp $
+.\" $Id: captoinfo.1m,v 1.17 2003/05/11 00:32:53 tom Exp $
 .TH captoinfo 1M ""
 .ds n 5
 .ds d @TERMINFO@
 .SH NAME
 \fBcaptoinfo\fR - convert a \fItermcap\fR description into a \fIterminfo\fR description
 .SH SYNOPSIS
-\fBcaptoinfo\fR [\fB-v\fR\fIn\fR \fIwidth\fR]  [\fB-V\fR] [\fB-1\fR] [\fB-w\fR \fIwidth\fR] \fIfile\fR . . .
+\fBcaptoinfo\fR [\fB\-v\fR\fIn\fR \fIwidth\fR]  [\fB\-V\fR] [\fB\-1\fR] [\fB\-w\fR \fIwidth\fR] \fIfile\fR . . .
 .SH DESCRIPTION
 \fBcaptoinfo\fR looks in \fIfile\fR for \fBtermcap\fR descriptions.  For each
 one found, an equivalent \fBterminfo\fR description is written to standard
@@ -47,18 +47,18 @@
 extracted from that file.  If the environment variable \fBTERMCAP\fR is not
 set, then the file \fB\*d\fR is read.
 .TP 5
-\fB-v\fR
+\fB\-v\fR
 print out tracing information on standard error as the program runs.
 .TP 5
-\fB-V\fR
+\fB\-V\fR
 print out the version of the program in use on standard error and exit.
 .TP 5
-\fB-1\fR
+\fB\-1\fR
 cause the fields to print out one to a line.  Otherwise, the fields
 will be printed several to a line to a maximum width of 60
 characters.
 .TP 5
-\fB-w\fR
+\fB\-w\fR
 change the output to \fIwidth\fR characters.
 .SH FILES
 .TP 20
@@ -172,11 +172,11 @@
 capabilities \fBmeml\fR (memory lock) and \fBmemu\fR (memory unlock).
 These will be discarded with a warning message.
 .SH NOTES
-This utility is actually a link to \fItic\fR(1M), running in \fI-I\fR mode.
-You can use other \fItic\fR options such as \fB-f\fR and  \fB-x\fR.
+This utility is actually a link to \fItic\fR(1M), running in \fI\-I\fR mode.
+You can use other \fItic\fR options such as \fB\-f\fR and  \fB\-x\fR.
 
 The trace option isn't identical to SVr4's.  Under SVr4, instead of following
-the -v with a trace level n, you repeat it n times.
+the \fB\-v\fR with a trace level n, you repeat it n times.
 .SH SEE ALSO
 \fBcurses\fR(3X), \fB@INFOCMP@\fR(1M), \fBterminfo\fR(\*n)
 .SH AUTHOR
Index: man/curs_addch.3x
Prereq:  1.20 
--- ncurses-5.3-20021012/man/curs_addch.3x	Sat Aug 10 18:12:36 2002
+++ ncurses-5.3-20030719/man/curs_addch.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_addch.3x,v 1.20 2002/08/10 22:12:36 tom Exp $
+.\" $Id: curs_addch.3x,v 1.21 2003/05/10 20:33:49 jmc Exp $
 .TH curs_addch 3X ""
 .SH NAME
 \fBaddch\fR, \fBwaddch\fR, \fBmvaddch\fR, \fBmvwaddch\fR,
@@ -62,7 +62,7 @@
 edge of a window it does nothing.
 Newline does a \fBclrtoeol\fR,
 then moves the cursor to the window left margin on the next line,
-scrolling the window if on the last line).
+scrolling the window if on the last line.
 Tabs are considered to be at every eighth column.
 The tab interval may be altered by setting the \fBTABSIZE\fR variable.
 
@@ -74,7 +74,7 @@
 Video attributes can be combined with a character argument passed to
 \fBaddch\fR or related functions by logical-ORing them into the character.
 (Thus, text, including attributes, can be copied from one place to another
-using \fBinch\fR and \fBaddch\fR.).  See the \fBcurs_attr\fR(3X) page for
+using \fBinch\fR and \fBaddch\fR.)  See the \fBcurs_attr\fR(3X) page for
 values of predefined video attribute constants that can be usefully OR'ed
 into characters.
 
Index: man/curs_beep.3x
Prereq:  1.7 
--- ncurses-5.3-20021012/man/curs_beep.3x	Wed Mar 11 16:12:53 1998
+++ ncurses-5.3-20030719/man/curs_beep.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_beep.3x,v 1.7 1998/03/11 21:12:53 juergen Exp $
+.\" $Id: curs_beep.3x,v 1.8 2003/05/10 20:33:49 jmc Exp $
 .TH curs_beep 3X ""
 .SH NAME
 \fBbeep\fR, \fBflash\fR - \fBcurses\fR bell and screen flash routines
@@ -45,7 +45,7 @@
 alert is possible, nothing happens.  Nearly all terminals have an audible alert
 (bell or beep), but only some can flash the screen.
 .SH RETURN VALUE
-These routines return \fBOK\fR if they succeed in beeping or flashing, 
+These routines return \fBOK\fR if they succeed in beeping or flashing,
 \fBERR\fR otherwise.
 .SH EXTENSIONS
 SVr4's beep and flash routines always returned \fBOK\fR, so it was not
Index: man/curs_deleteln.3x
Prereq:  1.7 
--- ncurses-5.3-20021012/man/curs_deleteln.3x	Sat Nov 11 15:43:20 2000
+++ ncurses-5.3-20030719/man/curs_deleteln.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_deleteln.3x,v 1.7 2000/11/11 20:43:20 Bernhard.Rosenkraenzer Exp $
+.\" $Id: curs_deleteln.3x,v 1.8 2003/05/10 20:33:49 jmc Exp $
 .TH curs_deleteln 3X ""
 .SH NAME
 \fBdeleteln\fR,
@@ -61,7 +61,7 @@
 with the one under the cursor), and move the remaining lines up.  The bottom
 \fIn\fR lines are cleared.  The current cursor position remains the same.
 
-The \fBinsertln\fR and \fBwinsertln\fR routines, insert a blank line above the
+The \fBinsertln\fR and \fBwinsertln\fR routines insert a blank line above the
 current line and the bottom line is lost.
 .SH RETURN VALUE
 All routines return the integer \fBERR\fR upon failure and an \fBOK\fR (SVr4
Index: man/curs_extend.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_extend.3x	Sat Feb 16 17:39:04 2002
+++ ncurses-5.3-20030719/man/curs_extend.3x	Sat May 10 20:32:53 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
 .\"
 .\" Author: Thomas E. Dickey <dickey@clark.net> 1999
 .\"
-.\" $Id: curs_extend.3x,v 1.9 2002/02/16 22:39:04 tom Exp $
+.\" $Id: curs_extend.3x,v 1.11 2003/05/11 00:32:53 tom Exp $
 .TH curs_extend 3X ""
 .SH NAME
 \fBcurses_version\fP,
@@ -55,11 +55,11 @@
 is able to use user-defined or nonstandard names
 which may be compiled into the terminfo
 description, i.e., via the terminfo or termcap interfaces.
-Normally these names are available for use, since the essential descision
-is made by using the \fB-x\fP option of \fItic\fP to compile
+Normally these names are available for use, since the essential decision
+is made by using the \fB\-x\fP option of \fItic\fP to compile
 extended terminal definitions.
 However you can disable this feature
-to ensure compatiblity with other implementations of curses
+to ensure compatiblity with other implementations of curses.
 .SH PORTABILITY
 These routines are specific to ncurses.  They were not supported on
 Version 7, BSD or System V implementations.  It is recommended that
Index: man/curs_get_wch.3x
Prereq:  1.3 
--- ncurses-5.3-20021012/man/curs_get_wch.3x	Sat May 18 17:48:53 2002
+++ ncurses-5.3-20030719/man/curs_get_wch.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 2002 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 2002,2003 Free Software Foundation, Inc.                   *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_get_wch.3x,v 1.3 2002/05/18 21:48:53 tom Exp $
+.\" $Id: curs_get_wch.3x,v 1.5 2003/05/10 20:33:49 jmc Exp $
 .TH curs_get_wch 3X ""
 .SH NAME
 \fBget_wch\fR,
@@ -37,13 +37,13 @@
 .SH SYNOPSIS
 \fB#include <curses.h>\fR
 .sp
-\fBint get_wch(win_t *\fR\fIwch\fR\fB);\fR
+\fBint get_wch(wint_t *\fR\fIwch\fR\fB);\fR
 .br
-\fBint wget_wch(WINDOW *\fR\fIwin\fR\fB, win_t *\fR\fIwch\fR\fB);\fR
+\fBint wget_wch(WINDOW *\fR\fIwin\fR\fB, wint_t *\fR\fIwch\fR\fB);\fR
 .br
-\fBint mvget_wch(int \fR\fIy\fR\fB, int \fR\fIx\fR\fB, win_t *\fR\fIwch\fR\fB);\fR
+\fBint mvget_wch(int \fR\fIy\fR\fB, int \fR\fIx\fR\fB, wint_t *\fR\fIwch\fR\fB);\fR
 .br
-\fBint mvwget_wch(WINDOW *\fR\fIwin\fR\fB, int \fR\fIy\fR\fB, int \fR\fIx\fR\fB, win_t *\fR\fIwch\fR\fB);\fR
+\fBint mvwget_wch(WINDOW *\fR\fIwin\fR\fB, int \fR\fIy\fR\fB, int \fR\fIx\fR\fB, wint_t *\fR\fIwch\fR\fB);\fR
 .br
 \fBint unget_wch(const wchar_t \fR\fIwch\fR\fB);\fR
 .SH DESCRIPTION
@@ -130,7 +130,7 @@
 Depending on the state of the tty driver when each character
 is typed, the program may produce undesirable results.
 .PP
-All functions except \fBwget_wch\fR and \fBunget_wch\fR 
+All functions except \fBwget_wch\fR and \fBunget_wch\fR
 may be macros.
 .SH RETURN VALUES
 When
Index: man/curs_get_wstr.3x
Prereq:  1.2 
--- ncurses-5.3-20021012/man/curs_get_wstr.3x	Sat May 18 17:48:15 2002
+++ ncurses-5.3-20030719/man/curs_get_wstr.3x	Sat Jul  5 07:15:28 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 2002 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 2002,2003 Free Software Foundation, Inc.                   *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_get_wstr.3x,v 1.2 2002/05/18 21:48:15 tom Exp $
+.\" $Id: curs_get_wstr.3x,v 1.3 2003/07/05 11:15:28 tom Exp $
 .TH curs_get_wstr 3X ""
 .SH NAME
 \fBget_wstr\fR,
@@ -151,6 +151,9 @@
 In the latter case,
 an ERR return without other data is treated as an end-of-file condition,
 and the returned array contains a \fBWEOF\fR followed by a null \fBwchar_t\fR.
+.PP
+X/Open curses documents these functions to pass an array of \fBwchar_t\fR,
+but all of the vendors implement this using \fBwint_t\fR.
 .SH SEE ALSO
 Functions:
 \fBcurses\fR(3X),
Index: man/curs_getcchar.3x
Prereq:  1.6 
--- ncurses-5.3-20021012/man/curs_getcchar.3x	Sat Mar 23 20:08:55 2002
+++ ncurses-5.3-20030719/man/curs_getcchar.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 2001,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_getcchar.3x,v 1.6 2002/03/24 01:08:55 tom Exp $
+.\" $Id: curs_getcchar.3x,v 1.7 2003/05/10 20:33:49 jmc Exp $
 .TH curs_getcchar 3X ""
 .SH NAME
 \fBgetcchar\fP,
@@ -108,7 +108,7 @@
 The string must be L'\\0' terminated,
 contain at most one character with strictly positive width,
 which must be the first,
-and contain no characters of negative width. 
+and contain no characters of negative width.
 .SH NOTES
 .PP
 The \fIopts\fP argument is reserved for future use.
Index: man/curs_getch.3x
Prereq:  1.21 
--- ncurses-5.3-20021012/man/curs_getch.3x	Sun Mar 17 09:36:21 2002
+++ ncurses-5.3-20030719/man/curs_getch.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_getch.3x,v 1.21 2002/03/17 14:36:21 tom Exp $
+.\" $Id: curs_getch.3x,v 1.22 2003/05/10 20:33:49 jmc Exp $
 .TH curs_getch 3X ""
 .SH NAME
 \fBgetch\fR,
@@ -82,7 +82,7 @@
 that function key is returned instead of the raw characters.
 Possible function
 keys are defined in \fB<curses.h>\fR as macros with values outside the range
-of 8-bit characters whose names begin with \fBKEY_.\fR Thus, a variable
+of 8-bit characters whose names begin with \fBKEY_\fR. Thus, a variable
 intended to hold the return value of a function key must be of short size or
 larger.
 
@@ -143,7 +143,7 @@
 KEY_SRESET/Soft (partial) reset
 KEY_RESET/Reset or hard reset
 KEY_PRINT/Print or copy
-KEY_LL/Home down or bottom (lower left).
+KEY_LL/Home down or bottom (lower left)
 KEY_A1/Upper left of keypad
 KEY_A3/Upper right of keypad
 KEY_B2/Center of keypad
@@ -238,7 +238,7 @@
 treat these control keys specially (and ignore the terminfo), or
 use the terminfo definitions.
 \fBNcurses\fR uses the terminfo definition.
-If it says that KEY_ENTER is control/M, \fBgetch\fR, will return KEY_ENTER
+If it says that KEY_ENTER is control/M, \fBgetch\fR will return KEY_ENTER
 when you press control/M.
 
 When using \fBgetch\fR, \fBwgetch\fR, \fBmvgetch\fR, or
Index: man/curs_getstr.3x
Prereq:  1.11 
--- ncurses-5.3-20021012/man/curs_getstr.3x	Sat Apr 13 18:14:30 2002
+++ ncurses-5.3-20030719/man/curs_getstr.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_getstr.3x,v 1.11 2002/04/13 22:14:30 tom Exp $
+.\" $Id: curs_getstr.3x,v 1.12 2003/05/10 20:33:49 jmc Exp $
 .TH curs_getstr 3X ""
 .SH NAME
 \fBgetstr\fR,
@@ -90,7 +90,7 @@
 
 SVr3 and early SVr4 curses implementations did not reject function keys;
 the SVr4.0 documentation claimed that "special keys" (such as function
-keys, "home" key, "clear" key, \fIetc\fR.) are interpreted" without
+keys, "home" key, "clear" key, \fIetc\fR.) are "interpreted", without
 giving details.  It lied.  In fact, the `character' value appended to the
 string by those implementations was predictable but not useful
 (being, in fact, the low-order eight bits of the key's KEY_ value).
Index: man/curs_getyx.3x
Prereq:  1.8 
--- ncurses-5.3-20021012/man/curs_getyx.3x	Sat Sep 21 15:00:38 2002
+++ ncurses-5.3-20030719/man/curs_getyx.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,17 +26,9 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_getyx.3x,v 1.8 2002/09/21 19:00:38 tom Exp $
+.\" $Id: curs_getyx.3x,v 1.10 2003/05/10 20:33:49 jmc Exp $
 .TH curs_getyx 3X ""
 .SH NAME
-.IX getbegx
-.IX getbegy
-.IX getcurx
-.IX getcury
-.IX getmaxx
-.IX getmaxy
-.IX getparx
-.IX getpary
 \fBgetyx\fR,
 \fBgetparyx\fR,
 \fBgetbegyx\fR,
@@ -64,7 +56,7 @@
 Like \fBgetyx\fR, the \fBgetbegyx\fR and \fBgetmaxyx\fR macros store
 the current beginning coordinates and size of the specified window.
 .SH RETURN VALUE
-The return values of these macros are undefined (\fIi\fR.\fIe\fR.,
+The return values of these macros are undefined (i.e.,
 they should not be used as the right-hand side of assignment statements).
 .SH NOTES
 All of these interfaces are macros.
Index: man/curs_initscr.3x
Prereq:  1.11 
--- ncurses-5.3-20021012/man/curs_initscr.3x	Sat Jul 20 10:51:04 2002
+++ ncurses-5.3-20030719/man/curs_initscr.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_initscr.3x,v 1.11 2002/07/20 14:51:04 tom Exp $
+.\" $Id: curs_initscr.3x,v 1.12 2003/05/10 20:33:49 jmc Exp $
 .TH curs_initscr 3X ""
 .SH NAME
 \fBinitscr\fR,
@@ -111,7 +111,7 @@
 
 Old versions of curses, e.g., BSD 4.4, may have returned a null pointer
 from \fBinitscr\fR when an error is detected, rather than exiting.
-It is safe but redundant to check the return value of \fBinitscr\fR 
+It is safe but redundant to check the return value of \fBinitscr\fR
 in XSI Curses.
 .SH SEE ALSO
 \fBcurses\fR(3X), \fBcurs_kernel\fR(3X), \fBcurs_refresh\fR(3X),
Index: man/curs_inopts.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_inopts.3x	Sat Aug 10 18:29:49 2002
+++ ncurses-5.3-20030719/man/curs_inopts.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2001 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_inopts.3x,v 1.9 2002/08/10 22:29:49 tom Exp $
+.\" $Id: curs_inopts.3x,v 1.10 2003/05/10 20:33:49 jmc Exp $
 .TH curs_inopts 3X ""
 .SH NAME
 \fBcbreak\fR, \fBnocbreak\fR, \fBecho\fR,
@@ -163,9 +163,9 @@
 
 The \fBtimeout\fR and \fBwtimeout\fR routines set blocking or
 non-blocking read for a given window.  If \fIdelay\fR is negative,
-blocking read is used (\fIi\fR.\fIe\fR., waits indefinitely for
+blocking read is used (i.e., waits indefinitely for
 input).  If \fIdelay\fR is zero, then non-blocking read is used
-(\fIi\fR.\fIe\fR., read returns \fBERR\fR if no input is waiting).  If
+(i.e., read returns \fBERR\fR if no input is waiting).  If
 \fIdelay\fR is positive, then read blocks for \fIdelay\fR
 milliseconds, and returns \fBERR\fR if there is still no input.
 Hence, these routines provide the same functionality as \fBnodelay\fR,
@@ -193,7 +193,7 @@
 AT&T curses implementations, in that the echo bit is cleared when curses
 initializes the terminal state.  BSD curses differed from this slightly; it
 left the echo bit on at initialization, but the BSD \fBraw\fR call turned it
-off as a side-effect.  For best portability, set echo or noecho explicitly 
+off as a side-effect.  For best portability, set echo or noecho explicitly
 just after initialization, even if your program remains in cooked mode.
 .SH NOTES
 Note that \fBecho\fR, \fBnoecho\fR, \fBhalfdelay\fR, \fBintrflush\fR,
Index: man/curs_insch.3x
Prereq:  1.7 
--- ncurses-5.3-20021012/man/curs_insch.3x	Sat Jul  1 15:57:21 2000
+++ ncurses-5.3-20030719/man/curs_insch.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_insch.3x,v 1.7 2000/07/01 19:57:21 tom Exp $
+.\" $Id: curs_insch.3x,v 1.8 2003/05/10 20:33:49 jmc Exp $
 .TH curs_insch 3X ""
 .SH NAME
 \fBinsch\fR,
@@ -45,7 +45,7 @@
 \fBint mvwinsch(WINDOW *win, int y, int x, chtype ch);\fR
 .br
 .SH DESCRIPTION
-These routines, insert the character \fIch\fR before the character under the
+These routines insert the character \fIch\fR before the character under the
 cursor.  All characters to the right of the cursor are moved one space to the
 right, with the possibility of the rightmost character on the line being lost.
 The insertion operation does not change the cursor position.
Index: man/curs_mouse.3x
Prereq:  1.20 
--- ncurses-5.3-20021012/man/curs_mouse.3x	Sat Jul 20 10:52:14 2002
+++ ncurses-5.3-20030719/man/curs_mouse.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_mouse.3x,v 1.20 2002/07/20 14:52:14 tom Exp $
+.\" $Id: curs_mouse.3x,v 1.22 2003/05/10 20:33:49 jmc Exp $
 .TH curs_mouse 3X ""
 .SH NAME
 \fBgetmouse\fR, \fBungetmouse\fR,
@@ -149,8 +149,8 @@
 to screen-relative coordinates due to the mechanism to reserve lines on top
 or bottom of the screen for other purposes (ripoff() call, see also slk_...
 functions).
-If the parameter \fBto_screen\fR is \fBTRUE\fR, the pointers 
-\fBpY, pX\fR must reference the coordinates of a location inside the window 
+If the parameter \fBto_screen\fR is \fBTRUE\fR, the pointers
+\fBpY, pX\fR must reference the coordinates of a location inside the window
 \fBwin\fR.
 They are converted to screen-relative coordinates and returned
 through the pointers.
@@ -168,7 +168,7 @@
 Please notice, that the referenced coordinates
 are only replaced by the converted coordinates if the transformation was
 successful.
- 
+
 The \fBmouseinterval\fR function sets the maximum time (in thousands of a
 second) that can elapse between press and release events for them to
 be recognized as a click.
@@ -208,6 +208,14 @@
 running on your machine, mouse events will not be visible to
 \fBncurses\fR(3X) (and the \fBwmousemask\fR function will always
 return \fB0\fR).
+
+If the terminfo entry contains a \fBXM\fR string,
+this is used in the xterm mouse driver to control the
+way the terminal is initialized for mouse operation.
+The default, if \fBXM\fR is not found,
+corresponds to private mode 1000 of xterm:
+
+    \\E[?1000%?%p1%{1}%=%th%el%;
 
 The z member in the event structure is not presently used.
 It is intended
Index: man/curs_outopts.3x
Prereq:  1.17 
--- ncurses-5.3-20021012/man/curs_outopts.3x	Sat Oct 13 20:50:30 2001
+++ ncurses-5.3-20030719/man/curs_outopts.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2001 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_outopts.3x,v 1.17 2001/10/14 00:50:30 tom Exp $
+.\" $Id: curs_outopts.3x,v 1.18 2003/05/10 20:33:49 jmc Exp $
 .TH curs_outopts 3X ""
 .SH NAME
 \fBclearok\fR, \fBidlok\fR, \fBidcok\fR, \fBimmedok\fR,
@@ -93,7 +93,7 @@
 
 If \fBimmedok\fR is called with \fBTRUE as argument\fR, any change
 in the window image, such as the ones caused by \fBwaddch, wclrtobot, wscrl\fR,
-\fIetc\fR., automatically cause a call to \fBwrefresh\fR.
+etc., automatically cause a call to \fBwrefresh\fR.
 However, it may
 degrade performance considerably, due to repeated calls to \fBwrefresh\fR.
 It is disabled by default.
@@ -165,7 +165,7 @@
 This will not work under
 ncurses.
 
-Earlier System V curses implementations specified that with \fBscrollok\fR 
+Earlier System V curses implementations specified that with \fBscrollok\fR
 enabled, any window modification triggering a scroll also forced a physical
 refresh.
 XSI Curses does not require this, and \fBncurses\fR avoids doing
Index: man/curs_pad.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_pad.3x	Tue Jul  4 18:38:13 2000
+++ ncurses-5.3-20030719/man/curs_pad.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_pad.3x,v 1.9 2000/07/04 22:38:13 tom Exp $
+.\" $Id: curs_pad.3x,v 1.10 2003/05/10 20:33:49 jmc Exp $
 .TH curs_pad 3X ""
 .SH NAME
 \fBnewpad\fR, \fBsubpad\fR, \fBprefresh\fR,
@@ -53,7 +53,7 @@
 screen size, and is not necessarily associated with a particular part of the
 screen.  Pads can be used when a large window is needed, and only a part of the
 window will be on the screen at one time.  Automatic refreshes of pads
-(\fIe\fR.\fIg\fR., from scrolling or echoing of input) do not occur.  It is not
+(e.g., from scrolling or echoing of input) do not occur.  It is not
 legal to call \fBwrefresh\fR with a \fIpad\fR as an argument; the routines
 \fBprefresh\fR or \fBpnoutrefresh\fR should be called instead.  Note that these
 routines require additional parameters to specify the part of the pad to be
@@ -84,7 +84,7 @@
 The \fBpechochar\fR routine is functionally equivalent to a call to \fBaddch\fR
 followed by a call to \fBrefresh\fR, a call to \fBwaddch\fR followed by a call
 to \fBwrefresh\fR, or a call to \fBwaddch\fR followed by a call to
-\fBprefresh.\fR The knowledge that only a single character is being output is
+\fBprefresh\fR. The knowledge that only a single character is being output is
 taken into consideration and, for non-control characters, a considerable
 performance gain might be seen by using these routines instead of their
 equivalents.  In the case of \fBpechochar\fR, the last location of the pad on
@@ -95,7 +95,7 @@
 completion.
 
 Routines that return pointers return \fBNULL\fR on error, and set \fBerrno\fR
-to \fBENOMEM\fR.  
+to \fBENOMEM\fR.
 .SH NOTES
 Note that \fBpechochar\fR may be a macro.
 .SH PORTABILITY
Index: man/curs_print.3x
Prereq:  1.5 
--- ncurses-5.3-20021012/man/curs_print.3x	Sat Feb 16 17:39:04 2002
+++ ncurses-5.3-20030719/man/curs_print.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_print.3x,v 1.5 2002/02/16 22:39:04 tom Exp $
+.\" $Id: curs_print.3x,v 1.6 2003/05/10 20:33:49 jmc Exp $
 .TH curs_print 3X ""
 .SH NAME
 \fBmcprint\fR - ship binary data to printer
@@ -46,7 +46,7 @@
 rule of thumb is to sleep for a second after shipping each 80-character line.
 
 .SH RETURN VALUE
-The \fBmcprint\fR function returns \fBERR\fR if the write operation aborted 
+The \fBmcprint\fR function returns \fBERR\fR if the write operation aborted
 for some reason.  In this case, errno will contain either an error associated
 with \fBwrite(2)\fR or one of the following:
 .TP 5
Index: man/curs_printw.3x
Prereq:  1.12 
--- ncurses-5.3-20021012/man/curs_printw.3x	Sat Jul 20 11:01:43 2002
+++ ncurses-5.3-20030719/man/curs_printw.3x	Sat Nov 16 17:28:57 2002
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_printw.3x,v 1.12 2002/07/20 15:01:43 tom Exp $
+.\" $Id: curs_printw.3x,v 1.13 2002/11/16 22:28:57 tom Exp $
 .TH curs_printw 3X ""
 .SH NAME
 \fBprintw\fR,
@@ -37,17 +37,17 @@
 .SH SYNOPSIS
 \fB#include <curses.h>\fR
 
-\fBint printw(char *fmt, ...);\fR
+\fBint printw(const char *fmt, ...);\fR
 .br
-\fBint wprintw(WINDOW *win, char *fmt, ...);\fR
+\fBint wprintw(WINDOW *win, const char *fmt, ...);\fR
 .br
-\fBint mvprintw(int y, int x, char *fmt, ...);\fR
+\fBint mvprintw(int y, int x, const char *fmt, ...);\fR
 .br
-\fBint mvwprintw(WINDOW *win, int y, int x, char *fmt, ...);\fR
+\fBint mvwprintw(WINDOW *win, int y, int x, const char *fmt, ...);\fR
 .br
-\fBint vwprintw(WINDOW *win, char *fmt, va_list varglist);\fR
+\fBint vwprintw(WINDOW *win, const char *fmt, va_list varglist);\fR
 .br
-\fBint vw_printw(WINDOW *win, char *fmt, va_list varglist);\fR
+\fBint vw_printw(WINDOW *win, const char *fmt, va_list varglist);\fR
 .br
 .SH DESCRIPTION
 The \fBprintw\fR, \fBwprintw\fR, \fBmvprintw\fR and \fBmvwprintw\fR
Index: man/curs_scroll.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_scroll.3x	Sat Oct 13 20:51:56 2001
+++ ncurses-5.3-20030719/man/curs_scroll.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_scroll.3x,v 1.9 2001/10/14 00:51:56 tom Exp $
+.\" $Id: curs_scroll.3x,v 1.10 2003/05/10 20:33:49 jmc Exp $
 .TH curs_scroll 3X ""
 .SH NAME
 \fBscroll\fR, \fBscrl\fR, \fBwscrl\fR - scroll a \fBcurses\fR window
@@ -61,12 +61,12 @@
 .SH NOTES
 Note that \fBscrl\fR and \fBscroll\fR may be macros.
 
-The SVr4 documentation says that the optimization of physically scrolling 
+The SVr4 documentation says that the optimization of physically scrolling
 immediately if the scroll region is the entire screen "is" performed, not
 "may be" performed.
 This implementation deliberately does not guarantee
 that this will occur, to leave open the possibility of smarter
-optimization of multiple scroll actions on the next update. 
+optimization of multiple scroll actions on the next update.
 
 Neither the SVr4 nor the XSI documentation specify whether the current
 attribute or
Index: man/curs_slk.3x
Prereq:  1.11 
--- ncurses-5.3-20021012/man/curs_slk.3x	Sat Mar  3 16:05:41 2001
+++ ncurses-5.3-20030719/man/curs_slk.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_slk.3x,v 1.11 2001/03/03 21:05:41 Todd.C.Miller Exp $
+.\" $Id: curs_slk.3x,v 1.12 2003/05/10 20:33:49 jmc Exp $
 .TH curs_slk 3X ""
 .SH NAME
 \fBslk_init\fR, \fBslk_set\fR, \fBslk_refresh\fR,
@@ -77,7 +77,7 @@
 many terminals.  For those terminals that do not have soft labels,
 \fBcurses\fR takes over the bottom line of \fBstdscr\fR, reducing the size of
 \fBstdscr\fR and the variable \fBLINES\fR.  \fBcurses\fR standardizes on eight
-labels of up to eight characters each. In addition to this, the ncurses 
+labels of up to eight characters each. In addition to this, the ncurses
 implementation supports a mode where it simulates 12 labels of up to five
 characters each. This is most common for todays PC like enduser devices.
 Please note that ncurses simulates this mode by taking over up to two lines at
@@ -94,10 +94,10 @@
 identify the key numbers easily.
 
 The \fBslk_set\fR routine requires \fIlabnum\fR to be a label number,
-from \fB1\fR to \fB8\fR (resp. \fB12\fR); \fIlabel\fR must be the string 
+from \fB1\fR to \fB8\fR (resp. \fB12\fR); \fIlabel\fR must be the string
 to be put on the label, up to eight (resp. five) characters in length.
 A null string or a null pointer sets up a blank label. \fIfmt\fR is either
-\fB0\fR, \fB1\fR, or \fB2\fR, indicating whether the label is  to be 
+\fB0\fR, \fB1\fR, or \fB2\fR, indicating whether the label is  to be
 left-justified, centered, or right-justified, respectively, within the
 label.
 
@@ -109,7 +109,7 @@
 
 The \fBslk_clear\fR routine clears the soft labels from the screen.
 
-The \fBslk_restore\fR routine, restores the soft labels to the screen
+The \fBslk_restore\fR routine restores the soft labels to the screen
 after a \fBslk_clear\fR has been performed.
 
 The \fBslk_touch\fR routine forces all the soft labels to be output
@@ -118,7 +118,7 @@
 The \fBslk_attron\fR, \fBslk_attrset\fR, \fBslk_attroff\fR and \fBslk_attr\fR
 routines correspond to \fBattron\fR, \fBattrset\fR, \fBattroff\fR and \fBattr_get\fR.
 They have an effect only if soft labels are simulated on the bottom line of
-the screen.  The default highlight for soft keys is A_STANDOUT (as in 
+the screen.  The default highlight for soft keys is A_STANDOUT (as in
 System V curses, which does not document this fact).
 
 The \fBslk_color\fR routine corresponds to \fBcolor_set\fR. It has an effect only
Index: man/curs_termcap.3x
Prereq:  1.16 
--- ncurses-5.3-20021012/man/curs_termcap.3x	Sat Feb 16 14:26:41 2002
+++ ncurses-5.3-20030719/man/curs_termcap.3x	Sat Feb  8 17:25:47 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_termcap.3x,v 1.16 2002/02/16 19:26:41 tom Exp $
+.\" $Id: curs_termcap.3x,v 1.18 2003/02/08 22:25:47 tom Exp $
 .TH curs_termcap 3X ""
 .ds n 5
 .SH NAME
@@ -130,6 +130,12 @@
 Because terminfo conventions for representing padding in string capabilities
 differ from termcap's, \fBtputs("50");\fR will put out a literal "50" rather
 than busy-waiting for 50 milliseconds.  Cope with it.
+
+Note that termcap has nothing analogous to terminfo's \fBsgr\fR string.
+One consequence of this is that termcap applications assume \fRme\fR
+(terminfo \fBsgr0\fR) does not reset the alternate character set.
+This implementation checks for, and modifies the data shown to the
+termcap interface to accommodate termcap's limitation in this respect.
 .SH PORTABILITY
 The XSI Curses standard, Issue 4 describes these functions.  However, they
 are marked TO BE WITHDRAWN and may be removed in future versions.
Index: man/curs_terminfo.3x
Prereq:  1.16 
--- ncurses-5.3-20021012/man/curs_terminfo.3x	Sat Jul 20 12:05:19 2002
+++ ncurses-5.3-20030719/man/curs_terminfo.3x	Sat May 10 16:22:01 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_terminfo.3x,v 1.16 2002/07/20 16:05:19 tom Exp $
+.\" $Id: curs_terminfo.3x,v 1.17 2003/05/10 20:22:01 tom Exp $
 .TH curs_terminfo 3X ""
 .ds n 5
 .SH NAME
@@ -108,7 +108,7 @@
 
 The header files \fBcurses.h\fR and \fBterm.h\fR should be included (in this
 order) to get the definitions for these strings, numbers, and flags.
-Parameterized strings should be passed through \fBtparm\fR to instantiate them.  
+Parameterized strings should be passed through \fBtparm\fR to instantiate them. 
 All \fBterminfo\fR strings [including the output of \fBtparm\fR] should be printed
 with \fBtputs\fR or \fBputp\fR.  Call the \fBreset_shell_mode\fR to restore the
 tty modes before exiting [see \fBcurs_kernel\fR(3X)].  Programs which use
@@ -280,7 +280,7 @@
 actual terminal state, and that an application should touch and refresh
 the window before resuming normal curses calls.
 Both ncurses and System V Release 4 curses implement \fBmvcur\fR using
-the SCREEN data allocated in either \fBinitscr\fR or \fBnewterm\fR. 
+the SCREEN data allocated in either \fBinitscr\fR or \fBnewterm\fR.
 So though it is documented as a terminfo function,
 \fBmvcur\fR is really a curses function which is not well specified.
 .SH SEE ALSO
Index: man/curs_util.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_util.3x	Sun Sep  1 15:44:37 2002
+++ ncurses-5.3-20030719/man/curs_util.3x	Sat Jul 19 15:59:56 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_util.3x,v 1.9 2002/09/01 19:44:37 tom Exp $
+.\" $Id: curs_util.3x,v 1.11 2003/07/19 19:59:56 tom Exp $
 .TH curs_util 3X ""
 .SH NAME
 \fBdelay_output\fR,
@@ -44,7 +44,7 @@
 
 \fBchar *unctrl(chtype c);\fR
 .br
-\fBchar *wunctrl(wchar_t w);\fR
+\fBchar *wunctrl(cchar_t *c);\fR
 .br
 \fBchar *keyname(int c);\fR
 .br
@@ -105,6 +105,7 @@
 The \fBdelay_output\fR routine inserts an \fIms\fR millisecond pause
 in output.  This routine should not be used extensively because
 padding characters are used rather than a CPU pause.
+If no padding character is specified, this uses \fBnapms\fR to perform the delay.
 
 The \fBflushinp\fR routine throws away any typeahead that has been typed by the
 user and has not yet been read by the program.
@@ -125,7 +126,10 @@
 terms.  The description here is adapted from the XSI Curses standard (which
 erroneously fails to describe the disabling of \fBcuu\fR).
 .SH SEE ALSO
-\fBcurses\fR(3X), \fBcurs_initscr\fR(3X), \fBcurs_scr_dump\fR(3X).
+\fBcurses\fR(3X),
+\fBcurs_initscr\fR(3X),
+\fBcurs_kernel\fR(3X),
+\fBcurs_scr_dump\fR(3X).
 .\"#
 .\"# The following sets edit modes for GNU EMACS
 .\"# Local Variables:
Index: man/curs_window.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/curs_window.3x	Sat Jul  1 16:08:37 2000
+++ ncurses-5.3-20030719/man/curs_window.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: curs_window.3x,v 1.9 2000/07/01 20:08:37 tom Exp $
+.\" $Id: curs_window.3x,v 1.10 2003/05/10 20:33:49 jmc Exp $
 .TH curs_window 3X ""
 .SH NAME
 \fBnewwin\fR,
@@ -142,7 +142,7 @@
 incompletely implemented, and not well tested.
 
 The System V curses documentation is very unclear about what \fBwsyncup\fR
-and \fBwsyncdown\fR actually do.  It seems to imply that they are only 
+and \fBwsyncdown\fR actually do.  It seems to imply that they are only
 supposed to touch exactly those lines that are affected by ancestor changes.
 The language here, and the behavior of the \fBcurses\fR implementation,
 is patterned on the XPG4 curses standard.  The weaker XPG4 spec may result
Index: man/define_key.3x
Prereq:  1.8 
--- ncurses-5.3-20021012/man/define_key.3x	Sat Feb 16 17:39:52 2002
+++ ncurses-5.3-20030719/man/define_key.3x	Sat May 17 19:25:11 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -28,14 +28,14 @@
 .\"
 .\" Author: Thomas E. Dickey <dickey@clark.net> 1997
 .\"
-.\" $Id: define_key.3x,v 1.8 2002/02/16 22:39:52 tom Exp $
+.\" $Id: define_key.3x,v 1.9 2003/05/17 23:25:11 tom Exp $
 .TH define_key 3X ""
 .SH NAME
 \fBdefine_key\fP \- define a keycode
 .SH SYNOPSIS
 \fB#include <curses.h>\fP
 
-\fBint define_key(char *definition, int keycode);\fP
+\fBint define_key(const char *definition, int keycode);\fP
 .SH DESCRIPTION
 This is an extension to the curses library.
 It permits an application to define keycodes with their corresponding control
Index: man/form_field.3x
Prereq:  1.5 
--- ncurses-5.3-20021012/man/form_field.3x	Sat Nov 28 20:05:52 1998
+++ ncurses-5.3-20030719/man/form_field.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field.3x,v 1.5 1998/11/29 01:05:52 Rick.Ohnemus Exp $
+.\" $Id: form_field.3x,v 1.6 2003/05/10 20:33:49 jmc Exp $
 .TH form_field 3X ""
 .SH NAME
 \fBform_field\fR - make and break connections between fields and forms
@@ -50,7 +50,7 @@
 
 The function \fBfield_count\fR returns the count of fields in \fIform\fR.
 
-The function \fBmove_field\fR move the given field (which must be disconnected)
+The function \fBmove_field\fR moves the given field (which must be disconnected)
 to a specified location on the screen.
 .SH RETURN VALUES
 The function \fBform_fields\fR returns \fBNULL\fR on error.
Index: man/form_field_buffer.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/form_field_buffer.3x	Sat Jan 19 17:48:23 2002
+++ ncurses-5.3-20030719/man/form_field_buffer.3x	Sat May 10 16:22:01 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field_buffer.3x,v 1.9 2002/01/19 22:48:23 tom Exp $
+.\" $Id: form_field_buffer.3x,v 1.10 2003/05/10 20:22:01 tom Exp $
 .TH form_field_buffer 3X ""
 .SH NAME
 \fBform_field_buffer\fR - field buffer control
@@ -50,7 +50,7 @@
 numbered buffers may be allocated by applications through the \fBnbuf\fR
 argument of (see \fBform_field_new\fR(3X)) but are not manipulated by the forms
 library.  The function \fBfield_buffer\fR returns the address of the buffer.
-Please note that this buffer has always the length of the buffer, that means 
+Please note that this buffer has always the length of the buffer, that means
 that it may typically contain trailing spaces. If you entered leading spaces
 the buffer may also contain them. If you want the raw data, you must write your
 own routine that copies the value out of the buffer and removes the leading
Index: man/form_field_just.3x
Prereq:  1.6 
--- ncurses-5.3-20021012/man/form_field_just.3x	Sat Jan 19 17:48:41 2002
+++ ncurses-5.3-20030719/man/form_field_just.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field_just.3x,v 1.6 2002/01/19 22:48:41 tom Exp $
+.\" $Id: form_field_just.3x,v 1.7 2003/05/10 20:33:49 jmc Exp $
 .TH form_field_just 3X ""
 .SH NAME
 \fBform_field_just\fR - retrieve field characteristics
@@ -48,7 +48,7 @@
 The function \fBfield_just\fR returns one of: NO_JUSTIFICATION,
 JUSTIFY_RIGHT, JUSTIFY_LEFT, or JUSTIFY_CENTER.
 
-The function \fBset_field_just\fR return one of the following:
+The function \fBset_field_just\fR returns one of the following:
 .TP 5
 \fBE_OK\fR
 The routine succeeded.
Index: man/form_field_new.3x
Prereq:  1.11 
--- ncurses-5.3-20021012/man/form_field_new.3x	Sat Feb 16 17:39:52 2002
+++ ncurses-5.3-20030719/man/form_field_new.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field_new.3x,v 1.11 2002/02/16 22:39:52 tom Exp $
+.\" $Id: form_field_new.3x,v 1.12 2003/05/10 20:33:49 jmc Exp $
 .TH form_field_new 3X ""
 .SH NAME
 \fBform_field_new\fR - create and destroy form fields
@@ -84,7 +84,7 @@
 
 It may be unwise to count on the set of attributes copied by
 \fBdup_field\fR(3X) being portable; the System V forms library documents are
-not very explicit on what gets copied and was not.
+not very explicit about what gets copied and what doesn't.
 .SH AUTHORS
 Juergen Pfeifer.  Manual pages and adaptation for new curses by Eric
 S. Raymond.
Index: man/form_field_opts.3x
Prereq:  1.7 
--- ncurses-5.3-20021012/man/form_field_opts.3x	Sat Nov 28 20:06:54 1998
+++ ncurses-5.3-20030719/man/form_field_opts.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 1998,2003 Free Software Foundation, Inc.                   *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field_opts.3x,v 1.7 1998/11/29 01:06:54 Rick.Ohnemus Exp $
+.\" $Id: form_field_opts.3x,v 1.8 2003/05/10 20:33:49 jmc Exp $
 .TH form_field_opts 3X ""
 .SH NAME
 \fBform_field_opts\fR - set and get field options
@@ -58,7 +58,7 @@
 .TP 5
 O_VISIBLE
 The field is displayed.  If this option is off, display of the field is
-suppressed,
+suppressed.
 .TP 5
 O_ACTIVE
 The field is visited during processing.  If this option is off, the field will
@@ -79,7 +79,7 @@
 The field is cleared whenever a character is entered at the first position.
 .TP 5
 O_AUTOSKIP
-Skip to the next field when this one fills
+Skip to the next field when this one fills.
 .TP 5
 O_NULLOK
 Allow a blank field.
Index: man/form_field_validation.3x
Prereq:  1.12 
--- ncurses-5.3-20021012/man/form_field_validation.3x	Sat Feb 16 17:39:52 2002
+++ ncurses-5.3-20030719/man/form_field_validation.3x	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,10 +26,10 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_field_validation.3x,v 1.12 2002/02/16 22:39:52 tom Exp $
+.\" $Id: form_field_validation.3x,v 1.14 2003/05/10 20:33:49 jmc Exp $
 .TH form_field_validation 3X ""
 .SH NAME
-\fBform_field_validation\fR - data type validation for fields 
+\fBform_field_validation\fR - data type validation for fields
 .SH SYNOPSIS
 \fB#include <form.h>\fR
 .br
@@ -38,10 +38,25 @@
 FIELDTYPE *field_type(const FIELD *field);
 .br
 void *field_arg(const FIELD *field);
+.sp
+FIELDTYPE *TYPE_ALNUM;
+.br
+FIELDTYPE *TYPE_ALPHA;
+.br
+FIELDTYPE *TYPE_ENUM;
+.br
+FIELDTYPE *TYPE_INTEGER;
+.br
+FIELDTYPE *TYPE_NUMERIC;
+.br
+FIELDTYPE *TYPE_REGEXP;
+.br
+FIELDTYPE *TYPE_IPV4;
 .br
 .SH DESCRIPTION
 The function \fBset_field_type\fR declares a data type for a given form field.
-This is the type checked by validation functions.  The types are as follows:
+This is the type checked by validation functions.
+The predefined types are as follows:
 .TP 5
 TYPE_ALNUM
 Alphanumeric data.  Requires a third \fBint\fR argument, a minimum field width.
@@ -56,27 +71,29 @@
 match must be a unique one (if this flag is off, a prefix matches the first
 of any set of more than one list elements with that prefix). Please notice
 that the string list is not copied, only a reference to it is stored in the
-field. So you should avoid to use a list that lives in automatic variables
+field. So you should avoid using a list that lives in automatic variables
 on the stack.
 .TP 5
 TYPE_INTEGER
 Integer data, parsable to an integer by \fBatoi(3)\fR.  Requires a third
-\fBint\fR argument controlling the precision, a fourth \fBlong\fR argument 
+\fBint\fR argument controlling the precision, a fourth \fBlong\fR argument
 constraining minimum value, and a fifth \fBlong\fR constraining maximum value.
-If the maximum value is less or equal the minimum value, the range is simply
-ignored. On return the field buffer is formatted according to the \fBprintf\fR
-format specification ".*ld", where the '*' is replaced by the precision argument.
+If the maximum value is less than or equal to the minimum value, the range is
+simply ignored. On return the field buffer is formatted according to the
+\fBprintf\fR format specification ".*ld", where the '*' is replaced by the
+precision argument.
 For details of the precision handling see \fBprintf's\fR man-page.
 .TP 5
 TYPE_NUMERIC
 Numeric data (may have a decimal-point part). Requires a third
 \fBint\fR argument controlling the precision, a fourth \fBdouble\fR
-argument constraining minimum value, and a fifth \fBdouble\fR constraining 
-maximum value. If your system supports locale's, the decimal point character
+argument constraining minimum value, and a fifth \fBdouble\fR constraining
+maximum value. If your system supports locales, the decimal point character
 to be used must be the one specified by your locale.
-If the maximum value is less or equal the minimum value, the range is simply
-ignored. On return the field buffer is formatted according to the \fBprintf\fR
-format specification ".*f", where the '*' is replaced by the precision argument.
+If the maximum value is less than or equal to the minimum value, the range is
+simply ignored. On return the field buffer is formatted according to the
+\fBprintf\fR format specification ".*f", where the '*' is replaced by the
+precision argument.
 For details of the precision handling see \fBprintf's\fR man-page.
 .TP 5
 TYPE_REGEXP
@@ -96,7 +113,7 @@
 numbers between 0 and 255. Trailing blanks in the buffer are ignored. The address
 itself is not validated. Please note that this is an ncurses extension. This
 field type may not be available in other curses implementations.
-
+.PP
 It is possible to set up new programmer-defined field types.  See the
 \fBform_fieldtype\fR(3X) manual page.
 .SH RETURN VALUE
Index: man/form_fieldtype.3x
Prereq:  1.9 
--- ncurses-5.3-20021012/man/form_fieldtype.3x	Sat Aug  4 16:36:25 2001
+++ ncurses-5.3-20030719/man/form_fieldtype.3x	Sat May 10 16:33:49 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: form_fieldtype.3x,v 1.9 2001/08/04 20:36:25 William.Setzer Exp $
+.\" $Id: form_fieldtype.3x,v 1.12 2003/05/10 20:33:49 jmc Exp $
 .TH form_fieldtype 3X ""
 .SH NAME
 \fBform_fieldtype\fR - define validation-field types
@@ -57,7 +57,7 @@
 .SH DESCRIPTION
 The function \fBnew_fieldtype\fR creates a new field type usable for data
 validation.  You supply it with \fIfield_check\fR, a predicate to check the
-validity of an entered data string whenever the user attempt to leave a field.
+validity of an entered data string whenever the user attempts to leave a field.
 The (FIELD *) argument is passed in so the validation predicate can see the
 field's buffer, sizes and other attributes; the second argument is an
 argument-block structure, about which more below.
@@ -69,22 +69,31 @@
 The function \fBfree_fieldtype\fR frees the space allocated for a given
 validation type.
 
-The function \fBset_fieldtype\fR associates three storage-management functions
-with a field type.  The \fImak_arg\fR function is automatically applied to the
+The function \fBset_fieldtype_arg\fR associates three storage-management functions
+with a field type.
+The \fImake_arg\fR function is automatically applied to the
 list of arguments you give \fBset_field_type\fR when attaching validation
 to a field; its job is to bundle these into an allocated argument-block
-object which can later be passed to validation predicated.  The other two
-hook arguments should copy and free argument-block structures.  They will
-be used by the forms-driver code. You must supply the \fImak_arg\fR function,
-the other two are optional, you may supply NULL for them. In this case it
-is assumed, that \fImak_arg\fR doesn't allocate memory but simply loads the
+object which can later be passed to validation predicated.
+The other two hook arguments should copy and free argument-block structures.
+They will be used by the forms-driver code.
+You must supply the \fImake_arg\fR function,
+the other two are optional, you may supply NULL for them.
+In this case it is assumed
+that \fImake_arg\fR does not allocate memory but simply loads the
 argument into a single scalar value.
 
+The function \fBlink_fieldtype\fR creates
+a new field type from the two given types.
+They are connected by an logical 'OR'.
+
 The form driver requests \fBREQ_NEXT_CHOICE\fR and \fBREQ_PREV_CHOICE\fR assume
 that the possible values of a field form an ordered set, and provide the forms
-user with a way to move through the set.  The \fBset_fieldtype_choice\fR
+user with a way to move through the set.
+The \fBset_fieldtype_choice\fR
 function allows forms programmers to define successor and predecessor functions
-for the field type.  These functions take the field pointer and an
+for the field type.
+These functions take the field pointer and an
 argument-block structure as arguments.
 .SH RETURN VALUE
 The pointer-valued routines return NULL on error.
Index: man/infocmp.1m
Prereq:  1.30 
--- ncurses-5.3-20021012/man/infocmp.1m	Sat Oct  5 17:22:21 2002
+++ ncurses-5.3-20030719/man/infocmp.1m	Sat May 10 20:32:53 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,14 +27,14 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: infocmp.1m,v 1.30 2002/10/05 21:22:21 tom Exp $
+.\" $Id: infocmp.1m,v 1.33 2003/05/11 00:32:53 tom Exp $
 .TH infocmp 1M ""
 .ds n 5
 .ds d @TERMINFO@
 .SH NAME
 \fBinfocmp\fR - compare or print out \fIterminfo\fR descriptions
 .SH SYNOPSIS
-\fBinfocmp\fR [\fB-\
+\fBinfocmp\fR [\fB\-\
 1\
 C\
 E\
@@ -58,9 +58,9 @@
 u\
 \fR]
 .br
-      [\fB-v\fR \fIn\fR] [\fB-s d\fR| \fBi\fR| \fBl\fR| \fBc\fR] [\fB-R \fR\fBsubset\fR]
+      [\fB\-v\fR \fIn\fR] [\fB\-s d\fR| \fBi\fR| \fBl\fR| \fBc\fR] [\fB\-R \fR\fBsubset\fR]
 .br
-      [\fB-w\fR\ \fIwidth\fR] [\fB-A\fR\ \fIdirectory\fR] [\fB-B\fR\ \fIdirectory\fR]
+      [\fB\-w\fR\ \fIwidth\fR] [\fB\-A\fR\ \fIdirectory\fR] [\fB\-B\fR\ \fIdirectory\fR]
 .br
       [\fItermname\fR...]
 .SH DESCRIPTION
@@ -72,9 +72,9 @@
 string fields.
 .SS Default Options
 If no options are specified and zero or one \fItermnames\fR are specified, the
-\fB-I\fR option will be assumed.  If more than one \fItermname\fR is specified,
-the \fB-d\fR option will be assumed.
-.SS Comparison Options [-d] [-c] [-n]
+\fB\-I\fR option will be assumed.  If more than one \fItermname\fR is specified,
+the \fB\-d\fR option will be assumed.
+.SS Comparison Options [\-d] [\-c] [\-n]
 \fBinfocmp\fR compares the \fBterminfo\fR description of the first terminal
 \fItermname\fR with each of the descriptions given by the entries for the other
 terminal's \fItermnames\fR.  If a capability is defined for only one of the
@@ -82,35 +82,35 @@
 \fBF\fR for boolean variables, \fB-1\fR for integer variables, and \fBNULL\fR
 for string variables.
 
-The \fB-d\fR option produces a list of each capability that is different
+The \fB\-d\fR option produces a list of each capability that is different
 between two entries.  This option is useful to show the difference between two
 entries, created by different people, for the same or similar terminals.
 
-The \fB-c\fR option produces a list of each capability that is common between
+The \fB\-c\fR option produces a list of each capability that is common between
 two entries.  Capabilities that are not set are ignored.  This option can be
-used as a quick check to see if the \fB-u\fR option is worth using.
+used as a quick check to see if the \fB\-u\fR option is worth using.
 
-The \fB-n\fR option produces a list of each capability that is in neither
+The \fB\-n\fR option produces a list of each capability that is in neither
 entry.  If no \fItermnames\fR are given, the environment variable \fBTERM\fR
 will be used for both of the \fItermnames\fR.  This can be used as a quick
 check to see if anything was left out of a description.
-.SS Source Listing Options [-I] [-L] [-C] [-r]
-The \fB-I\fR, \fB-L\fR, and \fB-C\fR options will produce a source listing for
+.SS Source Listing Options [\-I] [\-L] [\-C] [\-r]
+The \fB\-I\fR, \fB\-L\fR, and \fB\-C\fR options will produce a source listing for
 each terminal named.
 
 .TS
 center tab(/) ;
 l l .
-\fB-I\fR/use the \fBterminfo\fR names
-\fB-L\fR/use the long C variable name listed in <\fBterm.h\fR>
-\fB-C\fR/use the \fBtermcap\fR names
-\fB-r\fR/when using \fB-C\fR, put out all capabilities in \fBtermcap\fR form
+\fB\-I\fR/use the \fBterminfo\fR names
+\fB\-L\fR/use the long C variable name listed in <\fBterm.h\fR>
+\fB\-C\fR/use the \fBtermcap\fR names
+\fB\-r\fR/when using \fB\-C\fR, put out all capabilities in \fBtermcap\fR form
 .TE
 
 If no \fItermnames\fR are given, the environment variable \fBTERM\fR will be
 used for the terminal name.
 
-The source produced by the \fB-C\fR option may be used directly as a
+The source produced by the \fB\-C\fR option may be used directly as a
 \fBtermcap\fR entry, but not all parameterized strings can be changed to
 the \fBtermcap\fR format.  \fBinfocmp\fR will attempt to convert most of the
 parameterized information, and anything not converted will be plainly marked in
@@ -123,7 +123,7 @@
 All \fBtermcap\fR variables no longer supported by \fBterminfo\fR, but which
 are derivable from other \fBterminfo\fR variables, will be output.  Not all
 \fBterminfo\fR capabilities will be translated; only those variables which were
-part of \fBtermcap\fR will normally be output.  Specifying the \fB-r\fR option
+part of \fBtermcap\fR will normally be output.  Specifying the \fB\-r\fR option
 will take off this restriction, allowing all capabilities to be output in
 \fItermcap\fR form.
 
@@ -151,8 +151,8 @@
 \fB%p1%?%'x'%>%t%p1%'y'%+%;/%>xy\fR/concept
 \fB%p2\fR is printed before \fB%p1/%r\fR/hp
 .TE
-.SS Use= Option [-u]
-The \fB-u\fR option produces a \fBterminfo\fR source description of the first
+.SS Use= Option [\-u]
+The \fB\-u\fR option produces a \fBterminfo\fR source description of the first
 terminal \fItermname\fR which is relative to the sum of the descriptions given
 by the entries for the other terminals \fItermnames\fR.  It does this by
 analyzing the differences between the first \fItermname\fR and the other
@@ -187,29 +187,29 @@
 the compilation time, is specifying extra \fBuse=\fR fields that are
 superfluous.  \fBinfocmp\fR will flag any other \fItermname use=\fR fields that
 were not needed.
-.SS Changing Databases [-A \fIdirectory\fR] [-B \fIdirectory\fR]
+.SS Changing Databases [\-A \fIdirectory\fR] [\-B \fIdirectory\fR]
 The location of the compiled \fBterminfo\fR database is taken from the
 environment variable \fBTERMINFO\fR .  If the variable is not defined, or the
 terminal is not found in that location, the system \fBterminfo\fR database,
-in \fB@TERMINFO@\fR, will be used.  The options \fB-A\fR
-and \fB-B\fR may be used to override this location.  The \fB-A\fR option will
-set \fBTERMINFO\fR for the first \fItermname\fR and the \fB-B\fR option will
+in \fB@TERMINFO@\fR, will be used.  The options \fB\-A\fR
+and \fB\-B\fR may be used to override this location.  The \fB\-A\fR option will
+set \fBTERMINFO\fR for the first \fItermname\fR and the \fB\-B\fR option will
 set \fBTERMINFO\fR for the other \fItermnames\fR.  With this, it is possible to
 compare descriptions for a terminal with the same name located in two different
 databases.  This is useful for comparing descriptions for the same terminal
 created by different people.
 .SS Other Options
 .TP 5
-\fB-1\fR
+\fB\-1\fR
 causes the fields to be printed out one to a line.  Otherwise,
 the fields will be printed several to a line to a maximum width
 of 60 characters.
 .TP
-\fB-a\fR
+\fB\-a\fR
 tells \fBinfocmp\fP to retain commented-out capabilities rather than discarding
 them.  Capabilities are commented by prefixing them with a period.
 .TP 5
-\fB-E\fR
+\fB\-E\fR
 Dump the capabilities of the given terminal as tables, needed in
 the C initializer for a
 TERMTYPE structure (the terminal capability structure in the \fB<term.h>\fR).
@@ -218,17 +218,17 @@
 The tables are all declared static, and are named according to the type
 and the name of the corresponding terminal entry.
 .sp
-Before ncurses 5.0, the split between the \fB\-e\fP and \fB\-E\fP 
+Before ncurses 5.0, the split between the \fB\-e\fP and \fB\-E\fP
 options was not needed; but support for extended names required making
 the arrays of terminal capabilities separate from the TERMTYPE structure.
 .TP 5
-\fB-e\fR
+\fB\-e\fR
 Dump the capabilities of the given terminal as a C initializer for a
 TERMTYPE structure (the terminal capability structure in the \fB<term.h>\fR).
 This option is useful for preparing versions of the curses library hardwired
 for a given terminal type.
 .TP 5
-\fB-F\fR
+\fB\-F\fR
 compare terminfo files.  This assumes that two following arguments are
 filenames.  The files are searched for pairwise matches between
 entries, with two entries considered to match if any of their names do.
@@ -237,21 +237,21 @@
 with exactly one match it includes a difference report.  Normally,
 to reduce the volume of the report, use references are
 not resolved before looking for differences, but resolution can be forced
-by also specifying \fB-r\fR.
+by also specifying \fB\-r\fR.
 .TP 5
-\fB-f\fR
+\fB\-f\fR
 Display complex terminfo strings which contain if/then/else/endif expressions
 indented for readability.
 .TP 5
-\fB-G\fR
+\fB\-G\fR
 Display constant literals in decimal form
 rather than their character equivalents.
 .TP 5
-\fB-g\fR
+\fB\-g\fR
 Display constant character literals in quoted form
 rather than their decimal equivalents.
 .TP 5
-\fB-i\fR
+\fB\-i\fR
 Analyze the initialization (\fBis1\fR, \fBis2\fR, \fBis3\fR), and reset
 (\fBrs1\fR, \fBrs2\fR, \fBrs3\fR), strings in the entry.  For each string, the
 code tries to analyze it into actions in terms of the other capabilities in the
@@ -302,17 +302,17 @@
 
 An SGR0 designates an empty highlight sequence (equivalent to {SGR:NORMAL}).
 .TP 5
-\bB-l\fR
+\fB\-l\fR
 Set output format to terminfo.
 .TP 5
-\fB-p\fR
+\fB\-p\fR
 Ignore padding specifications when comparing strings.
 .TP 5
-\fB-q\fR
+\fB\-q\fR
 Make the comparison listing shorter by omitting subheadings, and using
 "-" for absent capabilities, "@" for canceled rather than "NULL".
 .TP 5
-\fB-R\fR\fIsubset\fR
+\fB\-R\fR\fIsubset\fR
 Restrict output to a given subset.  This option is for use with archaic
 versions of terminfo like those on SVr1, Ultrix, or HP/UX that do not support
 the full set of SVR4/XSI Curses terminfo; and variants such as AIX
@@ -321,8 +321,8 @@
 details.  You can also choose the subset "BSD" which selects only capabilities
 with termcap equivalents recognized by 4.4BSD.
 .TP
-\fB-s \fR\fI[d|i|l|c]\fR
-The \fB-s\fR option sorts the fields within each type according to the argument
+\fB\-s \fR\fI[d|i|l|c]\fR
+The \fB\-s\fR option sorts the fields within each type according to the argument
 below:
 .br
 .RS 5
@@ -340,30 +340,30 @@
 sort by the \fItermcap\fR name.
 .RE
 .IP
-If the \fB-s\fR option is not given, the fields printed out will be
+If the \fB\-s\fR option is not given, the fields printed out will be
 sorted alphabetically by the \fBterminfo\fR name within each type,
-except in the case of the \fB-C\fR or the \fB-L\fR options, which cause the
+except in the case of the \fB\-C\fR or the \fB\-L\fR options, which cause the
 sorting to be done by the \fBtermcap\fR name or the long C variable
 name, respectively.
 .TP 5
-\fB-T\fR
+\fB\-T\fR
 eliminates size-restrictions on the generated text.
 This is mainly useful for testing and analysis, since the compiled
 descriptions are limited (e.g., 1023 for termcap, 4096 for terminfo).
 .TP
-\fB-t\fR
+\fB\-t\fR
 tells \fBtic\fP to discard commented-out capabilities.
 Normally when translating from terminfo to termcap,
 untranslatable capabilities are commented-out.
 .TP 5
-\fB-V\fR
+\fB\-V\fR
 reports the version of ncurses which was used in this program, and exits.
 .TP 5
-\fB-v\fR \fIn\fR
+\fB\-v\fR \fIn\fR
 prints out tracing information on standard error as the program runs.
 Higher values of n induce greater verbosity.
 .TP 5
-\fB-w\fR \fIwidth\fR
+\fB\-w\fR \fIwidth\fR
 changes the output to \fIwidth\fR characters.
 .SH FILES
 .TP 20
@@ -371,28 +371,28 @@
 Compiled terminal description database.
 .SH EXTENSIONS
 The
-\fB-E\fR,
-\fB-F\fR,
-\fB-G\fR,
-\fB-R\fR,
-\fB-T\fR,
-\fB-V\fR,
-\fB-a\fR,
-\fB-e\fR,
-\fB-f\fR,
-\fB-g\fR,
-\fB-i\fR,
-\fB-l\fR,
-\fB-p\fR,
-\fB-q\fR and
-\fB-t\fR
+\fB\-E\fR,
+\fB\-F\fR,
+\fB\-G\fR,
+\fB\-R\fR,
+\fB\-T\fR,
+\fB\-V\fR,
+\fB\-a\fR,
+\fB\-e\fR,
+\fB\-f\fR,
+\fB\-g\fR,
+\fB\-i\fR,
+\fB\-l\fR,
+\fB\-p\fR,
+\fB\-q\fR and
+\fB\-t\fR
 options are not supported in SVr4 curses.
 
-The \fB-r\fR option's notion of `termcap' capabilities is System V Release 4's.
+The \fB\-r\fR option's notion of `termcap' capabilities is System V Release 4's.
 Actual BSD curses versions will have a more restricted set.  To see only the
-4.4BSD set, use -r -RBSD.
+4.4BSD set, use \fB\-r\fR \fB\-RBSD\fR.
 .SH BUGS
-The -F option of \fBinfocmp\fR(1M) should be a \fBtoe\fR(1M) mode.
+The \fB\-F\fR option of \fBinfocmp\fR(1M) should be a \fBtoe\fR(1M) mode.
 .SH SEE ALSO
 \fBinfocmp\fR(1M), \fBcaptoinfo\fR(1M), \fBinfotocap\fR(1M),
 \fBtic\fR(1M), \fBtoe\fR(1M),
Index: man/infotocap.1m
Prereq:  1.3 
--- ncurses-5.3-20021012/man/infotocap.1m	Sat Aug 12 21:56:03 2000
+++ ncurses-5.3-20030719/man/infotocap.1m	Sat May 10 20:32:53 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1999,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1999-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,40 +27,40 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: infotocap.1m,v 1.3 2000/08/13 01:56:03 tom Exp $
+.\" $Id: infotocap.1m,v 1.4 2003/05/11 00:32:53 tom Exp $
 .TH infotocap 1M ""
 .ds n 5
 .ds d @TERMINFO@
 .SH NAME
 \fBinfotocap\fR - convert a \fIterminfo\fR description into a \fItermcap\fR description
 .SH SYNOPSIS
-\fBinfotocap\fR [\fB-v\fR\fIn\fR \fIwidth\fR]  [\fB-V\fR] [\fB-1\fR] [\fB-w\fR \fIwidth\fR] \fIfile\fR . . .
+\fBinfotocap\fR [\fB\-v\fR\fIn\fR \fIwidth\fR]  [\fB\-V\fR] [\fB\-1\fR] [\fB\-w\fR \fIwidth\fR] \fIfile\fR . . .
 .SH DESCRIPTION
 \fBinfotocap\fR looks in \fIfile\fR for \fBterminfo\fR descriptions.  For each
 one found, an equivalent \fBtermcap\fR description is written to standard
 output.  Terminfo \fBuse\fR capabilities are translated directly to termcap
 \fBtc\fR capabilities.
 .TP 5
-\fB-v\fR
+\fB\-v\fR
 print out tracing information on standard error as the program runs.
 .TP 5
-\fB-V\fR
+\fB\-V\fR
 print out the version of the program in use on standard error and exit.
 .TP 5
-\fB-1\fR
+\fB\-1\fR
 cause the fields to print out one to a line.  Otherwise, the fields
 will be printed several to a line to a maximum width of 60
 characters.
 .TP 5
-\fB-w\fR
+\fB\-w\fR
 change the output to \fIwidth\fR characters.
 .SH FILES
 .TP 20
 \*d
 Compiled terminal description database.
 .SH NOTES
-This utility is actually a link to \fItic\fR(1M), running in \fI-C\fR mode.
-You can use other \fItic\fR options such as \fB-f\fR and  \fB-x\fR.
+This utility is actually a link to \fItic\fR(1M), running in \fI\-C\fR mode.
+You can use other \fItic\fR options such as \fB\-f\fR and  \fB\-x\fR.
 .SH SEE ALSO
 \fBcurses\fR(3X),
 \fBtic\fR(1M),
Index: man/key_defined.3x
--- /dev/null	Tue Jun  3 10:49:35 2003
+++ ncurses-5.3-20030719/man/key_defined.3x	Sat May 17 19:24:45 2003
@@ -0,0 +1,60 @@
+.\"***************************************************************************
+.\" Copyright (c) 2003 Free Software Foundation, Inc.                        *
+.\"                                                                          *
+.\" Permission is hereby granted, free of charge, to any person obtaining a  *
+.\" copy of this software and associated documentation files (the            *
+.\" "Software"), to deal in the Software without restriction, including      *
+.\" without limitation the rights to use, copy, modify, merge, publish,      *
+.\" distribute, distribute with modifications, sublicense, and/or sell       *
+.\" copies of the Software, and to permit persons to whom the Software is    *
+.\" furnished to do so, subject to the following conditions:                 *
+.\"                                                                          *
+.\" The above copyright notice and this permission notice shall be included  *
+.\" in all copies or substantial portions of the Software.                   *
+.\"                                                                          *
+.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
+.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
+.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
+.\" IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
+.\" DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
+.\" OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
+.\" THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
+.\"                                                                          *
+.\" Except as contained in this notice, the name(s) of the above copyright   *
+.\" holders shall not be used in advertising or otherwise to promote the     *
+.\" sale, use or other dealings in this Software without prior written       *
+.\" authorization.                                                           *
+.\"***************************************************************************
+.\"
+.\" Author: Thomas E. Dickey 2003
+.\"
+.\" $Id: key_defined.3x,v 1.2 2003/05/17 23:24:45 tom Exp $
+.TH key_defined 3X ""
+.SH NAME
+\fBdefine_key\fP \- define a keycode
+.SH SYNOPSIS
+\fB#include <curses.h>\fP
+
+\fBint key_defined(const char *definition);\fP
+.SH DESCRIPTION
+This is an extension to the curses library.
+It permits an application to determine if a string is currently bound
+to any keycode.
+.SH RETURN VALUE
+If the string is bound to a keycode, its value (greater than zero) is returned.
+If no keycode is bound, zero is returned.
+If the string conflicts with longer strings which are bound to keys, -1 is returned.
+.SH PORTABILITY
+These routines are specific to ncurses.  They were not supported on
+Version 7, BSD or System V implementations.  It is recommended that
+any code depending on them be conditioned using NCURSES_VERSION.
+.SH SEE ALSO
+\fBdefine_key\fR(3X).
+.SH AUTHOR
+Thomas Dickey.
+.\"#
+.\"# The following sets edit modes for GNU EMACS
+.\"# Local Variables:
+.\"# mode:nroff
+.\"# fill-column:79
+.\"# End:
Index: man/keybound.3x
Prereq:  1.3 
--- ncurses-5.3-20021012/man/keybound.3x	Sat Feb 16 17:30:36 2002
+++ ncurses-5.3-20030719/man/keybound.3x	Sat Mar  8 14:08:33 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1999,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -28,7 +28,7 @@
 .\"
 .\" Author: Thomas E. Dickey <dickey@clark.net> 1999
 .\"
-.\" $Id: keybound.3x,v 1.3 2002/02/16 22:30:36 tom Exp $
+.\" $Id: keybound.3x,v 1.4 2003/03/08 19:08:33 tom Exp $
 .TH keyok 3X ""
 .SH NAME
 \fBkeybound\fP \- return definition of keycode
@@ -41,9 +41,12 @@
 It permits an application to determine the string which is defined
 in the terminfo for specific keycodes.
 .SH RETURN VALUE
-The keycode must be greater than zero, else NULL is returned.
+The \fIkeycode\fP parameter must be greater than zero, else NULL is returned.
 If it does not correspond to a defined key, then NULL is returned.
-Otherwise, the function returns a string, which must be freed by the caller.
+The \fIcount\fP parameter is used to allow the application to iterate
+through multiple definitions, counting from zero.
+When successful,
+the function returns a string which must be freed by the caller.
 .SH PORTABILITY
 These routines are specific to ncurses.  They were not supported on
 Version 7, BSD or System V implementations.  It is recommended that
Index: man/make_sed.sh
Prereq:  1.5 
--- ncurses-5.3-20021012/man/make_sed.sh	Wed Feb 11 07:13:48 1998
+++ ncurses-5.3-20030719/man/make_sed.sh	Sat Jan 11 17:23:11 2003
@@ -1,7 +1,7 @@
 #!/bin/sh
-# $Id: make_sed.sh,v 1.5 1998/02/11 12:13:48 tom Exp $
+# $Id: make_sed.sh,v 1.6 2003/01/11 22:23:11 tom Exp $
 ##############################################################################
-# Copyright (c) 1998 Free Software Foundation, Inc.                          #
+# Copyright (c) 1998,2003 Free Software Foundation, Inc.                     #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -47,7 +47,7 @@
 rm -f $UPPER $SCRIPT $RESULT
 trap "rm -f $COL.* $INPUT $UPPER $SCRIPT $RESULT" 0 1 2 5 15
 fgrep -v \# $1 | \
-sed	-e 's/[	]\+/	/g' >$INPUT
+sed	-e 's/[	][	]*/	/g' >$INPUT
 
 for F in 1 2 3 4
 do
Index: man/man_db.renames
Prereq:  0.31 
--- ncurses-5.3-20021012/man/man_db.renames	Sat Apr 13 17:49:08 2002
+++ ncurses-5.3-20030719/man/man_db.renames	Sat May 31 13:27:11 2003
@@ -1,4 +1,4 @@
-# $Id: man_db.renames,v 0.31 2002/04/13 21:49:08 tom Exp $
+# $Id: man_db.renames,v 0.32 2003/05/31 17:27:11 tom Exp $
 # Manual-page renamings for the man_db program
 #
 # Files:
@@ -89,6 +89,7 @@
 infotocap.1m			infotocap.1
 keybound.3x			keybound.3ncurses
 keyok.3x			keyok.3ncurses
+key_defined.3x			key_defined.3ncurses
 menu.3x				menu.3menu
 menu_attributes.3x		attributes.3menu
 menu_cursor.3x			cursor.3menu
Index: man/manlinks.sed
Prereq:  1.10 
--- ncurses-5.3-20021012/man/manlinks.sed	Sat Sep 21 15:02:03 2002
+++ ncurses-5.3-20030719/man/manlinks.sed	Sat May 24 14:57:33 2003
@@ -1,6 +1,6 @@
-# $Id: manlinks.sed,v 1.10 2002/09/21 19:02:03 tom Exp $
+# $Id: manlinks.sed,v 1.11 2003/05/24 18:57:33 tom Exp $
 ##############################################################################
-# Copyright (c) 2000,2002 Free Software Foundation, Inc.                     #
+# Copyright (c) 2000-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -29,6 +29,8 @@
 # Given a manpage (nroff) as input, writes a list of the names that are
 # listed in the "NAME" section, i.e., the names that we would like to use
 # as aliases for the manpage -T.Dickey
+#
+# eliminate formatting controls that get in the way
 /^'\\"/d
 /\.\\"/d
 /^\.br/d
@@ -36,11 +38,18 @@
 s/^\.IX//
 s/\\f.//g
 s/[:,]/ /g
+#
+# eliminate unnecessary whitespace, convert multiple blanks to single space
 s/^[ 	][ 	]*//
 s/[ 	][ 	]*$//
 s/[ 	][ 	]*/ /g
+#
+# convert ".SH" into a more manageable form
 s/\.SH[ 	][ 	]*/.SH_(/
 #
+# in ".SH NAME"
+# change "\-" to "-", eliminate text after "-", and split the remaining lines
+# at each space, making a list of names:
 /^\.SH_(NAME/,/^\.SH_(SYNOPSIS/{
 s/\\-.*/ -/
 / -/{
@@ -54,16 +63,39 @@
 s/ /\
 /g
 }
+#
+# in ".SH SYNOPSIS"
+# remove any line that does not contain a '(', since we only want functions.
+# then strip off return-type of each function.
+# finally, remove the parameter list, which begins with a '('.
 /^\.SH_(SYNOPSIS/,/^\.SH_(DESCRIPTION/{
-	/^#/d
 	/^[^(]*$/d
+	# reduce
+	#	.B "int add_wch( const cchar_t *\fIwch\fB );"
+	# to
+	#	add_wch( const cchar_t *\fIwch\fB );"
 	s/^\([^ (]* [^ (]* [*]*\)//g
 	s/^\([^ (]* [*]*\)//g
+	# trim blanks in case we have
+	#	void (*) (FORM *) field_init(const FORM *form);
+	s/) (/)(/g
+	# reduce stuff like
+	#	void (*)(FORM *) field_init(const FORM *form);
+	# to
+	#	field_init(const FORM *form);
+	s/^\(([^)]*)\)\(([^)]*)\)*[ ]*//g
+	# rename marker temporarily
 	s/\.SH_(/.SH_/
-	s/(.*//
+	# kill lines with ");", and trim off beginning of argument list.
+	s/[()].*//
+	# rename marker back
 	s/\.SH_/.SH_(/
 }
+#
+# delete ".SH DESCRIPTION" and following lines
 /^\.SH_(DESCRIPTION/,${
 	d
 }
+#
+# delete any remaining directives
 /^\./d
Index: man/menu_driver.3x
Prereq:  1.10 
--- ncurses-5.3-20021012/man/menu_driver.3x	Sat Feb 16 17:40:59 2002
+++ ncurses-5.3-20030719/man/menu_driver.3x	Sat May 10 16:22:01 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: menu_driver.3x,v 1.10 2002/02/16 22:40:59 tom Exp $
+.\" $Id: menu_driver.3x,v 1.11 2003/05/10 20:22:01 tom Exp $
 .TH menu_driver 3X ""
 .SH NAME
 \fBmenu_driver\fR - command-processing loop of the menu system
@@ -115,10 +115,10 @@
 is generated and \fBE_UNKNOWN_COMMAND\fR is returned. This return value makes
 sense, because a double click usually means that an item-specific action should
 be returned. It's exactly the purpose of this return value to signal that an
-application specific command should be executed. If a translation 
+application specific command should be executed. If a translation
 into a request was done, \fBmenu_driver\fR returns the result of this request.
 If you clicked outside the user window or the mouse event couldn't be translated
-into a menu request an \fBE_REQUEST_DENIED\fR is returned. 
+into a menu request an \fBE_REQUEST_DENIED\fR is returned.
 .PP
 If the second argument is neither printable ASCII nor one of the above
 pre-defined menu requests or KEY_MOUSE, the drive assumes it is an application-specific
Index: man/menu_pattern.3x
Prereq:  1.7 
--- ncurses-5.3-20021012/man/menu_pattern.3x	Sat Feb 16 17:40:59 2002
+++ ncurses-5.3-20030719/man/menu_pattern.3x	Sat May 10 16:22:01 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: menu_pattern.3x,v 1.7 2002/02/16 22:40:59 tom Exp $
+.\" $Id: menu_pattern.3x,v 1.8 2003/05/10 20:22:01 tom Exp $
 .TH menu_pattern 3X ""
 .SH NAME
 \fBmenu_pattern\fR - get and set a menu's pattern buffer
@@ -44,7 +44,7 @@
 
 The function \fBset_menu_pattern\fR sets the pattern buffer for the given menu
 and tries to find the first matching item.  If it succeeds, that item becomes
-current; if not, the current item does not change.  
+current; if not, the current item does not change. 
 
 The function \fBmenu_pattern\fR returns the pattern buffer of the given
 \fImenu\fR.
Index: man/ncurses.3x
Prereq:  1.63 
--- ncurses-5.3-20021012/man/ncurses.3x	Sat Aug 10 17:56:07 2002
+++ ncurses-5.3-20030719/man/ncurses.3x	Sat May 10 20:32:53 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998,1999,2001,2002 Free Software Foundation, Inc.         *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: ncurses.3x,v 1.63 2002/08/10 21:56:07 tom Exp $
+.\" $Id: ncurses.3x,v 1.66 2003/05/11 00:32:53 tom Exp $
 .hy 0
 .TH ncurses 3X ""
 .ds n 5
@@ -322,6 +322,7 @@
 is_linetouched/\fBcurs_touch\fR(3X)
 is_wintouched/\fBcurs_touch\fR(3X)
 isendwin/\fBcurs_initscr\fR(3X)
+key_defined/\fBkey_defined\fR(3X)*
 key_name/\fBcurs_util\fR(3X)
 keybound/\fBkeybound\fR(3X)*
 keyname/\fBcurs_util\fR(3X)
@@ -614,9 +615,9 @@
 otherwise noted in the routine descriptions.
 
 All macros return the value of the \fBw\fR version, except \fBsetscrreg\fR,
-\fBwsetscrreg\fR, \fBgetyx\fR, \fBgetbegyx\fR, \fBgetmaxyx\fR.  The return
+\fBwsetscrreg\fR, \fBgetyx\fR, \fBgetbegyx\fR, and \fBgetmaxyx\fR.  The return
 values of \fBsetscrreg\fR, \fBwsetscrreg\fR, \fBgetyx\fR, \fBgetbegyx\fR, and
-\fBgetmaxyx\fR are undefined (\fIi\fR.\fIe\fR., these should not be used as the
+\fBgetmaxyx\fR are undefined (i.e., these should not be used as the
 right-hand side of assignment statements).
 
 Routines that return pointers return \fBNULL\fR on error.
@@ -629,7 +630,7 @@
 The debugging library checks this environment symbol when the application
 has redirected output to a file.
 The symbol's numeric value is used for the baudrate.
-If no value is found \fBncurses\fR uses 9600.
+If no value is found, \fBncurses\fR uses 9600.
 This allows testers to construct repeatable test-cases
 that take into account costs that depend on baudrate.
 .TP 5
@@ -784,7 +785,7 @@
 .RS
 .TP 3
 -
-the last directory to which \fBncurses\fR wrote, if any, is searched first.
+the last directory to which \fBncurses\fR wrote, if any, is searched first
 .TP 3
 -
 the directory specified by the TERMINFO symbol
@@ -828,7 +829,7 @@
 \fBterminfo\fR(\*n) and related pages whose names begin "curs_" for detailed routine
 descriptions.
 .SH EXTENSIONS
-The \fBncurses\fR library can be compiled with an option (\fB-DUSE_GETCAP\fR)
+The \fBncurses\fR library can be compiled with an option (\fB\-DUSE_GETCAP\fR)
 that falls back to the old-style /etc/termcap file if the terminal setup code
 cannot find a terminfo entry corresponding to \fBTERM\fR.  Use of this feature
 is not recommended, as it essentially includes an entire termcap compiler in
@@ -848,6 +849,7 @@
 of terminals by allowing the application designer to define additional
 key sequences at runtime.
 See the \fBdefine_key\fR(3X)
+\fBkey_defined\fR(3X),
 and \fBkeyok\fR(3X) manual pages for details.
 
 The \fBncurses\fR library can exploit the capabilities of terminals which
Index: man/panel.3x
Prereq:  1.10 
--- ncurses-5.3-20021012/man/panel.3x	Sat Aug 12 21:56:47 2000
+++ ncurses-5.3-20030719/man/panel.3x	Sat May 17 18:44:09 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998 Free Software Foundation, Inc.                        *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: panel.3x,v 1.10 2000/08/13 01:56:47 tom Exp $
+.\" $Id: panel.3x,v 1.11 2003/05/17 22:44:09 jmc Exp $
 .TH panel 3X ""
 .ds n 5
 .ds d @TERMINFO@
@@ -77,7 +77,7 @@
 of the stack.
 .P
 A window is associated with every panel. The panel routines enable
-you to create, move, hides, and show panels, as well as position a
+you to create, move, hide, and show panels, as well as position a
 panel at any desired location in the stack.
 .P
 Panel routines are a functional layer added to \fBcurses\fR(3X), make only
Index: man/term.5
Prereq:  1.14 
--- ncurses-5.3-20021012/man/term.5	Sat Aug 10 17:59:37 2002
+++ ncurses-5.3-20030719/man/term.5	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2002 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: term.5,v 1.14 2002/08/10 21:59:37 tom Exp $
+.\" $Id: term.5,v 1.15 2003/05/10 20:33:49 jmc Exp $
 .TH TERM 5
 .ds n 5
 .ds d @TERMINFO@
@@ -56,7 +56,7 @@
 or sign extension are made.
 .PP
 The compiled file is created with the
-.I tic 
+.I tic
 program, and read by the routine
 .IR setupterm .
 The file is divided into six parts:
@@ -84,7 +84,7 @@
 and the second byte contains the most significant 8 bits.
 (Thus, the value represented is 256*second+first.)
 The value \-1 is represented by the two bytes 0377, 0377; other negative
-values are illegal. This value generally 
+values are illegal. This value generally
 means that the corresponding capability is missing from this terminal.
 Note that this format corresponds to the hardware of the \s-1VAX\s+1
 and \s-1PDP\s+1-11 (that is, little-endian machines).
@@ -160,12 +160,12 @@
 ADM-3, a popular though rather stupid early terminal:
 .nf
 .sp
-adm3a|lsi adm3a, 
-        am, 
-        cols#80, lines#24, 
-        bel=^G, clear=\032$<1>, cr=^M, cub1=^H, cud1=^J, 
-        cuf1=^L, cup=\\E=%p1%{32}%+%c%p2%{32}%+%c, cuu1=^K, 
-        home=^^, ind=^J, 
+adm3a|lsi adm3a,
+        am,
+        cols#80, lines#24,
+        bel=^G, clear=\032$<1>, cr=^M, cub1=^H, cud1=^J,
+        cuf1=^L, cup=\\E=%p1%{32}%+%c%p2%{32}%+%c, cuu1=^K,
+        home=^^, ind=^J,
 .sp
 .ft CW
 \s-20000  1a 01 10 00 02 00 03 00  82 00 31 00 61 64 6d 33  ........ ..1.adm3
Index: man/term.7
Prereq:  1.13 
--- ncurses-5.3-20021012/man/term.7	Sat Apr 20 12:50:47 2002
+++ ncurses-5.3-20030719/man/term.7	Sat May 10 16:33:49 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: term.7,v 1.13 2002/04/20 16:50:47 tom Exp $
+.\" $Id: term.7,v 1.14 2003/05/10 20:33:49 jmc Exp $
 .TH TERM 7
 .ds n 5
 .ds d @TERMINFO@
@@ -96,7 +96,7 @@
 First, choose a root name.  The root will consist of a lower-case letter
 followed by up to seven lower-case letters or digits.  You need to avoid using
 punctuation characters in root names, because they are used and interpreted as
-filenames and shell meta-characters (such as !, $, *, ? etc.) embedded in them
+filenames and shell meta-characters (such as !, $, *, ?, etc.) embedded in them
 may cause odd and unhelpful behavior.  The slash (/), or any other character
 that may be interpreted by anyone's file system (\e, $, [, ]), is especially
 dangerous (terminfo is platform-independent, and choosing names with special
@@ -136,29 +136,29 @@
 attributes.
 .TP 5
 -am
-Enable auto-margin (right-margin wraparound)
+Enable auto-margin (right-margin wraparound).
 .TP 5
 -m
-Mono mode - suppress color support
+Mono mode - suppress color support.
 .TP 5
 -na
 No arrow keys - termcap ignores arrow keys which are actually there on the
 terminal, so the user can use the arrow keys locally.
 .TP 5
 -nam
-No auto-margin - suppress am capability
+No auto-margin - suppress am capability.
 .TP 5
 -nl
-No labels - suppress soft labels
+No labels - suppress soft labels.
 .TP 5
 -nsl
-No status line - suppress status line
+No status line - suppress status line.
 .TP 5
 -pp
 Has a printer port which is used.
 .TP 5
 -rv
-Terminal in reverse video mode (black on white)
+Terminal in reverse video mode (black on white).
 .TP 5
 -s
 Enable status line.
@@ -190,10 +190,10 @@
 compiled terminal capability data base
 .TP 5
 /etc/inittab
-tty line initialization (AT&T-like UNIXes).
+tty line initialization (AT&T-like UNIXes)
 .TP 5
 /etc/ttys
-tty line initialization (BSD-like UNIXes).
+tty line initialization (BSD-like UNIXes)
 .SH SEE ALSO
 \fBcurses\fR(3X), \fBterminfo\fR(\*n), \fBterm\fR(\*n).
 .\"#
Index: man/terminfo.tail
Prereq:  1.35 
--- ncurses-5.3-20021012/man/terminfo.tail	Sat Apr 20 12:49:33 2002
+++ ncurses-5.3-20030719/man/terminfo.tail	Sun Jan  5 17:47:05 2003
@@ -1,4 +1,4 @@
-.\" $Id: terminfo.tail,v 1.35 2002/04/20 16:49:33 tom Exp $
+.\" $Id: terminfo.tail,v 1.38 2003/01/05 22:47:05 tom Exp $
 .\" Beginning of terminfo.tail file
 .ps +1
 .PP
@@ -311,42 +311,81 @@
 to manipulate it.
 Typically a sequence will push one of the
 parameters onto the stack and then print it in some format.
-Often more complex operations are necessary.
+Print (e.g., "%d") is a special case.
+Other operations, including "%t" pop their operand from the stack.
+It is noted that more complex operations are often necessary,
+e.g., in the \fBsgr\fP string.
 .PP
 The \fB%\fR encodings have the following meanings:
 .PP
-.DT
-.nf
-.ta .5i 1.5i
-	\s-1%%	outputs `%'
-	%\fI[[\fP:\fI]flags][width[.precision]][\fPdoxXs\fI]\fP
-		as in \fBprintf\fP, flags are [-+#] and space
-	%c	print pop() like %c in printf()
-	%s	print pop() like %s in printf()
-
-	%p[1-9]	push \fIi\fP'th parm
-	%P[a-z]	set dynamic variable [a-z] to pop()
-	%g[a-z]	get dynamic variable [a-z] and push it
-	%P[A-Z]	set static variable [a-z] to pop()
-	%g[A-Z]	get static variable [a-z] and push it
-	%'\fIc\fP'	char constant \fIc\fP
-	%{\fInn\fP}	integer constant \fInn\fP
-	%l	push strlen(pop)
-
-	%+ %- %* %/ %m
-		arithmetic (%m is mod): push(pop() op pop())
-	%& %| %^	bit operations: push(pop() op pop())
-	%= %> %<	logical operations: push(pop() op pop())
-	%A, %O	logical and & or operations (for conditionals)
-	%! %~	unary operations push(op pop())
-	%i	add 1 to first two parameters (for ANSI terminals)
-
-	%? expr %t thenpart %e elsepart %;
-		if-then-else, %e elsepart is optional.
-		else-if's are possible a la Algol 68:
-		%? c\d1\u %t b\d1\u %e c\d2\u %t b\d2\u %e c\d3\u %t b\d3\u %e c\d4\u %t b\d4\u %e %;
-\s+1		c\di\u are conditions, b\di\u are bodies.
-.fi
+.TP 5
+\s-1%%
+outputs `%'
+.TP
+%\fI[[\fP:\fI]flags][width[.precision]][\fPdoxXs\fI]\fP
+as in \fBprintf\fP, flags are [-+#] and space
+.TP
+%c
+print pop() like %c in \fBprintf\fP
+.TP
+%s
+print pop() like %s in \fBprintf\fP
+.TP
+%p[1-9]
+push \fIi\fP'th parameter
+.TP
+%P[a-z]
+set dynamic variable [a-z] to pop()
+.TP
+%g[a-z]
+get dynamic variable [a-z] and push it
+.TP
+%P[A-Z]
+set static variable [a-z] to pop()
+.TP
+%g[A-Z]
+get static variable [a-z] and push it
+.IP
+The terms "static" and "dynamic" are misleading.
+Historically, these are simply two different sets of variables,
+whose values are not reset between calls to \fBtparm\fP.
+However, that fact is not documented in other implementations.
+Relying on it will adversely impact portability to other implementations.
+.TP
+%'\fIc\fP'
+char constant \fIc\fP
+.TP
+%{\fInn\fP}
+integer constant \fInn\fP
+.TP
+%l
+push strlen(pop)
+.TP
+%+ %- %* %/ %m
+arithmetic (%m is mod): push(pop() op pop())
+.TP
+%& %| %^
+bit operations: push(pop() op pop())
+.TP
+%= %> %<
+logical operations: push(pop() op pop())
+.TP
+%A, %O
+logical and & or operations (for conditionals)
+.TP
+%! %~
+unary operations push(op pop())
+.TP
+%i
+add 1 to first two parameters (for ANSI terminals)
+.TP
+%? \fIexpr\fP %t \fIthenpart\fP %e \fIelsepart\fP %;
+if-then-else, %e \fIelsepart\fP is optional.
+else-if's are possible a la Algol 68:
+.br
+%? c\d1\u %t b\d1\u %e c\d2\u %t b\d2\u %e c\d3\u %t b\d3\u %e c\d4\u %t b\d4\u %e %;
+.br
+c\di\u are conditions, b\di\u are bodies.
 .PP
 Binary operations are in postfix form with the operands in the usual order.
 That is, to get x-5 one would use "%gx%{5}%-".
@@ -1170,7 +1209,7 @@
 .PP
 The \fBsetaf\fR/\fBsetab\fR and \fBsetf\fR/\fBsetb\fR capabilities take a
 single numeric argument each.
-Argument values 0-7 are portably defined as
+Argument values 0-7 of \fBsetaf\fR/\fBsetab\fR are portably defined as
 follows (the middle column is the symbolic #define available in the header for
 the \fBcurses\fR or \fBncurses\fR libraries).
 The terminal hardware is free to
@@ -1191,6 +1230,25 @@
 cyan	\fBCOLOR_CYAN\fR	6	0,max,max
 white	\fBCOLOR_WHITE\fR	7	max,max,max
 .TE
+.PP
+The argument values of \fBsetf\fR/\fBsetb\fR historically correspond to
+a different mapping, i.e.,
+.TS H
+center;
+l c c c
+l l n l.
+\fBColor	#define 	Value	RGB\fR
+black	\fBCOLOR_BLACK\fR	0	0, 0, 0
+blue	\fBCOLOR_BLUE\fR	1	0,0,max
+green	\fBCOLOR_GREEN\fR	2	0,max,0
+cyan	\fBCOLOR_CYAN\fR	3	0,max,max
+red	\fBCOLOR_RED\ \fR	4	max,0,0
+magenta	\fBCOLOR_MAGENTA\fR	5	max,0,max
+yellow	\fBCOLOR_YELLOW\fR	6	max,max,0
+white	\fBCOLOR_WHITE\fR	7	max,max,max
+.TE
+It is important to not confuse the two sets of color capabilities;
+otherwise red/blue will be interchanged on the display.
 .PP
 On an HP-like terminal, use \fBscp\fR with a color-pair number parameter to set
 which color pair is current.
Index: man/tic.1m
Prereq:  1.33 
--- ncurses-5.3-20021012/man/tic.1m	Sat Oct  5 16:06:13 2002
+++ ncurses-5.3-20030719/man/tic.1m	Sat May 10 20:32:53 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,7 +26,7 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: tic.1m,v 1.33 2002/10/05 20:06:13 tom Exp $
+.\" $Id: tic.1m,v 1.35 2003/05/11 00:32:53 tom Exp $
 .TH tic 1M ""
 .ds n 5
 .ds d @TERMINFO@
@@ -52,11 +52,11 @@
 t\
 x\
 \fR]
-[\fB-e\fR \fInames\fR]
-[\fB-o\fR \fIdir\fR]
-[\fB-R\fR \fIsubset\fR]
-[\fB-v\fR[\fIn\fR]]
-[\fB-w\fR[\fIn\fR]]
+[\fB\-e\fR \fInames\fR]
+[\fB\-o\fR \fIdir\fR]
+[\fB\-R\fR \fIsubset\fR]
+[\fB\-v\fR[\fIn\fR]]
+[\fB\-w\fR[\fIn\fR]]
 \fIfile\fR
 .br
 .SH DESCRIPTION
@@ -78,31 +78,31 @@
 directory first, look at \fI$HOME/.terminfo\fR if TERMINFO is not set, and
 finally look in \fI\*d\fR.
 .TP
-\fB-1\fR
+\fB\-1\fR
 restricts the output to a single column
 .TP
-\fB-a\fR
+\fB\-a\fR
 tells \fBtic\fP to retain commented-out capabilities rather than discarding
 them.  Capabilities are commented by prefixing them with a period.
-This sets the \fB-x\fR option, because it treats the commented-out
+This sets the \fB\-x\fR option, because it treats the commented-out
 entries as user-defined names.
 .TP
-\fB-C\fR
-Force source translation to termcap format.  Note: this differs from the -C
+\fB\-C\fR
+Force source translation to termcap format.  Note: this differs from the \fB\-C\fR
 option of \fIinfocmp\fR(1M) in that it does not merely translate capability
 names, but also translates terminfo strings to termcap format.  Capabilities
 that are not translatable are left in the entry under their terminfo names
 but commented out with two preceding dots.
 .TP
-\fB-c\fR
+\fB\-c\fR
 tells \fBtic\fP to only check \fIfile\fR for errors, including syntax problems and
-bad use links.  If you specify \fB-C\fR (\fB-I\fR) with this option, the code
+bad use links.  If you specify \fB\-C\fR (\fB\-I\fR) with this option, the code
 will print warnings about entries which, after use resolution, are more than
 1023 (4096) bytes long.  Due to a fixed buffer length in older termcap
 libraries (and a documented limit in terminfo), these entries may cause core
 dumps.
 .TP
-\fB-e \fR\fInames\fR
+\fB\-e \fR\fInames\fR
 Limit writes and translations to the following comma-separated list of
 terminals.
 If any name or alias of a terminal matches one of the names in
@@ -110,32 +110,32 @@
 Otherwise no output will be generated for it.
 The option value is interpreted as a file containing the list if it
 contains a '/'.
-(Note: depending on how tic was compiled, this option may require -I or -C.)
+(Note: depending on how tic was compiled, this option may require \fB\-I\fR or \fB\-C\fR.)
 .TP
-\fB-f\fR
+\fB\-f\fR
 Display complex terminfo strings which contain if/then/else/endif expressions
 indented for readability.
 .TP
-\fB-G\fR
+\fB\-G\fR
 Display constant literals in decimal form
 rather than their character equivalents.
 .TP
-\fB-g\fR
+\fB\-g\fR
 Display constant character literals in quoted form
 rather than their decimal equivalents.
 .TP
-\fB-I\fR
+\fB\-I\fR
 Force source translation to terminfo format.
 .TP
-\fB-L\fR
+\fB\-L\fR
 Force source translation to terminfo format
 using the long C variable names listed in <\fBterm.h\fR>
 .TP
-\fB-N\fR
-Disable smart defaults.  
-Normally, when translating from termcap to terminfo, the compiler makes 
+\fB\-N\fR
+Disable smart defaults. 
+Normally, when translating from termcap to terminfo, the compiler makes
 a number of assumptions about the defaults of string capabilities
-\fBreset1_string\fR, \fBcarriage_return\fR, \fBcursor_left\fR, 
+\fBreset1_string\fR, \fBcarriage_return\fR, \fBcursor_left\fR,
 \fBcursor_down\fR, \fBscroll_forward\fR, \fBtab\fR, \fBnewline\fR,
 \fBkey_backspace\fR, \fBkey_left\fR, and \fBkey_down\fR, then attempts
 to use obsolete termcap capabilities to deduce correct values.  It also
@@ -143,42 +143,42 @@
 This option forces a more literal translation that also preserves the
 obsolete capabilities.
 .TP
-\fB-o\fR\fIdir\fR
+\fB\-o\fR\fIdir\fR
 Write compiled entries to given directory.  Overrides the TERMINFO environment
 variable.
 .TP
-\fB-R\fR\fIsubset\fR
+\fB\-R\fR\fIsubset\fR
 Restrict output to a given subset.  This option is for use with archaic
 versions of terminfo like those on SVr1, Ultrix, or HP/UX that do not support
 the full set of SVR4/XSI Curses terminfo; and outright broken ports like AIX 3.x
 that have their own extensions incompatible with SVr4/XSI.  Available subsets
 are "SVr1", "Ultrix", "HP", "BSD" and "AIX"; see \fBterminfo\fR(\*n) for details.
 .TP
-\fB-r\fR
+\fB\-r\fR
 Force entry resolution (so there are no remaining tc capabilities) even
 when doing translation to termcap format.  This may be needed if you are
 preparing a termcap file for a termcap library (such as GNU termcap through
 version 1.3 or BSD termcap through 4.3BSD) that does not handle multiple
 tc capabilities per entry.
 .TP
-\fB-s\fR
+\fB\-s\fR
 Summarize the compile by showing the directory into which entries
 are written, and the number of entries which are compiled.
 .TP
-\fB-T\fR
+\fB\-T\fR
 eliminates size-restrictions on the generated text.
 This is mainly useful for testing and analysis, since the compiled
 descriptions are limited (e.g., 1023 for termcap, 4096 for terminfo).
 .TP
-\fB-t\fR
+\fB\-t\fR
 tells \fBtic\fP to discard commented-out capabilities.
 Normally when translating from terminfo to termcap,
 untranslatable capabilities are commented-out.
 .TP
-\fB-V\fR
+\fB\-V\fR
 reports the version of ncurses which was used in this program, and exits.
 .TP
-\fB-v\fR\fIn\fR
+\fB\-v\fR\fIn\fR
 specifies that (verbose) output be written to standard error trace
 information showing \fBtic\fR's progress.  The optional integer
 \fIn\fR is a number from 1 to 10, inclusive, indicating the desired
@@ -186,10 +186,10 @@
 level is 1.  If \fIn\fR is specified and greater than 1, the level of
 detail is increased.
 .TP
-\fB-w\fR\fIn\fR
+\fB\-w\fR\fIn\fR
 specifies the width of the output.
 .TP
-\fB-x\fR
+\fB\-x\fR
 Treat unknown capabilities as user-defined.
 That is, if you supply a capability name which \fBtic\fP does not recognize,
 it will infer its type (boolean, number or string) from the syntax and
@@ -274,25 +274,25 @@
 error messages, and can be parsed by GNU Emacs's compile facility.
 
 The
-\fB-C\fR,
-\fB-G\fR,
-\fB-I\fR,
-\fB-N\fR,
-\fB-R\fR,
-\fB-T\fR,
-\fB-V\fR,
-\fB-a\fR,
-\fB-e\fR,
-\fB-f\fR,
-\fB-g\fR,
-\fB-o\fR,
-\fB-r\fR,
-\fB-s\fR,
-\fB-t\fR and 
-\fB-x\fR
+\fB\-C\fR,
+\fB\-G\fR,
+\fB\-I\fR,
+\fB\-N\fR,
+\fB\-R\fR,
+\fB\-T\fR,
+\fB\-V\fR,
+\fB\-a\fR,
+\fB\-e\fR,
+\fB\-f\fR,
+\fB\-g\fR,
+\fB\-o\fR,
+\fB\-r\fR,
+\fB\-s\fR,
+\fB\-t\fR and
+\fB\-x\fR
 options
 are not supported under SVr4.
-The SVr4 -c mode does not report bad use links.
+The SVr4 \fB\-c\fR mode does not report bad use links.
 
 System V does not compile entries to or read entries from your
 \fI$HOME/.terminfo\fR directory unless TERMINFO is explicitly set to it.
Index: man/toe.1m
Prereq:  1.10 
--- ncurses-5.3-20021012/man/toe.1m	Sat Aug 19 14:51:05 2000
+++ ncurses-5.3-20030719/man/toe.1m	Sat May 10 20:32:53 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,45 +26,45 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: toe.1m,v 1.10 2000/08/19 18:51:05 tom Exp $
+.\" $Id: toe.1m,v 1.12 2003/05/11 00:32:53 tom Exp $
 .TH toe 1M ""
 .ds n 5
 .ds d @TERMINFO@
 .SH NAME
 \fBtoe\fR - table of (terminfo) entries
 .SH SYNOPSIS
-\fBtoe\fR [\fB-v\fR[\fIn\fR]] [\fB-huUV\fR] \fIfile...\fR
+\fBtoe\fR [\fB\-v\fR[\fIn\fR]] [\fB\-huUV\fR] \fIfile...\fR
 .br
 .SH DESCRIPTION
 .PP
 With no options, \fBtoe\fR lists all available terminal types by primary name
 with descriptions.  File arguments specify the directories to be scanned; if no
 such arguments are given, your default terminfo directory is scanned.  If you
-also specify the -h option, a directory header will be issued as each
-directory is entered. 
+also specify the \fB\-h\fR option, a directory header will be issued as each
+directory is entered.
 .PP
 There are other options intended for use by terminfo file maintainers:
 .TP
-\fB-u\fR \fIfile\fR
+\fB\-u\fR \fIfile\fR
 says to issue a report on dependencies in the given file. This report condenses
 the `use' relation: each line consists of the primary name of a terminal that
 has use capabilities, followed by a colon, followed by the
 whitespace-separated primary names of all terminals which occur in those use
 capabilities, followed by a newline
 .TP
-\fB-U\fR \fIfile\fR
+\fB\-U\fR \fIfile\fR
 says to issue a report on reverse dependencies in the given file. This report
 reverses the `use' relation: each line consists of the primary name of a
 terminal that occurs in use capabilities, followed by a colon, followed by the
 whitespace-separated primary names of all terminals which depend on it,
 followed by a newline.
 .TP
-\fB-v\fR\fIn\fR
+\fB\-v\fR\fIn\fR
 specifies that (verbose) output be written to standard error trace
 information showing \fBtoe\fR's progress.  The optional integer
 \fIn\fR is a number from 1 to 10, interpreted as for \fBtic\fR(1).
 .TP 5
-\fB-V\fR
+\fB\-V\fR
 reports the version of ncurses which was used in this program, and exits.
 .SH FILES
 .TP 5
Index: man/tput.1
Prereq:  1.18 
--- ncurses-5.3-20021012/man/tput.1	Sat Oct 12 09:53:20 2002
+++ ncurses-5.3-20030719/man/tput.1	Sat May 10 20:32:53 2003
@@ -1,6 +1,6 @@
 '\" t
 .\"***************************************************************************
-.\" Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+.\" Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -27,24 +27,24 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: tput.1,v 1.18 2002/10/12 13:53:20 tom Exp $
+.\" $Id: tput.1,v 1.20 2003/05/11 00:32:53 tom Exp $
 .TH tput 1 ""
 .ds d @TERMINFO@
 .ds n 1
 .SH NAME
 \fBtput\fR, \fBreset\fR - initialize a terminal or query terminfo database
 .SH SYNOPSIS
-\fBtput\fR [\fB-T\fR\fItype\fR] \fIcapname\fR [\fIparms\fR ... ]
+\fBtput\fR [\fB\-T\fR\fItype\fR] \fIcapname\fR [\fIparms\fR ... ]
 .br
-\fBtput\fR [\fB-T\fR\fItype\fR] \fBinit\fR
+\fBtput\fR [\fB\-T\fR\fItype\fR] \fBinit\fR
 .br
-\fBtput\fR [\fB-T\fR\fItype\fR] \fBreset\fR
+\fBtput\fR [\fB\-T\fR\fItype\fR] \fBreset\fR
 .br
-\fBtput\fR [\fB-T\fR\fItype\fR] \fBlongname\fR
+\fBtput\fR [\fB\-T\fR\fItype\fR] \fBlongname\fR
 .br
-\fBtput -S\fR  \fB<<\fR
+\fBtput \-S\fR  \fB<<\fR
 .br
-\fBtput -V\fR
+\fBtput \-V\fR
 .br
 .SH DESCRIPTION
 The \fBtput\fR utility uses the \fBterminfo\fR database to make the
@@ -62,10 +62,10 @@
 For a complete list of capabilities
 and the \fIcapname\fR associated with each, see \fBterminfo\fR(\*n).
 .TP
-\fB-T\fR\fItype\fR
+\fB\-T\fR\fItype\fR
 indicates the \fItype\fR of terminal.  Normally this option is
 unnecessary, because the default is taken from the environment
-variable \fBTERM\fR.  If \fB-T\fR is specified, then the shell
+variable \fBTERM\fR.  If \fB\-T\fR is specified, then the shell
 variables \fBLINES\fR and \fBCOLUMNS\fR will be ignored,and the
 operating system will not be queried for the actual screen size.
 .TP
@@ -83,14 +83,14 @@
 \fBtput\fR uses a table to decide which to pass as strings.
 Normally \fBtput\fR uses \fBtparm\fR (3X) to perform the substitution.
 If no parameters are given for the attribute,
-\fBtput\fR writes the string without performing the substitution. 
+\fBtput\fR writes the string without performing the substitution.
 .TP
-\fB-S\fR
+\fB\-S\fR
 allows more than one capability per invocation of \fBtput\fR.  The
 capabilities must be passed to \fBtput\fR from the standard input
 instead of from the command line (see example).
 Only one \fIcapname\fR is allowed per line.
-The \fB-S\fR option changes the
+The \fB\-S\fR option changes the
 meaning of the \fB0\fR and \fB1\fR boolean and string exit codes (see the
 EXIT CODES section).
 .IP
@@ -98,12 +98,12 @@
 to decide whether to use \fBtparm\fR (3X),
 and how to interpret the parameters.
 .TP
-\fB-V\fR
+\fB\-V\fR
 reports the version of ncurses which was used in this program, and exits.
 .TP
 \fBinit\fR
 If the \fBterminfo\fR database is present and an entry for the user's
-terminal exists (see \fB-T\fR\fItype\fR, above), the following will
+terminal exists (see \fB\-T\fR\fItype\fR, above), the following will
 occur: (1) if present, the terminal's initialization strings will be
 output (\fBis1\fR, \fBis2\fR, \fBis3\fR, \fBif\fR, \fBiprog\fR), (2)
 any delays (e.g., newline) specified in the entry will be set in the
@@ -122,7 +122,7 @@
 .TP
 \fBlongname\fR
 If the \fBterminfo\fR database is present and an entry for the
-user's terminal exists (see \fB-T\fR\fItype\fR above), then the long name
+user's terminal exists (see \fB\-T\fR\fItype\fR above), then the long name
 of the terminal will be put out.  The long name is the last
 name in the first line of the terminal's description in the
 \fBterminfo\fR database [see \fBterm\fR(5)].
@@ -139,7 +139,7 @@
 the environmental variable \fBTERM\fR has been exported, as
 illustrated on the \fBprofile\fR(5) manual page.
 .TP 5
-\fBtput -T5620 reset\fR
+\fBtput \-T5620 reset\fR
 Reset an AT&T 5620 terminal, overriding the type of
 terminal in the environmental variable \fBTERM\fR.
 .TP 5
@@ -154,7 +154,7 @@
 \fBtput cols\fR
 Print the number of columns for the current terminal.
 .TP 5
-\fBtput -T450 cols\fR
+\fBtput \-T450 cols\fR
 Print the number of columns for the 450 terminal.
 .TP 5
 \fBbold=`tput smso` offbold=`tput rmso`\fR
@@ -178,7 +178,7 @@
 variable \fBTERM\fR.
 .PP
 .RS 5
-\fBtput -S <<!\fR
+\fBtput \-S <<!\fR
 .br
 \fB> clear\fR
 .br
@@ -213,7 +213,7 @@
 information, see the "Tabs and Initialization"
 section of \fBterminfo\fR(5)
 .SH EXIT CODES
-If the \fB-S\fR option is used,
+If the \fB\-S\fR option is used,
 \fBtput\fR checks for errors from each line,
 and if any errors are found, will set the exit code to 4 plus the
 number of lines with errors.
@@ -221,7 +221,7 @@
 No indication of which line failed can be given so
 exit code \fB1\fR will never appear.  Exit codes \fB2\fR, \fB3\fR, and
 \fB4\fR retain their usual interpretation.
-If the \fB-S\fR option is not used,
+If the \fB\-S\fR option is not used,
 the exit code depends on the type of \fIcapname\fR:
 .RS 5
 .TP
@@ -241,7 +241,7 @@
 whether or not \fIcapname\fR is defined for this terminal \fItype\fR.
 To determine if \fIcapname\fR is defined for this terminal \fItype\fR,
 the user must test the value written to standard output.
-A value of \fB-1\fR
+A value of \fB\-1\fR
 means that \fIcapname\fR is not defined for this terminal \fItype\fR.
 .TP
 .I other
@@ -262,17 +262,17 @@
 \fB0\fR	T{
 (\fIcapname\fR is a numeric variable that is not specified in the
 \fBterminfo\fR(\*n) database for this terminal type, e.g.
-\fBtput -T450 lines\fR and \fBtput -T2621 xmc\fR)
+\fBtput \-T450 lines\fR and \fBtput \-T2621 xmc\fR)
 T}
 \fB1\fR	no error message is printed, see the \fBEXIT CODES\fR section.
 \fB2\fR	usage error
 \fB3\fR	unknown terminal \fItype\fR or no \fBterminfo\fR database
 \fB4\fR	unknown \fBterminfo\fR capability \fIcapname\fR
-\fB>4\fR	error occurred in -S
+\fB>4\fR	error occurred in \-S
 =
 .TE
 .SH PORTABILITY
-The \fBlongname\fR and \fB-S\fR options, and the parameter-substitution
+The \fBlongname\fR and \fB\-S\fR options, and the parameter-substitution
 features used in the \fBcup\fR example, are not supported in BSD curses or in
 AT&T/USL curses before SVr4.
 .SH SEE ALSO
Index: man/tset.1
Prereq:  1.12 
--- ncurses-5.3-20021012/man/tset.1	Sat Sep  9 16:33:07 2000
+++ ncurses-5.3-20030719/man/tset.1	Sat May 10 20:32:53 2003
@@ -1,5 +1,5 @@
 .\"***************************************************************************
-.\" Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+.\" Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
 .\"                                                                          *
 .\" Permission is hereby granted, free of charge, to any person obtaining a  *
 .\" copy of this software and associated documentation files (the            *
@@ -26,14 +26,14 @@
 .\" authorization.                                                           *
 .\"***************************************************************************
 .\"
-.\" $Id: tset.1,v 1.12 2000/09/09 20:33:07 tom Exp $
+.\" $Id: tset.1,v 1.13 2003/05/11 00:32:53 tom Exp $
 .TH tset 1 ""
 .SH NAME
 \fBtset\fR, \fBreset\fR - terminal initialization
 .SH SYNOPSIS
-tset [-IQVqrs] [-] [-e \fIch\fR] [-i \fIch\fR] [-k \fIch\fR] [-m \fImapping\fR] [\fIterminal\fR]
+tset [\-IQVqrs] [\-] [\-e \fIch\fR] [\-i \fIch\fR] [\-k \fIch\fR] [\-m \fImapping\fR] [\fIterminal\fR]
 .br
-reset [-IQVqrs] [-] [-e \fIch\fR] [-i \fIch\fR] [-k \fIch\fR] [-m \fImapping\fR] [\fIterminal\fR]
+reset [\-IQVqrs] [\-] [\-e \fIch\fR] [\-i \fIch\fR] [\-k \fIch\fR] [\-m \fImapping\fR] [\fIterminal\fR]
 .SH DESCRIPTION
 \&\fBTset\fR initializes terminals.
 \fBTset\fR first determines the type of terminal that you are using.
@@ -50,7 +50,7 @@
 .PP
 4. The default terminal type, ``unknown''.
 .PP
-If the terminal type was not specified on the command-line, the -m
+If the terminal type was not specified on the command-line, the \fB\-m\fR
 option mappings are then applied (see below for more information).
 Then, if the terminal type begins with a question mark (``?''), the
 user is prompted for confirmation of the terminal type.  An empty
@@ -81,50 +81,50 @@
 .PP
 The options are as follows:
 .TP 5
--q
+.B \-q
 The terminal type is displayed to the standard output, and the terminal is
 not initialized in any way.  The option `-' by itself is equivalent but
 archaic.
-.TP 5
--e
+.TP
+.B \-e
 Set the erase character to \fIch\fR.
-.TP 5
--I
+.TP
+.B \-I
 Do not send the terminal or tab initialization strings to the terminal.
-.TP 5
--Q
+.TP
+.B \-Q
 Don't display any values for the erase, interrupt and line kill characters.
 .TP
-\fB-V\fR
+.B \-V
 reports the version of ncurses which was used in this program, and exits.
-.TP 5
--i
+.TP
+.B \-i
 Set the interrupt character to \fIch\fR.
-.TP 5
--k
+.TP
+.B \-k
 Set the line kill character to \fIch\fR.
-.TP 5
--m
+.TP
+.B \-m
 Specify a mapping from a port type to a terminal.
 See below for more information.
-.TP 5
--r
+.TP
+.B \-r
 Print the terminal type to the standard error output.
-.TP 5
--s
+.TP
+.B \-s
 Print the sequence of shell commands to initialize the environment variable
 \fBTERM\fR to the standard output.
 See the section below on setting the environment for details.
 .PP
-The arguments for the -e, -i, and -k
+The arguments for the \fB-e\fR, \fB-i\fR, and \fB-k\fR
 options may either be entered as actual characters or by using the `hat'
 notation, i.e. control-h may be specified as ``^H'' or ``^h''.
 .SH SETTING THE ENVIRONMENT
 It is often desirable to enter the terminal type and information about
 the terminal's capabilities into the shell's environment.
-This is done using the -s option.
+This is done using the \fB\-s\fR option.
 .PP
-When the -s option is specified, the commands to enter the information
+When the \fB\-s\fR option is specified, the commands to enter the information
 into the shell's environment are written to the standard output.  If
 the \fBSHELL\fR environmental variable ends in ``csh'', the commands
 are for \fBcsh\fR, otherwise, they are for \fBsh\fR.
@@ -132,7 +132,7 @@
 \fBnoglob\fR, leaving it unset.  The following line in the \fB.login\fR
 or \fB.profile\fR files will initialize the environment correctly:
 
-    eval \`tset -s options ... \`
+    eval \`tset \-s options ... \`
 
 .SH TERMINAL TYPE MAPPING
 When the terminal is not hardwired into the system (or the current
@@ -142,13 +142,13 @@
 When \fBtset\fR is used in a startup script it is often desirable to
 provide information about the type of terminal used on such ports.
 .PP
-The purpose of the -m option is to map
+The purpose of the \fB\-m\fR option is to map
 from some set of conditions to a terminal type, that is, to
 tell \fBtset\fR
 ``If I'm on this port at a particular speed, guess that I'm on that
 kind of terminal''.
 .PP
-The argument to the -m option consists of an optional port type, an
+The argument to the \fB\-m\fR option consists of an optional port type, an
 optional operator, an optional baud rate specification, an optional
 colon (``:'') character and a terminal type.  The port type is a
 string (delimited by either the operator or the colon character).  The
@@ -159,7 +159,7 @@
 of the standard error output (which should be the control terminal).
 The terminal type is a string.
 .PP
-If the terminal type is not specified on the command line, the -m
+If the terminal type is not specified on the command line, the \fB\-m\fR
 mappings are applied to the terminal type.  If the port type and baud
 rate match the mapping, the terminal type specified in the mapping
 replaces the current type.  If more than one mapping is specified, the
@@ -174,16 +174,16 @@
 .PP
 If no baud rate is specified, the terminal type will match any baud rate.
 If no port type is specified, the terminal type will match any port type.
-For example, \fB-m dialup:vt100 -m :?xterm\fR
+For example, \fB\-m dialup:vt100 \-m :?xterm\fR
 will cause any dialup port, regardless of baud rate, to match the terminal
 type vt100, and any non-dialup port type to match the terminal type ?xterm.
 Note, because of the leading question mark, the user will be
 queried on a default port as to whether they are actually using an xterm
 terminal.
 .PP
-No whitespace characters are permitted in the -m option argument.
+No whitespace characters are permitted in the \fB\-m\fR option argument.
 Also, to avoid problems with meta-characters, it is suggested that the
-entire -m option argument be placed within single quote characters,
+entire \fB\-m\fR option argument be placed within single quote characters,
 and that \fBcsh\fR users insert a backslash character (``\e'') before
 any exclamation marks (``!'').
 .SH HISTORY
@@ -197,30 +197,33 @@
 \fBtset\fR's most important use).  This implementation behaves like 4.4BSD
 tset, with a few exceptions specified here.
 .PP
-The -S option of BSD tset no longer works; it prints an error message to stderr
-and dies.  The -s option only sets \fBTERM\fR, not \fBTERMCAP\fP.  Both these
+The \fB\-S\fR option of BSD tset no longer works; it prints an error message to stderr
+and dies.  The \fB\-s\fR option only sets \fBTERM\fR, not \fBTERMCAP\fP.  Both these
 changes are because the \fBTERMCAP\fR variable is no longer supported under
-terminfo-based \fBncurses\fR, which makes \fBtset -S\fR useless (we made it die
+terminfo-based \fBncurses\fR, which makes \fBtset \-S\fR useless (we made it die
 noisily rather than silently induce lossage).
 .PP
 There was an undocumented 4.4BSD feature that invoking tset via a link named
 `TSET` (or via any other name beginning with an upper-case letter) set the
 terminal to use upper-case only.  This feature has been omitted.
 .PP
-The -A, -E, -h, -u and -v options were deleted from the \fBtset\fR
-utility in 4.4BSD. None of them were documented in 4.3BSD and all are
-of limited utility at best. The -a, -d, and -p options are similarly
+The \fB\-A\fR, \fB\-E\fR, \fB\-h\fR, \fB\-u\fR and \fB\-v\fR
+options were deleted from the \fBtset\fR
+utility in 4.4BSD.
+None of them were documented in 4.3BSD and all are
+of limited utility at best.
+The \fB\-a\fR, -\fB\d\fR, and -\fB\p\fR options are similarly
 not documented or useful, but were retained as they appear to be in
 widespread use.  It is strongly recommended that any usage of these
-three options be changed to use the -m option instead.  The
--n option remains, but has no effect.  The -adnp options are therefore
+three options be changed to use the \fB\-m\fR option instead.  The
+-n option remains, but has no effect.  The \fB\-adnp\fR options are therefore
 omitted from the usage summary above.
 .PP
-It is still permissible to specify the -e, -i, and -k options without
+It is still permissible to specify the \fB\-e\fR, \fB\-i\fR, and \fB\-k\fR options without
 arguments, although it is strongly recommended that such usage be fixed to
 explicitly specify the character.
 .PP
-As of 4.4BSD, executing \fBtset\fR as \fBreset\fR no longer implies the -Q
+As of 4.4BSD, executing \fBtset\fR as \fBreset\fR no longer implies the \fB\-Q\fR
 option.  Also, the interaction between the - option and the \fIterminal\fR
 argument in some historic implementations of \fBtset\fR has been removed.
 .SH ENVIRONMENT
@@ -230,7 +233,7 @@
 .TP 5
 /etc/ttys
 system port name to terminal type mapping database (BSD versions only).
-.TP 5
+.TP
 @TERMINFO@
 terminal capability database
 .SH SEE ALSO
Index: menu/Makefile.in
Prereq:  1.36 
--- ncurses-5.3-20021012/menu/Makefile.in	Sat Jan 19 20:49:17 2002
+++ ncurses-5.3-20030719/menu/Makefile.in	Sat Jun  7 17:09:50 2003
@@ -1,6 +1,6 @@
-# $Id: Makefile.in,v 1.36 2002/01/20 01:49:17 tom Exp $
+# $Id: Makefile.in,v 1.39 2003/06/07 21:09:50 tom Exp $
 ##############################################################################
-# Copyright (c) 1998,1999,2000,2001,2002 Free Software Foundation, Inc.      #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -71,8 +71,7 @@
 CPP		= @CPP@
 CFLAGS		= @CFLAGS@
 
-CPPFLAGS	= @CPPFLAGS@ \
-		  -DHAVE_CONFIG_H 
+CPPFLAGS	= -DHAVE_CONFIG_H @CPPFLAGS@
 
 CCFLAGS		= $(CPPFLAGS) $(CFLAGS)
 
@@ -97,7 +96,7 @@
 REL_VERSION	= @cf_cv_rel_version@
 ABI_VERSION	= @cf_cv_abi_version@
 
-RANLIB		= @RANLIB@
+RANLIB		= @LIB_PREP@
 
 IMPORT_LIB	= @IMPORT_LIB@
 SHARED_LIB	= @SHARED_LIB@
Index: misc/csort
--- /dev/null	Tue Jun  3 10:49:35 2003
+++ ncurses-5.3-20030719/misc/csort	Sat Oct 19 17:42:09 2002
@@ -0,0 +1,36 @@
+#!/bin/sh
+# $Id: csort,v 1.2 2002/10/19 21:42:09 tom Exp $
+##############################################################################
+# Copyright (c) 2002 Free Software Foundation, Inc.                          #
+#                                                                            #
+# Permission is hereby granted, free of charge, to any person obtaining a    #
+# copy of this software and associated documentation files (the "Software"), #
+# to deal in the Software without restriction, including without limitation  #
+# the rights to use, copy, modify, merge, publish, distribute, distribute    #
+# with modifications, sublicense, and/or sell copies of the Software, and to #
+# permit persons to whom the Software is furnished to do so, subject to the  #
+# following conditions:                                                      #
+#                                                                            #
+# The above copyright notice and this permission notice shall be included in #
+# all copies or substantial portions of the Software.                        #
+#                                                                            #
+# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
+# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
+# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
+# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
+# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
+# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
+# DEALINGS IN THE SOFTWARE.                                                  #
+#                                                                            #
+# Except as contained in this notice, the name(s) of the above copyright     #
+# holders shall not be used in advertising or otherwise to promote the sale, #
+# use or other dealings in this Software without prior written               #
+# authorization.                                                             #
+##############################################################################
+#
+# override anything that might cause 'sort' to do the wrong thing...
+LANG=C;		export LANG
+LANGUAGE=C;	export LANGUAGE
+LC_ALL=C;	export LC_ALL
+LC_CTYPE=C;	export LC_CTYPE
+sort $*
Index: misc/emx.src
Prereq:  1.7 
--- ncurses-5.3-20021012/misc/emx.src	Sat Aug 26 22:16:08 2000
+++ ncurses-5.3-20030719/misc/emx.src	Sat Jan 25 20:17:55 2003
@@ -1,4 +1,4 @@
-# $Id: emx.src,v 1.7 2000/08/27 02:16:08 jmcoopr Exp $
+# $Id: emx.src,v 1.8 2003/01/26 01:17:55 tom Exp $
 # This is a reformatted copy of the terminfo source for OS/2 EMX from
 # Juan Jose Garcia Ripoll <worm@arrakis.es>.
 # http://www.arrakis.es/~worm/
@@ -85,6 +85,7 @@
 	smpch=\E[11m,
 	smso=\E[7m,
 	smul=\E[4m,
+	use=klone+acs,
 
 # Highlight controls corresponding to the ANSI.SYS standard.  *All*
 # console drivers for Intel boxes obey these.  Does not assume \E[11m will
@@ -103,6 +104,7 @@
 	smacs=\E[12m,
 	smso=\E[7m,
 	smul=\E[4m,
+	use=klone+acs,
 
 # ANSI.SYS color control.
 # The DOS 5 manual asserts that these sequences meet the ISO 6429 standard.
@@ -113,8 +115,17 @@
 	op=\E[37;40m,
 	setab=\E[4%p1%dm,
 	setaf=\E[3%p1%dm,
-	setb=\E[4%?%p1%{1}%=%t4%e%p1%{3}%=%t6%e%p1%{4}%=%t1%e%p1%{6}%=%t3%e%p1%d%;m,
-	setf=\E[3%?%p1%{1}%=%t4%e%p1%{3}%=%t6%e%p1%{4}%=%t1%e%p1%{6}%=%t3%e%p1%d%;m,
+
+# This is better than klone+color, it doesn't assume white-on-black as the
+# default color pair,  but many `ANSI' terminals don't grok the <op> cap.
+ecma+color|color control for ECMA-48-compatible terminals,
+	AX,
+	colors#8,
+	ncv#3,
+	pairs#64,
+	op=\E[39;49m,
+	setab=\E[4%p1%dm,
+	setaf=\E[3%p1%dm,
 
 #### ANSI/ECMA-48 terminals and terminal emulators
 #
@@ -209,7 +220,9 @@
 # no_color_video to inform the application that standout(1), underline(2)
 # reverse(4) and invisible(64) don't work with color.
 emx-base|DOS special keys,
+	bce,
 	bw,
+	it#8,
 	ncv#71,
 	bel=^G,
 	ka1=\0G,
@@ -293,7 +306,7 @@
 #	me	<->	sgr0	turn off all atributes
 #
 # On my terminal, \E[4m looks dim.
-ansi|ANSI.SYS color,
+ansi-emx|ANSI.SYS color,
 	blink=\E[5m,
 	bold=\E[1m,
 	kmous=\E[M,
@@ -319,17 +332,17 @@
 	smul=\E[1;31;47m,
 	use=emx-base,
 os2|OS/2-emx ANSI.SYS,
-	cuu=\E[%p1%dA,
-	cuu1=\E[A,
+	cub=\E[%p1%dD,
+	cub1=\E[D,
 	cud=\E[%p1%dB,
 	cud1=\E[B,
 	cuf=\E[%p1%dC,
 	cuf1=\E[C,
-	cub=\E[%p1%dD,
-	cub1=\E[D,
-	sc=\E[s,
+	cuu=\E[%p1%dA,
+	cuu1=\E[A,
 	rc=\E[u,
-	use=ansi,
+	sc=\E[s,
+	use=ansi-emx,
 	use=mono,
 mono|ANSI.SYS mono,
 	blink=\E[5m,
@@ -353,7 +366,7 @@
 	smul=\E[1;31;40m,
 	use=mono,
 # nice colors for Emacs (white on blue, mode line white on cyan)
-ansi-color-2|ANSI.SYS color 2,
+ansi-color-2-emx|ANSI.SYS color 2,
 	rmcup=\E[0m,
 	rmso=\E[0;37;44m,
 	rmul=\E[0m,
@@ -361,9 +374,9 @@
 	smcup=\E[0;37;44m,
 	smso=\E[1;37;46m,
 	smul=\E[1;31;40m,
-	use=ansi,
+	use=ansi-emx,
 # nice colors for Emacs (white on black, mode line black on cyan)
-ansi-color-3|ANSI.SYS color 3,
+ansi-color-3-emx|ANSI.SYS color 3,
 	rmcup=\E[0m,
 	rmso=\E[0m,
 	rmul=\E[0m,
@@ -371,7 +384,7 @@
 	smcup=\E[0m,
 	smso=\E[30;46m,
 	smul=\E[1;31;40m,
-	use=ansi,
+	use=ansi-emx,
 
 #### X terminal emulators
 #
@@ -437,7 +450,7 @@
 # xterm's internal mouse-tracking facility; ncurses will interpret the
 # following three bytes of mouse status information.
 # From: Eric S. Raymond <esr@snark.thyrsus.com> 14 Dec 1995
-xterm|vs100|xterm terminal emulator (X11R6 Window System),
+xterm-r6|xterm terminal emulator (X11R6 Window System),
 	am,
 	km,
 	mir,
@@ -488,7 +501,15 @@
 	kf10=\E[21~,
 	kf11=\E[23~,
 	kf12=\E[24~,
+	kf13=\E[25~,
+	kf14=\E[26~,
+	kf15=\E[28~,
+	kf16=\E[29~,
+	kf17=\E[31~,
+	kf18=\E[32~,
+	kf19=\E[33~,
 	kf2=\E[12~,
+	kf20=\E[34~,
 	kf3=\E[13~,
 	kf4=\E[14~,
 	kf5=\E[15~,
@@ -496,6 +517,7 @@
 	kf7=\E[18~,
 	kf8=\E[19~,
 	kf9=\E[20~,
+	kfnd=\E[1~,
 	khome=\EO\0,
 	kich1=\E[2~,
 	kmous=\E[M,
@@ -545,6 +567,7 @@
 	sc=\E7,
 	tsl=\E[?E\E[?%i%dT,
 	use=xterm,
+	use=ecma+color,
 
 # See the note on ICH/ICH1 VERSUS RMIR/SMIR near the end of file
 xterm-nic|xterm with ich/ich1 suppressed for non-curses programs,
@@ -758,7 +781,6 @@
 	cup=\EE%p1%d;%p2%d;,
 	cuu=\Ep-%p1%d;,
 	cuu1=\EA,
-	cvvis=\Ea,
 	dch=\EI%p1%d;,
 	dch1=\EI1;,
 	dl=\ER%p1%d;,
@@ -816,10 +838,21 @@
 	rmso=\ES,
 	rmul=\ES,
 	rs2=\ES\Es0;\Er0;,
-	setab=\Es%i%p1%d; setaf=\Er%i%p1%d;,
+	setab=\Es%i%p1%d;,
+	setaf=\Er%i%p1%d;,
 	sgr0=\ES,
 	smacs=\0,
 	smir=\EY,
 	smso=\ES\ET,
 	smul=\ES\EV,
 	tbc=\Ej,
+###############################################################################
+# Aliases which conflict with terminfo.src
+ansi|ANSI.SYS color,
+	use=ansi-emx,
+ansi-color-2|ANSI.SYS color 2,
+	use=ansi-color-2-emx,
+ansi-color-3|ANSI.SYS color 3,
+	use=ansi-color-3-emx,
+xterm|vs100|xterm terminal emulator (X11R6 Window System),
+	use=xterm-r6,
Index: misc/run_tic.in
Prereq:  1.11 
--- ncurses-5.3-20021012/misc/run_tic.in	Sat Oct 13 20:44:33 2001
+++ ncurses-5.3-20030719/misc/run_tic.in	Sat Jul 19 14:44:32 2003
@@ -1,6 +1,6 @@
 #!@SHELL@
 ##############################################################################
-# Copyright (c) 1998,2000 Free Software Foundation, Inc.                     #
+# Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -29,7 +29,7 @@
 #
 # Author: Thomas E. Dickey 1996,2000
 #
-# $Id: run_tic.in,v 1.11 2001/10/14 00:44:33 tom Exp $
+# $Id: run_tic.in,v 1.14 2003/07/19 18:44:32 Charles.Wilson Exp $
 # This script is used to install terminfo.src using tic.  We use a script
 # because the path checking is too awkward to do in a makefile.
 #
@@ -62,8 +62,8 @@
 # on the host's copy of tic to compile the terminfo database.
 if test "$THAT_CC" = "$THIS_CC" ; then
 case "$PATH" in
-:*) PATH=../progs:${DESTDIR}$bindir$PATH ;;
-*) PATH=../progs:${DESTDIR}$bindir:$PATH ;;
+:*) PATH=../progs:../lib:${DESTDIR}$bindir$PATH ;;
+*) PATH=../progs:../lib:${DESTDIR}$bindir:$PATH ;;
 esac
 export PATH
 fi
@@ -81,7 +81,7 @@
 umask 022
 
 # Construct the name of the old (obsolete) pathname, e.g., /usr/lib/terminfo.
-TICDIR=`echo $TERMINFO | sed -e 's@/share/@/lib/@'`
+TICDIR=`echo $TERMINFO | sed -e 's%/share/%/lib/%'`
 
 # Remove the old terminfo stuff; we don't care if it existed before, and it
 # would generate a lot of confusing error messages if we tried to overwrite it.
@@ -91,11 +91,11 @@
 
 # If we're not installing into /usr/share/, we'll have to adjust the location
 # of the tabset files in terminfo.src (which are in a parallel directory).
-TABSET=`echo $ticdir | sed -e 's@/terminfo$@/tabset@'`
+TABSET=`echo $ticdir | sed -e 's%/terminfo$%/tabset%'`
 if test "x$TABSET" != "x/usr/share/tabset" ; then
 	echo '** adjusting tabset paths'
 	TMP=${TMPDIR-/tmp}/$$
-	sed -e s:/usr/share/tabset:$TABSET:g $source >$TMP
+	sed -e s%/usr/share/tabset%$TABSET%g $source >$TMP
 	trap "rm -f $TMP" 0 1 2 5 15
 	source=$TMP
 fi
@@ -140,13 +140,15 @@
 		cd ${DESTDIR}$prefix
 		# Construct a symbolic link that only assumes $ticdir has the
 		# same $prefix as the other installed directories.
-		RELATIVE=`echo $ticdir|sed -e 's:^'$prefix'/::'`
+		RELATIVE=`echo $ticdir|sed -e 's%^'$prefix'/%%'`
 		if test "$RELATIVE" != "$ticdir" ; then
-			RELATIVE=../`echo $ticdir|sed -e 's:^'$prefix'/::' -e 's:^/::'`
+			RELATIVE=../`echo $ticdir|sed -e 's%^'$prefix'/%%' -e 's%^/%%'`
 		fi
 		if ( @LN_S@ $RELATIVE $TICDIR )
 		then
-			echo '** linked '$TICDIR' for compatibility'
+			echo '** sym-linked '$TICDIR' for compatibility'
+		else
+			echo '** could not sym-link '$TICDIR' for compatibility'
 		fi
 	fi
 fi
Index: misc/shlib
Prereq:  1.6 
--- ncurses-5.3-20021012/misc/shlib	Sat May 20 19:01:17 2000
+++ ncurses-5.3-20030719/misc/shlib	Sat Jul 19 18:58:14 2003
@@ -29,7 +29,7 @@
 #
 # Author: Thomas E. Dickey <dickey@clark.net> 1996
 #
-# $Id: shlib,v 1.6 2000/05/20 23:01:17 tom Exp $
+# $Id: shlib,v 1.7 2003/07/19 22:58:14 tom Exp $
 # Use this script as a wrapper when running executables linked to shared
 # libraries on systems that use the $LD_LIBRARY_PATH variable and don't embed
 # the soname's path within the linked executable (such as IRIX), e.g,
@@ -84,4 +84,11 @@
 	fi
 	export LD_LIBRARY_PATH
 fi
+
+# cygwin doesn't use LD_LIBRARY_PATH, but does use PATH
+if test -n "$PATHEXT" ; then
+	PATH=$LD_LIBRARY_PATH:$PATH;
+	export PATH
+fi
+
 eval "$*"
Index: misc/terminfo.src
--- ncurses-5.3-20021012/misc/terminfo.src	Sat Oct  5 14:40:53 2002
+++ ncurses-5.3-20030719/misc/terminfo.src	Sat Jul 19 15:44:24 2003
@@ -10,7 +10,7 @@
 #
 #------------------------------------------------------------------------------
 #	Version 10.2.1
-#	$Date: 2002/10/05 18:40:53 $
+#	$Date: 2003/07/19 19:44:24 $
 #	terminfo syntax
 #
 #	Eric S. Raymond		(current maintainer)
@@ -562,7 +562,7 @@
 #
 # This completely describes the sequences specified in the DOS 2.1 ANSI.SYS
 # documentation (except for the keyboard key reassignment feature, which
-# doen't fit the <pfkey> model well).  The klone+acs sequences were valid
+# doesn't fit the <pfkey> model well).  The klone+acs sequences were valid
 # though undocumented.  The <pfkey> capability is untested but should work for
 # keys F1-F10 (%p1 values outside this range will yield unpredictable results).
 # From: Eric S. Raymond <esr@snark.thyrsus.com> Nov 7 1995
@@ -1468,7 +1468,9 @@
 	kf1=\2330P, kf10=\2330M, kf2=\2330Q, kf3=\2330W, 
 	kf4=\2330x, kf5=\2330t, kf6=\2330u, kf7=\2330q, kf8=\2330r, 
 	kf9=\2330p, knp=\233/, kpp=\233?, nel=^M^J, rev=\2337m, 
-	rmso=\2330m, rmul=\2330m, sgr0=\2330m, 
+	rmso=\2330m, rmul=\2330m, 
+	sgr=\2330%?%p6%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;m, 
+	sgr0=\2330m, 
 
 # NetBSD "wscons" emulator in vt220 mode
 # These are micro-minimal and probably need to be redone for real
@@ -1484,7 +1486,7 @@
 # DECstation/pmax.
 rcons|BSD rasterconsole, 
 	use=sun-il, 
-# Color version of above. Color currenly only provided by NetBSD.
+# Color version of above. Color currently only provided by NetBSD.
 rcons-color|BSD rasterconsole with ANSI color, 
 	bce, 
 	colors#8, pairs#64, 
@@ -1809,6 +1811,44 @@
 #  |        $Op        |  $On    |         |
 #  |___kc1_______K4____|_kc3__K5_|_kent_@8_|
 #
+# Note however, that the arrangement of the 5-key ka1-kc3 do not follow the
+# terminfo guidelines.  That is a compromise used to assign the remaining
+# keys on the keypad to kf5-kf0, used on older systems with legacy termcap
+# support:
+vt100+keypad|dec vt100 numeric keypad no fkeys, 
+	ka1=\EOq, ka3=\EOs, kb2=\EOr, kc1=\EOp, kc3=\EOn, 
+vt100+pfkeys|dec vt100 numeric keypad, 
+	kent=\EOM, kf1=\EOP, kf2=\EOQ, kf3=\EOR, kf4=\EOS, 
+	use=vt100+keypad, 
+vt100+fnkeys|dec vt100 numeric keypad, 
+	kf0=\EOy, kf10=\EOx, kf5=\EOt, kf6=\EOu, kf7=\EOv, kf8=\EOl, 
+	kf9=\EOw, use=vt100+pfkeys, 
+#
+# A better adaptation to modern keyboards such as the PC's, which have a dozen
+# function keys and the keypad 2,4,6,8 keys are labeled with arrows keys, is to
+# use the 5-key arrangement to model the arrow keys as suggested in the
+# terminfo guidelines:
+#   _______________________________________
+#  |   PF1   |   PF2   |   PF3   |   PF4   |
+#  |   $OP   |   $OQ   |   $OR   |   $OS   |
+#  |_kf1__k1_|_kf2__k2_|_kf3__k3_|_kf4__k4_|
+#  |    7         8         9         -    |
+#  |   $Ow   |   $Ox   |   $Oy   |   $Om   |
+#  |_ka1__K1_|_________|_ka3__K3_|_________|
+#  |    4    |    5    |    6    |    ,    |
+#  |   $Ot   |   $Ou   |   $Ov   |   $Ol   |
+#  |_________|_kb2__K2_|_________|_________|
+#  |    1    |    2    |    3    |         |
+#  |   $Oq   |   $Or   |   $Os   |  enter  |
+#  |_kc1__K4_|_________|_kc3__K5_|  $OM    |
+#  |         0         |   .     |         |
+#  |        $Op        |  $On    |         |
+#  |___________________|_________|_kent_@8_|
+#
+vt220+keypad|dec vt220 numeric keypad, 
+	ka1=\EOw, ka3=\EOy, kb2=\EOu, kc1=\EOq, kc3=\EOs, kent=\EOM, 
+	kf1=\EOP, kf2=\EOQ, kf3=\EOR, kf4=\EOS, 
+#
 # And here, for those of you with orphaned VT100s lacking documentation, is
 # a description of the soft switches invoked when you do `Set Up'.
 # 
@@ -1853,17 +1893,15 @@
 	cuf=\E[%p1%dC, cuf1=\E[C$<2>, 
 	cup=\E[%i%p1%d;%p2%dH$<5>, cuu=\E[%p1%dA, 
 	cuu1=\E[A$<2>, ed=\E[J$<50>, el=\E[K$<3>, el1=\E[1K$<3>, 
-	enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, ind=^J, ka1=\EOq, 
-	ka3=\EOs, kb2=\EOr, kbs=^H, kc1=\EOp, kc3=\EOn, kcub1=\EOD, 
-	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kent=\EOM, kf0=\EOy, 
-	kf1=\EOP, kf10=\EOx, kf2=\EOQ, kf3=\EOR, kf4=\EOS, kf5=\EOt, 
-	kf6=\EOu, kf7=\EOv, kf8=\EOl, kf9=\EOw, rc=\E8, 
+	enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, ind=^J, kbs=^H, 
+	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, rc=\E8, 
 	rev=\E[7m$<2>, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
 	rmkx=\E[?1l\E>, rmso=\E[m$<2>, rmul=\E[m$<2>, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<2>, 
 	sgr0=\E[m\017$<2>, smacs=^N, smam=\E[?7h, smkx=\E[?1h\E=, 
 	smso=\E[7m$<2>, smul=\E[4m$<2>, tbc=\E[3g, 
+	use=vt100+fnkeys, 
 vt100nam|vt100-nam|vt100 no automargins, 
 	am@, xenl@, use=vt100-am, 
 vt100-vb|dec vt100 (w/advanced video) & no beep, 
@@ -2132,22 +2170,21 @@
 	home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, il=\E[%p1%dL, 
 	il1=\E[L, ind=\ED, 
 	is2=\E>\E[?3l\E[?4l\E[5?l\E[?7h\E[?8h\E[1;24r\E[24;1H, 
-	ka1=\EOw, ka3=\EOy, kb2=\EOu, kbs=\177, kc1=\EOq, kc3=\EOs, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
-	kdch1=\E[3~, kel=\E[4~, kent=\EOM, kf1=\EOP, kf10=\E[21~, 
-	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
-	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
-	kf19=\E[33~, kf2=\EOQ, kf20=\E[34~, kf3=\EOR, kf4=\EOS, 
-	kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, 
-	khome=\E[1~, kich1=\E[2~, knp=\E[6~, knxt=^I, kpp=\E[5~, 
-	kprv=\E[Z, kslt=\E[4~, mc0=\E[i, mc4=\E[?4i, mc5=\E[?5i, 
-	nel=\EE, rc=\E8, rev=\E[7m, rf=/usr/share/tabset/vt300, 
-	ri=\EM, rmacs=\E(B, rmam=\E[?7l, rmir=\E[4l, 
-	rmkx=\E[?1l\E>, rmso=\E[m, rmul=\E[m, 
+	kbs=\177, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	kdch1=\E[3~, kel=\E[4~, kf10=\E[21~, kf11=\E[23~, 
+	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
+	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
+	kf20=\E[34~, kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, 
+	kf9=\E[20~, khome=\E[1~, kich1=\E[2~, knp=\E[6~, knxt=^I, 
+	kpp=\E[5~, kprv=\E[Z, kslt=\E[4~, mc0=\E[i, mc4=\E[?4i, 
+	mc5=\E[?5i, nel=\EE, rc=\E8, rev=\E[7m, 
+	rf=/usr/share/tabset/vt300, ri=\EM, rmacs=\E(B, 
+	rmam=\E[?7l, rmir=\E[4l, rmkx=\E[?1l\E>, rmso=\E[m, 
+	rmul=\E[m, 
 	rs2=\E>\E[?3l\E[?4l\E[5?l\E[?7h\E[?8h\E[1;24r\E[24;1H, 
 	sc=\E7, sgr0=\E[m, smacs=\E(0, smam=\E[?7h, smir=\E[4h, 
 	smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, tbc=\E[3g, 
-	tsl=\E[1$}\E[H\E[K, 
+	tsl=\E[1$}\E[H\E[K, use=vt220+keypad, 
 vt320-nam|vt300-nam|dec vt320 7 bit terminal with no am to make SAS happy, 
 	am@, 
 	is2=\E>\E[?3l\E[?4l\E[5?l\E[?7l\E[?8h\E[1;24r\E[24;1H, 
@@ -2584,6 +2621,13 @@
 	dch=\E[%p1%dP, ich=\E[%p1%d@, use=ecma+color, 
 	use=ms-vt100, 
 
+# a minimal subset of a vt100 (compare with "news-unk).
+tt|tkterm|Don Libes' tk text widget terminal emulator, 
+	clear=\E[H\E[J, cr=^M, cuf1=\E[C, cup=\E[%p1%d;%p2%dH, 
+	cuu1=\E[A, ind=^J, kf1=\EOP, kf2=\EOQ, kf3=\EOR, kf4=\EOS, 
+	kf5=\EOT, kf6=\EOU, kf7=\EOV, kf8=\EOW, kf9=\EOX, rmso=\E[m, 
+	smso=\E[7m, 
+
 #### X terminal emulators
 #
 # You can add the following line to your .Xdefaults to change the terminal type
@@ -2691,9 +2735,8 @@
 	ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, il=\E[%p1%dL, 
 	il1=\E[L, ind=^J, 
 	is2=\E7\E[r\E[m\E[?7h\E[?1;3;4;6l\E[4l\E8\E>, 
-	ka1=\EOw, ka3=\EOu, kb2=\EOy, kbeg=\EOE, kbs=^H, kc1=\EOq, 
-	kc3=\EOs, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
-	kdch1=\177, kend=\EOF, kent=\EOM, kf1=\E[11~, kf10=\E[21~, 
+	kbeg=\EOE, kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
+	kcuu1=\EOA, kdch1=\177, kend=\EOF, kf1=\E[11~, kf10=\E[21~, 
 	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
 	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
 	kf19=\E[33~, kf2=\E[12~, kf20=\E[34~, kf3=\E[13~, 
@@ -2710,7 +2753,7 @@
 	sgr0=\E[m\017, smacs=^N, smam=\E[?7h, smcup=\E7\E[?47h, 
 	smir=\E[4h, smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, 
 	tbc=\E[3g, u6=\E[%i%d;%dR, u7=\E[6n, u8=\E[?1;2c, u9=\E[c, 
-	vpa=\E[%i%p1%dd, use=ecma+color, 
+	vpa=\E[%i%p1%dd, use=ecma+color, use=vt220+keypad, 
 
 # This is the stock xterm entry supplied with XFree86 3.3, which uses VT100
 # codes for F1-F4 except while in VT220 mode.
@@ -2752,8 +2795,8 @@
 
 xterm-xfree86|xterm-new|xterm terminal emulator (XFree86 4.0 Window System), 
 	npc, 
-	kDC=\E[3;2~, kEND=\EO2F, kHOM=\EO2H, kIC=\E[2;2~, 
-	kLFT=\EO2D, kNXT=\E[6;2~, kPRV=\E[5;2~, kRIT=\EO2C, 
+	kDC=\E[3;2~, kEND=\E[1;2F, kHOM=\E[1;2H, kIC=\E[2;2~, 
+	kLFT=\E[1;2D, kNXT=\E[6;2~, kPRV=\E[5;2~, kRIT=\E[1;2C, 
 	kb2=\EOE, kcbt=\E[Z, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
 	kcuu1=\EOA, kend=\EOF, kent=\EOM, kf1=\EOP, kf10=\E[21~, 
 	kf11=\E[23~, kf12=\E[24~, kf13=\EO2P, kf14=\EO2Q, 
@@ -2819,6 +2862,14 @@
 xterm-88color|xterm with 88 colors, 
 	colors#88, pairs#88, use=xterm-256color, 
 
+# These two are used to demonstrate the any-event mouse support, i.e., by
+# using an extended name "XM" which tells ncurses to put the terminal into
+# a special mode when initializing the xterm mouse.
+xterm-1002|testing xterm-mouse, 
+	XM=\E[?1002%?%p1%{1}%=%th%el%;, use=xterm-xfree86, 
+xterm-1003|testing xterm-mouse, 
+	XM=\E[?1003%?%p1%{1}%=%th%el%;, use=xterm-xfree86, 
+
 # This is another variant, for XFree86 4.0 xterm (T.Dickey)
 # This is an 8-bit version of xterm, which emulates DEC vt220 with ANSI color.
 # To use it, your decTerminalID resource must be set to 200 or above.
@@ -2895,15 +2946,14 @@
 #	+ uses DEC-style control sequences for the application keypad.
 #	  
 xterm-vt220|XFree86 xterm emulating vt220, 
-	ka1=\EOw, ka3=\EOy, kbeg=\EOu, kc1=\EOq, kc3=\EOs, kcbt=\E[Z, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kend=\E[4~, 
-	kent=\EOM, kf1=\EOP, kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, 
-	kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, 
-	kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, kf2=\EOQ, 
-	kf20=\E[34~, kf3=\EOR, kf4=\EOS, kf5=\E[15~, kf6=\E[17~, 
-	kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, khome=\E[1~, 
-	kich1=\E[2~, kmous=\E[M, knp=\E[6~, kpp=\E[5~, 
-	use=xterm-basic, 
+	kbeg=\EOu, kcbt=\E[Z, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
+	kcuu1=\EOA, kend=\E[4~, kf10=\E[21~, kf11=\E[23~, 
+	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
+	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
+	kf20=\E[34~, kf5=\E[15~, kf6=\E[17~, kf7=\E[18~, 
+	kf8=\E[19~, kf9=\E[20~, khome=\E[1~, kich1=\E[2~, 
+	kmous=\E[M, knp=\E[6~, kpp=\E[5~, use=xterm-basic, 
+	use=vt220+keypad, 
 
 xterm-vt52|XFree86 xterm emulating dec vt52, 
 	cols#80, it#8, lines#24, 
@@ -2951,7 +3001,7 @@
 #  -- MATSUMOTO Shoji)
 kterm|kterm kanji terminal emulator (X window system), 
 	eslok, hs, 
-	acsc=++\,\,--..00II``aaffgghhjjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~, 
+	acsc=++\,\,--..00ii``aaffgghhjjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~, 
 	csr=\E[%i%p1%d;%p2%dr, dsl=\E[?H, enacs=, fsl=\E[?F, 
 	kmous=\E[M, rc=\E8, rmacs=\E(B, sc=\E7, smacs=\E(0, 
 	tsl=\E[?E\E[?%i%dT, use=xterm-r6, use=ecma+color, 
@@ -2981,9 +3031,8 @@
 	dch=\E[%p1%dP, dch1=\E[P, dl=\E[%p1%dM, dl1=\E[M, ed=\E[J, 
 	el=\E[K, el1=\E[1K, enacs=\E(B\E)0, home=\E[H, ht=^I, 
 	ich=\E[%p1%d@, il=\E[%p1%dL, il1=\E[L, ind=^J, 
-	is1=\E[r\E[m\E[?7h\E[?4;6l\E[4l, ka1=\EOw, ka3=\EOy, 
-	kb2=\EOu, kbs=^H, kc1=\EOq, kc3=\EOs, kcub1=\EOD, kcud1=\EOB, 
-	kcuf1=\EOC, kcuu1=\EOA, kend=\E[8~, kent=\EOM, kf1=\E[11~, 
+	is1=\E[r\E[m\E[?7h\E[?4;6l\E[4l, kbs=^H, kcub1=\EOD, 
+	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kend=\E[8~, kf1=\E[11~, 
 	kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, kf2=\E[12~, 
 	kf3=\E[13~, kf4=\E[14~, kf5=\E[15~, kf6=\E[17~, kf7=\E[18~, 
 	kf8=\E[19~, kf9=\E[20~, khome=\E[7~, kich1=\E[2~, 
@@ -2995,7 +3044,7 @@
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m, smacs=^N, smam=\E[?7h, 
 	smcup=\E[?1;41s\E[?1;41h\E=, smir=\E[4h, smso=\E[7m, 
-	smul=\E[4m, use=ecma+color, 
+	smul=\E[4m, use=ecma+color, use=vt220+keypad, 
 
 # The 'nxterm' distributed with Redhat Linux 5.2 is a slight rehack of
 # xterm-sb_right-ansi-3d, which implements ANSI colors, but does not support
@@ -3005,7 +3054,9 @@
 #
 # Redhat Linux 6.x distributes XFree86 xterm as "nxterm", which uses bce
 # colors; note that this is not compatible with the 5.2 version.
-nxterm|xterm-color|generic color xterm, 
+# csw (2002-05-15): make xterm-color primary instead of nxterm, to 
+#   match XFree86's xterm.terminfo usage and prevent circular links
+xterm-color|nxterm|generic color xterm, 
 	ncv@, 
 	op=\E[m, use=xterm-r6, use=klone+color, 
 
@@ -3146,10 +3197,9 @@
 	il=\E[%p1%dL, il1=\E[L, ind=^J, is1=\E[?47l\E=\E[?1l, 
 	is2=\E[r\E[m\E[2J\E[H\E[?7h\E[?1;3;4;6l\E[4l, 
 	kDC=\E[3$, kEND=\E[8$, kHOM=\E[7$, kLFT=\E[d, kNXT=\E[6$, 
-	kPRV=\E[5$, kRIT=\E[c, ka1=\EOw, ka3=\EOy, kb2=\EOu, kbs=^H, 
-	kc1=\EOq, kc3=\EOs, kcbt=\E[Z, kcub1=\E[D, kcud1=\E[B, 
-	kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kel=\E[8\^, 
-	kend=\E[8~, kent=\EOM, kf1=\E[11~, kf10=\E[21~, 
+	kPRV=\E[5$, kRIT=\E[c, kbs=^H, kcbt=\E[Z, kcub1=\E[D, 
+	kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, 
+	kel=\E[8\^, kend=\E[8~, kf1=\E[11~, kf10=\E[21~, 
 	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
 	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
 	kf19=\E[33~, kf2=\E[12~, kf20=\E[34~, kf3=\E[13~, 
@@ -3162,10 +3212,22 @@
 	rs2=\E[r\E[m\E[2J\E[H\E[?7h\E[?1;3;4;6l\E[4l\E>, 
 	s0ds=\E(B, s1ds=\E(0, sc=\E7, sgr0=\E[0m\017, smacs=^N, 
 	smcup=\E7\E[?47h, smir=\E[4h, smkx=\E=, smso=\E[7m, 
-	smul=\E[4m, tbc=\E[3g, 
+	smul=\E[4m, tbc=\E[3g, use=vt220+keypad, 
 rxvt|rxvt terminal emulator (X Window System), 
 	ncv@, 
-	sgr0=\E[m\017, use=rxvt-basic, use=ecma+color, 
+	cvvis=\E[?25h, hpa=\E[%i%p1%dG, kf0=\E[21~, 
+	sgr0=\E[m\017, vpa=\E[%i%p1%dd, use=rxvt-basic, 
+	use=ecma+color, 
+rxvt-color|rxvt terminal emulator (X Window System), 
+	use=rxvt, 
+rxvt-xpm|rxvt terminal emulator (X Window System), 
+	use=rxvt, 
+rxvt-cygwin|rxvt terminal emulator (X Window System) on cygwin, 
+	acsc=0\333+\257\,\256-\^`\004a\261f\370g\361h\260j\331k\277l\332m\300n\305o~p\304q\304r\304s_t\303u\264v\301w\302x\263y\363z\362{\343|\330}\234~\376, 
+	use=rxvt, 
+rxvt-cygwin-native|rxvt terminal emulator (native MS Window System port) on cygwin, 
+	acsc=0\333+\257\,\256-\^`\004a\261f\370g\361h\260j\331k\277l\332m\300n\305o~p\304q\304r\304s_t\303u\264v\301w\302x\263y\363z\362{\343|\330~\376, 
+	use=rxvt-cygwin, 
 
 # This variant is supposed to work with rxvt 2.7.7 when compiled with
 # NO_BRIGHTCOLOR defined.  rxvt needs more work...
@@ -3227,19 +3289,17 @@
 	dch=\E[%p1%dP, dch1=\E[P, dl=\E[%p1%dM, dl1=\E[M, ed=\E[J, 
 	el=\E[K, el1=\E[1K$<3>, enacs=\E(B\E)0, getm=\E[%p1%dY, 
 	home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, 
-	il=\E[%p1%dL, il1=\E[L, ind=^J, ka1=\EOq, ka3=\EOs, kb2=\EOr, 
-	kbs=^H, kc1=\EOp, kc3=\EOn, kcub1=\EOD, kcud1=\EOB, 
-	kcuf1=\EOC, kcuu1=\EOA, kend=\E[Y, kent=\EOM, kf0=\EOy, 
-	kf1=\EOP, kf10=\EOY, kf11=\EOZ, kf12=\EOA, kf2=\EOQ, 
-	kf3=\EOR, kf4=\EOS, kf5=\EOT, kf6=\EOU, kf7=\EOV, kf8=\EOW, 
-	kf9=\EOX, khome=\E[H, kmous=\E[^_, knp=\E[U, kpp=\E[V, 
-	rc=\E8, reqmp=\E[492Z, rev=\E[7m, ri=\EM, rmacs=^O, 
-	rmcup=\E@0\E[?4r, rmso=\E[m, 
+	il=\E[%p1%dL, il1=\E[L, ind=^J, kbs=^H, kcub1=\EOD, 
+	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kend=\E[Y, kf0=\EOy, 
+	kf10=\EOY, kf11=\EOZ, kf12=\EOA, kf5=\EOT, kf6=\EOU, 
+	kf7=\EOV, kf8=\EOW, kf9=\EOX, khome=\E[H, kmous=\E[^_, 
+	knp=\E[U, kpp=\E[V, rc=\E8, reqmp=\E[492Z, rev=\E[7m, ri=\EM, 
+	rmacs=^O, rmcup=\E@0\E[?4r, rmso=\E[m, 
 	rs1=\E>\E[1;3;4;5;6l\E[?7h\E[m\E[r\E[2J\E[H, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smcup=\E@0\E[?4s\E[?4h\E@1, 
-	smso=\E[7m, tbc=\E[3g, 
+	smso=\E[7m, tbc=\E[3g, use=vt100+fnkeys, 
 
 xtermc|xterm terminal emulator (color), 
 	colors#8, ncv#7, pairs#64, 
@@ -3332,7 +3392,7 @@
 # print interface, ANSI X3.64 colour escape sequences, etc.  Newsgroup postings
 # indicate that it emulates more than one terminal, but incompletely.
 # 
-# This is dapted from a FreeBSD bug-report by Daniel Rudy <dcrudy@pacbell.net>
+# This is adapted from a FreeBSD bug-report by Daniel Rudy <dcrudy@pacbell.net>
 # It is based on vt102's entry, with some subtle differences, but also
 #	has status line
 #	supports ANSI colors (except for 'op' string)
@@ -3349,19 +3409,71 @@
 	dch=\E[%p1%dP, dch1=\E[P, dl=\E[%p1%dM, dl1=\E[M, 
 	dsl=\E[?E, ed=\E[J, el=\E[K, el1=\E[1K$<3>, enacs=\E(B\E)0, 
 	fsl=\E[?F, home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, 
-	ich1=\E[@, il=\E[%p1%dL, il1=\E[L, ind=^J, ka1=\EOq, 
-	ka3=\EOs, kb2=\EOr, kbs=^H, kc1=\EOp, kc3=\EOn, kcub1=\EOD, 
-	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kent=\EOM, kf0=\EOy, 
-	kf1=\EOP, kf10=\EOx, kf2=\EOQ, kf3=\EOR, kf4=\EOS, kf5=\EOt, 
-	kf6=\EOu, kf7=\EOv, kf8=\EOl, kf9=\EOw, op=\E[100m, rc=\E8, 
-	rev=\E[7m, ri=\EM, rmacs=^O, rmcup=\E[2J\E[?47l\E8, 
-	rmkx=\E[?1l\E>, rmso=\E[m, rmul=\E[m, 
+	ich1=\E[@, il=\E[%p1%dL, il1=\E[L, ind=^J, kbs=^H, 
+	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kf0=\EOy, 
+	kf10=\EOx, kf5=\EOt, kf6=\EOu, kf7=\EOv, kf8=\EOl, kf9=\EOw, 
+	op=\E[100m, rc=\E8, rev=\E[7m, ri=\EM, rmacs=^O, 
+	rmcup=\E[2J\E[?47l\E8, rmkx=\E[?1l\E>, rmso=\E[m, 
+	rmul=\E[m, 
 	rs2=\E>\E[1;3;4;5;6l\E[?7h\E[100m\E[m\E[r\E[2J\E[H, 
 	sc=\E7, setab=\E[4%p1%dm, setaf=\E[3%p1%dm, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smcup=\E7\E[?47h, 
 	smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, tbc=\E[3g, 
-	tsl=\E[?E\E[?%i%p1%dT, 
+	tsl=\E[?E\E[?%i%p1%dT, use=vt100+fnkeys, 
+
+### MTERM
+#
+# This application is available by email from <mouse@Rodents.Montreal.QC.CA>.
+#
+# "mterm -type ansi" sets $TERM to "ansi"
+mterm-ansi|ANSI emulation, 
+	am, bw, mir, msgr, 
+	it#8, 
+	acsc=``aaffggiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~, 
+	bel=^G, blink=\E[5m, bold=\E[1m, clear=\E[H\E[J, cr=^M, 
+	cub=\E[%p1%dD, cub1=\E[D, cud=\E[%p1%dB, cud1=\E[B, 
+	cuf=\E[%p1%dC, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, 
+	cuu=\E[%p1%dA, cuu1=\E[A, dch=\E[%p1%dP, dch1=\E[P, 
+	dim=\E[2m, dl=\E[%p1%dM, dl1=\E[M, ech=\E[%p1%dX, ed=\E[J, 
+	el=\E[K, home=\E[H, hpa=\E[%i%p1%d`, ht=^I, ich1=, 
+	il=\E[%p1%dL, il1=\E[L, ind=\E[S, indn=\E[%p1%dS, 
+	invis=\E[8m, is2=\E)0\017, kbs=^H, nel=\EE, rev=\E[7m, 
+	ri=\E[T, rin=\E[%p1%dT, rmacs=^O, rmir=\E[4l, rmso=\E[27m, 
+	rmul=\E[24m, sgr0=\E[m, smacs=^N, smir=\E[4h, smso=\E[7m, 
+	smul=\E[4m, vpa=\E[%i%p1%dd, 
+# mterm normally sets $TERM to "mterm"
+mterm|mouse-sun|Der Mouse term, 
+	am, bw, mir, 
+	it#8, 
+	bel=^G, clear=^L, cr=^M, cub1=^H, cud1=^N, cuf1=^S, 
+	cup=\006%p1%d.%p2%d., cuu1=^X, dch1=^Y, dl1=^K, ed=^B, el=^C, 
+	home=^P, ht=^I, il1=^A, ind=^U, kbs=^H, ll=^R, nel=^M^U, ri=^W, 
+	rmir=^O, rmso=^T, smir=^Q, smso=^V, 
+# "mterm -type decansi" sets $TERM to "decansi"
+decansi|ANSI emulation with DEC compatibility hacks, 
+	am, mir, msgr, xenl, 
+	colors#8, it#8, pairs#64, 
+	acsc=``aaffggiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~, 
+	bel=^G, blink=\E[5m, bold=\E[1m, civis=\E[?25l, 
+	clear=\E[H\E[J, cnorm=\E[?25h, cr=^M, 
+	csr=\E[%i%p1%d;%p2%dr, cub=\E[%p1%dD, cub1=\E[D, 
+	cud=\E[%p1%dB, cud1=\E[B, cuf=\E[%p1%dC, cuf1=\E[C, 
+	cup=\E[%i%p1%d;%p2%dH, cuu=\E[%p1%dA, cuu1=\E[A, 
+	dch=\E[%p1%dP, dch1=\E[P, dim=\E[2m, dl=\E[%p1%dM, 
+	dl1=\E[M, ech=\E[%p1%dX, ed=\E[J, el=\E[K, enacs=\E(B\E)0, 
+	home=\E[H, hpa=\E[%i%p1%d`, ht=^I, ich1=, il=\E[%p1%dL, 
+	il1=\E[L, ind=\E[S, indn=\E[%p1%dS, invis=\E[8m, 
+	is2=\E)0\E[r\017, kbs=^H, kcub1=\EOD, kcud1=\EOB, 
+	kcuf1=\EOC, kcuu1=\EOA, nel=\EE, op=\E[0m, rc=\E8, rev=\E[7m, 
+	ri=\E[T, rin=\E[%p1%dT, rmacs=^O, rmam=\E[?7l, rmir=\E[4l, 
+	rmkx=\E[?1l\E>, rmso=\E[27m, rmul=\E[24m, sc=\E7, 
+	setab=\E[4%p1%dm, setaf=\E[3%p1%dm, 
+	sgr=\E[0%?%p6%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;%?%p5%t;2%;%?%p7%t;8%;m%?%p9%t\016%e\017%;, 
+	sgr0=\E[m, smacs=^N, smam=\E[?7h, smir=\E[4h, 
+	smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, u6=\E[%i%d;%dR, 
+	u7=\E[6n, vpa=\E[%i%p1%dd, 
+
 #### MGR
 #
 # MGR is a Bell Labs window system lighter-weight than X.
@@ -3467,11 +3579,18 @@
 	kf11=\E[23~, kf12=\E[24~, kf2=\EOQ, kf3=\EOR, kf4=\EOS, 
 	kf5=\E[15~, kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, 
 	khome=\E[1~, kich1=\E[2~, kmous=\E[M, knp=\E[6~, kpp=\E[5~, 
-	nel=\EE, rc=\E8, rev=\E[7m, ri=\EM, rmacs=^O, rmir=\E[4l, 
-	rmkx=\E[?1l\E>, rmso=\E[23m, rmul=\E[24m, rs2=\Ec, sc=\E7, 
-	sgr0=\E[m, smacs=^N, smir=\E[4h, smkx=\E[?1h\E=, 
-	smso=\E[3m, smul=\E[4m, tbc=\E[3g, E0=\E(B, S0=\E(%p1%c, 
+	nel=\EE, rc=\E8, rev=\E[7m, ri=\EM, rmacs=^O, 
+	rmcup=\E[?1049l, rmir=\E[4l, rmkx=\E[?1l\E>, rmso=\E[23m, 
+	rmul=\E[24m, rs2=\Ec, sc=\E7, sgr0=\E[m, smacs=^N, 
+	smcup=\E[?1049h, smir=\E[4h, smkx=\E[?1h\E=, smso=\E[3m, 
+	smul=\E[4m, tbc=\E[3g, E0=\E(B, S0=\E(%p1%c, 
 	use=ecma+color, 
+# The bce and status-line entries are from screen 3.9.13 (and require some
+# changes to .screenrc).
+screen-bce|VT 100/ANSI X3.64 virtual terminal with bce, 
+	bce, use=screen, 
+screen-s|VT 100/ANSI X3.64 virtual terminal with hardstatus line, 
+	dsl=\E_\E\\, fsl=\E\\, tsl=\E_, use=screen, 
 
 # Read the fine manpage:
 #       When  screen  tries  to  figure  out  a  terminal name for
@@ -3508,9 +3627,11 @@
 screen.xterm-r6|screen customized for X11R6 xterm, 
 	bw, use=xterm-r6, 
 # Color applications running in screen and TeraTerm do not play well together
-# on Solaris.
+# on Solaris because Sun's curses implementation gets confused.
 screen.teraterm|disable ncv in teraterm, 
-	ncv#127, use=screen, 
+	ncv#127, 
+	acsc=+\020\,\021-\030.^Y0\333`\004a\261f\370g\361h\260i\316j\331k\277l\332m\300n\305o~p\304q\304r\304s_t\303u\264v\301w\302x\263y\363z\362{\343|\330}\234~\376, 
+	use=screen, 
 
 screen-w|VT 100/ANSI X3.64 virtual terminal with 132 cols, 
 	cols#132, use=screen, 
@@ -3631,7 +3752,7 @@
 #### Pilot Pro Palm-Top
 #
 # Termcap for Top Gun Telnet and SSH on the Palm Pilot.
-# http://www.isaac.cs.berkeley.edu/pilot/tgtelnet.html
+# http://www.ai/~iang/TGssh/
 pilot|tgtelnet|Top Gun Telnet on the Palm Pilot Professional, 
 	OTbs, am, xenl, 
 	cols#39, lines#16, 
@@ -3763,6 +3884,9 @@
 sun-c|sun-cmd|Sun Microsystems Workstation console with scrollable history, 
 	lines#35, 
 	rmcup=\E[>4h, smcup=\E[>4l, use=sun, 
+sun-type4|Sun Workstation console with type 4 keyboard, 
+	kcub1=\E[217z, kcud1=\E[221z, kcuf1=\E[219z, 
+	kcuu1=\E[215z, use=sun-il, 
 
 #### Iris consoles
 #
@@ -4032,62 +4156,79 @@
 #### Non-Unix Consoles
 #
 
+### EMX termcap.dat compatibility modes
+#
+# Keypad:	Home=\0G	Up=\0H	PrPag=\0I
+#		ka1,kh		kcuu1		kpp,ka3
+#
+#		Left=\0K	5=\0L		Right=\0M
+#		kcub1		kb2		kcuf1
+#
+#		End=\0O		Down=\0P	NxPag=\0Q
+#		kc1,kend	kcud1		kc3,knp
+#
+#		Ins=\0R		Del=\0S
+#		kich1		kdch1
+#
+# On keyboard with 12 function keys,
+#	shifted f-keys: F13-F24
+#	control f-keys: F25-F36
+#	alt f-keys:     F37-F48
+# The shift/control/alt keys do not modify each other, but alt overrides both,
+# and control overrides shift.
+#
+# Also (possibly only EMX, so we don't put it in ansi.sys, etc): set the
+# no_color_video to inform the application that standout(1), underline(2)
+# reverse(4) and invisible(64) don't work with color.
+emx-base|DOS special keys, 
+	bce, bw, 
+	it#8, ncv#71, 
+	bel=^G, ka1=\0G, ka3=\0I, kb2=\0L, kbs=^H, kc1=\0O, kc3=\0Q, 
+	kcbt=\0^O, kcub1=\0K, kcud1=\0P, kcuf1=\0M, kcuu1=\0H, 
+	kdch1=\0S, kend=\0O, kf1=\0;, kf10=\0D, kf11=\0\205, 
+	kf12=\0\206, kf13=\0T, kf14=\0U, kf15=\0V, kf16=\0W, 
+	kf17=\0X, kf18=\0Y, kf19=\0Z, kf2=\0<, kf20=\0[, kf21=\0\\, 
+	kf22=\0], kf23=\0\207, kf24=\0\210, kf25=\0\^, kf26=\0_, 
+	kf27=\0`, kf28=\0a, kf29=\0b, kf3=\0=, kf30=\0c, kf31=\0d, 
+	kf32=\0e, kf33=\0f, kf34=\0g, kf35=\0\211, kf36=\0\212, 
+	kf37=\0h, kf38=\0i, kf39=\0j, kf4=\0>, kf40=\0k, kf41=\0l, 
+	kf42=\0m, kf43=\0n, kf44=\0o, kf45=\0p, kf46=\0q, 
+	kf47=\0\213, kf48=\0\214, kf5=\0?, kf6=\0@, kf7=\0A, kf8=\0B, 
+	kf9=\0C, khome=\0G, kich1=\0R, knp=\0Q, kpp=\0I, 
+	use=ansi.sys, 
+
 # Except for the "-emx" suffixes, these are as distributed with EMX 0.9b,
 # a Unix-style environment used on OS/2.  (Note that the suffix makes some
 # names longer than 14 characters, the nominal maximum).
 #
 # Removed: rmacs=\E[10m, smacs=\E[11m, because OS/2 does not implement acs.
 ansi-emx|ANSI.SYS color, 
-	am, bce, eo, mir, msgr, xenl, xon, 
+	am, bce, eo, mir, msgr, xon, 
 	colors#8, cols#80, it#8, lines#25, pairs#64, 
 	bel=^G, blink=\E[5m, bold=\E[1m, civis=\E[?25l, 
 	clear=\E[1;33;44m\E[H\E[J, cnorm=\E[?25h, cr=^M, cub1=^H, 
 	cud1=^J, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, cuu1=\E[A, 
 	dch=\E[%p1%dp, ed=\E[J, el=\E[K, flash=\E[?5h\E[?5l, 
 	home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, ind=^J, 
-	kb2=\E[G, kbs=^H, kcub1=\0K, kcud1=\0P, kcuf1=\0M, kcuu1=\0H, 
-	kf0=\0D, kf1=\0;, kf2=\0<, kf3=\0=, kf4=\0>, kf5=\0?, kf6=\0@, 
-	kf7=\0A, kf8=\0B, kf9=\0C, khome=\0G, kich1=\0R, kll=\0O, 
-	knp=\0Q, kpp=\0I, kspd=^Z, nel=^M^J, rev=\E[5;37;41m, 
-	rmir=\E[4l, rmpch=\E[10m, rmso=\E[0;44m\E[1;33m, 
-	rmul=\E[0;44m\E[1;33m, rs1=\Ec, setab=\E[4%p1%dm, 
-	setaf=\E[3%p1%dm, sgr0=\E[0m\E[1;33;44m, smir=\E[4h, 
-	smpch=\E[11m, smso=\E[0;31;47m, smul=\E[1;31;44m, 
-	tbc=\E[3g, u8=\E[?6c, u9=\E[c, 
+	kb2=\E[G, kbs=^H, kf0=\0D, kll=\0O, kspd=^Z, nel=^M^J, 
+	rev=\E[5;37;41m, rmir=\E[4l, rmpch=\E[10m, 
+	rmso=\E[0;44m\E[1;33m, rmul=\E[0;44m\E[1;33m, rs1=\Ec, 
+	setab=\E[4%p1%dm, setaf=\E[3%p1%dm, 
+	sgr0=\E[0m\E[1;33;44m, smir=\E[4h, smpch=\E[11m, 
+	smso=\E[0;31;47m, smul=\E[1;31;44m, tbc=\E[3g, u8=\E[?6c, 
+	u9=\E[c, use=emx-base, 
+# nice colors for Emacs (white on blue, mode line white on cyan)
 ansi-color-2-emx|ANSI.SYS color 2, 
-	am, bce, eo, mir, msgr, xenl, xon, 
-	colors#8, cols#80, it#8, lines#25, pairs#64, 
-	bel=^G, blink=\E[5m, bold=\E[1m, civis=\E[?25l, 
-	clear=\E[0;37;44m\E[H\E[J, cnorm=\E[?25h, cr=^M, cub1=^H, 
-	cud1=^J, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, cuu1=\E[A, 
-	dch=\E[%p1%dp, ed=\E[J, el=\E[K, flash=\E[?5h\E[?5l, 
-	home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, ind=^J, 
-	kb2=\E[G, kbs=^H, kcub1=\0K, kcud1=\0P, kcuf1=\0M, kcuu1=\0H, 
-	kf0=\0D, kf1=\0;, kf2=\0<, kf3=\0=, kf4=\0>, kf5=\0?, kf6=\0@, 
-	kf7=\0A, kf8=\0B, kf9=\0C, khome=\0G, kich1=\0R, kll=\0O, 
-	knp=\0Q, kpp=\0I, kspd=^Z, nel=^M^J, rev=\E[1;37;46m, 
-	rmir=\E[4l, rmpch=\E[10m, rmso=\E[0;37;44m, 
-	rmul=\E[0;37;44m, rs1=\Ec, setab=\E[4%p1%dm, 
-	setaf=\E[3%p1%dm, sgr0=\E[0;37;44m, smir=\E[4h, 
-	smpch=\E[11m, smso=\E[1;37;46m, smul=\E[1;36;44m, 
-	tbc=\E[3g, u8=\E[?6c, u9=\E[c, 
+	clear=\E[0;37;44m\E[H\E[J, rev=\E[1;37;46m, 
+	rmso=\E[0;37;44m, rmul=\E[0;37;44m, rs1=\Ec, 
+	setaf=\E[3%p1%dm, sgr0=\E[0;37;44m, smso=\E[1;37;46m, 
+	smul=\E[1;36;44m, use=ansi-emx, 
+# nice colors for Emacs (white on black, mode line black on cyan)
 ansi-color-3-emx|ANSI.SYS color 3, 
-	am, bce, eo, mir, msgr, xenl, xon, 
-	colors#8, cols#80, it#8, lines#25, pairs#64, 
-	bel=^G, blink=\E[5m, bold=\E[1m, civis=\E[?25l, 
-	clear=\E[0;37;40m\E[H\E[J, cnorm=\E[?25h, cr=^M, cub1=^H, 
-	cud1=^J, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, cuu1=\E[A, 
-	dch=\E[%p1%dp, ed=\E[J, el=\E[K, flash=\E[?5h\E[?5l, 
-	home=\E[H, ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, ind=^J, 
-	kb2=\E[G, kbs=^H, kcub1=\0K, kcud1=\0P, kcuf1=\0M, kcuu1=\0H, 
-	kf0=\0D, kf1=\0;, kf2=\0<, kf3=\0=, kf4=\0>, kf5=\0?, kf6=\0@, 
-	kf7=\0A, kf8=\0B, kf9=\0C, khome=\0G, kich1=\0R, kll=\0O, 
-	knp=\0Q, kpp=\0I, kspd=^Z, nel=^M^J, rev=\E[1;37;46m, 
-	rmir=\E[4l, rmpch=\E[10m, rmso=\E[0;37;40m, 
-	rmul=\E[0;37;40m, rs1=\Ec, setab=\E[4%p1%dm, 
-	setaf=\E[3%p1%dm, sgr0=\E[0;10m, smir=\E[4h, 
-	smpch=\E[11m, smso=\E[1;37;46m, smul=\E[0;36;40m, 
-	tbc=\E[3g, u8=\E[?6c, u9=\E[c, 
+	clear=\E[0;37;40m\E[H\E[J, rev=\E[1;37;46m, 
+	rmso=\E[0;37;40m, rmul=\E[0;37;40m, rs1=\Ec, 
+	setaf=\E[3%p1%dm, sgr0=\E[0;10m, smso=\E[1;37;46m, 
+	smul=\E[0;36;40m, use=ansi-emx, 
 mono-emx|stupid monochrome ansi terminal with only one kind of emphasis, 
 	am, 
 	cols#80, it#8, lines#24, 
@@ -4117,31 +4258,112 @@
 # I've indicated which of these were and which I used.
 # Cheers, earnie_boyd@yahoo.com
 # several changes based on running with tack and comparing with older entry -TD
+# more changes from csw:
+#   add    cbt   [backtab]
+#   remove eo    [erase overstrike with blank]
+#   change clear was \E[H\E[J  now \E[2J  (faster?)
+#   remove cols
+#   remove lines
+#   remove ncv#3 [colors collide with highlights, bitmask] not applicable
+#                to MSDOS box?
+#   add    cub   [cursor back param] 
+#   add    cuf   [cursor forward param]
+#   add    cuu   [cursor up param]
+#   add    cud   [cursor down param]
+#   add    hs    [has status line]
+#   add    fsl   [return from status line]
+#   add    tsl   [go to status line]
+#   add    smacs [Start alt charset] (not sure if this works)
+#   add    rmacs [End alt charset]   (ditto)
+#   add    smcup [enter_ca_mode] (save console; thanks Corinna)
+#   add    rmcup [exit_ca_mode]  (restore console; thanks Corinna)
+#   add    kb2   [center of keypad]
+#   add    u8    [user string 8] \E[?6c
+#   add    el    [clear to end of line] \E[K
+# Notes:
+#   cnorm [make cursor normal] not implemented
+#   flash [flash] not implemented
+#   blink [blink] not implemented very usefully in cygwin? \E[5m
+#   dim   [dim] not implemented very usefully in cygwin? \E[2m
+#   cub1  [cursor back 1] typically \E[D, but ^H is faster?
+#   kNXT  [shifted next key] not implemented
+#   kPRV  [shifted prev key] not implemented
+#   khome [home key] really is \E[1~ NOT \E[H
+#   tbc   [clear tab stops] not implemented
+#   xenl  [newline ignnored after 80 cols] messes up last line? Ehud Karni
+#   smpch [Start PC charset] is \E[11m, same as smacs
+#   rmpch [End PC charset] is \E[10m, same as rmacs
+#   mir   [move in insert mode] fails in tack?
+#   bce   [back color erase] causes problems with change background color?
+#   cvvis [make cursor very visible] causes a stackdump when testing with
+#         testcurs using the output option? \E[?25h\E[?8c
+#   civis [make cursor invisible] causes everything to stackdump? \E[?25l\E[?1c
+#   ech   [erase characters param] broken \E[%p1%dX
+#   kcbt  [back-tab key] not implemented in cygwin?  \E[Z
 cygwin|ansi emulation for Cygwin, 
-	am, eo, in, msgr, xon, 
-	colors#8, cols#80, it#8, lines#25, ncv#3, pairs#64, 
+	am, hs, in, msgr, xon, 
+	colors#8, it#8, pairs#64, 
 	acsc=+\020\,\021-\030.^Y0\333`\004a\261f\370g\361h\260j\331k\277l\332m\300n\305o~p\304q\304r\304s_t\303u\264v\301w\302x\263y\363z\362{\343|\330}\234~\376, 
-	bel=^G, bold=\E[1m, clear=\E[H\E[J, cr=^M, cub1=^H, 
-	cud1=\E[B, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, cuu1=\E[A, 
-	dch=\E[%p1%dP, dch1=\E[P, dl=\E[%p1%dM, dl1=\E[M, ed=\E[J, 
-	el=\E[K, el1=\E[1K, home=\E[H, hpa=\E[%i%p1%dG, ht=^I, 
-	hts=\EH, ich=\E[%p1%d@, ich1=\E[@, il=\E[%p1%dL, il1=\E[L, 
-	ind=^J, invis=\E[8m, kbs=^H, kcub1=\E[D, kcud1=\E[B, 
-	kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kend=\E[4~, kf1=\E[[A, 
+	bel=^G, bold=\E[1m, cbt=\E[Z, clear=\E[H\E[J, cr=^M, 
+	cub=\E[%p1%dD, cub1=^H, cud=\E[%p1%dB, cud1=\E[B, 
+	cuf=\E[%p1%dC, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, 
+	cuu=\E[%p1%dA, cuu1=\E[A, dch=\E[%p1%dP, dch1=\E[P, 
+	dl=\E[%p1%dM, dl1=\E[M, ed=\E[J, el=\E[K, el1=\E[1K, fsl=^G, 
+	home=\E[H, hpa=\E[%i%p1%dG, ht=^I, ich=\E[%p1%d@, 
+	ich1=\E[@, il=\E[%p1%dL, il1=\E[L, ind=^J, invis=\E[8m, 
+	kb2=\E[G, kbs=^H, kcub1=\E[D, kcud1=\E[B, kcuf1=\E[C, 
+	kcuu1=\E[A, kdch1=\E[3~, kend=\E[4~, kf1=\E[[A, 
 	kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, 
 	kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, 
 	kf18=\E[32~, kf19=\E[33~, kf2=\E[[B, kf20=\E[34~, 
 	kf3=\E[[C, kf4=\E[[D, kf5=\E[[E, kf6=\E[17~, kf7=\E[18~, 
 	kf8=\E[19~, kf9=\E[20~, khome=\E[1~, kich1=\E[2~, 
 	knp=\E[6~, kpp=\E[5~, kspd=^Z, nel=^M^J, op=\E[39;49m, 
-	rc=\E8, rev=\E[7m, ri=\EM, rmir=\E[4l, rmpch=\E[10m, 
+	rc=\E8, rev=\E[7m, ri=\EM, rmacs=\E[10m, 
+	rmcup=\E[2J\E[?47l\E8, rmir=\E[4l, rmpch=\E[10m, 
 	rmso=\E[27m, rmul=\E[24m, rs1=\Ec\E]R, sc=\E7, 
 	setab=\E[4%p1%dm, setaf=\E[3%p1%dm, 
 	sgr=\E[0;10%?%p1%t;7%;%?%p2%t;4%;%?%p3%t;7%;%?%p4%t;5%;%?%p6%t;1%;%?%p7%t;8%;%?%p9%t;11%;m, 
-	sgr0=\E[0;10m, smir=\E[4h, smpch=\E[11m, smso=\E[7m, 
-	smul=\E[4m, u6=\E[%i%d;%dR, u7=\E[6n, u9=\E[c, 
+	sgr0=\E[0;10m, smacs=\E11m, smcup=\E7\E[?47h, smir=\E[4h, 
+	smpch=\E[11m, smso=\E[7m, smul=\E[4m, tsl=\E];, 
+	u6=\E[%i%d;%dR, u7=\E[6n, u8=\E[?6c, u9=\E[c, 
 	vpa=\E[%i%p1%dd, 
 
+# I've supplied this so that you can help test new values and add other
+# features.  Cheers, earnie_boyd@yahoo.com.
+#
+# Some features are from pcansi.  The op value is from linux.  Function-keys
+# are from linux.  These have been tested not to cause problems.  xenl was in
+# this list, but DOES cause problems so it has been removed
+cygwinDBG|Debug Version for Cygwin, 
+	am, eo, mir, msgr, xon, 
+	colors#8, cols#80, it#8, lines#24, ncv#3, pairs#64, 
+	acsc=+\020\,\021-\030.^Y0\333`\004a\261f\370g\361h\260j\331k\277l\332m\300n\305o~p\304q\304r\304s_t\303u\264v\301w\302x\263y\363z\362{\343|\330}\234~\376, 
+	bel=^G, blink=\E[5m, bold=\E[1m, cbt=\E[Z, clear=\E[H\E[J, 
+	cnorm=\E[?25h, cr=^M, cub=\E[%p1%dD, cub1=\E[D, 
+	cud=\E[%p1%dB, cud1=\E[B, cuf=\E[%p1%dC, cuf1=\E[C, 
+	cup=\E[%i%p1%d;%p2%dH, cuu=\E[%p1%dA, cuu1=\E[A, 
+	dch=\E[%p1%dP, dch1=\E[P, dim=\E[2m, dl=\E[%p1%dM, 
+	dl1=\E[M, ed=\E[J, el=\E[K, el1=\E[1K, 
+	flash=\E[?5h\E[?5l$<200/>, home=\E[H, hpa=\E[%i%p1%dG, 
+	ht=^I, hts=\EH, ich=\E[%p1%d@, ich1=\E[@, il=\E[%p1%dL, 
+	il1=\E[L, ind=^J, invis=\E[8m, kNXT=\E[6$, kPRV=\E[5$, 
+	kb2=\E[G, kbs=^H, kcbt=\E[Z, kcub1=\E[D, kcud1=\E[B, 
+	kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kend=\E[4~, kf1=\E[[A, 
+	kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, 
+	kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, 
+	kf18=\E[32~, kf19=\E[33~, kf2=\E[[B, kf20=\E[34~, 
+	kf3=\E[[C, kf4=\E[[D, kf5=\E[[E, kf6=\E[17~, kf7=\E[18~, 
+	kf8=\E[19~, kf9=\E[20~, khome=\E[1~, kich1=\E[2~, 
+	knp=\E[6~, kpp=\E[5~, kspd=^Z, nel=^M^J, op=\E[39;49m, 
+	rc=\E8, rev=\E[7m, ri=\EM, rmacs=\E[10m, rmir=\E[4l, 
+	rmso=\E[m, rmul=\E[m, rs1=\Ec\E]R, sc=\E7, 
+	setab=\E[4%p1%dm, setaf=\E[3%p1%dm, 
+	sgr=\E[0;10%?%p1%t;7%;%?%p2%t;4%;%?%p3%t;7%;%?%p4%t;5%;%?%p6%t;1%;%?%p7%t;8%;%?%p9%t;12%;m, 
+	sgr0=\E[0;10m, smacs=\E[11m, smir=\E[4h, smso=\E[7m, 
+	smul=\E[4m, tbc=\E[2g, u6=\E[%i%d;%dR, u7=\E[6n, u8=\E[?6c, 
+	u9=\E[c, vpa=\E[%i%p1%dd, 
+
 # This entry fits the Windows NT console when the _POSIX_TERM environment
 # variable is set to 'on'.  While the Windows NT POSIX console is seldom used,
 # the Telnet client supplied with both the Windows for WorkGroup 3.11 TCP/IP
@@ -6939,9 +7161,8 @@
 	ich=\E[%p1%d@$<1*>, il=\E[%p1%dL$<2*>, il1=\E[L$<2>, 
 	ind=\n$<2>, ip=$<1>, 
 	is1=\E[2;4;20;30l\E[?1;10l\E[12h\E[?7;8;25h, 
-	is2=\E>\E(B\E)0\017, is3=\E[m, ka1=\EOw, ka3=\EOy, 
-	kb2=\EOu, kbs=^H, kc1=\EOq, kc3=\EOs, kcub1=\E[D, kcud1=\E[B, 
-	kcuf1=\E[C, kcuu1=\E[A, kdl1=\E[M, kel=\E[K, kent=\EOM, 
+	is2=\E>\E(B\E)0\017, is3=\E[m, kbs=^H, kcub1=\E[D, 
+	kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, kdl1=\E[M, kel=\E[K, 
 	kf1=\E[?5i, kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, 
 	kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, 
 	kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, kf2=\E[?3i, 
@@ -6956,7 +7177,7 @@
 	sgr=%?%p5%t\E[0t%;%?%p3%p1%|%t\E[1t%;%?%p2%t\E[2t%;%?%p4%t\E[3t%;%?%p1%p2%p3%p4%p5%|%|%|%|%t\E[7m%e\E[m%;%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smam=\E[?7h, smir=\E[4h, 
 	smkx=\E[?1l\E[?7h\E=, smso=\E[1t\E[7m, smul=\E[2t\E[4m, 
-	tbc=\E[3g, tsl=\E[>\,\001, 
+	tbc=\E[3g, tsl=\E[>\,\001, use=vt220+keypad, 
 #
 #	This terminal description uses the non-hidden attribute mode
 #	(with magic cookie).
@@ -7008,23 +7229,22 @@
 	ich=\E[%p1%d@$<4*>, il=\E[%p1%dL$<5*>, il1=\E[L$<5>, 
 	ind=\n$<3>, invis=\E[8m, ip=$<3>, is1=\E[62;1"p\E[?5W, 
 	is2=\E[2;4;20;30l\E[?1;4;10;16l\E[12h\E[?7;8;25h$<16>, 
-	is3=\E>\E(B\E)0\017\E[m, ka1=\EOw, ka3=\EOy, kb2=\EOu, 
-	kbs=^H, kc1=\EOq, kc3=\EOs, kcub1=\E[D, kcud1=\E[B, 
-	kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kent=\EOM, kf1=\EOP, 
-	kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, 
-	kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, 
-	kf18=\E[32~, kf19=\E[33~, kf2=\EOQ, kf20=\E[34~, kf3=\EOR, 
-	kf4=\EOS, kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, 
-	kfnd=\E[1~, khlp=\E[28~, khome=\E[26~, kich1=\E[2~, 
-	knp=\E[6~, kpp=\E[5~, kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, 
-	lf4=PF4, mc0=\E[0i, mc4=\E[4i, mc5=\E[5i, rc=\E8, rev=\E[7m, 
-	ri=\EM$<3>, rmacs=^O, rmam=\E[?7l, rmir=\E[4l, rmkx=\E>, 
-	rmso=\E[m, rmul=\E[m, rs1=\E[13l\E[3l\E!p, 
-	rs2=\E[35h\E[?3l$<70>, rs3=\E[?5l, sc=\E7, 
+	is3=\E>\E(B\E)0\017\E[m, kbs=^H, kcub1=\E[D, kcud1=\E[B, 
+	kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kf10=\E[21~, 
+	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
+	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
+	kf19=\E[33~, kf20=\E[34~, kf6=\E[17~, kf7=\E[18~, 
+	kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, khlp=\E[28~, 
+	khome=\E[26~, kich1=\E[2~, knp=\E[6~, kpp=\E[5~, 
+	kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, lf4=PF4, mc0=\E[0i, 
+	mc4=\E[4i, mc5=\E[5i, rc=\E8, rev=\E[7m, ri=\EM$<3>, 
+	rmacs=^O, rmam=\E[?7l, rmir=\E[4l, rmkx=\E>, rmso=\E[m, 
+	rmul=\E[m, rs1=\E[13l\E[3l\E!p, rs2=\E[35h\E[?3l$<70>, 
+	rs3=\E[?5l, sc=\E7, 
 	sgr=\E[0%?%p2%t;4%;%?%p3%p1%|%t;7%;%?%p4%t;5%;%?%p5%t;2%;%?%p6%t;1%;%?%p7%t;8%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smam=\E[?7h, smir=\E[4h, 
 	smkx=\E[?1l\E=, smso=\E[7m, smul=\E[4m, tbc=\E[3g, 
-	tsl=\E[40h\E7\E[25;%i%p1%dH, 
+	tsl=\E[40h\E7\E[25;%i%p1%dH, use=vt220+keypad, 
 #
 #	Wyse 85 with visual bell.
 wy85-vb|wyse85-vb|wyse 85 with visible bell, 
@@ -7113,25 +7333,24 @@
 	ich=\E[%p1%d@$<2>, il=\E[%p1%dL$<3*>, il1=\E[L$<3>, 
 	ind=\n$<2>, invis=\E[8m, ip=$<4>, is1=\E[?5W, 
 	is2=\E[2;4;20;30l\E[?1;4;10;16l\E[12h\E[?7;8;25h, 
-	is3=\E>\E(B\E)0\017\E[m, ka1=\EOw, ka3=\EOy, kb2=\EOu, 
-	kbs=^H, kc1=\EOq, kc3=\EOs, kcbt=\E[Z, kcub1=\E[D, 
-	kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kent=\EOM, 
-	kf1=\EOP, kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, 
-	kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, 
-	kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, kf2=\EOQ, 
-	kf20=\E[34~, kf3=\EOR, kf4=\EOS, kf6=\E[17~, kf7=\E[18~, 
-	kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, khlp=\E[28~, 
-	khome=\E[26~, kich1=\E[2~, knp=\E[6~, kpp=\E[5~, 
-	kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, lf4=PF4, mc0=\E[0i, 
-	mc4=\E[4i, mc5=\E[5i, rc=\E8, rev=\E[7m, ri=\EM$<2>, 
-	rmacs=^O, rmam=\E[?7l, rmcup=\E[ R, rmir=\E[4l, rmkx=\E>, 
-	rmso=\E[27m, rmul=\E[24m, 
+	is3=\E>\E(B\E)0\017\E[m, kbs=^H, kcbt=\E[Z, kcub1=\E[D, 
+	kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, kf1=\EOP, 
+	kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, 
+	kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, 
+	kf18=\E[32~, kf19=\E[33~, kf2=\EOQ, kf20=\E[34~, kf3=\EOR, 
+	kf4=\EOS, kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, 
+	kfnd=\E[1~, khlp=\E[28~, khome=\E[26~, kich1=\E[2~, 
+	knp=\E[6~, kpp=\E[5~, kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, 
+	lf4=PF4, mc0=\E[0i, mc4=\E[4i, mc5=\E[5i, rc=\E8, rev=\E[7m, 
+	ri=\EM$<2>, rmacs=^O, rmam=\E[?7l, rmcup=\E[ R, rmir=\E[4l, 
+	rmkx=\E>, rmso=\E[27m, rmul=\E[24m, 
 	rs1=\E[13l\E[3l\E\\\E[63;1"p\E[!p, rs2=\E[35h\E[?3l, 
 	rs3=\E[?5l\E[47h\E[40l\E[r, sc=\E7, 
 	sgr=\E[0%?%p2%t;4%;%?%p3%p1%|%t;7%;%?%p4%t;5%;%?%p5%t;2%;%?%p6%t;1%;%?%p7%t;8%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smam=\E[?7h, smcup=\E[ Q, 
 	smir=\E[4h, smkx=\E[?1l\E=, smso=\E[7m, smul=\E[4m, 
 	tbc=\E[3g, tsl=\E7\E[99;%i%p1%dH, vpa=\E[%i%p1%dd, 
+	use=vt220+keypad, 
 #
 #	Wyse 185 with 24 data lines and top status (terminal status)
 wy185-24|wyse185-24|wyse 185 with 24 data lines, 
@@ -7322,16 +7541,14 @@
 #	Function key set for the VT-320 (and wy85) compatible keyboard
 #
 wy370-105k|Wyse 370 with 105 key keyboard, 
-	ka1=\EOw, ka3=\EOy, kb2=\EOu, kbs=^H, kc1=\EOq, kc3=\EOs, 
-	kcub1=\E[D, kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, 
-	kdch1=\E[3~, kent=\EOM, kf1=\EOP, kf10=\E[21~, kf11=\E[23~, 
-	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
-	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
-	kf2=\EOQ, kf20=\E[34~, kf3=\EOR, kf4=\EOS, kf6=\E[17~, 
-	kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, 
+	kbs=^H, kcub1=\E[D, kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, 
+	kdch1=\E[3~, kf10=\E[21~, kf11=\E[23~, kf12=\E[24~, 
+	kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, kf16=\E[29~, 
+	kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, kf20=\E[34~, 
+	kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, 
 	khlp=\E[28~, khome=\E[26~, kich1=\E[2~, knp=\E[6~, 
 	kpp=\E[5~, kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, lf4=PF4, 
-	use=wy370-nk, 
+	use=wy370-nk, use=vt220+keypad, 
 #
 #	Function key set for the PC compatible keyboard
 #
@@ -7435,26 +7652,24 @@
 	hts=\EH, ich=\E[%p1%d@$<2>, il=\E[%p1%dL$<3*>, 
 	il1=\E[L$<3>, ind=\n$<2>, invis=\E[8m, ip=$<4>, is1=\E[?5W, 
 	is2=\E[2;4;20;30l\E[?1;4;10;16l\E[12h\E[?7;8;25;67h, 
-	is3=\E>\E(B\E)0\017\E[m, ka1=\EOw, ka3=\EOu, kb2=\EOy, 
-	kbs=^H, kc1=\EOq, kc3=\EOs, kcbt=\E[Z, kcub1=\E[D, 
+	is3=\E>\E(B\E)0\017\E[m, kbs=^H, kcbt=\E[Z, kcub1=\E[D, 
 	kcud1=\E[B, kcuf1=\E[C, kcuu1=\E[A, kdch1=\E[3~, ked=\E[1~, 
-	kel=\E[4~, kent=\EOM, kf1=\EOP, kf10=\E[21~, kf11=\E[23~, 
+	kel=\E[4~, kent=\EOM, kf10=\E[21~, kf11=\E[23~, 
 	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
 	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
-	kf2=\EOQ, kf20=\E[34~, kf3=\EOR, kf4=\EOS, kf6=\E[17~, 
-	kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, 
-	khlp=\E[28~, khome=\E[26~, kich1=\E[2~, knp=\E[6~, 
-	kpp=\E[5~, kslt=\E[4~, lf1=PF1, lf2=PF2, lf3=PF3, lf4=PF4, 
-	mc0=\E[0i, mc4=\E[4i, mc5=\E[5i, rc=\E8, rev=\E[7m, 
-	ri=\EM$<2>, rmacs=^O, rmam=\E[?7l, rmcup=\E[ R, rmir=\E[4l, 
-	rmso=\E[m, rmul=\E[24m, 
+	kf20=\E[34~, kf6=\E[17~, kf7=\E[18~, kf8=\E[19~, 
+	kf9=\E[20~, kfnd=\E[1~, khlp=\E[28~, khome=\E[26~, 
+	kich1=\E[2~, knp=\E[6~, kpp=\E[5~, kslt=\E[4~, lf1=PF1, 
+	lf2=PF2, lf3=PF3, lf4=PF4, mc0=\E[0i, mc4=\E[4i, mc5=\E[5i, 
+	rc=\E8, rev=\E[7m, ri=\EM$<2>, rmacs=^O, rmam=\E[?7l, 
+	rmcup=\E[ R, rmir=\E[4l, rmso=\E[m, rmul=\E[24m, 
 	rs1=\E[13l\E[3l\E\\\E[63;1"p\E[!p, rs2=\E[35h\E[?3l, 
 	rs3=\E[?5l\E[47h\E[40l\E[r, sc=\E7, 
 	sgr=\E[0%?%p2%t;4%;%?%p3%p1%|%t;7%;%?%p4%t;5%;%?%p5%t;2%;%?%p6%t;1%;%?%p7%t;8%;m%?%p9%t\016%e\017%;, 
 	sgr0=\E[m\017, smacs=^N, smam=\E[?7h, 
 	smcup=\E[ Q\E[?67;8h, smir=\E[4h, smso=\E[7m, smul=\E[4m, 
 	tbc=\E[3g, tsl=\E[2$~\E[1$}\E[%i%p1%d`, 
-	vpa=\E[%i%p1%dd, 
+	vpa=\E[%i%p1%dd, use=vt220+keypad, 
 #
 #       Wyse 520 with 24 data lines and status (terminal status)
 wy520-24|wyse520-24|wyse 520 with 24 data lines, 
@@ -7976,17 +8191,15 @@
 	cup=\E[%i%p1%d;%p2%dH$<5>, cuu1=\E[A$<2>, dch1=\E[P, 
 	dl1=\E[M, ed=\E[J$<50>, el=\E[K$<3>, el1=\E[1K$<3>, 
 	enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, ich1=\E[@, 
-	il1=\E[L, ind=^J, ka1=\EOq, ka3=\EOs, kb2=\EOr, kbs=^H, 
-	kc1=\EOp, kc3=\EOn, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
-	kcuu1=\EOA, kent=\EOM, kf0=\EOy, kf1=\EOP, kf10=\EOx, 
-	kf2=\EOQ, kf3=\EOR, kf4=\EOS, kf5=\EOt, kf6=\EOu, kf7=\EOv, 
-	kf8=\EOl, kf9=\EOw, rc=\E8, rev=\E[7m$<2>, ri=\EM$<5>, 
-	rmacs=^O, rmam=\E[?7l, rmkx=\E[?1l\E>, rmso=\E[m$<2>, 
+	il1=\E[L, ind=^J, kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
+	kcuu1=\EOA, rc=\E8, rev=\E[7m$<2>, ri=\EM$<5>, rmacs=^O, 
+	rmam=\E[?7l, rmkx=\E[?1l\E>, rmso=\E[m$<2>, 
 	rmul=\E[m$<2>, rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, 
 	sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<2>, 
 	sgr0=\E[m\017$<2>, smacs=^N, smam=\E[?7h, smkx=\E[?1h\E=, 
 	smso=\E[1;7m$<2>, smul=\E[4m$<2>, tbc=\E[3g, 
+	use=vt100+fnkeys, 
 
 # 
 # Teletype Model 5420 -- A souped up 5410, with multiple windows,
@@ -11380,16 +11593,14 @@
 	cuu1=\E[A$<2>, dch1=\E~W, dl1=\E~R, ed=\E[J$<50>, 
 	el=\E[K$<3>, el1=\E[1K$<3>, enacs=\E(B\E)0, home=\E[H, 
 	ht=^I, hts=\EH, ich1=\E~Q, il1=\E~E, ind=^J, is1=\E~)\E~ea, 
-	ka1=\EOq, ka3=\EOs, kb2=\EOr, kbs=^H, kc1=\EOp, kc3=\EOn, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kent=\EOM, 
-	kf0=\EOy, kf1=\EOP, kf10=\EOx, kf2=\EOQ, kf3=\EOR, kf4=\EOS, 
-	kf5=\EOt, kf6=\EOu, kf7=\EOv, kf8=\EOl, kf9=\EOw, rc=\E8, 
-	rev=\E[7m$<2>, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
+	kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	rc=\E8, rev=\E[7m$<2>, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
 	rmkx=\E[?1l\E>, rmso=\E[m$<2>, rmul=\E[m$<2>, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<2>, 
 	sgr0=\E[m\017$<2>, smacs=^N, smam=\E[?7h, smkx=\E[?1h\E=, 
 	smso=\E[1;7m$<2>, smul=\E[4m$<2>, tbc=\E[3g, 
+	use=vt100+fnkeys, 
 ts100-ctxt|falco ts-100 saving context, 
 	rmcup=\E~_b, smcup=\E~_d\E[2J, use=ts100, 
 
@@ -13192,19 +13403,17 @@
 	il1=\E[L$<5>, ind=\ED$<5>, indn=\E[%p1%dE$<5>, 
 	invis=\E[8m, 
 	is2=\E[!p\E[?7;19;67h\E[?1;3;4l\E(B\E)0\017\E[2J\E[1;1H\E>$<200>, 
-	ka1=\EOw, ka3=\EOu, kb2=\EOy, kbs=^H, kc1=\EOq, kc3=\EOs, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
-	kdch1=\E[3~, kent=\EOM, kf1=\EOP, kf2=\EOQ, kf3=\EOR, 
-	kf4=\EOS, kfnd=\E[1~, khlp=\E[28~, kich1=\E[2~, knp=\E[6~, 
-	kpp=\E[5~, krdo=\E[29~, kslt=\E[4~, nel=\EE$<5>, rc=\E8, 
-	rev=\E[7m, ri=\EM$<5>, rmacs=^O, rmir=\E[4l, 
+	kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	kdch1=\E[3~, kfnd=\E[1~, khlp=\E[28~, kich1=\E[2~, 
+	knp=\E[6~, kpp=\E[5~, krdo=\E[29~, kslt=\E[4~, nel=\EE$<5>, 
+	rc=\E8, rev=\E[7m, ri=\EM$<5>, rmacs=^O, rmir=\E[4l, 
 	rmkx=\E[?1l\E>, rmso=\E[0m, rmul=\E[0m, 
 	rs2=\E[!p\E[?7;19;67h\E[?1;3;4l\E(B\E)0\017\E[2J\E[1;1H\E>$<200>, 
 	sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<20>, 
 	sgr0=\E[0m\017$<20>, smacs=^N, smir=\E[4h, 
 	smkx=\E[?1h\E=, smso=\E[1;7m, smul=\E[4m, tbc=\E[3g, 
-	tsl=\E[2$~\E[1$}, vpa=\E[%p1%dd$<40>, 
+	tsl=\E[2$~\E[1$}, vpa=\E[%p1%dd$<40>, use=vt220+keypad, 
 ncr260vt100wan|NCR 2900_260 vt100 wide mode ansi kybd, 
 	cols#132, 
 	cup=\E[%i%p1%d;%p2%dH$<30>, 
@@ -13242,15 +13451,14 @@
 	ich=\E[%p1%d@$<5>, il=\E[%p1%dL$<5>, il1=\E[L$<5>, 
 	ind=\ED$<5>, indn=\E[%p1%dE$<5>, invis=\E[8m, 
 	is2=\E[!p\E[?7;19;67h\E[?1;3;4l\E(B\E)0\017\E[2J\E[1;1H\E>$<200>, 
-	ka1=\EOw, ka3=\EOu, kb2=\EOy, kbs=^H, kc1=\EOq, kc3=\EOs, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
-	kdch1=\E[3~, kent=\EOM, kf0=\EOy, kf1=\EOP, kf10=\E[21~, 
-	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
-	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
-	kf19=\E[33~, kf2=\EOQ, kf20=\E[34~, kf21=\E[31~, 
-	kf22=\E[32~, kf23=\E[33~, kf24=\E[34~, kf25=\E[35~, 
-	kf26=\E[1~, kf27=\E[2~, kf28=\E[3~, kf29=\E[4~, kf3=\EOR, 
-	kf30=\E[5~, kf31=\E[6~, kf32=\E[7~, kf33=\E[8~, kf34=\E[9~, 
+	kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	kdch1=\E[3~, kf0=\EOy, kf10=\E[21~, kf11=\E[23~, 
+	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
+	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
+	kf2=\EOQ, kf20=\E[34~, kf21=\E[31~, kf22=\E[32~, 
+	kf23=\E[33~, kf24=\E[34~, kf25=\E[35~, kf26=\E[1~, 
+	kf27=\E[2~, kf28=\E[3~, kf29=\E[4~, kf3=\EOR, kf30=\E[5~, 
+	kf31=\E[6~, kf32=\E[7~, kf33=\E[8~, kf34=\E[9~, 
 	kf35=\E[10~, kf4=\EOS, kf5=\E[M, kf6=\E[17~, kf7=\E[18~, 
 	kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, khlp=\E[28~, 
 	kich1=\E[2~, knp=\E[6~, kpp=\E[5~, krdo=\E[29~, kslt=\E[4~, 
@@ -13263,6 +13471,7 @@
 	sgr0=\E[0m\017$<20>, smacs=\016$<20>, smam=\E[?7h, 
 	smir=\E[4h, smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, 
 	tbc=\E[3g, tsl=\E[2$~\E[1$}, vpa=\E[%p1%dd$<40>, 
+	use=vt220+keypad, 
 ncr260vt200wan|NCR 2900_260 vt200 wide mode ansi kybd, 
 	cols#132, 
 	cup=\E[%i%p1%d;%p2%dH$<30>, 
@@ -13298,27 +13507,27 @@
 	ich=\E[%p1%d@$<5>, il=\E[%p1%dL$<5>, il1=\E[L$<5>, 
 	ind=\ED$<5>, indn=\E[%p1%dE$<5>, invis=\E[8m, 
 	is2=\E[!p\E[?7;19;67h\E[?1;3;4l\E[1;0%w\E(B\E)0\017\E[2J\E[1;1H\E>$<200>, 
-	ka1=\EOw, ka3=\EOu, kb2=\EOy, kbs=^H, kc1=\EOq, kc3=\EOs, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
-	kdch1=\E[3~, kent=\EOM, kf0=\EOy, kf1=\EOP, kf10=\E[21~, 
-	kf11=\E[23~, kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, 
-	kf15=\E[28~, kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, 
-	kf19=\E[33~, kf2=\EOQ, kf20=\E[34~, kf21=\E[31~, 
-	kf22=\E[32~, kf23=\E[33~, kf24=\E[34~, kf25=\E[35~, 
-	kf26=\E[1~, kf27=\E[2~, kf28=\E[3~, kf29=\E[4~, kf3=\EOR, 
-	kf30=\E[5~, kf31=\E[6~, kf32=\E[7~, kf33=\E[8~, kf34=\E[9~, 
-	kf35=\E[10~, kf4=\EOS, kf5=\E[M, kf6=\E[17~, kf7=\E[18~, 
-	kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, khlp=\E[28~, 
-	kich1=\E[2~, knp=\E[6~, kpp=\E[5~, krdo=\E[29~, kslt=\E[4~, 
-	mc0=\E[i, mc4=\E[4i, mc5=\E[5i, nel=\EE, rc=\E8, rev=\E[7m, 
-	ri=\EM$<5>, rmacs=\017$<20>, rmam=\E[?7l, rmir=\E[4l, 
-	rmkx=\E[?1l\E>, rmso=\E[27m, rmul=\E[24m, 
+	kbs=^H, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	kdch1=\E[3~, kf0=\EOy, kf10=\E[21~, kf11=\E[23~, 
+	kf12=\E[24~, kf13=\E[25~, kf14=\E[26~, kf15=\E[28~, 
+	kf16=\E[29~, kf17=\E[31~, kf18=\E[32~, kf19=\E[33~, 
+	kf20=\E[34~, kf21=\E[31~, kf22=\E[32~, kf23=\E[33~, 
+	kf24=\E[34~, kf25=\E[35~, kf26=\E[1~, kf27=\E[2~, 
+	kf28=\E[3~, kf29=\E[4~, kf30=\E[5~, kf31=\E[6~, kf32=\E[7~, 
+	kf33=\E[8~, kf34=\E[9~, kf35=\E[10~, kf5=\E[M, kf6=\E[17~, 
+	kf7=\E[18~, kf8=\E[19~, kf9=\E[20~, kfnd=\E[1~, 
+	khlp=\E[28~, kich1=\E[2~, knp=\E[6~, kpp=\E[5~, 
+	krdo=\E[29~, kslt=\E[4~, mc0=\E[i, mc4=\E[4i, mc5=\E[5i, 
+	nel=\EE, rc=\E8, rev=\E[7m, ri=\EM$<5>, rmacs=\017$<20>, 
+	rmam=\E[?7l, rmir=\E[4l, rmkx=\E[?1l\E>, rmso=\E[27m, 
+	rmul=\E[24m, 
 	rs2=\E[!p\E[?7;19;67h\E[?1;3;4l\E[1;0%w\E(B\E)0\017\E[2J\E[1;1H\E>$<200>, 
 	sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<20>, 
 	sgr0=\E[0m\017$<20>, smacs=\016$<20>, smam=\E[?7h, 
 	smir=\E[4h, smkx=\E[?1h\E=, smso=\E[7m, smul=\E[4m, 
 	tbc=\E[3g, tsl=\E[2$~\E[1$}, vpa=\E[%p1%dd$<40>, 
+	use=vt220+keypad, 
 ncr260vt300wan|NCR 2900_260 vt300 wide mode ansi kybd, 
 	cols#132, 
 	cup=\E[%i%p1%d;%p2%dH$<30>, 
@@ -13406,7 +13615,7 @@
 #
 ncr260wy350pp|NCR 2900_260 wyse 350, 
 	am, bw, hs, km, mc5i, mir, msgr, xon, 
-	colors#16, cols#80, lines#24, ncv#33, nlab#32, xmc#1, 
+	colors#16, cols#80, lines#24, ncv#33, nlab#32, pairs#16, xmc#1, 
 	acsc=07a?h;j5k3l2m1n8q\:t4u9v=w0x6, bel=^G, blink=\EG2, 
 	cbt=\EI, civis=\E`0, clear=\E+$<20>, cnorm=\E`1, cr=^M, 
 	cub1=\010$<5>, cud1=\n$<5>, cuf1=\014$<5>, 
@@ -14005,17 +14214,15 @@
 	cuf=\E[%p1%dC, cuf1=\E[C$<2>, 
 	cup=\E[%i%p1%d;%p2%dH$<5>, cuu=\E[%p1%dA, 
 	cuu1=\E[A$<2>, ed=\E[J$<50>, el=\E[K$<3>, el1=\E[1K$<3>, 
-	enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, ind=^J, ka1=\EOq, 
-	ka3=\EOs, kb2=\EOr, kbs=^H, kc1=\EOp, kc3=\EOn, kcub1=\EOD, 
-	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kent=\EOM, kf0=\EOy, 
-	kf1=\EOP, kf10=\EOx, kf2=\EOQ, kf3=\EOR, kf4=\EOS, kf5=\EOt, 
-	kf6=\EOu, kf7=\EOv, kf8=\EOl, kf9=\EOw, rc=\E8, 
+	enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, ind=^J, kbs=^H, 
+	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, rc=\E8, 
 	rev=\E[7m$<2>, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
 	rmkx=\E[?1l\E>, rmso=\E[m$<2>, rmul=\E[m$<2>, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
 	sgr=\E[0%?%p1%p6%|%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m%?%p9%t\016%e\017%;$<2>, 
 	sgr0=\E[m\017$<2>, smacs=^N, smam=\E[?7h, smkx=\E[?1h\E=, 
 	smso=\E[1;7m$<2>, smul=\E[4m$<2>, tbc=\E[3g, 
+	use=vt100+fnkeys, 
 
 # Tektronix 4105 from BRL
 # The following setup modes are assumed for normal operation:
@@ -14831,15 +15038,14 @@
 	cup=\E[%i%p1%d;%p2%dH, cuu=\E[%p1%dA, cuu1=\E[A, 
 	dl=\E[%p1%dM, dl1=\E[M, ed=\E[J, el=\E[K, el1=\E[1K, 
 	home=\E[H, ht=^I, hts=\EH, il=\E[%p1%dL, il1=\E[L, ind=^J, 
-	ka1=\EOq, ka3=\EOs, kb2=\EOr, kbs=\177, kc1=\EOp, kc3=\EOn, 
-	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, kent=\EOM, 
-	kf1=\EOP, kf2=\EOQ, kf3=\EOR, kf4=\EOS, rc=\E8, rev=\E[7m, 
-	ri=\EM, rmam=\E[?7l, rmkx=\E[?1l\E>, rmso=\E[m, rmul=\E[m, 
+	kbs=\177, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, 
+	kent=\EOM, rc=\E8, rev=\E[7m, ri=\EM, rmam=\E[?7l, 
+	rmkx=\E[?1l\E>, rmso=\E[m, rmul=\E[m, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
 	sgr=\E[0%?%p6%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;%?%p4%t;5%;m, 
 	sgr0=\E[m\017, smam=\E[?7h, smkx=\E[?1h\E=, smso=\E[7m, 
 	smul=\E[4m, tbc=\E[3g, u6=\E[%i%d;%dR, u7=\E[6n, 
-	u8=\E[?1;2c, u9=\E[c, 
+	u8=\E[?1;2c, u9=\E[c, use=vt100+pfkeys, 
 
 nsterm+acs|AppKit Terminal.app v41+ basic capabilities w/VT100 alternate-charset, 
 	acsc=``aaffggjjkkllmmnnooppqqrrssttuuvvwwxxyyzz{{||}}~~, 
@@ -15026,14 +15232,14 @@
 	cub=\E[%p1%dD, cub1=\E[D, cud=\E[%p1%dB, cud1=\E[B, 
 	cuf=\E[%p1%dC, cuf1=\E[C, cup=\E[%i%p1%d;%p2%dH, 
 	cuu=\E[%p1%dA, cuu1=\E[A, dsl=\E]2;\007, ed=\E[J, el=\E[K, 
-	el1=\E[1K, home=\E[H, ht=^I, hts=\EH, ind=^J, ka1=\EOq, 
-	ka3=\EOs, kb2=\EOr, kbs=\177, kc1=\EOp, kc3=\EOn, kcub1=\EOD, 
-	kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, rc=\E8, rev=\E[7m, 
-	ri=\EM, rmam=\E[?7l, rmkx=\E[?1l\E>, rmso=\E[m, rmul=\E[m, 
-	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sc=\E7, 
+	el1=\E[1K, home=\E[H, ht=^I, hts=\EH, ind=^J, kbs=\177, 
+	kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, kcuu1=\EOA, rc=\E8, 
+	rev=\E[7m, ri=\EM, rmam=\E[?7l, rmkx=\E[?1l\E>, rmso=\E[m, 
+	rmul=\E[m, rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, 
+	sc=\E7, 
 	sgr=\E[0%?%p6%t;1%;%?%p2%t;4%;%?%p1%p3%|%t;7%;m, 
 	sgr0=\E[m\017, smam=\E[?7h, smkx=\E[?1h\E=, smso=\E[7m, 
-	smul=\E[4m, tbc=\E[3g, 
+	smul=\E[4m, tbc=\E[3g, use=vt100+keypad, 
 
 xnuppc+c|Darwin PowerPC Console ANSI color support, 
 	colors#8, ncv#32, pairs#64, 
@@ -17642,7 +17848,7 @@
 # respectively, to be able to restore them when color changes
 # (because any color change turns off ALL attributes)
 # 3. <bold> and <rev> sequences alternate modes,
-# rather then simply  entering them.  Thus we have to check the
+# rather than simply  entering them.  Thus we have to check the
 # static register B and H to determine the status, before sending the 
 # escape sequence.
 # 4. <sgr0> now must set the status of all 3 register (A,B,H) to zero
@@ -17744,15 +17950,12 @@
 	cup=\E[%i%p1%d;%p2%dH$<5>, cuu=\E[%p1%dA, 
 	cuu1=\E[A$<2>, dl1=\E[M$<99>, ed=\E[J$<50>, el=\E[K$<3>, 
 	el1=\E[1K$<3>, enacs=\E(B\E)0, home=\E[H, ht=^I, hts=\EH, 
-	il1=\E[L$<99>, ind=^J, ka1=\EOq, ka3=\EOs, kb2=\EOr, kbs=^H, 
-	kc1=\EOp, kc3=\EOn, kcub1=\EOD, kcud1=\EOB, kcuf1=\EOC, 
-	kcuu1=\EOA, kent=\EOM, kf0=\EOy, kf1=\EOP, kf10=\EOx, 
-	kf2=\EOQ, kf3=\EOR, kf4=\EOS, kf5=\EOt, kf6=\EOu, kf7=\EOv, 
-	kf8=\EOl, kf9=\EOw, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
+	il1=\E[L$<99>, ind=^J, kbs=^H, kcub1=\EOD, kcud1=\EOB, 
+	kcuf1=\EOC, kcuu1=\EOA, ri=\EM$<5>, rmacs=^O, rmam=\E[?7l, 
 	rmkx=\E[?1l\E>, rmso=\E[m\s, 
 	rs2=\E>\E[?3l\E[?4l\E[?5l\E[?7h\E[?8h, sgr0=\E[m, 
 	smacs=^N, smam=\E[?7h, smkx=\E[?1h\E=, smso=\E[7m\s, 
-	tbc=\E[3g, 
+	tbc=\E[3g, use=vt100+fnkeys, 
 
 # The official PC terminal emulator program of the AT&T Product Centers.
 # Note - insert mode commented out - doesn't seem to work on AT&T PC.
@@ -18325,12 +18528,12 @@
 # (T) ECMA-48 calls this "Partial Line Forward" but retains the PLD
 # abbreviation.
 #
-# (U) ECMA-48 calls this "Partial Line Backward" but retains the PLD
+# (U) ECMA-48 calls this "Partial Line Backward" but retains the PLU
 # abbreviation.
 #
 # (V) ECMA-48 calls this "Reverse Line Feed" but retains the RI abbreviation.
 #
-# (W) RM/SM modes are as follows: 1 = Guarder Area Transfer Mode (GATM), 
+# (W) RM/SM modes are as follows: 1 = Guarded Area Transfer Mode (GATM), 
 # 2 = Keyboard Action Mode (KAM), 3 = Control Representation Mode (CRM), 
 # 4 = Insertion Replacement Mode, 5 = Status Report Transfer Mode (SRTM),
 # 6 = Erasure Mode (ERM), 7 = Line Editing Mode (LEM), 8 = Bi-Directional
@@ -19536,8 +19739,45 @@
 #	* scaled the linux-c terminfo entry to match linux-c-nc, i.e., the
 #	  r/g/b parameters of initc are in the range 0 to 1000 -TD
 #
-# 2002-1005
+# 2002-10-05
 #	* minor fix for scale-factor of linux-c and linux-c-nc -TD
+#
+# 2002-11-09
+#	* split-out vt100+keypad and vt220+keypad, fix interchanged ka3/kb2
+#	  in the latter -TD
+#
+# 2002-11-16
+#	* add entries for mterm (mterm, mterm-ansi, decansi) -TD
+#	* ncr260wy350pp has only 16 color pairs -TD
+#	* add sun-type4 from NetBSD -TD
+#	* update xterm-xfree86 to current (patch 170) -TD
+#	* add screen-bce, screen-s entries -TD
+#	* add xterm-1002, xterm-1003 entries -TD
+#
+# 2003-01-11
+#	* update homepage for Top Gun Telnet/SSH
+#
+# 2003-01-25
+#	* reduce duplication in emx entries, added emx-base -TD
+#
+# 2003-05-24
+#	* corrected acs for screen.teraterm -TD
+#	* add tkterm entry -TD
+#
+# 2003-07-15
+#	* cygwin changes from Charles Wilson:
+#	  misc/terminfo.src (nxterm|xterm-color): make xterm-color
+#	  primary instead of nxterm, to match XFree86's xterm.terminfo
+#	  usage and to prevent circular links.
+#	  (rxvt): add additional codes from rxvt.org.
+#	  (rxvt-color): new alias
+#	  (rxvt-xpm): new alias
+#	  (rxvt-cygwin): like rxvt, but with special acsc codes.
+#	  (rxvt-cygwin-native): ditto.  rxvt may be run under XWindows, or
+#	  with a "native" MSWin GUI.  Each takes different acsc codes,
+#	  which are both different from the "normal" rxvt's acsc.
+#	  (cygwin): cygwin-in-cmd.exe window.  Lots of fixes.
+#	  (cygwinDBG): ditto.
 #
 # The following sets edit modes for GNU EMACS.
 # Local Variables:
Index: mk-1st.awk
Prereq:  1.55 
--- ncurses-5.3-20021012/mk-1st.awk	Sat Apr 20 13:32:47 2002
+++ ncurses-5.3-20030719/mk-1st.awk	Sat Jul 19 14:44:32 2003
@@ -1,4 +1,4 @@
-# $Id: mk-1st.awk,v 1.55 2002/04/20 17:32:47 tom Exp $
+# $Id: mk-1st.awk,v 1.59 2003/07/19 18:44:32 Charles.Wilson Exp $
 ##############################################################################
 # Copyright (c) 1998,2000,2002 Free Software Foundation, Inc.                #
 #                                                                            #
@@ -27,7 +27,7 @@
 # authorization.                                                             #
 ##############################################################################
 #
-# Author: Thomas E. Dickey <dickey@clark.net> 1996,1997,2000
+# Author: Thomas E. Dickey 1996,1997,2000,2002
 #
 # Generate list of objects for a given model library
 # Variables:
@@ -38,7 +38,7 @@
 #	MODEL (e.g., "DEBUG", uppercase; toupper is not portable)
 #	depend (optional dependencies for all objects, e.g, ncurses_cfg.h)
 #	subset ("none", "base", "base+ext_funcs" or "termlib")
-#	target (cross-compile target, if any)
+#	host (cross-compile host, if any)
 #	ShlibVer ("rel", "abi" or "auto", to augment DoLinks variable)
 #	ShlibVerInfix ("yes" or "no", determines location of version #)
 #	DoLinks ("yes", "reverse" or "no", flag to add symbolic links)
@@ -110,7 +110,7 @@
 			if (using == 0) {
 				if (found == 0) {
 					print  ""
-					print  "# generated by mk-1st.awk"
+					printf "# generated by mk-1st.awk (subset=%s)\n", subset
 					print  ""
 				}
 				using = 1
@@ -162,8 +162,8 @@
 			if ( MODEL == "SHARED" )
 			{
 				if (ShlibVerInfix == "cygdll") {
-					abi_name = sprintf("%s%s$(ABI_VERSION)%s", prefix, name, suffix);
-					rel_name = sprintf("%s%s$(REL_VERSION)%s", prefix, name, suffix);
+					abi_name = sprintf("%s%s$(ABI_VERSION)%s", "cyg", name, suffix);
+					rel_name = sprintf("%s%s$(REL_VERSION)%s", "cyg", name, suffix);
 					imp_name = sprintf("%s%s%s.a", prefix, name, suffix);
 				} else if (ShlibVerInfix == "yes") {
 					abi_name = sprintf("%s%s.$(ABI_VERSION)%s", prefix, name, suffix);
@@ -194,7 +194,7 @@
 					print "\t-@rm -f $@";
 				}
 				if ( subset == "termlib") {
-					printf "\t$(MK_SHARED_LIB) $(%s_OBJS) $(TINFO_LIST)\n", OBJS
+					printf "\t$(MK_SHARED_LIB) $(%s_OBJS) $(TINFO_LIST) $(LDFLAGS)\n", OBJS
 				} else {
 					printf "\t$(MK_SHARED_LIB) $(%s_OBJS) $(SHLIB_LIST) $(LDFLAGS)\n", OBJS
 				}
@@ -233,9 +233,15 @@
 
 				if ( overwrite == "yes" && name == "ncurses" )
 				{
-					ovr_name = sprintf("libcurses%s", suffix)
-					printf "\t@echo linking %s to %s\n", end_name, ovr_name
-					printf "\tcd $(DESTDIR)$(libdir) && (rm -f %s; $(LN_S) %s %s; )\n", ovr_name, end_name, ovr_name
+					if ( ShlibVer == "cygdll" ) {
+						ovr_name = sprintf("libcurses%s.a", suffix)
+						printf "\t@echo linking %s to %s\n", imp_name, ovr_name
+						printf "\tcd $(DESTDIR)$(libdir) && (rm -f %s; $(LN_S) %s %s; )\n", ovr_name, imp_name, ovr_name
+					} else {
+						ovr_name = sprintf("libcurses%s", suffix)
+						printf "\t@echo linking %s to %s\n", end_name, ovr_name
+						printf "\tcd $(DESTDIR)$(libdir) && (rm -f %s; $(LN_S) %s %s; )\n", ovr_name, end_name, ovr_name
+					}
 				}
 				if ( ldconfig != "" ) {
 					printf "\t- test -z \"$(DESTDIR)\" && %s\n", ldconfig
@@ -257,7 +263,11 @@
 					removelinks("$(DESTDIR)$(libdir)")
 					if ( overwrite == "yes" && name == "ncurses" )
 					{
-						ovr_name = sprintf("libcurses%s", suffix)
+						if ( ShlibVer == "cygdll" ) {
+							ovr_name = sprintf("libcurses%s.a", suffix)
+						} else {
+							ovr_name = sprintf("libcurses%s", suffix)
+						}
 						printf "\t-@rm -f $(DESTDIR)$(libdir)/%s\n", ovr_name
 					}
 				}
@@ -277,13 +287,13 @@
 				}
 				end_name = lib_name;
 				printf "../lib/%s : $(%s_OBJS)\n", lib_name, OBJS
-				printf "\tcd ../lib && $(LIBTOOL) $(%s) -o %s $(%s_OBJS:.o=.lo) -rpath $(DESTDIR)$(libdir) -version-info $(NCURSES_MAJOR):$(NCURSES_MINOR)\n", compile, lib_name, OBJS
+				printf "\tcd ../lib && $(LIBTOOL) $(%s) -o %s $(%s_OBJS:.o=.lo) -rpath $(DESTDIR)$(libdir) -version-info $(NCURSES_MAJOR):$(NCURSES_MINOR) $(SHLIB_LIST)\n", compile, lib_name, OBJS
 				print  ""
 				print  "install \\"
 				print  "install.libs \\"
 				printf "install.%s :: $(DESTDIR)$(libdir) ../lib/%s\n", name, lib_name
 				printf "\t@echo installing ../lib/%s as $(DESTDIR)$(libdir)/%s\n", lib_name, lib_name
-				printf "\tcd ../lib; $(LIBTOOL) $(INSTALL_DATA) %s $(DESTDIR)$(libdir)\n", lib_name
+				printf "\tcd ../lib; $(LIBTOOL) $(INSTALL) %s $(DESTDIR)$(libdir)\n", lib_name
 				print  ""
 				print  "uninstall \\"
 				print  "uninstall.libs \\"
@@ -297,7 +307,7 @@
 				printf "../lib/%s : $(%s_OBJS)\n", lib_name, OBJS
 				printf "\t$(AR) $(AR_OPTS) $@ $?\n"
 				printf "\t$(RANLIB) $@\n"
-				if ( target == "vxworks" )
+				if ( host == "vxworks" )
 				{
 					printf "\t$(LD) $(LD_OPTS) $? -o $(@:.a=.o)\n"
 				}
@@ -314,7 +324,7 @@
 					printf "\t(cd $(DESTDIR)$(libdir) && $(LN_S) libncurses.a libcurses.a)\n"
 				}
 				printf "\t$(RANLIB) $(DESTDIR)$(libdir)/%s\n", lib_name
-				if ( target == "vxworks" )
+				if ( host == "vxworks" )
 				{
 					printf "\t@echo installing ../lib/lib%s.o as $(DESTDIR)$(libdir)/lib%s.o\n", name, name
 					printf "\t$(INSTALL_DATA) ../lib/lib%s.o $(DESTDIR)$(libdir)/lib%s.o\n", name, name
@@ -330,7 +340,7 @@
 					printf "\t@echo linking libcurses.a to libncurses.a\n"
 					printf "\t-@rm -f $(DESTDIR)$(libdir)/libcurses.a\n"
 				}
-				if ( target == "vxworks" )
+				if ( host == "vxworks" )
 				{
 					printf "\t@echo uninstalling $(DESTDIR)$(libdir)/lib%s.o\n", name
 					printf "\t-@rm -f $(DESTDIR)$(libdir)/lib%s.o\n", name
Index: ncurses/Makefile.in
Prereq:  1.84 
--- ncurses-5.3-20021012/ncurses/Makefile.in	Sat Jun 29 18:36:25 2002
+++ ncurses-5.3-20030719/ncurses/Makefile.in	Sat Jun  7 17:09:50 2003
@@ -1,6 +1,6 @@
-# $Id: Makefile.in,v 1.84 2002/06/29 22:36:25 tom Exp $
+# $Id: Makefile.in,v 1.88 2003/06/07 21:09:50 tom Exp $
 ##############################################################################
-# Copyright (c) 1998,1999,2000,2001,2002 Free Software Foundation, Inc.      #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -27,7 +27,7 @@
 # authorization.                                                             #
 ##############################################################################
 #
-# Author: Thomas E. Dickey 1996-2001
+# Author: Thomas E. Dickey 1996-2002
 #
 # Makefile for ncurses source code.
 #
@@ -86,10 +86,10 @@
 
 CCFLAGS		= $(CPPFLAGS) $(CFLAGS)
 
-HOSTCC		= @BUILD_CC@
-HOSTCCFLAGS	= -DHAVE_CONFIG_H -I../ncurses -I$(srcdir) @BUILD_CFLAGS@ @BUILD_CPPFLAGS@
-HOSTLDFLAGS	= @BUILD_LDFLAGS@
-HOSTLIBS	= @BUILD_LIBS@
+BUILD_CC	= @BUILD_CC@
+BUILD_CCFLAGS	= -DHAVE_CONFIG_H -I../ncurses -I$(srcdir) @BUILD_CPPFLAGS@ @BUILD_CFLAGS@
+BUILD_LDFLAGS	= @BUILD_LDFLAGS@
+BUILD_LIBS	= @BUILD_LIBS@
 
 CFLAGS_LIBTOOL	= $(CCFLAGS)
 CFLAGS_NORMAL	= $(CCFLAGS)
@@ -113,7 +113,7 @@
 REL_VERSION	= @cf_cv_rel_version@
 ABI_VERSION	= @cf_cv_abi_version@
 
-RANLIB		= @RANLIB@
+RANLIB		= @LIB_PREP@
 
 IMPORT_LIB	= @IMPORT_LIB@
 SHARED_LIB	= @SHARED_LIB@
@@ -189,12 +189,12 @@
 make_keys$x : \
 		$(tinfo)/make_keys.c \
 		names.c
-	$(HOSTCC) -o $@ $(HOSTCCFLAGS) $(tinfo)/make_keys.c $(HOSTLDFLAGS) $(HOSTLIBS)
+	$(BUILD_CC) -o $@ $(BUILD_CCFLAGS) $(tinfo)/make_keys.c $(BUILD_LDFLAGS) $(BUILD_LIBS)
 
 make_hash$x : \
 		$(tinfo)/comp_hash.c \
 		../include/hashsize.h
-	$(HOSTCC) -o $@ $(HOSTCCFLAGS) -DMAIN_PROGRAM $(tinfo)/comp_hash.c $(HOSTLDFLAGS) $(HOSTLIBS)
+	$(BUILD_CC) -o $@ $(BUILD_CCFLAGS) -DMAIN_PROGRAM $(tinfo)/comp_hash.c $(BUILD_LDFLAGS) $(BUILD_LIBS)
 
 expanded.c : $(serial)/MKexpanded.sh
 	sh $(serial)/MKexpanded.sh "$(CPP)" $(CPPFLAGS) > $@
Index: ncurses/base/MKlib_gen.sh
Prereq:  1.20 
--- ncurses-5.3-20021012/ncurses/base/MKlib_gen.sh	Sat Sep 28 11:02:11 2002
+++ ncurses-5.3-20030719/ncurses/base/MKlib_gen.sh	Sat Feb 22 14:58:07 2003
@@ -2,10 +2,10 @@
 #
 # MKlib_gen.sh -- generate sources from curses.h macro definitions
 #
-# ($Id: MKlib_gen.sh,v 1.20 2002/09/28 15:02:11 tom Exp $)
+# ($Id: MKlib_gen.sh,v 1.22 2003/02/22 19:58:07 tom Exp $)
 #
 ##############################################################################
-# Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.                #
+# Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.                #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -82,19 +82,19 @@
 	cat >$ED1 <<EOF1
 /^extern.*implemented/{
 	h
-	s/^.*implemented:\([^ 	*]*\).*/P_#if_USE_\1_SUPPORT/p
+	s/^.*implemented:\([^ 	*]*\).*/P_POUNDCif_USE_\1_SUPPORT/p
 	g
 	s/^extern \([^;]*\);.*/\1/p
 	g
-	s/^.*implemented:\([^ 	*]*\).*/P_#endif/p
+	s/^.*implemented:\([^ 	*]*\).*/P_POUNDCendif/p
 }
 /^extern.*generated/{
 	h
-	s/^.*generated:\([^ 	*]*\).*/P_#if_USE_\1_SUPPORT/p
+	s/^.*generated:\([^ 	*]*\).*/P_POUNDCif_USE_\1_SUPPORT/p
 	g
 	s/^extern \([^;]*\);.*/\1/p
 	g
-	s/^.*generated:\([^ 	*]*\).*/P_#endif/p
+	s/^.*generated:\([^ 	*]*\).*/P_POUNDCendif/p
 }
 EOF1
 else
@@ -102,11 +102,11 @@
 	cat >$ED1 <<EOF1
 /^extern.*${ALL}/{
 	h
-	s/^.*${ALL}:\([^ 	*]*\).*/P_#if_USE_\1_SUPPORT/p
+	s/^.*${ALL}:\([^ 	*]*\).*/P_POUNDCif_USE_\1_SUPPORT/p
 	g
 	s/^extern \([^;]*\);.*/\1/p
 	g
-	s/^.*${ALL}:\([^ 	*]*\).*/P_#endif/p
+	s/^.*${ALL}:\([^ 	*]*\).*/P_POUNDCendif/p
 }
 EOF1
 fi
@@ -134,13 +134,14 @@
 	s/)/ z)/
 	s/\.\.\. z)/...)/
 :nc
-	/(/s// ( /
+	s/(/ ( /
 	s/)/ )/
 EOF2
 
 cat >$ED3 <<EOF3
 /^P_/{
-	s/^P_#if_/#if /
+	s/^P_POUNDCif_/#if /
+	s/^P_POUNDCendif/#endif/
 	s/^P_//
 	b done
 }
@@ -151,7 +152,7 @@
 	s/ )/)/g
 	s/ gen_/ /
 	s/^M_/#undef /
-	/^%%/s//	/
+	/^%%/s/%%/	/
 :done
 EOF3
 
@@ -175,12 +176,12 @@
 BEGIN	{
 		skip=0;
 	}
-/^P_#if/ {
+/^P_POUNDCif/ {
 		print "\n"
 		print $0
 		skip=0;
 }
-/^P_#endif/ {
+/^P_POUNDCendif/ {
 		print $0
 		skip=1;
 }
Index: ncurses/base/define_key.c
Prereq:  1.6 
--- ncurses-5.3-20021012/ncurses/base/define_key.c	Sat Dec  9 21:43:26 2000
+++ ncurses-5.3-20030719/ncurses/base/define_key.c	Sat May 17 19:28:05 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -32,11 +32,10 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: define_key.c,v 1.6 2000/12/10 02:43:26 tom Exp $")
+MODULE_ID("$Id: define_key.c,v 1.8 2003/05/17 23:28:05 tom Exp $")
 
 NCURSES_EXPORT(int)
-define_key
-(char *str, int keycode)
+define_key(const char *str, int keycode)
 {
     int code = ERR;
 
@@ -49,8 +48,12 @@
 		code = OK;
 	}
 	if (str != 0) {
-	    (void) _nc_add_to_try(&(SP->_keytry), str, keycode);
-	    code = OK;
+	    if (key_defined(str) == 0) {
+		(void) _nc_add_to_try(&(SP->_keytry), str, keycode);
+		code = OK;
+	    } else {
+		code = ERR;
+	    }
 	}
     } else {
 	while (_nc_remove_string(&(SP->_keytry), str))
Index: ncurses/base/key_defined.c
--- /dev/null	Tue Jun  3 10:49:35 2003
+++ ncurses-5.3-20030719/ncurses/base/key_defined.c	Sat May 17 19:12:27 2003
@@ -0,0 +1,76 @@
+/****************************************************************************
+ * Copyright (c) 2003 Free Software Foundation, Inc.                        *
+ *                                                                          *
+ * Permission is hereby granted, free of charge, to any person obtaining a  *
+ * copy of this software and associated documentation files (the            *
+ * "Software"), to deal in the Software without restriction, including      *
+ * without limitation the rights to use, copy, modify, merge, publish,      *
+ * distribute, distribute with modifications, sublicense, and/or sell       *
+ * copies of the Software, and to permit persons to whom the Software is    *
+ * furnished to do so, subject to the following conditions:                 *
+ *                                                                          *
+ * The above copyright notice and this permission notice shall be included  *
+ * in all copies or substantial portions of the Software.                   *
+ *                                                                          *
+ * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS  *
+ * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF               *
+ * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.   *
+ * IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,   *
+ * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR    *
+ * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR    *
+ * THE USE OR OTHER DEALINGS IN THE SOFTWARE.                               *
+ *                                                                          *
+ * Except as contained in this notice, the name(s) of the above copyright   *
+ * holders shall not be used in advertising or otherwise to promote the     *
+ * sale, use or other dealings in this Software without prior written       *
+ * authorization.                                                           *
+ ****************************************************************************/
+
+/****************************************************************************
+ *  Author: Thomas E. Dickey, 2003                                          *
+ ****************************************************************************/
+
+#include <curses.priv.h>
+
+MODULE_ID("$Id: key_defined.c,v 1.3 2003/05/17 23:12:27 tom Exp $")
+
+static int
+find_definition(struct tries *tree, const char *str)
+{
+    struct tries *ptr;
+    int result = 0;
+
+    if (str != 0 && *str != '\0') {
+	for (ptr = tree; ptr != 0; ptr = ptr->sibling) {
+	    if (UChar(*str) == UChar(ptr->ch)) {
+		if (str[1] == '\0' && ptr->child != 0) {
+		    result = -1;
+		} else if ((result = find_definition(ptr->child, str + 1)) == 0) {
+		    result = ptr->value;
+		} else if (str[1] == '\0') {
+		    result = -1;
+		}
+	    }
+	    if (result != 0)
+		break;
+	}
+    }
+    return (result);
+}
+
+/*
+ * Returns the keycode associated with the given string.  If none is found,
+ * return 0.  If the string is only a prefix to other strings, return -1.
+ */
+NCURSES_EXPORT(int)
+key_defined(const char *str)
+{
+    int code = ERR;
+
+    T((T_CALLED("key_defined(%s)"), _nc_visbuf(str)));
+    if (SP != 0 && str != 0) {
+	code = find_definition(SP->_keytry, str);
+    }
+
+    returnCode(code);
+}
Index: ncurses/base/keybound.c
Prereq:  1.3 
--- ncurses-5.3-20021012/ncurses/base/keybound.c	Sat Dec  9 21:43:26 2000
+++ ncurses-5.3-20030719/ncurses/base/keybound.c	Sat Mar  8 14:39:31 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1999,2000 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1999-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -32,7 +32,7 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: keybound.c,v 1.3 2000/12/10 02:43:26 tom Exp $")
+MODULE_ID("$Id: keybound.c,v 1.4 2003/03/08 19:39:31 tom Exp $")
 
 /*
  * Returns the count'th string definition which is associated with the
@@ -42,5 +42,6 @@
 NCURSES_EXPORT(char *)
 keybound(int code, int count)
 {
-    return _nc_expand_try(SP->_key_ok, code, &count, 0);
+    T((T_CALLED("keybound(%d,%d)"), code, count));
+    returnPtr(_nc_expand_try(SP->_keytry, code, &count, 0));
 }
Index: ncurses/base/lib_addch.c
Prereq:  1.68 
--- ncurses-5.3-20021012/ncurses/base/lib_addch.c	Sat Sep 28 13:48:13 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_addch.c	Sat Jul  5 14:34:42 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -36,7 +36,7 @@
 #include <curses.priv.h>
 #include <ctype.h>
 
-MODULE_ID("$Id: lib_addch.c,v 1.68 2002/09/28 17:48:13 tom Exp $")
+MODULE_ID("$Id: lib_addch.c,v 1.76 2003/07/05 18:34:42 tom Exp $")
 
 /*
  * Ugly microtweaking alert.  Everything from here to end of module is
@@ -68,7 +68,7 @@
 	AddAttr(ch, (a & COLOR_MASK(AttrOf(ch))));
     }
 
-    TR(TRACE_VIRTPUT, ("bkg = %s, attrs = %s -> ch = %s",
+    TR(TRACE_VIRTPUT, ("render_char bkg %s, attrs %s -> ch %s",
 		       _tracech_t2(1, CHREF(win->_nc_bkgd)),
 		       _traceattr(win->_attrs),
 		       _tracech_t2(3, CHREF(ch))));
@@ -99,15 +99,21 @@
 #define CHECK_POSITION(win, x, y)	/* nothing */
 #endif
 
-static inline int
+static
+#if !USE_WIDEC_SUPPORT		/* cannot be inline if it is recursive */
+  inline
+#endif
+int
 waddch_literal(WINDOW *win, NCURSES_CH_T ch)
 {
     int x;
+    int y;
     struct ldat *line;
 
     x = win->_curx;
+    y = win->_cury;
 
-    CHECK_POSITION(win, x, win->_cury);
+    CHECK_POSITION(win, x, y);
 
     /*
      * If we're trying to add a character at the lower-right corner more
@@ -122,20 +128,65 @@
 #endif
 
     ch = render_char(win, ch);
-    TR(TRACE_VIRTPUT, ("win attr = %s", _traceattr(win->_attrs)));
 
-    line = win->_line + win->_cury;
+    line = win->_line + y;
 
     CHANGED_CELL(line, x);
 
     /*
+     * Build up multibyte characters until we have a wide-character.
+     */
+    if_WIDEC({
+	if (Charable(ch)) {
+	    WINDOW_EXT(win, addch_used) = 0;
+	} else {
+	    char *buffer = WINDOW_EXT(win, addch_work);
+	    int len;
+	    mbstate_t state;
+	    wchar_t result;
+
+	    if ((WINDOW_EXT(win, addch_used) != 0) &&
+		(WINDOW_EXT(win, addch_x) != x ||
+		 WINDOW_EXT(win, addch_y) != y)) {
+		/* discard the incomplete multibyte character */
+		WINDOW_EXT(win, addch_used) = 0;
+	    }
+	    WINDOW_EXT(win, addch_x) = x;
+	    WINDOW_EXT(win, addch_y) = y;
+
+	    memset(&state, 0, sizeof(state));
+	    buffer[WINDOW_EXT(win, addch_used)] = CharOf(ch);
+	    WINDOW_EXT(win, addch_used) += 1;
+	    buffer[WINDOW_EXT(win, addch_used)] = '\0';
+	    if ((len = mbrtowc(&result,
+			       buffer,
+			       WINDOW_EXT(win, addch_used), &state)) > 0) {
+		attr_t attrs = AttrOf(ch);
+		SetChar(ch, result, attrs);
+		WINDOW_EXT(win, addch_used) = 0;
+	    } else {
+		if (len == -1) {
+		    /*
+		     * An error occurred.  We could either discard everything,
+		     * or assume that the error was in the previous input.
+		     * Try the latter.
+		     */
+		    TR(TRACE_VIRTPUT, ("Alert! mbrtowc returns error"));
+		    buffer[0] = CharOf(ch);
+		    WINDOW_EXT(win, addch_used) = 1;
+		}
+		return OK;
+	    }
+	}
+    });
+
+    /*
      * Handle non-spacing characters
      */
     if_WIDEC({
 	if (wcwidth(CharOf(ch)) == 0) {
 	    int i;
-	    int y;
-	    if ((x > 0 && ((y = win->_cury) >= 0))
+	    if ((x > 0 && y >= 0)
 		|| ((y = win->_cury - 1) >= 0 &&
 		    (x = win->_maxx) > 0)) {
 		wchar_t *chars = (win->_line[y].text[x - 1].chars);
@@ -154,8 +205,18 @@
      * Provide for multi-column characters
      */
     if_WIDEC({
-	if (wcwidth(CharOf(ch)) > 1)
+	int len = wcwidth(CharOf(ch));
+	while (len-- > 1) {
+	    if (x + (len - 1) > win->_maxx) {
+		NCURSES_CH_T blank = NewChar2(BLANK_TEXT, BLANK_ATTR);
+		AddAttr(blank, AttrOf(ch));
+		if (waddch_literal(win, blank) != ERR)
+		    return waddch_literal(win, ch);
+		return ERR;
+	    }
 	    AddAttr(line->text[x++], WA_NAC);
+	    TR(TRACE_VIRTPUT, ("added NAC %d", x - 1));
+	}
     }
   testwrapping:
     );
@@ -330,14 +391,30 @@
 NCURSES_EXPORT(int)
 wadd_wch(WINDOW *win, const cchar_t * wch)
 {
+    PUTC_DATA;
+    int n;
     int code = ERR;
 
     TR(TRACE_VIRTPUT | TRACE_CCALLS, (T_CALLED("wadd_wch(%p, %s)"), win,
 				      _tracech_t(wch)));
 
-    if (win && (waddch_nosync(win, *wch) != ERR)) {
-	_nc_synchook(win);
-	code = OK;
+    if (win != 0) {
+	PUTC_INIT;
+	while (PUTC_i < CCHARW_MAX) {
+	    if ((PUTC_ch = wch->chars[PUTC_i++]) == L'\0')
+		break;
+	    if ((PUTC_n = wcrtomb(PUTC_buf, PUTC_ch, &PUT_st)) <= 0) {
+		code = ERR;
+		break;
+	    }
+	    for (n = 0; n < PUTC_n; n++) {
+		if ((code = waddch(win, UChar(PUTC_buf[n]))) == ERR) {
+		    break;
+		}
+	    }
+	    if (code == ERR)
+		break;
+	}
     }
 
     TR(TRACE_VIRTPUT | TRACE_CCALLS, (T_RETURN("%d"), code));
@@ -347,18 +424,32 @@
 NCURSES_EXPORT(int)
 wecho_wchar(WINDOW *win, const cchar_t * wch)
 {
+    PUTC_DATA;
+    int n;
     int code = ERR;
 
     TR(TRACE_VIRTPUT | TRACE_CCALLS, (T_CALLED("wecho_wchar(%p, %s)"), win,
 				      _tracech_t(wch)));
 
-    if (win && (waddch_nosync(win, *wch) != ERR)) {
-	bool save_immed = win->_immed;
-	win->_immed = TRUE;
-	_nc_synchook(win);
-	win->_immed = save_immed;
-	code = OK;
+    if (win != 0) {
+	PUTC_INIT;
+	while (PUTC_i < CCHARW_MAX) {
+	    if ((PUTC_ch = wch->chars[PUTC_i++]) == L'\0')
+		break;
+	    if ((PUTC_n = wcrtomb(PUTC_buf, PUTC_ch, &PUT_st)) <= 0) {
+		code = ERR;
+		break;
+	    }
+	    for (n = 0; n < PUTC_n; n++) {
+		if ((code = wechochar(win, UChar(PUTC_buf[n]))) == ERR) {
+		    break;
+		}
+	    }
+	    if (code == ERR)
+		break;
+	}
     }
+
     TR(TRACE_VIRTPUT | TRACE_CCALLS, (T_RETURN("%d"), code));
     return (code);
 }
Index: ncurses/base/lib_addstr.c
Prereq:  1.34 
--- ncurses-5.3-20021012/ncurses/base/lib_addstr.c	Sat Oct  5 20:25:25 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_addstr.c	Sat Jul  5 15:45:21 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -29,6 +29,10 @@
 /****************************************************************************
  *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
+ *                                                                          *
+ *  Rewritten 2001-2002 to support wide-characters by                       *
+ *	Sven Verdoolaege                                                    *
+ *	Thomas Dickey                                                       *
  ****************************************************************************/
 
 /*
@@ -40,53 +44,13 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_addstr.c,v 1.34 2002/10/06 00:25:25 tom Exp $")
-
-#if USE_WIDEC_SUPPORT
-#define CONV_DATA   mbstate_t state; wchar_t cached; int clen = 0
-#define CONV_INIT   memset (&state, '\0', sizeof (state)); cached = (wchar_t)WEOF
-#define NEXT_CHAR(s,ch, n)						\
-    {									\
-	int len, i = 0;							\
-	memset(&ch, 0, sizeof(cchar_t));				\
-	if (cached != (wchar_t) WEOF) {					\
-	    ch.chars[i++] = cached;					\
-	    cached = (wchar_t) WEOF;					\
-	    n -= clen;							\
-	    s += clen;							\
-	}								\
-	for (; i < CCHARW_MAX && n > 0; ++i) {				\
-	    if ((len = mbrtowc(&ch.chars[i], s, n, &state)) < 0) {	\
-		code = ERR;						\
-		break;							\
-	    }								\
-	    if (i == 0 || wcwidth(ch.chars[i]) == 0) {			\
-		n -= len;						\
-		s += len;						\
-	    } else {							\
-		cached = ch.chars[i];					\
-		clen = len;						\
-		ch.chars[i] = L'\0';					\
-		break;							\
-	    }								\
-	}								\
-	if (code == ERR)						\
-	    break;							\
-    }
-#else
-#define CONV_DATA
-#define CONV_INIT
-#define NEXT_CHAR(s,ch, n)						\
-    ch = *s++;								\
-    --n
-#endif
+MODULE_ID("$Id: lib_addstr.c,v 1.38 2003/07/05 19:45:21 tom Exp $")
 
 NCURSES_EXPORT(int)
 waddnstr(WINDOW *win, const char *astr, int n)
 {
-    unsigned const char *str = (unsigned const char *) astr;
+    const char *str = astr;
     int code = ERR;
-    CONV_DATA;
 
     T((T_CALLED("waddnstr(%p,%s,%d)"), win, _nc_visbufn(astr, n), n));
 
@@ -97,11 +61,10 @@
 	    n = (int) strlen(astr);
 
 	TR(TRACE_VIRTPUT, ("str is not null, length = %d", n));
-	CONV_INIT;
-	while ((n > 0) && (*str != '\0')) {
+	while ((n-- > 0) && (*str != '\0')) {
 	    NCURSES_CH_T ch;
-	    TR(TRACE_VIRTPUT, ("*str = %#x", *str));
-	    NEXT_CHAR(str, ch, n);
+	    TR(TRACE_VIRTPUT, ("*str = %#o", UChar(*str)));
+	    SetChar(ch, UChar(*str++), A_NORMAL);
 	    if (_nc_waddch_nosync(win, ch) == ERR) {
 		code = ERR;
 		break;
@@ -114,7 +77,7 @@
 }
 
 NCURSES_EXPORT(int)
-waddchnstr(WINDOW *win, const chtype * astr, int n)
+waddchnstr(WINDOW *win, const chtype *astr, int n)
 {
     NCURSES_SIZE_T y = win->_cury;
     NCURSES_SIZE_T x = win->_curx;
@@ -155,7 +118,7 @@
 
 #if USE_WIDEC_SUPPORT
 
-int
+NCURSES_EXPORT(int)
 _nc_wchstrlen(const cchar_t * s)
 {
     int result = 0;
@@ -217,9 +180,8 @@
 waddnwstr(WINDOW *win, const wchar_t * str, int n)
 {
     int code = ERR;
-    int i;
 
-    T((T_CALLED("waddnwstr(%p,%s,%d)"), win, _nc_viswbufn(str,n), n));
+    T((T_CALLED("waddnwstr(%p,%s,%d)"), win, _nc_viswbufn(str, n), n));
 
     if (win && (str != 0)) {
 	TR(TRACE_VIRTPUT | TRACE_ATTRS, ("... current %s", _traceattr(win->_attrs)));
@@ -230,16 +192,9 @@
 	TR(TRACE_VIRTPUT, ("str is not null, length = %d", n));
 	while ((n-- > 0) && (*str != L('\0'))) {
 	    NCURSES_CH_T ch;
-	    TR(TRACE_VIRTPUT, ("*str[0] = %#lx", *str));
+	    TR(TRACE_VIRTPUT, ("*str[0] = %#lx", (unsigned long) *str));
 	    SetChar(ch, *str++, A_NORMAL);
-	    i = 1;
-	    while (i < CCHARW_MAX && n > 0 && (*str != L('\0'))
-		   && wcwidth(*str) == 0) {
-		TR(TRACE_VIRTPUT, ("*str[%d] = %#lx", i, *str));
-		ch.chars[i++] = *str++;
-		--n;
-	    }
-	    if (_nc_waddch_nosync(win, ch) == ERR) {
+	    if (wadd_wch(win, &ch) == ERR) {
 		code = ERR;
 		break;
 	    }
Index: ncurses/base/lib_bkgd.c
Prereq:  1.29 
--- ncurses-5.3-20021012/ncurses/base/lib_bkgd.c	Sun Sep 22 16:30:32 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_bkgd.c	Sat Jul  5 12:46:49 2003
@@ -33,7 +33,7 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_bkgd.c,v 1.29 2002/09/22 20:30:32 tom Exp $")
+MODULE_ID("$Id: lib_bkgd.c,v 1.30 2003/07/05 16:46:49 tom Exp $")
 
 /*
  * Set the window's background information.
@@ -70,7 +70,7 @@
 	    int tmp;
 
 	    wgetbkgrnd(win, &wch);
-	    tmp = wctob(CharOf(wch));
+	    tmp = _nc_to_char(CharOf(wch));
 
 	    win->_bkgd = ((tmp == EOF) ? ' ' : (chtype) tmp) | AttrOf(wch);
 	}
Index: ncurses/base/lib_freeall.c
Prereq:  1.20 
--- ncurses-5.3-20021012/ncurses/base/lib_freeall.c	Sat Jul 27 20:35:25 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_freeall.c	Sat Feb 15 16:18:14 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -39,7 +39,7 @@
 extern int malloc_errfd;	/* FIXME */
 #endif
 
-MODULE_ID("$Id: lib_freeall.c,v 1.20 2002/07/28 00:35:25 tom Exp $")
+MODULE_ID("$Id: lib_freeall.c,v 1.24 2003/02/15 21:18:14 tom Exp $")
 
 /*
  * Free all ncurses data.  This is used for testing only (there's no practical
@@ -51,8 +51,10 @@
     WINDOWLIST *p, *q;
     char *s;
 
+    T((T_CALLED("_nc_freeall()")));
 #if NO_LEAKS
     _nc_free_tparm();
+    FreeAndNull(_nc_oldnums);
 #endif
     if (SP != 0) {
 	while (_nc_windows != 0) {
@@ -82,18 +84,23 @@
 	_nc_free_termtype(&(cur_term->type));
 	free(cur_term);
     }
+    _nc_free_entries(_nc_head);
 
     if ((s = _nc_home_terminfo()) != 0)
 	free(s);
+
+    (void) _nc_printf_string(0, 0);
 #ifdef TRACE
     (void) _nc_trace_buf(-1, 0);
 #endif
+
 #if HAVE_LIBDBMALLOC
     malloc_dump(malloc_errfd);
 #elif HAVE_LIBDMALLOC
 #elif HAVE_PURIFY
     purify_all_inuse();
 #endif
+    returnVoid;
 }
 
 NCURSES_EXPORT(void)
Index: ncurses/base/lib_getch.c
Prereq:  1.67 
--- ncurses-5.3-20021012/ncurses/base/lib_getch.c	Sat Sep  7 13:17:59 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_getch.c	Sat May 17 19:49:28 2003
@@ -40,7 +40,7 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_getch.c,v 1.67 2002/09/07 17:17:59 tom Exp $")
+MODULE_ID("$Id: lib_getch.c,v 1.71 2003/05/17 23:49:28 tom Exp $")
 
 #include <fifo_defs.h>
 
@@ -53,6 +53,32 @@
 #define TWAIT_MASK 3
 #endif
 
+/*
+ * Check for mouse activity, returning nonzero if we find any.
+ */
+static int
+check_mouse_activity(int delay EVENTLIST_2nd(_nc_eventlist * evl))
+{
+    int rc;
+
+#if USE_SYSMOUSE
+    if ((SP->_mouse_type == M_SYSMOUSE)
+	&& (SP->_sysmouse_head < SP->_sysmouse_tail)) {
+	return 2;
+    }
+#endif
+    rc = _nc_timed_wait(TWAIT_MASK, delay, (int *) 0 EVENTLIST_2nd(evl));
+#if USE_SYSMOUSE
+    if ((SP->_mouse_type == M_SYSMOUSE)
+	&& (SP->_sysmouse_head < SP->_sysmouse_tail)
+	&& (rc == 0)
+	&& (errno == EINTR)) {
+	rc |= 2;
+    }
+#endif
+    return rc;
+}
+
 static inline int
 fifo_peek(void)
 {
@@ -88,7 +114,7 @@
 {
     int n;
     int ch = 0;
-    int mask;
+    int mask = 0;
 
     (void) mask;
     if (tail == -1)
@@ -101,11 +127,11 @@
 
 #ifdef NCURSES_WGETCH_EVENTS
     if (evl
-#if USE_GPM_SUPPORT || defined(USE_EMX_MOUSE)
+#if USE_GPM_SUPPORT || USE_EMX_MOUSE || USE_SYSMOUSE
 	|| (SP->_mouse_fd >= 0)
 #endif
 	) {
-	mask = _nc_timed_wait(TWAIT_MASK, -1, (int *) 0, evl);
+	mask = check_mouse_activity(-1 EVENTLIST_2nd(evl));
     } else
 	mask = 0;
 
@@ -114,18 +140,32 @@
 	ungetch(KEY_EVENT);
 	return KEY_EVENT;
     }
-#elif USE_GPM_SUPPORT || defined(USE_EMX_MOUSE)
-    if (SP->_mouse_fd >= 0)
-	mask = _nc_timed_wait(TWAIT_MASK, -1, (int *) 0 EVENTLIST_2nd(evl));
+#elif USE_GPM_SUPPORT || USE_EMX_MOUSE || USE_SYSMOUSE
+    if (SP->_mouse_fd >= 0) {
+	mask = check_mouse_activity(-1 EVENTLIST_2nd(evl));
+    }
 #endif
 
-#if USE_GPM_SUPPORT || defined(USE_EMX_MOUSE)
+#if USE_GPM_SUPPORT || USE_EMX_MOUSE
     if ((SP->_mouse_fd >= 0) && (mask & 2)) {
 	SP->_mouse_event(SP);
 	ch = KEY_MOUSE;
 	n = 1;
     } else
 #endif
+#if USE_SYSMOUSE
+	if ((SP->_mouse_type == M_SYSMOUSE)
+	    && (SP->_sysmouse_head < SP->_sysmouse_tail)) {
+	SP->_mouse_event(SP);
+	ch = KEY_MOUSE;
+	n = 1;
+    } else if ((SP->_mouse_type == M_SYSMOUSE)
+	       && (mask <= 0) && errno == EINTR) {
+	SP->_mouse_event(SP);
+	ch = KEY_MOUSE;
+	n = 1;
+    } else
+#endif
     {				/* Can block... */
 	unsigned char c2 = 0;
 	n = read(SP->_ifd, &c2, 1);
@@ -214,13 +254,19 @@
      * stuff its contents in the FIFO queue, and pop off
      * the first character to return it.
      */
-    if (head == -1 && !SP->_raw && !SP->_cbreak) {
+    if (head == -1 &&
+	!SP->_notty &&
+	!SP->_raw &&
+	!SP->_cbreak &&
+	!SP->_called_wgetch) {
 	char buf[MAXCOLUMNS], *sp;
 	int rc;
 
 	TR(TRACE_IEVENT, ("filling queue in cooked mode"));
 
+	SP->_called_wgetch = TRUE;
 	rc = wgetnstr(win, buf, MAXCOLUMNS);
+	SP->_called_wgetch = FALSE;
 
 	/* ungetch in reverse order */
 #ifdef NCURSES_WGETCH_EVENTS
@@ -265,10 +311,7 @@
 	TR(TRACE_IEVENT, ("delay is %d milliseconds", delay));
 
 	if (head == -1) {	/* fifo is empty */
-	    int rc = _nc_timed_wait(TWAIT_MASK,
-				    delay,
-				    (int *) 0
-				    EVENTLIST_2nd(evl));
+	    int rc = check_mouse_activity(delay EVENTLIST_2nd(evl));
 
 #ifdef NCURSES_WGETCH_EVENTS
 	    if (rc & 4) {
@@ -308,10 +351,8 @@
 		break;
 	} while
 	    (ch == KEY_MOUSE
-	     && (((rc = _nc_timed_wait(TWAIT_MASK,
-				       SP->_maxclick,
-				       (int *) 0
-				       EVENTLIST_2nd(evl))) != 0
+	     && (((rc = check_mouse_activity(SP->_maxclick
+					     EVENTLIST_2nd(evl))) != 0
 		  && !(rc & 4))
 		 || !SP->_mouse_parse(runcount)));
 #ifdef NCURSES_WGETCH_EVENTS
@@ -513,14 +554,11 @@
 	    int rc;
 
 	    TR(TRACE_IEVENT, ("waiting for rest of sequence"));
-	    rc = _nc_timed_wait(TWAIT_MASK,
-				timeleft,
-				&timeleft
-				EVENTLIST_2nd(evl));
+	    rc = check_mouse_activity(timeleft EVENTLIST_2nd(evl));
 #ifdef NCURSES_WGETCH_EVENTS
 	    if (rc & 4) {
 		TR(TRACE_IEVENT, ("interrupted by a user event"));
-		/* FIXME Should have preserved timeleft for reusal... */
+		/* FIXME Should have preserved remainder timeleft for reusal... */
 		peek = head;	/* Restart interpreting later */
 		return KEY_EVENT;
 	    }
Index: ncurses/base/lib_insch.c
Prereq:  1.15 
--- ncurses-5.3-20021012/ncurses/base/lib_insch.c	Sat Jun  9 19:47:38 2001
+++ ncurses-5.3-20030719/ncurses/base/lib_insch.c	Sat Nov 23 16:41:05 2002
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -29,6 +29,8 @@
 /****************************************************************************
  *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
+ *     and: Sven Verdoolaege                                                *
+ *     and: Thomas E. Dickey                                                *
  ****************************************************************************/
 
 /*
@@ -39,29 +41,98 @@
 */
 
 #include <curses.priv.h>
+#include <ctype.h>
 
-MODULE_ID("$Id: lib_insch.c,v 1.15 2001/06/09 23:47:38 skimo Exp $")
+MODULE_ID("$Id: lib_insch.c,v 1.18 2002/11/23 21:41:05 tom Exp $")
+
+/*
+ * Insert the given character, updating the current location to simplify
+ * inserting a string.
+ */
+void
+_nc_insert_ch(WINDOW *win, chtype ch)
+{
+    NCURSES_CH_T wch;
+    int count;
+
+    switch (ch) {
+    case '\t':
+	for (count = (TABSIZE - (win->_curx % TABSIZE)); count > 0; count--)
+	    _nc_insert_ch(win, ' ');
+	break;
+    case '\n':
+    case '\r':
+    case '\b':
+	SetChar2(wch, ch);
+	_nc_waddch_nosync(win, wch);
+	break;
+    default:
+	if (is7bits(ch) && iscntrl(ch)) {
+	    _nc_insert_ch(win, '^');
+	    _nc_insert_ch(win, '@' + (ch));
+	} else if (win->_curx <= win->_maxx) {
+	    struct ldat *line = &(win->_line[win->_cury]);
+	    NCURSES_CH_T *end = &(line->text[win->_curx]);
+	    NCURSES_CH_T *temp1 = &(line->text[win->_maxx]);
+	    NCURSES_CH_T *temp2 = temp1 - 1;
+
+	    SetChar2(wch, ch);
+
+	    CHANGED_TO_EOL(line, win->_curx, win->_maxx);
+	    while (temp1 > end)
+		*temp1-- = *temp2--;
+
+	    *temp1 = _nc_render(win, wch);
+
+	    win->_curx++;
+	}
+	break;
+    }
+}
 
 NCURSES_EXPORT(int)
 winsch(WINDOW *win, chtype c)
 {
+    NCURSES_SIZE_T oy;
+    NCURSES_SIZE_T ox;
     int code = ERR;
 
     T((T_CALLED("winsch(%p, %s)"), win, _tracechtype(c)));
 
-    if (win) {
-	struct ldat *line = &(win->_line[win->_cury]);
-	NCURSES_CH_T *end = &(line->text[win->_curx]);
-	NCURSES_CH_T *temp1 = &(line->text[win->_maxx]);
-	NCURSES_CH_T *temp2 = temp1 - 1;
-	NCURSES_CH_T wch;
-	SetChar2(wch, c);
-
-	CHANGED_TO_EOL(line, win->_curx, win->_maxx);
-	while (temp1 > end)
-	    *temp1-- = *temp2--;
+    if (win != 0) {
+	oy = win->_cury;
+	ox = win->_curx;
+
+	_nc_insert_ch(win, c);
+
+	win->_curx = ox;
+	win->_cury = oy;
+	_nc_synchook(win);
+	code = OK;
+    }
+    returnCode(code);
+}
 
-	*temp1 = _nc_render(win, wch);
+NCURSES_EXPORT(int)
+winsnstr(WINDOW *win, const char *s, int n)
+{
+    int code = ERR;
+    NCURSES_SIZE_T oy;
+    NCURSES_SIZE_T ox;
+    const unsigned char *str = (const unsigned char *) s;
+    const unsigned char *cp;
+
+    T((T_CALLED("winsnstr(%p,%s,%d)"), win, _nc_visbufn(s, n), n));
+
+    if (win != 0 && str != 0) {
+	oy = win->_cury;
+	ox = win->_curx;
+	for (cp = str; *cp && (n <= 0 || (cp - str) < n); cp++) {
+	    _nc_insert_ch(win, (chtype) UChar(*cp));
+	}
+	win->_curx = ox;
+	win->_cury = oy;
+	_nc_synchook(win);
 	code = OK;
     }
     returnCode(code);
Index: ncurses/base/lib_mouse.c
Prereq:  1.61 
--- ncurses-5.3-20021012/ncurses/base/lib_mouse.c	Sat Sep 28 12:08:58 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_mouse.c	Sat May 31 18:18:18 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -29,6 +29,7 @@
 /****************************************************************************
  *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
+ *     and: Thomas E. Dickey 1996-2003                                      *
  ****************************************************************************/
 
 /*
@@ -74,7 +75,11 @@
 #endif
 
 #include <curses.priv.h>
+
+MODULE_ID("$Id: lib_mouse.c,v 1.67 2003/05/31 22:18:18 tom Exp $")
+
 #include <term.h>
+#include <tic.h>
 
 #if USE_GPM_SUPPORT
 #ifndef LINT			/* don't need this for llib-lncurses */
@@ -84,18 +89,33 @@
 #endif
 #endif
 
-MODULE_ID("$Id: lib_mouse.c,v 1.61 2002/09/28 16:08:58 tom Exp $")
+#if USE_SYSMOUSE
+#undef buttons			/* symbol conflict in consio.h */
+#undef mouse_info		/* symbol conflict in consio.h */
+#include <osreldate.h>
+#if (__FreeBSD_version >= 400017)
+#include <sys/consio.h>
+#include <sys/fbio.h>
+#else
+#include <machine/console.h>
+#endif
+#endif /* use_SYSMOUSE */
 
 #define MY_TRACE TRACE_ICALLS|TRACE_IEVENT
 
-#define INVALID_EVENT	-1
+#define	MASK_RELEASE(x)		((001 << (6 * ((x) - 1))))
+#define	MASK_PRESS(x)		((002 << (6 * ((x) - 1))))
+#define	MASK_CLICK(x)		((004 << (6 * ((x) - 1))))
+#define	MASK_DOUBLE_CLICK(x)	((010 << (6 * ((x) - 1))))
+#define	MASK_TRIPLE_CLICK(x)	((020 << (6 * ((x) - 1))))
+#define	MASK_RESERVED_EVENT(x)	((040 << (6 * ((x) - 1))))
+
+#define BUTTON_CLICKED  (BUTTON1_CLICKED  | BUTTON2_CLICKED  | BUTTON3_CLICKED)
+#define BUTTON_PRESSED  (BUTTON1_PRESSED  | BUTTON2_PRESSED  | BUTTON3_PRESSED)
+#define BUTTON_RELEASED (BUTTON1_RELEASED | BUTTON2_RELEASED | BUTTON3_RELEASED)
 
-static int mousetype;
-#define M_XTERM		-1	/* use xterm's mouse tracking? */
-#define M_NONE		0	/* no mouse device */
-#define M_GPM		1	/* use GPM */
-#define M_QNX		2	/* QNX mouse on console */
-#define M_QNX_TERM	3	/* QNX mouse on pterm/xterm (using qansi-m) */
+#define INVALID_EVENT	-1
+#define NORMAL_EVENT	0
 
 #if USE_GPM_SUPPORT
 #ifndef LINT
@@ -117,7 +137,11 @@
  */
 static MEVENT events[EV_MAX];	/* hold the last mouse event seen */
 static MEVENT *eventp = events;	/* next free slot in event queue */
+
+#undef  NEXT
 #define NEXT(ep)	((ep == events + EV_MAX - 1) ? events : ep + 1)
+
+#undef  PREV
 #define PREV(ep)	((ep == events) ? events + EV_MAX - 1 : ep - 1)
 
 #ifdef TRACE
@@ -135,7 +159,7 @@
 }
 #endif
 
-#ifdef USE_EMX_MOUSE
+#if USE_EMX_MOUSE
 
 #  define TOP_ROW          0
 #  define LEFT_COL         0
@@ -229,31 +253,110 @@
     mouse_activated = state;
 }
 
+#endif /* USE_EMX_MOUSE */
+
+#if USE_SYSMOUSE
+static void
+handle_sysmouse(int sig GCC_UNUSED)
+{
+    struct mouse_info the_mouse;
+    MEVENT *work;
+
+    the_mouse.operation = MOUSE_GETINFO;
+    if (SP != 0
+	&& SP->_mouse_fd >= 0
+	&& SP->_sysmouse_tail < FIFO_SIZE
+	&& ioctl(SP->_mouse_fd, CONS_MOUSECTL, &the_mouse) != -1) {
+
+	if (SP->_sysmouse_head > SP->_sysmouse_tail) {
+	    SP->_sysmouse_tail = 0;
+	    SP->_sysmouse_head = 0;
+	}
+	work = &(SP->_sysmouse_fifo[SP->_sysmouse_tail]);
+	memset(work, 0, sizeof(*work));
+	work->id = NORMAL_EVENT;	/* there's only one mouse... */
+
+	SP->_sysmouse_old_buttons = SP->_sysmouse_new_buttons;
+	SP->_sysmouse_new_buttons = the_mouse.u.data.buttons & 0x7;
+
+	if (SP->_sysmouse_new_buttons) {
+	    if (SP->_sysmouse_new_buttons & 1)
+		work->bstate |= BUTTON1_PRESSED;
+	    if (SP->_sysmouse_new_buttons & 2)
+		work->bstate |= BUTTON2_PRESSED;
+	    if (SP->_sysmouse_new_buttons & 4)
+		work->bstate |= BUTTON3_PRESSED;
+	} else {
+	    if (SP->_sysmouse_old_buttons & 1)
+		work->bstate |= BUTTON1_RELEASED;
+	    if (SP->_sysmouse_old_buttons & 2)
+		work->bstate |= BUTTON2_RELEASED;
+	    if (SP->_sysmouse_old_buttons & 4)
+		work->bstate |= BUTTON3_RELEASED;
+	}
+
+	/* for cosmetic bug in syscons.c on FreeBSD 3.[34] */
+	the_mouse.operation = MOUSE_HIDE;
+	ioctl(SP->_mouse_fd, CONS_MOUSECTL, &the_mouse);
+	the_mouse.operation = MOUSE_SHOW;
+	ioctl(SP->_mouse_fd, CONS_MOUSECTL, &the_mouse);
+
+	/*
+	 * We're only interested if the button is pressed or released.
+	 * FIXME: implement continuous event-tracking.
+	 */
+	if (SP->_sysmouse_new_buttons != SP->_sysmouse_old_buttons) {
+	    SP->_sysmouse_tail += 1;
+	}
+	work->x = the_mouse.u.data.x / SP->_sysmouse_char_width;
+	work->y = the_mouse.u.data.y / SP->_sysmouse_char_height;
+    }
+}
 #endif
 
 static int initialized;
 
 static void
+init_xterm_mouse(void)
+{
+    SP->_mouse_type = M_XTERM;
+    SP->_mouse_xtermcap = tigetstr("XM");
+    if (!VALID_STRING(SP->_mouse_xtermcap))
+	SP->_mouse_xtermcap = "\033[?1000%?%p1%{1}%=%th%el%;";
+}
+
+#if !USE_EMX_MOUSE
+static void
+enable_xterm_mouse(int enable)
+{
+    putp(tparm(SP->_mouse_xtermcap, enable));
+}
+#endif /* !USE_EMX_MOUSE */
+
+static void
 initialize_mousetype(void)
 {
     static const char *xterm_kmous = "\033[M";
 
     /* Try gpm first, because gpm may be configured to run in xterm */
 #if USE_GPM_SUPPORT
-    /* GPM: initialize connection to gpm server */
-    gpm_connect.eventMask = GPM_DOWN | GPM_UP;
-    gpm_connect.defaultMask = ~(gpm_connect.eventMask | GPM_HARD);
-    gpm_connect.minMod = 0;
-    gpm_connect.maxMod = ~((1 << KG_SHIFT) | (1 << KG_SHIFTL) | (1 << KG_SHIFTR));
-    if (Gpm_Open(&gpm_connect, 0) >= 0) {	/* returns the file-descriptor */
-	mousetype = M_GPM;
-	SP->_mouse_fd = gpm_fd;
-	return;
+    /* GPM does printf's without checking if stdout is a terminal */
+    if (isatty(fileno(stdout))) {
+	/* GPM: initialize connection to gpm server */
+	gpm_connect.eventMask = GPM_DOWN | GPM_UP;
+	gpm_connect.defaultMask = ~(gpm_connect.eventMask | GPM_HARD);
+	gpm_connect.minMod = 0;
+	gpm_connect.maxMod = ~((1 << KG_SHIFT) | (1 << KG_SHIFTL) | (1 << KG_SHIFTR));
+	if (Gpm_Open(&gpm_connect, 0) >= 0) {	/* returns the file-descriptor */
+	    SP->_mouse_type = M_GPM;
+	    SP->_mouse_fd = gpm_fd;
+	    return;
+	}
     }
 #endif
 
     /* OS/2 VIO */
-#ifdef USE_EMX_MOUSE
+#if USE_EMX_MOUSE
     if (!mouse_thread
 	&& strstr(cur_term->type.term_names, "xterm") == 0
 	&& key_mouse) {
@@ -287,22 +390,87 @@
 		printf("mouse thread error %d=%#x", rc, rc);
 		return;
 	    } else {
-		mousetype = M_XTERM;
+		SP->_mouse_type = M_XTERM;
 		return;
 	    }
 	}
     }
 #endif
 
+#if USE_SYSMOUSE
+    {
+	struct mouse_info the_mouse;
+	char *the_device = 0;
+
+	if (isatty(SP->_ifd))
+	    the_device = ttyname(SP->_ifd);
+	if (the_device == 0)
+	    the_device = "/dev/tty";
+
+	SP->_mouse_fd = open(the_device, O_RDWR);
+
+	if (SP->_mouse_fd >= 0) {
+	    /*
+	     * sysmouse does not have a usable user interface for obtaining
+	     * mouse events.  The logical way to proceed (reading data on a
+	     * stream) only works if one opens the device as root.  Even in
+	     * that mode, careful examination shows we lose events
+	     * occasionally.  The interface provided for user programs is to
+	     * establish a signal handler.  really.
+	     *
+	     * Take over SIGUSR2 for this purpose since SIGUSR1 is more
+	     * likely to be used by an application.  getch() will have to
+	     * handle the misleading EINTR's.
+	     */
+	    signal(SIGUSR2, SIG_IGN);
+	    the_mouse.operation = MOUSE_MODE;
+	    the_mouse.u.mode.mode = 0;
+	    the_mouse.u.mode.signal = SIGUSR2;
+	    if (ioctl(SP->_mouse_fd, CONS_MOUSECTL, &the_mouse) != -1) {
+		signal(SIGUSR2, handle_sysmouse);
+		the_mouse.operation = MOUSE_SHOW;
+		ioctl(SP->_mouse_fd, CONS_MOUSECTL, &the_mouse);
+
+#if defined(FBIO_MODEINFO) || defined(CONS_MODEINFO)	/* FreeBSD > 2.x */
+		{
+#ifndef FBIO_GETMODE		/* FreeBSD 3.x */
+#define FBIO_GETMODE    CONS_GET
+#define FBIO_MODEINFO   CONS_MODEINFO
+#endif /* FBIO_GETMODE */
+		    video_info_t the_video;
+
+		    if (ioctl(SP->_mouse_fd,
+			      FBIO_GETMODE,
+			      &the_video.vi_mode) != -1
+			&& ioctl(SP->_mouse_fd,
+				 FBIO_MODEINFO,
+				 &the_video) != -1) {
+			SP->_sysmouse_char_width = the_video.vi_cwidth;
+			SP->_sysmouse_char_height = the_video.vi_cheight;
+		    }
+		}
+#endif /* defined(FBIO_MODEINFO) || defined(CONS_MODEINFO) */
+
+		if (SP->_sysmouse_char_width <= 0)
+		    SP->_sysmouse_char_width = 8;
+		if (SP->_sysmouse_char_height <= 0)
+		    SP->_sysmouse_char_height = 16;
+		SP->_mouse_type = M_SYSMOUSE;
+		return;
+	    }
+	}
+    }
+#endif /* USE_SYSMOUSE */
+
     /* we know how to recognize mouse events under "xterm" */
     if (key_mouse != 0) {
 	if (!strcmp(key_mouse, xterm_kmous)) {
-	    mousetype = M_XTERM;
+	    init_xterm_mouse();
 	    return;
 	}
     } else if (strstr(cur_term->type.term_names, "xterm") != 0) {
 	(void) _nc_add_to_try(&(SP->_keytry), xterm_kmous, KEY_MOUSE);
-	mousetype = M_XTERM;
+	init_xterm_mouse();
 	return;
     }
 }
@@ -323,7 +491,7 @@
 
 	initialize_mousetype();
 
-	T(("_nc_mouse_init() set mousetype to %d", mousetype));
+	T(("_nc_mouse_init() set mousetype to %d", SP->_mouse_type));
     }
 }
 
@@ -334,74 +502,113 @@
 static bool
 _nc_mouse_event(SCREEN * sp GCC_UNUSED)
 {
-#if USE_GPM_SUPPORT
-    /* GPM: query server for event, return TRUE if we find one */
-    Gpm_Event ev;
-
-    if (Gpm_GetEvent(&ev) == 1) {
-	eventp->id = 0;		/* there's only one mouse... */
+    bool result = FALSE;
 
-	eventp->bstate = 0;
-	switch (ev.type & 0x0f) {
-	case (GPM_DOWN):
-	    if (ev.buttons & GPM_B_LEFT)
-		eventp->bstate |= BUTTON1_PRESSED;
-	    if (ev.buttons & GPM_B_MIDDLE)
-		eventp->bstate |= BUTTON2_PRESSED;
-	    if (ev.buttons & GPM_B_RIGHT)
-		eventp->bstate |= BUTTON3_PRESSED;
-	    break;
-	case (GPM_UP):
-	    if (ev.buttons & GPM_B_LEFT)
-		eventp->bstate |= BUTTON1_RELEASED;
-	    if (ev.buttons & GPM_B_MIDDLE)
-		eventp->bstate |= BUTTON2_RELEASED;
-	    if (ev.buttons & GPM_B_RIGHT)
-		eventp->bstate |= BUTTON3_RELEASED;
-	    break;
-	default:
-	    break;
+    switch (SP->_mouse_type) {
+    case M_XTERM:
+	/* xterm: never have to query, mouse events are in the keyboard stream */
+#if USE_EMX_MOUSE
+	{
+	    char kbuf[3];
+
+	    int i, res = read(M_FD(sp), &kbuf, 3);	/* Eat the prefix */
+	    if (res != 3)
+		printf("Got %d chars instead of 3 for prefix.\n", res);
+	    for (i = 0; i < res; i++) {
+		if (kbuf[i] != key_mouse[i])
+		    printf("Got char %d instead of %d for prefix.\n",
+			   (int) kbuf[i], (int) key_mouse[i]);
+	    }
+	    result = TRUE;
 	}
+#endif /* USE_EMX_MOUSE */
+	break;
+
+#if USE_GPM_SUPPORT
+    case M_GPM:
+	{
+	    /* query server for event, return TRUE if we find one */
+	    Gpm_Event ev;
+
+	    if (Gpm_GetEvent(&ev) == 1) {
+		/* there's only one mouse... */
+		eventp->id = NORMAL_EVENT;
+
+		eventp->bstate = 0;
+		switch (ev.type & 0x0f) {
+		case (GPM_DOWN):
+		    if (ev.buttons & GPM_B_LEFT)
+			eventp->bstate |= BUTTON1_PRESSED;
+		    if (ev.buttons & GPM_B_MIDDLE)
+			eventp->bstate |= BUTTON2_PRESSED;
+		    if (ev.buttons & GPM_B_RIGHT)
+			eventp->bstate |= BUTTON3_PRESSED;
+		    break;
+		case (GPM_UP):
+		    if (ev.buttons & GPM_B_LEFT)
+			eventp->bstate |= BUTTON1_RELEASED;
+		    if (ev.buttons & GPM_B_MIDDLE)
+			eventp->bstate |= BUTTON2_RELEASED;
+		    if (ev.buttons & GPM_B_RIGHT)
+			eventp->bstate |= BUTTON3_RELEASED;
+		    break;
+		default:
+		    break;
+		}
 
-	eventp->x = ev.x - 1;
-	eventp->y = ev.y - 1;
-	eventp->z = 0;
+		eventp->x = ev.x - 1;
+		eventp->y = ev.y - 1;
+		eventp->z = 0;
 
-	/* bump the next-free pointer into the circular list */
-	eventp = NEXT(eventp);
-	return (TRUE);
-    }
+		/* bump the next-free pointer into the circular list */
+		eventp = NEXT(eventp);
+		result = TRUE;
+	    }
+	}
+	break;
 #endif
 
-#ifdef USE_EMX_MOUSE
-    {
-	char kbuf[3];
+#if USE_SYSMOUSE
+    case M_SYSMOUSE:
+	if (SP->_sysmouse_head < SP->_sysmouse_tail) {
+	    *eventp = SP->_sysmouse_fifo[SP->_sysmouse_head];
 
-	int i, res = read(M_FD(sp), &kbuf, 3);	/* Eat the prefix */
-	if (res != 3)
-	    printf("Got %d chars instead of 3 for prefix.\n", res);
-	for (i = 0; i < res; i++) {
-	    if (kbuf[i] != key_mouse[i])
-		printf("Got char %d instead of %d for prefix.\n",
-		       (int) kbuf[i], (int) key_mouse[i]);
+	    /*
+	     * Point the fifo-head to the next possible location.  If there
+	     * are none, reset the indices.  This may be interrupted by the
+	     * signal handler, doing essentially the same reset.
+	     */
+	    SP->_sysmouse_head += 1;
+	    if (SP->_sysmouse_head == SP->_sysmouse_tail) {
+		SP->_sysmouse_tail = 0;
+		SP->_sysmouse_head = 0;
+	    }
+
+	    /* bump the next-free pointer into the circular list */
+	    eventp = NEXT(eventp);
+	    result = TRUE;
 	}
-	return TRUE;
+	break;
+#endif /* USE_SYSMOUSE */
+
+    case M_NONE:
+	break;
     }
-#endif /* USE_EMX_MOUSE */
 
-    /* xterm: never have to query, mouse events are in the keyboard stream */
-    return (FALSE);		/* no event waiting */
+    return result;		/* true if we found an event */
 }
 
 static bool
 _nc_mouse_inline(SCREEN * sp)
 /* mouse report received in the keyboard stream -- parse its info */
 {
+    bool result = FALSE;
+
     TR(MY_TRACE, ("_nc_mouse_inline() called"));
 
-    if (mousetype == M_XTERM) {
+    if (SP->_mouse_type == M_XTERM) {
 	unsigned char kbuf[4];
-	MEVENT *prev;
+	mmask_t prev;
 	size_t grabbed;
 	int res;
 
@@ -438,7 +645,7 @@
 	for (grabbed = 0; grabbed < 3; grabbed += res) {
 
 	    /* For VIO mouse we add extra bit 64 to disambiguate button-up. */
-#ifdef USE_EMX_MOUSE
+#if USE_EMX_MOUSE
 	    res = read(M_FD(sp) >= 0 ? M_FD(sp) : sp->_ifd, &kbuf, 3);
 #else
 	    res = read(sp->_ifd, kbuf + grabbed, 3 - grabbed);
@@ -451,59 +658,65 @@
 	TR(TRACE_IEVENT,
 	   ("_nc_mouse_inline sees the following xterm data: '%s'", kbuf));
 
-	eventp->id = 0;		/* there's only one mouse... */
+	/* there's only one mouse... */
+	eventp->id = NORMAL_EVENT;
 
 	/* processing code goes here */
 	eventp->bstate = 0;
+	prev = PREV(eventp)->bstate;
+
+#if USE_EMX_MOUSE
+#define PRESS_POSITION(n) \
+	eventp->bstate = MASK_PRESS(n); \
+	if (kbuf[0] & 0x40) \
+	    eventp->bstate = MASK_RELEASE(n)
+#else
+#define PRESS_POSITION(n) \
+	eventp->bstate = (prev & MASK_PRESS(n) \
+			? REPORT_MOUSE_POSITION \
+			: MASK_PRESS(n))
+#endif
+
 	switch (kbuf[0] & 0x3) {
 	case 0x0:
-	    eventp->bstate = BUTTON1_PRESSED;
-#ifdef USE_EMX_MOUSE
-	    if (kbuf[0] & 0x40)
-		eventp->bstate = BUTTON1_RELEASED;
-#endif
+	    PRESS_POSITION(1);
 	    break;
 
 	case 0x1:
-	    eventp->bstate = BUTTON2_PRESSED;
-#ifdef USE_EMX_MOUSE
-	    if (kbuf[0] & 0x40)
-		eventp->bstate = BUTTON2_RELEASED;
-#endif
+	    PRESS_POSITION(2);
 	    break;
 
 	case 0x2:
-	    eventp->bstate = BUTTON3_PRESSED;
-#ifdef USE_EMX_MOUSE
-	    if (kbuf[0] & 0x40)
-		eventp->bstate = BUTTON3_RELEASED;
-#endif
+	    PRESS_POSITION(3);
 	    break;
 
 	case 0x3:
 	    /*
-	     * Release events aren't reported for individual buttons,
-	     * just for the button set as a whole...
+	     * Release events aren't reported for individual buttons, just for
+	     * the button set as a whole.  However, because there are normally
+	     * no mouse events under xterm that intervene between press and
+	     * release, we can infer the button actually released by looking at
+	     * the previous event.
 	     */
-	    eventp->bstate =
-		(BUTTON1_RELEASED |
-		 BUTTON2_RELEASED |
-		 BUTTON3_RELEASED);
-	    /*
-	     * ...however, because there are no kinds of mouse events under
-	     * xterm that can intervene between press and release, we can
-	     * deduce which buttons were actually released by looking at the
-	     * previous event.
-	     */
-	    prev = PREV(eventp);
-	    if (!(prev->bstate & BUTTON1_PRESSED))
-		eventp->bstate &= ~BUTTON1_RELEASED;
-	    if (!(prev->bstate & BUTTON2_PRESSED))
-		eventp->bstate &= ~BUTTON2_RELEASED;
-	    if (!(prev->bstate & BUTTON3_PRESSED))
-		eventp->bstate &= ~BUTTON3_RELEASED;
+	    if (prev & (BUTTON_PRESSED | BUTTON_RELEASED)) {
+		eventp->bstate = BUTTON_RELEASED;
+		if (!(prev & BUTTON1_PRESSED))
+		    eventp->bstate &= ~BUTTON1_RELEASED;
+		if (!(prev & BUTTON2_PRESSED))
+		    eventp->bstate &= ~BUTTON2_RELEASED;
+		if (!(prev & BUTTON3_PRESSED))
+		    eventp->bstate &= ~BUTTON3_RELEASED;
+	    } else {
+		/*
+		 * XFree86 xterm will return a stream of release-events to
+		 * let the application know where the mouse is going, if the
+		 * private mode 1002 or 1003 is enabled.
+		 */
+		eventp->bstate = REPORT_MOUSE_POSITION;
+	    }
 	    break;
 	}
+	result = (eventp->bstate & REPORT_MOUSE_POSITION) ? TRUE : FALSE;
 
 	if (kbuf[0] & 4) {
 	    eventp->bstate |= BUTTON_SHIFT;
@@ -529,7 +742,7 @@
 #endif
     }
 
-    return (FALSE);
+    return (result);
 }
 
 static void
@@ -542,16 +755,16 @@
 
     if (on) {
 
-	switch (mousetype) {
+	switch (SP->_mouse_type) {
 	case M_XTERM:
 #if NCURSES_EXT_FUNCS
 	    keyok(KEY_MOUSE, on);
 #endif
 	    TPUTS_TRACE("xterm mouse initialization");
-#ifdef USE_EMX_MOUSE
+#if USE_EMX_MOUSE
 	    server_state(1);
 #else
-	    putp("\033[?1000h");
+	    enable_xterm_mouse(1);
 #endif
 	    break;
 #if USE_GPM_SUPPORT
@@ -559,6 +772,13 @@
 	    SP->_mouse_fd = gpm_fd;
 	    break;
 #endif
+#if USE_SYSMOUSE
+	case M_SYSMOUSE:
+	    signal(SIGUSR2, handle_sysmouse);
+	    break;
+#endif
+	case M_NONE:
+	    return;
 	}
 	/* Make runtime binding to cut down on object size of applications that
 	 * do not use the mouse (e.g., 'clear').
@@ -571,19 +791,26 @@
 
     } else {
 
-	switch (mousetype) {
+	switch (SP->_mouse_type) {
 	case M_XTERM:
 	    TPUTS_TRACE("xterm mouse deinitialization");
-#ifdef USE_EMX_MOUSE
+#if USE_EMX_MOUSE
 	    server_state(0);
 #else
-	    putp("\033[?1000l");
+	    enable_xterm_mouse(0);
 #endif
 	    break;
 #if USE_GPM_SUPPORT
 	case M_GPM:
 	    break;
 #endif
+#if USE_SYSMOUSE
+	case M_SYSMOUSE:
+	    signal(SIGUSR2, SIG_IGN);
+	    break;
+#endif
+	case M_NONE:
+	    return;
 	}
     }
     _nc_flush();
@@ -631,7 +858,7 @@
 	   ("_nc_mouse_parse: returning simple mouse event %s at slot %ld",
 	    _tracemouse(prev),
 	    (long) (prev - events)));
-	return (prev->id >= 0)
+	return (prev->id >= NORMAL_EVENT)
 	    ? ((prev->bstate & eventmask) ? TRUE : FALSE)
 	    : FALSE;
     }
@@ -657,7 +884,7 @@
 	merge = FALSE;
 	for (ep = runp; (next = NEXT(ep)) != eventp; ep = next) {
 	    if (ep->x == next->x && ep->y == next->y
-		&& (ep->bstate & (BUTTON1_PRESSED | BUTTON2_PRESSED | BUTTON3_PRESSED))
+		&& (ep->bstate & BUTTON_PRESSED)
 		&& (!(ep->bstate & BUTTON1_PRESSED)
 		    == !(next->bstate & BUTTON1_RELEASED))
 		&& (!(ep->bstate & BUTTON2_PRESSED)
@@ -729,10 +956,8 @@
 		    continue;
 
 		/* merge click events forward */
-		if ((ep->bstate &
-		     (BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED))
-		    && (follower->bstate &
-			(BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED))) {
+		if ((ep->bstate & BUTTON_CLICKED)
+		    && (follower->bstate & BUTTON_CLICKED)) {
 		    if ((eventmask & BUTTON1_DOUBLE_CLICKED)
 			&& (follower->bstate & BUTTON1_CLICKED)) {
 			follower->bstate &= ~BUTTON1_CLICKED;
@@ -760,8 +985,7 @@
 		     (BUTTON1_DOUBLE_CLICKED
 		      | BUTTON2_DOUBLE_CLICKED
 		      | BUTTON3_DOUBLE_CLICKED))
-		    && (follower->bstate &
-			(BUTTON1_CLICKED | BUTTON2_CLICKED | BUTTON3_CLICKED))) {
+		    && (follower->bstate & BUTTON_CLICKED)) {
 		    if ((eventmask & BUTTON1_TRIPLE_CLICKED)
 			&& (follower->bstate & BUTTON1_CLICKED)) {
 			follower->bstate &= ~BUTTON1_CLICKED;
@@ -831,7 +1055,7 @@
 {
     TR(MY_TRACE, ("_nc_mouse_wrap() called"));
 
-    switch (mousetype) {
+    switch (SP->_mouse_type) {
     case M_XTERM:
 	if (eventmask)
 	    mouse_activate(FALSE);
@@ -841,6 +1065,13 @@
     case M_GPM:
 	break;
 #endif
+#if USE_SYSMOUSE
+    case M_SYSMOUSE:
+	mouse_activate(FALSE);
+	break;
+#endif
+    case M_NONE:
+	break;
     }
 }
 
@@ -850,11 +1081,27 @@
 {
     TR(MY_TRACE, ("_nc_mouse_resume() called"));
 
-    /* xterm: re-enable reporting */
-    if (mousetype == M_XTERM && eventmask)
-	mouse_activate(TRUE);
+    switch (SP->_mouse_type) {
+    case M_XTERM:
+	/* xterm: re-enable reporting */
+	if (eventmask)
+	    mouse_activate(TRUE);
+	break;
 
-    /* GPM: reclaim our event set */
+#if USE_GPM_SUPPORT
+    case M_GPM:
+	/* GPM: reclaim our event set */
+	break;
+#endif
+
+#if USE_SYSMOUSE
+    case M_SYSMOUSE:
+	mouse_activate(TRUE);
+	break;
+#endif
+    case M_NONE:
+	break;
+    }
 }
 
 /**************************************************************************
@@ -869,7 +1116,7 @@
 {
     T((T_CALLED("getmouse(%p)"), aevent));
 
-    if (aevent && (mousetype != M_NONE)) {
+    if (aevent && (SP->_mouse_type != M_NONE)) {
 	/* compute the current-event pointer */
 	MEVENT *prev = PREV(eventp);
 
@@ -917,14 +1164,14 @@
 	returnBits(0);
 
     _nc_mouse_init();
-    if (mousetype != M_NONE) {
+    if (SP->_mouse_type != M_NONE) {
 	eventmask = newmask &
-	    (BUTTON_ALT | BUTTON_CTRL | BUTTON_SHIFT
-	     | BUTTON1_PRESSED | BUTTON1_RELEASED | BUTTON1_CLICKED
+	    (REPORT_MOUSE_POSITION | BUTTON_ALT | BUTTON_CTRL | BUTTON_SHIFT
+	     | BUTTON_PRESSED
+	     | BUTTON_RELEASED
+	     | BUTTON_CLICKED
 	     | BUTTON1_DOUBLE_CLICKED | BUTTON1_TRIPLE_CLICKED
-	     | BUTTON2_PRESSED | BUTTON2_RELEASED | BUTTON2_CLICKED
 	     | BUTTON2_DOUBLE_CLICKED | BUTTON2_TRIPLE_CLICKED
-	     | BUTTON3_PRESSED | BUTTON3_RELEASED | BUTTON3_CLICKED
 	     | BUTTON3_DOUBLE_CLICKED | BUTTON3_TRIPLE_CLICKED);
 
 	mouse_activate(eventmask != 0);
@@ -977,7 +1224,7 @@
 NCURSES_EXPORT(int)
 _nc_has_mouse(void)
 {
-    return (mousetype == M_NONE ? 0 : 1);
+    return (SP->_mouse_type == M_NONE ? 0 : 1);
 }
 
 NCURSES_EXPORT(bool)
@@ -1010,5 +1257,3 @@
     }
     returnBool(result);
 }
-
-/* lib_mouse.c ends here */
Index: ncurses/base/lib_newterm.c
Prereq:  1.56 
--- ncurses-5.3-20021012/ncurses/base/lib_newterm.c	Sat Oct 12 11:24:08 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_newterm.c	Sat Oct 19 20:10:56 2002
@@ -47,7 +47,7 @@
 #include <term.h>		/* clear_screen, cup & friends, cur_term */
 #include <tic.h>
 
-MODULE_ID("$Id: lib_newterm.c,v 1.56 2002/10/12 15:24:08 tom Exp $")
+MODULE_ID("$Id: lib_newterm.c,v 1.57 2002/10/20 00:10:56 Philippe.Blain Exp $")
 
 #ifndef ONLCR			/* Allows compilation under the QNX 4.2 OS */
 #define ONLCR 0
@@ -118,13 +118,6 @@
     /* implement filter mode */
     if (filter_mode) {
 	LINES = 1;
-
-	if (VALID_NUMERIC(init_tabs))
-	    TABSIZE = init_tabs;
-	else
-	    TABSIZE = 8;
-
-	T(("TABSIZE = %d", TABSIZE));
 
 	clear_screen = 0;
 	cursor_down = parm_down_cursor = 0;
Index: ncurses/base/lib_printw.c
Prereq:  1.13 
--- ncurses-5.3-20021012/ncurses/base/lib_printw.c	Sat Oct  5 18:52:21 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_printw.c	Sat Feb  8 15:50:13 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -39,10 +39,10 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_printw.c,v 1.13 2002/10/05 22:52:21 tom Exp $")
+MODULE_ID("$Id: lib_printw.c,v 1.15 2003/02/08 20:50:13 tom Exp $")
 
 NCURSES_EXPORT(int)
-printw(NCURSES_CONST char *fmt,...)
+printw(const char *fmt,...)
 {
     va_list argp;
     int code;
@@ -62,7 +62,7 @@
 }
 
 NCURSES_EXPORT(int)
-wprintw(WINDOW *win, NCURSES_CONST char *fmt,...)
+wprintw(WINDOW *win, const char *fmt,...)
 {
     va_list argp;
     int code;
@@ -82,7 +82,7 @@
 }
 
 NCURSES_EXPORT(int)
-mvprintw(int y, int x, NCURSES_CONST char *fmt,...)
+mvprintw(int y, int x, const char *fmt,...)
 {
     va_list argp;
     int code;
@@ -103,7 +103,7 @@
 }
 
 NCURSES_EXPORT(int)
-mvwprintw(WINDOW *win, int y, int x, NCURSES_CONST char *fmt,...)
+mvwprintw(WINDOW *win, int y, int x, const char *fmt,...)
 {
     va_list argp;
     int code;
@@ -124,7 +124,7 @@
 }
 
 NCURSES_EXPORT(int)
-vwprintw(WINDOW *win, NCURSES_CONST char *fmt, va_list argp)
+vwprintw(WINDOW *win, const char *fmt, va_list argp)
 {
     char *buf;
     int code = ERR;
@@ -134,9 +134,6 @@
 
     if ((buf = _nc_printf_string(fmt, argp)) != 0) {
 	code = waddstr(win, buf);
-#if USE_SAFE_SPRINTF
-	free(buf);
-#endif
     }
     returnCode(code);
 }
Index: ncurses/base/lib_set_term.c
Prereq:  1.71 
--- ncurses-5.3-20021012/ncurses/base/lib_set_term.c	Sat Sep 14 18:48:00 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_set_term.c	Sat May 17 15:43:46 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -43,7 +43,7 @@
 #include <term.h>		/* cur_term */
 #include <tic.h>
 
-MODULE_ID("$Id: lib_set_term.c,v 1.71 2002/09/14 22:48:00 tom Exp $")
+MODULE_ID("$Id: lib_set_term.c,v 1.77 2003/05/17 19:43:46 tom Exp $")
 
 NCURSES_EXPORT(SCREEN *)
 set_term(SCREEN * screenp)
@@ -61,7 +61,6 @@
     stdscr = SP->_stdscr;
     COLORS = SP->_color_count;
     COLOR_PAIRS = SP->_pair_count;
-    memcpy(acs_map, SP->_acs_map, sizeof(SP->_acs_map[0]) * ACS_LEN);
 
     T((T_RETURN("%p"), oldSP));
     return (oldSP);
@@ -101,7 +100,6 @@
 
     if (sp->_slk != 0) {
 	FreeIfNeeded(sp->_slk->ent);
-	FreeIfNeeded(sp->_slk->buffer);
 	free(sp->_slk);
 	sp->_slk = 0;
     }
@@ -204,7 +202,7 @@
 #endif
 
 NCURSES_EXPORT(int)
-_nc_setupscreen(short slines, short const scolumns, FILE * output)
+_nc_setupscreen(short slines, short const scolumns, FILE *output)
 /* OS-independent screen initializations */
 {
     int bottom_stolen = 0;
@@ -377,8 +375,15 @@
     _nc_init_acs();
 #if USE_WIDEC_SUPPORT
     _nc_init_wacs();
+
+    SP->_screen_acs_fix = (_nc_unicode_locale() && _nc_locale_breaks_acs());
+    {
+	char *env = _nc_get_locale();
+	SP->_posix_locale = ((env == 0)
+			     || !strcmp(env, "C")
+			     || !strcmp(env, "POSIX"));
+    }
 #endif
-    memcpy(SP->_acs_map, acs_map, sizeof(chtype) * ACS_LEN);
 
     _nc_idcok = TRUE;
     _nc_idlok = FALSE;
Index: ncurses/base/lib_slk.c
Prereq:  1.24 
--- ncurses-5.3-20021012/ncurses/base/lib_slk.c	Sat Sep 28 13:46:40 2002
+++ ncurses-5.3-20030719/ncurses/base/lib_slk.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2000,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -41,7 +41,7 @@
 #include <ctype.h>
 #include <term.h>		/* num_labels, label_*, plab_norm */
 
-MODULE_ID("$Id: lib_slk.c,v 1.24 2002/09/28 17:46:40 tom Exp $")
+MODULE_ID("$Id: lib_slk.c,v 1.28 2003/05/24 21:10:28 tom Exp $")
 
 /*
  * We'd like to move these into the screen context structure, but cannot,
@@ -64,12 +64,26 @@
 	wmove(win, 0, 0);
 
 	for (i = 0; i < SP->_slk->maxlab; i++) {
-	    mvwprintw(win, 0, SP->_slk->ent[i].x, "F%d", i + 1);
+	    mvwprintw(win, 0, SP->_slk->ent[i].ent_x, "F%d", i + 1);
 	}
     }
 }
 
 /*
+ * Free any memory related to soft labels, return an error.
+ */
+static int
+slk_failed(void)
+{
+    if (SP->_slk) {
+	FreeIfNeeded(SP->_slk->ent);
+	free(SP->_slk);
+	SP->_slk = (SLK *) 0;
+    }
+    return ERR;
+}
+
+/*
  * Initialize soft labels.
  * Called from newterm()
  */
@@ -78,19 +92,26 @@
 {
     int i, x;
     int res = OK;
-    char *p;
     unsigned max_length;
 
-    T(("slk_initialize()"));
+    T((T_CALLED("_nc_slk_initialize()")));
 
     if (SP->_slk) {		/* we did this already, so simply return */
-	return (OK);
+	returnCode(OK);
     } else if ((SP->_slk = typeCalloc(SLK, 1)) == 0)
-	return (ERR);
+	returnCode(ERR);
 
     SP->_slk->ent = NULL;
-    SP->_slk->buffer = NULL;
-    SP->_slk->attr = A_STANDOUT;
+
+    /*
+     * If we use colors, vidputs() will suppress video attributes that conflict
+     * with colors.  In that case, we're still guaranteed that "reverse" would
+     * work.
+     */
+    if ((no_color_video & 1) == 0)
+	SP->_slk->attr = A_STANDOUT;
+    else
+	SP->_slk->attr = A_REVERSE;
 
     SP->_slk->maxlab = ((num_labels > 0)
 			? num_labels
@@ -106,19 +127,19 @@
 	|| SP->_slk->labcnt <= 0
 	|| (SP->_slk->ent = typeCalloc(slk_ent,
 				       (unsigned) SP->_slk->labcnt)) == NULL)
-	goto exception;
+	returnCode(slk_failed());
 
     max_length = SP->_slk->maxlen;
-    p = SP->_slk->buffer = (char *) calloc((unsigned) (2 * SP->_slk->labcnt),
-					   (1 + max_length));
-    if (SP->_slk->buffer == NULL)
-	goto exception;
-
     for (i = 0; i < SP->_slk->labcnt; i++) {
-	SP->_slk->ent[i].text = p;
-	p += (1 + max_length);
-	SP->_slk->ent[i].form_text = p;
-	p += (1 + max_length);
+
+	if ((SP->_slk->ent[i].ent_text = (char *)_nc_doalloc(0, max_length + 1)) == 0)
+	    returnCode(slk_failed());
+	memset(SP->_slk->ent[i].ent_text, 0, max_length + 1);
+
+	if ((SP->_slk->ent[i].form_text = (char *)_nc_doalloc(0, max_length + 1)) == 0)
+	    returnCode(slk_failed());
+	memset(SP->_slk->ent[i].form_text, 0, max_length + 1);
+
 	memset(SP->_slk->ent[i].form_text, ' ', max_length);
 	SP->_slk->ent[i].visible = (i < SP->_slk->maxlab);
     }
@@ -129,7 +150,7 @@
 	    gap = 1;
 
 	for (i = x = 0; i < SP->_slk->maxlab; i++) {
-	    SP->_slk->ent[i].x = x;
+	    SP->_slk->ent[i].ent_x = x;
 	    x += max_length;
 	    x += (i == 3 || i == 7) ? gap : 1;
 	}
@@ -141,7 +162,7 @@
 	    if (gap < 1)
 		gap = 1;
 	    for (i = x = 0; i < SP->_slk->maxlab; i++) {
-		SP->_slk->ent[i].x = x;
+		SP->_slk->ent[i].ent_x = x;
 		x += max_length;
 		x += (i == 3) ? gap : 1;
 	    }
@@ -153,24 +174,17 @@
 		if (gap < 1)
 		    gap = 1;
 		for (i = x = 0; i < SP->_slk->maxlab; i++) {
-		    SP->_slk->ent[i].x = x;
+		    SP->_slk->ent[i].ent_x = x;
 		    x += max_length;
 		    x += (i == 2 || i == 4) ? gap : 1;
 		}
 	    } else
-		goto exception;
+		returnCode(slk_failed());
 	}
     }
     SP->_slk->dirty = TRUE;
     if ((SP->_slk->win = stwin) == NULL) {
-      exception:
-	if (SP->_slk) {
-	    FreeIfNeeded(SP->_slk->buffer);
-	    FreeIfNeeded(SP->_slk->ent);
-	    free(SP->_slk);
-	    SP->_slk = (SLK *) 0;
-	    res = (ERR);
-	}
+	returnCode(slk_failed());
     }
 
     /* We now reset the format so that the next newterm has again
@@ -179,7 +193,7 @@
      */
     SP->slk_format = _nc_slk_format;
     _nc_slk_format = 0;
-    return (res);
+    returnCode(res);
 }
 
 /*
Index: ncurses/base/lib_slklab.c
Prereq:  1.6 
--- ncurses-5.3-20021012/ncurses/base/lib_slklab.c	Sat Dec  9 21:43:27 2000
+++ ncurses-5.3-20030719/ncurses/base/lib_slklab.c	Sat Mar 29 17:53:48 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -38,7 +38,7 @@
  */
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_slklab.c,v 1.6 2000/12/10 02:43:27 tom Exp $")
+MODULE_ID("$Id: lib_slklab.c,v 1.7 2003/03/29 22:53:48 tom Exp $")
 
 NCURSES_EXPORT(char *)
 slk_label(int n)
@@ -47,5 +47,5 @@
 
     if (SP == NULL || SP->_slk == NULL || n < 1 || n > SP->_slk->labcnt)
 	returnPtr(0);
-    returnPtr(SP->_slk->ent[n - 1].text);
+    returnPtr(SP->_slk->ent[n - 1].ent_text);
 }
Index: ncurses/base/lib_slkrefr.c
Prereq:  1.10 
--- ncurses-5.3-20021012/ncurses/base/lib_slkrefr.c	Sat Dec  9 21:43:27 2000
+++ ncurses-5.3-20030719/ncurses/base/lib_slkrefr.c	Sat Mar 29 17:53:48 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000 Free Software Foundation, Inc.                   *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -38,7 +38,7 @@
 #include <curses.priv.h>
 #include <term.h>		/* num_labels, label_*, plab_norm */
 
-MODULE_ID("$Id: lib_slkrefr.c,v 1.10 2000/12/10 02:43:27 tom Exp $")
+MODULE_ID("$Id: lib_slkrefr.c,v 1.11 2003/03/29 22:53:48 tom Exp $")
 
 /*
  * Write the soft labels to the soft-key window.
@@ -58,7 +58,7 @@
 			putp(tparm(plab_norm, i + 1, slk->ent[i].form_text));
 		    }
 		} else {
-		    wmove(slk->win, SLK_LINES(fmt) - 1, slk->ent[i].x);
+		    wmove(slk->win, SLK_LINES(fmt) - 1, slk->ent[i].ent_x);
 		    if (SP && SP->_slk)
 			wattrset(slk->win, SP->_slk->attr);
 		    waddnstr(slk->win, slk->ent[i].form_text,
Index: ncurses/base/lib_slkset.c
Prereq:  1.7 
--- ncurses-5.3-20021012/ncurses/base/lib_slkset.c	Sat Jun  2 18:50:29 2001
+++ ncurses-5.3-20030719/ncurses/base/lib_slkset.c	Sat Apr 12 17:32:16 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -38,13 +38,14 @@
 #include <curses.priv.h>
 #include <ctype.h>
 
-MODULE_ID("$Id: lib_slkset.c,v 1.7 2001/06/02 22:50:29 skimo Exp $")
+MODULE_ID("$Id: lib_slkset.c,v 1.10 2003/04/12 21:32:16 tom Exp $")
 
 NCURSES_EXPORT(int)
 slk_set(int i, const char *astr, int format)
 {
     SLK *slk = SP->_slk;
     size_t len;
+    int offset;
     const char *str = astr;
     const char *p;
 
@@ -64,33 +65,30 @@
     --i;			/* Adjust numbering of labels */
 
     len = (size_t) (p - str);
-    if (len > (unsigned) slk->maxlen)
+    if (len > (size_t) slk->maxlen)
 	len = slk->maxlen;
     if (len == 0)
-	slk->ent[i].text[0] = 0;
+	slk->ent[i].ent_text[0] = 0;
     else
-	(void) strncpy(slk->ent[i].text, str, len);
+	strncpy(slk->ent[i].ent_text, str, len)[len] = 0;
     memset(slk->ent[i].form_text, ' ', (unsigned) slk->maxlen);
-    slk->ent[i].text[slk->maxlen] = 0;
-    /* len = strlen(slk->ent[i].text); */
+    slk->ent[i].ent_text[slk->maxlen] = 0;
 
     switch (format) {
+    default:
     case 0:			/* left-justified */
-	memcpy(slk->ent[i].form_text,
-	       slk->ent[i].text,
-	       len);
+	offset = 0;
 	break;
     case 1:			/* centered */
-	memcpy(slk->ent[i].form_text + (slk->maxlen - len) / 2,
-	       slk->ent[i].text,
-	       len);
+	offset = (slk->maxlen - len) / 2;
 	break;
     case 2:			/* right-justified */
-	memcpy(slk->ent[i].form_text + slk->maxlen - len,
-	       slk->ent[i].text,
-	       len);
+	offset = slk->maxlen - len;
 	break;
     }
+    memcpy(slk->ent[i].form_text + offset,
+	   slk->ent[i].ent_text,
+	   len);
     slk->ent[i].form_text[slk->maxlen] = 0;
     slk->ent[i].dirty = TRUE;
     returnCode(OK);
Index: ncurses/base/resizeterm.c
Prereq:  1.14 
--- ncurses-5.3-20021012/ncurses/base/resizeterm.c	Sat Jul 13 17:32:57 2002
+++ ncurses-5.3-20030719/ncurses/base/resizeterm.c	Fri Dec 27 20:21:34 2002
@@ -41,10 +41,13 @@
 #include <curses.priv.h>
 #include <term.h>
 
-MODULE_ID("$Id: resizeterm.c,v 1.14 2002/07/13 21:32:57 tom Exp $")
+MODULE_ID("$Id: resizeterm.c,v 1.15 2002/12/28 01:21:34 tom Exp $")
 
 #define stolen_lines (screen_lines - SP->_lines_avail)
 
+static int current_lines;
+static int current_cols;
+
 NCURSES_EXPORT(bool)
 is_term_resized(int ToLines, int ToCols)
 {
@@ -99,7 +102,7 @@
 adjust_window(WINDOW *win, int ToLines, int ToCols, int stolen)
 {
     int result;
-    int bottom = screen_lines + SP->_topstolen - stolen;
+    int bottom = current_lines + SP->_topstolen - stolen;
     int myLines = win->_maxy + 1;
     int myCols = win->_maxx + 1;
 
@@ -109,13 +112,13 @@
        getbegy(win), getbegx(win)));
 
     if (win->_begy >= bottom) {
-	win->_begy += (ToLines - screen_lines);
+	win->_begy += (ToLines - current_lines);
     } else {
-	if (myLines == screen_lines - stolen
-	    && ToLines != screen_lines)
+	if (myLines == current_lines - stolen
+	    && ToLines != current_lines)
 	    myLines = ToLines - stolen;
-	else if (myLines == screen_lines
-		 && ToLines != screen_lines)
+	else if (myLines == current_lines
+		 && ToLines != current_lines)
 	    myLines = ToLines;
     }
 
@@ -125,12 +128,12 @@
     if (myCols > ToCols)
 	myCols = ToCols;
 
-    if (myLines == screen_lines
-	&& ToLines != screen_lines)
-	myCols = ToLines;
+    if (myLines == current_lines
+	&& ToLines != current_lines)
+	myLines = ToLines;
 
-    if (myCols == screen_columns
-	&& ToCols != screen_columns)
+    if (myCols == current_cols
+	&& ToCols != current_cols)
 	myCols = ToCols;
 
     result = wresize(win, myLines, myCols);
@@ -216,15 +219,19 @@
        screen_lines, screen_columns));
 
     if (is_term_resized(ToLines, ToCols)) {
-	int myLines = screen_lines;
-	int myCols = screen_columns;
+	int myLines = current_lines = screen_lines;
+	int myCols = current_cols = screen_columns;
 
 	if (ToLines > screen_lines) {
 	    increase_size(myLines = ToLines, myCols, was_stolen);
+	    current_lines = myLines;
+	    current_cols = myCols;
 	}
 
 	if (ToCols > screen_columns) {
 	    increase_size(myLines, myCols = ToCols, was_stolen);
+	    current_lines = myLines;
+	    current_cols = myCols;
 	}
 
 	if (ToLines < myLines ||
Index: ncurses/base/safe_sprintf.c
Prereq:  1.14 
--- ncurses-5.3-20021012/ncurses/base/safe_sprintf.c	Sat Jul  7 20:58:34 2001
+++ ncurses-5.3-20030719/ncurses/base/safe_sprintf.c	Sat Feb  8 19:40:33 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,1999,2000 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -33,7 +33,7 @@
 #include <curses.priv.h>
 #include <ctype.h>
 
-MODULE_ID("$Id: safe_sprintf.c,v 1.14 2001/07/08 00:58:34 tom Exp $")
+MODULE_ID("$Id: safe_sprintf.c,v 1.15 2003/02/09 00:40:33 tom Exp $")
 
 #if USE_SAFE_SPRINTF
 
@@ -203,42 +203,48 @@
  * Wrapper for vsprintf that allocates a buffer big enough to hold the result.
  */
 NCURSES_EXPORT(char *)
-_nc_printf_string
-(const char *fmt, va_list ap)
+_nc_printf_string(const char *fmt, va_list ap)
 {
+    static char *buf;
+    static size_t used;
+
+    if (fmt != 0) {
 #if USE_SAFE_SPRINTF
-    char *buf = 0;
-    int len = _nc_printf_length(fmt, ap);
+	int len = _nc_printf_length(fmt, ap);
 
-    if (len > 0) {
-	if ((buf = typeMalloc(char, len + 1)) == 0)
-	      return (0);
-	vsprintf(buf, fmt, ap);
-    }
+	if (len > 0) {
+	    if ((int)used < len + 1) {
+		used = len + 1;
+		buf = typeRealloc(char, used, buf);
+	    }
+	    if (buf != 0) {
+		vsprintf(buf, fmt, ap);
+	    }
+	}
 #else
-    static int rows, cols;
-    static char *buf;
-    static size_t len;
+	static int rows, cols;
 
-    if (screen_lines > rows || screen_columns > cols) {
-	if (screen_lines > rows)
-	    rows = screen_lines;
-	if (screen_columns > cols)
-	    cols = screen_columns;
-	len = (rows * (cols + 1)) + 1;
-	buf = typeRealloc(char, len, buf);
-	if (buf == 0) {
-	    return (0);
+	if (screen_lines > rows || screen_columns > cols) {
+	    if (screen_lines > rows)
+		rows = screen_lines;
+	    if (screen_columns > cols)
+		cols = screen_columns;
+	    used = (rows * (cols + 1)) + 1;
+	    buf = typeRealloc(char, used, buf);
 	}
-    }
 
-    if (buf != 0) {
+	if (buf != 0) {
 # if HAVE_VSNPRINTF
-	vsnprintf(buf, len, fmt, ap);	/* GNU extension */
+	    vsnprintf(buf, used, fmt, ap);	/* GNU extension */
 # else
-	vsprintf(buf, fmt, ap);	/* ANSI */
+	    vsprintf(buf, fmt, ap);	/* ANSI */
 # endif
-    }
+	}
 #endif
+    } else if (buf != 0) {
+	free(buf);
+	buf = 0;
+	used = 0;
+    }
     return buf;
 }
Index: ncurses/base/tries.c
Prereq:  1.15 
--- ncurses-5.3-20021012/ncurses/base/tries.c	Sat Dec 15 19:50:40 2001
+++ ncurses-5.3-20030719/ncurses/base/tries.c	Sat May 17 19:11:24 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2001,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -39,15 +39,14 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: tries.c,v 1.15 2001/12/16 00:50:40 tom Exp $")
+MODULE_ID("$Id: tries.c,v 1.19 2003/05/17 23:11:24 tom Exp $")
 
 /*
  * Expand a keycode into the string that it corresponds to, returning null if
  * no match was found, otherwise allocating a string of the result.
  */
 NCURSES_EXPORT(char *)
-_nc_expand_try
-(struct tries *tree, unsigned short code, int *count, size_t len)
+_nc_expand_try(struct tries *tree, unsigned short code, int *count, size_t len)
 {
     struct tries *ptr = tree;
     char *result = 0;
@@ -84,8 +83,7 @@
  * true if the code was found/removed.
  */
 NCURSES_EXPORT(int)
-_nc_remove_key
-(struct tries **tree, unsigned short code)
+_nc_remove_key(struct tries **tree, unsigned short code)
 {
     T((T_CALLED("_nc_remove_key(%p,%d)"), tree, code));
 
@@ -117,7 +115,7 @@
  * true if the string was found/removed.
  */
 NCURSES_EXPORT(int)
-_nc_remove_string(struct tries **tree, char *string)
+_nc_remove_string(struct tries **tree, const char *string)
 {
     T((T_CALLED("_nc_remove_string(%p,%s)"), tree, _nc_visbuf(string)));
 
@@ -125,18 +123,17 @@
 	returnCode(FALSE);
 
     while (*tree != 0) {
-	if ((unsigned char) (*tree)->ch == (unsigned char) *string) {
+	if (UChar((*tree)->ch) == UChar(*string)) {
 	    if (string[1] != 0)
 		returnCode(_nc_remove_string(&(*tree)->child, string + 1));
-	    if ((*tree)->child) {
-		/* don't cut the whole sub-tree */
-		(*tree)->value = 0;
-	    } else {
+	    if ((*tree)->child == 0) {
 		struct tries *to_free = *tree;
 		*tree = (*tree)->sibling;
 		free(to_free);
+		returnCode(TRUE);
+	    } else {
+		returnCode(FALSE);
 	    }
-	    returnCode(TRUE);
 	}
 	tree = &(*tree)->sibling;
     }
Index: ncurses/base/vsscanf.c
Prereq:  1.16 
--- ncurses-5.3-20021012/ncurses/base/vsscanf.c	Sat Sep  7 13:27:56 2002
+++ ncurses-5.3-20030719/ncurses/base/vsscanf.c	Sat May 24 17:10:28 2003
@@ -38,7 +38,7 @@
 
 #if !HAVE_VSSCANF
 
-MODULE_ID("$Id: vsscanf.c,v 1.16 2002/09/07 17:27:56 tom Exp $")
+MODULE_ID("$Id: vsscanf.c,v 1.17 2003/05/24 21:10:28 tom Exp $")
 
 #if !(HAVE_VFSCANF || HAVE__DOSCAN)
 
@@ -230,7 +230,7 @@
 		/* find a chunk */
 		state = sUnknown;
 		chunk = cUnknown;
-		other = cUnknown;
+		other = oUnknown;
 		pointer = 0;
 		for (n = 0; format[n] != 0 && state != sFinal; ++n) {
 		    my_fmt[n] = format[n];
Index: ncurses/curses.priv.h
Prereq:  1.228 
--- ncurses-5.3-20021012/ncurses/curses.priv.h	Sat Oct 12 11:49:10 2002
+++ ncurses-5.3-20030719/ncurses/curses.priv.h	Sat Jul  5 12:50:00 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -34,7 +34,7 @@
 
 
 /*
- * $Id: curses.priv.h,v 1.228 2002/10/12 15:49:10 tom Exp $
+ * $Id: curses.priv.h,v 1.249 2003/07/05 16:50:00 tom Exp $
  *
  *	curses.priv.h
  *
@@ -130,7 +130,9 @@
 
 /* EMX mouse support */
 #ifdef __EMX__
-#define USE_EMX_MOUSE
+#define USE_EMX_MOUSE 1
+#else
+#define USE_EMX_MOUSE 0
 #endif
 
 #define DEFAULT_MAXCLICK 166
@@ -259,21 +261,32 @@
 
 struct ldat
 {
-	NCURSES_CH_T	*text;	    	/* text of the line */
-	NCURSES_SIZE_T	firstchar;  	/* first changed character in the line */
-	NCURSES_SIZE_T	lastchar;   	/* last changed character in the line */
-	NCURSES_SIZE_T	oldindex;   	/* index of the line at last update */
+	NCURSES_CH_T	*text;		/* text of the line */
+	NCURSES_SIZE_T	firstchar;	/* first changed character in the line */
+	NCURSES_SIZE_T	lastchar;	/* last changed character in the line */
+	NCURSES_SIZE_T	oldindex;	/* index of the line at last update */
 };
 
+typedef enum {
+	M_XTERM	= -1		/* use xterm's mouse tracking? */
+	,M_NONE = 0		/* no mouse device */
+#if USE_GPM_SUPPORT
+	,M_GPM			/* use GPM */
+#endif
+#if USE_SYSMOUSE
+	,M_SYSMOUSE		/* FreeBSD sysmouse on console */
+#endif
+} MouseType;
+
 /*
  * Structure for soft labels.
  */
 
 typedef struct
 {
-	char *text;             /* text for the label */
+	char *ent_text;         /* text for the label */
 	char *form_text;        /* formatted text (left/center/...) */
-	int x;                  /* x coordinate of this field */
+	int ent_x;              /* x coordinate of this field */
 	char dirty;             /* this label has changed */
 	char visible;           /* field is visible */
 } slk_ent;
@@ -283,11 +296,10 @@
 	char hidden;            /* soft labels are hidden */
 	WINDOW *win;
 	slk_ent *ent;
-	char*  buffer;           /* buffer for labels */
-	short  maxlab;           /* number of available labels */
-	short  labcnt;           /* number of allocated labels */
-	short  maxlen;           /* length of labels */
-        chtype attr;             /* soft label attribute */
+	short  maxlab;          /* number of available labels */
+	short  labcnt;          /* number of allocated labels */
+	short  maxlen;          /* length of labels */
+	chtype attr;            /* soft label attribute */
 } SLK;
 
 typedef struct {
@@ -308,7 +320,7 @@
 	char            *_setbuf;       /* buffered I/O for output          */
 	int		_buffered;      /* setvbuf uses _setbuf data        */
 	int             _checkfd;       /* filedesc for typeahead check     */
-	struct term     *_term;         /* terminal type information        */
+	TERMINAL        *_term;         /* terminal type information        */
 	short           _lines;         /* screen lines                     */
 	short           _columns;       /* screen columns                   */
 
@@ -326,6 +338,7 @@
 	bool            _tried;         /* keypad mode was initialized      */
 	bool            _keypad_on;     /* keypad mode is currently on      */
 
+	bool		_called_wgetch;	/* check for recursion in wgetch()  */
 	int    	        _fifo[FIFO_SIZE];       /* input push-back buffer   */
 	short           _fifohead,      /* head of fifo queue               */
 	                _fifotail,      /* tail of fifo queue               */
@@ -339,6 +352,7 @@
 	int             _cursor;        /* visibility of the cursor         */
 	int             _cursrow;       /* physical cursor row              */
 	int             _curscol;       /* physical cursor column           */
+	bool		_notty;		/* true if we cannot switch non-tty */
 	int             _nl;            /* True if NL -> CR/NL is on        */
 	int             _raw;           /* True if in raw mode              */
 	int             _cbreak;        /* 1 if in cbreak mode              */
@@ -405,7 +419,7 @@
 #endif
 	chtype          _xmc_suppress;  /* attributes to suppress if xmc     */
 	chtype          _xmc_triggers;  /* attributes to process if xmc      */
-	chtype          _acs_map[ACS_LEN];
+	chtype          _acs_map[ACS_LEN]; /* the real alternate-charset map */
 
 	/* used in lib_vidattr.c */
 	bool            _use_rmso;	/* true if we may use 'rmso'         */
@@ -426,6 +440,7 @@
 	/*
 	 * These are the data that support the mouse interface.
 	 */
+	MouseType	_mouse_type;
 	int             _maxclick;
 	bool            (*_mouse_event) (SCREEN *);
 	bool            (*_mouse_inline)(SCREEN *);
@@ -433,6 +448,16 @@
 	void            (*_mouse_resume)(SCREEN *);
 	void            (*_mouse_wrap)  (SCREEN *);
 	int             _mouse_fd;      /* file-descriptor, if any */
+	NCURSES_CONST char *_mouse_xtermcap; /* string to enable/disable mouse */
+#if USE_SYSMOUSE
+	MEVENT		_sysmouse_fifo[FIFO_SIZE];
+	int		_sysmouse_head;
+	int		_sysmouse_tail;
+	int		_sysmouse_char_width;	/* character width */
+	int		_sysmouse_char_height;	/* character height */
+	int		_sysmouse_old_buttons;
+	int		_sysmouse_new_buttons;
+#endif
 
 	/*
 	 * This supports automatic resizing
@@ -461,6 +486,14 @@
 	HASHMAP 	*hashtab;
 	int		hashtab_len;
 
+	/* recent versions of 'screen' have partially-working support for
+	 * UTF-8, but do not permit ACS at the same time (see tty_update.c).
+	 */
+#if USE_WIDEC_SUPPORT
+	bool		_posix_locale;
+	bool		_screen_acs_fix;
+#endif
+
 	bool            _cleanup;	/* cleanup after int/quit signal */
 	int             (*_outch)(int);	/* output handler if not putc */
 };
@@ -471,21 +504,19 @@
 #include <nomacros.h>
 #endif
 
-/*
- * The margins are used in resizeterm() to retain the original layout after
- * resizing.
- */
 	WINDOWLIST {
+	WINDOW	win;	/* first, so WINDOW_EXT() works */
 	WINDOWLIST *next;
-#if HAVE_RESIZETERM
-	int	l_margin;
-	int	r_margin;
-	int	t_margin;
-	int	b_margin;
+#ifdef _XOPEN_SOURCE_EXTENDED
+	char addch_work[(MB_LEN_MAX * 9) + 1];
+	int addch_used;
+	int addch_x;
+	int addch_y;
 #endif
-	WINDOW	win;
 };
 
+#define WINDOW_EXT(win,field) (((WINDOWLIST *)(win))->field)
+
 /* The terminfo source is assumed to be 7-bit ASCII */
 #define is7bits(c)	((unsigned)(c) < 128)
 
@@ -539,18 +570,29 @@
 #define O_BINARY 0
 #endif
 
+#ifdef TRACE
+#define TRACE_OUTCHARS(n) _nc_outchars += (n);
+#else
+#define TRACE_OUTCHARS(n) /* nothing */
+#endif
+
 #define UChar(c)	((unsigned char)(c))
 #define ChCharOf(c)	((c) & (chtype)A_CHARTEXT)
 #define ChAttrOf(c)     ((c) & (chtype)A_ATTRIBUTES)
 
+#ifndef MB_LEN_MAX
+#define MB_LEN_MAX 8 /* should be >= MB_CUR_MAX, but that may be a function */
+#endif
+
 #if USE_WIDEC_SUPPORT /* { */
+#define NulChar		0,0,0,0	/* FIXME: see CCHARW_MAX */
 #define CharOf(c)	((c).chars[0])
 #define AttrOf(c)	((c).attr)
 #define AddAttr(c,a)	(c).attr |= a
 #define RemAttr(c,a)	(c).attr &= ~(a)
 #define SetAttr(c,a)	(c).attr = a
-#define NewChar(ch)	{ ChAttrOf(ch), { ChCharOf(ch) } }
-#define NewChar2(c,a)	{ a, { c } }
+#define NewChar(ch)	{ ChAttrOf(ch), { ChCharOf(ch), NulChar } }
+#define NewChar2(c,a)	{ a, { c, NulChar } }
 #define CharEq(a,b)	(!memcmp(&a, &b, sizeof(a)))
 #define SetChar(ch,c,a)	do { 							    \
 			    NCURSES_CH_T *_cp = &ch;				    \
@@ -562,9 +604,14 @@
 #define CARG_CH_T	const NCURSES_CH_T *
 #define PUTC_DATA	char PUTC_buf[MB_LEN_MAX]; int PUTC_i, PUTC_n; \
 			mbstate_t PUT_st; wchar_t PUTC_ch
+#define PUTC_INIT	memset (&PUT_st, '\0', sizeof (PUT_st));		    \
+			PUTC_i = 0
 #define PUTC(ch,b)	do { if(!isnac(ch)) { 					    \
-			    memset (&PUT_st, '\0', sizeof (PUT_st));		    \
-			    PUTC_i = 0;						    \
+			if (Charable(ch)) {					    \
+			    fputc(CharOf(ch), b);				    \
+			    TRACE_OUTCHARS(1);					    \
+			} else {						    \
+			    PUTC_INIT;						    \
 			    do {						    \
 				PUTC_ch = PUTC_i < CCHARW_MAX ?			    \
 					    (ch).chars[PUTC_i] : L'\0';		    \
@@ -577,7 +624,8 @@
 				fwrite(PUTC_buf, (unsigned) PUTC_n, 1, b);	    \
 				++PUTC_i;					    \
 			    } while (PUTC_ch != L'\0');				    \
-			} } while (0)
+			    TRACE_OUTCHARS(PUTC_i);				    \
+			} } } while (0)
 
 #define BLANK		{ WA_NORMAL, ' ' }
 #define ISBLANK(ch)	((ch).chars[0] == L' ' && (ch).chars[1] == L'\0')
@@ -585,9 +633,10 @@
 #define WA_NAC		1
 #define isnac(ch)	(AttrOf(ch) & WA_NAC)
 #define if_WIDEC(code)  code
-#define Charable(ch)	(!isnac(ch) &&  			   	\
-			 (ch).chars[1] == L'\0' &&			\
-                         (wctob(CharOf(ch)) == (char)CharOf(ch)))
+#define Charable(ch)	((SP != 0 && SP->_posix_locale)			\
+			 || (!isnac(ch) &&				\
+			     (ch).chars[1] == L'\0' &&			\
+                             _nc_is_charable(CharOf(ch))))
 
 #define L(ch)		L ## ch
 #else /* }{ */
@@ -743,7 +792,7 @@
 
 #define ALL_BUT_COLOR ((chtype)~(A_COLOR))
 #define IGNORE_COLOR_OFF FALSE
-#define NONBLANK_ATTR (A_BOLD|A_DIM|A_BLINK)
+#define NONBLANK_ATTR (A_NORMAL|A_BOLD|A_DIM|A_BLINK)
 #define XMC_CHANGES(c) ((c) & SP->_xmc_suppress)
 
 #define toggle_attr_on(S,at) {\
@@ -847,6 +896,13 @@
 #define getcwd(buf,len) getwd(buf)
 #endif
 
+/* charable.c */
+#if USE_WIDEC_SUPPORT
+extern NCURSES_EXPORT(bool) _nc_is_charable(wchar_t);
+extern NCURSES_EXPORT(int) _nc_to_char(wint_t);
+extern NCURSES_EXPORT(wint_t) _nc_to_widechar(int);
+#endif
+
 /* doupdate.c */
 #if USE_XMC_SUPPORT
 extern NCURSES_EXPORT(void) _nc_do_xmc_glitch (attr_t);
@@ -872,6 +928,9 @@
 /* lib_getch.c */
 extern NCURSES_EXPORT(int) _nc_wgetch(WINDOW *, unsigned long *, int EVENTLIST_2nd(_nc_eventlist *));
 
+/* lib_insch.c */
+extern NCURSES_EXPORT(void) _nc_insert_ch(WINDOW *, chtype);
+
 /* lib_mvcur.c */
 #define INFINITY	1000000	/* cost: too high to use */
 
@@ -891,6 +950,11 @@
 /* lib_mvcur.c */
 #define INFINITY	1000000	/* cost: too high to use */
 
+/* lib_setup.c */
+extern NCURSES_EXPORT(char *) _nc_get_locale(void);
+extern NCURSES_EXPORT(int) _nc_unicode_locale(void);
+extern NCURSES_EXPORT(int) _nc_locale_breaks_acs(void);
+
 /* lib_wacs.c */
 #if USE_WIDEC_SUPPORT
 extern NCURSES_EXPORT(void) _nc_init_wacs(void);
@@ -931,14 +995,15 @@
 extern NCURSES_EXPORT(void) _nc_add_to_try (struct tries **, const char *, unsigned short);
 extern NCURSES_EXPORT(char *) _nc_expand_try (struct tries *, unsigned short, int *, size_t);
 extern NCURSES_EXPORT(int) _nc_remove_key (struct tries **, unsigned short);
-extern NCURSES_EXPORT(int) _nc_remove_string (struct tries **, char *);
+extern NCURSES_EXPORT(int) _nc_remove_string (struct tries **, const char *);
 
 /* elsewhere ... */
+extern NCURSES_EXPORT(NCURSES_CH_T) _nc_render (WINDOW *, NCURSES_CH_T);
 extern NCURSES_EXPORT(WINDOW *) _nc_makenew (int, int, int, int, int);
 extern NCURSES_EXPORT(char *) _nc_home_terminfo (void);
 extern NCURSES_EXPORT(char *) _nc_trace_buf (int, size_t);
-extern NCURSES_EXPORT(NCURSES_CH_T) _nc_render (WINDOW *, NCURSES_CH_T);
-extern NCURSES_EXPORT(int)  _nc_access (const char *, int);
+extern NCURSES_EXPORT(char *) _nc_trace_bufcat (int, const char *);
+extern NCURSES_EXPORT(int) _nc_access (const char *, int);
 extern NCURSES_EXPORT(int) _nc_baudrate (int);
 extern NCURSES_EXPORT(int) _nc_freewin (WINDOW *);
 extern NCURSES_EXPORT(int) _nc_getenv_num (const char *);
Index: ncurses/llib-lncurses
--- ncurses-5.3-20021012/ncurses/llib-lncurses	Sat Aug 31 17:34:07 2002
+++ ncurses-5.3-20030719/ncurses/llib-lncurses	Sat Apr 12 14:23:33 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
  ****************************************************************************/
 
 /****************************************************************************
- *  Author: Thomas E. Dickey 1996-2001,2002                                 *
+ *  Author: Thomas E. Dickey 1996-2002,2003                                 *
  ****************************************************************************/
 /* LINTLIBRARY */
 
@@ -192,6 +192,10 @@
 #undef COLORS
 int	COLORS;
 
+#undef _nc_reset_colors
+NCURSES_BOOL _nc_reset_colors(void)
+		{ return(*(NCURSES_BOOL *)0); }
+
 #undef start_color
 int	start_color(void)
 		{ return(*(int *)0); }
@@ -910,7 +914,7 @@
 #undef vw_printw
 int	vw_printw(
 		WINDOW	*a1, 
-		char	*a2, 
+		const char *a2, 
 		va_list	z)
 		{ return(*(int *)0); }
 
@@ -1080,26 +1084,30 @@
 
 /* ./base/lib_insch.c */
 
+#undef _nc_insert_ch
+void	_nc_insert_ch(
+		WINDOW	*win, 
+		chtype	ch)
+		{ /* void */ }
+
 #undef winsch
 int	winsch(
 		WINDOW	*win, 
 		chtype	c)
 		{ return(*(int *)0); }
 
-/* ./base/lib_insdel.c */
-
-#undef winsdelln
-int	winsdelln(
+#undef winsnstr
+int	winsnstr(
 		WINDOW	*win, 
+		const char *s, 
 		int	n)
 		{ return(*(int *)0); }
 
-/* ./base/lib_insstr.c */
+/* ./base/lib_insdel.c */
 
-#undef winsnstr
-int	winsnstr(
+#undef winsdelln
+int	winsdelln(
 		WINDOW	*win, 
-		const char *s, 
 		int	n)
 		{ return(*(int *)0); }
 
@@ -1358,14 +1366,14 @@
 
 #undef printw
 int	printw(
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
 #undef wprintw
 int	wprintw(
 		WINDOW	*win, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
@@ -1373,7 +1381,7 @@
 int	mvprintw(
 		int	y, 
 		int	x, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
@@ -1382,14 +1390,14 @@
 		WINDOW	*win, 
 		int	y, 
 		int	x, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
 #undef vwprintw
 int	vwprintw(
 		WINDOW	*win, 
-		char	*fmt, 
+		const char *fmt, 
 		va_list	argp)
 		{ return(*(int *)0); }
 
@@ -1724,9 +1732,9 @@
 		{ return(*(char **)0); }
 
 #undef _nc_retrace_chtype
-attr_t	_nc_retrace_chtype(
-		attr_t	code)
-		{ return(*(attr_t *)0); }
+chtype	_nc_retrace_chtype(
+		chtype	code)
+		{ return(*(chtype *)0); }
 
 /* ./trace/lib_tracedmp.c */
 
@@ -1938,6 +1946,14 @@
 void	_nc_vsscanf(void)
 		{ /* void */ }
 
+/* ./base/lib_freeall.c */
+
+#include <term_entry.h>
+
+#undef _nc_freeall
+void	_nc_freeall(void)
+		{ /* void */ }
+
 /* ./base/define_key.c */
 
 #undef define_key
@@ -1975,6 +1991,13 @@
 		chtype	c)
 		{ /* void */ }
 
+/* ./base/key_defined.c */
+
+#undef key_defined
+int	key_defined(
+		char	*str)
+		{ return(*(int *)0); }
+
 /* ./base/keybound.c */
 
 #undef keybound
@@ -2003,14 +2026,6 @@
 		int	bg)
 		{ return(*(int *)0); }
 
-/* ./base/lib_freeall.c */
-
-#include <term_entry.h>
-
-#undef _nc_freeall
-void	_nc_freeall(void)
-		{ /* void */ }
-
 /* ./tinfo/lib_print.c */
 
 #undef mcprint
@@ -2625,11 +2640,8 @@
 
 #include <sys/ioctl.h>
 
-#undef use_env
-void	use_env(
-		NCURSES_BOOL f)
-		{ /* void */ }
-
+#undef ttytype
+char	ttytype[256 ];
 #undef LINES
 int	LINES;
 #undef COLS
@@ -2637,12 +2649,22 @@
 #undef TABSIZE
 int	TABSIZE;
 
+#undef use_env
+void	use_env(
+		NCURSES_BOOL f)
+		{ /* void */ }
+
 #undef _nc_update_screensize
 void	_nc_update_screensize(void)
 		{ /* void */ }
 
-#undef ttytype
-char	ttytype[256 ];
+#undef _nc_unicode_locale
+int	_nc_unicode_locale(void)
+		{ return(*(int *)0); }
+
+#undef _nc_locale_breaks_acs
+int	_nc_locale_breaks_acs(void)
+		{ return(*(int *)0); }
 
 #undef setupterm
 int	setupterm(
@@ -2731,6 +2753,13 @@
 #undef _nc_tparm_err
 int	_nc_tparm_err;
 
+#undef _nc_tparm_analyze
+int	_nc_tparm_analyze(
+		const char *string, 
+		char	*p_is_s[9 ], 
+		int	*popcount)
+		{ return(*(int *)0); }
+
 #undef tparm
 char	*tparm(
 		char	*string, 
@@ -2793,11 +2822,21 @@
 		...)
 		{ /* void */ }
 
+#undef _nc_retrace_bool
+NCURSES_BOOL _nc_retrace_bool(
+		NCURSES_BOOL code)
+		{ return(*(NCURSES_BOOL *)0); }
+
 #undef _nc_retrace_int
 int	_nc_retrace_int(
 		int	code)
 		{ return(*(int *)0); }
 
+#undef _nc_retrace_unsigned
+unsigned _nc_retrace_unsigned(
+		unsigned code)
+		{ return(*(unsigned *)0); }
+
 #undef _nc_retrace_ptr
 char	*_nc_retrace_ptr(
 		char	*code)
@@ -3017,6 +3056,12 @@
 		size_t	want)
 		{ return(*(char **)0); }
 
+#undef _nc_trace_bufcat
+char	*_nc_trace_bufcat(
+		int	bufnum, 
+		const char *value)
+		{ return(*(char **)0); }
+
 /* ./trace/trace_tries.c */
 
 #undef _nc_trace_tries
@@ -3042,6 +3087,12 @@
 #undef _nc_visbuf
 const char *_nc_visbuf(
 		const char *buf)
+		{ return(*(const char **)0); }
+
+#undef _nc_visbufn
+const char *_nc_visbufn(
+		const char *buf, 
+		int	len)
 		{ return(*(const char **)0); }
 
 /* ./tinfo/write_entry.c */
Index: ncurses/llib-lncursesw
--- ncurses-5.3-20021012/ncurses/llib-lncursesw	Sat Aug 31 17:58:14 2002
+++ ncurses-5.3-20030719/ncurses/llib-lncursesw	Sat Apr 12 14:20:04 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 2001,2002 Free Software Foundation, Inc.                   *
+ * Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
  ****************************************************************************/
 
 /****************************************************************************
- *  Author: Thomas E. Dickey 2001,2002                                      *
+ *  Author: Thomas E. Dickey 2001-2003                                      *
  ****************************************************************************/
 /* LINTLIBRARY */
 
@@ -235,6 +235,10 @@
 #undef COLORS
 int	COLORS;
 
+#undef _nc_reset_colors
+NCURSES_BOOL _nc_reset_colors(void)
+		{ return(*(NCURSES_BOOL *)0); }
+
 #undef start_color
 int	start_color(void)
 		{ return(*(int *)0); }
@@ -965,7 +969,7 @@
 #undef vw_printw
 int	vw_printw(
 		WINDOW	*a1, 
-		char	*a2, 
+		const char *a2, 
 		va_list	z)
 		{ return(*(int *)0); }
 
@@ -1588,26 +1592,30 @@
 
 /* ./base/lib_insch.c */
 
+#undef _nc_insert_ch
+void	_nc_insert_ch(
+		WINDOW	*win, 
+		chtype	ch)
+		{ /* void */ }
+
 #undef winsch
 int	winsch(
 		WINDOW	*win, 
 		chtype	c)
 		{ return(*(int *)0); }
 
-/* ./base/lib_insdel.c */
-
-#undef winsdelln
-int	winsdelln(
+#undef winsnstr
+int	winsnstr(
 		WINDOW	*win, 
+		const char *s, 
 		int	n)
 		{ return(*(int *)0); }
 
-/* ./base/lib_insstr.c */
+/* ./base/lib_insdel.c */
 
-#undef winsnstr
-int	winsnstr(
+#undef winsdelln
+int	winsdelln(
 		WINDOW	*win, 
-		const char *s, 
 		int	n)
 		{ return(*(int *)0); }
 
@@ -1866,14 +1874,14 @@
 
 #undef printw
 int	printw(
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
 #undef wprintw
 int	wprintw(
 		WINDOW	*win, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
@@ -1881,7 +1889,7 @@
 int	mvprintw(
 		int	y, 
 		int	x, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
@@ -1890,14 +1898,14 @@
 		WINDOW	*win, 
 		int	y, 
 		int	x, 
-		char	*fmt, 
+		const char *fmt, 
 		...)
 		{ return(*(int *)0); }
 
 #undef vwprintw
 int	vwprintw(
 		WINDOW	*win, 
-		char	*fmt, 
+		const char *fmt, 
 		va_list	argp)
 		{ return(*(int *)0); }
 
@@ -2232,9 +2240,9 @@
 		{ return(*(char **)0); }
 
 #undef _nc_retrace_chtype
-attr_t	_nc_retrace_chtype(
-		attr_t	code)
-		{ return(*(attr_t *)0); }
+chtype	_nc_retrace_chtype(
+		chtype	code)
+		{ return(*(chtype *)0); }
 
 #undef _tracecchar_t2
 char	*_tracecchar_t2(
@@ -2457,6 +2465,14 @@
 void	_nc_vsscanf(void)
 		{ /* void */ }
 
+/* ./base/lib_freeall.c */
+
+#include <term_entry.h>
+
+#undef _nc_freeall
+void	_nc_freeall(void)
+		{ /* void */ }
+
 /* ./widechar/lib_box_set.c */
 
 #undef wborder_set
@@ -2547,15 +2563,6 @@
 		int	n)
 		{ return(*(int *)0); }
 
-/* ./widechar/lib_ins_nwstr.c */
-
-#undef wins_nwstr
-int	wins_nwstr(
-		WINDOW	*win, 
-		const wchar_t *wstr, 
-		int	n)
-		{ return(*(int *)0); }
-
 /* ./widechar/lib_ins_wch.c */
 
 #undef wins_wch
@@ -2564,6 +2571,13 @@
 		const cchar_t *wch)
 		{ return(*(int *)0); }
 
+#undef wins_nwstr
+int	wins_nwstr(
+		WINDOW	*win, 
+		const wchar_t *wstr, 
+		int	n)
+		{ return(*(int *)0); }
+
 /* ./widechar/lib_inwstr.c */
 
 #undef winnwstr
@@ -2579,6 +2593,15 @@
 		wchar_t *wstr)
 		{ return(*(int *)0); }
 
+/* ./widechar/lib_slk_wset.c */
+
+#undef slk_wset
+int	slk_wset(
+		int	i, 
+		const wchar_t *astr, 
+		int	format)
+		{ return(*(int *)0); }
+
 /* ./widechar/lib_unget_wch.c */
 
 #undef unget_wch
@@ -2670,6 +2693,13 @@
 		chtype	c)
 		{ /* void */ }
 
+/* ./base/key_defined.c */
+
+#undef key_defined
+int	key_defined(
+		char	*str)
+		{ return(*(int *)0); }
+
 /* ./base/keybound.c */
 
 #undef keybound
@@ -2698,14 +2728,6 @@
 		int	bg)
 		{ return(*(int *)0); }
 
-/* ./base/lib_freeall.c */
-
-#include <term_entry.h>
-
-#undef _nc_freeall
-void	_nc_freeall(void)
-		{ /* void */ }
-
 /* ./tinfo/lib_print.c */
 
 #undef mcprint
@@ -3325,11 +3347,8 @@
 
 #include <sys/ioctl.h>
 
-#undef use_env
-void	use_env(
-		NCURSES_BOOL f)
-		{ /* void */ }
-
+#undef ttytype
+char	ttytype[256 ];
 #undef LINES
 int	LINES;
 #undef COLS
@@ -3337,12 +3356,22 @@
 #undef TABSIZE
 int	TABSIZE;
 
+#undef use_env
+void	use_env(
+		NCURSES_BOOL f)
+		{ /* void */ }
+
 #undef _nc_update_screensize
 void	_nc_update_screensize(void)
 		{ /* void */ }
 
-#undef ttytype
-char	ttytype[256 ];
+#undef _nc_unicode_locale
+int	_nc_unicode_locale(void)
+		{ return(*(int *)0); }
+
+#undef _nc_locale_breaks_acs
+int	_nc_locale_breaks_acs(void)
+		{ return(*(int *)0); }
 
 #undef setupterm
 int	setupterm(
@@ -3431,6 +3460,13 @@
 #undef _nc_tparm_err
 int	_nc_tparm_err;
 
+#undef _nc_tparm_analyze
+int	_nc_tparm_analyze(
+		const char *string, 
+		char	*p_is_s[9 ], 
+		int	*popcount)
+		{ return(*(int *)0); }
+
 #undef tparm
 char	*tparm(
 		char	*string, 
@@ -3493,11 +3529,21 @@
 		...)
 		{ /* void */ }
 
+#undef _nc_retrace_bool
+NCURSES_BOOL _nc_retrace_bool(
+		NCURSES_BOOL code)
+		{ return(*(NCURSES_BOOL *)0); }
+
 #undef _nc_retrace_int
 int	_nc_retrace_int(
 		int	code)
 		{ return(*(int *)0); }
 
+#undef _nc_retrace_unsigned
+unsigned _nc_retrace_unsigned(
+		unsigned code)
+		{ return(*(unsigned *)0); }
+
 #undef _nc_retrace_ptr
 char	*_nc_retrace_ptr(
 		char	*code)
@@ -3717,6 +3763,12 @@
 		size_t	want)
 		{ return(*(char **)0); }
 
+#undef _nc_trace_bufcat
+char	*_nc_trace_bufcat(
+		int	bufnum, 
+		const char *value)
+		{ return(*(char **)0); }
+
 /* ./trace/trace_tries.c */
 
 #undef _nc_trace_tries
@@ -3744,6 +3796,12 @@
 		const char *buf)
 		{ return(*(const char **)0); }
 
+#undef _nc_visbufn
+const char *_nc_visbufn(
+		const char *buf, 
+		int	len)
+		{ return(*(const char **)0); }
+
 #undef _nc_viswbuf2
 const char *_nc_viswbuf2(
 		int	bufnum, 
@@ -3753,6 +3811,12 @@
 #undef _nc_viswbuf
 const char *_nc_viswbuf(
 		const wchar_t *buf)
+		{ return(*(const char **)0); }
+
+#undef _nc_viswbufn
+const char *_nc_viswbufn(
+		const wchar_t *buf, 
+		int	len)
 		{ return(*(const char **)0); }
 
 #undef _nc_viscbuf2
Index: ncurses/modules
Prereq:  1.90 
--- ncurses-5.3-20021012/ncurses/modules	Sat May 11 16:14:41 2002
+++ ncurses-5.3-20030719/ncurses/modules	Sat Jul  5 12:01:45 2003
@@ -1,4 +1,4 @@
-# $Id: modules,v 1.90 2002/05/11 20:14:41 tom Exp $
+# $Id: modules,v 1.96 2003/07/05 16:01:45 tom Exp $
 ##############################################################################
 # Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.                #
 #                                                                            #
@@ -61,7 +61,6 @@
 lib_initscr	lib		$(base)		$(INCDIR)/tic.h
 lib_insch	lib		$(base)
 lib_insdel	lib		$(base)
-lib_insstr	lib		$(base)
 lib_instr	lib		$(base)
 lib_isendwin	lib		$(base)
 lib_leaveok	lib		$(base)
@@ -120,8 +119,12 @@
 sigaction	lib		$(base)
 vsscanf 	lib		$(base)
 
+# actually an extension, but with its own configure option (--disable-leaks)
+lib_freeall	lib		$(base)
+
 # XSI extensions to the base library (wide-character)
 @ widechar
+charable	lib		$(wide)
 lib_box_set	lib		$(wide)
 lib_cchar	lib		$(wide)
 lib_get_wch	lib		$(wide)
@@ -130,9 +133,9 @@
 lib_hline_set	lib		$(wide)
 lib_in_wch	lib		$(wide)
 lib_in_wchnstr	lib		$(wide)
-lib_ins_nwstr	lib		$(wide)
 lib_ins_wch	lib		$(wide)
 lib_inwstr	lib		$(wide)
+lib_slk_wset	lib		$(wide)
 lib_unget_wch	lib		$(wide)
 lib_vid_attr	lib		$(wide)		../include/term.h
 lib_vline_set	lib		$(wide)
@@ -143,10 +146,10 @@
 @ ext_funcs
 define_key	lib		$(base)
 expanded	lib		.
+key_defined	lib		$(base)
 keybound	lib		$(base)
 keyok		lib		$(base)
 lib_dft_fgbg	lib		$(base)		../include/term.h
-lib_freeall	lib		$(base)
 lib_print	lib		$(tinfo)	../include/term.h
 resizeterm	lib		$(base)		../include/term.h
 trace_xnames	lib		$(trace)	../include/term.h $(INCDIR)/term_entry.h
Index: ncurses/tinfo/MKkeys_list.sh
Prereq:  1.2 
--- ncurses-5.3-20021012/ncurses/tinfo/MKkeys_list.sh	Sat Jun 16 12:50:35 2001
+++ ncurses-5.3-20030719/ncurses/tinfo/MKkeys_list.sh	Sat Jan 11 17:24:53 2003
@@ -1,7 +1,7 @@
 #! /bin/sh
-# $Id: MKkeys_list.sh,v 1.2 2001/06/16 16:50:35 tom Exp $
+# $Id: MKkeys_list.sh,v 1.3 2003/01/11 22:24:53 tom Exp $
 ##############################################################################
-# Copyright (c) 2001 Free Software Foundation, Inc.                          #
+# Copyright (c) 2001,2003 Free Software Foundation, Inc.                     #
 #                                                                            #
 # Permission is hereby granted, free of charge, to any person obtaining a    #
 # copy of this software and associated documentation files (the "Software"), #
@@ -39,7 +39,7 @@
 
 data=data$$
 trap 'rm -f $data' 0 1 2 5 15
-sed -e 's/[	]\+/	/g' < $DATA >$data
+sed -e 's/[	][	]*/	/g' < $DATA >$data
 
 cat <<EOF
 # These definitions were generated by $0 $DATA
Index: ncurses/tinfo/access.c
Prereq:  1.9 
--- ncurses-5.3-20021012/ncurses/tinfo/access.c	Sat Jun 23 18:11:49 2001
+++ ncurses-5.3-20030719/ncurses/tinfo/access.c	Sat Jul  5 15:31:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,2000,2001 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998,2001,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -34,7 +34,7 @@
 #include <tic.h>
 #include <nc_alloc.h>
 
-MODULE_ID("$Id: access.c,v 1.9 2001/06/23 22:11:49 tom Exp $")
+MODULE_ID("$Id: access.c,v 1.10 2003/07/05 19:31:28 tom Exp $")
 
 #define LOWERCASE(c) ((isalpha(UChar(c)) && isupper(UChar(c))) ? tolower(UChar(c)) : (c))
 
@@ -64,19 +64,28 @@
     return result;
 }
 
-NCURSES_EXPORT(char *)
-_nc_basename(char *path)
+/*
+ * Return index of the basename
+ */
+NCURSES_EXPORT(unsigned)
+_nc_pathlast(const char *path)
 {
-    char *result = strrchr(path, '/');
+    const char *test = strrchr(path, '/');
 #ifdef __EMX__
-    if (result == 0)
-	result = strrchr(path, '\\');
+    if (test == 0)
+	test = strrchr(path, '\\');
 #endif
-    if (result == 0)
-	result = path;
+    if (test == 0)
+	test = path;
     else
-	result++;
-    return result;
+	test++;
+    return (test - path);
+}
+
+NCURSES_EXPORT(char *)
+_nc_basename(char *path)
+{
+    return path + _nc_pathlast(path);
 }
 
 NCURSES_EXPORT(int)
Index: ncurses/tinfo/alloc_entry.c
Prereq:  1.37 
--- ncurses-5.3-20021012/ncurses/tinfo/alloc_entry.c	Sat Sep  7 16:04:15 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/alloc_entry.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -47,7 +47,7 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: alloc_entry.c,v 1.37 2002/09/07 20:04:15 tom Exp $")
+MODULE_ID("$Id: alloc_entry.c,v 1.38 2003/05/24 21:10:28 tom Exp $")
 
 #define ABSENT_OFFSET    -1
 #define CANCELLED_OFFSET -2
@@ -61,10 +61,10 @@
 _nc_init_entry(TERMTYPE * const tp)
 /* initialize a terminal type data block */
 {
-    int i;
+    unsigned i;
 
     if (stringbuf == 0)
-	stringbuf = malloc(MAX_STRTAB);
+	stringbuf = (char *) malloc(MAX_STRTAB);
 
 #if NCURSES_XNAMES
     tp->num_Booleans = BOOLCOUNT;
@@ -126,7 +126,8 @@
 /* copy the string parts to allocated storage, preserving pointers to it */
 {
     int offsets[MAX_ENTRY_SIZE / 2], useoffsets[MAX_USES];
-    int i, n;
+    unsigned i, n;
+    unsigned nuses = ep->nuses;
     TERMTYPE *tp = &(ep->tterm);
 
     if (copy_strings) {
@@ -141,7 +142,7 @@
 	    }
 	}
 
-	for (i = 0; i < ep->nuses; i++) {
+	for (i = 0; i < nuses; i++) {
 	    if (ep->uses[i].name == 0) {
 		ep->uses[i].name = _nc_save_str(ep->uses[i].name);
 	    }
@@ -160,7 +161,7 @@
 	    offsets[i] = tp->Strings[i] - stringbuf;
     }
 
-    for (i = 0; i < ep->nuses; i++) {
+    for (i = 0; i < nuses; i++) {
 	if (ep->uses[i].name == 0)
 	    useoffsets[i] = ABSENT_OFFSET;
 	else
@@ -200,7 +201,7 @@
     }
 #endif
 
-    for (i = 0; i < ep->nuses; i++) {
+    for (i = 0; i < nuses; i++) {
 	if (useoffsets[i] == ABSENT_OFFSET)
 	    ep->uses[i].name = 0;
 	else
@@ -209,11 +210,10 @@
 }
 
 NCURSES_EXPORT(void)
-_nc_merge_entry
-(TERMTYPE * const to, TERMTYPE * const from)
+_nc_merge_entry(TERMTYPE * const to, TERMTYPE * const from)
 /* merge capabilities from `from' entry into `to' entry */
 {
-    int i;
+    unsigned i;
 
 #if NCURSES_XNAMES
     _nc_align_termtype(to, from);
Index: ncurses/tinfo/alloc_ttype.c
Prereq:  1.13 
--- ncurses-5.3-20021012/ncurses/tinfo/alloc_ttype.c	Sat Sep 28 11:28:43 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/alloc_ttype.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -43,7 +43,7 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: alloc_ttype.c,v 1.13 2002/09/28 15:28:43 tom Exp $")
+MODULE_ID("$Id: alloc_ttype.c,v 1.14 2003/05/24 21:10:28 tom Exp $")
 
 #if NCURSES_XNAMES
 /*
@@ -92,8 +92,10 @@
 }
 
 static void
-realign_data(TERMTYPE * to, char **ext_Names, int ext_Booleans, int
-	     ext_Numbers, int ext_Strings)
+realign_data(TERMTYPE * to, char **ext_Names,
+	     int ext_Booleans,
+	     int ext_Numbers,
+	     int ext_Strings)
 {
     int n, m, base;
     int limit = (to->ext_Booleans + to->ext_Numbers + to->ext_Strings);
@@ -371,8 +373,7 @@
 }
 
 NCURSES_EXPORT(void)
-_nc_align_termtype
-(TERMTYPE * to, TERMTYPE * from)
+_nc_align_termtype(TERMTYPE * to, TERMTYPE * from)
 {
     int na = NUM_EXT_NAMES(to);
     int nb = NUM_EXT_NAMES(from);
@@ -457,10 +458,9 @@
 #endif
 
 NCURSES_EXPORT(void)
-_nc_copy_termtype
-(TERMTYPE * dst, TERMTYPE * src)
+_nc_copy_termtype(TERMTYPE * dst, TERMTYPE * src)
 {
-    int i;
+    unsigned i;
 
     *dst = *src;		/* ...to copy the sizes and string-tables */
     dst->Booleans = typeMalloc(char, NUM_BOOLEANS(dst));
Index: ncurses/tinfo/comp_parse.c
Prereq:  1.53 
--- ncurses-5.3-20021012/ncurses/tinfo/comp_parse.c	Sat Sep  7 16:01:28 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/comp_parse.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -52,7 +52,7 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: comp_parse.c,v 1.53 2002/09/07 20:01:28 tom Exp $")
+MODULE_ID("$Id: comp_parse.c,v 1.54 2003/05/24 21:10:28 tom Exp $")
 
 static void sanity_check(TERMTYPE *);
 NCURSES_IMPEXP void NCURSES_API(*_nc_check_termtype) (TERMTYPE *) = sanity_check;
@@ -163,7 +163,7 @@
  ****************************************************************************/
 
 NCURSES_EXPORT(void)
-_nc_read_entry_source(FILE * fp, char *buf,
+_nc_read_entry_source(FILE *fp, char *buf,
 		      int literal, bool silent,
 		      bool(*hook) (ENTRY *))
 /* slurp all entries in the given file into core */
@@ -216,7 +216,8 @@
 {
     ENTRY *qp, *rp, *lastread = 0;
     bool keepgoing;
-    int i, j, unresolved, total_unresolved, multiples;
+    int i, unresolved, total_unresolved, multiples;
+    unsigned j;
 
     DEBUG(2, ("RESOLUTION BEGINNING"));
 
Index: ncurses/tinfo/comp_scan.c
Prereq:  1.61 
--- ncurses-5.3-20021012/ncurses/tinfo/comp_scan.c	Sat Sep  7 16:04:09 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/comp_scan.c	Sat May 31 19:27:20 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -50,7 +50,7 @@
 #include <term_entry.h>
 #include <tic.h>
 
-MODULE_ID("$Id: comp_scan.c,v 1.61 2002/09/07 20:04:09 tom Exp $")
+MODULE_ID("$Id: comp_scan.c,v 1.64 2003/05/31 23:27:20 tom Exp $")
 
 /*
  * Maximum length of string capability we'll accept before raising an error.
@@ -93,10 +93,10 @@
 _nc_disable_period = FALSE;	/* used by tic -a option */
 #endif
 
+static bool end_of_stream(void);
 static int last_char(void);
 static int next_char(void);
 static long stream_pos(void);
-static bool end_of_stream(void);
 static void push_back(char c);
 
 /* Assume we may be looking at a termcap-style continuation */
@@ -148,8 +148,11 @@
     static const char terminfo_punct[] = "@%&*!#";
     static char *buffer;
 
+    char *after_list;
+    char *after_name;
     char *numchk;
     char *ptr;
+    char *s;
     char numbuf[80];
     int ch;
     int dot_flag = FALSE;
@@ -173,8 +176,12 @@
 	return (retval);
     }
 
-    if (end_of_stream())
+    if (end_of_stream()) {
+	if (buffer != 0) {
+	    FreeAndNull(buffer);
+	}
 	return (EOF);
+    }
 
   start_token:
     token_start = stream_pos();
@@ -227,17 +234,21 @@
 	*(ptr++) = ch;
 
 	if (first_column) {
-	    char *desc;
-
 	    _nc_comment_start = token_start;
 	    _nc_comment_end = _nc_curr_file_pos;
 	    _nc_start_line = _nc_curr_line;
 
 	    _nc_syntax = ERR;
+	    after_name = 0;
+	    after_list = 0;
 	    while ((ch = next_char()) != '\n') {
-		if (ch == EOF)
+		if (ch == EOF) {
 		    _nc_err_abort(MSG_NO_MEMORY);
-		else if (ch == ':' && last_char() != ',') {
+		} else if (ch == '|') {
+		    after_list = ptr;
+		    if (after_name == 0)
+			after_name = ptr;
+		} else if (ch == ':' && last_char() != ',') {
 		    _nc_syntax = SYN_TERMCAP;
 		    separator = ':';
 		    break;
@@ -245,14 +256,18 @@
 		    _nc_syntax = SYN_TERMINFO;
 		    separator = ',';
 		    /*
-		     * Fall-through here is not an accident.  The idea is that
-		     * if we see a comma, we figure this is terminfo unless we
-		     * subsequently run into a colon -- but we don't stop
-		     * looking for that colon until hitting a newline.  This
+		     * If we did not see a '|', then we found a name with no
+		     * aliases or description.
+		     */
+		    if (after_name == 0)
+			break;
+		    /*
+		     * If we see a comma, we assume this is terminfo unless we
+		     * subsequently run into a colon.  But we don't stop
+		     * looking for a colon until hitting a newline.  This
 		     * allows commas to be embedded in description fields of
 		     * either syntax.
 		     */
-		    /* FALLTHRU */
 		} else
 		    ch = eat_escaped_newline(ch);
 
@@ -277,53 +292,53 @@
 
 	    /*
 	     * This is the soonest we have the terminal name fetched.  Set up
-	     * for following warning messages.
+	     * for following warning messages.  If there's no '|', then there
+	     * is no description.
 	     */
-	    ptr = strchr(buffer, '|');
-	    if (ptr == (char *) NULL)
-		ptr = buffer + strlen(buffer);
-	    ch = *ptr;
-	    *ptr = '\0';
-	    _nc_set_type(buffer);
-	    *ptr = ch;
+	    if (after_name != 0) {
+		ch = *after_name;
+		*after_name = '\0';
+		_nc_set_type(buffer);
+		*after_name = ch;
+	    }
 
 	    /*
 	     * Compute the boundary between the aliases and the description
 	     * field for syntax-checking purposes.
 	     */
-	    desc = strrchr(buffer, '|');
-	    if (!silent && desc) {
-		if (*desc == '\0')
-		    _nc_warning("empty longname field");
-		else if (strchr(desc, ' ') == (char *) NULL)
-		    _nc_warning("older tic versions may treat the description field as an alias");
+	    if (after_list != 0) {
+		if (!silent) {
+		    if (*after_list == '\0')
+			_nc_warning("empty longname field");
+		    else if (strchr(after_list, ' ') == 0)
+			_nc_warning("older tic versions may treat the description field as an alias");
+		}
+	    } else {
+		after_list = buffer + strlen(buffer);
+		DEBUG(1, ("missing description"));
 	    }
-	    if (!desc)
-		desc = buffer + strlen(buffer);
 
 	    /*
 	     * Whitespace in a name field other than the long name can confuse
 	     * rdist and some termcap tools.  Slashes are a no-no.  Other
 	     * special characters can be dangerous due to shell expansion.
 	     */
-	    for (ptr = buffer; ptr < desc; ptr++) {
-		if (isspace(UChar(*ptr))) {
+	    for (s = buffer; s < after_list; ++s) {
+		if (isspace(UChar(*s))) {
 		    if (!silent)
 			_nc_warning("whitespace in name or alias field");
 		    break;
-		} else if (*ptr == '/') {
+		} else if (*s == '/') {
 		    if (!silent)
 			_nc_warning("slashes aren't allowed in names or aliases");
 		    break;
-		} else if (strchr("$[]!*?", *ptr)) {
+		} else if (strchr("$[]!*?", *s)) {
 		    if (!silent)
-			_nc_warning("dubious character `%c' in name or alias field", *ptr);
+			_nc_warning("dubious character `%c' in name or alias field", *s);
 		    break;
 		}
 	    }
 
-	    ptr = buffer;
-
 	    _nc_curr_token.tk_name = buffer;
 	    type = NAMES;
 	} else {
@@ -684,7 +699,7 @@
  */
 
 NCURSES_EXPORT(void)
-_nc_reset_input(FILE * fp, char *buf)
+_nc_reset_input(FILE *fp, char *buf)
 {
     pushtype = NO_PUSHBACK;
     if (pushname != 0)
@@ -766,7 +781,7 @@
 		if (used == 0)
 		    _nc_curr_file_pos = ftell(yyin);
 
-		if (fgets(result + used, allocated - used, yyin) != NULL) {
+		if (fgets(result + used, allocated - used, yyin) != 0) {
 		    bufstart = result;
 		    if (used == 0) {
 			_nc_curr_line++;
Index: ncurses/tinfo/free_ttype.c
Prereq:  1.8 
--- ncurses-5.3-20021012/ncurses/tinfo/free_ttype.c	Sun Sep  1 16:29:03 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/free_ttype.c	Sat Feb 15 14:36:45 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1999-2000,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1999-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -43,11 +43,13 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: free_ttype.c,v 1.8 2002/09/01 20:29:03 tom Exp $")
+MODULE_ID("$Id: free_ttype.c,v 1.9 2003/02/15 19:36:45 tom Exp $")
 
 NCURSES_EXPORT(void)
 _nc_free_termtype(TERMTYPE * ptr)
 {
+    T(("_nc_free_termtype(%s)", ptr->term_names));
+
     FreeIfNeeded(ptr->str_table);
     FreeIfNeeded(ptr->Booleans);
     FreeIfNeeded(ptr->Numbers);
@@ -66,7 +68,9 @@
 use_extended_names(bool flag)
 {
     int oldflag = _nc_user_definable;
+
+    T((T_CALLED("use_extended_names(%d)"), flag));
     _nc_user_definable = flag;
-    return oldflag;
+    returnBool(oldflag);
 }
 #endif
Index: ncurses/tinfo/lib_acs.c
Prereq:  1.22 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_acs.c	Sun Sep  1 15:26:57 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_acs.c	Sat Dec 28 11:26:46 2002
@@ -34,7 +34,7 @@
 #include <curses.priv.h>
 #include <term.h>		/* ena_acs, acs_chars */
 
-MODULE_ID("$Id: lib_acs.c,v 1.22 2002/09/01 19:26:57 tom Exp $")
+MODULE_ID("$Id: lib_acs.c,v 1.25 2002/12/28 16:26:46 tom Exp $")
 
 #if BROKEN_LINKER
 NCURSES_EXPORT_VAR(chtype *)
@@ -55,101 +55,88 @@
 NCURSES_EXPORT(void)
 _nc_init_acs(void)
 {
+    chtype *fake_map = acs_map;
+    chtype *real_map = SP != 0 ? SP->_acs_map : fake_map;
+    int j;
+
     T(("initializing ACS map"));
-#if !BROKEN_LINKER
-    memset(acs_map, 0, sizeof(acs_map));
-#endif
+
+    /*
+     * If we're using this from curses (rather than terminfo), we are storing
+     * the mapping information in the SCREEN struct so we can decide how to
+     * render it.
+     */
+    if (real_map != fake_map) {
+	for (j = 1; j < ACS_LEN; ++j) {
+	    real_map[j] = 0;
+	    fake_map[j] = A_ALTCHARSET | j;
+	}
+    } else {
+	for (j = 1; j < ACS_LEN; ++j) {
+	    real_map[j] = 0;
+	}
+    }
 
     /*
      * Initializations for a UNIX-like multi-terminal environment.  Use
      * ASCII chars and count on the terminfo description to do better.
      */
-    ACS_ULCORNER = '+';		/* should be upper left corner */
-    ACS_LLCORNER = '+';		/* should be lower left corner */
-    ACS_URCORNER = '+';		/* should be upper right corner */
-    ACS_LRCORNER = '+';		/* should be lower right corner */
-    ACS_RTEE = '+';		/* should be tee pointing left */
-    ACS_LTEE = '+';		/* should be tee pointing right */
-    ACS_BTEE = '+';		/* should be tee pointing up */
-    ACS_TTEE = '+';		/* should be tee pointing down */
-    ACS_HLINE = '-';		/* should be horizontal line */
-    ACS_VLINE = '|';		/* should be vertical line */
-    ACS_PLUS = '+';		/* should be large plus or crossover */
-    ACS_S1 = '~';		/* should be scan line 1 */
-    ACS_S9 = '_';		/* should be scan line 9 */
-    ACS_DIAMOND = '+';		/* should be diamond */
-    ACS_CKBOARD = ':';		/* should be checker board (stipple) */
-    ACS_DEGREE = '\'';		/* should be degree symbol */
-    ACS_PLMINUS = '#';		/* should be plus/minus */
-    ACS_BULLET = 'o';		/* should be bullet */
-    ACS_LARROW = '<';		/* should be arrow pointing left */
-    ACS_RARROW = '>';		/* should be arrow pointing right */
-    ACS_DARROW = 'v';		/* should be arrow pointing down */
-    ACS_UARROW = '^';		/* should be arrow pointing up */
-    ACS_BOARD = '#';		/* should be board of squares */
-    ACS_LANTERN = '#';		/* should be lantern symbol */
-    ACS_BLOCK = '#';		/* should be solid square block */
+    real_map['l'] = '+';	/* should be upper left corner */
+    real_map['m'] = '+';	/* should be lower left corner */
+    real_map['k'] = '+';	/* should be upper right corner */
+    real_map['j'] = '+';	/* should be lower right corner */
+    real_map['u'] = '+';	/* should be tee pointing left */
+    real_map['t'] = '+';	/* should be tee pointing right */
+    real_map['v'] = '+';	/* should be tee pointing up */
+    real_map['w'] = '+';	/* should be tee pointing down */
+    real_map['q'] = '-';	/* should be horizontal line */
+    real_map['x'] = '|';	/* should be vertical line */
+    real_map['n'] = '+';	/* should be large plus or crossover */
+    real_map['o'] = '~';	/* should be scan line 1 */
+    real_map['s'] = '_';	/* should be scan line 9 */
+    real_map['`'] = '+';	/* should be diamond */
+    real_map['a'] = ':';	/* should be checker board (stipple) */
+    real_map['f'] = '\'';	/* should be degree symbol */
+    real_map['g'] = '#';	/* should be plus/minus */
+    real_map['~'] = 'o';	/* should be bullet */
+    real_map[','] = '<';	/* should be arrow pointing left */
+    real_map['+'] = '>';	/* should be arrow pointing right */
+    real_map['.'] = 'v';	/* should be arrow pointing down */
+    real_map['-'] = '^';	/* should be arrow pointing up */
+    real_map['h'] = '#';	/* should be board of squares */
+    real_map['i'] = '#';	/* should be lantern symbol */
+    real_map['0'] = '#';	/* should be solid square block */
     /* these defaults were invented for ncurses */
-    ACS_S3 = '-';		/* should be scan line 3 */
-    ACS_S7 = '-';		/* should be scan line 7 */
-    ACS_LEQUAL = '<';		/* should be less-than-or-equal-to */
-    ACS_GEQUAL = '>';		/* should be greater-than-or-equal-to */
-    ACS_PI = '*';		/* should be greek pi */
-    ACS_NEQUAL = '!';		/* should be not-equal */
-    ACS_STERLING = 'f';		/* should be pound-sterling symbol */
+    real_map['p'] = '-';	/* should be scan line 3 */
+    real_map['r'] = '-';	/* should be scan line 7 */
+    real_map['y'] = '<';	/* should be less-than-or-equal-to */
+    real_map['z'] = '>';	/* should be greater-than-or-equal-to */
+    real_map['{'] = '*';	/* should be greek pi */
+    real_map['|'] = '!';	/* should be not-equal */
+    real_map['}'] = 'f';	/* should be pound-sterling symbol */
+
+#if !USE_WIDEC_SUPPORT
+    if (_nc_unicode_locale() && _nc_locale_breaks_acs()) {
+	acs_chars = NULL;
+	ena_acs = NULL;
+    }
+#endif
 
     if (ena_acs != NULL) {
 	TPUTS_TRACE("ena_acs");
 	putp(ena_acs);
     }
-#define ALTCHAR(c)	((chtype)(((unsigned char)(c)) | A_ALTCHARSET))
 
     if (acs_chars != NULL) {
 	size_t i = 0;
 	size_t length = strlen(acs_chars);
 
-	while (i < length)
-	    switch (acs_chars[i]) {
-	    case 'l':
-	    case 'm':
-	    case 'k':
-	    case 'j':
-	    case 'u':
-	    case 't':
-	    case 'v':
-	    case 'w':
-	    case 'q':
-	    case 'x':
-	    case 'n':
-	    case 'o':
-	    case 's':
-	    case '`':
-	    case 'a':
-	    case 'f':
-	    case 'g':
-	    case '~':
-	    case ',':
-	    case '+':
-	    case '.':
-	    case '-':
-	    case 'h':
-	    case 'i':
-	    case '0':
-	    case 'p':
-	    case 'r':
-	    case 'y':
-	    case 'z':
-	    case '{':
-	    case '|':
-	    case '}':
-		acs_map[(unsigned int) acs_chars[i]] =
-		    ALTCHAR(acs_chars[i + 1]);
-		i++;
-		/* FALLTHRU */
-	    default:
-		i++;
-		break;
+	while (i + 1 < length) {
+	    if (acs_chars[i] != 0 && UChar(acs_chars[i]) < ACS_LEN) {
+		real_map[UChar(acs_chars[i])] = UChar(acs_chars[i + 1]) | A_ALTCHARSET;
 	    }
+	    i += 2;
+	}
     }
 #ifdef TRACE
     /* Show the equivalent mapping, noting if it does not match the
@@ -159,9 +146,9 @@
 	size_t n, m;
 	char show[ACS_LEN + 1];
 	for (n = 1, m = 0; n < ACS_LEN; n++) {
-	    if (acs_map[n] != 0) {
+	    if (real_map[n] != 0) {
 		show[m++] = (char) n;
-		show[m++] = ChCharOf(acs_map[n]);
+		show[m++] = ChCharOf(real_map[n]);
 	    }
 	}
 	show[m] = 0;
Index: ncurses/tinfo/lib_cur_term.c
Prereq:  1.11 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_cur_term.c	Sat Dec  9 21:55:07 2000
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_cur_term.c	Sat Feb 22 20:00:56 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,1999,2000 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -40,7 +40,7 @@
 #include <term_entry.h>		/* TTY, cur_term */
 #include <termcap.h>		/* ospeed */
 
-MODULE_ID("$Id: lib_cur_term.c,v 1.11 2000/12/10 02:55:07 tom Exp $")
+MODULE_ID("$Id: lib_cur_term.c,v 1.12 2003/02/23 01:00:56 tom Exp $")
 
 NCURSES_EXPORT_VAR(TERMINAL *) cur_term = 0;
 
@@ -49,11 +49,14 @@
 {
     TERMINAL *oldterm = cur_term;
 
+    T((T_CALLED("set_curterm(%p)"), termp));
+
     if ((cur_term = termp) != 0) {
 	ospeed = _nc_ospeed(cur_term->_baudrate);
 	PC = (pad_char != NULL) ? pad_char[0] : 0;
     }
-    return oldterm;
+    T((T_RETURN("%p"), oldterm));
+    return (oldterm);
 }
 
 NCURSES_EXPORT(int)
Index: ncurses/tinfo/lib_kernel.c
Prereq:  1.22 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_kernel.c	Sat May 11 16:32:18 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_kernel.c	Sat Jan 25 19:24:53 2003
@@ -48,12 +48,12 @@
 #include <curses.priv.h>
 #include <term.h>		/* cur_term */
 
-MODULE_ID("$Id: lib_kernel.c,v 1.22 2002/05/11 20:32:18 tom Exp $")
+MODULE_ID("$Id: lib_kernel.c,v 1.23 2003/01/26 00:24:53 tom Exp $")
 
 static int
 _nc_vdisable(void)
 {
-    int value;
+    int value = -1;
 #if defined(_POSIX_VDISABLE) && defined(HAVE_UNISTD_H)
     value = _POSIX_VDISABLE;
 #endif
Index: ncurses/tinfo/lib_setup.c
Prereq:  1.70 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_setup.c	Sat Oct 12 17:50:18 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_setup.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -29,6 +29,7 @@
 /****************************************************************************
  *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
+ *     and: Thomas E. Dickey 1996-2003                                      *
  ****************************************************************************/
 
 /*
@@ -48,7 +49,7 @@
 
 #include <term.h>		/* lines, columns, cur_term */
 
-MODULE_ID("$Id: lib_setup.c,v 1.70 2002/10/12 21:50:18 tom Exp $")
+MODULE_ID("$Id: lib_setup.c,v 1.77 2003/05/24 21:10:28 tom Exp $")
 
 /****************************************************************************
  *
@@ -90,9 +91,12 @@
 # endif
 #endif
 
-static int _use_env = TRUE;
+NCURSES_EXPORT_VAR(char) ttytype[NAMESIZE] = "";
+NCURSES_EXPORT_VAR(int) LINES = 0;
+NCURSES_EXPORT_VAR(int) COLS = 0;
+NCURSES_EXPORT_VAR(int) TABSIZE = 0;
 
-static void do_prototype(void);
+static int _use_env = TRUE;
 
 NCURSES_EXPORT(void)
 use_env(bool f)
@@ -102,10 +106,6 @@
     returnVoid;
 }
 
-NCURSES_EXPORT_VAR(int) LINES = 0;
-NCURSES_EXPORT_VAR(int) COLS = 0;
-NCURSES_EXPORT_VAR(int) TABSIZE = 0;
-
 static void
 _nc_get_screensize(int *linep, int *colp)
 /* Obtain lines/columns values from the environment and/or terminfo entry */
@@ -199,7 +199,6 @@
     else
 	TABSIZE = 8;
     T(("TABSIZE = %d", TABSIZE));
-
 }
 
 #if USE_SIZECHANGE
@@ -241,7 +240,9 @@
 grab_entry(const char *const tn, TERMTYPE * const tp)
 /* return 1 if entry found, 0 if not found, -1 if database not accessible */
 {
+#if USE_DATABASE
     char filename[PATH_MAX];
+#endif
     int status;
 
     /*
@@ -275,7 +276,7 @@
      * a string is cancelled, for merging entries).
      */
     if (status == 1) {
-	int n;
+	unsigned n;
 	for_each_boolean(n, tp) {
 	    if (!VALID_BOOLEAN(tp->Booleans[n]))
 		tp->Booleans[n] = FALSE;
@@ -289,7 +290,82 @@
 }
 #endif
 
-NCURSES_EXPORT_VAR(char) ttytype[NAMESIZE] = "";
+/*
+**	do_prototype()
+**
+**	Take the real command character out of the CC environment variable
+**	and substitute it in for the prototype given in 'command_character'.
+**
+*/
+static void
+do_prototype(void)
+{
+    int i;
+    char CC;
+    char proto;
+    char *tmp;
+
+    tmp = getenv("CC");
+    CC = *tmp;
+    proto = *command_character;
+
+    for_each_string(i, &(cur_term->type)) {
+	for (tmp = cur_term->type.Strings[i]; *tmp; tmp++) {
+	    if (*tmp == proto)
+		*tmp = CC;
+	}
+    }
+}
+
+/*
+ * Check if we are running in a UTF-8 locale.
+ */
+NCURSES_EXPORT(char *)
+_nc_get_locale(void)
+{
+    char *env;
+    if (((env = getenv("LC_ALL")) != 0 && *env != '\0')
+	|| ((env = getenv("LC_CTYPE")) != 0 && *env != '\0')
+	|| ((env = getenv("LANG")) != 0 && *env != '\0')) {
+	return env;
+    }
+    return 0;
+}
+
+/*
+ * Check if we are running in a UTF-8 locale.
+ */
+NCURSES_EXPORT(int)
+_nc_unicode_locale(void)
+{
+    char *env = _nc_get_locale();
+    if (env != 0) {
+	if (strstr(env, ".UTF-8") != 0)
+	    return 1;
+    }
+    return 0;
+}
+
+/*
+ * Check for known broken cases where a UTF-8 locale breaks the alternate
+ * character set.
+ */
+NCURSES_EXPORT(int)
+_nc_locale_breaks_acs(void)
+{
+    char *env = getenv("TERM");
+    if (env != 0) {
+	if (strstr(env, "linux"))
+	    return 1;		/* always broken */
+	if (strstr(env, "screen") != 0
+	    && ((env = getenv("TERMCAP")) != 0
+		&& strstr(env, "screen") != 0)
+	    && strstr(env, "hhII00") != 0) {
+	    return 1;
+	}
+    }
+    return 0;
+}
 
 /*
  *	setupterm(termname, Filedes, errret)
@@ -302,7 +378,6 @@
 NCURSES_EXPORT(int)
 setupterm(NCURSES_CONST char *tname, int Filedes, int *errret)
 {
-    struct term *term_ptr;
     int status;
 
     START_TRACE();
@@ -321,77 +396,89 @@
 
     T(("your terminal name is %s", tname));
 
-    term_ptr = typeCalloc(TERMINAL, 1);
+    /*
+     * Allow output redirection.  This is what SVr3 does.  If stdout is
+     * directed to a file, screen updates go to standard error.
+     */
+    if (Filedes == STDOUT_FILENO && !isatty(Filedes))
+	Filedes = STDERR_FILENO;
 
-    if (term_ptr == 0) {
-	ret_error0(-1, "Not enough memory to create terminal structure.\n");
-    }
+    /*
+     * Check if we have already initialized to use this terminal.  If so, we
+     * do not need to re-read the terminfo entry, or obtain TTY settings.
+     *
+     * This is an improvement on SVr4 curses.  If an application mixes curses
+     * and termcap calls, it may call both initscr and tgetent.  This is not
+     * really a good thing to do, but can happen if someone tries using ncurses
+     * with the readline library.  The problem we are fixing is that when
+     * tgetent calls setupterm, the resulting Ottyb struct in cur_term is
+     * zeroed.  A subsequent call to endwin uses the zeroed terminal settings
+     * rather than the ones saved in initscr.  So we check if cur_term appears
+     * to contain terminal settings for the same output file as our current
+     * call - and copy those terminal settings.  (SVr4 curses does not do this,
+     * however applications that are working around the problem will still work
+     * properly with this feature).
+     */
+    if (cur_term != 0
+	&& cur_term->Filedes == Filedes
+	&& _nc_name_match(cur_term->type.term_names, tname, "|")) {
+	T(("reusing existing terminal information and mode-settings"));
+    } else {
+	TERMINAL *term_ptr;
+
+	term_ptr = typeCalloc(TERMINAL, 1);
+
+	if (term_ptr == 0) {
+	    ret_error0(-1,
+		       "Not enough memory to create terminal structure.\n");
+	}
 #if USE_DATABASE || USE_TERMCAP
-    status = grab_entry(tname, &term_ptr->type);
+	status = grab_entry(tname, &term_ptr->type);
 #else
-    status = 0;
+	status = 0;
 #endif
 
-    /* try fallback list if entry on disk */
-    if (status != 1) {
-	const TERMTYPE *fallback = _nc_fallback(tname);
-
-	if (fallback) {
-	    term_ptr->type = *fallback;
-	    status = 1;
+	/* try fallback list if entry on disk */
+	if (status != 1) {
+	    const TERMTYPE *fallback = _nc_fallback(tname);
+
+	    if (fallback) {
+		term_ptr->type = *fallback;
+		status = 1;
+	    }
 	}
-    }
 
-    if (status == -1) {
-	ret_error0(-1, "terminals database is inaccessible\n");
-    } else if (status == 0) {
-	ret_error(0, "'%s': unknown terminal type.\n", tname);
-    }
+	if (status == -1) {
+	    ret_error0(-1, "terminals database is inaccessible\n");
+	} else if (status == 0) {
+	    ret_error(0, "'%s': unknown terminal type.\n", tname);
+	}
 
-    /*
-     * Improve on SVr4 curses.  If an application mixes curses and termcap
-     * calls, it may call both initscr and tgetent.  This is not really a
-     * good thing to do, but can happen if someone tries using ncurses with
-     * the readline library.  The problem we are fixing is that when
-     * tgetent calls setupterm, the resulting Ottyb struct in cur_term is
-     * zeroed.  A subsequent call to endwin uses the zeroed terminal
-     * settings rather than the ones saved in initscr.  So we check if
-     * cur_term appears to contain terminal settings for the same output
-     * file as our current call - and copy those terminal settings.  (SVr4
-     * curses does not do this, however applications that are working
-     * around the problem will still work properly with this feature).
-     */
-    if (cur_term != 0) {
-	if (cur_term->Filedes == Filedes)
-	    term_ptr->Ottyb = cur_term->Ottyb;
-    }
+	set_curterm(term_ptr);
 
-    set_curterm(term_ptr);
+	if (command_character && getenv("CC"))
+	    do_prototype();
 
-    if (command_character && getenv("CC"))
-	do_prototype();
+	strncpy(ttytype, cur_term->type.term_names, NAMESIZE - 1);
+	ttytype[NAMESIZE - 1] = '\0';
 
-    strncpy(ttytype, cur_term->type.term_names, NAMESIZE - 1);
-    ttytype[NAMESIZE - 1] = '\0';
+	cur_term->Filedes = Filedes;
 
-    /*
-     * Allow output redirection.  This is what SVr3 does.  If stdout is
-     * directed to a file, screen updates go to standard error.
-     */
-    if (Filedes == STDOUT_FILENO && !isatty(Filedes))
-	Filedes = STDERR_FILENO;
-    cur_term->Filedes = Filedes;
+	/*
+	 * If an application calls setupterm() rather than initscr() or
+	 * newterm(), we will not have the def_prog_mode() call in
+	 * _nc_setupscreen().  Do it now anyway, so we can initialize the
+	 * baudrate.
+	 */
+	if (isatty(Filedes)) {
+	    def_prog_mode();
+	    baudrate();
+	}
+    }
 
     /*
-     * If an application calls setupterm() rather than initscr() or newterm(),
-     * we will not have the def_prog_mode() call in _nc_setupscreen().  Do it
-     * now anyway, so we can initialize the baudrate.
+     * We should always check the screensize, just in case.
      */
-    if (isatty(Filedes)) {
-	def_prog_mode();
-	baudrate();
-    }
-
     _nc_get_screensize(&LINES, &COLS);
 
     if (errret)
@@ -406,32 +493,4 @@
 	ret_error(1, "'%s': I can't handle hardcopy terminals.\n", tname);
     }
     returnCode(OK);
-}
-
-/*
-**	do_prototype()
-**
-**	Take the real command character out of the CC environment variable
-**	and substitute it in for the prototype given in 'command_character'.
-**
-*/
-
-static void
-do_prototype(void)
-{
-    int i;
-    char CC;
-    char proto;
-    char *tmp;
-
-    tmp = getenv("CC");
-    CC = *tmp;
-    proto = *command_character;
-
-    for_each_string(i, &(cur_term->type)) {
-	for (tmp = cur_term->type.Strings[i]; *tmp; tmp++) {
-	    if (*tmp == proto)
-		*tmp = CC;
-	}
-    }
 }
Index: ncurses/tinfo/lib_termcap.c
Prereq:  1.43 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_termcap.c	Sat May 25 08:24:13 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_termcap.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -43,7 +43,7 @@
 
 #include <term_entry.h>
 
-MODULE_ID("$Id: lib_termcap.c,v 1.43 2002/05/25 12:24:13 tom Exp $")
+MODULE_ID("$Id: lib_termcap.c,v 1.44 2003/05/24 21:10:28 tom Exp $")
 
 #define CSI       233
 #define ESC       033		/* ^[ */
@@ -233,7 +233,7 @@
 NCURSES_EXPORT(int)
 tgetflag(NCURSES_CONST char *id)
 {
-    int i;
+    unsigned i;
 
     T((T_CALLED("tgetflag(%s)"), id));
     if (cur_term != 0) {
@@ -261,7 +261,7 @@
 NCURSES_EXPORT(int)
 tgetnum(NCURSES_CONST char *id)
 {
-    int i;
+    unsigned i;
 
     T((T_CALLED("tgetnum(%s)"), id));
     if (cur_term != 0) {
@@ -290,7 +290,7 @@
 NCURSES_EXPORT(char *)
 tgetstr(NCURSES_CONST char *id, char **area)
 {
-    int i;
+    unsigned i;
     char *result = NULL;
 
     T((T_CALLED("tgetstr(%s,%p)"), id, area));
Index: ncurses/tinfo/lib_ti.c
Prereq:  1.22 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_ti.c	Sat Dec  9 21:55:08 2000
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_ti.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,1999,2000 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2000,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -36,12 +36,12 @@
 #include <term_entry.h>
 #include <tic.h>
 
-MODULE_ID("$Id: lib_ti.c,v 1.22 2000/12/10 02:55:08 tom Exp $")
+MODULE_ID("$Id: lib_ti.c,v 1.23 2003/05/24 21:10:28 tom Exp $")
 
 NCURSES_EXPORT(int)
 tigetflag(NCURSES_CONST char *str)
 {
-    int i;
+    unsigned i;
 
     T((T_CALLED("tigetflag(%s)"), str));
 
@@ -62,7 +62,7 @@
 NCURSES_EXPORT(int)
 tigetnum(NCURSES_CONST char *str)
 {
-    int i;
+    unsigned i;
 
     T((T_CALLED("tigetnum(%s)"), str));
 
@@ -84,7 +84,7 @@
 NCURSES_EXPORT(char *)
 tigetstr(NCURSES_CONST char *str)
 {
-    int i;
+    unsigned i;
 
     T((T_CALLED("tigetstr(%s)"), str));
 
Index: ncurses/tinfo/lib_tparm.c
Prereq:  1.62 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_tparm.c	Sat Oct  5 15:33:24 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_tparm.c	Sat May 24 16:18:50 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -43,7 +43,7 @@
 #include <term.h>
 #include <tic.h>
 
-MODULE_ID("$Id: lib_tparm.c,v 1.62 2002/10/05 19:33:24 Frank.Henigman Exp $")
+MODULE_ID("$Id: lib_tparm.c,v 1.67 2003/05/24 20:18:50 tom Exp $")
 
 /*
  *	char *
@@ -129,6 +129,9 @@
 static size_t out_size;
 static size_t out_used;
 
+static char *fmt_buff;
+static size_t fmt_size;
+
 #if NO_LEAKS
 NCURSES_EXPORT(void)
 _nc_free_tparm(void)
@@ -137,6 +140,8 @@
 	FreeAndNull(out_buff);
 	out_size = 0;
 	out_used = 0;
+	FreeAndNull(fmt_buff);
+	fmt_size = 0;
     }
 }
 #endif
@@ -247,153 +252,136 @@
 static inline const char *
 parse_format(const char *s, char *format, int *len)
 {
-    bool done = FALSE;
-    bool allowminus = FALSE;
-    bool dot = FALSE;
-    bool err = FALSE;
-    char *fmt = format;
-    int my_width = 0;
-    int my_prec = 0;
-    int value = 0;
-
     *len = 0;
-    *format++ = '%';
-    while (*s != '\0' && !done) {
-	switch (*s) {
-	case 'c':		/* FALLTHRU */
-	case 'd':		/* FALLTHRU */
-	case 'o':		/* FALLTHRU */
-	case 'x':		/* FALLTHRU */
-	case 'X':		/* FALLTHRU */
-	case 's':
-	    *format++ = *s;
-	    done = TRUE;
-	    break;
-	case '.':
-	    *format++ = *s++;
-	    if (dot) {
-		err = TRUE;
-	    } else {		/* value before '.' is the width */
-		dot = TRUE;
-		my_width = value;
-	    }
-	    value = 0;
-	    break;
-	case '#':
-	    *format++ = *s++;
-	    break;
-	case ' ':
-	    *format++ = *s++;
-	    break;
-	case ':':
-	    s++;
-	    allowminus = TRUE;
-	    break;
-	case '-':
-	    if (allowminus) {
-		*format++ = *s++;
-	    } else {
+    if (format != 0) {
+	bool done = FALSE;
+	bool allowminus = FALSE;
+	bool dot = FALSE;
+	bool err = FALSE;
+	char *fmt = format;
+	int my_width = 0;
+	int my_prec = 0;
+	int value = 0;
+
+	*len = 0;
+	*format++ = '%';
+	while (*s != '\0' && !done) {
+	    switch (*s) {
+	    case 'c':		/* FALLTHRU */
+	    case 'd':		/* FALLTHRU */
+	    case 'o':		/* FALLTHRU */
+	    case 'x':		/* FALLTHRU */
+	    case 'X':		/* FALLTHRU */
+	    case 's':
+		*format++ = *s;
 		done = TRUE;
-	    }
-	    break;
-	default:
-	    if (isdigit(UChar(*s))) {
-		value = (value * 10) + (*s - '0');
-		if (value > 10000)
+		break;
+	    case '.':
+		*format++ = *s++;
+		if (dot) {
 		    err = TRUE;
+		} else {	/* value before '.' is the width */
+		    dot = TRUE;
+		    my_width = value;
+		}
+		value = 0;
+		break;
+	    case '#':
 		*format++ = *s++;
-	    } else {
-		done = TRUE;
+		break;
+	    case ' ':
+		*format++ = *s++;
+		break;
+	    case ':':
+		s++;
+		allowminus = TRUE;
+		break;
+	    case '-':
+		if (allowminus) {
+		    *format++ = *s++;
+		} else {
+		    done = TRUE;
+		}
+		break;
+	    default:
+		if (isdigit(UChar(*s))) {
+		    value = (value * 10) + (*s - '0');
+		    if (value > 10000)
+			err = TRUE;
+		    *format++ = *s++;
+		} else {
+		    done = TRUE;
+		}
 	    }
 	}
-    }
 
-    /*
-     * If we found an error, ignore (and remove) the flags.
-     */
-    if (err) {
-	my_width = my_prec = value = 0;
-	format = fmt;
-	*format++ = '%';
-	*format++ = *s;
-    }
+	/*
+	 * If we found an error, ignore (and remove) the flags.
+	 */
+	if (err) {
+	    my_width = my_prec = value = 0;
+	    format = fmt;
+	    *format++ = '%';
+	    *format++ = *s;
+	}
 
-    /*
-     * Any value after '.' is the precision.  If we did not see '.', then
-     * the value is the width.
-     */
-    if (dot)
-	my_prec = value;
-    else
-	my_width = value;
-
-    *format = '\0';
-    /* return maximum string length in print */
-    *len = (my_width > my_prec) ? my_width : my_prec;
+	/*
+	 * Any value after '.' is the precision.  If we did not see '.', then
+	 * the value is the width.
+	 */
+	if (dot)
+	    my_prec = value;
+	else
+	    my_width = value;
+
+	*format = '\0';
+	/* return maximum string length in print */
+	*len = (my_width > my_prec) ? my_width : my_prec;
+    }
     return s;
 }
 
 #define isUPPER(c) ((c) >= 'A' && (c) <= 'Z')
 #define isLOWER(c) ((c) >= 'a' && (c) <= 'z')
 
-static inline char *
-tparam_internal(const char *string, va_list ap)
+/*
+ * Analyze the string to see how many parameters we need from the varargs list,
+ * and what their types are.  We will only accept string parameters if they
+ * appear as a %l or %s format following an explicit parameter reference (e.g.,
+ * %p2%s).  All other parameters are numbers.
+ *
+ * 'number' counts coarsely the number of pop's we see in the string, and
+ * 'popcount' shows the highest parameter number in the string.  We would like
+ * to simply use the latter count, but if we are reading termcap strings, there
+ * may be cases that we cannot see the explicit parameter numbers.
+ */
+NCURSES_EXPORT(int)
+_nc_tparm_analyze(const char *string, char *p_is_s[NUM_PARM], int *popcount)
 {
-#define NUM_VARS 26
-    char *p_is_s[9];
-    long param[9];
-    int lastpop;
-    int popcount;
-    int number;
-    int len;
-    int level;
-    int x, y;
-    int i;
     size_t len2;
-    register const char *cp;
-    static size_t len_fmt;
+    int i;
+    int lastpop = -1;
+    int len;
+    int number = 0;
+    const char *cp = string;
     static char dummy[] = "";
-    static char *format;
-    static int dynamic_var[NUM_VARS];
-    static int static_vars[NUM_VARS];
 
-    out_used = 0;
-    if (string == NULL)
-	return NULL;
+    if (cp == 0)
+	return 0;
 
-    if ((len2 = strlen(string)) > len_fmt) {
-	len_fmt = len2 + len_fmt + 2;
-	if ((format = typeRealloc(char, len_fmt, format)) == 0)
+    if ((len2 = strlen(cp)) > fmt_size) {
+	fmt_size = len2 + fmt_size + 2;
+	if ((fmt_buff = typeRealloc(char, fmt_size, fmt_buff)) == 0)
 	      return 0;
     }
 
-    /*
-     * Find the highest parameter-number referred to in the format string.
-     * Use this value to limit the number of arguments copied from the
-     * variable-length argument list.
-     */
-
-    number = 0;
-    lastpop = -1;
-    popcount = 0;
-    memset(p_is_s, 0, sizeof(p_is_s));
+    memset(p_is_s, 0, sizeof(p_is_s[0]) * NUM_PARM);
+    *popcount = 0;
 
-    /*
-     * Analyze the string to see how many parameters we need from the varargs
-     * list, and what their types are.  We will only accept string parameters
-     * if they appear as a %l or %s format following an explicit parameter
-     * reference (e.g., %p2%s).  All other parameters are numbers.
-     *
-     * 'number' counts coarsely the number of pop's we see in the string, and
-     * 'popcount' shows the highest parameter number in the string.  We would
-     * like to simply use the latter count, but if we are reading termcap
-     * strings, there may be cases that we cannot see the explicit parameter
-     * numbers.
-     */
-    for (cp = string; (cp - string) < (int) len2;) {
+    while ((cp - string) < (int) len2) {
 	if (*cp == '%') {
 	    cp++;
-	    cp = parse_format(cp, format, &len);
+	    cp = parse_format(cp, fmt_buff, &len);
 	    switch (*cp) {
 	    default:
 		break;
@@ -416,11 +404,11 @@
 
 	    case 'p':
 		cp++;
-		i = (*cp - '0');
-		if (i >= 0 && i <= 9) {
+		i = (UChar(*cp) - '0');
+		if (i >= 0 && i <= NUM_PARM) {
 		    lastpop = i;
-		    if (lastpop > popcount)
-			popcount = lastpop;
+		    if (lastpop > *popcount)
+			*popcount = lastpop;
 		}
 		break;
 
@@ -440,7 +428,7 @@
 
 	    case L_BRACE:
 		cp++;
-		while (*cp >= '0' && *cp <= '9') {
+		while (isdigit(UChar(*cp))) {
 		    cp++;
 		}
 		break;
@@ -470,8 +458,8 @@
 
 	    case 'i':
 		lastpop = -1;
-		if (popcount < 2)
-		    popcount = 2;
+		if (*popcount < 2)
+		    *popcount = 2;
 		break;
 	    }
 	}
@@ -479,8 +467,43 @@
 	    cp++;
     }
 
-    if (number > 9)
-	number = 9;
+    if (number > NUM_PARM)
+	number = NUM_PARM;
+    return number;
+}
+
+static inline char *
+tparam_internal(const char *string, va_list ap)
+{
+#define NUM_VARS 26
+    char *p_is_s[NUM_PARM];
+    long param[NUM_PARM];
+    int popcount;
+    int number;
+    int len;
+    int level;
+    int x, y;
+    int i;
+    const char *cp = string;
+    size_t len2;
+    static int dynamic_var[NUM_VARS];
+    static int static_vars[NUM_VARS];
+
+    if (cp == NULL)
+	return NULL;
+
+    out_used = 0;
+    len2 = strlen(cp);
+
+    /*
+     * Find the highest parameter-number referred to in the format string.
+     * Use this value to limit the number of arguments copied from the
+     * variable-length argument list.
+     */
+    number = _nc_tparm_analyze(cp, p_is_s, &popcount);
+    if (fmt_buff == 0)
+	return NULL;
+
     for (i = 0; i < max(popcount, number); i++) {
 	/*
 	 * A few caps (such as plab_norm) have string-valued parms.
@@ -517,18 +540,18 @@
 	    else
 		save_number(", %d", param[i], 0);
 	}
-	_tracef(T_CALLED("%s(%s%s)"), tname, _nc_visbuf(string), out_buff);
+	_tracef(T_CALLED("%s(%s%s)"), tname, _nc_visbuf(cp), out_buff);
 	out_used = 0;
     }
 #endif /* TRACE */
 
-    while (*string) {
-	if (*string != '%') {
-	    save_char(*string);
+    while ((cp - string) < (int) len2) {
+	if (*cp != '%') {
+	    save_char(UChar(*cp));
 	} else {
-	    tparam_base = string++;
-	    string = parse_format(string, format, &len);
-	    switch (*string) {
+	    tparam_base = cp++;
+	    cp = parse_format(cp, fmt_buff, &len);
+	    switch (*cp) {
 	    default:
 		break;
 	    case '%':
@@ -539,7 +562,7 @@
 	    case 'o':		/* FALLTHRU */
 	    case 'x':		/* FALLTHRU */
 	    case 'X':		/* FALLTHRU */
-		save_number(format, npop(), len);
+		save_number(fmt_buff, npop(), len);
 		break;
 
 	    case 'c':		/* FALLTHRU */
@@ -551,13 +574,13 @@
 		break;
 
 	    case 's':
-		save_text(format, spop(), len);
+		save_text(fmt_buff, spop(), len);
 		break;
 
 	    case 'p':
-		string++;
-		i = (*string - '1');
-		if (i >= 0 && i < 9) {
+		cp++;
+		i = (UChar(*cp) - '1');
+		if (i >= 0 && i < NUM_PARM) {
 		    if (p_is_s[i])
 			spush(p_is_s[i]);
 		    else
@@ -566,39 +589,39 @@
 		break;
 
 	    case 'P':
-		string++;
-		if (isUPPER(*string)) {
-		    i = (*string - 'A');
+		cp++;
+		if (isUPPER(*cp)) {
+		    i = (UChar(*cp) - 'A');
 		    static_vars[i] = npop();
-		} else if (isLOWER(*string)) {
-		    i = (*string - 'a');
+		} else if (isLOWER(*cp)) {
+		    i = (UChar(*cp) - 'a');
 		    dynamic_var[i] = npop();
 		}
 		break;
 
 	    case 'g':
-		string++;
-		if (isUPPER(*string)) {
-		    i = (*string - 'A');
+		cp++;
+		if (isUPPER(*cp)) {
+		    i = (UChar(*cp) - 'A');
 		    npush(static_vars[i]);
-		} else if (isLOWER(*string)) {
-		    i = (*string - 'a');
+		} else if (isLOWER(*cp)) {
+		    i = (UChar(*cp) - 'a');
 		    npush(dynamic_var[i]);
 		}
 		break;
 
 	    case S_QUOTE:
-		string++;
-		npush(*string);
-		string++;
+		cp++;
+		npush(UChar(*cp));
+		cp++;
 		break;
 
 	    case L_BRACE:
 		number = 0;
-		string++;
-		while (*string >= '0' && *string <= '9') {
-		    number = number * 10 + *string - '0';
-		    string++;
+		cp++;
+		while (isdigit(UChar(*cp))) {
+		    number = (number * 10) + (UChar(*cp) - '0');
+		    cp++;
 		}
 		npush(number);
 		break;
@@ -689,38 +712,38 @@
 		x = npop();
 		if (!x) {
 		    /* scan forward for %e or %; at level zero */
-		    string++;
+		    cp++;
 		    level = 0;
-		    while (*string) {
-			if (*string == '%') {
-			    string++;
-			    if (*string == '?')
+		    while (*cp) {
+			if (*cp == '%') {
+			    cp++;
+			    if (*cp == '?')
 				level++;
-			    else if (*string == ';') {
+			    else if (*cp == ';') {
 				if (level > 0)
 				    level--;
 				else
 				    break;
-			    } else if (*string == 'e' && level == 0)
+			    } else if (*cp == 'e' && level == 0)
 				break;
 			}
 
-			if (*string)
-			    string++;
+			if (*cp)
+			    cp++;
 		    }
 		}
 		break;
 
 	    case 'e':
 		/* scan forward for a %; at level zero */
-		string++;
+		cp++;
 		level = 0;
-		while (*string) {
-		    if (*string == '%') {
-			string++;
-			if (*string == '?')
+		while (*cp) {
+		    if (*cp == '%') {
+			cp++;
+			if (*cp == '?')
 			    level++;
-			else if (*string == ';') {
+			else if (*cp == ';') {
 			    if (level > 0)
 				level--;
 			    else
@@ -728,22 +751,22 @@
 			}
 		    }
 
-		    if (*string)
-			string++;
+		    if (*cp)
+			cp++;
 		}
 		break;
 
 	    case ';':
 		break;
 
-	    }			/* endswitch (*string) */
-	}			/* endelse (*string == '%') */
+	    }			/* endswitch (*cp) */
+	}			/* endelse (*cp == '%') */
 
-	if (*string == '\0')
+	if (*cp == '\0')
 	    break;
 
-	string++;
-    }				/* endwhile (*string) */
+	cp++;
+    }				/* endwhile (*cp) */
 
     get_space(1);
     out_buff[out_used] = '\0';
Index: ncurses/tinfo/lib_tputs.c
Prereq:  1.60 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_tputs.c	Sat Aug 17 19:44:08 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_tputs.c	Sat Jun 14 17:10:44 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -45,7 +45,7 @@
 #include <termcap.h>		/* ospeed */
 #include <tic.h>
 
-MODULE_ID("$Id: lib_tputs.c,v 1.60 2002/08/17 23:44:08 tom Exp $")
+MODULE_ID("$Id: lib_tputs.c,v 1.61 2003/06/14 21:10:44 tom Exp $")
 
 NCURSES_EXPORT_VAR(char) PC = 0;		/* used by termcap library */
 NCURSES_EXPORT_VAR(NCURSES_OSPEED) ospeed = 0;	/* used by termcap library */
@@ -84,9 +84,7 @@
 NCURSES_EXPORT(int)
 _nc_outch(int ch)
 {
-#ifdef TRACE
-    _nc_outchars++;
-#endif /* TRACE */
+    TRACE_OUTCHARS(1);
 
     if (SP != 0
 	&& SP->_cleanup) {
Index: ncurses/tinfo/lib_ttyflags.c
Prereq:  1.9 
--- ncurses-5.3-20021012/ncurses/tinfo/lib_ttyflags.c	Sat Oct 12 17:28:16 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/lib_ttyflags.c	Sat May 17 19:50:37 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -38,7 +38,7 @@
 #include <curses.priv.h>
 #include <term.h>		/* cur_term */
 
-MODULE_ID("$Id: lib_ttyflags.c,v 1.9 2002/10/12 21:28:16 tom Exp $")
+MODULE_ID("$Id: lib_ttyflags.c,v 1.11 2003/05/17 23:50:37 tom Exp $")
 
 #undef tabs
 
@@ -60,8 +60,10 @@
 _nc_get_tty_mode(TTY * buf)
 {
     if (cur_term == 0
-	|| GET_TTY(cur_term->Filedes, buf) != 0)
+	|| GET_TTY(cur_term->Filedes, buf) != 0) {
+	memset(buf, 0, sizeof(*buf));
 	return (ERR);
+    }
     TR(TRACE_BITS, ("_nc_get_tty_mode(%d): %s",
 		    cur_term->Filedes, _nc_trace_ttymode(buf)));
     return (OK);
@@ -71,8 +73,11 @@
 _nc_set_tty_mode(TTY * buf)
 {
     if (cur_term == 0
-	|| SET_TTY(cur_term->Filedes, buf) != 0)
+	|| SET_TTY(cur_term->Filedes, buf) != 0) {
+	if ((errno == ENOTTY) && (SP != 0))
+	    SP->_notty = TRUE;
 	return (ERR);
+    }
     TR(TRACE_BITS, ("_nc_set_tty_mode(%d): %s",
 		    cur_term->Filedes, _nc_trace_ttymode(buf)));
     return (OK);
Index: ncurses/tinfo/parse_entry.c
Prereq:  1.57 
--- ncurses-5.3-20021012/ncurses/tinfo/parse_entry.c	Sat Aug 31 13:02:02 2002
+++ ncurses-5.3-20030719/ncurses/tinfo/parse_entry.c	Sat May 24 18:51:38 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -47,7 +47,7 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: parse_entry.c,v 1.57 2002/08/31 17:02:02 tom Exp $")
+MODULE_ID("$Id: parse_entry.c,v 1.58 2003/05/24 22:51:38 tom Exp $")
 
 #ifdef LINT
 static short const parametrized[] =
@@ -196,8 +196,7 @@
  */
 
 NCURSES_EXPORT(int)
-_nc_parse_entry
-(struct entry *entryp, int literal, bool silent)
+_nc_parse_entry(struct entry *entryp, int literal, bool silent)
 {
     int token_type;
     struct name_table_entry const *entry_ptr;
@@ -217,11 +216,21 @@
     entryp->startline = _nc_start_line;
     DEBUG(2, ("Comment range is %ld to %ld", entryp->cstart, entryp->cend));
 
-    /* junk the 2-character termcap name, if present */
+    /*
+     * Strip off the 2-character termcap name, if present.  Originally termcap
+     * used that as an indexing aid.  We can retain 2-character terminfo names,
+     * but note that they would be lost if we translate to/from termcap.  This
+     * feature is supposedly obsolete since "newer" BSD implementations do not
+     * use it; however our reference for this feature is SunOS 4.x, which
+     * implemented it.  Note that the resulting terminal type was never the
+     * 2-character name, but was instead the first alias after that.
+     */
     ptr = _nc_curr_token.tk_name;
-    if (ptr[2] == '|') {
-	ptr = _nc_curr_token.tk_name + 3;
-	_nc_curr_token.tk_name[2] = '\0';
+    if (_nc_syntax == SYN_TERMCAP) {
+	if (ptr[2] == '|') {
+	    ptr += 3;
+	    _nc_curr_token.tk_name[2] = '\0';
+	}
     }
 
     entryp->tterm.str_table = entryp->tterm.term_names = _nc_save_str(ptr);
Index: ncurses/tinfo/read_entry.c
Prereq:  1.72 
--- ncurses-5.3-20021012/ncurses/tinfo/read_entry.c	Sat Dec  9 21:55:08 2000
+++ ncurses-5.3-20030719/ncurses/tinfo/read_entry.c	Sat Jul  5 15:31:51 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,1999,2000 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -29,6 +29,7 @@
 /****************************************************************************
  *  Author: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
+ *     and: Thomas E. Dickey                                                *
  ****************************************************************************/
 
 /*
@@ -41,10 +42,10 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: read_entry.c,v 1.72 2000/12/10 02:55:08 tom Exp $")
+MODULE_ID("$Id: read_entry.c,v 1.76 2003/07/05 19:31:51 tom Exp $")
 
 #if !HAVE_TELL
-#define tell(fd) 0		/* lseek() is POSIX, but not tell() - odd... */
+#define tell(fd) lseek(fd, 0, SEEK_CUR)		/* lseek() is POSIX, but not tell() */
 #endif
 
 /*
@@ -156,9 +157,10 @@
 {
     int name_size, bool_count, num_count, str_count, str_size;
     int i;
-    char buf[MAX_ENTRY_SIZE];
+    char buf[MAX_ENTRY_SIZE + 1];
+    unsigned want, have;
 
-    TR(TRACE_DATABASE, ("READ termtype header @%d", tell(fd)));
+    TR(TRACE_DATABASE, ("READ termtype header @%ld", (long) tell(fd)));
 
     memset(ptr, 0, sizeof(*ptr));
 
@@ -197,16 +199,19 @@
 	str_count = 0;
     }
 
-    /* grab the name (a null-terminate string) */
-    read(fd, buf, min(MAX_NAME_SIZE, (unsigned) name_size));
-    buf[MAX_NAME_SIZE] = '\0';
+    /* grab the name (a null-terminated string) */
+    want = min(MAX_NAME_SIZE, (unsigned) name_size);
+    if ((have = read(fd, buf, want)) != want) {
+	memset(buf + have, 0, want - have);
+    }
+    buf[want] = '\0';
     ptr->term_names = typeCalloc(char, strlen(buf) + 1);
     if (ptr->term_names == NULL) {
 	return (0);
     }
     (void) strcpy(ptr->term_names, buf);
-    if (name_size > MAX_NAME_SIZE)
-	lseek(fd, (off_t) (name_size - MAX_NAME_SIZE), 1);
+    if (have > MAX_NAME_SIZE)
+	lseek(fd, (off_t) (have - MAX_NAME_SIZE), 1);
 
     /* grab the booleans */
     if ((ptr->Booleans = typeCalloc(char, max(BOOLCOUNT, bool_count))) == 0
@@ -252,7 +257,7 @@
      * Read extended entries, if any, after the normal end of terminfo data.
      */
     even_boundary(str_size);
-    TR(TRACE_DATABASE, ("READ extended_header @%d", tell(fd)));
+    TR(TRACE_DATABASE, ("READ extended_header @%ld", (long) tell(fd)));
     if (_nc_user_definable && read_shorts(fd, buf, 5)) {
 	int ext_bool_count = LOW_MSB(buf + 0);
 	int ext_num_count = LOW_MSB(buf + 2);
@@ -284,8 +289,8 @@
 			    ext_bool_count, ext_num_count, ext_str_count,
 			    ext_str_size, ext_str_limit));
 
-	TR(TRACE_DATABASE, ("READ %d extended-booleans @%d",
-			    ext_bool_count, tell(fd)));
+	TR(TRACE_DATABASE, ("READ %d extended-booleans @%ld",
+			    ext_bool_count, (long) tell(fd)));
 	if ((ptr->ext_Booleans = ext_bool_count) != 0) {
 	    if (read(fd, ptr->Booleans + BOOLCOUNT, (unsigned)
 		     ext_bool_count) != ext_bool_count)
@@ -293,8 +298,8 @@
 	}
 	even_boundary(ext_bool_count);
 
-	TR(TRACE_DATABASE, ("READ %d extended-numbers @%d",
-			    ext_num_count, tell(fd)));
+	TR(TRACE_DATABASE, ("READ %d extended-numbers @%ld",
+			    ext_num_count, (long) tell(fd)));
 	if ((ptr->ext_Numbers = ext_num_count) != 0) {
 	    if (!read_shorts(fd, buf, ext_num_count))
 		return (0);
@@ -302,13 +307,13 @@
 	    convert_shorts(buf, ptr->Numbers + NUMCOUNT, ext_num_count);
 	}
 
-	TR(TRACE_DATABASE, ("READ extended-offsets @%d", tell(fd)));
+	TR(TRACE_DATABASE, ("READ extended-offsets @%ld", (long) tell(fd)));
 	if ((ext_str_count || need)
 	    && !read_shorts(fd, buf, ext_str_count + need))
 	    return (0);
 
-	TR(TRACE_DATABASE, ("READ %d bytes of extended-strings @%d",
-			    ext_str_limit, tell(fd)));
+	TR(TRACE_DATABASE, ("READ %d bytes of extended-strings @%ld",
+			    ext_str_limit, (long) tell(fd)));
 
 	if (ext_str_limit) {
 	    if ((ptr->ext_str_table = typeMalloc(char, ext_str_limit)) == 0)
@@ -374,8 +379,7 @@
 }
 
 NCURSES_EXPORT(int)
-_nc_read_file_entry
-(const char *const filename, TERMTYPE * ptr)
+_nc_read_file_entry(const char *const filename, TERMTYPE * ptr)
 /* return 1 if read, 0 if not found or garbled */
 {
     int code, fd = -1;
@@ -458,13 +462,20 @@
  */
 
 NCURSES_EXPORT(int)
-_nc_read_entry
-(const char *const tn, char *const filename, TERMTYPE * const tp)
+_nc_read_entry(const char *const tn, char *const filename, TERMTYPE * const tp)
 {
     char *envp;
     char ttn[MAX_ALIAS + 3];
 
-    /* truncate the terminal name to prevent dangerous buffer airline */
+    if (strlen(tn) == 0
+	|| strcmp(tn, ".") == 0
+	|| strcmp(tn, "..") == 0
+	|| _nc_pathlast(tn) != 0) {
+	T(("illegal or missing entry name '%s'", tn));
+	return 0;
+    }
+
+    /* truncate the terminal name to prevent buffer overflow */
     (void) sprintf(ttn, "%c/%.*s", *tn, MAX_ALIAS, tn);
 
     /* This is System V behavior, in conjunction with our requirements for
@@ -482,7 +493,7 @@
 	/* this is an ncurses extension */
 	if ((envp = _nc_home_terminfo()) != 0) {
 	    if (_nc_read_tic_entry(filename, envp, ttn, tp) == 1) {
-		return (1);
+		return 1;
 	    }
 	}
 
Index: ncurses/tinfo/read_termcap.c
Prereq:  1.58 
--- ncurses-5.3-20021012/ncurses/tinfo/read_termcap.c	Sat Oct 27 21:11:34 2001
+++ ncurses-5.3-20030719/ncurses/tinfo/read_termcap.c	Sat Jul  5 15:31:16 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998,1999,2000,2001 Free Software Foundation, Inc.         *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -57,7 +57,7 @@
 #include <tic.h>
 #include <term_entry.h>
 
-MODULE_ID("$Id: read_termcap.c,v 1.58 2001/10/28 01:11:34 tom Exp $")
+MODULE_ID("$Id: read_termcap.c,v 1.60 2003/07/05 19:31:16 tom Exp $")
 
 #if !PURE_TERMINFO
 
@@ -945,6 +945,15 @@
     static int lineno;
 
     T(("read termcap entry for %s", tn));
+
+    if (strlen(tn) == 0
+	|| strcmp(tn, ".") == 0
+	|| strcmp(tn, "..") == 0
+	|| _nc_pathlast(tn) != 0) {
+	T(("illegal or missing entry name '%s'", tn));
+	return 0;
+    }
+
     if (use_terminfo_vars() && (p = getenv("TERMCAP")) != 0
 	&& !is_pathname(p) && _nc_name_match(p, tn, "|:")) {
 	/* TERMCAP holds a termcap entry */
Index: ncurses/trace/lib_traceatr.c
Prereq:  1.43 
--- ncurses-5.3-20021012/ncurses/trace/lib_traceatr.c	Sat Sep 28 08:37:03 2002
+++ ncurses-5.3-20030719/ncurses/trace/lib_traceatr.c	Sat Jun 28 19:20:26 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
  ****************************************************************************/
 
 /****************************************************************************
- *  Author: Thomas Dickey 1996-2001                                         *
+ *  Author: Thomas Dickey 1996-2003                                         *
  *     and: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
  ****************************************************************************/
@@ -39,7 +39,7 @@
 #include <curses.priv.h>
 #include <term.h>		/* acs_chars */
 
-MODULE_ID("$Id: lib_traceatr.c,v 1.43 2002/09/28 12:37:03 tom Exp $")
+MODULE_ID("$Id: lib_traceatr.c,v 1.47 2003/06/28 23:20:26 tom Exp $")
 
 #define COLOR_OF(c) (c < 0 || c > 7 ? "default" : colors[c].name)
 
@@ -52,7 +52,7 @@
 _traceattr2(int bufnum, attr_t newmode)
 {
     char *buf = _nc_trace_buf(bufnum, BUFSIZ);
-    char *tmp = buf;
+    char temp[80];
     static const struct {
 	unsigned int val;
 	const char *name;
@@ -92,39 +92,39 @@
     unsigned save_nc_tracing = _nc_tracing;
     _nc_tracing = 0;
 
-    strcpy(tmp++, l_brace);
+    strcpy(buf, l_brace);
 
     for (n = 0; n < SIZEOF(names); n++) {
 	if ((newmode & names[n].val) != 0) {
 	    if (buf[1] != '\0')
-		strcat(tmp, "|");
-	    strcat(tmp, names[n].name);
-	    tmp += strlen(tmp);
+		buf = _nc_trace_bufcat(bufnum, "|");
+	    buf = _nc_trace_bufcat(bufnum, names[n].name);
 
 	    if (names[n].val == A_COLOR) {
 		short pairnum = PAIR_NUMBER(newmode);
 		short fg, bg;
 
-		if (pair_content(pairnum, &fg, &bg) == OK)
-		    (void) sprintf(tmp,
+		if (pair_content(pairnum, &fg, &bg) == OK) {
+		    (void) sprintf(temp,
 				   "{%d = {%s, %s}}",
 				   pairnum,
 				   COLOR_OF(fg),
-				   COLOR_OF(bg)
-			);
-		else
-		    (void) sprintf(tmp, "{%d}", pairnum);
+				   COLOR_OF(bg));
+		} else {
+		    (void) sprintf(temp, "{%d}", pairnum);
+		}
+		buf = _nc_trace_bufcat(bufnum, temp);
 	    }
 	}
     }
     if (ChAttrOf(newmode) == A_NORMAL) {
 	if (buf[1] != '\0')
-	    strcat(tmp, "|");
-	strcat(tmp, "A_NORMAL");
+	    (void) _nc_trace_bufcat(bufnum, "|");
+	(void) _nc_trace_bufcat(bufnum, "A_NORMAL");
     }
 
     _nc_tracing = save_nc_tracing;
-    return (strcat(buf, r_brace));
+    return (_nc_trace_bufcat(bufnum, r_brace));
 }
 
 NCURSES_EXPORT(char *)
@@ -146,7 +146,7 @@
 {
     const char *result = 0;
 
-    if (attr & A_ALTCHARSET) {
+    if ((attr & A_ALTCHARSET) && (acs_chars != 0)) {
 	char *cp;
 	char *found = 0;
 	static const struct {
@@ -214,20 +214,21 @@
 NCURSES_EXPORT(char *)
 _tracechtype2(int bufnum, chtype ch)
 {
-    char *buf = _nc_trace_buf(bufnum, BUFSIZ);
     const char *found;
 
-    strcpy(buf, l_brace);
+    strcpy(_nc_trace_buf(bufnum, BUFSIZ), l_brace);
     if ((found = _nc_altcharset_name(ChAttrOf(ch), ch)) != 0) {
-	(void) strcat(buf, found);
+	(void) _nc_trace_bufcat(bufnum, found);
     } else
-	(void) strcat(buf, _tracechar(ChCharOf(ch)));
+	(void) _nc_trace_bufcat(bufnum, _tracechar(ChCharOf(ch)));
 
-    if (ChAttrOf(ch) != A_NORMAL)
-	(void) sprintf(buf + strlen(buf), " | %s",
+    if (ChAttrOf(ch) != A_NORMAL) {
+	(void) _nc_trace_bufcat(bufnum, " | ");
+	(void) _nc_trace_bufcat(bufnum,
 		_traceattr2(bufnum + 20, ChAttrOf(ch)));
+    }
 
-    return (strcat(buf, r_brace));
+    return (_nc_trace_bufcat(bufnum, r_brace));
 }
 
 NCURSES_EXPORT(char *)
@@ -256,15 +257,16 @@
     if (ch != 0) {
 	attr = AttrOfD(ch);
 	if ((found = _nc_altcharset_name(attr, CharOfD(ch))) != 0) {
-	    (void) strcat(buf, found);
+	    (void) _nc_trace_bufcat(bufnum, found);
 	    attr &= ~A_ALTCHARSET;
-	} else if (!isnac(CHDEREF(ch))) {
+	} else if (isnac(CHDEREF(ch))) {
+	    (void) _nc_trace_bufcat(bufnum, "{NAC}");
+	} else {
 	    PUTC_DATA;
 	    int n;
 
-	    memset (&PUT_st, '\0', sizeof (PUT_st));
-	    PUTC_i = 0;
-	    (void) strcat(buf, "{ ");
+	    PUTC_INIT;
+	    (void) _nc_trace_bufcat(bufnum, "{ ");
 	    do {
 		PUTC_ch = PUTC_i < CCHARW_MAX ? ch->chars[PUTC_i] : L'\0';
 		PUTC_n = wcrtomb(PUTC_buf, ch->chars[PUTC_i], &PUT_st);
@@ -274,19 +276,20 @@
 		    break;
 		for (n = 0; n < PUTC_n; n++) {
 		    if (n)
-			(void) strcat(buf, ", ");
-		    (void) strcat(buf, _tracechar(UChar(PUTC_buf[n])));
+			(void) _nc_trace_bufcat(bufnum, ", ");
+		    (void) _nc_trace_bufcat(bufnum, _tracechar(UChar(PUTC_buf[n])));
 		}
 		++PUTC_i;
 	    } while (PUTC_ch != L'\0');
-	    (void) strcat(buf, " }");
+	    (void) _nc_trace_bufcat(bufnum, " }");
+	}
+	if (attr != A_NORMAL) {
+	    (void) _nc_trace_bufcat(bufnum, " | ");
+	    (void) _nc_trace_bufcat(bufnum, _traceattr2(bufnum + 20, attr));
 	}
-	if (attr != A_NORMAL)
-	    (void) sprintf(buf + strlen(buf), " | %s",
-		    _traceattr2(bufnum + 20, attr));
     }
 
-    return (strcat(buf, r_brace));
+    return (_nc_trace_bufcat(bufnum, r_brace));
 }
 
 NCURSES_EXPORT(char *)
Index: ncurses/trace/lib_tracechr.c
Prereq:  1.9 
--- ncurses-5.3-20021012/ncurses/trace/lib_tracechr.c	Sat May 25 19:34:19 2002
+++ ncurses-5.3-20030719/ncurses/trace/lib_tracechr.c	Sat Jun 14 07:05:42 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -36,19 +36,36 @@
  */
 #include <curses.priv.h>
 
-MODULE_ID("$Id: lib_tracechr.c,v 1.9 2002/05/25 23:34:19 tom Exp $")
+#include <ctype.h>
+
+MODULE_ID("$Id: lib_tracechr.c,v 1.10 2003/06/14 11:05:42 tom Exp $")
 
 #ifdef TRACE
 NCURSES_EXPORT(char *)
 _tracechar(int ch)
 {
-    static char crep[40];
-    (void) sprintf(crep, "'%.30s' = %#03o",
-		   ((ch > KEY_MIN || ch < 0)
-		    ? keyname(ch)
-		    : unctrl(ch)),
-		   ch);
-    return (crep);
+    static char result[40];
+    char *name;
+
+    if (ch > KEY_MIN || ch < 0) {
+	name = keyname(ch);
+	if (name == 0 || *name == '\0')
+	    name = "NULL";
+	(void) sprintf(result, "'%.30s' = %#03o", name, ch);
+    } else if (!isprint(ch) || ch > 255) {
+	/*
+	 * workaround for glibc bug:
+	 * sprintf changes the result from unctrl() to an empty string if it
+	 * does not correspond to a valid multibyte sequence.
+	 */
+	(void) sprintf(result, "%#03o", ch);
+    } else {
+	name = unctrl(ch);
+	if (name == 0 || *name == 0)
+	    name = "null";	/* shouldn't happen */
+	(void) sprintf(result, "'%.30s' = %#03o", name, ch);
+    }
+    return (result);
 }
 #else
 empty_module(_nc_lib_tracechr)
Index: ncurses/trace/trace_buf.c
Prereq:  1.11 
--- ncurses-5.3-20021012/ncurses/trace/trace_buf.c	Sat Jul 13 20:08:08 2002
+++ ncurses-5.3-20030719/ncurses/trace/trace_buf.c	Sat Mar 15 16:21:36 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -35,15 +35,15 @@
 
 #include <curses.priv.h>
 
-MODULE_ID("$Id: trace_buf.c,v 1.11 2002/07/14 00:08:08 tom Exp $")
+MODULE_ID("$Id: trace_buf.c,v 1.12 2003/03/15 21:21:36 tom Exp $")
 
 typedef struct {
     char *text;
     size_t size;
 } LIST;
 
-NCURSES_EXPORT(char *)
-_nc_trace_buf(int bufnum, size_t want)
+static char *
+_nc_trace_alloc(int bufnum, size_t want)
 {
     char *result = 0;
     static LIST *list;
@@ -65,8 +65,6 @@
 		  list[bufnum].size = want;
 	}
 
-	if (list[bufnum].text != 0)
-	    *(list[bufnum].text) = '\0';
 	result = list[bufnum].text;
     }
 #if NO_LEAKS
@@ -81,4 +79,31 @@
     }
 #endif
     return result;
+}
+
+/*
+ * (re)Allocate a buffer big enough for the caller's wants.
+ */
+NCURSES_EXPORT(char *)
+_nc_trace_buf(int bufnum, size_t want)
+{
+    char *result = _nc_trace_alloc(bufnum, want);
+    if (result != 0)
+	*result = '\0';
+    return result;
+}
+
+/*
+ * Append a new string to an existing buffer.
+ */
+NCURSES_EXPORT(char *)
+_nc_trace_bufcat(int bufnum, const char *value)
+{
+    char *buffer = _nc_trace_alloc(bufnum, 0);
+    size_t have = strlen(buffer);
+
+    buffer = _nc_trace_alloc(bufnum, 1 + have + strlen(value));
+    (void) strcpy(buffer + have, value);
+
+    return buffer;
 }
Index: ncurses/trace/varargs.c
Prereq:  1.3 
--- ncurses-5.3-20021012/ncurses/trace/varargs.c	Sat Oct  5 19:04:17 2002
+++ ncurses-5.3-20030719/ncurses/trace/varargs.c	Sat May 24 17:10:28 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 2001,2002 Free Software Foundation, Inc.                   *
+ * Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -34,7 +34,7 @@
 
 #include <ctype.h>
 
-MODULE_ID("$Id: varargs.c,v 1.3 2002/10/05 23:04:17 tom Exp $")
+MODULE_ID("$Id: varargs.c,v 1.4 2003/05/24 21:10:28 tom Exp $")
 
 #ifdef TRACE
 
@@ -46,7 +46,7 @@
 
 #define VA_INT(type) ival = va_arg(ap, type)
 #define VA_FLT(type) fval = va_arg(ap, type)
-#define VA_PTR(type) pval = (void *)va_arg(ap, type)
+#define VA_PTR(type) pval = (char *)va_arg(ap, type)
 #define VA_STR(type) sval = va_arg(ap, type)
 
 /*
Index: ncurses/trace/visbuf.c
Prereq:  1.6 
--- ncurses-5.3-20021012/ncurses/trace/visbuf.c	Sat Oct  5 20:03:43 2002
+++ ncurses-5.3-20030719/ncurses/trace/visbuf.c	Sat Jun 28 19:20:37 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 2001 Free Software Foundation, Inc.                        *
+ * Copyright (c) 2001-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -27,7 +27,7 @@
  ****************************************************************************/
 
 /****************************************************************************
- *  Author: Thomas E. Dickey 1996-2001                                      *
+ *  Author: Thomas E. Dickey 1996-2003                                      *
  *     and: Zeyd M. Ben-Halim <zmbenhal@netcom.com> 1992,1995               *
  *     and: Eric S. Raymond <esr@snark.thyrsus.com>                         *
  ****************************************************************************/
@@ -41,7 +41,7 @@
 #include <tic.h>
 #include <ctype.h>
 
-MODULE_ID("$Id: visbuf.c,v 1.6 2002/10/06 00:03:43 tom Exp $")
+MODULE_ID("$Id: visbuf.c,v 1.8 2003/06/28 23:20:37 tom Exp $")
 
 static char *
 _nc_vischar(char *tp, unsigned c)
@@ -187,9 +187,7 @@
 NCURSES_EXPORT(const char *)
 _nc_viscbuf2(int bufnum, const cchar_t * buf, int len)
 {
-    size_t have = BUFSIZ;
-    char *result = _nc_trace_buf(bufnum, have);
-    char *tp = result;
+    char *result = _nc_trace_buf(bufnum, BUFSIZ);
     int n;
     bool same = TRUE;
     attr_t attr = A_NORMAL;
@@ -211,17 +209,18 @@
      * detailed trace function that displays each character separately.
      */
     if (same) {
-	*tp++ = D_QUOTE;
+	static const char d_quote[] =
+	{D_QUOTE, 0};
+
+	result = _nc_trace_bufcat(bufnum, d_quote);
 	while (len-- > 0) {
 	    if ((found = _nc_altcharset_name(attr, CharOfD(buf))) != 0) {
-		(void) strcpy(tp, found);
-		tp += strlen(tp);
+		result = _nc_trace_bufcat(bufnum, found);
 		attr &= ~A_ALTCHARSET;
 	    } else if (!isnac(CHDEREF(buf))) {
 		PUTC_DATA;
 
-		memset(&PUT_st, '\0', sizeof(PUT_st));
-		PUTC_i = 0;
+		PUTC_INIT;
 		do {
 		    PUTC_ch = PUTC_i < CCHARW_MAX ? buf->chars[PUTC_i] : L'\0';
 		    PUTC_n = wcrtomb(PUTC_buf, buf->chars[PUTC_i], &PUT_st);
@@ -230,33 +229,31 @@
 		    if (PUTC_n <= 0)
 			break;
 		    for (n = 0; n < PUTC_n; n++) {
-			tp = _nc_vischar(tp, UChar(PUTC_buf[n]));
+			char temp[80];
+			_nc_vischar(temp, UChar(PUTC_buf[n]));
+			result = _nc_trace_bufcat(bufnum, temp);
 		    }
 		    ++PUTC_i;
 		} while (PUTC_ch != L'\0');
 	    }
 	    buf++;
 	}
-	*tp++ = D_QUOTE;
-	*tp++ = '\0';
-	if (attr != A_NORMAL)
-	    (void) sprintf(tp, " | %s",
-			   _traceattr2(bufnum + 20, attr));
+	result = _nc_trace_bufcat(bufnum, d_quote);
+	if (attr != A_NORMAL) {
+	    result = _nc_trace_bufcat(bufnum, " | ");
+	    result = _nc_trace_bufcat(bufnum, _traceattr2(bufnum + 20, attr));
+	}
     } else {
-	*tp++ = L_BRACE;
+	static const char l_brace[] =
+	{L_BRACE, 0};
+	static const char r_brace[] =
+	{R_BRACE, 0};
+	strcpy(result, l_brace);
 	while (len-- > 0) {
-	    char *temp = _tracecchar_t2(bufnum + 20, buf++);
-	    size_t used = (tp - result);
-	    size_t want = strlen(temp) + 5 + used;
-	    if (want > have) {
-		result = _nc_trace_buf(bufnum, have = want);
-		tp = result + used;
-	    }
-	    (void) strcpy(tp, temp);
-	    tp += strlen(tp);
+	    result = _nc_trace_bufcat(bufnum,
+				      _tracecchar_t2(bufnum + 20, buf++));
 	}
-	*tp++ = R_BRACE;
-	*tp++ = '\0';
+	result = _nc_trace_bufcat(bufnum, r_brace);
     }
     return result;
 }
Index: ncurses/tty/lib_mvcur.c
Prereq:  1.86 
--- ncurses-5.3-20021012/ncurses/tty/lib_mvcur.c	Sat Sep 14 19:02:06 2002
+++ ncurses-5.3-20030719/ncurses/tty/lib_mvcur.c	Sat Jul 19 18:01:24 2003
@@ -1,5 +1,5 @@
 /****************************************************************************
- * Copyright (c) 1998-2001,2002 Free Software Foundation, Inc.              *
+ * Copyright (c) 1998-2002,2003 Free Software Foundation, Inc.              *
  *                                                                          *
  * Permission is hereby granted, free of charge, to any person obtaining a  *
  * copy of this software and associated documentation files (the            *
@@ -108,7 +108,9 @@
  * LONG_DIST and (b) further inward from the right or left edge than LONG_DIST,
  * we'll consider nonlocal.
  */
-#define NOT_LOCAL(fy, fx, ty, tx)	((tx > LONG_DIST) && (tx < screen_lines - 1 - LONG_DIST) && (abs(ty-fy) + abs(tx-fx) > LONG_DIST))
+#define NOT_LOCAL(fy, fx, ty, tx)	((tx > LONG_DIST) \
+ 		 && (tx < screen_columns - 1 - LONG_DIST) \
+		 && (abs(ty-fy) + abs(tx-fx) > LONG_DIST))
 
 /****************************************************************************
  *
@@ -152,7 +154,7 @@
 #include <term.h>
 #include <ctype.h>
 
-MODULE_ID("$Id: lib_mvcur.c,v 1.86 2002/09/14 23:02:06 Philippe.Blain Exp $")
+MODULE_ID("$Id: lib_mvcur.c,v 1.91 2003/07/19 22:01:24 tom Exp $")
 
 #define CURRENT_ROW	SP->_cursrow	/* phys cursor row */
 #define CURRENT_COLUMN	SP->_curscol	/* phys cursor column */
@@ -299,7 +301,10 @@
     /*
      * 9 = 7 bits + 1 parity + 1 stop.
      */
-    SP->_char_padding = (9 * 1000 * 10) / (BAUDRATE > 0 ? BAUDRATE : 9600);
+    if (isatty(fileno(SP->_ofp)))
+	SP->_char_padding = (9 * 1000 * 10) / (BAUDRATE > 0 ? BAUDRATE : 9600);
+    else
+	SP->_char_padding = 1;	/* must be nonzero */
     if (SP->_char_padding <= 0)
 	SP->_char_padding = 1;	/* must be