.\"

.\" Copyright (c) Mark J. Kilgard, 1996.

.\"

.TH glutCreateWindow 3GLUT "3.7" "GLUT" "GLUT"

.SH NAME

glutCreateWindow - creates a top-level window. 

.SH SYNTAX

.nf

.LP

int glutCreateWindow(char *name);

.fi

.SH ARGUMENTS

.IP \fIname\fP 1i

ASCII character string for use as window name. 

.SH DESCRIPTION

glutCreateWindow creates a top-level window. The

name will be provided to the window system as the window's name. The

intent is that the window system will label the window with the name. 



Implicitly, the current window is set to the newly created window. 



Each created window has a unique associated OpenGL context. State

changes to a window's associated OpenGL context can be done

immediately after the window is created. 



The display state of a window is initially for the window to be shown.

But the window's display state is not actually acted upon until

glutMainLoop is entered. This means until glutMainLoop is called,

rendering to a created window is ineffective because the window can not

yet be displayed. 



The value returned is a unique small integer identifier for the window.

The range of allocated identifiers starts at one. This window identifier

can be used when calling glutSetWindow. 

.SH X IMPLEMENTATION NOTES

The proper X Inter-Client Communication Conventions Manual

(ICCCM) top-level properties are established. The WM_COMMAND

property that lists the command line used to invoke the GLUT program

is only established for the first window created. 

.SH SEE ALSO

glutCreateSubWindow, glutCreateMenu, glutDestroyWindow

.SH AUTHOR

Mark J. Kilgard (mjk@nvidia.com)

