#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
export LIBPKG=lib${PKG}0-${VER}-${REL}

# if the orig src package is bzip2'ed, remember to
# change 'z' to 'j' in the 'tar xvzf' commands in the
# prep) and mkpatch) sections
export src_orig_pkg_name=${PKG}-${VER}.tar.bz2
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export lib_pkg_name=${LIBPKG}.tar.bz2
export dev_pkg_name=${PKG}-devel-${VER}-${REL}.tar.bz2
export doc_pkg_name=${PKG}-doc-${VER}-${REL}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export lib_pkg=${topdir}/${lib_pkg_name}
export dev_pkg=${topdir}/${dev_pkg_name}
export doc_pkg=${topdir}/${doc_pkg_name}

export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
MY_CFLAGS="-O2"
MY_LDFLAGS=

# define if the PCRE HTML docu is wanted
#withhtml=
withhtml=yes

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvjf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  chmod +x ${srcdir}/reconf-cygwin.sh && \
  mkdirs )
}
conf() {
  (cd ${srcdir} && ./reconf-cygwin.sh && cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --enable-utf8 \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --libexecdir='${sbindir}' --localstatedir=/var \
  --datadir='${prefix}/share' --mandir='${prefix}/share/man'
)
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make
# UGLY - REMOVE ME WHEN LIBTOOL IS FIXED
  cp ${objdir}/.libs/cygpcreposix-0.dll ${objdir}/cygpcreposix-0.dll.bak
  )
}
check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} 

# UGLY - REMOVE ME WHEN LIBTOOL IS FIXED
  cp ${objdir}/cygpcreposix-0.dll.bak ${instdir}${prefix}/bin/cygpcreposix-0.dll

  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/ANNOUNCE ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
           ${srcdir}/TODO ${srcdir}/doc/pcre.txt ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
	 else
				if [ -f ${topdir}/${FULLPKG}-README ]; then \
		  /usr/bin/install -m 644 ${topdir}/${FULLPKG}-README \
		    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
		fi
    fi ;\
  fi ;\
  if [ ! "x$withhtml" = "x" ]; then \
    for f in `ls ${srcdir}/doc/html/*.html` ; do \
      mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER}/html/ && \
      /usr/bin/install -m 644 $f ${instdir}${prefix}/share/doc/${PKG}-${VER}/html/ ; done \
  fi ;\
  sed -e "s#dependency_libs=.*#dependency_libs=' /usr/lib/libpcre.la'#" \
  < ${instdir}${prefix}/lib/libpcreposix.la > ${instdir}${prefix}/lib/libpcreposix.la.tmp && \
  mv ${instdir}${prefix}/lib/libpcreposix.la.tmp ${instdir}${prefix}/lib/libpcreposix.la )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} `find usr -name '*.exe' -print` usr/doc/Cygwin && \
  tar cvjf ${lib_pkg} `find usr -name '*-0.dll' -print` && \
  tar cvjf ${doc_pkg} usr/share/doc/${PKG}-${VER} usr/share/man && \
  tar cvjf ${dev_pkg} usr/include usr/lib usr/bin/pcre-config )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvjf ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  (diff -urdbN -x ".build" -x ".inst" -x ".sinst" \
              -x "chartables.c" -x "aclocal.m4" \
              -x "config.guess" -x "config.sub" \
              -x "configure" -x "install-sh" \
              -x "ltmain.sh" -x "missing" -x "mkinstalldirs" \
              ${PKG}-${VER}-orig ${PKG}-${VER} > ${srcinstdir}/${src_patch_name}); && \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cp ${FULLPKG}-README ${srcinstdir}/${FULLPKG}-README && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  test)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
