// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:         activity.h
Description:  processing control over all levels of swarm execution 
Library:      activity
*/

//S: Swarm¹Ԥ٥νȥ

//D: activity饤֥˲ݤ줿ϡߥ졼Ȥȯ륢򥹥塼뤹뤳ȡƤΥǼºݤȯ뤳ȤǤactivity饤֥ϡSwarmǤưŪʥ֥Ȼظߥ졼δä󶡤ޤ

//D: ϥ֥ȤؤΥåؿƤӽФ뤤줿˽ä󷲤Υ롼פǹޤactivity饤֥ϡ餹٤ƤΥ䤽餬߽Ф֤Ѳɤͽ¬ǽʥݥȤȯ뤳ȤݾڤޤϥнޤפΥͤǥǥå뤳ȤǤޤ

#import <collections.h>

@protocol ProcessType
//S: ץλ

//D: 졢ProcessTypeץΥѥ᥿饤ΥݡȤ褦ˤʤޤץȤϡŪʿ񤤤Ūʿ񤤤λͤ˽äˡ˼̤륤٥ȷƻڤΤȤǤ

//D: ץˤϡ֥Ȥȼ¹Բǽʥξޤޤޤ֥ȤϡŪ˳Ϥ줿Υ󥹤˴ŤƤξ֤俶񤤤ѲޤȤоŪˡ1˥åȤȤƤä¹Ԥ졢ѻǽʷ̤մĶˤ֤Ѳ⤿餹ʳˡŪʿ񤤤ʤΤ̤Ǥ

//D: ɬפϥѥ᡼ѿǽ̤򤹤٤¹ԥƥȤǤΥǡХɤȤŪʥե졼δäʤΤѥ᥿饤Ǥѥ᥿饤Υե졼ϳΩĤĤޤProcessType֥Ȥϡץλͤ򤽤λͤϰϤǵϿ褦ˤʤޤ
@end

@protocol ActionType
//S: ¹Բǽʥץλ͡

//D: 󷿤ϡꥯȤˤä1ñ̤μ¹ԤȤƳϤ뤳ȤǤץηǤ̾ΥΤ줿³֤äƤޤδ֤ϤΥǼ¹ԤŪʰϢΥˤäƷޤޤŪ˳ϤߺѤΤϡ̤ϥץΤγϻ뤤ϽλǤ̾Υϡ򳫻Ϥ볰ꥯȤȯФΤ٤Ƥ¹Ԥޤޤˤϡ줬ޤޤĶ¾Υ󤬤μ¹ԤϤ뤫λޤǡϤⴰλǤʤ褦Ūʥ٥ȤĤΤ⤢ޤΤ褦ʽŤϡ󷿤ǡ뤤ưŪʼ¹ԥƥȤΰȤǤޤ

//D: ¹Բǽʥˤϡۥȸ(CؿObjective Cå)˥ѥ뤵줿ȡSwarmݥޥ󤬲᤹褦˼¹Ի˹ۤʣ祢ξޤޤޤ
  
//D: (.. ʬActionTypeΥ֥פCompoundActionǤؿåΤ褦ʤޤȤޤäηϤޤƤޤ ..)

USING
//M: activateIn:åϡActionTypeaction¹ԤץޤΥץϡActivityȸƤФ륪֥Ȥ˥ȥ뤵ޤactivateInåϥƥӥƥswarmContextȤϤ줿¹ԥƥȤβǼ¹Ԥ褦˽ơޤ˺줿ƥӥƥ֥Ȥ֤ޤ¹ԥƥȤnilξϡƤӽФ˼¹Ԥ򥳥ȥǤ륢ƥӥƥ֤ޤʳξǤϡ¹ԥƥȤSwarmProcessSwarmActivityΥ󥹥󥹤ǤʤФʤޤ(Υ֥Ȥϸߤбä11δطǾ˴ޤswarmContextȤƤϡΥڥξԤǤ)

//M: ȥåץ٥Υƥӥƥ(swarmContextnil)ΥƥӥƥrunstepʤɤΥƥӥƥޥɤȤäƽǤޤƥӥƥSwarmƥȲǼ¹Ԥ褦˺硢֥ƥӥƥνSwarmȤǤޤνϡΥƥӥƥƱ˴ؤɬ׾˽äƤʤޤSwarmβǼ¹ԤΥץ򥢥ƥֲȡSwarm˥ȥ뤬ơ֥ƥӥƥϤܼۤΧƥӥƥȤƼ¹Ԥޤ
- activateIn: swarmContext;
@end


@protocol AutoDrop
//S: 󤬤ν˥ɥåפ褦˻ꤷޤ

//D: AutoDropץϡ¹Υƥӥƥ륢νλƱˡΥץ󤫤ɥåפƤӸʤ褦˻ꤷޤΥץä˾¹Ԥ٤ˤ˼ΤΡ˥塼뤵줿Ϸ褷Ʒ֤ȤʤȤưŪʥ塼ǤȤäƤ륹塼μˤäƤϡAutoDropǸŤ򤫤ʤ餺ɥåפ뤳Ȥǡ塼Υѥեޥ󥹤ʤޤ

//D: AutoDropΤ褦ʥץѤȤ뤤ϥץƤʤưŪȤϡΥץѤΤñΥݥȤˤϤǤAutoDropꤹȥƥ֤ʥե󥹤ʣˤʤʤ褦¤ݤ졢⤷2ĤΥƥӥƥƱͭAutoDropȤä1ĤΥ褦ȤС顼ˤʤޤ
CREATING
- (void)setAutoDrop: (BOOL)autoDrop;
USING
- (BOOL)getAutoDrop;
@end

@protocol CompoundAction <ActionType, Collection, AutoDrop>
//S:  ϢνŤ˽äǼ¹Ԥ٤Υ쥯

//D: CompoundActionActionGroupScheduleΥѡפǤʣ祢ϡ줿˽äϢΥμ¹Ԥǹ¹Բǽץޤ

//D: CompoundActionľܺǤʤΤǡΥ֥פ1ĤƤActionPlanϡ¹Ԥ˸ActionType饢ƥֲǤ褦˴ܵǽѾޤ
@end

@protocol ActionCreatingCall
//S: CؿƤӽФ

//D: createActionCall:åcreateActionToå˻ƤޤͤΥꥹȤФCؿΥХɤȤƥ󤬼¹Ԥ褦˻ꤷޤȤϤؿݥ󥿤ˤĿΰͿʤФʤޤ
USING
- createActionCall: (func_t)fptr;
- createActionCall: (func_t)fptr : arg1;
- createActionCall: (func_t)fptr : arg1 : arg2;
- createActionCall: (func_t)fptr : arg1 : arg2 : arg3;
@end

@protocol ActionCreatingTo
//S: å򥪥֥Ȥ륢

//D: createActionTo:åϡ¹Ԥ٤Objective Cå쥯졢֥ȤǤդɬפʰ˴ŤƼ¹Ԥ褦˻ꤷޤȼ֥ȤϡǽΰĤޤ꥿åȤȤƻꤵޤ

//E: Given a variable aTurtle already initialized to a valid object, following
//E: is an example of a createActionTo message:

//E: [createActionTo: aTurtle message: M(print)];

//E: M() is a macro defined in defobj.h which is just a convenient
//E: shorthand for the Objective C expression @selector(message-name).  As
//E: in any selector, the message name must include all parts of the
//E: message including colons and subsequent argument portions.  An example
//E: of a message with one additional argument is the following:

//E: [createActionTo: aTurtle message: M(move:) : obj];

USING
- createActionTo: target message: (SEL)aSel;
- createActionTo: target message: (SEL)aSel : arg1;
- createActionTo: target message: (SEL)aSel : arg1 : arg2;
- createActionTo: target message: (SEL)aSel : arg1 : arg2 : arg3;
@end

@protocol ActionCreatingForEach
//S: åȤγƥƥ˥åޤåȤϥ쥯Ǥ뤳ȤȤʤޤ

//D: createActionForEach:åϡcreateActionToåƱˡ٤åޤåȰȤϤ륪֥Ȥϥ쥯󥪥֥ȤǤ뤳ȤȤʤޤcollections饤֥CollectionɸåȤΥ쥯󤫤ѤǤƥ֥Ȥꤷå褦˻ꤷޤ

USING
- createActionForEach: target message: (SEL)aSel;
- createActionForEach: target message: (SEL)aSel : arg1;
- createActionForEach: target message: (SEL)aSel : arg1 : arg2;
- createActionForEach: target message: (SEL)aSel : arg1 : arg2 : arg3;
@end

@protocol ActionCreating <ActionCreatingCall, ActionCreatingTo, ActionCreatingForEach>
//S: ActionGroupSchedule˶ͭץȥ

//D: ActionCreatingϡΥץȥ뤬ScheduleȶͭǤ褦ˤ뤿ˡActionGroupؤcreateActionåޤϡ0ǥ塼Υʥ󥿡եȤʤޤ

//D: createActionåϡåΤ٤Ƥΰ򥪥֥idˤʤ褦ޤХʰܿˤ¤ϰǡ¾Υݥ󥿤ͤͳ˥㥹ȤǤޤϡ٤ƤΥޥ󥢡ƥϤäܿϤޤ󡣤SwarmݡȤǤ32-bit64-bitƥǤϡܿǤͽ¬ޤʤåϡid˥㥹ȤºݤϤηʤФʤޤ

//D: (.. ηŤإץϸ߳ȯǤϡcreateActionåθߤη֤ΤǤʤɲä뤳ȤˤʤǤ礦)

//D: 줾createActionåϡ줬󥪥֥Ȥ֤ޤۤʤcreateActionåϡ̾礷ۤʤ뷿Action֥Ȥ֤ޤAction֥ȤϡActionν˻Ѥ٤ƤξؤΥ󶡤ޤ줿Action֥ȷϡƤؤΥѤǤåޤᡢƤޤ(.. ߡAction֥Ȥμϡѥ᡼ͤηŤdefobjActionType˰Ѥ褦ѹʤǤޤ)

USING
//M: createAction:åϡ¾Υ󷿤νΥˤäƤʤ褦˻ꤷޤȤ륢󷿤ϡñ˺줿θ̤Ʊǽ餫ǸޤǤ٤Ƥ¹Ԥޤ
- createAction: anActionType;

@end

@protocol ActionGroup <CompoundAction, ActionCreating, CREATABLE>
//S: Τ뤤ʬŪ˽󤬤륢Υ쥯

//D: 󥰥롼פϡŪ˺줿Υ󥹤򤽤δɽȤƻäץǤ

//D: 󥰥롼פϡcollections饤֥OrderedSetŪɽѾޤŤ줿ϢΥФϡɤActionGroupȤ줿createActionåΤɤ줫˺륢ǹʤФʤޤ󡣤ä󥢥󤬺ȡOrderedSetɸåȤäƥȥСǤޤ

//D: 󥪥֥Ȥϡ餬륢ץԲķʥȥ뤵줿ݡͥȤǤremoveåˤäƤ餬ץ󥳥쥯󤫤줿硢Ǥ륳쥯ϸΥ쥯Ǥ֤̤˺뤳ȤˤäơɽΥ󥹤뤳ȤǤޤ
@end


@deftype DefaultOrder

//S: ¾ŪʽŤƤʤäȤˡΥץΥ֤˲ꤵŤ򼨤ޤ

//D: DefaultOrderץϡ¾Ū˳Ƥ줿ŤʤȤˡץΥ֤ȤŤ򼨤ޤġΥʬͤŬѤСνŤĶۤɲŪʽŤŪɲä뤳ȤǤޤ(.. ʬϡޤƤޤ)

//D: DefaultOrder˻ꤹͤϡConcurrentSequentialRandomizedΤ줫ΥܥǤ

//D: DefaultOrderץConcurrentͤꤹȡ(ϡɥ䥽եȥξˤäƤƱޤߤޤ)ǥ󤬼¹ԤǤ褦ˤʤޤξϡΥκǽ̤ؤƶڤӤޤη̤Ȥμ¹Խΰ¸طʤ褦׵᤹뤳Ȥǡ֤ˤϡʬ򤷤ǤդνǤ¹ԤȤ餫;͵ͿޤñΥꥢץåФ븽ߤμǤϡȤConcurrentͤꤵƤƤ⥢Ͼ˽缡ޤϸߤʳ˲ǽˡʤǤΥСǤϡꥢץåˤ¹Խ򺮹礷ƥǥ̤Ωݤ̤ʼ¹Ի⡼ɤǤ褦ˤʤޤ

//D: DefaultOrderץΥǥեȤSequentialͤǤSequentialꤹȡϾˤ餬ץȯǼ¹Ԥ뤳Ȥˤʤޤ̾盧νϡ󤬤ץδäȤʤɤ褽Υ쥯Ū˲äʤ¤ꡢץǺǽˤΥ󤬺줿Ǥ̤ͽ¬ǽݤ뤿ˤϡΥץ󤬾˺ǤǤ˼¹ԤǽϤ̵ʤޤǥ߷פΤƵҤˤϡ餬Sequentialν˰¸뤫ݤˤĤơץŪʻؼͿɤǤ礦

//D: ǥη̤ϼ¹Խ˰¸ΤΡ󤬺ޤɲä줿̤ʰ̣ʤȤϡDefaultOrderRandomizedͤꤷޤˤꡢƱΥΥ쥯Ĥɥʽˡǽΰ¸ޤΥʽϡ֤ͥ졼ޤ

CREATING
- (void)setDefaultOrder: aSymbol;
USING
- getDefaultOrder;

@end

//G: DefaultOrder
extern id <Symbol>  Concurrent, Sequential, Randomized;

#ifndef DEFINED_timeval_t
#define DEFINED_timeval_t

//T: Values of this type are used as keys when inserting actions into a
//T: schedule at a particular time, or for querying the current time value
//T: of a swarm or schedule during its execution.  (The shorter name time_t
//T: has already been taken by one the standard C libraries.)

//T: For very long running models using finely divided units of time, it is
//T: quite possible that a 32-bit unsigned time value could overflow.
//T: Special messages are provided in the execution machinery to reset all
//T: times to a different base value if a danger of overflow exists.  If
//T: this machinery is exercised, all times of all referenced action plans
//T: are reset to a different base value in unison, which makes the shift
//T: as transparent as possible.  Separate support is also available to
//T: declare time values that are subunits of the discrete clock values in
//T: a containing schedule or swarm.  (.. Currently, all this extended time
//T: unit support is unsupported, though there is an example of scheduling
//T: at subunit times in a GridTurtle test program.)
typedef unsigned long timeval_t;
#endif

//G: timeval_tͤκ
extern const timeval_t TimebaseMax;


@protocol RelativeTime
//S: 郎塼γϻФŪˤʤ褦˻ꤷޤ

//D: RelativeTimeץϡ塼Τ٤Ƥλ郎塼ΤνϤޤäФŪʴطĤ褦˻ꤷޤΥץȤʤϡǥΤγϻ١ȤлȤʤޤ
SETTING
- (void)setRelativeTime: (BOOL)relativeTime;
USING
- (BOOL)getRelativeTime;
@end

@protocol RepeatInterval
//S: ¸Υƥ塼뤷ޤ

//D: RepeatIntervalץꤹȡ塼Τ٤ƤΥϡ줬λƱˡ塼뤬Ǹ˳ϤRepeatInterval˻ꤵ줿ͤפ˺ƥ塼뤵ޤΥץǤϡлȤư̾ΥǥեȤ򥪡С饤ɤRelativeTimeץ󤬰˻ꤵ줿褦ʸ̤Ϳޤ塼뤵Ϥ٤ƻꤷȿֳ̤ǤʤФʤ餺ʤȥ顼ȯޤRepeatIntervalץϡ륹塼뤬줿塢³ۤʤäͤ˺ƳƤǤޤֳͤϾˤ줬ޤह٤ƤΥΥ塼뤵줿礭ʤФʤޤ(.. Υץϸߥ塼ˤΤߥݡȤƤޤSwarmˤϥݡȤޤ)
SETTING
- (void)setRepeatInterval: (timeval_t)repeatInterval;
USING
- (timeval_t)getRepeatInterval;
@end

@protocol ConcurrentGroupType
//S: ƱͤΥ󥹥塼ޤ

//D: ʣΥνɤƱͤ˥塼뤵褦˥ȥ뤷ȤConcurrentGroupTypeץѤޤ塼ɽˤĤƤϡǥեȤǤΥ¹ԤƼ¹ԲǽǤ뤳ȤȤ졢֤ConcurrentGroupTypeץ󤬤ޤäꤵƤʤΤ褦ˡΥͳ˽Ǥޤ

//D: ƱॹƥåפΥ˰ۤʤ᤬ɬפʤ顢ConcurrentGroupTypeץ󤬻ǤޤΥץΰϥ֥ȤǤʤФʤޤɸŪcreate:åͿȡΥץɸActionGroup֥Ȥι¤򤹤٤ƻä֥Ȥ֤ޤ

//D: ɸActionGroupΥС饤ɤ˲ä¹ԥ롼׷ϡʤȤ󶡤ActionGroupμΥॵ֥饹ˤäƼ뤳ȤǤޤॵ֥饹ǤϡޤƱͤ夹뤹٤ƤΥ礹ˡˤĤơͳʥ롼ǤޤȤСĤΥϤޤä¹Ԥ٤Ǥʤȷ᤿ꡢ뤤ϡȤȥ塼뤵줿夨ơޤϤ˲äƼ¹Ԥ٤Ǥޤ

//D: (.. ActionGroup֥饹εˡϤ⤵ޤ򤹤ƻϤǤˤޤߤ¹ԥ󥰥롼פϡ륪ʡSwarmΥSwarm֤μ¹ԽŬ˴뤿˻Ѥޤ)
SETTING
- (void)setConcurrentGroupType: groupType;
USING
- getConcurrentGroupType;
@end

@protocol SingletonGroups
//S: ¸ߤͤȤ˥󥰥롼פ٤Ǥ뤳Ȥ򼨤ޤ

//D: SingletonGroupsץꤹȡλͤ˥1ĤʤȤǤ⡢¸ߤͤȤ˥󥰥롼פޤ

//D: ̾ϡʣΥƱॹƥåפǥ塼뤵ˤΤߡ¹ԥ󥰥롼פ졢Υॹƥåפǥ󤬿ʤޤξ硢ľܥ󤬥󥯤ñΥ֥Ȥ򿷤˺ǺѤिᡢΥ󥰥롼פΥСإåɤŪ㤯ʤޤäơॹƥåפ¸ߤ륢1Ĥξϡ󥰥롼פʤФ˹®ˤʤޤॵ֥饹ͿƤϡ󤬤ä1ĤʤƤ⡢륿ॹƥåפΥ򸡺ɬפ뤫⤷ޤ
SETTING
- (void)setSingletonGroups: (BOOL)singletonGroups;
USING
- (BOOL)getSingletonGroups;
@end

@protocol Schedule <CompoundAction, ActionCreating, CREATABLE, RelativeTime, RepeatInterval, ConcurrentGroupType, SingletonGroups>
//S: ͤǽŤ줿Υ쥯

//D: 塼ϡŪ˺줿ΥȺѤMapδɽȤʤʣ祢ǤΥΤ줾б륭ͤunsignedͤǡtypedef timeval_tͿޤ

//D: 塼ϡcollections饤֥MapɽѾޤ٤ƤΥФνդϡ塼뼫Ȥ줿createActionåΤɤ줫󷲤ǹʤФʤޤ󡣤ä󥢥󤬺ƤޤСMapɸåȤäƥȥСǤޤΥ쥯ΥͤϡMapˤäƥͤid˥㥹ȤʤФʤޤ

//D: 塼˥åϡ¹Ԥ٤򼨤at:СActionGroupΥåܼŪƱǤcreateActionåΰ̣ϡƥбActionGroupƱǤ

//D: ʣΥ󤬤٤Ʊ˥塼뤵ȤϤ٤ơλѤ˺¹ԥ󥰥롼פޤ¹ԥФǥեȤΥ󥰥롼פ򡢥桼Υॵ֥饹ǥС饤ɤȤϡConcurrentGroupTypeץ󤬻ѤǤޤ(.. ܤˡϤޤ⤵Ƥޤ󤬡Ϥޤ)

USING
- at: (timeval_t)tVal createAction: anActionType;

- at: (timeval_t)tVal createActionCall: (func_t)fptr;
- at: (timeval_t)tVal createActionCall: (func_t)fptr:arg1;
- at: (timeval_t)tVal createActionCall: (func_t)fptr:arg1:arg2;
- at: (timeval_t)tVal createActionCall: (func_t)fptr:arg1:arg2:arg3;

- at: (timeval_t)tVal createActionTo: target message: (SEL)aSel;
- at: (timeval_t)tVal createActionTo: target message: (SEL)aSel:arg1;
- at: (timeval_t)tVal createActionTo: target message: (SEL)aSel:arg1:arg2;
- at: (timeval_t)tVal createActionTo: target message: (SEL)aSel:arg1:arg2:arg3;

- at: (timeval_t)tVal createActionForEach: target message: (SEL)aSel;
- at: (timeval_t)tVal createActionForEach: target message: (SEL)aSel:arg1;
- at: (timeval_t)tVal createActionForEach: target message: (SEL)aSel:arg1:arg2;
- at: (timeval_t)tVal createActionForEach: target message: (SEL)aSel:
                                                                arg1:arg2:arg3;

//M: 塼¹ԥ롼פ饢ޤ
- remove: anAction;

- insertGroup: aKey; 
@end

@protocol SynchronizationType
//S: Synchronizationϡswarm֥塼Ʊ뤿Ū˻Ѥ륹塼η򥻥åȤޤ

//D: Synchronizationϡ֥塼Ʊ뤿swarmŪ˻Ѥ륹塼η򥻥åȤޤǥեȤϡActivationOrder¹ԥ롼פĥ塼Ǥ

//D: SynchronizationTypeץΥǥեͤΥ󥰥롼פǤʤActivationOrderȸƤФ̤ˤ餫줿ActionGroupΥ֥פǤ¹ԥ롼׷ƱswarmǼ¹ԤƤۤʤäץ󤫤顢Ʊȯ褦˥塼뤵줿򡢤Υץ󤬺ǽ˥ƥֲ줿Ǽ¹Ԥޤ

CREATING
- (void)setSynchronizationType: aScheduleType;

USING
- getSynchronizationType;
@end

@protocol SwarmProcess <ActionType, Zone, CREATABLE, SynchronizationType>
//S: ¹ԥ֥ץΥ쥯ݻ륪֥ȡ

//D: SwarmProcessϡActionTypeZoneΥå򶦤˷Ѿޤο񤤤ѾȤȤϡswarm˥֥ȤȤˡswarmcreate:createBegin:åΰȤѤǤȤȤǤ

//D: ¾Υ󷿤Ȱ㤤SwarmƥֲƤСSwarmSwarmƥӥƥϾ11δط¸ߤޤñΥƥӥƥФ뤳¤ˤꡢSwarmϤSwarmǼ¹Υƥӥƥ˼ȤΥ󥿡ե󶡤륫४֥ȤȤơ̤ȤǤޤ

CREATING
//M: InternalZoneTypeץϡswarm˺륪֥Ȥݻ뤿swarm륾η򥻥åȤޤnil򥻥åȤȤswarmˤϰڤϺ줺Ǥ뤫Τ褦swarmѤȤ٤ƥ顼ˤʤޤΥץΥǥեȤɸZoneǤ(.. ޤ¾Zoneʤᡢ򥪥դˤʳΥץ򥻥åȤŪϤޤ ..)
- setInternalZoneType: aZoneType;

USING

//M: getInternalZoneϡswarm֥Ȥݻ뤿swarmѤZone֥Ȥ֤ޤswarmȤZoneѾƤꡢZoneȤƤۤȤɤ٤ƤŪѤǤޤο񤤤Ȥ̵ط˥󼫿ȤǤ褦ˤΥå󶡤Ƥޤ
- getInternalZone;

//M: getActivityϡswarmΥ֥ƥӥƥΤ߼¹Υƥӥƥ֤ޤswarmǽ˥ƥֲ줿ȤϡΥƥӥƥactivateIn:֤ͤƱǤswarmޤƥֲƤʤnil֤ޤ
- getActivity;
@end


@protocol Action <GetOwner>
//S: 󥤥󥿥ץ꥿ˤäľܼ¹Ԥ˸ƥޥ줿󷿡

//D: ϡץ˺뤹٤ƤΥ󷿤˶̤ΥѡפǤƥϡ줬°ñΥץˤäƾ˥ȥ뤵ޤΥץϤΥʡȤƻȤޤ륢󥪥֥ȤΥʡץϡѾgetOwneråȤäƼǤޤ

//D: ϤΥʡץƱ˳Ƥ졢ActionGroupSchedulecreateActionåΤɤ줫ȤäƤΤߺǤޤΥåϤ줾줿ͤȤ֤ޤޤץˤ륢ϡδäȤʤ륳쥯󤫤Ѿ줿åΤɤ줫ȤäƥץȤˤǤޤץ󤫤饢ȤϡäȤʤ륳쥯removeåȤޤ

//D: (.. աߤΥϡμ¹˺뤳ȤǤޤ󡣤Ĥޤꡢ˸ƤӽФ줿ؿåϡΥ򥢥ץ󤫤ǤʤȤˤʤޤ褳¤Ϥʤʤޤ)

//D: ActionΥ֥פcreateActionåˤ͡ʷꡢ֥פϤη줾ˤĤƸ̤ޤΥѥ᡼꥿󷿤ΥݡȤdefobj饤֥꤫ܥݡȤ˰ܤΤȼߤΥɽѹƤޤƥ󷿤ϡΥ˥Хɤ줿٤ƤΰͤΥåȤȼԤå󶡤ޤεǽϤĤޤĤϰۤʤäåݡȤ褦ˤʤǤ礦ActionǥݡȤåСΥɥơⴰޤ
@end

@protocol ActionArgs <Action>
//S: ActionCallActionToActionForEachΥѡ

//D: ActionArgsΤ٤ƤΥ֥פϡ󷿤ΰ˥Хɤ뤿Υϡɥɲ줿᥽åɤޤϤ٤idȸߴΤ뷿äƤʤФʤޤ󡣾Ūˤϡ󷿤ǤդοǤդηΰ˥Хɤ뤿ΤŪʥ᥽åɤȯ졢ͤ󶡤褦ˤʤǤ礦

USING
- (int)getNArgs;
- (void)setArg1: arg1;
- getArg1;
- (void)setArg2: arg2;
- getArg2;
- (void)setArg3: arg3;
- getArg3;
@end

@protocol ActionCall <ActionArgs>
//S: CؿƤӽФȤ륢
//D: CؿƤӽФȤ륢

USING
- (void)setFunctionPointer: (func_t)fptr;
- (func_t)getFunctionPointer;
@end

@protocol ActionTo <ActionArgs>
//S: Objective Cå뤳Ȥ륢
//D: Objective Cå뤳Ȥ륢

USING
- (void)setTarget: target;
- getTarget;
- (void)setMessageSelector: (SEL)aSel;
- (SEL)getMessageSelector;
@end

@protocol ActionForEach <ActionTo>
//S: 쥯Τ٤ƤΥФ˥å뤳Ȥ륢
//D: 쥯Τ٤ƤΥФ˥å뤳Ȥ륢
@end


@protocol Activity <DefinedObject, Drop>
//S: 󷿤Υ󥿥ץ꥿ˤΥ٥롣

//D: ActivityΥ֥ȤϡץΥνޤץγƥ֥פϡ줾˥ץηνбActivityΥ֥פޤ

//D: Activityϡץ󥤥󥿥ץ꥿β۽֤ΰǤߤν֤ޤߡ֤μפʥȤϥǥХåʤɤѥġγȯΩޤץꥱ󼫿ȤƤ륢ƥӥƥƼ¹ԤɬפΤ륢ץꥱץꥱǥ벽뤳ȤˤäƥƥӥƥľŪ˻Ѥ٤ǤϤޤ

//D: ƥӥƥ֥Ȥˤϡ줾activateIn:å򥢥󷿤ޤactivateIn:Ͽƥӥƥ֥Ȥν򤷤ޤ켫ȤΥ¹Ԥ뤳ȤϤޤ󡣥ƥӥƥν򳫻Ϥ뤿ˤϡrunΤ褦ʥåȼɬפޤSwarmƥȲǼ¹Ԥ褦˥ƥӥƥƥֲƤȤϡʡǤSwarmȤ֥ƥӥƥΤ٤Ƥν򥳥ȥ뤷ޤ

//D: Activityϡ߼¹Υĥ꡼뤤Ū˼¹Բǽʥ֥ƥӥƥݻޤƥƥӥƥ֥Ȥϡ1ĤΥץν֤ɽޤʣΥƥӥƥƱ˼¹Ԥꡢ¹ԤʤĤȤǽʤᡢƥӥƥ֥Ȥι¤ϥĥ꡼Ǥ2ĤΥƥӥƥ¹Ԥ˻ꤵƤСʤ餺ξޤʤʤ顢¾Υץ¹ԥˤäƤ餬¹ԤƤ뤿ᡢ뤤ƱSwarmμΧ¹ԤФƳϤ줿Ǥ֤Сƥƥӥƥϡ¾Τ륢ƥӥƥξ֤Ω켫Ȥξ֤ǿʤळȤǤޤ

//D: ߤμǥݡȤƤΤϡñΥꥢץåǤꥢ¹ԤǤϡƱ˥ƥ֤ˤǤ륢ƥӥƥ1Ĥ˸¤ޤĤޤꡢߤΥƥӥƥñΥåˤäƸߤν֤ɽǤޤϡ¹Բǽʥƥӥƥĥ꡼ˤ1դؤΥѥȥ졼ޤꥢ⡼ɤǼ¹ԤƤȤåѤС߼¹üƥӥƥ뤤ϸ߻Τ褦ʤ줫ѤǤʥƥȾǤޤ

USING
//M: runåϡ¹ԤߤƤ֤饢ƥӥƥν³ޤǤ˥ƥӥƥ¹ԤƤХ顼ȤʤޤrunͤˤStoppedơΤۤƥӥƥϤ䤵ʤ¹ԤˤŬʤȤCompletedơޤ
- run;

//M: stopåϡ߼¹Υƥӥƥĥ꡼νߤStoppedơ֤ޤ
- stop;

//M: terminate⥢ƥӥƥĥ꡼μ¹Ԥߤޤĥ꡼˼¹ԤȤϡĥ꡼Τ٤ƤΥƥӥƥCompletedơåȤޤterminateϥƥӥƥμ¹Υĥ꡼ȡߤĥ꡼ξ˻ѤǤޤRepeatIntervalץˤꥨɥ쥹ȿƤ륹塼򽪷뤵Ȥϡ줬ɸŪˡǤ
- (void)terminate;

//M: next1Ĥʣ祢ˤ륢󷲤¹ԤޤΥ˼¹Ԥ봰ʥץνϤ٤ƥåפޤ
- next;

//M: stepåϡƥӥƥĥ꡼ˤñΥ¹Ԥޤ
- step;

//M: getStatusåϡΥƥӥƥθߤμ¹Ծ֤ˤĤơInitializedRunningStoppedHoldingReleasedTerminatedCompletedΤɤ줫Υɤ֤ޤ
- getStatus;

//M: getHoldTypeϡߥƥӥƥäƤholdɽ(HoldStartޤHoldEnd)֤ޤΥƥӥƥδܾ֤HoldingǤʤȤnil֤ޤ

//M: (.. ߡSwarmǤΥޡʳholdϥݡȤƤޤ󡣤ΥåͤϾnilǤ)
- getHoldType;

//M: 륢ƥӥƥؤΥѥ᡼ΥХɤޤޤ
- getAction;

//M: ƥӥƥ˼¹ԤƤ륢Υ󷿤ޤ 
- getActionType;

//M: Swarmƥӥƥ¾Υƥӥƥءʡѹޤ
- (void)setOwnerActivity: ownerActivity;

//M: ¹Υƥӥƥξ̤Υƥӥƥ֤ޤ
- getOwnerActivity;

//M: ¹ԤαƤϢΥ֥ƥӥƥ֤ޤ
- getSubactivities;

//M: ߤμ¹׵ȥåץ٥ΥƥӥƥȯԤƥӥƥ֤ޤ
- getControllingActivity;

//M: ʥƥӥƥ¹ԤƤ륢ƥӥƥĥ꡼Υȥåפ֤ޤ
- getTopLevelActivity;

//M: ǤľŪ˴ޤǤSwarmƥӥƥ֤ޤ
- getSwarmActivity;

//M: ǤľŪ˴ޤǤScheduleƥӥƥ֤ޤ
- getScheduleActivity;

//M: ꥢ¹ԥ⡼ɤ򥻥åȤޤ
- setSerialMode: (BOOL)serialMode;

//M: ꥢ¹ԥ⡼ɤΥ󥸥֤ޤ
- (BOOL)getSerialMode;

//M: ¹Υ֥ƥӥƥ뤤ϼ˼¹Ԥ륵֥ƥӥƥޤ
- getCurrentSubactivity;  // serial mode only
@end

//G: getStatus֤
extern id <Symbol> Initialized, Running, Holding, Released, Stopped,
  Terminated, Completed;

//G: getHoldType֤
extern id <Symbol> HoldStart, HoldEnd;


@protocol ForEachActivity <Activity>
//S: ForEachǤμ¹Ծ֡
//D: ForEachǤμ¹Ծ֡

USING
- getCurrentMember;
@end

@protocol ScheduleActivity <Activity>
//S: ScheduleǤμ¹Ծ֡
//D: ScheduleǤμ¹Ծ֡
CREATING
USING
//M: ƥӥƥθ߻(hold֤ʤpending)ޤ
- (timeval_t)getCurrentTime;

//M: ׵ᤷãޤǥƥӥƥʤޤ
- stepUntil: (timeval_t)tVal;
@end

@protocol SwarmActivity <ScheduleActivity>
//S: Ȥ֥ƥӥƥΥ쥯
//D: Ȥ֥ƥӥƥΥ쥯

USING
//M: SwarmƥӥƥޤSwarm֥ȤС֤ޤ
- getSwarm;

- getSynchronizationSchedule;
@end

//
// Macros to access to the current context in which an action is executing
//

#define getCurrentSwarm() \
({ id swarmActivity; \
( _activity_current && \
  (swarmActivity = [_activity_current getSwarmActivity]) ? \
[swarmActivity getActionType] : \
_activity_context_error( "getCurrentSwarm" ) ); })

#define getCurrentSchedule() \
({ id scheduleActivity; \
( ( _activity_current & \
    (scheduleActivity = [_activity_current getScheduleActivity]) ) ? \
[scheduleActivity getActionType] : \
_activity_context_error( "getCurrentSchedule" ) ); })

//#: ߤΥƥӥƥλޥƥӥƥºݤäƤȤˤΤͭǤ(timeval_t)֤ޤ
#define getCurrentTime() \
({ id scheduleActivity; \
( _activity_current && \
  (scheduleActivity = [_activity_current getScheduleActivity]) ? \
[scheduleActivity getCurrentTime] : \
(timeval_t)_activity_context_error( "getCurrentTime" ) ); })

//#: ߤtopLevelActivityidޥƥӥƥºݤäƤȤˤΤͭǤ
#define getTopLevelActivity() \
( _activity_current ? [_activity_current getTopLevelActivity] : \
_activity_context_error( "getTopLevelActivity" ) )

#define getCurrentSwarmActivity() \
( _activity_current ? [_activity_current getSwarmActivity] : \
_activity_context_error( "getCurrentSwarmActivity" ) )

#define getCurrentScheduleActivity() \
( _activity_current ? [_activity_current getScheduleActivity] : \
_activity_context_error( "getCurrentScheduleActivity" ) )

#define getCurrentOwnerActivity() \
( _activity_current ? _activity_current : \
_activity_context_error( "getCurrentOwnerActivity" ) )

#define getCurrentAction() \
( _activity_current ? [_activity_current _getSubactivityAction_] : \
_activity_context_error( "getCurrentAction" ) )

@protocol GetSubactivityAction
//S: getCurrentAction()᥽åɤޤ
//D: getCurrentAction()᥽åɤޤ

USING
-	_getSubactivityAction_;  
@end

#define getCurrentActivity() \
( _activity_current ? [_activity_current getCurrentSubactivity] : nil )

//G: ߤΥƥȥޥѤƤѿ
extern id _activity_current;

//G: ߤΥƥӥƥ줿ȤȯԤ顼å
extern id _activity_context_error (const char *macroName);


@protocol ConcurrentGroup <ActionGroup, CREATABLE>
//S: 塼¹ԥ롼פȤƻȤǥեȷ
//D: 塼¹ԥ롼פȤƻȤǥեȷ
@end

@protocol ConcurrentSchedule <ActionGroup, CREATABLE>
//S: ¹ԥ롼פ˻ѤǤ١Υޥåס
//D: ¹ԥ롼פ˻ѤǤ١Υޥåס
@end

@protocol ActivationOrder <ActionGroup, CREATABLE>
//S: swarm¹ԥ롼פȤƻȤǥեȷ
//D: swarmΥƥֲˤäƽΥޡ򤹤¹ԥ롼ס
USING
//M: SwarmΥƥֲν¹ԥޡ򥽡Ȥ᥽å
- (void)addLast: mergeAction;

//M: Ȥ줿롼פ¹ԥޡ᥽å
- remove: mergeAction;
@end

//G: ͽ¬줿̵ȤȯԤ륨顼
extern id <Error> InvalidSwarmZone;


//G: _activity_zone -- ƥӥƥ֥Ȥ줿
extern id _activity_zone;

//G: ƥӥƥĥ꡼Τ٤ƤѹФƸƤӽФ٤ؿˤĤơƥӥƥ¹ԤΥХѿȥ졼ؿ
//G:
//G: աΥȥ졼եƥηФ륵ݡȤϡΥСǤϤޤäݾڤޤ󡣤ʤȤ⥤٥ȤΥActivityΰȤƴ˼ޤǤϡǥХåŪǥȥ졼եƥΤĤηĤޤ
extern BOOL (*_activity_trace)(id);  

#define COMPLETEDP(status) ((id)(status) == (id)Completed)
#define HOLDINGP(status) ((id)(status) == (id)Holding)
#define INITIALIZEDP(status) ((id)(status) == (id)Initialized)
#define RELEASEDP(status) ((id)(status) == (id)Released)
#define RUNNINGP(status) ((id)(status) == (id)Running)
#define STOPPEDP(status) ((id)(status) == (id)Stopped)
#define TERMINATEDP(status) ((id)(status) == (id)Terminated)

//
// include automatically generated definitions for activity package
//
#import <activity/types.h>
