// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:         collections.h
Description:  standard collection types   
Library:      collections
*/

#import <defobj.h>

//S: ɸॳ쥯󷿡

//D: collections饤֥ϡdefobj饤֥Υ饤֥ꥤ󥿡ե§˽ޤޤɸॹѡ饹ȤΥ饤֥륯饹˰¸ޤcollections饤֥ȡdefobj饤֥⼫ưŪ˽ޤޤdefobj饤֥collections饤֥׵᤹뤿ᡢץꥱˤϾξ󥯤ƤʤФʤޤ

@protocol Offsets 
//S: ֤ˤäƥ쥯Ф˥᥽å

//D: եåȤϡ쥯󥷡󥹤ˤФа֤ͿͤǤOffsetsǤϡC󥤥ǥåΤ褦˺ǽΥФΥȤϥǤ

//D: Offsetsϡ̤Υǥå֥Ȥ뤳Ȥʤ륳쥯ΥФ˥ؼʤ󶡤ޤArrayΤ褦ʤĤΥ쥯Υ֥פХեåȤˤꡢ®ľŪʥ򥵥ݡȤޤ¾Υ֥פϡ٤ƤΥФü᤯缡ƻȤƤΤߥХեåȤ򥵥ݡȤޤեåȤˤ륢ϡġΥ쥯󷿤ؤν®٤̤Ȥơ٤ƤΥ쥯ǥݡȤޤ

//D: atOffset:atOffset:put:ϡեåȤ̤뤤ϤΥ쥯ΥФΥȰʾǤȤˡ顼OffsetOutOfRangeȯޤ

USING
//M: ХեåȤΥФ֤ޤ
- atOffset: (int)offset;

//M: atOffset: put:åΥեåȤΥФ򿷤֤ͤΥեåȤΥ֤ͤޤ
- atOffset: (int)offset put: anObject;

//M: [aCollection atOffset: 0]ޤ
- getFirst;

//M: [aCollection atOffset: [aCollection getCount] - 1]ޤ
- getLast;
@end

@protocol ForEach
//S: 륳쥯ʣΥ֥ȤƱå¹Ԥå

//D: forEachåϡ쥯ΥФȤƴޤޤ뤹٤ƤΥ֥ȤˡƱå򷫤֤¹Ԥ᤯ʼʤǤåaSelectorǧޤΥ쥯ϡforEachåλĤΰåȤ˴ޤޤοƱΰɬפޤåΰididƱӥåȿ¾ηˤʤФʤޤ󡣥ХʰܿݤĤˡˤint(signedޤunsigned)Ʊ礭ǧƤޤʤ餺longƱ礭ǤʤƤ⹽ޤ󡣤ΥåѤˤϡʤidͤƤӽФɽΰȤid˥㥹ȤʤФʤޤ

//D: forEach:åϡǥåȤ쥯Τ٤ƤΥФñʥ롼פ¹Ԥ뤳Ȥˤޤʣʥåɬפʾ硢켫ȤΥǥåȥС롼פȤäơڥ졼ľܥɲƤ

USING
- (void)forEach: (SEL)aSelector;
- (void)forEach: (SEL)aSelector : arg1;
- (void)forEach: (SEL)aSelector : arg1 : arg2;
- (void)forEach: (SEL)aSelector : arg1 : arg2 : arg3;

- (void)describeForEach: outputCharStream;
- (void)describeForEachID: outputCharStream;

@end


@protocol Collection <Create, SetInitialValue, Copy, Drop, Offsets, ForEach>
//S: Υ쥯󥤥󥿡ե

//D: 쥯Ȥϡ֥ȥե󥹡뤤ϤΥ쥯ΥФȤŪ˳Ƥ¾ΥǡͤΥ롼פΤȤǤޤΥ֥פˤäƤϡФνŤ伱ѤΥͤȥФбʤɡ͡ʸߤδϢǥ쥯ФޤCollectionμʥ֥פˤϡArrayListSetMapޤCollectionΥѡפϡ٤Ƥcollections˥ݡȤ붦̤ε§(ȡϢå)Ωޤ

//D: ٤ƤΥ쥯ϡIndexȸƤФ̸ĤΥ֥ȤȤäФΥȥС򥵥ݡȤޤޤ٤ƤΥ쥯ϡФȤƲäǡͤηˤĤƶ̤ε§˽ޤ2ĤΥ֥ǡ٤ƤΥ쥯ΤδܵǽޤȤޤ

//D: ǥåϡ쥯󥷡󥹤θ֤߰򻲾Ȥ̤ʥ֥ȷǤ󥷡󥹤ϡ쥯γƥФ̩1ĤĴޤߤޤ٤ƤΥ쥯ϡΥǥåб뷿Υ֥Ȥޤ쥯Υǥåϡ쥯ľѤǤ뤢åΥ쥯ΥФǤ褦ˡ̤ˡޤǥåΥڥ졼󤬡쥯θġΥФ򰷤ǤŪǽʼʤ󶡤뤳Ȥ⡢ФФޤ

//D: 쥯ؤΥǥå֥ȤϡĤǤǤޤǥåϥ쥯Τ٤ƤΥФȥСŪʼʤǤƱ쥯ˡƱ뤤ϰۤʤä֤򻲾ȤʣΥǥåƱ¸ߤ뤳ȤǤޤcollectionˤäƤϡǥå̤ƥ쥯뤳ȤǽǤ

//D: ä󥤥ǥåȡ󥷡󥹤ΥФΥ󥹤ϡФ쥯ɲä줿¸Фʤ¤ꡢƱ֤Ǥ뤳ȤݾڤޤФΰ֤˰٥ȤȡǥåΤΤޤޤǤФΰ֤ˤȤɤޤޤ

//D: ¿collectionϡΥоŪʽ̤ŤޤΤ褦ʥ쥯ФơǥåˤäƻȤФΥ󥹤ϾˤνǰǤޤŪŪ˽ŤȡƱ쥯Τ٤ƤΥǥåʤ餺ƱХ󥹤Ĥ褦ˤʤޤ

//D: Τ褦ʽ̤ŤƤʤС٤ƤΥ쥯Υ󥹤ϡ줿ƥǥå˴ŤȤˤʤޤɤΥǥåˤĤƤ⡢٤ƤΥ쥯ФϤ󥷡󥹤Τɤˤʤ餺ޤޤޤƱ쥯2ĤΥǥåƱ󥹤ĤȤϸ¤ޤ

//D: Index¾¿Υ֥Ȼظ饤֥ƤiteratorޤûΤ̾Indexǡ륳쥯Ф뤳δܥݡȥ֥ȤΡŪǥޥǽŪ׻뤷Ƥޤǥå䥤ƥ졼Υǥ˴ؤܺ٤طʤˤĤƤϡcollections饤֥Υ󥿡ե߷פ˴ؤդ򻲾ȤƤ

CREATING
//M: booleanͥץϡФɲä򤹤٤ӽơ쥯ϰϤ¤ޤĤΥ쥯Υ֥פФƤϡִΤߤȤ¤ݤȤǡ꡼ɥ꡼¤Ʊ褦ʸΨθ̤뤳ȤǤޤReadOnlyץƱͤˡReplaceOnlyץϤȤȤ줬true˥åȤƤʤä˸¤ꡢ쥯κ˥ꥻåȤǤޤ
- (void)setReplaceOnly: (BOOL)replaceOnly;

- (void)setIndexFromMemberLoc: (int)byteOffset;

USING
//M: աcopy᥽åɤԡǤĤޤꥳ쥯¦ΥФϥԡޤ
- copy: aZone;

- (BOOL)getReplaceOnly;

//M: getCountϡߤΥ쥯˴ޤޤФο򼨤֤ޤ٤ƤΥ쥯ŪˤΥȤޤˤꡢñˤ֤ͤ׵ᤵ륳쥯ФΥȥС̵ʤޤ
- (unsigned)getCount;

//M: contains:åϡȤϤ줿ͤ˥ޥåͤ򤽤Υ쥯󤬴ޤtrue֤ޤ쥯Υ֥פˤäƤϡޥåФĤޤǡ쥯ФΥȥС׵᤹뤳Ȥˤʤޤ¾Υ֥פǤϡͤľܥǥåݡȤޤåϤν®٤˴طʤݡȤޤ
- (BOOL)contains: aMember;

//M: remove:åϡȤϤ줿ͤ˥ޥåͤĺǽΥФ򥳥쥯󤫤ޤꤷФ¸ߤʤnil֤ͤޤΥåcontains:åȼΤǡ®٤ϥ쥯Υ֥פ˰¸п㤷Ѳޤ
- remove: aMember;

//M: removeAllåϡ쥯δ¸Ф򤹤٤ƺΥХȤ򥼥˥åȤޤθ⥳쥯ͭǡɲäФԤޤΥåϡ줿ͤȤƤ֥Ȥˤϱƶޤ󡣤Υ֥Ȥ꥽񤷤Ƥ硢ͤκ(dropåΤ褦)¹ԤǤޤ
- (void)removeAll;

//M: removeAll:˲äФdropޤ
- (void)deleteAll;

//M: ٤ƤΥФƱ饹ΥФǤСYES֤ޤ
- (BOOL)allSameClass;

//M: begin:åϡ쥯ΥȤȥС뤿οǥåɸ᥽åɤǤǥå˴ؤܺپˤĤƤIndex򻲾ȤƤ
- begin: aZone;

- beginPermuted: aZone;
@end

@protocol Index <DefinedObject, Drop>
//S: 쥯󥷡󥹤ؤΥե

//D: ǥåϡ쥯󥷡󥹤ؤΥե󥹤ǤΤ褦󥷡󥹤ϡΥ쥯Τ٤ƤΥФ򡢤ǴޤǤޤνϡΥ쥯ΥФФ뤢ŤȤäƾ˰ݤޤϡΤ褦ʽ̤Ť¸ߤ뤳ȤȤƤޤ⤷̤Ť̵СΥ󥹤ꤵ줿Ǥ٤ƤΥФޤΤϡ쥯󤫤ΥФκɲäʤȤ˸¤뤳Ȥˤʤޤ

//D: ǥåκˤϡ쥯Фbegin:createIndex:åѤޤcollectionϤ줾б륤ǥåäƤꡢμΥ쥯ͭƤФơü첽ν򥵥ݡȤޤǥåϤäХ쥯󼫿ȤȤ̤Υ֥ȤǤΥ쥯󼫿Ȥ¸ߤƤ¤ͭʤޤޤǤƱ쥯ФʣΥǥåƱ¸ߤǤƥǥåϤΥ쥯󥷡󥹤ˤ켫Ȥΰ֤ݻޤ

//D: ¿Υǥåñ˥ФȥСǤʤ餬ȤƤ륳쥯뵡ǽ󶡤ޤ쥯ƤδˤĤơ쥯󼫿ȤǤԤⴰʼʤ򥤥ǥå󶡤뤳Ȥ褯ޤǥåΰ֤¾ξ֤ϼưŪ˹졢ΥǥåȤ̤Ƥʤ줿ѹȿǤޤ

//D: ¾Υǥå¸ߤƤȤ˥쥯ѹȡ¾ΥǥåŪʱƶ붲줬ޤ¸Υǥå˱ƶͿꡢ̵ˤꤹ뤳ȤʤѹˤĤƤϡcollectionβ򸫤ƤCollectionIndexSafetyץϡΩ˵ƶ饤ǥå­Ūˡ󶡤Ƥޤ

//D: ƥǥåϡåΰϤ줿˳Ƥ줿ɥΥ֥ȤǤΥϡ쥯Υ˥ޥåɬפϤޤ󡣥ǥå¸³֤Υ쥯¸³֤ûȤ褯ޤȤХǥåϡ롼ǤΤ߻Ѥ뤿ˡå뤳ȤǤޤ

//D: 쥯ؤΥåǥåͣͭˡǤäơcreateåΥץ󤬥ǥåȤȤ˻Ѥ뤳ȤϤޤ󡣥ǥåΤ٤Ƥͭʽϡ줬줿쥯ˤäƷޤޤ̾IndexϤ餬줿쥯η̾Ȥä̿̾ޤϼˡ쥯ΤηΥǥåФͭʡΥåΤΩޤ

//D: Index֥Ȥϡɸdrop:getZoneå˲äƥȥåץ٥DefinedObjectΥѡפΥ˥Сå򥵥ݡȤޤ餬쥯󤫤ǤʤǤ⡢ɸŪcopy:åȤС¸Υǥå鿷ǥå֥ȤǤޤƥԡϡǥåƱ쥯򻲾Ȥ󥷡󥹤Ʊ֤ǥȤޤʳΤ٤ƤǡԡϤɤνФƤȼΰ֤ݻΩǥåˤʤޤ

USING
//M: getCollectionϥǥåȤ륳쥯֤ޤΥ쥯ϡΥǥå¸³֡ѹ뤳ȤϤޤ
- getCollection;

//M: nextåϡ֤߰μˤͭʥФ뤤Ϥ٤ƤͭʥФθ̤ʰ֤˥ǥå֤ŤޤɤξǤ⡢ǥå֤Ť塢֤Ť줿֤ͤ뤤ϤΤ褦ʥФ¸ߤʤȤnil֤ޤ
- next;

//M: prevånextȻ褦ư򤷤ޤ֤߰ͭʥС뤤Ϥ٤ƤͭʥФ̤ʰ֤ˡǥå֤Ťޤ
- prev;

//M: findNext:ϡǥåΥͤ˥ޥåޤnext򷫤֤ޤ˥ޥåʤޤͭʥФνüãȡnil֤ޤ
- findNext: anObject;

//M: findPrev:ϡǥåΥͤ˥ޥåޤprev򷫤֤ޤ˥ޥåʤޤޥǥåͭʥФƬãȡnil֤ޤ
- findPrev: anObject;

//M: getϥǥå֤߰ŤƤ֤ͤޤǥåФ˰֤ŤƤʤnil֤ޤ

//M: getåϡ쥯ȥС롼פǸߤΥͤˡǤͤϡnextprevФκǽΰ֤Ť֤ΤƱǤ
- get;

//M: put:åϡߤΥǥå֤ΥФͤ򤽤ΰ֤ޤǥåߤΥФ˰֤ŤƤʤ硢InvalidIndexLoc顼ޤ
- put: anObject;

//M: removeåϥǥåθߤΰ֤ΥФ줿֤ͤޤǥå֤ϡ줿ФθΥФΥФδ֤̤ʰ֤˥åȤޤ³ФΥФʤȤϡ٤ƤΥФνüθ뤤ϳϰ֤̤ʰ֤˥åȤޤߤΥФȡߤΥǥå֤˥ФϤʤʤޤ³nextޤprevåϡߤΥФƤʤΤ褦ưޤǥåߤΥФ˰֤ŤƤʤȡInvalidIndexLocޤ
- remove;

//M: getLocåϡǥå֤߰ŤƤ֤η򼨤ܥ֤ޤΥǥå֥ܥϡStartEnd
#if 0
//M: Between
#endif
//M: MemberΤɤ줫ޤ

//M: StartܥϡΥ쥯󥷡󥹤ˤ뤹٤ƤΥФ̤ʰ֤򼨤ޤĤޤꡢǥåǽ˺줿Ȥΰ֤ǤEndܥϤΥ쥯Τ٤ƤΥФ³̤ʰ֡ĤޤnextåˤäƺǸΥФۤưưnil֤줿ȤΥǥåΰ֤򼨤ޤMemberܥϡ쥯󥷡Ρ븽ߤΥФ˰֤ŤƤ뤳Ȥ򼨤ޤ
#if 0
//M: The Between symbol indicates the special position
//M: between two other members, at which an index is positioned after a
//M: current member, between two other members, is removed. 
#endif

//M: nilͤĥФ¸ߤϤΥ쥯ȥСȤϡgetLocåɬפˤʤޤgetLocȤʤnext֤nilͤͭʥͤʤΤ뤤ϥФνü֤줿̤ͤʤΤ̤ˡϤޤgetLocȤС쥯ȥС롼פ˥Фνü(ޤϳϰ)ƥȤ롼ä뤳ȤǤޤ

//E: ʲϤˡ򼨤ץʥ롼פǤ:

//E: {
//E:   id <Index> index = [aCollection begin: aZone];
//E:   id member;
//E:
//E:   for (member = [index next]; [index getLoc] == Member; member = [index next])
//E:     {
//E:      // ΥФǲȤ򤹤 ...
//E:     }
//E:   [index drop];
//E: }
- getLoc;

//M: setLoc:åϡǥåθ֤߰StartEnd˥ꥻåȤΤ˻ѤޤΥåϡ쥯֤ΥФ˰֤Ť줿ǥå֤ᤷơƽΤ˻ѤǤޤޤprevǥФս˥ȥСΤΩäơ٤ƤΥФνü˥ǥå֤ŤΤˤѤǤޤ

//M: setLoc:StartEnd˲äBetweenAfterBetweenBeforeȤܥ뤬̤ʰͤĤޤΰͤϥǥåߤΥФ˰֤ŤƤˤΤͭǡߤΥФȤľޤľΥФδ֤̤ʰ֤˥ǥå֤Ťޤ
- (void)setLoc: locSymbol;

//M: ׻ε礭ʤʤСǥåϡ쥯󥷡󥹤ˤ븽ߤΥФΥեåȤǴޤեåͤϡCollectionatOffset:åΤƱäƤޤgetOffsetåϡθߤΥեå֤ͤޤߤΥǥåStartEnd˰֤ŤƤʤgetOffset-1֤Between˰֤ŤƤľΥФΥեåȤ֤ޤޤߤΥǥå饪եåȤѤǤʤʤ顢getOffset̤UnknownOffset֤ޤͤϥޥΤǡ32-bit2ɽˤ˼ޤ

//M: ǽStartEnd֤鷫֤줿ˤäƸߤΥǥåΰ֤˻äƤꡢδäȤʤ륳쥯¾ѹ̵ä硢ˤΥǥå饪եåȤѤǤޤĤΥǥåݡȤľŪʥХǤϡŪѤǤʤեåȤ⤿餹Τ⤢ޤ¤ˤĤƤϸġindexޤ
- (int)getOffset;

//M: setOffset:åȤȡ󥷡ΥФΥեåȤȤäơΥФľŪ˥ǥå֤Ťޤν®٤ϡCollectionatOffset:å褦ˡ쥯η˰¸ޤǰξ礳ν®٤ϥեåȤ礭㤷ޤ
- setOffset: (int)offset;

//M: compare:åϡ1ĤΥǥåθߤΰ֤ȡΰȤϤ줿̤Υǥåθߤΰ֤Ӥޤ2ĤΥǥåƱ֤ˤcompare:ϥ֤ǤʤФΥ쥯󥷡󥹤ˤơΥǥå¦ǥåˤ뤫ˤ뤫˱+1ޤ-1֤ޤ2ĤΥǥåΤɤ餫ΥեåȤ̤ΤǤȤ¾Υǥåΰ֤StartEndʳ뤤ϥФľˤСcompare:UnknownOffset֤ͤޤ
- (int)compare: anIndex;

//#: ǥåϰ֤ˤ뤫ƥȤޤ
#define INDEXSTARTP(obj) ((id) (obj) == (id)Start)

//#: ǥåüˤ뤫ƥȤޤ
#define INDEXENDP(obj) ((id) (obj) == (id)End)

//#: ǥåΥƥब줿ƥȤޤ
#define REMOVEDP(obj) ((id) (obj) == (id)Removed)

//G: ǥå֤Ф
extern id <Symbol>  Start, End, Between, Removed, Member;

//
// return value for index offset if not defined
//
#define UndefinedOffset -0x80000000;

//G: collectionserror
extern id <Error> OffsetOutOfRange, NoMembers, 
  AlreadyAtEnd, AlreadyAtStart, InvalidIndexLoc, InvalidLocSymbol;

@end


@protocol DefaultMember
//S: 쥯ΥǥեȥФΥåȤȼԤ᥽å

//D: Υץ󤬥åȤȡ٤ƤοФνͤͿ줿ͤ˥åȤޤ(åȤʤȤΥǥեȤnil)Ǥդ¾ͭʥ(nilޤ)饻åȤƤʤФ̤ȤǤΥץϡ˲餫Υåƥ󥰤ʤ줿ˤΤߡ˥ꥻåȤǤޤ(˥åȤͤϥǥեȤnilΤޤޤǤ⹽ޤ󤬡˥ꥻåȤˤͤŪ˥åȤƤɬפޤ)Υץgetåϡ˸ߤΥåƥ󥰤ޤΥȤäƿФνɬפʤȤͤϸϤޤ
SETTING
- (void)setDefaultMember: memberValue;

USING
- getDefaultMember;
@end

@protocol MemberBlock
//S: Ф¸C򥪥֥ȥ쥯Ȥƥåפˡ

//D: Υץϡ¸C򥪥֥ȥ쥯ȤƥåפʤȤʤޤưŪʥꥵϥݡȤʤʤޤMemberBlock˿ͿС󤬤Ǥ¸ߤǤåפ줿ߤC֤뤳ȤǤޤͿˤϡ˲餫򤷤ƤʤФʤޤ

//D: ȤMemberBlock꤬ʤƤʤƤ⡢󥪥֥ȤѤƤȤϡMemberBlockؤgetåϾˤФݥ󥿤֤ޤMemberBlockꤵƤС֤ݥ󥿤Ϳ줿ΤƱˤʤޤɤΥǤ⡢֤ݥ󥿤ѤСͥƥ֤CɽȤäǤդˡǥͤ򰷤ȤǤޤ󤬺줿ϡMemberBlockݥ󥿤Ū˳Ω줿Τ뤤ƤˤΤȽǤˡϤޤ󡣤ݥ󥿤ƤǳΩ줿硢ץǤΥ褦ȤꡢƳƤƤϤޤ

//D: гƤȤȤˡȤͿʤФʤޤ󡣤ˤϡcompound᥽åɤsetCount:ȤޤƤѤƤ硢ȤꥻåȤͣˡMemberBlockꥻåȤ뤳ȤǡsetCount:åñȤǻȤȤƤ⥨顼ȯޤгƤѤƤȤץϡMemberBlockͤͭ˳Ƥ줿Фݥ󥿤ȤʤäƤ뤳ȡƤΥ꤬ʤȤsetCount:Ϳ줿ХåȿޤǤ뤳ȤɬפȤʤޤ

//D: гƤȤС󼫿ȤϤΥƤ褦Ȥꡢ󤬥ɥåפ줿Ȥˤ褦Ȥꤹ뤳ȤϤޤΥɥåפϡƤؤλȤΤߤǤ

//D: гƤˤäƳƤʤᡢƤ줿Ʊΰʣ󤬻ȤǤޤˤϡϰ֤ȥȤǤ줾줿СåפƤϰϤޤޤޤνΤᡢ̡˺줿쥯ˤäơñϢ³ʬϰϤߤ˸뤳ȤǤޤ
CREATING
+ create: aZone setMemberBlock: (id *)members setCount:(unsigned)count;

SETTING
- (void)setMemberBlock: (id *)members setCount: (unsigned)count;

USING
- (void *)getMemberBlock;
@end

@protocol Array <Collection, CREATABLE, DefaultMember, MemberBlock>
//S: а֤ˤäƤΤߥ򥵥ݡȤ륳쥯

//D: ϡ쥯ΥФȤƤ٤Ʊ˺ФΥ쥯Ǥ¸ΥͤϿ֤ͤ뤫⤷ޤ󤬡мΤϤΥ쥯ΰꥪեåȤ˸ꤵޤθ깽¤ΤϳƥФΥľܷ׻Ǥ뤿ᡢեåȰ֤ˤäƥФؤζˤƹ®ʥǽˤޤ

//D: ArrayϡǤ⥷ץcollections饤֥collectionǡCľܥݡȤǡ¤˶ˤƻƤޤCȰ㤤°ФΥ롼פϤʤ餺⤽¸³֤˸ꤵޤ󤬡ۤʤäпޤळȤǤ褦ưŪ˥ꥵޤưŪ˥ꥵȤ¸Υͤϲǽʤ¿¸ޤ

//D: ArrayϡCollectionѾ줿ΥåˡۤȤɥåäޤǤդ¾μΥ֥ȥ쥯ƱѰʰϢδܥåȤäƸ깽¤Τ˥Ǥ褦ηʬŪ󶡤ޤޤArrayϥ쥯׵ᤵ뤹٤ƤΥƤޤ1ĤΥץȤơηϡФ¸C򥪥֥ȥ쥯ȤƥåפΤˤѤǤޤˡCɽȤäľФơCؤΥ󶡤뤳ȤǤޤ٥륢ν񼰤ϡ٥ȳ֥ȥξ礷ϥ֥åɥ⡼ɤѤ򥵥ݡȤޤ

//D: ArrayľܺǤġΥФκCollectionΤ٤Ƥɸå򥵥ݡȤޤ쥯(atOffset:, atOffset:put:)塢뤤ϥǥå(setOffset:)եåȤȤäåϡ٤ƹ®ʰλ֤ޤΥФϡեåȤˤäƴ˽ŤޤФФ뤽ΥФ̤ƤϢ³⡢˥ݡȤޤArrayϡCollectionѾ줿removeå̵ˤޤĤޤꡢåޤФ褦ȤȤݡȤƤʤȤ顼ޤ

//D: ArrayIndexSafetyץϥǥեȤUnsafeȤʤäƤޤΥꥵгƤΥꥻåȤФƥǥåܼŪ˰Ǥ(ƤġΥϡ֤ͤޤϴ¸Υǥå˱ƶޤ)IndexSafetyUnsafeAtMemberͤϡġΥФɲäǤʤ᥵ݡȤޤSafeAlwaysͤϡȤꥵƳƤäƤ⡢¸Υǥåˤޤ¸ΥǥåϤ˴ޤޤƤʤХ򻲾Ȥ硢ǥåϡEnd˥ꥻåȤޤ

//D: ReplaceOnlyץΥǥեͤϿǡС饤ɤϤǤޤ

//D: begin:֤ǥåηIndexǤArrayˤIndexǤǴ֤˹ʤ褦ɲååϤʤᡢ̤ʥǥåϤޤ

//D: ArrayκΥץϡ󤬤Ǥ˺줿Ǥ⤹٤ƥåȤǤޤʲ»դƤ

CREATING
+ create: aZone setCount: (unsigned)count;

SETTING
//M: Countץϡ쥯°Фο򥻥åȤޤޤǤʤͤͭǤǤ¸ߤ硢ȤޤǤδ¸ФϤδ¸ͤ¸뤳ȤˤʤޤȤ¸ΥȤ礭ȤϿ󤬺ޤξ硢٤ƤΥФ˳ƤǥեͤϡnilޤϤ餫DefaultMember˻ꤵ줿ͤǤ
- setCount: (unsigned)count;
@end


@protocol List <Collection, CREATABLE>
//S:  Ū˳Ƥ줿ʿΥФΥ쥯

//D: ꥹȤϳŪ˳Ƥ줿֤ФνʿǴ륳쥯ǤʿϥФɲä֤ˤäƳΩޤФϥꥹȤκǽ顢Ǹ塢֤ǤդΥݥȤɲäǤޤ

//D: ꥹȤϤޤФɲäε㤤ȤǡǤưŪʴܥ쥯1ĤȸޤǤդΰ֤ΥФκϡФɲäȤޤäƱͤ˴ñǤꥹȤϥФο˹碌ƼưŪ˿̤ޤꥹȤ礹륵¤Ϥޤ

//D: ListϡCollectionΤ٤ƤΥå򥵥ݡȤޤǥեȤΥץǺ硢եåȤˤ륢ν®٤ä˸夷ޤ

//D: EndsOnlyץ󤬻ꤵƤʤСIndexSafetyΥǥեͤUnsafeAtMemberǤĤޤꡢ륤ǥå֤Ф˱ƶ뤤ϥǥåд֤ˤȤϤľΥФ˱ƶСǥåϤɤˤܼŪ˰ǤEndsOnlyץ󤬻ꤵƤIndexSafetyΥǥեͤUnsafeǤξ硢ФɲäʤХǥå»ޤɤʾǤ⥤ǥåݤSafeAlwaysꤷƤ

USING
//M: addFirst:åϡꥹȤκǽ˿Фäޤ
- (void)addFirst: anObject;

//M: addLast:åϡꥹȤκǸ˿Фäޤ
- (void)addLast: anObject;

//M: ꥹȤǽΥФ֤ޤ
- removeFirst;

//M: ꥹȤǸΥФ֤ޤ
- removeLast;
@end

@protocol ListIndex <Index>
//S: ꥹȤǤդΥݥȤǤǽäǥå

//D: addAfter:addBefore:åϡꥹȤ˴줿Х󥹤ΥݥȤ˥Фɲäޤɲä뿷ФΥݥȤϡǥåθ֤߰ˤäƷޤޤaddAfter:åϡߤΥǥå֤ΤˤꥹȰ֤˥ФäaddBefore:Ϥΰ֤˥ФäޤɤΥå⥤ǥåθ֤߰ѹޤ󤬡StartEndΰ֤BetweenѤޤ

//D: ǥåϡꥹȤǤդΰ֤˰֤Ť뤳ȤǤ뤿ᡢΥåǤդΥФΥ󥹤ۤǤޤߤΥǥå֤ѹޤ󡣤äơꥹȤΤݥȤʣΥФϢ³ŪǤޤΤȤɲä줿ФϡФɲäˤĤƽ֤˲夲ޤ

//D: StartEndBetweenΰ֤ĥǥå⡢Ф˰֤Ť줿ǥåƱ褦ˡaddAfter:addBefore:ˤȤäͭʰ֤Ȥʤޤξ硢Υǥåθߤΰ֤˥ФϤʤᡢФϸߤΥǥå֤ľޤΤȤǥåϡФȡۤɵ٤äƤФδ֤˰֤Ť줿ޤޤȤʤޤΰ֤StartǥåaddAfter:뤤ΰ֤EndǥåaddBefore:ξ硢ǥåΰ֤StartEndΤޤޤǤ

//D: addAfter:addBefore:åEndsOnlyץȼä׵ᤵ졢ĥǥåΰ֤StartEndʳǤ硢뤤ϡǽǤǸǤʤФ˰֤ŤƤ륤ǥåremoveꥯȤ줿ϡ顼ޤ

USING
//M: ǥå֤θ˥Фɲäޤ
- (void)addAfter: anObject;

//M: ǥå֤˥Фɲäޤ
- (void)addBefore: anObject;
@end


//F: ֥ȤӤ롼
//F: (EQ)μ̤ˤΤΩޤ
extern int compareIDs (id, id);

//F: Ӥ롼
extern int compareIntegers (id, id);

//F: unsignedӤ롼
extern int compareUnsignedIntegers (id, id);

//F: CʸӤ롼
extern int compareCStrings (id, id);

@protocol CompareFunction
//S: 쥯ΥӤ˻Ѥcompareؿ륤󥿡ե

//D: 륭ͤ¾ΥͤӤɬפˤʤĤɡؿϸƤӽФ뤳ȤˤʤޤŵŪˤϡ쥯˥Фɲá뤿ӤʣƤӽФȯФޤޤ³ޤ

//D: compareؿ2ĤΥͤӤؿǡ쥯󤫤鷫֤ƤӽФޤδؿϥͤȤ0ǽΥ2Ĥ꾮Ȥ-11Ĥ᤬2Ĥ礭Ȥ+1֤ޤȤ줿쥯󤬥ȤƤʤȡʤˤϡɤ餬礭˴ؤ餺-1+1Τ줫֤ޤ

//T: The compare function accepts two key values as its arguments.  Like
//T: member types, key types declared with the id pointer type, but may
//T: contain any type of value (such as an integer) up to the size of an
//T: id.  An explicit compare function can support any type of value as a
//T: key, regardless of whether it is an object that supports a standard
//T: compare: message.
typedef int (*compare_t) (id, id);

CREATING
- setCompareFunction: (compare_t)aFunction;

USING
- (compare_t)getCompareFunction;
@end

@protocol KeyedCollection <Collection, CompareFunction>
//S: SetMap˶ͭФΥǥƥƥ

//D: 줿쥯ǤϡФ̤¾Τ(ХȸƤӤޤ)ȤäƳƥФӤǤޤͤϡͼȤˤä(Setޤ)뤤ϤΥФǽɲäȤΥФȤγŪʴϢˤä(Mapޤ)ꤵޤ

//D: KeyedCollectionϡCollectionΤ٤ƤɸŪʿ񤤤ѾޤηΤϺԲǽǡSetMap collectionؤζ̤ΥѡפȤѤǤǤ

//D: 줿쥯󷿤ϡSetMapξǶͭŪʿ񤤤Ωޤ쥯ΥФνŤɸ४ץ󶡤Ƥޤ
CREATING

USING
- createIndex: aZone fromMember: anObject;

//M: at:åϡȤϤ줿ͤ˥ޥå륳쥯δ¸Ф֤ޥå륭ͤΥ쥯̵Ȥnil֤ޤΥ˥ޥåФʣ¸ߤ硢ΥͤФƺ줿ʣФΥ쥯Τ֤ޤ
- at: aKey;

//M: removeKey:åϡͤ˥ޥåФ򥳥쥯󤫤κ줿Ф֤ޤ쥯˥ޥå륭ͤʤϡnil֤ޤΥ˥ޥåФʣ¸ߤ硢ʣФФƺ줿쥯κǽΥФ֤ޤ
- removeKey: aKey;

@end

@protocol KeyedCollectionIndex <Index>
//S: SetMap˶ͭIndexο

//D: 줿쥯Ф륤ǥåϡΥ쥯Τ٤ƤΥФȥСޤΥФϡͤʣ֤Ϥ줿ФΥ쥯°ƤƤ⹽ޤ󡣤Ūˤϡǥåϸ߽Τꥵ֥쥯Υȥåݻޤ

@end


@protocol MemberSlot
//S: ®setMember:/setKey:Υ/γ

//D: MemberSlotץϡƥ˶֤ݤƤ뤳Ȥ򼨤ޤˤꡢ륳쥯ˡΰ֤Ф󥯤ľܴޤळȤǤޤΤ褦ʶ֤ݤƤСΥФؤľŪʥǥå᤯֤Ť̤ʥåѤǤޤޤФ⤫ʤ®Ǥ

//D: MemberSlotͤϡ֥󥯤ζ֤ݤƤƥФγϰ֤ΥХȿɽեåȤꤷޤ

//D: Фγϰ֤ΰ֥󥯤ΥեåȤϡ-2048+2047ϰϤͤͤˤʤޤMemberSlotΥǥեͤUnknownOffset(礭)ǡϳƥѤǤ֥󥯤ΥåȤʤȤꤷޤ

//T: This type declares the required space for a position link in a
//T: collection that does not accept duplicate key values.

//T: If a member slot is defined, a memory pointer of some kind must always
//T: be used for the value of every member.  These members may be object id
//T: pointers, but other types of memory pointers are acceptable as well.

//T: The contents of the first two words of position link vary according to
//T: the position of a member in a collection. 
typedef struct memberData { void *memberData[2]; } member_t;

//T: The third word of a
//T: dupmember_t link contains the id of the collection in which a member
//T: is directly contained.  This collection is either an internally
//T: created collection containing members with duplicate keys, or the
//T: collection to which the member was added if there is no other member
//T: with the same key.
typedef struct { void *memberData[2]; id owner; } dupmember_t;
@end

@protocol Set <CREATABLE>
//S: 줾줿ǥƥƥĥФΥ쥯

//D: SetKeyedCollectionΥ֥פǡƥФб륭ͤϥͼȤˤäƷޤޤͤϥмȤƤ⡢뤤ϺץȤäƥФaؿȤƤ⹽ޤ

//D: SetϤΥ󥿡եʬKeyedCollectionѡפѾޤSetϡKeyedCollectionǤץʾ˺ץ뤳ȤϤޤ󡣥compareؿbucketؿꤵȡδؿΥͰȤƥͤϤޤδؿϡɤΥФˤͤꤹ뤳ȤǡͤΤɤʬͤǤ뤫ꤷޤ

USING
//M: add:åset˿Фäޤä줿ФǤˤSet˴ޤޤФΥ˥ޥåtrue֤ޤФºݤˤΥ쥯˲ä줿ݤϡDupOption˰¸ޤ
- (id *)add: anObject;

///M: The add:setIndex: message adds a new member to a set just like add:,
///M: but also has a side effect of setting the position of the index passed
///M: as the setIndex: argument to the member which was just added.  If an
///M: index positioned to the new member is needed anyway, setting the index
///M: in the same operation avoids repeating a search for the position at
///M: which the member key belongs.
// - (BOOL)add: anObject setIndex: anIndex;

//M: replace:åϡͿ줿˳ǼƤФƱ˥ޥå̤Υ֤ͤޤ¸֤ͤ뿷ͤϰȤϤޤreplace:֤줿֤ͤ뤤ϥ˥ޥåФ쥯˴ޤޤʤȤnil֤ޤ
- replace: anObject;
@end

@protocol OrderedSet <List, CREATABLE>
//S: Ū˳Ƥ줿ʿΥФν

//D: OrderedSetŪ˽Ť줿ФΥ쥯ǤΥ쥯Ǥϡ٤ƤΥФͤӤΤʥǥƥƥäƤޤ

//D: (.. ߤηϡХåȤ٥륪ץȤäƤΤ߼졢ΥץΥåϡKeyedCollectionεҤ˥ޥåޤ󡣤Υ֥ȤΤɤ줫ɬפʤȤϡListȤ¾μǤޤԤäƤ)

//D: OrderedSetΥФΥ󥹤ϡListΥХ󥹤åƱåȤäƳΩޤOrderedSetϡSetKeyedCollectionΤȤơˤ륫ಽȥ򥵥ݡȤޤ餹٤ƤΥΥåηΤOrderedSetΤΥ󥿡եޤʣĥФOrderedSetˤ̵ǤƥФϡΥХ󥹤˥ˡʰ֤äƤʤФʤޤ
@end

@protocol Map <KeyedCollection, CREATABLE>
//S: ֥ȤХ֥ȤФбΥ쥯

//D: MapKeyedCollectionΥ֥פǡƥФб륭ͤϥмȤΩƤޤФ򥳥쥯ɲäȤϡΤĤɲåФб٤ͤ󶡤ʤФʤޤMapϥͤͤؤΥޥåԥ󥰤ޤ

//D: MapǤϡͤбͤΩƤޤMapϤΥͤ˴ؤ뵭ҾˤĤ2Ĥ­ŪʥץޤMapϤޤξޤढǡͤȥ̤ͤåޤ

USING
//M: at:insert:ϡΰȤͿ줿ͤȥͤޤMap˥ȥޤˤΥ쥯˴ޤޤƤʤtrue֤ʣ褦Ȥȡݤfalse֤ޤ
- (BOOL)at: aKey insert: anObject;

//M: ͤб¸Υͤ򡢺ǸΰͿ줿֤ͤޤΥåϡޤǥͤбƤ֤ͤƱĥФʣ¸ߤnil֤ޤ
- at: aKey replace: anObject;

- removeKey: aKey;
@end

@protocol MapIndex <KeyedCollectionIndex>
//S: MapФ륤ǥåο

//D: MapФ륤ǥåο

USING
//M: setKey:åϡ˥ޥå륭ͤĥȥ˥ǥå֤Ťޤͤ˥ޥå륨ȥ꤬ʣȡǥå֤ϥޥåǽΥȥˤʤޤ
- setKey: aKey;

//M: getKeyåϡǥåθߤΰ֤б륭֤ͤǥåɤΥФˤ֤ŤƤʤnil֤ޤ
- getKey;

//M: ΥƥȤΥ֤ޤ
- next: (id *)key;

//M: ΥƥȤΥ֤ޤ
- prev: (id *)key;

//M: ߤΥƥȤΥ֤ޤ
- get:  (id *)key;
@end


@protocol OutputStream <Create, Drop, CREATABLE>
//S: ϥХ

//D: ߤOutputStreamϤ˰ŪstreamФץ졼ۥǡեؤʸν񤭹ߤ򥵥ݡȤƤǤstreamϥФϢ³Ūɲ(ϥȥ꡼)(ϥȥ꡼)򥵥ݡȤ륳쥯Ǥ
CREATING
+ create: aZone setFileStream: (FILE *)fileStream;
- setFileStream: (FILE *)fileStream;

USING
- (FILE *)getFileStream;
- (void)catC: (const char *)cstring;
@end

@protocol InputStream <Create, Drop, CREATABLE>
//S: ϥǡ

//D: ηLispɽꥹȤɤ߹ߤޤ
CREATING
+ create: aZone setFileStream: (FILE *)file;
-               setFileStream: (FILE *)fileStream;

USING
- (FILE *)getFileStream;
- getExpr;
@end

//G: ֥ѡѤȡ
extern id <Symbol> ArchiverLiteral, ArchiverQuote, ArchiverEOL, ArchiverDot;

@protocol ArchiverKeyword <Create, Drop, CREATABLE>
//S: ꥢ饤ΥɤΥץ벽
//D: ꥢ饤ΥɤΥץ벽
CREATING
- setKeywordName: (const char *)name;
USING
- (const char *)getKeywordName;
@end

@protocol ArchiverArray <Create, Drop, CREATABLE>
//S: ꥢ饤Υץ벽
//D: ꥢ饤Υץ벽
CREATING
- setArray: array;
USING
- (void *)getData;
- (unsigned *)getDims;
- (size_t)getElementSize;
- (unsigned)getElementCount;
- (void)drop;
@end

@protocol ArchiverValue <Create, Drop, CREATABLE>
//S: ꥢ饤ͤΥץ벽
//D: ꥢ饤ͤΥץ벽
CREATING
- setDouble: (double)val;
- setFloat: (float)val;
- setInteger: (int)val;
- setChar: (unsigned char)val;
- setBoolean: (BOOL)val;
- setNil;
USING
- (char)getValueType;
- (double)getDouble;
- (float)getFloat;
- (int)getInteger;
- (unsigned char)getChar;
- (BOOL)getBoolean;
- getObject;
- (void)drop;
@end

@protocol ArchiverPair <Create, Drop, CREATABLE>
//S: ꥢ饤ΥꥹȥڥΥץ벽
//D: ꥢ饤ΥꥹȥڥΥץ벽
CREATING
- setCar: car;
- setCdr: cdr;
USING
- getCar;
- getCdr;
@end

#define ARCHIVERDOTP(obj) ((id) (obj) == (id) ArchiverDot)

@protocol String <Create, Drop, Copy, CREATABLE>
//S: ʸ󥪥֥(˥쥯ο񤤤򥵥ݡȤޤ)

//D: String֥ȷϡC񼰤nullǽʸ򥪥֥Ȥ˥ѥåޤʸͤݻΤɬפʤ٤ƤΥƤϡΥ֥ȤޤߤΤηϡCʸνɲäȤǤŪΤߤǤߤ¤줿䡢Ĥޤʸ¾μγƥ֥ȤΰɬפȤˤϤǽʬǤ

CREATING
+ create: aZone setC: (const char *)cstring;

SETTING
- (void)setC: (const char *)cstring;

USING
- (const char *)getC;
- (void)catC: (const char *)cstring;
- (unsigned)getCount;
- (int)compare: aString;
@end

@protocol ListShuffler <Create, Drop, CREATABLE>
//S: Swarm Listνޥ륯饹

//D: ListShufflerϡListΥȤνޥ(ꥹΡ뤤numǾΥ)ޤꥹȤ󶡤ƤʤФʤޤ󡣰ʬۤƥब󶡤ƤuniformUnsRandѤޤ르ꥺKnuthΤΤǤΥ᥽åɤϤ٤ƴäȤʤ륳쥯ѹä뤿ᡢǥåϤ٤ƺƺʤФʤޤ
CREATING
//M: setUniformRandom:᥽åɤϡͿ줿ʬۤShuffler³ޤ(createBegin:θǼ¹ԤƤ)
- setUniformRandom: dist;

- createEnd;

//M: create:setUniformRandom᥽åɤϡShufflerͿ줿ʬۥ֥Ȥ³ޤ
+ create: aZone setUniformRandom: dist;

USING
//M: shuffleWholeList᥽åɤϡꥹΤޥޤ
- shuffleWholeList: list;

//M: shufflePartialList:Num᥽åɤϡꥹȤ'num'κǾȤνޥޤ(num>ꥹȤΥ)ǻꤹȥꥹΤޥޤ
- shufflePartialList: list Num: (unsigned)num;
@end

@protocol PermutationItem <CREATABLE, Create>
//S: Υ

//D: Υ
CREATING
- setItem: item;
- setPosition: (int)position;

USING
- getItem;
- (int)getPosition;
@end

@protocol Permutation <Collection, CREATABLE, Create, Array>
//S: 쥯ΥȤν򼨤饹

//D: Permutationϥ쥯ΥȤν®ʥǤ褦ˤ˳ǼޤPermutationϤȤΥ쥯ߥ顼ǤPermutationƤ򹹿Ƥ⸵Υ쥯ˤϱƶޤ

CREATING
+ createBegin: aZone;
- setCollection: collection;
- setUniformRandom: rnd;

USING
- generatePermutation;
@end

@protocol PermutedIndex <Index>
//S: PermutedIndex饹

//D: PermutedIndex饹ϡ쥯Υޥ줿ȥС˻Ѥޤ᥽åɤϡȥСޥIndex饹ΤƱǽ󶡤ޤ
CREATING
+ createBegin: aZone;
- setCollection: aCollection;
- setUniformRandom: rnd;
- createEnd;
USING
- reshuffle;
- next;
- prev;
- findNext: anObject;
- findPrev: anObject;
- get;
- getLoc;
- (void)setLoc: locSymbol;
- (int)getOffset;
- setOffset: (int)offset;
@end;

#import <collections/types.h>
