// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:         defobj.h
Description:  standard objects for GNU Objective C extensions
Library:      defobj
*/

#import <defobj/deftype.h>

//S: GNU Objective Cĥɸ४֥

//D: defobjϡSwarmΤǻѤ륪֥Ȼظץߥ󥰤Υ򥵥ݡȤޤdefobjΤϡ֥Ȥκȥ졼γơ顼ǥХåݡȤȤäObjective CѤ뤿ȼΥǤ

@protocol Serialization
//S: ֥ȥꥢ饤ץȥ롣
//D: ֥ȥꥢ饤ץȥ롣

CREATING
//M: ɽΥɥѥ᡼ơΥѥ᡼ޤ
- lispInCreate: expr;

//M: HDF5֥ȤơΥѥ᡼ꤷޤ
- hdf5InCreate: hdf5Obj;

//F: Load an object from a lisp expression of the form
//F: (make-{class,instance} :arg1 x :arg y). 
extern id lispIn (id aZone, id expr);

//F: Load an object from a HDF5 object.
extern id hdf5In (id aZone, id hdf5Obj);

USING
//M: 󥹥ѿ̾/ͥڥΥꥹȤ顢֥Ȥξ֤Υ֤줿Lispɽޤ
- lispIn: expr;

//M: ֥Ȥξ֤Lispɽ򡢥ȥ꡼ؽϤޤ
- lispOutShallow: stream;

//M: ֥Ȥξ֤οLispɽ򡢥ȥ꡼ؽϤޤ
- lispOutDeep: stream;

//M: HDF5֥Ȥ饤󥹥ѿɤޤ
- hdf5In: hdf5Obj;

//M: ֥Ȥξ֤HDF5ɽ򡢥ȥ꡼ؽϤޤ
- hdf5OutShallow: hdf5obj;

//M: ֥Ȥξ֤οHDF5ɽ򡢥ȥ꡼ؽϤޤ
- hdf5OutDeep: hdf5obj;

- updateArchiver;

//F: Expect and convert a boolean from next index item.
extern BOOL lispInBoolean (id index);

//F: Expect and convert an integer from next index item.
extern int lispInInteger (id index);

//F: Expect and convert a string from next index item.
extern const char *lispInString (id index);

//F: Expect and convert a keyword from next index item.
extern id lispInKeyword (id index);

@end

@protocol DefinedObject
//S: ȼĥ֥ȡ

//D: DefinedObjectϡdefobj饤֥Υ֥ȥץߥ󥰵§˽äȥåץ٥ΥѡפǤη줿åϡε§˽֥ȤǼưŪѲǽȤʤͣΥåǤäˡGNU Objective C󥿥Objectѡ饹åλѤȤƤϤޤ󡣤ʤʤ顢Υ֥ȤμΥåؤΥĤȤϸ¤ʤǤ

//D: DefinedObjectɬ׺¤ɸåޤŪǤդˡǸġΥ֥ȤŬѤ롢뤤ŬѤʤå¾ηǹԤޤ
USING
//M: getZoneåϡ֥Ȥ֤ޤ
- getZone;

//M: ֥Ȥselector˻ꤵ줿åƤСrespondsTo:åtrue֤ޤåȤȤϡå֥Ȥ줿ˡ餫Υ᥽åɤȤȤ˲᤮ޤ(Ǥ⤳Υ᥽åɤϥ顼ȯǽޤ)respondTo:åϥ᥽åɥǥѥåơ֥ǤľܥååפˤäƼޤäơ̤ΥåΤ®ϤޤäѤޤ󡣤륪֥ȤηΥåޤǤ뤫᤯ƥȤʤȤʤޤ
- (BOOL)respondsTo: (SEL)aSel;

+ (BOOL)conformsTo: (Protocol *)protocol;

//M: getClassϡ֥Ȥθߤο񤤤Ƥ륯饹֤ޤ
- getClass;

//M: getTypeNameϡΥ֥ȤθȤʤ뷿֤̾ޤ
- (const char *)getTypeName;

//M: ֥Ȥѹ뤫ƥȤ뤿ӤΤ륪֥Ȥˡե󥹤ɲäޤ
- (ref_t)addRef: (notify_t)notifyFunction withArgument: (void *)arg;

//M: ֥Ȥؤγե󥹤ޤ
- (void)removeRef: (ref_t)refVal;

//M: Object᥽åɤΥʼ
- (int)compare: anObject;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel with: anObject1;

//M: Object᥽åɤΥʼ
- perform: (SEL)aSel with: anObject1 with: anObj2;

//M: 3ĤΥ֥ȰȤäƥ쥯¹Ԥޤ
- perform: (SEL)aSel with: anObject1 with: anObj2 with: anObj3;

//M: ɽѤ⤷ϥǥХåѤΥ֥Ȥ̤̾ȤơʸƤޤ
- (void)setDisplayName: (const char *)displayName;

//M: ɽѤΥ֥Ȥ̤ʸ򡢰˳Ƥʸ󤫥ǥեȤμʸΤ줫֤ޤ
- (const char *)getDisplayName;

//M: describe:åϰȤϤ줿֥Ȥˡ֥ȤΥǥХåŪȤñץȤޤoutputCharStreamϤ줿֥Ȥϡcollections饤֥StringOutputStreamƤ褦ʡcatC:åʤФʤޤ󡣥֥ȷˤäƤϡӥȥ󤵤줿ǥեȤۤɲþޤ֥ȵʸ礬ޤǥեȤǤϡ饹֥̾Ȥɽ̾(⤷)˲äơ֥idݥ󥿤16ͤץȤޤ
- (void)describe: outputCharStream;

//M: ӥȥ󤵤줿ǥեȤޤ1ԤʸoutputCharStream˥ץȤޤ
- (void)describeID: outputCharStream;

//M: describe:ƱǤϤɸϤˤʤޤ
- (void)xprint;

//M: describeID:ƱǤϤɸϤˤʤޤ
- (void)xprintid;

//M: ǥХåϥȥ꡼ˡ쥯γƥФץȤޤ
- (void)xfprint;

//M: ǥХåϥȥ꡼ˡ쥯γƥФidץȤޤ
- (void)xfprintid;
@end

@protocol Customize
//S: եΥޥ

//D: ˤäƤϡ󥹥󥹤ǤϤʤηȤοС򥫥ޥ뤿ˤΥåѤǤޤޥ뷿륪֥ȤϡΥޥ뷿줿å餫᥻åȤ줿ץĤȤˤʤޤƱץɬפȤ륪֥Ȥ¿Ȥϡޥ뷿ΥСäƤη餵ʤ륤󥹥󥹤Ȥˡ̾ϴñǤ®Ǥ

//D: ֥ȤΥޥǡꥸʥη֥Ȥѹ뤳ȤϤޤ󡣤ˡޥǽȤ߹ޤ줿֥Ȥޤ֥Ȥcreate:åϡcreateBegin:createEndȤäƺƱå󥹤η֥Ȥ줿Τ褦ˡ󥹥󥹤ޤΥޥϡ󥹥󥹤createBegin:createEndåȤäƺΥå󥹤򤯤뤳ȤǤʤΤǤϤޤcreateBegincreateEndåѤޤ

//D: ޥ줿ΥСǤ뤫ϡηȤμˡ˰¸ޤޥбƤʤ硢ηؤcustomizeBegin:åϥ顼ˤʤޤ@protocol줿Ϥ٤ơ֥Ȥ뾯ʤȤ1Υޥ򥵥ݡȤΤȹͤ뤳ȤǤޤǤ˥ޥ줿(customizeEnd֤)֥ȤʾΥΥޥ(⤦1ȤcustomizeBegin:/customizeEnd󥹤ˤ)򥵥ݡȤ뤫ݤϡǽ˷ѾϤ᤿ꥸʥημˡ˰¸ޤŪ˵ҤƤΤǤʤСʣΥޥ򥵥ݡȤȹͤƤϤޤ

CREATING
//E: newArrayType = [Array customizeBegin: aZone];
//E: [newArrayType setCount: 100];
//E: newArrayType = [newArrayType customizeEnd];
//E: array1 = [newArrayType create: aZone];
//E: array2 = [newArrayType create: aZone];
//E: // [array1 getCount][array2 getCount]ϡȤ100

//M: createBegin:Τ褦ʺΥå뤿ΰ֤ͤޤ

//M: customizeBegin:Ϥ륾ϡǽŪʷ֥ȤΥȥ졼ݤ뤳Ȥˤʤ륾˰פޤΥϤη˺륤󥹥󥹤ƱˤɬפϤޤ󡣤ηФ뺣createåˤϡ٤ƿϤ뤫Ǥ
+ customizeBegin: aZone;

//M: ꥸʥηΡޥ줿С֤ޤ
- customizeEnd;

//M: customizeCopy:åϡcustomizeBegin:֤֥Ȥοԡޤΰ֥ȤϤǤ˽Υޥ˱ƶͿʤޤޡ˥ޥԤΤ˻ѤǤޤĤޤꡢΥåϿʹΥޥʬơ⤦1ĤκǽŪ˥ޥ줿֥Ȥ뤿˻Ѥޤ

//M: customizeCopy:ϡcustomizeBegin:֤֥ȤcustomizeEnd:Ǵ뤵ƤʤˤΤ߻ѤǤޤޥ줿֥ȤοСϡcustomizeCopy:׵᤹zoneѤơꥸʥΥСƱ⤷ϰۤʤä˳뤳ȤǤޤ

//E: newArrayType1 = [Array customizeBegin: aZone];
//E: [newArrayType1 setCount: 100];
//E: newArrayType2 = [newArrayType2 customizeCopy: aZone];
//E: [newArrayType2 setDefaultMember: UnsetMember];
//E:
//E: newArrayType1 = [newArrayType1 customizeEnd];
//E:  newArrayType2 = [newArrayType2 customizeEnd];
//E: array1 = [newArrayType1 create: aZone];  // DefaultMemberץʤ
//E: array2 = [newArrayType create: aZone];   // DefaultMemberץ󥻥å
- customizeCopy: aZone;
@end


@protocol Create <DefinedObject, Customize>
//S: ޥȤ(ץʥ)Υ󥹥󥹤ޤ

//D: Createѡפϡ֥Ȥ뤿ѥץȥ󶡤ɸåޤΥåϡ1ĤΥå˿Υ󥹥󥹤Ȥ뤤Ϻ٤֥ȤѤǤ륪ץ򥫥ޥϢΥå򤯤Ȥ˻ѤǤޤλͤΥ֥Ȥο񤤤ʬΥ뤳ȤǡŪʷġΥˡŬ뤿ι⤤ޤޤ

//D: createåϡƤ륯饹򱣤ˤäƼꡢ뤤ϥ֥Ȥ뤿ΰͤʥ󥿡եȤƤΥåѤƤ륯饹ˤäľŪ˼뤳ȤǽǤ饹ľܼ硢Υ饹֥ȤϤθ³٤ƤΥåҤˤƷ֥ȤȤΩޤʳξ硢֥Ȥ͡ǼǤޤȯԤ줿åȤȤ«ޤ

//D: Createcreateå˲ä֥ȷ¾Ǥդ̾ƤӽФ§Τå򥵥ݡȤǤޤΥåϡ¾ηε§˽äƼͳ˷ѾǤ뿷֥Ȥ뤿ɸ᥽åɤޤʤ뵬§̤ξǳΩޤɸŪˤĤƷåǤĤΥƥåפ礷createå礷ޤ

//D: createBegin:ޤcustomizeBegin:Τ줫֤٤Ƥΰ֥ȤϡgetZoneådropå򥵥ݡȤޤΥåϡǽ󥹥󥹤Ǥ⥵ݡȤǤޤĤޤꡢΥåDrop졢̾Ϥ뷿ˤѾФơǽ󥹥󥹤Ǥ줬Ǥ褦ˤʤޤηCreateˤϷѾޤ󡣤ʤʤ顢ˤΥåŬѤΤϡ֥ȤǤʤǽ󥹥󥹤ǤΥåϤȤƤʤƤ⡢֥ȤѤǤޤ֥ȤФdropåϡ䥫ޥǤ˳Ϥ줿塢ϤǽСפȽ˻ȤȤˤʤǤ礦

//D: createBegin:createEndåϡƤ륪֥ȤΥץꤹϢΥå򤯤ޤ2ĤΥåδ֤˥åϤळȤǡΥѥ᡼Ȥͤ򥻥åȤꡢѲǽʥåȤä¾ηλͤͿ뤳ȤǤޤġΥ֥ȷϡΰեĤΥåޤ

//E: newArray = [Array createBegin: aZone];
//E: [newArray setInitialValue: aList];
//E: [newArray setDefaultMember: UnsetMember];
//E: [newArray setCount: [aList getCount] * 2 );
//E: newArray = [newArray createEnd];   // ! note reassignment of newArray

CREATING
//M: create:åϡǥեȤΥץä󥹥󥹤ޤzoneϿ֥ȤΤΥȥ졼ꤷޤΥå륪֥ȤϡǤƤ륪֥ȤǤΥåǤ˺줿ηΥ󥹥󥹤ǤϤʤ֥ȤΤΤˤΤ߼褦å+դΥ饹åȤޤ

//M: create:åϺ줿֥Ȥ֤ޤΥ֥Ȥϡη뤿򤵤줿륯饹Υ󥹥󥹤ǤgetClassåȤХ֥Ȥ뤿˷򤷤饹Ǥޤ¾ˡǸƤӽФΥץफ餽Τ뤳ȤϤǤޤ󡣤ΥåȤäƥ֥ȤƤȤƤӽФϤʤ륯饹̾⻲Ȥޤ󡣸ƤӽФȤΤϷ̾Ǥ̾Ϥɤ@protocolǤ⥰ХȤƼưŪȯԤޤ
+ create: aZone;

//M: createBegin:ϡΥåŪò֥Ȥ֤ޤ@protocol줿ΤǤСΥåCREATINGޤSETTINGˤΤǤʳξϡιʸޡʤåȤͭʥåޤ
+ createBegin: aZone;

//M: createEnd åϡ줿֥Ȥͭʥץꤹץλޤ̤ˤΥå׵ᤵƤ륪ץͭǤꡢߤ礬Ƥ뤳Ȥǧ˰ȿåХ顼ȯޤɸ२顼InvalidCombinationȯԤꥯȤȤ߹碌򼨤ȤǤޤ뤤¾ΤŪʥ顼ϥɥ󥰤Ѥ뤳ȤǤޤ

//M: ǽcreateBegin:ʹߡġΥꥯȤ䤽Ȥ߹碌٤ͭ˼Ĥ줿硢createEndϼä٤ƤΥꥯȤ֥ȤκǽŪʷꤷΥ֥Ȥ֤ޤǽŪʥ֥Ȥ׵᤹뤢ɲåȥ졼ϡcreateBegin˺ǽϤ줿Ʊ󤫤ޤΥ֥ȤϡġΥꥯȤФ줿ɤμʤƤϤǤۤʤäꥯȤϡޤäۤʤä֤Ǥ礦֤륪֥Ȥϡǽ֥ȤθѤǤ褦줿å򥵥ݡȤ뤳Ȥݾڤޤ뷿@protocolˤä줿硢ΥåSETTINGޤUSINGΤ줫˸åǤ

//M: createEnd֤ͤƱˡcreateBegin:֤֥ȤidϤϤ亣ѤͭǤ뤫ݾڤޤ󡣤äơΥ֥ȤϻȤʤǤidΤ褦ʥ֥ȤݻѿˤϡcreateEnd֤idƳƤ뤳ȤǤޤˤꡢΥ֥ȤϢ³СƱѿݤޤ
- createEnd;

@end

@protocol Drop
//S: ˳Ƥ줿֥Ȥޤ

//D: DropѡפdropåޤdropϤΥ֥ȤϤ¸ߤ٤ȻȤʤȤ򼨤ɸåǤdrop¹Ԥ줿֥Ȥ򤳤θ˻Ȥ褦ȤСʤ餺顼ȯޤΥ顼ͽ¬ǽʱƶĤϡǥХåå䤽¾ǤΥ٥ˤޤ

//M: dropåľŪʱƶϡΥ֥ȤΥȥ졼뤿˻ѤΥ֥פ˰¸ޤ󷿤ˤäƤϡdropå֥ȤΥȥ졼¨¤˲¾ŪǤΥȥ졼ѤǤ褦ˤʤΤ⤢ޤʹߤλѤǤϡޤäƱ֤˿֥ȤƤΤǡdrop֥Ȥidȿ֥idƱˤʤޤ

//M: DropϡΥ󥹥󥹤Фdrop򥵥ݡȤ뷿ʤ顢ɤηѾƤ⹽ޤdropåϥȥ졼β䥪֥Ȥ̵˲äΥ֥Ǽ졢뤤ϼƤ줿¾Υ꥽Ǥޤ줿٤ƤΥ֥ȤɥåפбƤȤϸ¤ޤ󡣤ޤ֥ȤˤϡľܺǤʤˤؤ餺ɥåפǽʤΤ¸ߤޤ¾Υڥ졼ѤȤƺ줿֥ȤˤɥåפǽʤΤꡢ¾¾Υ֥ȤȤΥ󥯤ˤäƺƤơñȤǤϥɥåפǤʤΤ¸ߤޤ뷿CreateDropΤ줫⤷ξѾɸ।󥿡ե򥵥ݡȤơ֥ȤΥ饤եνޤ
USING
- (void)drop;
@end


//
// Miscellaneous operations for mixing into other types.
//

@protocol Copy
//S: ֥ȤΰȤ줿٤Ƥξ֤򥳥ԡޤ

//D: ԡ˺ݤơԡΥ֥ȤƤ˲ޤ뤫뤿Υ֥ȷǤԡ륪֥Ȥȡԡݤ˻Ȥ륪֥Ȥ""ȤƲθ뤫ȤǡХʥ롼Ϥޤ󡣤ĤޤꡢĤΥ֥ȥ饤֥˸褦ʡԡ(shallow copy)俼ԡ(deep copy)Ȥ공ǰϤޤ󡣥ԡ塢Υ֥Ȥ黲ȤƤ¾ΥȤؤΥե󥹤֥Ȥ˻Ĥ⤢ޤ̤˿֥ȤϡΥ֥Ȥȶͭ¸طǤ¤꾯ʤƤޤcopyå󶡤뤹٤ƤΥ֥ȷϡԡ륪֥Ȥ˴ؤ롼򵭽ҤʤФʤޤ

//M: copyåϡΥ֥ȤƱͤƤ俶񤤤Ŀ֥ȤޤΥ֥Ȥˤˤʤѹ⤦˱ƶʤ褦Υ֥ȤƤΩʣȤʤޤzoneˤϡ֥ȤФ륹ȥ졼Υꤷޤcopyåͤϡ줿֥ȤidǤ
USING
- copy: aZone;
@end

@protocol GetName
//S: ѥƥȤǥ֥Ȥ̤뤿Υ֥̾ޤ

//D: ѥƥȤǥ֥Ȥ̤뤿Υ֥̾ޤ

//M: getNameåϡѥƥȤǥ֥Ȥ̤̥뽪üʸ֤ޤꤵ줿ƥȤǥ֥Ȥ졢ˡ̾ƤȡʹߤϤΥ֥ȤФƤΥåŪ˻ѤޤΤ褦ʥ֥ȤˤϡȤХץ饤֥ΰȤ줿֥Ȥ󤲤ޤΥåϡ֥Ȥ¸³֤̤Ƥб֤̾ߤƤꡢ䤨Ѳ褦ʥǡ֤ȤϤޤ
USING
+ (const char *)getName;
@end

@protocol GetOwner
//S: ֥Ȥ¸ߤ뤿ΰ¸ȤʤäƤ륪֥Ȥޤ

//D: ͭؤϡʬȤ̩ñ롼ȤΥĥ꡼󤷤ޤͭؤΥȥåץ٥ΥΡɤϡ̾綠ΥʡȤnil֤ޤ֥ȤñˤΥʡȤƤ̤Υ֥ȤΰȤߤʤ硢ʡ֥Ȥ򥳥ԡɥåפꤹȡΥХ֥Ȥ˥ԡޤϥɥåפޤʡȥФδطϡޤƻҴطȸƤФŪطФƤǤġΥ֥ȷϡgetOwnerˤäƼطΤʤФʤޤ

//M: getOwneråϡ֥ȤΥʡȤߤʤ̤Υ֥Ȥ֤ޤʡȤߤʤ뤫ϡ줾Υ֥ȷ˰¸ޤ륪֥ȤΰʬȤʤäƤ륪֥Ȥ䡢륪֥Ȥ¾Ū˥ȥ뤹륪֥Ȥϡ구Ϥ礭ʥ֥ȤȤʤǤ礦ͭ¤ΩǽפʤΤϡ륪֥Ȥ¾ñΥ֥Ȥ򵿤ʤʡȤƻĤȤǤ
USING
- getOwner;
@end

@protocol SetInitialValue
//S: ¸Υ֥ȤνͤѤcreate

//D: SetInitialValueϡ֥ȤΰȤƳΩƤͤͤ˴ط͡ʥåޤäˤΥåϡͤ򥼥Ωƿ֥ȤΤǤʤ¸Υ֥Ȥͤ򥳥ԡ뤳ȤǴز뤿󶡤ƤޤcopyåƱͤˡԡ٤Ȥߤʤ¸Υ֥ȤͤϡΥå󶡤Υ֥ȷˤäƤΤޤ

//D: ֥Ȥ˳ΩͤäƤȤϡ夳Υ֥ȤѤ֡ͤϰڹʤȤƤȤƤǤޤˤäƤʤθΨ¸ޤͤι¤뤳Ȥ"꡼ɥ꡼"¤ɽޤηϡǤդνͤ˥꡼ɥ꡼å󶡤ޤ֥ȷˤϡ֥Ȥ줿Ǥ꡼ɥ꡼°ɲäǽʤΤ⤢ޤ

CREATING
//M: setInitialValue:åΰˤϡ륪֥Ȥͤ٤̤Υ֥ȤꤷޤcopyåȤϰ㤤ͤΥȤƻѤ륪֥Ȥϡ뿷֥ȤȰۤʤäǤ⹽ޤ󡣸ġΥ֥ȷϡ줬ĤͤΥ֥Ȥη򡢤Τ褦ͤŬѤ뤢̤ѴޤϲˡȤȤޤ
- (void)setInitialValue: initialValue;
@end


@protocol Symbol <Create, GetName, CREATABLE>
//S: ƤʥХidȤ륪֥ȡ

//D: SymbolϡѹǤʤ̾Ȥäƺ줿֥ȤǤΥ֥Ȥˤϡꤵ줿̾ʳ˿񤤤Ϥޤ̾SymbolϡХ̾˳ƤˡidͤΤ˻Ѥޤ̾ϡХ륪֥ο侩§˽äʸɽƤꡢĤΥ饤֥ǤϥåͤˤͤΥɡ뤤ϥե饰ȤƻѤƤޤ

//D: ̾亮ܥϡ줬Ƥ줿Хid˥ޥåʸ̾Ȥäƺޤʸ塢ΥХץϡ켫ȤκǾ٥εҤ򥪥֥ȤȤ󶡤뤳ȤǤޤSymbolΥ֥פ̾դХidδäĥơ˾ܺ٤ʥݡͥȤΥХΩ뤳ȤǤޤ

//D: ܥɸCreateåǺǤޤǥեͤϤʤᡢܥˤϤʤ餺ʸ̾ꤹɬפޤSymbolϥܥ֤̾getNameåѾޤ

CREATING
//M: create:setName:ϡƤӽФΤåǤå§˴ؤ륵ޥϡåΥ򻲾ȤƤ
+ create: aZone setName: (const char *)name;
@end

@protocol EventType <Symbol>
//S: ץμ¹˸Ф줿򼨤ݡȡ

//D: ץμ¹˸Ф줿򼨤ݡȡ

USING
//M: ͤʤǡ٥ȤΥܥ뷿ȯޤ
- (void)raiseEvent;

//M: եޥåʸȰȤͤʤǡ٥ȤΥܥ뷿ȯޤ
- (void)raiseEvent: (const void *)eventData, ...;
@end

@protocol Warning <EventType, CREATABLE>
//S: ץ೫ȯԤؿʾ

//D: ץ೫ȯԤؿʾ

USING
//M: ηٹ˥åʸϢդޤ
- (void)setMessageString: (const char *)messageString;

//M: ηٹ˴ϢդƤå֤ޤ
- (const char *)getMessageString;

extern id <Warning>
  WarningMessage,         //G: Υåٹޤ
  ResourceAvailability,   //G: 󥿥ĶΥ꥽̵Ǥ
  LibraryUsage,           //G: 饤֥ꥤ󥿡եλѰȿǤ
  DefaultAssumed,         //G: ǥեȤѤޤ
  ObsoleteFeature,        //G: Ū˺뵡ǽѤޤ
  ObsoleteMessage;        //G: Ū˺åѤޤ

@end

@protocol Error <Warning, CREATABLE>
//S: ʤ¹Ԥ˸֡

//D: ʤ¹Ԥ˸֡

extern id <Error> 
  SourceMessage,        //G: Υå顼ޤ
  NotImplemented,       //G: ׵ᤵ줿񤤤ϡ֥Ȥ˼Ƥޤ
  SubclassMustImplement,//G: ׵ᤵ줿񤤤ϡ֥饹¦Ǽɬפޤ
  InvalidCombination,   //G: ѤsetåȤ߹碌̵Ǥ
  InvalidOperation,     //G: ¦θߤξ֤ڥ졼бƤޤ
  InvalidArgument,      //G: ̵ͤǤ
  CreateSubclassing,    //G: Create֥饹Υե졼ޤ
  CreateUsage,          //G: CreateץȥåΥ󥹤äƤޤ
  OutOfMemory,          //G: Ƥ꤬ޤ
  InvalidAllocSize,     //G: Ƥ꤬ޤ
  InternalError,        //G: ץͽʤ֤ȯޤ
  BlockedObjectAlloc,   //G: ̵ʳƤObjectΥ᥽åɡ
  BlockedObjectUsage,   //G: Objectѡ饹Ѿ줿᥽åɡ
  ProtocolViolation,    //G: ׵ᤵ줿ץȥ˥֥ȤбƤޤ
  LoadError,            //G: ꥽˥Ǥޤ
  SaveError;            //G: ꥽¸Ǥޤ

@end


//#: ΥʸȤäƷٹ䥨顼ȯޥ
#define raiseEvent( eventType, formatString, args... ) \
[eventType raiseEvent: \
"\r" __FUNCTION__, __FILE__, __LINE__, formatString , ## args]

@protocol Zone <Create, Drop, CREATABLE>
//S: ȥ졼ƤΥ⥸塼ñ̡

//D: ϡ֥Ȥ䤽¾˳ƤǡѤΥȥ졼Ǥ֥ȤȡϤΥ󥹥ѿ¾ǡˤĤơɤΥȥ졼餽줬뤫ǧɬפޤץȤСʣΥΩơ褦¸³֤뤤ϻ褦ʥȥ졼ɬ׾ĥ֥Ȥְ㤤ʤƱȤ˳Ƥ褦ˤꡢȥ졼γƤѤŬ뤳ȤǤޤ

//D: ZoneϤޤΥ˳ƤƤ뤹٤ƤΥ֥ȤΥ쥯ޤΥ쥯ϥ"콸"ȤƤФ뽸ǡǺƤޤɥåפƤʤ֥ȤϤ٤ƥ쥯˴ޤޤޤ쥯ϥ˼ưŪ˴뤿ᡢ֥Ȥ콸ΤΥȥåݻɬפΤ륢ץꥱǤ⡢쥯̤˴ɬפϤޤ󡣳Ƥ줿֥ȤΥ쥯Ǥϡ֥ȥ꡼֥ȥȥ졼ưȥ졼ؤΥݡȤ󶡤ޤ

//D: ϥ֥ȤΥȥ졼ǤʤCmallocؿ󶡤褦Υȥ졼֥åǤޤ륾˳Ƥ줿֥Ȥ䥹ȥ졼֥åϡ٤ƤΥФƥʤޤޤǤĤޤꡢ¾Υ˥ȥ졼ƤƤ⡢ġΥΥȥ졼γƸΨ˱ƶϤޤ󡣤ۤȤɤΥ󷿤Ǥϡ륾ǤθġγƤϼͳǡιץȥ졼̤ɬ׾˱ޤƤϤ줾ǤΤɥåפ뤳ȤǤޤɥåפȡǺ줿٤ƤγƤϼưŪ˲졢ƱˡƤ줿֥ȤǥɥåפɬפʤΤˤĤƤǽŪʥɥå׽ʤޤΤβϡˤ륪֥Ȥ11ĲƤꤺäȹ®Ǥ

//D: Zoneϴ˼줿ǡ֥Ȥ䤽¾γƤ줿ȥ졼ФơǥեȤΥȥ졼ݡȤ󶡤ޤηϤޤ̤ʾѤ뤿إݥꥷ¾ΥΥѡפǤ⤢ޤ

//D: ¾Υ֥ȤƱ͡ɸcreateåѤƺ뤳ȤǤޤĤޤꡢzoneϤΥȥ졼븵Ȥʤ¾ΥꤷʤФʤޤ󡣥ȥ졼ϥڡȸƤФ礭ñ̤Ǵ¸Υ󤫤졢ŪʳƵǽ򥵥ݡȤ뤿˥륾ˤäƴޤDropgetZoneåϡΥ١ڡ󶡤륾֤ޤ

//D: Ͼ˴¸Υǧɬפ뤿ᡢ¸ߤƤʤ¤꿷뤳ȤϤǤޤ󡣤Τ褦ʥΤΤĤdefobj饤֥ΰȤƤ餫ƤޤޥˤĤƤϴΥ򻲾ȤƤ

CREATING
//M: PageSizeϡŪʳƤڡΥꤷޤǥեȤǤϡޥΥƥŬڡ(餯4K)ǤΥǥեȤ򥪡С饤ɤΤϡˤüʾǥȥ졼ƤĴʤФʤʤ˸¤٤Ǥ礦Ǥγƿϥڡ¤ޤ󡣤ȤΤϡڡĶꥯȤϡΥ󤬳ƤƤ륪ʡΥϤ뤫Ǥ
- (void)setPageSize: (int)pageSize;

USING
- getReclaimPolicy;
- (BOOL)getStackedSubzones;
- (int)getPageSize;

//M: allocIVars:ϡ֥Ȥ˥󥹥ѿ¤ΤƤޤι¤Τκǽ1ñϡȤϤ줿饹id˥åȤޤΥ饹ϤޤƤ빽¤ΤΥꤷޤι¤ΤλĤƤϥХʥ0ͤ˽ޤ
- allocIVars: aClass;

//M: copyIVars:ϡ륾˿Ƥ줿ȥ졼ˡ¸Υ󥹥ѿ¤ΤΥԡޤ¸Υ󥹥ѿ¤ΤϤɤΥˤäƤ⹽ޤ󤬡¤ΤΥҤκǽ1ñΥ饹ݥ󥿤ޤǤʤФʤޤ
- copyIVars: anObject;

//M: freeIVars:ϡ֥ȤΥ󥹥ѿ¤Τ¸뤿˳Ƥ줿ȥ졼ޤ֥Ȥκǽ1ñϡ¤ΤΥҤ饹ݥ󥿤ǤʤФʤޤallocIVars:copyIVars:Ƥȥ졼ϡfreeIVars:ǤʤвǤޤ󡣤ޤfreeIVars:ϤΥåΤɤ줫Ƥȥ졼뤿ˤѤǤޤ
- (void)freeIVars: anObject;

//M: ϳơԡ뤿ΥåǤ

//M: Υåϡ֥ȤΥ󥹥ѿ¸륹ȥ졼Ƥޤ֥Ȥϥ콸Ĥ˴ޤޤʤݡͥȤȤƳƤޤѤΤϡ¾Υ֥ȤμΰȤɲå֥ȤƤ륯饹ȡ٥륪֥Ȥ餳Υȥ졼Υޥåԥ󥰤̤˥ȥ뤹륯饹Ǥ
- allocIVarsComponent: aClass;

//M: allocateIVarsComponentȤۤȤƱǤ֥ȤΥ󥹥ѿ¸Ƥ륹ȥ졼򥳥ԡޤ
- copyIVarsComponent: anObject;

//M: ֥ȤΥ󥹥ѿȥ졼ޤ
- (void)freeIVarsComponent: anObject;

//M: ̤˸¤Ϳ줿СΥ֤ޤΥϡallocIVars:copyIVars:ˤäƳƤ줿ΤޤߡݡͥȤθ¤ĤΥ֥Ȥ٤ƤưŪ˳Ƥޤ̤ʸ¤ĥcreate:createBegin:å˰ȤϤȡݡͥȥ֥ȤȤƿ֥Ȥޤ
- getComponentZone;

//M: alloc:Ͽȥ졼֥åƤåǡC饤֥mallocؿˤ褯Ƥޤȥ졼ϡΥޥΥƥǤΡ٤ƤΥǡФǤ⸷̩׵˽ä󤷤ޤȥ졼Τͤǽ뤳ȤϤޤ
- (void *)alloc: (size_t)size;

//M: free:alloc:ǳƤ줿ȥ졼֥åޤalloc:ϺǽγƽǤΥ֥åΥ¸뤿ᡢfree:ΰ˥֥åϤޤfree:alloc:ǳƤ줿֥åФƤΤ߻ѤƤ¾alloc:Ƥ֥åϡfree:ǤΤ߲Ǥޤ
- (void)free: (void *)aBlock;

//M: allocBlock:ϡalloc:˻ȥ졼֥å򿷤˳Ƥޤ֥åȤƤ줿֥åΥϤɬפޤ
- (void *)allocBlock: (size_t)size;

//M: freeBlock:blockSize:ϡallocBlock:Ƥ֥å뤿˻ѤǤޤ
- (void)freeBlock: (void *)aBlock blockSize: (size_t)size;

//M: getPopulationϡallocIVars:ޤcopyIVars:ˤäƥ˳Ƥ졢ޤfreeIVars:ǲƤϤʤ٤ƤΥ֥ȤΥ쥯֤ޤObjectCollectionץfalseξ硢getObjectsnil֤ޤ֤륳쥯ϡcollections饤֥Ƥ褦OrderedSetޤ(ReadOnlyץtrueIndexSafetyץSafeAlways)Υ쥯ΥФϡ֥ȤƤ줿ȤѹƤ⹽ޤ󤬡쥯ľɲáƤϤޤ
- getPopulation;

//M: containsAlloc:ϡġγƤ륾䤽Υ󤫤饹ȥ졼ˤäƤʤ줿ΤȽꤷޤݥ󥿰ϡäǤդΥ󤬹ԤäƤؤƤʤФʤޤ󡣤Υȥ졼륾䤽Υ֥󤫤Ƥ줿ΤǤСåtrue֤ޤ
- (BOOL)containsAlloc: (void *)alloc;

//M: 콸ĤΤ줾ΥФˡǥХåεҤޤ
- (void)describeForEach: outputCharStream;

//M: 콸ĤΤ줾ΥФˡǥХåidεҤޤ
- (void)describeForEachID: outputCharStream;

//G: ReclaimPolicyץΥܥ
extern id <Symbol>  ReclaimImmediate, ReclaimDeferred,
                    ReclaimFrontierInternal, ReclaimInternal, ReclaimFrontier;

@end

@protocol DefinedClass <DefinedObject, GetName>
//S: Υ󥿡ե륯饹

//D: Υ󥿡ե륯饹
USING
+ getSuperclass;
+ (BOOL)isSubclass: aClass;

+ (void)setTypeImplemented: aType;
+ getTypeImplemented;

+ (IMP)getMethodFor: (SEL)aSel;
@end

@protocol CreatedClass <Create, DefinedClass>
//S: ¹Իѿ᥽åɤĥ饹

//D: ¹Իѿ᥽åɤĥ饹

CREATING
- setName: (const char *)name;
- setClass: aClass;
- setSuperclass: aClass;
- setDefiningClass: aClass;
- at: (SEL)aSel addMethod: (IMP)aMethod;
- lispInCreate: expr;
- hdf5InCreate: hdf5Obj;
- lispOutShallow: stream;
- hdf5OutShallow: hdf5Obj;
- updateArchiver;
extern id createType (id aZone, const char *name);
extern Class copyClass (Class class);
extern void addVariable (Class class, const char *name, const char *type);
USING
- getDefiningClass;
@end

@protocol BehaviorPhase <CreatedClass>
//S: ֥Ȥο񤤤Υե뤿˺륯饹

//D: ֥Ȥο񤤤Υե뤿˺륯饹

CREATING
- (void)setNextPhase: aClass;

USING
- getNextPhase;
@end

@protocol Arguments <Create, Drop, CREATABLE>
//S: ޥǽʥޥɥ饤ΰϥݡȤ󶡤륯饹

//D: ޥǽʥޥɥ饤ΰϥݡȤ󶡤륯饹

//E: ȤС`protocol'ȤɸΥޥɥꥹȤɲä
//E: ޤ礦Ĥޤꡢޥɥ饤--helpϤݤ˰ʲΤ褦ɽ
//E: 褦ˤȤޤ
//E: ------------------------
//E: mgd@wijiji[/opt/src/mgd/src/mySwarmApp] $ ./mySwarmApp --help
//E: Usage: mySwarmApp [OPTION...]
//E: 
//E:   -s, --varyseed             Run with a ramdom seed -ॷɤǼ¹
//E:   -b, --batch                Run in batch mode -Хå⡼ɤǼ¹
//E:   -m, --mode=MODE            Specify mode of use (for archiving) -(֤Ф)Ѥ⡼ɤ
//E:   -p, --protocol=PROTOCOL    Set protocol -ץȥ
//E:   -?, --help                 Give this help list -ΥإץꥹȤ
//E:       --usage                Give a short usage message -ˡʷ˼
//E:   -V, --version              Print program version -ץСץ
//E: 
//E: Mandatory or optional arguments to long options are also mandatory or
//E: optional for any corresponding short options.
//E: -- ĹɽΥץФɬܤ뤤ϥץʥΰϡ
//E:    бûץǤƱͤǤɬפޤ
//E: 
//E: Report bugs to bug-swarm@santafe.edu.
//E: -- ХݡȤbug-swarm@santafe.eduäƤ
//E: -----------------------
//E: 
//E: ˤϡʲΤ褦ˡʤȤΥ֥饹Arguments
//E: ɬפޤ
//E: 
//E: #import <defobj/Arguments.h>
//E: 
//E: @interface MySwarmAppArguments: Arguments_c
//E: {
//E:   const char *protocolArg;
//E: }
//E: - (const char *)getProtocolArg;
//E: @end
//E: 
//E: @implementation MySwarmAppArguments
//E: 
//E: + createBegin: aZone
//E: {
//E:   static struct argp_option options[] = {
//E:     {"protocol", 'p', "PROTOCOL", 0, "Set protocol", 3},
//E:     { 0 }
//E:   };
//E:   
//E:   MySwarmAppArguments *obj = [super createBegin: aZone];
//E: 
//E:   [obj addOptions: options];
//E:   return obj;
//E: }
//E: 
//E: - (int)parseKey: (int)key arg: (const char *)arg
//E: {
//E:   if (key == 'p')
//E:     {
//E:       protocolArg = arg;
//E:       return 0;
//E:     }
//E:   else
//E:     return [super parseKey: key arg: arg];
//E: }
//E: 
//E: - (const char *)getProtocolArg
//E: {
//E:   return protocolArg;
//E: }
//E: 
//E: @end
//E:
//E: ºݤmain.mץफ¹Ԥ뤿ˤϡʲΤ褦ˤޤ
//E:
//E: int 
//E: main (int argc, const char ** argv) 
//E: {
//E:   initSwarmArguments (argc, argv, [MySwarmAppArguments class]);
//E:   
//E:   // Ĥ̤ - buildObjects:, - buildActions:, - activateIn: θƤӽФ
//E:   
//E:   return 0;					  
//E: }

CREATING
+ createBegin: aZone;
- createEnd;

- setArgc: (int)argc Argv: (const char **)argv;
- setAppModeString: (const char *)appModeString;
- setOptionFunc: (int (*) (int, const char *))optionFunc;
- setBugAddress: (const char *)bugAddress;
- setVersion: (const char *)version;
- setInhibitArchiverLoadFlag: (BOOL)inhibitArchiverLoadFlag;
- addOptions: (struct argp_option *)options;

+ createArgc: (int)argc Argv: (const char **)argv version: (const char *)version bugAddress: (const char *)bugAddress options: (struct argp_option *)options optionFunc: (int (*) (int, const char *))optionFunc;

//M: ʲξޤ४ץǤޤ

//M: - ץͤ̾Ρ

//M: - ץΥϰǽǤФΥץαѻ1ʸ򼨤ǤȤ`p'`--protocol'ɽۤʤƱץǡԤϳФ䤹ԤǤ

//M: - NULLǤʤСΥץ󤬰(ξϥץȥ̾)ɬפȤ뤳Ȥ򼨤٥롣

//M: - ΥץβϤȲĻѹե饰

//M: - Υץ

//M: - إץ꡼ǤΥץа֡

//M: Υ᥽åɤȯƥץ˸ƤӽФޤ
- (int)parseKey: (int)key arg: (const char *)arg;

SETTING
- setArgc: (int)theArgc Argv: (const char **)theArgv;
- setAppName: (const char *)appName;
- setAppModeString: (const char *)appModeString;
- setBatchModeFlag: (BOOL)batchModeFlag;
- setVarySeedFlag: (BOOL)varySeedFlag;
//M: SwarmΥ󥹥ȡ꤬狼ʤΡե졼եؤΥǥեȥѥꤷޤǥեȤϥȥǥ쥯ȥǤ
- setDefaultAppConfigPath: (const char *)path;
//M: SwarmΥ󥹥ȡ꤬狼ʤΡǡեؤΥǥեȥѥꤷޤǥեȤϥȥǥ쥯ȥǤ
- setDefaultAppDataPath: (const char *)path;

USING
- (BOOL)getBatchModeFlag;
- (BOOL)getVarySeedFlag;
- (const char *)getAppName;
- (const char *)getAppModeString;
- (int)getArgc;
- (const char **)getArgv;
- (const char *)getExecutablePath;
- (const char *)getSwarmHome;
- (const char *)getConfigPath;
- (const char *)getDataPath;
//M: ץꥱͭΥǡե뤬ĤȴԤѥ̾
- (const char *)getAppDataPath;
//M: ץꥱͭΥե졼ե뤬ĤȴԤѥ̾
- (const char *)getAppConfigPath;
- (BOOL)getShowCurrentTimeFlag;
- (BOOL)getInhibitArchiverLoadFlag;
@end

@protocol Archiver <Create, Drop, CREATABLE>
//S: ٥롦ꥢ饤󥤥󥿡ե
//D: ٥롦ꥢ饤󥤥󥿡ե
CREATING
+ createBegin: aZone;
- setInhibitLoadFlag: (BOOL)inhibitLoadFlag;
- setHDF5Flag: (BOOL)hdf5Flag;
- setPath: (const char *)path;
- setDefaultLispPath;
- setDefaultHDF5Path;
- createEnd;
USING
- registerClient: client;
- unregisterClient: client;
- putDeep: (const char *)key object: object;
- putShallow: (const char *)key object: object;
- getObject: (const char *)key;
- save;
@end

@protocol HDF5 <Create, Drop, CREATABLE>
//S: HDF5󥿡ե
//D: HDF5󥿡ե
CREATING
+ createBegin: aZone;
- setCreateFlag: (BOOL)createFlag;
- setDatasetFlag: (BOOL)datasetFlag;
- setParent: parent;
- setName: (const char *)name;
- setCompoundType: compoundType;
- setCount: (unsigned)count;
- createEnd;
SETTING
- setBaseTypeObject: baseTypeObject;
USING
- iterate: (int (*) (id hdf5Obj))iterateFunc;
- (BOOL)getDatasetFlag;
- (const char *)getName;
- (unsigned)getCount;
- getCompoundType;
- getClass;

- (BOOL)checkName: (const char *)groupName;
- loadDataset: (void *)ptr;
- storeAsDataset: (const char *)name typeName: (const char *)typeName type: (const char *)type ptr: (void *)ptr;
- storeTypeName: (const char *)typeName;
- storeComponentTypeName: (const char *)typeName;
- shallowLoadObject: obj;
- shallowStoreObject: obj;
- nameRecord: (unsigned)recordNumber name: (const char *)recordName;
- numberRecord: (unsigned)recordNumber;
- selectRecord: (unsigned)recordNumber;

- (const char **)readRowNames;
- writeRowNames;

- storeAttribute: (const char *)attributeName value: (const char *)valueString;
- iterateAttributes: (int (*) (const char *key, const char *value))iterateFunc;
- (const char *)getAttribute: (const char *)attributeName;

- (void)drop;
@end

@protocol HDF5CompoundType <Create, Drop, CREATABLE>
//S: HDF5ʣ祤󥿡ե
//D: HDF5ʣ祤󥿡ե
CREATING
+ createBegin: aZone;
- setClass: class;
- createEnd;
USING
- getClass;
@end

//G: 󥰥ȥArguments֥ȡ
extern id arguments;

//G: 󥰥ȥHDF5 Archiver֥ȡ
extern id hdf5Archiver;

//G: 󥰥ȥLisp Archiver֥ȡ
extern id lispArchiver;

//G: ƥ֥åδηǥץ
extern id <Symbol> t_ByteArray, t_LeafObject, t_PopulationObject;

//#: @selector()ά
#define M(messageName) @selector (messageName)

#ifndef PTRFMT
#if 0
//#: ХȿȤƤΥݥ󥿥
#ifndef PTRSIZE
#define PTRSIZE 4
#endif
#if PTRSIZE == 4
#define PTRFMT "%0#8lx"
#else
#define PTRFMT "%0#16lx"
#endif
#endif
//#: ݥ󥿤ɽ뤿printfΥեޥå
#define PTRFMT "%p"
#endif


//F: ɸեޥåȤǥ֥idʸȯؿ(󶡤ƤХåեϡǹ78ʸޤǼƲǽǤ)
extern void _obj_formatIDString (char *buffer, id anObject);

//F: ѥ饨顼򵯤ˡåԤ@classѤǤ褦ˤ뤿
extern Class objc_get_class (const char *name);  // for class id lookup 

//F: defobjΥ֥Ȥ򥪥֥̾Ǹޤ
extern id defobj_lookup_type (const char *name);

//
// type objects generated for module
//
#import <defobj/types.h>


//F: ץꥱ󡢥Arguments饹ץʥ(ޤNULL)ɲåץw/ؿȤädefobjޤ
extern void initDefobj (int argc,
                        const char **argv, 
                        const char *version,
                        const char *bugAddress,
                        Class argumentsClass,
                        struct argp_option *options,
                        int (*optionFunc) (int key, const char *arg));

//F: ⥸塼ؿ
extern void _obj_initModule (void *module);

//#: ⥸塼ޥ
#define initModule(module) _obj_initModule(_##module##_)

//G: globalZoneޥѿ
extern id _obj_globalZone;   

//G: scratchZoneޥѿ
extern id _obj_scratchZone; 

//#: Х륪֥ȤƤ뤿Υ
#define globalZone _obj_globalZone

//#: ֥ȤƤ뤿Υ
#define scratchZone _obj_scratchZone

#ifndef _obj_debug
//G: trueǤФ٤ƤΥǥХå顼åԤޤ
extern BOOL _obj_debug;   
#endif

//G: 顼åѽϥե
extern FILE *_obj_xerror;  
//G: ǥХååѽϥե
extern FILE *_obj_xdebug;  

//F: ǥץ쥤̾򥻥åȤޤ
extern void xsetname (id anObject, const char *name); 

//F: ǥХåϥȥ꡼ˡ֥ȤεҤץȤޤ
extern void xprint (id anObject);                

//F: ǥХåϥȥ꡼ˡ֥ȤidʸץȤޤ
extern void xprintid (id anObject);              

//F: ǥХåϥȥ꡼ˡ쥯γƥФεҤץȤޤ
extern void xfprint (id anObject);

//F: ǥХåϥȥ꡼ˡ쥯γƥФidץȤޤ
extern void xfprintid (id anObject);  

//F: ֥Ȥ˥å¹Ԥ뤿ΥǥХåؿ
extern void xexec (id anObject, const char *name);

//F: 쥯γƥФ˥å¹Ԥ뤿ΥǥХåؿ
extern void xfexec (id anObject, const char *name); 

//F: ƥȤΥݥ󥿵Ҥ饪֥Ȥޤ
extern id nameToObject (const char *name);

//
// macros used to create and initialize warning and error symbols
// (obsolete once module system in use)
//

//#: ܥκȽ˻Ѥޥ
#define defsymbol(name) name = [Symbol create: globalZone setName: #name]

//#: Errorܥ뤿˻Ѥޥ
#define defwarning(name, message) \
  [(name = [Warning create: globalZone setName: #name]) \
    setMessageString: message]

//#: Warningܥ뤿˻Ѥޥ
#define deferror(name, message) \
  [(name = [Error create: globalZone setName: #name]) \
    setMessageString: message]

//#: Lisp֤Υ饹ؿѤ뤿̾
#define MAKE_CLASS_FUNCTION_NAME "make-class"

//#: Lisp֤Υ֥ȺؿѤ뤿̾
#define MAKE_INSTANCE_FUNCTION_NAME "make-instance"

//#: ȤϤ줿Υ֥Ȥˡ10ʷݼŪʳԤޤߥ͡ϴޤߤޤsignchar + roundup (log (10)/log(2) = 3.3219)
#define DSIZE(type) (1 + sizeof (type) * 8 / 3 + 1)
