// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.
/*
Name:            objectbase.h
Description:     support for swarmobjects and probing   
Library:         swarmobject
Authors:         Manor Askenazi
Date:            1996-12-12
*/

//S: Swarm֥Ȥȥץӥ󥰤򥵥ݡȤޤ

//D: objectbase饤֥ˤϡ桼ΥȤswarm߷פɬפʺǤŪʥ֥ȤޤޤޤޤߤΤȤ٤ƤSwarmObject󶡤ץӥ֤ΥݥȥȤΩޤ

#import <defobj.h>
#import <activity.h> // timeval_t

//
//  Objectbase errors
//
// id <Error> ReferenceError;  // dangling pointer to removed object

@protocol SwarmObject <Create, Drop>
//S: ץӥ󥰤򥵥ݡȤSwarmߥ졼ǤΡۤȤɤΥ֥ȤΥѡ饹

//D: SwarmObjectϡSwarmΥФˤʤͽΥ֥ȤǤSwarm֥ȤΥƥȤ줿٥ȤΥ塼뤫åSwarmObjectο񤤤³ޤ

//D: ߥ졼Τ٤ƤΥȤΥǥϡSwarmObject¸ߤ뤳ȤˤʤޤäơɤΥȤå⡢֤ϤۤȤɤ桼˰ѤͤޤSwarmObjectδܵǽϡdefobj饤֥줿CreateDrop֥ȷѾޤ
 

USING
//M: getInstanceName᥽åɤϡץ֤줿֥Ȥ򼨤̣Τñե졼֤ޤ(probe displayξϲ̤ΥåȤ֤ޤ)
- (const char *)getInstanceName;

//M: getProbeMap᥽åɤϡΥ֥ȤΥ饹˺줿ProbeMapСProbeMapؤΥݥ󥿤֤ޤƤʤСǥեȤProbeMapޤ
- getProbeMap;

//M: getCompleteProbeMap᥽åɤϡΥ֥Ȥ˿˺줿CompleteProbeMap֤ޤ
- getCompleteProbeMap;

//M: getProbeForVariable:᥽åɤϡProbeMap桢ʸaVariableǥǥå줿VarProbe֤ޤ
- getProbeForVariable: (const char *)aVariable;

//M: getProbeForMessage:᥽åɤϡProbeMap桢ʸaMessageǥǥå줿MessageProbe֤ޤ
- getProbeForMessage: (const char *)aMessage;
@end

@protocol ProbeConfig
//S: ProbeProbeMapProbeLibraryΥե졼ѥץȥ롣

//D: ProbeProbeMapProbeLibraryΥե졼ѥץȥ롣
USING
- setObjectToNotify: anObject;
- getObjectToNotify;
@end

@protocol Swarm
//S: ƥʡ

//D: Swarmϡ̤Υסȶ̤Υॹͭ륨ȤζƱΤǤ

USING
//M: Swarm˴ޤޤ륪֥Ȥˤϡ򥪡С饤ɤޤ
- buildObjects;

//M: SwarmˤΥۤˤϡ򥪡С饤ɤޤ
- buildActions;

//M: buildActionsǹۤ륢򥢥ƥ١Ȥˤϡ򥪡С饤ɤޤաʤΥ򥢥ƥ١ȤˡޤʤȤ򥢥ƥ١ȤʤФʤޤ

//E: [super activateIn: swarmContext];
//E: [myFancySchedule activateIn: self];
//E: return [self getSwarmActivity];    
- activateIn: swarmContext;

//M: SwarmΥץӥ󥰤򥵥ݡȤΤɬפǤ
- getProbeMap;

//M: SwarmΥץӥ󥰤򥵥ݡȤΤɬפǤ
- getCompleteProbeMap;

//M: SwarmΥץӥ󥰤򥵥ݡȤΤɬפǤ
- getProbeForVariable: (const char *)aVariable;    
@end

@protocol Probe <SwarmObject, ProbeConfig>
//S: VarProbeMessageProbeݥѡ饹

//D: Probeϡ¾Υ֥ȤΥ(󥹥ѿޤϥå)ؤΥݥ󥿤ޤñʤ륪֥ȤǤProbeˤϡեȤΥ饹ȷɽ󥹥ѿޤޤޤºݤˤϡϤ륪֥ȤΥȤ2ĤδܷɽVarProbeMessageProbe˥ʬ䤵줿ݥ饹ǤProbeProbeMap˼졢³ProbeLibrary˥󥹥ȡ뤵ޤ

CREATING
//M: setProbedClass:᥽åɤϡprobeؤ˸ƤӽФʤФʤʤ֥ȤΥ饹򥻥åȤޤ
- setProbedClass: (Class)class;
SETTING
//M: setSafety᥽åɤϡ֥Ȥ˥󤬤ޤä¹Ԥʤˡ֥ȤΥ饹θߴå륪ץonˤޤ
- setSafety;     // There should be a setSafety: BOOL

//M: unsetSafety᥽åɤϡ֥Ȥ˥󤬤ޤä¹Ԥʤˡ֥ȤΥ饹θߴå륪ץoffˤޤ
- unsetSafety;   // and getSafety methods instead...

USING
//M: clone:᥽åɤprobeΥ֤ޤǽprobe饤֥ǥեȥСΥ֥Ǻ줿硢probeѹ˥󲽤Ƥprobeѹ¾ߥ桼˱ƶ뤳Ȥ򤱤ʤФʤޤ
- clone: aZone;

//M: getProbedClass᥽åɤϡprobeؤ֥ȤΥ饹򥯥饹ݥ󥿤Ȥ֤ޤ
- (Class)getProbedClass;

//M: getProbedType᥽åɤϡץ֤줿ѿåηŤ֤ޤŤϡObjective-CΥ󥿥ॷƥ󶡤ʸ񼰤Ȥäɽޤ
- (const char *)getProbedType;

#if 0
   These are currently implemented here but belong in VarProbe...

- setStringReturnType: returnType;      
- (void *)probeRaw: anObject;
- (void *)probeAsPointer: anObject;
- (int)   probeAsInt: anObject;
- (double)probeAsDouble: anObject;
- (char *)probeAsString: anObject Buffer: (char *) buffer;
#endif
@end

@protocol _VarProbe
CREATING
//M: setProbedVariable:ϥץ֤ѿꤷޤaVariable̻ҤϡѿեȤμ̻ҤǹñʤʸǤΥ᥽åɤcreateեδ֤˸ƤӽФʤФʤޤ
- setProbedVariable: (const char *)aVariable;

- createEnd;

SETTING
//M: setNonInteractive᥽åɤϡ÷VarProbe򥻥åȤޤ桼probeͤ򸫤ǡѹϰڤǤޤVarProbe÷˥åȤƤ⡢VarProbeեɤؤΥ֥ȤΥɥå&ɥåפϲǽǤ

//   Currently, setNonInteractive must be used *after* create phase
//   In any case these should also become setInteractive: BOOL etc.
- setNonInteractive; 

//M: setStringReturnType:᥽åɤϡѿؤΤ˻Ѥ񼰤򥻥åȤޤprobedVariableunsigned charޤcharǤСprobeAsString᥽åɤϡǥեȤ"'%c' %d"񼰤ʸ֤ޤĤޤꡢ̤unsigned charλѤ򾮤intɽޤ
- setStringReturnType: returnType;

//M: setFloatFormat:᥽åɤϡGUIɽåȤsprintfʸͿȤư񼰤򥻥åȤޤ
- setFloatFormat: (const char *)format;

USING
//M: getProbedVariable᥽åɤϡץ֤줿ѿμ̻Ҥ˥ޥåʸ֤ޤ
- (const char *)getProbedVariable;

//M: getInteractiveFlag᥽åɤϡVarProbe֤ޤ
- (BOOL)getInteractiveFlag;

//M: probeRaw:᥽åɤϡץ֤줿ѿؤΥݥ󥿤֤ޤ
- (void *)probeRaw: anObject;

//M: probeAsPointer:᥽åɤϡץ֤줿ѿؤΥݥ󥿤ProbeType˴Ť֤ޤ
- (void *)probeAsPointer: anObject;

//M: probeAsInt:᥽åɤϡץ֤줿ѿؤΥݥ󥿤Ȥ֤ޤ
- (int)probeAsInt: anObject;

//M: probeAsDouble:᥽åɤϡץ֤줿ѿؤΥݥ󥿤٤Ȥ֤ޤ
- (double)probeAsDouble: anObject;

//M: probeAsString:Buffer:᥽åɤϡѿͤХåեإץȤޤ餫ХåեƤʤФʤޤ
- (const char *)probeAsString: anObject Buffer: (char *)buffer;

//M: probeAsString:Buffer:withFullPrecision:᥽åɤϡѿͤХåեإץȤޤ餫ХåեƤʤФʤޤ󡣤ΥСprobeAsStringϡObjectSaver"¸"("ɽ"Ȥϰۤʤ뤳Ȥޤ)Ѥ뤿ˡŪ˻Ѥޤ
- (const char *)probeAsString: anObject
                       Buffer: (char *)buf
            withFullPrecision: (int)precision;

//M: setData:To:᥽åɤϡͤؤΥݥ󥿤ȤäprobedVariable򥻥åȤޤ
- setData: anObject To: (void *)newValue;  // pass by reference.

//M: setData:ToString:ϡprobeɤ߹ޤŬڤѴʸȤäơprobedVariable򥻥åȤޤΥ᥽åɤunsigned charchar򥻥åȤȤʸˤϡCharString򤵤ʤ¤(ξ"'%c'")"%i"ν񼰤Ȥޤ
- (BOOL)setData: anObject ToString: (const char *)s; 
@end

@protocol VarProbe <_VarProbe, Probe>
//S: 륯饹ηѾ뤤Ϥ륯饹Υ󥹥󥹤ǤǤդθΡѿθǽˤ륯饹

//D: ݥ饹Probeü첽֥饹Ǥ֥ȤΥ󥹥ѿȤ򻲾Ȥprobeλͤޤ
@end

//T: This type is used in MessageProbes to return an object of arbitrary
//T: type.
typedef struct val {
  char type;
  union {
    id object;
    SEL selector;
    const char *string;
    char _char;
    unsigned char _uchar;
    short _short;
    unsigned short _ushort;
    int _int;
    unsigned int _uint;
    long _long;
    unsigned long _ulong;
    float _float;
    double _double;
  } val;
} val_t;

@protocol MessageProbe <Probe>
//S: 륯饹ηѾ뤤Ϥ륯饹Υ󥹥󥹤ǤǤդθǡåθƤӽФǽˤ륯饹

//D: Probeݥ饹ü첽֥饹Ǥ֥ȤΥåȤ򻲾Ȥprobeλͤޤ

CREATING
//M: setProbedSelector:᥽åɤϡͿ줿쥯ץ֤褦˥å򥻥åȤޤ
- setProbedSelector: (SEL)aSel;

//M: setHideResult:᥽åɤϡ̥եɤβĻ򥻥åȤΤ˻Ѥޤ1򥻥åȤȡåprobeΥեɽ˷̥եɤʤʤޤ
- setHideResult: (BOOL)val;

USING
//M: isResultId᥽åɤϡå֥ͤȤΤΤǤ1֤Ǥʤ0֤ޤ
- (BOOL)isResultId;                  // I doubt that a user will 

//M: isArgumentId:᥽åɤϡͿ줿åΰ֥ȤΤΤǤ1֤Ǥʤ0֤ޤ
- (BOOL)isArgumentId: (int)which;    // ever need these.

//M: getProbedMessage᥽åɤϡץ֤줿åμ̻Ҥ˥ޥåʸ֤ޤ
- (const char *)getProbedMessage;

- (int)getArgCount;

//M: getArg:᥽åɤϡnܤΰʸɽ֤ޤ
- (const char *)getArg: (int)which;

//M: getArgName:᥽åɤϡͿ줿̾äʸɽ֤ޤ
- (const char *)getArgName: (int)which;

//M: getHideResult᥽åɤϡ̥եɤ"hidden"ΤȤ1֤ޤ
- (BOOL)getHideResult;

//M: setArg:ToString:᥽åɤϡånܤΰ򥻥åȤޤʸ񼰤ͿʤФʤޤ
- setArg: (int)which ToString: (const char *)what;

//M: dynamicCallOn:᥽åɤϡåȥ֥ȾưŪʥåƤӽФޤͤϤޤ
- (val_t)dynamicCallOn: target;

//M: doubleDynamicCallOn:᥽åɤϡåȥ֥ȾưŪʥåƤӽФޤΥ᥽åɤϡdoubleȤʤ٤ʬäƤơdoubleľѴȤ˻Ѥޤ
- (double)doubleDynamicCallOn: target;
@end

@protocol ProbeMap <SwarmObject, ProbeConfig>
//S: ProbeDisplayƤꤹΤ˻ѤProbeΥƥʥ饹

//D: ProbeMapProbeMap쥯ǡ˶̤ΥեȤĤĤProbe«˽Τ˻ѤޤȤСModelSwarmΤ٤ƤΥ󥹥ѿ1ĤProbeMap˽ޤˡProbeMapϥХProbeLibrary˥󥹥ȡ뤵ޤ

CREATING
//M: setProbedClass:᥽åɤϡprobe mapprobe礬ؤ֥ȤΥ饹򥻥åȤޤΥåcreateEndʤФʤޤ
- setProbedClass: (Class)class;

USING
//M: getNumEntries᥽åɤϡProbeMapˤprobeθĿ֤ޤ
- (int)getNumEntries;

//M: getProbedClass᥽åɤϡprobe mapϢprobeؤ֥ȤΥ饹֤ޤ
- (Class)getProbedClass;

//M: getProbeForVariable:᥽åɤϡͿ줿ѿ̾бProbe֤ޤ
- getProbeForVariable: (const char *)aVariable;

//M: getProbeForMessage:᥽åɤϡꤵ줿å̾бProbe֤ޤ
- getProbeForMessage: (const char *)aMessage;

//M: addProbe:᥽åɤϡProbeMapƤprobe1ĲäޤProbeMapϡɲä줿ProbeprobedClassʬprobedClassбƤ뤳Ȥ˳ǧޤ
- addProbe: aProbe;

//M: addProbeMap:᥽åɤϡ¾ProbeMap"set inclusion"¹Ԥ뤳ȤǡProbeMapƤŬΤ˻ѤޤŤinclusion˸ڤޤ
- addProbeMap: aProbeMap;

// These should use the word remove not drop.
//M: dropProbeForVariable:᥽åɤϡProbeMap餢ProbeɥåפΤ˻ѤޤprobeϤμºݤidͤǤʤvariableNameȤäƥɥåפ뤿ᡢ饹θڤȯޤ
- dropProbeForVariable: (const char *)aVariable; 

//M: dropProbeForMessage:᥽åɤϡProbeMap餢ProbeɥåפΤ˻ѤޤprobeϤμºݤidͤǤʤmassageNameȤäƥɥåפ뤿ᡢ饹θڤȯޤ
- dropProbeForMessage: (const char *)aMessage;  

//M: dropProbeMap:᥽åɤϡProbeMap餢probeɥåפΤ˻ѤޤɥåפProbeMap¸ߤѿ̾dropProbeForVariableƤӽФ³ɥåפProbeMap¸ߤƥå̾dropProbeForMessageƤӽФȤƱǤ
- dropProbeMap: aProbeMap;

//M: begin:᥽åɤProbeMapΥƥ졼(ǥå)֤ޤΥǥåϡMapǥåѤΤȤޤäƱ褦˻Ѥޤ
- begin: aZone; // returns an index to the underlying Map.

//M: clone:᥽åɤprobe mapΥ֤ޤprobe mapǥեȥСΥ饤֥䥪֥Ǻ줿硢probe mapѹ˥󲽤졢ѹprobe map¾ߥ桼˱ƶ뤳Ȥɤޤ
- clone: aZone;

@end

@protocol DefaultProbeMap <ProbeMap, CREATABLE>
//S: ProbeMapΥ֥饹ν֤ǡ׵ᤵ줿åȥ饹ȤΥѡ饹Τ٤ƤVarProbeޤޤޤ

//D: ProbeMapΥ֥饹ν֤ǡ׵ᤵ줿åȥ饹ȤΥѡ饹Τ٤ƤVarProbeޤޤޤ
@end

@protocol CustomProbeMap <ProbeMap, CREATABLE> 
//S: ǥեprobeMapν֤Ȱ㤤֤ProbeMapΥ֥饹ǥեȤ׵ᤵ줿åȥ饹Τ٤ƤVarProbeޤޤޤ

//D: ProbeMapΥ֥饹ϡξ֤ǽ줿probe map뤤VarProbeMessageProbeȤäƽ줿probe mapΤ˻ѤޤĤޤꡢcreateEndξVarProbeMessageProbe¸ߤʤȤץ֤륯饹̤ProbeMapƱ褦˥åȤޤεǽϡprobe map줫ȤǤ(ȤСProbeLibrarysetProbeMap:For:᥽åɤȶƱǻѤȤ)
CREATING
+ create: aZone forClass: (Class)aClass withIdentifiers: (const char *)vars, ...;
@end

@protocol EmptyProbeMap <CustomProbeMap, CREATABLE>
//S: ProbeMap줫鹽ۤȤѤCustomProbeMap

//D: ProbeMap줫鹽ۤȤѤCustomProbeMap
@end

@protocol CompleteProbeMap <ProbeMap>
//S: ֤ǡ׵ᤵ줿åȥ饹ȤΥ֥饹Τ٤ƤVarProbeMessageProbeޤProbeMapΥ֥饹

//D: ProbeMapΤΥ֥饹ϡͿ줿饹(Ѿ줿饹ޤ)Τ٤ƤΥåȤ٤ƤѿޤǺޤ
@end

@protocol CompleteVarMap <ProbeMap>
//S: ֤MessageProbeޤޤʤProbeMapΥ֥饹

//D: ֤MessageProbeޤޤʤProbeMapΥ֥饹׵ᤵ줿åȥ饹ȤΤ٤ƤΥѡ饹VarProbeϤ٤ƴޤߤޤ
@end

@protocol ProbeLibrary <Create, Drop, ProbeConfig> 
//S: Υ󥹥󥹤饹̾Ȥ'ǥե'ProbeMap֤ΥХʥޥåԥ󥰤ΥƥʤȤƻѤ(󥰥ȥ)饹ǥեȤѹǤ뤿ᡢ֥Ȥץ֤Ȥ˺ProbeDisplayΥǥեȤƤ򥫥ޥǤޤ

//D: 餯Ĥ̤Swarmߥ졼ˤϡprobeLibrary֥ȤȤΥ饹Υ󥹥󥹤1ĴޤޤǤΥ֥ȤProbeProbeMapΥ饤֥˻ѤޤSwarmμ¹ˡ䤨ץ֤뤹٤ƤΥ饹Фơ""ΥˡProbeMap򥭥å夹ΤǤProbeMap׵ᤵ줿Ȥ˺ޤ

USING
//M: setDisplayPrecision:᥽åɤϡGUIåȤɽưưͭ򥻥åȤޤΥ᥽åɤƤΤϸVarProbeǡMessageProbeˤϼƤޤsetDisplayPrecision᥽åɤˤꥰХProbeLibrary󥹥󥹤鸡줿probeϡɤ⤬ɽ٤˥ǤޤprobeȤˤΥХʥǥեȤѹ뤳ȤǤޤξϡ¸probesetFloatFormat᥽åɤѤޤ
- setDisplayPrecision: (int)nSigDisplay;

//M: getDisplayPrecision᥽åɤϡProbeLibrary󥹥󥹤˥åȤ줿ߤɽ٤ޤ
- (int)getDisplayPrecision;

//M: setSavedPrecision:᥽åɤϡObjectSaver̤¸ưưͭ򥻥åȤޤĤޤꡢưޤह٤ƤưˡХʥǥե٤ꤵޤư٤ϡObjectSaver饹̤¸뤹٤Ƥοͤ˱ƶޤߤΤȤġprobeΥХʥǥեȤ򥪡С饤ɤˡϤޤ
- setSavedPrecision: (int) nSigSaved;

//M: getSavedPrecision᥽åɤϡProbeLibrary󥹥󥹤˥åȤƤ븽ߤ٤ޤ
- (int)getSavedPrecision;

//M: isProbeMapDefinedFor:᥽åɤϡΥ饹ProbeLibrarynilǤʤͤTrue֤ʤFalse֤ޤ
- (BOOL)isProbeMapDefinedFor: (Class)aClass;

//M: getProbeMapFor:᥽åɤϡaClass饹ProbeMap֤ޤProbeMap߷פơΥ饹ProbeLibrary˥󥹥ȡ뤵ƤСProbeMap֤ޤProbeMap߷ס󥹥ȡ뤵ƤʤСCompleteProbeMap֤ޤ
- getProbeMapFor: (Class)aClass;

//M: getCompleteProbeMapFor:᥽åɤϡ륯饹Τ٤ƤΥ󥹥ѿȥå(Ѿѿȥåޤ)ProbeޤProbeMap֤ޤߤProbeLibraryμǤϡCompleteProbeMapϥå夵ޤ
- getCompleteProbeMapFor: (Class)aClass;

//M: getCompleteVarMapFor:᥽åɤϡ륯饹Τ٤ƤΥ󥹥ѿ(Ѿѿޤ)ProbeޤProbeMap֤ޤMessageProbeϴޤޤޤ
- getCompleteVarMapFor: (Class)aClass;

//M: getProbeForVariable:inClass:᥽åɤϡprobe饤֥ŬڤProbe"å"줿probe֤ޤա֤probeϥå夵ޤˤѹäprobeϥ󲽤졢ƱprobeإꥯȤäƤ⡢η̤ˤѹαƶФޤ
- getProbeForVariable: (const char *)aVar
              inClass: (Class)aClass;

//M: getProbeForMessage:inClass:᥽åɤϡprobe饤֥ŬڤProbe"å"줿probe֤ޤա֤probeϥå夵ޤˤѹäprobeϥ󲽤졢ƱprobeإꥯȤäƤ⡢η̤ˤѹαƶФޤ
- getProbeForMessage: (const char *)aMessage
             inClass: (Class)aClass;

//M: setProbeMap:For:᥽åɤϡprobeMapɸprobe map򥻥åȤޤ֤Probeϥ饤֥꼫Ȥ˺줿Τ褦˥å夵ޤ
- setProbeMap: aMap For: (Class)aClass; 

@end

//G: ProbeMapΥХ饤֥
extern id <ProbeLibrary> probeLibrary;

@protocol ActivityControl <SwarmObject>
//S: ƥӥƥؤΥ֥ȥ󥿡ե󶡤륯饹

//D: ActivityControl饹ϡƥӥƥ(ƥӥƥˡˤϴطޤ)˥åǤ륪֥ȤꤷޤŪϡΥƥӥƥΥץΥμ¹ԤŪ˥ȥ뤹뤳ȤǤǤActivityControl饹ϡƥӥƥΤѤǤѿå̤ƤѤǤʤʤäƤꡢΥ饹̤ƤŪѤǤ뵡ǽϤޤ󡣤פʥȥåѥåƤΤǡ륢ƥӥƥ򥳥ȥ뤹ɬפ뤫⤷ʤ¾Υ֥ȤϡΥȥåѤǤޤˤꡢ֥Ȥγ¦ľŪʥå饢ƥӥƥݸ桼ϥƥӥƥؤΤʣʥ󥿡եϤɬפʤʤޤ

CREATING
//M: attachToActivity:᥽åɤϡActivityControl֥Ȥˡȥ뤵٤ƥӥƥ򼨤󥹥ѿ򥻥åȤ˥塼ޤ塼Ϥ켫Τ˥å֤ơȤѿ򹹿ޤ
- attachToActivity: anActivity;

USING
//M: run᥽åɤϡ郎礨ХƥӥƥrunåޤΥåˤꡢƥӥƥ¾ԤäƤ륢̵ʤ뤫Υƥӥƥؤstopåˤäơ뤤ϥ֥ƥӥƥˤäƥμ¹ԤȥåפޤǡΥ塼Υ¹Ԥ³ޤΥ塼ˤ뤹٤ƤΥμ¹Ԥλȡrun᥽åɤCompleted֤ޤ
- run;

//M: stop᥽åɤϡ郎礨ХƥӥƥstopåޤΥåˤꡢrunå˥ȥ뤬ꡢrunǽ˼¹Ԥ줿ɤΰ֤ޤѡƥӥƥǤμΥϡĤäƤ븽ߤΥƥӥƥΥ򽪤뤳ȤʤϤޤ뤳Ȥˤʤޤ
- stop;

//M: next᥽åɤϡ郎礨ХƥӥƥnextåޤΥåbreakFunction˥ҥåȤޤǥƥӥƥʤɬפʤΥ¹ԤޤbreakFunctionݥȤ˥ҥåȤȡƥӥƥĥ꡼ξꡢStopped֤ޤĤޤꡢۤȤɤΥǤϡȥ벼ˤ륢ƥӥƥΥΤ뤤ϥ󥰥롼פ٤ƤΥ֥ƥӥƥδλޤߡ¹Ԥ뤳Ȥˤʤޤ
- next;

//M: step᥽åɤϡ郎礨ХƥӥƥstepåꡢñΥ¹Ԥޤ
- step;

//M: stepUntil:᥽åɤϡ郎礨stepUntil:å򥢥ƥӥƥޤˤꡢΥƥӥƥΥ塼ˤ뤹٤ƤΥϡ֥ƥӥƥΥ塼Υ⤹٤ƴޤߡΥƥӥƥл郎stopTime - 1ʤޤǼ¹Ԥޤ
- stepUntil: (timeval_t)stopTime;

//M: terminateActivity᥽åɤϡƥӥƥterminateåޤ٤ƤΥȥ󥰥롼פΥ塼뤫ޤաterminateƥӥƥ졢³Υƥӥƥrunߤȡץϥ顼Ϥߤޤ
- (void)terminateActivity;

//M: updateStateVar᥽åɤϡActivityControl󥹥ѿ򹹿ȥ뤵Ƥ륢ƥӥƥη³¸ߤƥȤޤΥåϡȥ뤵Ƥ륢ƥӥƥΥ塼γƥޤ
- updateStateVar;

//M: getStatus᥽åɤϡƥӥƥξ֤֤ޤ
- getStatus;

//M: getInstanceName᥽åɤϡ֥̾ǡ١displayName֤ޤ
- (const char *)getInstanceName;

@end

@class Probe;
@class VarProbe;
@class MessageProbe;
@class ProbeMap;
@class CustomProbeMap;
@class EmptyProbeMap;
@class CompleteProbeMap;
@class CompleteVarMap;
@class ProbeLibrary;
@class ActivityControl;
@class Swarm;
@class SwarmObject;

//G: SwarmΥС
extern const char *swarm_version;
