//
// <random/distributions.h>
//
//     1997-09-01 (v. 0.7)
//     1998-10-08 (v. 0.8)
//

// 
// See the file docs/README.Distributions.v07 for guide to usage
// 

#undef USETHINDOUBLES
// 
// All objects implementing the DoubleDistribution protocol presently call
//   the -getDoubleSample method of the generators, which uses 2 random
//   integer samples to fill the mantissa of the returned double value.
//
// If you do not need this degree of precision, or prefer faster execution,
//   uncomment the following line and recompile ('make install'):
// #define USETHINDOUBLES 1
// 

@protocol ProbabilityDistribution <SwarmObject, InternalState> 
//S: Ψʬ

//D: ʬ۴ؿ줿ٿ˥ޥå󥹤ץͿ줿ͥ졼ϤˤäơΥץ϶ưޤ

CREATING
//M: createWithDefaults᥽åɤϡǥեȤΥɥåȡǥեȤΥѥ᡼åȡȼΥץ饤١Ȥʥͥ졼äʬۥ֥Ȥޤ
+ createWithDefaults: aZone;

//M: ñʥͥ졼³ȤϡcreateåȤäƤ
+ create: aZone setGenerator: generator;

//M: ʬ䥸ͥ졼³ȤϡcreateåȤäƤ
+ create             : aZone 
         setGenerator: generator
  setVirtualGenerator: (unsigned) vGen;

+ createBegin: aZone;

- createEnd;

SETTING
//M: ñʥͥ졼³ȤϡΥåȤäƤ
- setGenerator: generator;

//M: ʬ䥸ͥ졼³ȤϡΥåȤäƤ
- setGenerator       : generator 
  setVirtualGenerator: (unsigned)vGen;

//M: reset᥽åɤϡߤΥȤ䤽¾ξ֥ǡꥻåȤޤ
- reset;

USING
//M: getGenerator᥽åɤϡͥ졼id֤ޤ
- getGenerator;

//M: getVirtualGeneratorϡѤ줿ۥͥ졼θĿ֤ޤ
- (unsigned)getVirtualGenerator;

//M: getOptionsInitializedϡѥ᡼֤ͤޤ
- (BOOL)getOptionsInitialized;

//M: getCurrentCount᥽åɤϡ줿̤ΥȤ֤ޤ
- (unsigned long long int)getCurrentCount;
@end

// 
// Subtype protocols:
// 

@protocol BooleanDistribution <ProbabilityDistribution> 
//S: Booleanʬ

//D: YES/NOΥץ֤ͤΨʬۡ

USING
//M: getBooleanSample᥽åɤϡYES뤤NOΥץ֤ͤޤ
- (BOOL)getBooleanSample;
- (int)getIntegerSample;	// for convenience
@end

@protocol IntegerDistribution <ProbabilityDistribution> 
//S: Integerʬ

//D: Υץ֤ͤΨʬۡ

USING
//M: getIntegerSample᥽åɤϡΥץ֤ͤޤ
- (int)getIntegerSample;
@end

@protocol UnsignedDistribution <ProbabilityDistribution> 
//S: Unsignedʬ

//D: ǤʤΥץ֤ͤΨʬۡ

USING
//M: getUnsignedSample᥽åɤϡǤʤΥץ֤ͤޤ
- (unsigned)getUnsignedSample;
@end

@protocol DoubleDistribution <ProbabilityDistribution>
//S: Doubleʬ

//D: ưͤɽ줿Ϣ³ͤζ֤ͤΨʬۡ

USING
//M: getDoubleSample᥽åɤϡư֤ͤޤ
- (double)getDoubleSample;
@end

// 
// Protocol definitions for specific distributions:
// 
// 

@protocol RandomBitDist <BooleanDistribution, CREATABLE>
//S: ӥåʬ

//D: ʬۤ˽ñΥӥå(Ĥޤʿʥꤲ)֤ͥ졼

USING
//M: getCoinToss᥽åɤϡYESNO֤ͤޤ
- (BOOL)getCoinToss;
@end

@protocol BernoulliDist <BooleanDistribution, CREATABLE>
//S: ٥̡ʬ

//D: ꤷΨYES֤ʬۡ
CREATING
//M: ñʥͥ졼³ȤϡcreateåѤƤ
+ create        : aZone
    setGenerator: generator
  setProbability: (double)p;

//M: ʬ䥸ͥ졼³ȤϡcreateåѤƤ
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
       setProbability: (double)p;

SETTING
//M: setProbability:᥽åɤϡYES֤Ψ򥻥åȤޤ
- setProbability: (double)p;

USING
//M: getProbability᥽åɤϡYES֤Ψ֤ޤ
- (double)getProbability;

//M: getSampleWithProbability:ϡYESޤNOΥץ֤ͤޤ
- (BOOL)getSampleWithProbability: (double)p;
@end


@protocol UniformIntegerDist <IntegerDistribution, CREATABLE>
//S: integerʬ

//D: Ĥ[min,max]ǰʬۤ˽ͤΥͥ졼(֤ξνޤߤޤ)աminValue == maxValueȤ꤬ǧޤ(minValue֤ޤ)
CREATING
//M: ñʥͥ졼³ȤϡcreateåȤäƤ 
+ create      : aZone
  setGenerator: generator
 setIntegerMin: (int)minValue
        setMax: (int)maxValue;

//M: ʬ䥸ͥ졼³ȤϡcreateåȤäƤ 
+ create           : aZone
       setGenerator: generator
setVirtualGenerator: (unsigned) vGen
      setIntegerMin: (int)minValue
             setMax: (int)maxValue;

SETTING
//M: setIntegerMin:setMax:᥽åɤϡ֤ǾӺ򥻥åȤޤ
- setIntegerMin: (int)minValue setMax: (int)maxValue;

USING
//M: getIntegerMin᥽åɤϡǾ֤ͤޤ
- (int)getIntegerMin;

//M: getIntegerMax᥽åɤϡ֤ͤޤ
- (int)getIntegerMax;

//M: getIntegerWithMin:withMax:ϡ[min, max]֤ޤ
- (int)getIntegerWithMin: (int)minValue withMax: (int)maxValue;
@end

@protocol UniformUnsignedDist <UnsignedDistribution, CREATABLE> 
//S: Unsignedʬ

//D: Ĥ[min,max]ǰʬۤ˽ǤʤͤΥͥ졼(֤ξνޤߤޤ)աminValue == maxValueȤ꤬ǧޤ(minValue֤ޤ)
CREATING
//M: ñʥͥ졼³ȤϡcreateåȤäƤ
+ create        : aZone
    setGenerator: generator
  setUnsignedMin: (unsigned)minValue
          setMax: (unsigned)maxValue;

//M: ʬ䥸ͥ졼³ȤϡcreateåȤäƤ 
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
       setUnsignedMin: (unsigned)minValue
               setMax: (unsigned)maxValue;

SETTING
//M: setUnsignedMin:setMax:᥽åɤϡ֤ǾӺunsignedͤ򥻥åȤޤ
- setUnsignedMin: (unsigned)minValue
          setMax: (unsigned)maxValue;

USING
//M: getUnsignedMin᥽åɤϡǾunsigned֤ͤޤ
- (unsigned)getUnsignedMin;

//M: getUnsignedMax᥽åɤϡunsigned֤ͤޤ
- (unsigned)getUnsignedMax;

//M: getUnsignedWithMin:withMax:᥽åɤϡ[min, max]unsigned֤ޤ
- (unsigned)getUnsignedWithMin: (unsigned)minVal 
                       withMax: (unsigned)maxVal;
@end

@protocol UniformDoubleDist <DoubleDistribution, CREATABLE> 
//S: Doubleʬ

//D: ¦[min,max)ǰʬۤ˽ưͤΥͥ졼(֤ˤϲ¤νϴޤޤޤ¤νϴޤޤޤ)աminValue == maxValueȤ꤬ǧޤ(minValue֤ޤ)

CREATING
//M: ñʥͥ졼³ȤϡcreateåȤäƤ
+ create        : aZone
    setGenerator: generator
    setDoubleMin: (double)minValue
          setMax: (double)maxValue;

//M: ʬ䥸ͥ졼³ȤϡcreateåȤäƤ
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
         setDoubleMin: (double)minValue
               setMax: (double)maxValue;

SETTING
//M: setDoubleMin:setMax᥽åɤϡʬۤκǾӺưͤ򥻥åȤޤ
- setDoubleMin: (double)minValue setMax: (double)maxValue;

USING
//M: getDoubleMin᥽åɤϡꤷϰϤκǾư֤ͤޤ
- (double)getDoubleMin;

//M: getDoubleMax᥽åɤϡꤷϰϤκư֤ͤޤ
- (double)getDoubleMax;

//M: getDoubleWithMin:withMax:᥽åɤϡ[min, max)ϰϤˤư֤ͤޤ
- (double)getDoubleWithMin: (double)minValue withMax: (double)maxValue;
@end

@protocol Normal <DoubleDistribution> 
//S: 
CREATING
//M: ñʥͥ졼³ȤϡcreateåѤƤ
+ create        : aZone
    setGenerator: generator
         setMean: (double)mean
     setVariance: (double)variance;

//M: ʬ䥸ͥ졼³ȤϡcreateåѤƤ
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
              setMean: (double)mean
          setVariance: (double)variance;

SETTING
//M: setMean:setVariance:᥽åɤϡʬۤʿͤʬ򥻥åȤޤ
- setMean: (double)mean setVariance: (double)variance;

USING
//M: getMean᥽åɤϡʬۤʿ֤ͤޤ
- (double)getMean;

//M: getVariance᥽åɤϡʬۤʬ֤ޤ
- (double)getVariance;

//M: getStdDev᥽åɤϡʬۤɸк֤ޤ
- (double)getStdDev;

//M: getSampleWithMean:withVariance:᥽åɤϡꤷʿͤʬȤäʬۤ饵ץ֤ͤޤ
- (double)getSampleWithMean: (double)mean 
               withVariance: (double)variance;
@end

@protocol NormalDist <Normal, CREATABLE> 
//S:  (Gaussian)ʬ

//D:  double֤ͭ̾Ϣ³Ψʬۡ 
@end

@protocol LogNormalDist <Normal, CREATABLE> 
//S: пʬ

//D:  double֤ͭ̾Ϣ³Ψʬۡ 
@end

@protocol ExponentialDist <DoubleDistribution, CREATABLE> 
//S: ؿʬ

//D: double֤ͭ̾Ϣ³Ψʬۡ
CREATING
//M: ñʥͥ졼³ȤϡcreateåѤƤ
+ create      : aZone
  setGenerator: generator
       setMean: (double)mean;

//M: ʬ䥸ͥ졼³ȤϡcreateåѤƤ
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
              setMean: (double)mean;


SETTING
//M: setMean:᥽åɤϡʬۤʿͤ򥻥åȤޤ
- setMean: (double)mean;

USING
//M: getMean᥽åɤϡʬۤʿ֤ͤޤ
- (double)getMean;

//M: getSampleWithMean:᥽åɤϡꤷʿͤĻؿʬۤ饵ץ֤ͤޤ
- (double)getSampleWithMean: (double)mean;
@end

@protocol GammaDist <DoubleDistribution, CREATABLE>
//S: ʬ

//D: double֤ͭ̾Ϣ³Ψʬۡ
CREATING
//M: ñʥͥ졼³ȤϡcreateåѤƤ
+ create     : aZone
 setGenerator: generator
     setAlpha: (double)alpha
      setBeta: (double)beta;

//M: ʬ䥸ͥ졼³ȤϡcreateåѤƤ
+ create             : aZone
         setGenerator: generator
  setVirtualGenerator: (unsigned)vGen
             setAlpha: (double)alpha
              setBeta: (double)beta;

SETTING
//M: setAlpha:setBeta:᥽åɤϡʬۤΥեȥ١ͤ򥻥åȤޤ
- setAlpha: (double)alpha setBeta: (double)beta;

USING
//M: getAlpha᥽åɤϥե֤ͤޤ
- (double)getAlpha;

//M: getBeta᥽åɤϥ١֤ͤޤ
- (double)getBeta;

//M: getSampleWithAlpha:withBeta:᥽åɤϡꤷեͤȥ١ͤĥʬۤ顢ץ֤ͤޤ
- (double)getSampleWithAlpha: (double)alpha 
                    withBeta: (double)beta;
@end

// Include declarations of type factories for each protocol marked CREATABLE
// (type factories can be defined either as class names or external id's)

// Boolean:
@class RandomBitDist;
@class BernoulliDist;

// Integer:
@class UniformIntegerDist;

// Unsigned:
@class UniformUnsignedDist;

// Double:
@class UniformDoubleDist;
@class NormalDist;
@class LogNormalDist;
@class ExponentialDist;
@class GammaDist;

