// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.    

//S: ߥ졼ѤGUIϢǽ

#import <objectbase.h>
#import <activity.h> // SwarmProcess

@protocol WindowGeometryRecordName <SwarmObject>
//S: ɥȥ򥢡֤ץȥ롣

//D: ɥȥΥ֤򡢤Υץȥ˽碌륯饹

CREATING
//M: ProbeDisplay󥹥󥹤̾򥻥åȤޤȥϿȤArchiverϤ̾Ѥޤ
- setWindowGeometryRecordName: (const char *)windowGeometryRecordName;

//#: Υޥϡɥȥꡦ쥳ɤtheWidgetΥ󥹥̾򥻥åȤޤ
#define SET_WINDOW_GEOMETRY_RECORD_NAME(theWidget) \
  [theWidget setWindowGeometryRecordName: #theWidget]
@end

@protocol CompositeWindowGeometryRecordName <WindowGeometryRecordName>
//S: ĤGUIݡͥȤȼä֥Ȥ򥢡֤ץȥ롣

//D: ĤGUIݡͥȤȼä֥ȤΥݡͥȤ˥̾Ƥޤ
CREATING
//M: ݡͥȤΥꥹȤ򹹿̾׻ޤ
- setWindowGeometryRecordNameForComponent: (const char *)componentName
                                   widget: widget;

#define SET_COMPONENT_WINDOW_GEOMETRY_RECORD_NAME_FOR(obj, theWidget) \
  [(obj) setWindowGeometryRecordNameForComponent: #theWidget widget: theWidget]

#define SET_COMPONENT_WINDOW_GEOMETRY_RECORD_NAME(theWidget) \
  SET_COMPONENT_WINDOW_GEOMETRY_RECORD_NAME_FOR (self,theWidget)

@end


@protocol ControlPanel <SwarmObject>
//S: ȥåץ٥SwarmProcess򥳥ȥ뤹륯饹

//D: ControlPanelrunstopquittime stepȤߥ졼ؤΥ桼ꥯȤΥȥåݤGUISwarmȶϤSwarmΥƥӥƥμ¹Ԥ򥳥ȥ뤷ޤ
CREATING
- createEnd;

USING
//M: controlpanelθߤΥܥ֡ControlStateRunningControlStateStoppedControlStateSteppingControlStateNextTime뤤ControlStateQuitޤ
- getState;

- setState: s;

- startInActivity: activityID;

//M: ֤`running'˥åȤޤ
- setStateRunning;

//M: -setStateStoppedϡä˥桼Ū˺ƥȤ򥻥åȤޤǥߥ졼ߤΤʥåǤ(Ĥޤꡢߥ졼򥽥եȥ¦켡ߤΤǤ)
- setStateStopped;

//M: ¹Υƥӥƥߤ֤`ControlStateStepping'򥻥åȤޤ
- setStateStepping;

//M: ƥӥƥλ֤`ControlStateQuit'򥻥åȤޤ
- setStateQuit;

//M: ¹Υƥӥƥߤ֤`ControlStateNextTime'򥻥åȤޤ
- setStateNextTime;

//M: ֤Ͽ륪֥Ȥ¸ޤ
- setStateSave;

@end

@protocol ActionCache <CompositeWindowGeometryRecordName>
//S: åɤSwarm륯饹

//D: SwarmΥ塼ͽSwarm䡢¾Υåɤ˥륢Ǽ륹ޡȥХå󶡤륯饹Ǥ
CREATING
- setControlPanel: cp;
- createEnd;
- createProcCtrl;

USING
- setScheduleContext: context;
- insertAction: actionHolder;
- deliverActions;
- sendActionOfType: (id <Symbol>) type toExecute: (const char *)cmd;
- sendStartAction;
- sendStopAction;
- sendStepAction;
- sendNextAction;
- sendQuitAction;
- verifyActions;

- getPanel;
- doTkEvents;  // should change to pollGUI or something
- waitForControlEvent;
- (void)drop;
@end

//G: ActionCacheηSymbol
extern id <Symbol> Control, Probing, Spatial;

//G: ActionCacheΥ顼Symbol
extern id <Symbol> InvalidActionType, ActionTypeNotImplemented;


@protocol CommonProbeDisplay <WindowGeometryRecordName>
//S: ProbeDisplayCompleteProbeDisplayδäȤץȥ롣

//D: Υץȥϡ٤ƤμProbeDisplayФ붦̤Υ󥿡ե󶡤ޤ

USING
//M: Υ᥽åɤϡprobedObjectѿͤȡProbeDisplayɽͤޤŪˤϡ֥Ȥߥ졼˽Ȥϡʤ餺Υ᥽åɤƤӽФ٤ǤŪˤϡprobeDisplayManagerǹ򥹥塼뤷probeDisplayManagerƥˤ뤹٤ƤΥƥ֤ProbeDisplayȽ˥ߥ˥ȤƤޤ
- update;

- (BOOL)getMarkedForDropFlag;
- getTopLevel;
@end

@protocol SingleProbeDisplay <CommonProbeDisplay>
//S: ñ쥪֥Ȥprobe displayδäȤݥץȥ

//D: ΥץȥϡCompleteProbeDisplayProbeDisplay˶̤Ǥ
CREATING
//M: Υ᥽åɤϤʤ餺ƤӽФʤФʤޤ
- setProbedObject: anObject;

- createEnd;
USING
//M: probe줿֥Ȥޤ
- getProbedObject;
@end

@protocol ProbeDisplay <SingleProbeDisplay>
//S: ProbeMapɽ륯饹

//D: Ϳ줿åȥ֥ȤŬѤprobeProbeMapGUI륯饹

CREATING
//M: createեΤΥ᥽åɤϤʤ餺ɬפޤprobeMapޤäꤵƤʤСProbeDisplayϸҤgetProbeMap᥽åɤȤäơProbeMapprobedObject뤳ȤˤʤޤΥ᥽åɤΥǥեȤο񤤤ϡåȥ֥ȤΥ饹ФprobeMapprobeLibraryΥԡ֤ȤǤ
- setProbeMap: (id <ProbeMap>)probeMap;

- createEnd;

USING
//M: probeMapޤ
- (id <ProbeMap>)getProbeMap;

@end

@protocol CompleteProbeDisplay <SingleProbeDisplay>
//S: ֥Ȥ˴ProbeMap륯饹

//D: åȥ֥ȤŬѤprobeδProbeMapGUI륯饹(""Ȥϡåȥ֥ȤΥ饹ȤΥѡ饹Ф뤹٤Ƥprobeޤޤ뤳Ȥ̣ޤ)
@end

@protocol MultiVarProbeDisplay <CommonProbeDisplay>
//S: ʣΥ֥ȤˤޤProbeMapɽޤ

//D: ProbeDisplayprobeMap餹٤Ƥѿprobe桼󶡤ꥹȤˤƥ֥Ȥѿprobeȥޤ
CREATING
//M: ɽ륪֥ȤΥꥹȤ򥻥åȤޤ
- setObjectList: (id <List>)objectList;

//M: ɽprobe map(ĤޤեɤΥꥹ)򥻥åȤޤ
- setProbeMap: (id <ProbeMap>)probeMap;

//M: ֥Ȥ˥٥Ĥ뤿륻쥯򥻥åȤޤ
- setObjectNameSelector: (SEL)objectNameSelector;

//M: ѿ̾(ʿ)ץȤ뤫ꤷޤ
- setLabelingFlag: (BOOL)labelingFlag;

+ createBegin: aZone;
- createEnd;
USING
- (void)drop;
@end

extern id <ProbeDisplay> _createProbeDisplay (id obj);
extern id <CompleteProbeDisplay> _createCompleteProbeDisplay (id obj);

extern id <ProbeDisplay> createArchivedProbeDisplayNamed (id obj, const char *name);
extern id <CompleteProbeDisplay> createArchivedCompleteProbeDisplayNamed (id obj, const char *name);


@protocol ProbeDisplayManager <SwarmObject>
//S: ProbeDisplayޥ͡㡣

//D: ProbeDisplayManager(󥰥ȥ)饹Υ󥹥󥹤ϡߥ졼GUI¹桢桼٤ƤProbeDisplayޤ
USING
- (id <ProbeDisplay>)createProbeDisplayFor: anObject;

- (id <ProbeDisplay>)createArchivedProbeDisplayFor: anObject variableName: (const char *)variableName;

- (id <ProbeDisplay>)createDefaultProbeDisplayFor: anObject;

- (id <ProbeDisplay>)createArchivedDefaultProbeDisplayFor: anObject 
                                             variableName: (const char *)variableName;

- (id <CompleteProbeDisplay>)createCompleteProbeDisplayFor: anObject;

- (id <CompleteProbeDisplay>)createArchivedCompleteProbeDisplayFor: anObject variableName: (const char *)variableName;

//M: ProbeDisplayManagerprobe displayɲäޤ
- addProbeDisplay: probeDisplay;

//M: ꤷprobe displayProbeDisplayManagerδ鳰ޤ
- removeProbeDisplay: probeDisplay;

//M: ꤷ֥Ȥбprobe displayProbeDisplayManagerδ鳰ޤ
- removeProbeDisplayFor: anObject;

//M: ꤷ֥Ȥбprobe displayɥåפޤ
- dropProbeDisplaysFor: anObject;

//M: ProbeDisplayManager˴Ƥ뤹٤Ƥprobe displayˡȿŪʹåޤ
 
- update;

- setDropImmediatelyFlag: (BOOL)dropImmediateFlag;

//#: ꤷ֥Ȥprobe displayޤ
#define CREATE_PROBE_DISPLAY(anObject) \
  _createProbeDisplay(anObject)

//#: ꤷ֥Ȥδprobe displayޤ
#define CREATE_COMPLETE_PROBE_DISPLAY(anObject) \
  _createCompleteProbeDisplay(anObject)

//#: ꤷ֥ȤΡɥФ¸٤probe displayޤ
#define CREATE_ARCHIVED_PROBE_DISPLAY(anObject) \
  createArchivedProbeDisplayNamed(anObject,#anObject)

//#: ꤷ֥ȤΡɥФ¸٤probe displayޤ
#define CREATE_ARCHIVED_COMPLETE_PROBE_DISPLAY(anObject) \
  createArchivedCompleteProbeDisplayNamed(anObject,#anObject)

@end

@protocol GUIComposite <CompositeWindowGeometryRecordName>
//S: ĤGUIݡͥȤѤ륪֥Ȥδ쥯饹

//D: ĤGUIݡͥȤѤ륪֥Ȥδ쥯饹
USING
- enableDestroyNotification: notificationTarget
         notificationMethod: (SEL)notificationMethod;
- disableDestroyNotification;
@end

@protocol GUISwarm <SwarmProcess, WindowGeometryRecordName>
//S: Swarm饹ΥեѤС

//D: GUISwarmSwarmΥ֥饹ǡե桼󥿡եȤäߥ졼μ¹ԤФƥȥåץ٥SwarmȤƻѤޤGUISwarmϼưŪˤʤControlPanel-go᥽åɤޤ-go᥽åɤControlPanelξ֤ᤷơ桼Ϥб¹Ծݻޤ桼ϡbuildObjectsbuildActionsactivateIn᥽åɤʤɤơ̤Swarm򥵥֥饹ΤƱͤGUISwarm򥵥֥饹ޤObserver SwarmۤƤȤϡ[myGUISwarm go]Ȥȥåץ٥ȤƤ򥹥ȤƤ

//D: controlPanelϡGUISwarm֥饹γȯԤ¿Ǥݤޤä[controlPanel doTkEvents]Ȥåϡʤˤ˥塼뤷ƤʤФʤޤ󡣤ʤʤ顢桼󥿡ե졢stopܥ󤬥åΤϡΥ᥽åɤ¹ԤȤǤ桼μ¹ԳϤνԤĤȤϡ[controlPanel setStateStopped]ȤǤ

USING
//M: ƥӥƥμ¹Ԥ򳫻ϤޤcontrolPanel̤ƥ桼ꥯȤޤCompleted(λ׵ᤵޤǥǥ뤬¹Ԥ줿Ȥ)뤤ControlStateQuit(桼quitܥ򲡤Ȥ)֤ޤ
- go;
- (void)drop;
@end

@protocol MessageProbeWidget
//S: MessageProbeΰԽ륦åȡ

//D: MessageProbeΰԽ륦å
CREATING
+ createBegin: aZone;
- setParent: parent;
- setObject: object;
- createEnd;
- setProbe: probe;

USING
- pack;
@end

@protocol MultiVarProbeWidget
//S: ʣΥեɤˤޤʣΥ֥Ȥɽ륦åȡ

//D: ʣΥեɤˤޤʣΥ֥Ȥɽ륦åȡ
CREATING
+ createBegin: aZone;
- createEnd;
- setParent: parent;

//M: ե(probe)˥٥Ť뤫ꤷޤ(ʿ) 
- setFieldLabelingFlag: (BOOL)labelingFlag;
//M: ƥ֥ȤΥ٥μ˻Ѥ᥽åɤ򥻥åȤޤ(ľ)
- setObjectNameSelector: (SEL)objectNameSelector;
//M: åȤ˼֥Ȥ򥻥åȤޤ
- setObjectList: (id <List>)objectList;
//M: åȤ˼ե(probe)򥻥åȤޤ
- setProbeMap: (id <ProbeMap>)probeMap;

USING
- update;
- pack;
- (void)drop;
@end

//G: ٤ƥ֤probeΥȥåݤĥޥ͡㡣
extern id <ProbeDisplayManager> probeDisplayManager;

//G: ControlPanelξSymbol
extern id ControlStateRunning, ControlStateStopped, ControlStateStepping,
  ControlStateNextTime, ControlStateQuit;

//F: 饤֥ProbeDisplayManagerޤ
extern void initSimtoolsGUI (void);

@class ControlPanel;
@class ActionCache;
@class ProbeDisplay;
@class CompleteProbeDisplay;
@class MultiVarProbeDisplay;
@class ProbeDisplayManager;
@class GUISwarm;
@class MessageProbeWidget;
@class MultiVarProbeWidget;
