// Swarm library. Copyright (C) 1996-1998 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

//S: ͡ʶ֤Υ֥Ȥвġ롣

//D: SwarmSpace饤֥ϡȤߤ˺ѤĶۤȤˡ򥢥Ȥ뤿""ʬȤʤ饤֥Ǥ̤ˡȤѲˤĤƴĶѲϤǤ(ǤϡĶȤ⤦1ĤΥȤǤ)¿Υߥ졼ϡΥɤˤäͭ˥ݡȤ褦ĶäƤޤ

//D: ߤspace饤֥ñʼΥ2֤ǤǤˤϲɤͽꤵƤޤ(todoꥹȤ򻲾ȤƤ)ʷ˸Сɸϥ֥Ȥξ֤˾ʤʤФʤޤ󡣤κɸ˾ޤΤϡ͡ʥ䶭Ķ֤̤λȷϤ̤ߺѤǤ뤳ȤǤˡϢ³ɸ¾ǤդΥդʤɤ¾ζַȤ˾ޤޤ

#import <objectbase.h>
#import <gui.h> // Raster, Colormap

@protocol _Discrete2d
CREATING
//M: Υ򥻥åȤޤ
- setSizeX: (unsigned)x Y: (unsigned)y;

//M: ʻҤ˥Ƥޤ
- (id *)allocLattice;

//M: 󥵥Ϳơyˤ軻򥭥å夹륪եå׻ޤdiscrete2dSiteAtޥ򻲾ȤƤ
- makeOffsets;

//M: ʻҤ餫Yɸˤ륪եåȤ׻ޤ
- createEnd;

USING
//M: Xγʻҥޤ
- (unsigned)getSizeX;

//M: Yγʻҥޤ
- (unsigned)getSizeY;

//M: (x,y)˳Ǽ줿ݥ󥿤֤ޤ
- getObjectAtX: (unsigned)x Y: (unsigned)y;

//M: (x,y)˳Ǽ줿֤ޤ
- (long)getValueAtX: (unsigned)x Y: (unsigned)y;

//M: ꤷݥ󥿤(x,y)ͿˤΤ򤹤٤ƾ񤭤ޤ
- putObject: anObject atX: (unsigned)x Y: (unsigned)y;

//M: ꤷ(x,y)ͿˤΤ򤹤٤ƾ񤭤ޤ
- putValue: (long)v atX: (unsigned)x Y: (unsigned)y;

//M: ľŪͤʻҤߤޤ
- fastFillWithValue: (long)aValue;

//M: ľŪ˥֥ȤʻҤߤޤ
- fastFillWithObject: anObj;

//M: putValueȤäƶ֤ޤ
- fillWithValue: (long)aValue;

//M: putObjectȤäƶ֤ޤ
- fillWithObject: anObj;

//M: ʻҤΥݥ󥿤֤ޤ®˥뤿ˤȤޤ
- (id *)getLattice;

//M: PGMեޥåȤΥեɤ߹ǡΥǡDiscrete2d֥Ȥ³ޤ
- (int)setDiscrete2d: a toFile: (const char *)filename;

//M: Discrete2d֥ȤΥǡ̤Discrete2d֥Ȥ˥ԡޤξΥ֥ȤǤ¸ߤƤ뤳ȤȤʤޤ
- copyDiscrete2d: a toDiscrete2d: b;

- (long *)getOffsets;
@end

@protocol Discrete2d <_Discrete2d, SwarmObject>
//S: 2Υ֤Υ롼ȥ饹

//D: ŪˤDiscrete2did2Ǥ֥饹Ϥξζ֥ޥƥɲäޤߤDiscrete2dåɤϡXɸYɸΥڥˤäƥޤ
@end

@protocol DblBuffer2d <Discrete2d>
//S: ֥Хåե֡

//D: DblBuffer2dDiscrete2d礷ơ֥Хåե֤η󶡤ޤlattice(ߤξ)newLattice(ξ)Ȥ2ĤγʻҤ졢ɤ߹ߤϤ٤lattice顢񤭹ߤϤ٤newLatticeˤʤޤupdateLatticeƤӽФȡnewLatticelattice˥ԡޤDblBuffer2dϡCa2dsƱ褦¹ԥ1ĤΥǥΤ˻ѤǤޤա٥ΥޥȤä˥ƤȤϡʤդɬפǤäˡnewLatticeν񤭹ߥޥƥݸǧƤ

CREATING
//M: Discrete2d᥽åɤƽ񤭹ߤޤ2ĤγʻҤƤƥեåȤäƤ
- createEnd;

USING
//M: newLatticeХåե˥ݥ󥿤֤ޤ
- (id *)getNewLattice;

//M: newLatticelattice˥ԡ¾lattice򹹿ޤ
- updateLattice;

//M: С饤ɤΤǡnewLatticeؤν񤭹ߤȯޤ
- putObject: anObject atX: (unsigned)x Y: (unsigned)y;

//M: С饤ɤΤǡnewLatticeؤν񤭹ߤȯޤ
- putValue: (long)v atX: (unsigned)x Y: (unsigned)y;
@end

@protocol Ca2d <DblBuffer2d>
//S: 顼ȥޥݥץȥޤ
//D: DblBuffer2dѾ顼ȥޥݥץȥޤ

CREATING
//M: ʤCAΤֿϿޤ
- setNumStates: (unsigned)n;

//M: CA˥ǥեȤν֤򥻥åȤޤCa2dˤϼƤޤ󡣤򥵥֥饹ƳʻҤν֤򥻥åȥåפƤ
- initializeLattice;

//M: numStatesǤ˥åȤƤ뤫ǧޤ
- createEnd;

USING
//M: CA롼1ȿCa2dˤϼƤޤ󡣤򥵥֥饹ƤʤCA롼Ƥ
- stepRule;
@end

@protocol Value2dDisplay <SwarmObject>
//S: 2ͤɽޤ

//D: Value2dDisplay2ͤɽΤΩޤValue2dDisplayͿ줿Discrete2dĴ֤򥫥顼ѤƤRasteråȤޤ

CREATING
//M: ɽåȤȡΤ˻Ѥ륫顼ޥåפ򥻥åȤޤ
- setDisplayWidget: (id <Raster>)r colormap: (id <Colormap>)c;

//M: 褹򥻥åȤޤ
- setDiscrete2dToDisplay: c;

- createEnd;

USING
//M: color = state / m + cȤơ֤褹뿧˰켡ѴޤåȤʤm == 1c == 0Ȥʤޤ
- setDisplayMappingM: (int)m C: (int)c;

//M: Ϳ줿åȤޤաθǤ켫ȤåȤʤФʤޤɽ뤿ΥɤǤϡgetLatticeͤΥåˡDiscrete2dι®ޥѤޤޤɽåȤdrawPointX:Y:᥽åɤΥååפ⥭å夷ޤϤޤˡʤΤǤʤܤɤǤ礦
- display;
@end

@protocol ConwayLife2d <Ca2d>
//S: ŵŪConway2饤եࡣ

//D: ŵŪConway2饤եࡣ
CREATING

//M: ֿ2˥åȤޤ
+ createBegin: aZone;

//M: ʻҤ1Υ1/3˽ޤ
- initializeLattice;

USING
//M: Conway饤ե롼()¹Ԥޤ
- stepRule;
@end

@protocol Diffuse2d <Ca2d>
//S: ȯȼ2Ȼ

//D: ȯȼ2ȻФΥŪ2ζϰ[0,0x7fff]Ƿ׻ޤ

CREATING
//M: ȻȾȯΨ1.0ˡnumStates0x7fff˥åȤޤ
+ createBegin: aZone;

//M: Ȼ򥻥åȤޤ1.0ĶͤͭǤϤޤ
- setDiffusionConstant: (double)d;

//M: ȯΨ򥻥åȤޤ1.0ĶͤϤޤ̣ޤ
- setEvaporationRate: (double)e;

//M: 0˽ޤ
- initializeLattice;

USING
//M: ȻΥ¹Ԥޤդʼˤȡnbdavg٤礦8νŤդʿѤȤnewHeat = evapRate * (self + diffuseConstant*(nbdavg - self))ˤʤޤ
- stepRule;
@end

@protocol Grid2d <Discrete2d>
//S: Ȥ2ƥʥ饹

//D: Grid2dϥȤΰ֤2ʻҾɽΥƥʥ饹ǤΥ饹Discrete2d餽ο񤤤ۤȤɳˤʤäƾ񤭤ʤ褦˥å륳ɤäƤޤGrid2d϶ˤƸŪǤȤС륵Ȥ˳ǼǤ륪֥Ȥ1Ĥǡϴޤޤޤ

CREATING
+ createBegin: aZone;

USING
//M: Discrete2d֤ޤǽ˾񤭤ηٹ򤹤٤åٹɬפǤʤ񤭤褦ȤƤСٹåץȤޤå˴ؤ餺֥ȤϽ񤭹ޤޤ
- putObject: anObject atX: (unsigned)x Y: (unsigned)y;

//M: true˥åȤʤ0x0äƤʤȤ˲Ǽ褦ȤСٹޤ
- setOverwriteWarnings: (BOOL)b;
@end

@protocol Object2dDisplay <SwarmObject>
//S: 2Υ֥Ȥɽޤ

//D: Object2dDisplayϥ֥Ȥ2ɽΤΩޤObject2dDisplayRasteråȡDiscrete2dƥ֥Ⱦ˸ƤӽФå֥ȤΥ쥯(Ǥ)ͿȡObject2dDisplayϰRasteråȤȤ٤ƤΥ֥Ȥ˥åǥѥåޤޤprobeκˤObject2dDisplayΩޤ

CREATING
//M: ˻ѤɽåȤ򥻥åȤޤ
- setDisplayWidget: (id <Raster>)r;

//M: 褹2򥻥åȤޤ
- setDiscrete2dToDisplay: c;

//M: ʬ뤿˥åγƥ֥Ȥå򥻥åȤޤ
- setDisplayMessage: (SEL)s;

USING
//M: ɽ٤֥ȤΥ쥯򥻥åȤޤꤷʤȡObject2dDisplay2åɤ롼פơȯ٤ƤΥ֥ȤåޤåɤޤФʤȤϡ褹륪֥ȤΥ쥯ŪͿΨŪǤ
- setObjectCollection: objects;

//M: (ޤϥ쥯)Τ٤ƤΥ֥ȤrasteråȤޤΥ᥽åɤԤΤɽåƥ֥Ȥ뤳ȤǡɽΤΤϳƥ֥ȤԤޤ
- display;

@end

@protocol Int2dFiler <SwarmObject>
//S: Discrete2d֥Ȥξ֤¸ޤ

//D: Int2dFiler饹ǤդDiscrete2d֥(ޤϤΥ֥饹)򡢻ꤷե¸ޤ

CREATING
+ createBegin: aZone;

USING
//M: ॿåȶ֤򥻥åȤޤΥåʣѤǤޤ֤Ȥ1ĤInt2dFilerݻʤȤ褯ޤ(Ȥж֤ʣ󥻡֤Ȥ)
- setDiscrete2dToFile: sSpace;

//M: åDiscrete2d֥ȷޤȤ˻Ѥ륪ץʥåǤƥ֥Ȥ˥쥯ꤷåȡInt2dFilerϥ֥Ȥ餽ξ֤ɽե˽񤭹ळȤǤޤ
- setValueMessage: (SEL)aSelector;

//M: åDiscrete2d֥ȷޤȤ˻Ѥ륪ץʥåǤ֤֤˥֥Ȥ¸ߤʤȡΥåΰϥեؤνҤ뤿ͤȤʤޤǥեȤΥХå饦ͤ0Ǥ
- setBackground: (int)aValue;

//M: Int2dFilerΥåȡaFileNameȤե򳫤餫ꤵ줿֤ξ֤ǼƥեĤޤ
- fileTo: (const char *)aFileName;
@end

@class Discrete2d;
@class DblBuffer2d;
@class Ca2d;
@class Value2dDisplay;
@class ConwayLife2d;
@class Diffuse2d;
@class Grid2d;
@class Object2dDisplay;
@class Int2dFiler;
