# ------------------------------------------------------------------------
# 	Makefile for demos 
# ------------------------------------------------------------------------

include ../win/makedefs

destdir =	$(scriptdir)/demos
srcdir =	.

SHELL =		bash
RM =		rm -rf
INSTALL =	install -m 0755
INSTALL_DATA =	install -m 0644

instdirs =	$(prefix) $(exec_prefix) $(libdir) $(scriptdir) \
		$(destdir) \
		$(destdir)/bitmaps \
		$(destdir)/bitmaps/hand \
		$(destdir)/bitmaps/fish \
		$(destdir)/images \
		$(destdir)/scripts

demos 	=	barchart1.tcl barchart2.tcl barchart3.tcl barchart4.tcl \
		barchart5.tcl \
		bgexec1.tcl bgexec2.tcl bgexec3.tcl bgexec4.tcl \
		bitmap.tcl \
		busy1.tcl \
		dragdrop1.tcl dragdrop2.tcl \
		eps.tcl \
		graph1.tcl graph2.tcl graph3.tcl graph4.tcl graph5.tcl \
		graph6.tcl graph7.tcl \
		hierbox1.tcl hierbox2.tcl hierbox3.tcl hierbox4.tcl \
		hiertable1.tcl \
		htext1.tcl \
		htext.txt \
		spline.tcl stripchart1.tcl \
		tabset1.tcl tabset2.tcl tabset3.tcl tabset4.tcl  \
		winop1.tcl 

all:

install: inst-dirs inst-bitmaps inst-images inst-scripts 

inst-scripts: 
	for i in $(srcdir)/scripts/*.tcl ; do \
            $(INSTALL) $$i $(destdir)/scripts ; \
	done 
	for i in $(demos) ; do \
            $(INSTALL) $(srcdir)/$$i $(destdir)/$$i ; \
	done 

inst-bitmaps: 
	for i in $(srcdir)/bitmaps/*.xbm ; do \
	    $(INSTALL_DATA) $$i $(destdir)/bitmaps ; \
	done 
	for i in $(srcdir)/bitmaps/hand/*.xbm ; do \
	    $(INSTALL_DATA) $$i $(destdir)/bitmaps/hand ; \
	done 
	for i in $(srcdir)/bitmaps/fish/*.xbm ; do \
	    $(INSTALL_DATA) $$i $(destdir)/bitmaps/fish ; \
	done 

inst-images: 
	for i in $(srcdir)/images/*.gif $(srcdir)/images/*.ps ; do \
	    $(INSTALL_DATA) $$i $(destdir)/images ; \
	done 

inst-dirs:
	@for i in $(instdirs) ; do \
	    if test -d "$$i" ; then : ; else mkdir "$$i" ; fi ; \
        done

clean:
	$(RM) $(srcdir)/*.bak $(srcdir)/*\~ $(srcdir)/"#"* 

distclean: clean
	$(RM) *.ps Makefile
