/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private static Hashtable portlist = new Hashtable();
    private CommPort port;
    private int type;
    private String owner;
    private Vector listeners;

    private CommPortIdentifier(CommPort commPort, int n) {
        this.port = commPort;
        this.type = n;
        this.owner = null;
        this.listeners = new Vector(2);
    }

    public static Enumeration getPortIdentifiers() {
        return portlist.elements();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = (CommPortIdentifier)portlist.get(string);
        if (commPortIdentifier == null) {
            throw new NoSuchPortException();
        }
        return commPortIdentifier;
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        return CommPortIdentifier.getPortIdentifier(commPort.getName());
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        commDriver.initialize();
        CommPort commPort = commDriver.getCommPort(string, n);
        portlist.put(string, new CommPortIdentifier(commPort, n));
    }

    public String getName() {
        return this.port.getName();
    }

    public int getPortType() {
        return this.type;
    }

    public String getCurrentOwner() {
        return this.owner;
    }

    public synchronized boolean isCurrentlyOwned() {
        return this.owner != null;
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        if (this.owner != null) {
            int n2 = this.listeners.size();
            for (int i = 0; i < n2; ++i) {
                ((CommPortOwnershipListener)this.listeners.elementAt(i)).ownershipChange(3);
            }
            if (this.owner != null) {
                throw new PortInUseException(this.owner);
            }
        }
        this.owner = string;
        return this.port;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.listeners.addElement(commPortOwnershipListener);
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.listeners.removeElement(commPortOwnershipListener);
    }
}

