/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;

class Defaults {
    static String ConsoleClass = null;
    static boolean AutoStop = true;
    static int ClickInterval = 250;
    static int ClickDistance = 0;
    static int EventPollingRate = 30;
    static int GraFlushRate = 250;
    static int ScreenSize = 130;
    static int ScreenWidth;
    static int ScreenHeight;
    static int XResolution;
    static int YResolution;
    static int MenuBarHeight;
    static int ScrollbarWidth;
    static Insets FrameInsets;
    static Insets DialogInsets;
    static String FsDefault;
    static String FsMonospaced;
    static String FsSansSerif;
    static String FsSerif;
    static String FsDialog;
    static String FsDialogInput;
    static String FsZapfDingbats;
    static int[] RgbRequests;
    static Color FocusClr;
    static Color WndForeground;
    static Color WndBackground;
    static Font WndFont;
    static FontMetrics WndFontMetrics;
    static Font MenuFont;
    static Color MenuTxtClr;
    static Color MenuSelTxtClr;
    static Color MenuBgClr;
    static Color MenuSelBgClr;
    static boolean MenuTxtCarved;
    static Font TextFont;
    static Color TextAreaBgClr;
    static Color TextAreaTxtClr;
    static Color TextAreaRoBgClr;
    static Color TextAreaRoTxtClr;
    static Font TextAreaFont;
    static Color TextAreaSelBgClr;
    static Color TextAreaSelTxtClr;
    static Color TextCursorClr;
    static Color TextCursorInactiveClr;
    static boolean ShowInactiveCursor;
    static boolean FocusScrolls;
    static Color TextFieldBgClr;
    static Color TextFieldTxtClr;
    static Color TextFieldSelBgClr;
    static Color TextFieldSelTxtClr;
    static Font TextFieldFont;
    static Font ListFont;
    static Color ListBgClr;
    static Color ListTxtClr;
    static Color ListSelBgClr;
    static Color ListSelTxtClr;
    static Color ListFlyOverBgClr;
    static Color ListFlyOverTxtClr;
    static boolean ListFlyOverInset;
    static Color LabelClr;
    static Font LabelFont;
    static boolean LabelTxtCarved;
    static Color BtnClr;
    static Color BtnTxtClr;
    static Color BtnPointClr;
    static Color BtnPointTxtClr;
    static Font BtnFont;
    static boolean BtnTxtCarved;
    static Color BorderClr;
    static String RootWindowClass;
    static Color RootWindowClr;
    static String RootWindowImg;
    static String KeyTabClass;
    static Color WndActiveClr;
    static Color WndActiveTitleClr;
    static Color WndInactiveClr;
    static Color WndInactiveTitleClr;
    static String ControlBoxClass;
    static String MinBoxClass;
    static int FileImageThreshold;
    static int DataImageThreshold;
    static int MemImageSrcThreshold;
    static int RecycleEvents;
    static String banner;
    static String beep;
    static String UserInitClass;

    static boolean setBooleanValue(String string, boolean bl) {
        String string2 = System.getProperty(string);
        boolean bl2 = string2 != null ? string2.equalsIgnoreCase("true") : bl;
        return bl2;
    }

    static Color setColorValue(String string, Color color) {
        Color color2 = color;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                color2 = new Color(Integer.parseInt(string2, 16));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("malformed awt property: " + string);
            }
            string2 = null;
        }
        return color2;
    }

    static int setIntValue(String string, int n) {
        int n2 = n;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("malformed awt property: " + string);
            }
            string2 = null;
        }
        return n2;
    }

    static String setStringValue(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    Defaults() {
    }

    static {
        ScrollbarWidth = 14;
        FrameInsets = new Insets(24, 4, 4, 4);
        DialogInsets = new Insets(24, 4, 4, 4);
        RgbRequests = new int[]{0xC3C3C3, 0xE6E6E6, 0xA3A3A3, 0xBE0000};
        FocusClr = new Color(191, 0, 0);
        WndForeground = Color.black;
        WndBackground = Color.lightGray;
        MenuTxtClr = Color.black;
        MenuSelTxtClr = FocusClr;
        MenuBgClr = Color.lightGray;
        MenuSelBgClr = new Color(180, 180, 180);
        MenuTxtCarved = true;
        TextAreaBgClr = Color.white;
        TextAreaTxtClr = Color.black;
        TextAreaRoBgClr = Color.white;
        TextAreaRoTxtClr = Color.gray;
        TextAreaSelBgClr = Color.lightGray;
        TextAreaSelTxtClr = Color.black;
        TextCursorClr = Color.blue;
        TextCursorInactiveClr = Color.gray;
        ShowInactiveCursor = false;
        FocusScrolls = false;
        TextFieldBgClr = Color.white;
        TextFieldTxtClr = Color.black;
        TextFieldSelBgClr = Color.lightGray;
        TextFieldSelTxtClr = Color.black;
        ListBgClr = new Color(223, 223, 223);
        ListTxtClr = Color.black;
        ListSelBgClr = new Color(163, 163, 163);
        ListSelTxtClr = Color.black;
        ListFlyOverBgClr = new Color(214, 214, 214);
        ListFlyOverTxtClr = Color.black;
        ListFlyOverInset = false;
        LabelClr = Color.black;
        LabelTxtCarved = false;
        BtnClr = new Color(163, 163, 163);
        BtnTxtClr = Color.black;
        BtnPointClr = new Color(180, 180, 180);
        BtnPointTxtClr = FocusClr;
        BtnTxtCarved = true;
        BorderClr = new Color(159, 159, 159);
        RootWindowClass = "java.awt.RootWindow";
        RootWindowClr = Color.blue;
        RootWindowImg = "marble.jpg";
        KeyTabClass = "java.awt.KeyTabGr";
        WndActiveClr = new Color(191, 0, 0);
        WndActiveTitleClr = Color.yellow;
        WndInactiveClr = Color.lightGray;
        WndInactiveTitleClr = Color.black;
        ControlBoxClass = "java.awt.WinTaskBar";
        MinBoxClass = "java.awt.WinTaskBar";
        FileImageThreshold = Integer.MAX_VALUE;
        DataImageThreshold = Integer.MAX_VALUE;
        MemImageSrcThreshold = Integer.MAX_VALUE;
        RecycleEvents = 0;
        UserInitClass = Defaults.setStringValue("awt.UserInitClass", null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ScreenWidth = dimension.width;
        ScreenHeight = dimension.height;
        XResolution = (int)((double)ScreenWidth * 10.0 / (0.8 * (double)ScreenSize));
        YResolution = (int)((double)ScreenHeight * 10.0 / (0.6 * (double)ScreenSize));
        String string = Toolkit.tlkVersion();
        if (string.startsWith("grx")) {
            FsDefault = "helv%d%s%s.fnt";
            FsMonospaced = "xm7x13b.fnt";
            FsSansSerif = "helv%d%s%s.fnt";
            FsSerif = "tms%d%s%s.fnt";
            FsDialog = "cour%d%s%s.fnt";
            FsDialogInput = "cour%d%s%s.fnt";
            FsZapfDingbats = "helv%d%s%s.fnt";
        } else if (string.startsWith("X")) {
            int n = ScreenWidth > 1024 ? 100 : 75;
            String string2 = Integer.toString(n) + '-' + n + "-*-*-*-*";
            FsDefault = "-adobe-helvetica-%s-%s-*-*-*-%d-" + string2;
            FsMonospaced = "-adobe-courier-%s-%s-*-*-*-%d-" + string2;
            FsSansSerif = "-adobe-helvetica-%s-%s-*-*-*-%d-" + string2;
            FsSerif = "-adobe-times-%s-%s-*-*-*-%d-" + string2;
            FsDialog = "-misc-fixed-%s-%s-*-*-*-%d-" + string2;
            FsDialogInput = "-b&h-lucidatypewriter-%s-%s-*-*-*-%d-" + string2;
            FsZapfDingbats = "-adobe-new century schoolbook-%s-%s-*-*-*-%d-" + string2;
        } else {
            FsDefault = "Default";
            FsMonospaced = "Monospaced";
            FsSansSerif = "SansSerif";
            FsSerif = "Serif";
            FsDialog = "Dialog";
            FsDialogInput = "DialogInput";
            FsZapfDingbats = "ZapfDingbats";
        }
        WndFont = new Font("Default", 1, 10);
        MenuFont = new Font("Default", 1, 10);
        TextFont = new Font("Default", 1, 10);
        TextAreaFont = new Font("Monospaced", 0, 12);
        TextFieldFont = new Font("Default", 1, 10);
        ListFont = new Font("Default", 1, 10);
        LabelFont = new Font("Default", 0, 10);
        BtnFont = new Font("Default", 1, 10);
        WndFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(WndFont);
        if (MenuBarHeight == 0) {
            MenuBarHeight = WndFontMetrics.getHeight() + 8;
        }
        beep = System.getProperty("awt.beep", "beep.wav");
        banner = System.getProperty("awt.banner", "banner.gif");
        if (banner != null) {
            Toolkit.tlkDisplayBanner(banner);
        }
        if (UserInitClass != null) {
            try {
                Class clazz = Class.forName(UserInitClass);
            }
            catch (Exception exception) {
                System.err.println("UserInitClass not initialized: " + exception);
            }
        }
    }
}

