/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;

public class StreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype;
    public String sval;
    public double nval;
    private PushbackReader pushIn;
    private LineNumberReader lineIn;
    private Reader rawIn;
    private TableEntry[] lookup = new TableEntry[256];
    private TableEntry ordinary;
    private boolean pushBack;
    private boolean EOLSignificant;
    private boolean CComments;
    private boolean CPlusPlusComments;
    private boolean toLower;
    private StringBuffer buffer;
    private boolean endOfFile;

    private int chrRead() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        return this.pushIn.read();
    }

    private void unRead(int n) throws IOException {
        if (n == -1) {
            this.endOfFile = true;
        } else {
            this.pushIn.unread(n);
        }
    }

    public void commentChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).isComment = true;
        }
    }

    public void eolIsSignificant(boolean bl) {
        this.EOLSignificant = bl;
    }

    public int lineno() {
        return this.lineIn.getLineNumber();
    }

    public void lowerCaseMode(boolean bl) {
        this.toLower = bl;
    }

    public int nextToken() throws IOException {
        if (this.pushBack) {
            this.pushBack = false;
            return this.ttype;
        }
        return this.nextTokenType();
    }

    /*
     * Unable to fully structure code
     */
    private int nextTokenType() throws IOException {
        block27: {
            block30: {
                block29: {
                    block28: {
                        var1_1 = this.chrRead();
                        if (var1_1 == 47 && (this.CComments || this.CPlusPlusComments)) {
                            var2_2 = this.chrRead();
                            if (var2_2 == 47 && this.CPlusPlusComments) {
                                this.skipLine();
                                this.nextTokenType();
                                return this.ttype;
                            }
                            if (var2_2 == 42 && this.CComments) {
                                this.skipCComment();
                                this.nextTokenType();
                                return this.ttype;
                            }
                            this.unRead(var2_2);
                        }
                        if (var1_1 == 10 && this.EOLSignificant) {
                            this.sval = null;
                            this.ttype = 10;
                            return this.ttype;
                        }
                        var2_3 = this.lookup(var1_1);
                        if (!TableEntry.access$2(var2_3)) break block28;
                        if (true) ** GOTO lbl26
                        do {
                            if ((var1_1 = this.chrRead()) == 10 && this.EOLSignificant) {
                                this.ttype = 10;
                                return this.ttype;
                            }
lbl26:
                            // 3 sources

                            this.lookup(var1_1);
                        } while (TableEntry.access$2(this.lookup(var1_1)));
                        this.unRead(var1_1);
                        this.ttype = this.nextTokenType();
                        break block27;
                    }
                    if (!TableEntry.access$3(var2_3)) break block29;
                    this.buffer.setLength(0);
                    if (true) ** GOTO lbl41
                    do {
                        this.buffer.append((char)var1_1);
                        var1_1 = this.chrRead();
                        if (var1_1 == 10 && this.EOLSignificant) break;
lbl41:
                        // 2 sources

                        this.lookup(var1_1);
                    } while (TableEntry.access$3(this.lookup(var1_1)));
                    this.unRead(var1_1);
                    try {
                        this.nval = new Double(this.buffer.toString());
                        this.ttype = -2;
                    }
                    catch (NumberFormatException var3_4) {
                        this.ttype = -3;
                        this.sval = this.buffer.toString();
                        if (this.toLower) {
                            this.sval = this.sval.toLowerCase();
                        }
                        break block27;
                    }
                }
                if (!TableEntry.access$4(var2_3)) break block30;
                this.buffer.setLength(0);
                if (true) ** GOTO lbl64
                while (true) {
                    this.buffer.append((char)var1_1);
                    var1_1 = this.chrRead();
                    if (var1_1 == 10 && this.EOLSignificant) break;
lbl64:
                    // 2 sources

                    this.lookup(var1_1);
                    if (TableEntry.access$4(this.lookup(var1_1))) continue;
                    this.lookup(var1_1);
                    if (!TableEntry.access$3(this.lookup(var1_1))) break;
                }
                this.unRead(var1_1);
                this.ttype = -3;
                this.sval = this.buffer.toString();
                if (this.toLower) {
                    this.sval = this.sval.toLowerCase();
                }
                break block27;
            }
            if (TableEntry.access$5(var2_3)) {
                var3_5 = var1_1;
                this.buffer.setLength(0);
                var1_1 = this.chrRead();
                while (var1_1 != var3_5) {
                    if (var1_1 == 92) {
                        var1_1 = this.chrRead();
                        switch (var1_1) {
                            case 97: {
                                var1_1 = 7;
                                break;
                            }
                            case 98: {
                                var1_1 = 8;
                                break;
                            }
                            case 102: {
                                var1_1 = 12;
                                break;
                            }
                            case 110: {
                                var1_1 = 10;
                                break;
                            }
                            case 114: {
                                var1_1 = 13;
                                break;
                            }
                            case 116: {
                                var1_1 = 9;
                                break;
                            }
                            case 118: {
                                var1_1 = 11;
                                break;
                            }
                        }
                    }
                    this.buffer.append((char)var1_1);
                    var1_1 = this.chrRead();
                    if (var1_1 == -1) break;
                }
                this.ttype = var3_5;
                this.sval = this.buffer.toString();
            } else if (TableEntry.access$0(var2_3)) {
                this.skipLine();
                this.ttype = this.nextTokenType();
            } else {
                this.sval = null;
                this.ttype = var1_1 == -1 ? -1 : var1_1;
            }
        }
        return this.ttype;
    }

    public void ordinaryChar(int n) {
        if (n >= 0 && n <= 255) {
            TableEntry tableEntry = this.lookup(n);
            tableEntry.isAlphabetic = false;
            tableEntry.isStringQuote = false;
            tableEntry.isNumeric = false;
            tableEntry.isComment = false;
            tableEntry.isWhitespace = false;
        }
    }

    public void ordinaryChars(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.ordinaryChar(n3);
            ++n3;
        }
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            this.lookup(n).isNumeric = true;
            ++n;
        }
        this.lookup(46).isNumeric = true;
        this.lookup(45).isNumeric = true;
    }

    public void pushBack() {
        this.pushBack = true;
    }

    public void quoteChar(int n) {
        if (n >= 0 && n <= 255) {
            this.lookup(n).isStringQuote = true;
        }
    }

    private void init() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.parseNumbers();
        this.commentChar(47);
        this.quoteChar(39);
        this.quoteChar(34);
        this.EOLSignificant = false;
        this.CComments = false;
        this.CPlusPlusComments = false;
        this.toLower = false;
    }

    public void resetSyntax() {
        this.ordinaryChars(0, 255);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipCComment() throws IOException {
        while (true) {
            int n;
            if ((n = this.chrRead()) == 42) {
                int n2 = this.chrRead();
                if (n2 == 47) return;
                this.unRead(n2);
                continue;
            }
            if (n == -1) return;
        }
    }

    private void skipLine() throws IOException {
        while (this.chrRead() != 10) {
        }
        if (this.EOLSignificant) {
            this.unRead(10);
        }
    }

    public void slashSlashComments(boolean bl) {
        this.CPlusPlusComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.CComments = bl;
    }

    public String toString() {
        if (this.ttype == -1) {
            return "EOF";
        }
        if (this.ttype == 10) {
            return "EOL";
        }
        if (this.ttype == -2) {
            return "Token[n=" + this.nval + "], line " + this.lineno();
        }
        return "Token[s=" + this.sval + "], line " + this.lineno();
    }

    public void whitespaceChars(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            TableEntry tableEntry = this.lookup(n3);
            tableEntry.isWhitespace = true;
            tableEntry.isAlphabetic = false;
            tableEntry.isNumeric = false;
            ++n3;
        }
    }

    public void wordChars(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.lookup(n3).isAlphabetic = true;
            ++n3;
        }
    }

    private TableEntry lookup(int n) {
        if (n < 0 || n > 255) {
            return this.ordinary;
        }
        return this.lookup[n];
    }

    public StreamTokenizer(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public StreamTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = this;
        if (streamTokenizer == null) {
            throw null;
        }
        this.ordinary = streamTokenizer.new TableEntry();
        this.pushBack = false;
        this.buffer = new StringBuffer();
        this.rawIn = reader;
        this.lineIn = new LineNumberReader(this.rawIn);
        this.pushIn = new PushbackReader(this.lineIn);
        int n = 0;
        while (n < this.lookup.length) {
            StreamTokenizer streamTokenizer2 = this;
            if (streamTokenizer2 == null) {
                throw null;
            }
            this.lookup[n] = streamTokenizer2.new TableEntry();
            ++n;
        }
        this.init();
    }

    class TableEntry {
        private boolean isNumeric = false;
        private boolean isWhitespace = false;
        private boolean isAlphabetic = false;
        private boolean isStringQuote = false;
        private boolean isComment = false;

        static /* synthetic */ boolean access$0(TableEntry tableEntry) {
            return tableEntry.isComment;
        }

        static /* synthetic */ boolean access$2(TableEntry tableEntry) {
            return tableEntry.isWhitespace;
        }

        static /* synthetic */ boolean access$3(TableEntry tableEntry) {
            return tableEntry.isNumeric;
        }

        static /* synthetic */ boolean access$4(TableEntry tableEntry) {
            return tableEntry.isAlphabetic;
        }

        static /* synthetic */ boolean access$5(TableEntry tableEntry) {
            return tableEntry.isStringQuote;
        }

        TableEntry() {
        }
    }
}

