/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import kaffe.lang.SystemClassLoader;
import kaffe.util.NotImplemented;

public abstract class ClassLoader {
    private final Hashtable loadedClasses = new Hashtable();
    private ProtectionDomain defaultProtectionDomain;
    private final ClassLoader parent;

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        block6: {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                block7: {
                    try {
                        if (this.parent != null) {
                            clazz = this.parent.loadClass(string, bl);
                            break block6;
                        }
                        if (this == ClassLoader.getSystemClassLoader()) break block7;
                        clazz = ClassLoader.getSystemClassLoader().loadClass(string, bl);
                        break block6;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if ((clazz = this.findClass(string)) == null) {
                    throw new ClassNotFoundException(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        if (this.defaultProtectionDomain == null) {
            this.defaultProtectionDomain = new ProtectionDomain(null, null);
        }
        return this.defineClass(string, byArray, n, n2, this.defaultProtectionDomain);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Class clazz = this.defineClass0(string, byArray, n, n2);
        if (string != null) {
            this.loadedClasses.put(string, clazz);
        } else {
            this.loadedClasses.put(clazz.getName(), clazz);
        }
        return clazz;
    }

    protected final void resolveClass(Class clazz) {
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().findClass(string);
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        throw new NotImplemented(this.getClass().getName() + ".setSigners()");
    }

    protected final Class findLoadedClass(String string) {
        return this.findLoadedClass0(string);
    }

    public URL getResource(String string) {
        try {
            return (URL)this.getResources(string).nextElement();
        }
        catch (IOException iOException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration enumeration;
        Vector vector = new Vector();
        ClassLoader classLoader = this.parent != null ? this.parent : (this != ClassLoader.getSystemClassLoader() ? ClassLoader.getSystemClassLoader() : null);
        if (classLoader != null) {
            enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        enumeration = this.findResources(string);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    protected Enumeration findResources(String string) throws IOException {
        return new Vector().elements();
    }

    protected URL findResource(String string) {
        try {
            return (URL)this.findResources(string).nextElement();
        }
        catch (IOException iOException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(string);
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public static ClassLoader getSystemClassLoader() {
        return SystemClassLoader.getClassLoader();
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        throw new NotImplemented(this.getClass().getName() + ".definePackage()");
    }

    protected Package getPackage(String string) {
        throw new NotImplemented(this.getClass().getName() + ".getPackage()");
    }

    protected Package[] getPackages() {
        throw new NotImplemented(this.getClass().getName() + ".getPackages()");
    }

    protected String findLibrary(String string) {
        return null;
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4);

    private native Class findLoadedClass0(String var1);

    private native void resolveClass0(Class var1);

    protected ClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    protected ClassLoader(ClassLoader classLoader) {
        System.getSecurityManager().checkCreateClassLoader();
        this.parent = classLoader;
    }
}

