/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashMap;
import java.util.Iterator;
import kaffe.lang.Application;
import kaffe.lang.ApplicationResource;
import kaffe.util.Deprecated;
import kaffe.util.Ptr;

public class Thread
implements Runnable,
ApplicationResource {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int threadCount;
    private char[] name;
    private int priority;
    private Thread threadQ;
    private Ptr PrivateInfo;
    private boolean daemon;
    private boolean interrupting;
    private Runnable target;
    private ThreadGroup group;
    private Ptr exceptPtr;
    private Throwable exceptObj;
    private Ptr jnireferences;
    private Throwable stackOverflowError;
    private Throwable outOfMemoryError;
    private boolean started;
    private boolean dying;
    private HashMap threadLocals;
    private Object suspendResume;
    private Object sleeper;
    private Object holder;
    private Ptr sem;
    private Thread nextlk;
    private Throwable death;
    private int needOnStack;
    private int noStopCount = 0;

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public void checkAccess() {
        System.getSecurityManager().checkAccess(this);
    }

    public native int countStackFrames();

    public static native Thread currentThread();

    public void destroy() {
        if (this.group != null) {
            this.group.remove(this);
        }
        this.destroy0();
    }

    private native void destroy0();

    public static void dumpStack() {
        Throwable throwable = new Throwable();
        throwable.printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    protected void finalize() throws Throwable {
        this.finalize0();
        super.finalize();
    }

    private final native void finalize0();

    private void finish() {
        Thread thread = this;
        synchronized (thread) {
            this.dying = true;
            this.notifyAll();
        }
        if (this.group != null) {
            this.group.remove(this);
        }
        Application.removeResource(this);
    }

    public void freeResource() {
        if (this.isAlive() && Thread.currentThread() != this) {
            this.destroy();
        }
    }

    private static String generateName() {
        return new String("Thread-" + threadCount++);
    }

    public final String getName() {
        return new String(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    synchronized HashMap getThreadLocals() {
        if (this.threadLocals == null) {
            this.threadLocals = new HashMap();
        }
        return this.threadLocals;
    }

    public void interrupt() {
        this.interrupting = true;
        Object object = this.holder;
        if (object != null) {
            this.holder = null;
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
        } else {
            this.interrupt0();
        }
    }

    private native void interrupt0();

    public static boolean interrupted() {
        Thread thread = Thread.currentThread();
        boolean bl = thread.interrupting;
        thread.interrupting = false;
        return bl;
    }

    public final boolean isAlive() {
        return this.started && !this.dying;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        return this.interrupting;
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public final synchronized void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final synchronized void join(long l, int n) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (l == 0L && n == 0) {
            while (this.isAlive()) {
                thread.waitOn(this, 0L);
            }
        } else {
            long l2 = System.currentTimeMillis() + l;
            while (true) {
                long l3 = l2 - System.currentTimeMillis();
                if (!this.isAlive() || l3 <= 0L) break;
                thread.waitOn(this, l3);
            }
        }
    }

    public final void resume() {
        if (this.suspendResume != null) {
            Object object = this.suspendResume;
            synchronized (object) {
                this.suspendResume.notifyAll();
            }
        }
    }

    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public final void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public final void setName(String string) {
        this.name = string.toCharArray();
    }

    public final void setPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > this.group.getMaxPriority()) {
            throw new IllegalArgumentException();
        }
        this.setPriority0(n);
    }

    public void setContextClassLoader(ClassLoader classLoader) {
    }

    private native void setPriority0(int var1);

    public static void sleep(long l) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread.sleeper == null) {
            thread.sleeper = new Sleeper();
        }
        if (l == 0L) {
            l = 1L;
        }
        Object object = thread.sleeper;
        synchronized (object) {
            thread.waitOn(thread.sleeper, l);
        }
    }

    public static void sleep(long l, int n) throws InterruptedException {
        Thread.sleep(l);
    }

    public synchronized void start() {
        if (this.dying) {
            throw new IllegalThreadStateException("Dead Thread");
        }
        if (this.started) {
            throw new IllegalThreadStateException("Active Thread");
        }
        this.started = true;
        this.start0();
    }

    public native void start0();

    public final void stop() {
        this.stop(new ThreadDeath());
    }

    public final synchronized void stop(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        this.death = throwable;
        Object object = this.holder;
        if (object != null) {
            this.holder = null;
            Object object2 = object;
            synchronized (object2) {
                object.notify();
            }
        } else {
            this.stop0(throwable);
        }
    }

    private native void stop0(Object var1);

    public final void suspend() {
        if (this.suspendResume == null) {
            this.suspendResume = new Suspender();
        }
        if (Thread.currentThread() != this) {
            throw new Deprecated("suspending of other threads not supported");
        }
        Object object = this.suspendResume;
        synchronized (object) {
            while (true) {
                try {
                    Object object2 = this.suspendResume;
                    synchronized (object2) {
                        this.waitOn(this.suspendResume, 0L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    void waitOn(Object object, long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout is negative");
        }
        if (this.interrupting) {
            this.interrupting = false;
            throw new InterruptedException();
        }
        if (this.death != null) {
            Error error = (Error)this.death;
            this.death = null;
            throw error;
        }
        this.holder = object;
        object.wait0(l);
        this.holder = null;
        if (this.interrupting) {
            this.interrupting = false;
            throw new InterruptedException();
        }
        if (this.death != null) {
            Error error = (Error)this.death;
            this.death = null;
            throw error;
        }
    }

    public static void yield() {
        Thread.yield0();
        Thread thread = Thread.currentThread();
        if (thread.death != null) {
            Error error = (Error)thread.death;
            thread.death = null;
            throw error;
        }
    }

    public static native void yield0();

    public Thread() {
        this(null, null, Thread.generateName());
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.generateName());
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string);
    }

    public Thread(String string) {
        this(null, null, string);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, Thread.generateName());
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        int n;
        int n2;
        Thread thread = Thread.currentThread();
        this.group = threadGroup == null ? thread.getThreadGroup() : threadGroup;
        this.group.checkAccess();
        this.group.add(this);
        this.name = string.toCharArray();
        Application.addResource(this);
        this.target = runnable;
        this.interrupting = false;
        this.stackOverflowError = new StackOverflowError();
        this.outOfMemoryError = new OutOfMemoryError();
        if (thread.threadLocals != null) {
            HashMap hashMap = thread.threadLocals;
            synchronized (hashMap) {
                Iterator iterator = thread.threadLocals.keySet().iterator();
                while (iterator.hasNext()) {
                    try {
                        InheritableThreadLocal inheritableThreadLocal = (InheritableThreadLocal)iterator.next();
                        inheritableThreadLocal.set(this, inheritableThreadLocal.childValue(inheritableThreadLocal.get()));
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((n2 = thread.getPriority()) < (n = this.group.getMaxPriority())) {
            this.setPriority0(n2);
        } else {
            this.setPriority0(n);
        }
        this.setDaemon(thread.isDaemon());
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string);
    }

    private static class Sleeper {
        Sleeper() {
        }
    }

    private static class Suspender {
        Suspender() {
        }
    }
}

