/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import kaffe.util.NotImplemented;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private DecimalFormatSymbols syms;
    private int groupsize;
    private int multiplier;
    private String negativeprefix;
    private String negativesuffix;
    private String positiveprefix;
    private String positivesuffix;
    private boolean decsepshown;

    public void applyLocalizedPattern(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == this.syms.digit) {
                cArray[n] = 35;
            } else if (cArray[n] == this.syms.patternSeparator) {
                cArray[n] = 59;
            } else if (cArray[n] == this.syms.zeroDigit) {
                cArray[n] = 48;
            } else if (cArray[n] == this.syms.groupSeparator) {
                cArray[n] = 44;
            } else if (cArray[n] == this.syms.decimalSeparator) {
                cArray[n] = 46;
            } else if (cArray[n] == this.syms.percentSign) {
                cArray[n] = 37;
            } else if (cArray[n] == this.syms.permillSign) {
                cArray[n] = 8240;
            } else if (cArray[n] == this.syms.currencySign) {
                cArray[n] = 164;
            } else if (cArray[n] == this.syms.minusSign) {
                cArray[n] = 45;
            } else if (cArray[n] == '\'') {
                ++n;
                while (n < cArray.length && cArray[n] != '\'') {
                    ++n;
                }
            }
            ++n;
        }
        this.applyPattern(new String(cArray));
    }

    public void applyPattern(String string) {
        this.multiplier = 100;
        this.negativeprefix = "";
        this.negativesuffix = "";
        this.positiveprefix = "";
        this.positivesuffix = "";
        this.intonly = true;
        this.minint = 1;
        this.maxint = Integer.MAX_VALUE;
        this.minfrac = 0;
        this.maxfrac = Integer.MAX_VALUE;
        this.decsepshown = false;
        this.groupsize = Integer.MAX_VALUE;
        this.grouping = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            block0 : switch (cArray[n5]) {
                case '#': 
                case ',': 
                case '.': 
                case '0': {
                    switch (n3) {
                        case 0: {
                            this.positiveprefix = new String(cArray, n4, n5 - n4);
                            n3 = 1;
                            n = n5;
                            break block0;
                        }
                        case 2: {
                            this.positivesuffix = new String(cArray, n4, n5 - n4);
                            n3 = 3;
                            break block0;
                        }
                        case 4: {
                            this.negativeprefix = new String(cArray, n4, n5 - n4);
                            n3 = 5;
                            break block0;
                        }
                        case 6: {
                            this.negativesuffix = new String(cArray, n4, n5 - n4);
                            n3 = 7;
                            break block0;
                        }
                    }
                    break;
                }
                case ';': {
                    if (n3 == 2) {
                        this.positivesuffix = new String(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    n2 = n5;
                    n3 = 4;
                    break;
                }
                default: {
                    switch (n3) {
                        case 1: {
                            n4 = n5;
                            n3 = 2;
                            break block0;
                        }
                        case 5: {
                            n4 = n5;
                            n3 = 6;
                            break block0;
                        }
                    }
                    break;
                }
            }
            ++n5;
        }
        if (n3 == 6) {
            this.negativesuffix = new String(cArray, n4, cArray.length - n4);
        }
        if (this.positiveprefix.equals(this.negativeprefix) && this.positivesuffix.equals(this.negativesuffix)) {
            char[] cArray2 = new char[]{this.syms.minusSign};
            this.negativeprefix = new String(cArray2);
        }
        boolean bl = false;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        while (n9 < n2) {
            switch (cArray[n9]) {
                case '0': {
                    if (n8 > 0 && bl) {
                        return;
                    }
                    ++n7;
                    break;
                }
                case '#': {
                    if (n7 > 0 && !bl) {
                        return;
                    }
                    ++n8;
                    break;
                }
                case '.': {
                    if (bl) {
                        return;
                    }
                    bl = true;
                    this.minint = n7;
                    this.maxint = Integer.MAX_VALUE;
                    if (n6 == -1 || n9 - n6 < 2) {
                        this.groupsize = 0;
                        this.grouping = false;
                    } else {
                        this.groupsize = n9 - n6 - 1;
                        this.grouping = true;
                    }
                    n8 = 0;
                    n7 = 0;
                    break;
                }
                case ',': {
                    if (n6 >= 0) {
                        return;
                    }
                    n6 = n9;
                    break;
                }
            }
            ++n9;
        }
        if (bl) {
            this.intonly = false;
            this.minfrac = n7;
            this.maxfrac = this.minfrac + n8;
            if (n7 > 0) {
                this.decsepshown = true;
            }
        } else {
            this.minint = n7;
        }
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    private StringBuffer format(String string, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n2 = string.indexOf(46);
        int n3 = n2;
        if (n3 == -1) {
            n3 = cArray.length;
        }
        if (cArray[n = 0] == '-') {
            ++n;
        }
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= n && n4 < this.maxint) {
            if (this.grouping && n4 % this.groupsize == 0 && n4 > 0) {
                stringBuffer2.append(this.syms.groupSeparator);
            }
            stringBuffer2.append((char)(cArray[n5] - 48 + this.syms.zeroDigit));
            --n5;
            ++n4;
        }
        while (n4 < this.minint) {
            if (this.grouping && n4 % this.groupsize == 0) {
                stringBuffer2.append(this.syms.groupSeparator);
            }
            stringBuffer2.append(this.syms.zeroDigit);
            ++n4;
        }
        stringBuffer2.reverse();
        if (cArray[0] == '-') {
            stringBuffer2.insert(0, this.negativeprefix);
        } else {
            stringBuffer2.insert(0, this.positiveprefix);
        }
        if (fieldPosition.field == 0) {
            fieldPosition.begin = stringBuffer.length();
            stringBuffer.append(stringBuffer2);
            fieldPosition.end = stringBuffer.length();
        } else {
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer2.setLength(0);
        if (!this.intonly) {
            n4 = 0;
            if (n2 != -1) {
                n = n2 + 1;
                n3 = cArray.length;
                n5 = n;
                while (n5 < n3 && n4 < this.maxfrac) {
                    stringBuffer2.append((char)(cArray[n5] - 48 + this.syms.zeroDigit));
                    ++n5;
                    ++n4;
                }
            }
            while (n4 < this.minfrac) {
                stringBuffer2.append(this.syms.zeroDigit);
                ++n4;
            }
        }
        if (cArray[0] == '-') {
            stringBuffer2.append(this.negativesuffix);
        } else {
            stringBuffer2.append(this.positivesuffix);
        }
        if (this.decsepshown || !this.intonly && (n2 != -1 || this.minfrac > 0)) {
            stringBuffer.append(this.syms.decimalSeparator);
        }
        if (fieldPosition.field == 1) {
            fieldPosition.begin = stringBuffer.length();
            stringBuffer.append(stringBuffer2);
            fieldPosition.end = stringBuffer.length();
        } else {
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(Double.toString(d), stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(Long.toString(l), stringBuffer, fieldPosition);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.syms;
    }

    public int getGroupingSize() {
        return this.groupsize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativeprefix;
    }

    public String getNegativeSuffix() {
        return this.negativesuffix;
    }

    public String getPositivePrefix() {
        return this.positiveprefix;
    }

    public String getPositiveSuffix() {
        return this.positivesuffix;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decsepshown;
    }

    public Number parse(String string, ParsePosition parsePosition) {
        char[] cArray;
        int n;
        int n2;
        char[] cArray2 = string.toCharArray();
        int n3 = this.positiveprefix.length();
        int n4 = this.negativeprefix.length();
        boolean bl = false;
        int n5 = 0;
        if (n3 > 0 && string.startsWith(this.positiveprefix)) {
            n2 = n3;
            n = cArray2.length - this.positivesuffix.length();
        } else if (n4 > 0 && string.startsWith(this.negativeprefix)) {
            n2 = n4;
            n = cArray2.length - this.negativesuffix.length();
            bl = true;
        } else {
            n2 = 0;
            n = cArray2.length;
        }
        if (bl) {
            cArray = new char[n - n2 + 1];
            cArray[n5++] = 45;
        } else {
            cArray = new char[n - n2];
        }
        int n6 = n2;
        while (n6 < n) {
            char c = cArray2[n6];
            if (Character.isDigit(c)) {
                cArray[n5++] = c;
            } else if (c == this.syms.decimalSeparator) {
                cArray[n5++] = 46;
            }
            ++n6;
        }
        return Double.valueOf(new String(cArray, 0, n5));
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.syms = decimalFormatSymbols;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decsepshown = bl;
    }

    public void setGroupingSize(int n) {
        this.groupsize = n;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void setNegativePrefix(String string) {
        this.negativeprefix = string;
    }

    public void setNegativeSuffix(String string) {
        this.negativesuffix = string;
    }

    public void setPositivePrefix(String string) {
        this.positiveprefix = string;
    }

    public void setPositiveSuffix(String string) {
        this.positivesuffix = string;
    }

    public String toLocalizedPattern() {
        throw new NotImplemented();
    }

    public String toPattern() {
        throw new NotImplemented();
    }

    public DecimalFormat() {
        this("#,##0.###;-#,##0.###", Locale.getDefault());
    }

    public DecimalFormat(String string) {
        this(string, Locale.getDefault());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.syms = decimalFormatSymbols;
        this.applyPattern(string);
    }

    DecimalFormat(String string, Locale locale2) {
        this(string, new DecimalFormatSymbols(locale2));
    }
}

