/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipLoader
extends ClassLoader {
    ZipFile zar;
    int size;
    private Vector loadedClasses;

    public ZipLoader(String name) throws IOException {
        this.zar = new ZipFile(name);
        this.size = 0;
        Enumeration<? extends ZipEntry> e = this.zar.entries();
        while (e.hasMoreElements()) {
            ZipEntry ent = e.nextElement();
            if (ent.isDirectory()) continue;
            ++this.size;
        }
        this.loadedClasses = new Vector(this.size);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clas;
        int index = this.loadedClasses.indexOf(name);
        if (index >= 0) {
            clas = (Class<?>)this.loadedClasses.elementAt(index + 1);
        } else if (this.zar == null) {
            clas = this.findSystemClass(name);
        } else {
            String member_name = String.valueOf(name.replace('.', '/')) + ".class";
            ZipEntry member = this.zar.getEntry(member_name);
            if (member == null) {
                clas = this.findSystemClass(name);
            } else {
                try {
                    int member_size = (int)member.getSize();
                    InputStream strm = this.zar.getInputStream(member);
                    byte[] bytes = new byte[member_size];
                    new DataInputStream(strm).readFully(bytes);
                    clas = this.defineClass(name, bytes, 0, member_size);
                    this.loadedClasses.addElement(name);
                    this.loadedClasses.addElement(clas);
                    if (2 * this.size == this.loadedClasses.size()) {
                        this.zar.close();
                        this.zar = null;
                    }
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("IOException while loading " + member_name + " from ziparchive \"" + name + "\": " + ex.toString());
                }
            }
        }
        if (resolve) {
            this.resolveClass(clas);
        }
        return clas;
    }
}

