/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.IntNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class S64Vector
extends UniformVector
implements Externalizable {
    long[] data;

    public S64Vector() {
    }

    public S64Vector(int n) {
        this.data = new long[n];
    }

    public S64Vector(int n, long l) {
        long[] lArray = new long[n];
        this.data = lArray;
        while (--n >= 0) {
            lArray[n] = l;
        }
    }

    public S64Vector(Sequence sequence) {
        this.data = new long[sequence.length()];
        this.copy(sequence);
    }

    public S64Vector(long[] lArray) {
        this.data = lArray;
    }

    public final Object get(int n) {
        return IntNum.make(this.data[n]);
    }

    public final String getTag() {
        return "s64";
    }

    public final int length() {
        return this.data.length;
    }

    public final long longValue(int n) {
        return this.data[n];
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.longValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = objectInput.readLong();
            ++n2;
        }
        this.data = lArray;
    }

    public final void set(int n, long l) {
        this.data[n] = l;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).longValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeLong(this.data[n2]);
            ++n2;
        }
    }
}

