/*
 * Decompiled with CFR 0.152.
 */
package gnu.ecmascript;

import gnu.ecmascript.Reserved;
import gnu.expr.QuoteExp;
import gnu.kawa.util.Sequence;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.SFormat;
import gnu.math.IntNum;
import gnu.text.Char;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Hashtable;

public class Lexer
extends gnu.text.Lexer {
    private boolean prevWasCR = false;
    public static final Char lparenToken = Char.make(40);
    public static final Char rparenToken = Char.make(41);
    public static final Char lbraceToken = Char.make(123);
    public static final Char rbraceToken = Char.make(125);
    public static final Char lbracketToken = Char.make(91);
    public static final Char rbracketToken = Char.make(93);
    public static final Char dotToken = Char.make(46);
    public static final Char condToken = Char.make(63);
    public static final Char commaToken = Char.make(44);
    public static final Char colonToken = Char.make(58);
    public static final Char equalToken = Char.make(61);
    public static final Char tildeToken = Char.make(126);
    public static final Char notToken = Char.make(33);
    public static final Char semicolonToken = Char.make(59);
    public static final Object eolToken = Char.make(10);
    public static final Object eofToken = Sequence.eofValue;
    public static final Reserved elseToken = new Reserved("else", 38);
    public static final Reserved newToken = new Reserved("new", 39);
    static Hashtable reserved;

    public Lexer(InPort inPort) {
        super(inPort);
    }

    public static Object checkReserved(String string) {
        if (reserved == null) {
            Lexer.initReserved();
        }
        return reserved.get(string);
    }

    public String getIdentifier(int n) throws IOException {
        int n2 = this.port.pos;
        int n3 = n2 - 1;
        int n4 = this.port.limit;
        char[] cArray = this.port.buffer;
        while (n2 < n4 && Character.isJavaIdentifierPart(cArray[n2])) {
            ++n2;
        }
        this.port.pos = n2;
        if (n2 < n4) {
            return new String(cArray, n3, n2 - n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n3, n2 - n3);
        while ((n = this.port.read()) >= 0) {
            if (Character.isJavaIdentifierPart((char)n)) {
                stringBuffer.append((char)n);
                continue;
            }
            this.port.unread_quick();
            break;
        }
        return stringBuffer.toString();
    }

    public Double getNumericLiteral(int n) throws IOException {
        boolean bl;
        int n2 = 10;
        if (n == 48) {
            n = this.read();
            if (n == 120 || n == 88) {
                n2 = 16;
                n = this.read();
            } else if (n != 46 && n != 101 && n != 69) {
                n2 = 8;
            }
        }
        int n3 = this.port.pos;
        if (n >= 0) {
            --n3;
        }
        this.port.pos = n3;
        long l = gnu.text.Lexer.readDigitsInBuffer(this.port, n2);
        boolean bl2 = bl = this.port.pos > n3;
        if (bl && this.port.pos < this.port.limit && !Character.isLetterOrDigit((char)(n = this.port.buffer[this.port.pos])) && n != 46) {
            double d = l >= 0L ? (double)l : IntNum.valueOf(this.port.buffer, n3, this.port.pos - n3, n2, false).doubleValue();
            return new Double(d);
        }
        if (n2 != 10) {
            this.error("invalid character in non-decimal number");
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        if (bl) {
            stringBuffer.append(this.port.buffer, n3, this.port.pos - n3);
        }
        int n4 = -1;
        int n5 = 0;
        boolean bl3 = false;
        block4: while (true) {
            if (Character.digit((char)(n = this.port.read()), n2) >= 0) {
                bl = true;
                stringBuffer.append((char)n);
                continue;
            }
            switch (n) {
                case 46: {
                    if (n4 >= 0) {
                        this.error("duplicate '.' in number");
                        continue block4;
                    }
                    n4 = stringBuffer.length();
                    stringBuffer.append('.');
                    continue block4;
                }
                case 69: 
                case 101: {
                    int n6;
                    if (n2 != 10 || (n6 = this.port.peek()) != 43 && n6 != 45 && Character.digit((char)n6, 10) < 0) break block4;
                    if (!bl) {
                        this.error("mantissa with no digits");
                    }
                    n5 = this.readOptionalExponent();
                    bl3 = true;
                    n = this.read();
                    break block4;
                }
            }
            break;
        }
        if (n >= 0) {
            this.port.unread();
        }
        if (n5 != 0) {
            stringBuffer.append('e');
            stringBuffer.append(n5);
        }
        return new Double(stringBuffer.toString());
    }

    public String getStringLiteral(char c) throws IOException, SyntaxException {
        int n;
        int n2 = n = this.port.pos;
        int n3 = this.port.limit;
        char[] cArray = this.port.buffer;
        while (n < n3) {
            char c2 = cArray[n];
            if (c2 == c) {
                this.port.pos = n + 1;
                return new String(cArray, n2, n - n2);
            }
            if (c2 == '\\' || c2 == '\n' || c2 == '\r') break;
            ++n;
        }
        this.port.pos = n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n2, n - n2);
        int n4;
        while ((n4 = this.port.read()) != c) {
            if (n4 < 0) {
                this.eofError("unterminated string literal");
            }
            if (n4 == 10 || n4 == 13) {
                this.fatal("string literal not terminated before end of line");
            }
            if (n4 == 92) {
                n4 = this.port.read();
                switch (n4) {
                    case -1: {
                        this.eofError("eof following '\\' in string");
                    }
                    case 10: 
                    case 13: {
                        this.fatal("line terminator following '\\' in string");
                        break;
                    }
                    case 98: {
                        n4 = 8;
                        break;
                    }
                    case 116: {
                        n4 = 9;
                        break;
                    }
                    case 110: {
                        n4 = 10;
                        break;
                    }
                    case 102: {
                        n4 = 12;
                        break;
                    }
                    case 114: {
                        n4 = 13;
                        break;
                    }
                    case 117: 
                    case 120: {
                        int n5;
                        int n6 = 0;
                        n = n4 == 120 ? 2 : 4;
                        while (--n >= 0) {
                            n5 = this.port.read();
                            if (n5 < 0) {
                                this.eofError("eof following '\\" + (char)n4 + "' in string");
                            }
                            if ((n5 = (int)Character.forDigit((char)n5, 16)) < 0) {
                                this.error("invalid char following '\\" + (char)n4 + "' in string");
                                n6 = 63;
                                break;
                            }
                            n6 = 16 * n6 + n5;
                        }
                        n4 = n6;
                        break;
                    }
                    default: {
                        int n5;
                        if (n4 < 48 || n4 > 55) break;
                        int n6 = 0;
                        n = 3;
                        while (--n >= 0) {
                            n5 = this.port.read();
                            if (n5 < 0) {
                                this.eofError("eof in octal escape in string literal");
                            }
                            if ((n5 = (int)Character.forDigit((char)n5, 8)) < 0) {
                                this.port.unread_quick();
                                break;
                            }
                            n6 = 8 * n6 + n5;
                        }
                        n4 = n6;
                    }
                    case 34: 
                    case 39: 
                    case 92: 
                }
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public Object getToken() throws IOException, SyntaxException {
        int n = this.read();
        while (true) {
            if (n < 0) {
                return eofToken;
            }
            if (!Character.isWhitespace((char)n)) break;
            if (n == 13) {
                this.prevWasCR = true;
                return eolToken;
            }
            if (n == 10 && !this.prevWasCR) {
                return eolToken;
            }
            this.prevWasCR = false;
            n = this.read();
        }
        switch (n) {
            case 46: {
                n = this.port.peek();
                if (n >= 48 && n <= 57) {
                    return new QuoteExp(this.getNumericLiteral(46));
                }
                return dotToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return new QuoteExp(this.getNumericLiteral(n));
            }
            case 34: 
            case 39: {
                return new QuoteExp(this.getStringLiteral((char)n));
            }
            case 40: {
                return lparenToken;
            }
            case 41: {
                return rparenToken;
            }
            case 91: {
                return lbracketToken;
            }
            case 93: {
                return rbracketToken;
            }
            case 123: {
                return lbraceToken;
            }
            case 125: {
                return rbraceToken;
            }
            case 63: {
                return condToken;
            }
            case 58: {
                return colonToken;
            }
            case 59: {
                return semicolonToken;
            }
            case 44: {
                return commaToken;
            }
            case 61: {
                if (this.port.peek() == 61) {
                    this.port.skip_quick();
                    return Reserved.opEqual;
                }
                return equalToken;
            }
            case 33: {
                if (this.port.peek() == 61) {
                    this.port.skip_quick();
                    return Reserved.opNotEqual;
                }
                return notToken;
            }
            case 126: {
                return tildeToken;
            }
            case 42: {
                return this.maybeAssignment(Reserved.opTimes);
            }
            case 47: {
                return this.maybeAssignment(Reserved.opDivide);
            }
            case 94: {
                return this.maybeAssignment(Reserved.opBitXor);
            }
            case 37: {
                return this.maybeAssignment(Reserved.opRemainder);
            }
            case 43: {
                if (this.port.peek() == 43) {
                    this.port.skip_quick();
                    return this.maybeAssignment(Reserved.opPlusPlus);
                }
                return this.maybeAssignment(Reserved.opPlus);
            }
            case 45: {
                if (this.port.peek() == 45) {
                    this.port.skip_quick();
                    return this.maybeAssignment(Reserved.opMinusMinus);
                }
                return this.maybeAssignment(Reserved.opMinus);
            }
            case 38: {
                if (this.port.peek() == 38) {
                    this.port.skip_quick();
                    return this.maybeAssignment(Reserved.opBoolAnd);
                }
                return this.maybeAssignment(Reserved.opBitAnd);
            }
            case 124: {
                if (this.port.peek() == 124) {
                    this.port.skip_quick();
                    return this.maybeAssignment(Reserved.opBoolOr);
                }
                return this.maybeAssignment(Reserved.opBitOr);
            }
            case 62: {
                n = this.port.peek();
                switch (n) {
                    case 62: {
                        this.port.skip_quick();
                        if (this.port.peek() == 62) {
                            this.port.skip_quick();
                            return this.maybeAssignment(Reserved.opRshiftUnsigned);
                        }
                        return this.maybeAssignment(Reserved.opRshiftSigned);
                    }
                    case 61: {
                        this.port.skip_quick();
                        return Reserved.opGreaterEqual;
                    }
                }
                return Reserved.opGreater;
            }
            case 60: {
                n = this.port.peek();
                switch (n) {
                    case 60: {
                        this.port.skip_quick();
                        return this.maybeAssignment(Reserved.opLshift);
                    }
                    case 61: {
                        this.port.skip_quick();
                        return Reserved.opLessEqual;
                    }
                }
                return Reserved.opLess;
            }
        }
        if (Character.isJavaIdentifierStart((char)n)) {
            String string = this.getIdentifier(n).intern();
            Object object2 = Lexer.checkReserved(string);
            if (object2 != null) {
                return object2;
            }
            return string;
        }
        return Char.make((char)n);
    }

    public static Object getToken(InPort inPort) throws IOException, SyntaxException {
        return new Lexer(inPort).getToken();
    }

    static synchronized void initReserved() {
        if (reserved == null) {
            reserved = new Hashtable(20);
            reserved.put("null", new QuoteExp(null));
            reserved.put("true", new QuoteExp(Boolean.TRUE));
            reserved.put("false", new QuoteExp(Boolean.FALSE));
            reserved.put("var", new Reserved("var", 30));
            reserved.put("if", new Reserved("if", 31));
            reserved.put("while", new Reserved("while", 32));
            reserved.put("for", new Reserved("for", 33));
            reserved.put("continue", new Reserved("continue", 34));
            reserved.put("break", new Reserved("break", 35));
            reserved.put("return", new Reserved("return", 36));
            reserved.put("with", new Reserved("with", 37));
            reserved.put("function", new Reserved("function", 41));
            reserved.put("this", new Reserved("this", 40));
            reserved.put("else", elseToken);
            reserved.put("new", newToken);
        }
    }

    public static void main(String[] stringArray) {
        InPort inPort = InPort.inDefault();
        Lexer lexer = new Lexer(inPort);
        try {
            Object object2;
            do {
                object2 = lexer.getToken();
                OutPort outPort = OutPort.outDefault();
                outPort.print("token:");
                SFormat.print(object2, outPort);
                outPort.println(" [class:" + object2.getClass() + "]");
            } while (object2 != Sequence.eofValue);
        }
        catch (Exception exception) {
            System.err.println("caught exception:" + exception);
            return;
        }
    }

    public Object maybeAssignment(Object object2) throws IOException, SyntaxException {
        int n = this.read();
        if (n == 61) {
            this.error("assignment operation not implemented");
        }
        if (n >= 0) {
            this.port.unread_quick();
        }
        return object2;
    }
}

