/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.LList;
import gnu.kawa.util.Sequence;
import gnu.mapping.Printable;
import gnu.mapping.SFormat;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class Pair
extends LList
implements Printable,
Externalizable {
    public Object car;
    public Object cdr;

    public Pair() {
    }

    public Pair(Object object2, Object object3) {
        this.car = object2;
        this.cdr = object3;
    }

    public static boolean equals(Pair pair, Pair pair2) {
        if (pair == pair2) {
            return true;
        }
        if (pair == null || pair2 == null) {
            return false;
        }
        Object object2;
        Object object3;
        while ((object3 = pair.car) == (object2 = pair2.car) || object3 != null && object3.equals(object2)) {
            object3 = pair.cdr;
            object2 = pair2.cdr;
            if (object3 == object2) {
                return true;
            }
            if (object3 == null || object2 == null) {
                return false;
            }
            if (!(object3 instanceof Pair) || !(object2 instanceof Pair)) {
                return object3.equals(object2);
            }
            pair = (Pair)object3;
            pair2 = (Pair)object2;
        }
        return false;
    }

    public boolean equals(Object object2) {
        if (object2 != null && object2 instanceof Pair) {
            return Pair.equals(this, (Pair)object2);
        }
        return false;
    }

    public Object get(int n) {
        int n2;
        Pair pair = this;
        for (n2 = n; n2 > 0; --n2) {
            if (pair.cdr instanceof Pair) {
                pair = (Pair)pair.cdr;
                continue;
            }
            if (!(pair.cdr instanceof Sequence)) break;
            return ((Sequence)pair.cdr).get(n2);
        }
        if (n2 == 0) {
            return pair.car;
        }
        throw new IndexOutOfBoundsException();
    }

    public int length() {
        int n = 0;
        Object object2 = this;
        Object object3 = this;
        while (object3 != LList.Empty) {
            if (!(object3 instanceof Pair)) {
                if (object3 instanceof Sequence) {
                    int n2 = ((Sequence)object3).length();
                    return n2 >= 0 ? n + n2 : n2;
                }
                return -2;
            }
            Pair pair = object3;
            if (pair.cdr == LList.Empty) {
                return n + 1;
            }
            if (object3 == object2 && n > 0) {
                return -1;
            }
            if (!(pair.cdr instanceof Pair)) {
                ++n;
                object3 = pair.cdr;
                continue;
            }
            if (!(object2 instanceof Pair)) {
                return -2;
            }
            object2 = ((Pair)object2).cdr;
            object3 = ((Pair)pair.cdr).cdr;
            n += 2;
        }
        return n;
    }

    public static Pair make(Object object2, Object object3) {
        return new Pair(object2, object3);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(");
        Pair.printNoParen(this, printWriter);
        printWriter.print(")");
    }

    public static final void printNoParen(Pair pair, PrintWriter printWriter) {
        block1: {
            Object object2;
            while (true) {
                SFormat.print(pair.car, printWriter);
                object2 = pair.cdr;
                if (object2 == null || object2 == LList.Empty) break block1;
                if (!(object2 instanceof Pair)) break;
                printWriter.print(" ");
                pair = (Pair)object2;
            }
            printWriter.print(" . ");
            SFormat.print(object2, printWriter);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.car = objectInput.readObject();
        this.cdr = objectInput.readObject();
    }

    public Object[] toArray() {
        int n = this.length();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        Sequence sequence = this;
        while (n2 < n && sequence instanceof Pair) {
            Pair pair = sequence;
            objectArray[n2] = pair.car;
            sequence = (Sequence)pair.cdr;
            ++n2;
        }
        int n3 = n2;
        while (n2 < n) {
            objectArray[n2] = ((Sequence)sequence).get(n2 - n3);
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = this.length();
        if (n2 > n) {
            objectArray = new Object[n2];
            n = n2;
        }
        int n3 = 0;
        Sequence sequence = this;
        while (n3 < n2 && sequence instanceof Pair) {
            Pair pair = sequence;
            objectArray[n3] = pair.car;
            sequence = (Sequence)pair.cdr;
            ++n3;
        }
        int n4 = n3;
        while (n3 < n2) {
            objectArray[n3] = ((Sequence)sequence).get(n3 - n4);
            ++n3;
        }
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.car);
        objectOutput.writeObject(this.cdr);
    }
}

