/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Interpreter;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.text.Char;

public class SpecialType
extends PrimType {
    Interpreter interpreter;

    public SpecialType(PrimType primType) {
        super(primType);
    }

    public SpecialType(PrimType primType, Interpreter interpreter) {
        super(primType);
        this.interpreter = interpreter;
    }

    public SpecialType(String string, String string2, int n, Class clazz) {
        super(string, string2, n, clazz);
    }

    public SpecialType(String string, String string2, int n, Class clazz, Interpreter interpreter) {
        super(string, string2, n, clazz);
        this.interpreter = interpreter;
    }

    public char charValue(Object object2) {
        if (object2 instanceof Character) {
            return ((Character)object2).charValue();
        }
        return ((Char)object2).charValue();
    }

    public Object coerceFromObject(Object object2) {
        if (object2.getClass() == this.reflectClass) {
            return object2;
        }
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                return this.interpreter.isTrue(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 'C': {
                return new Character(((Char)object2).charValue());
            }
        }
        return super.coerceFromObject(object2);
    }

    public Object coerceToObject(Object object2) {
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                return this.interpreter.booleanObject((Boolean)object2);
            }
            case 'C': {
                if (object2 instanceof Char) {
                    return object2;
                }
                return Char.make(((Character)object2).charValue());
            }
            case 'B': 
            case 'I': 
            case 'S': {
                return IntNum.make(((Number)object2).intValue());
            }
            case 'J': {
                return IntNum.make(((Number)object2).longValue());
            }
            case 'D': 
            case 'F': {
                return DFloNum.make(((Number)object2).doubleValue());
            }
            case 'V': {
                return Values.empty;
            }
        }
        return super.coerceToObject(object2);
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                this.interpreter.emitCoerceToBoolean(codeAttr);
                break;
            }
            case 'C': {
                ClassType classType = ClassType.make("gnu.text.Char");
                Method method = classType.getDeclaredMethod("charValue", 0);
                codeAttr.emitCheckcast(classType);
                codeAttr.emitInvokeVirtual(method);
                break;
            }
            default: {
                super.emitCoerceFromObject(codeAttr);
            }
        }
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
        char c = this.getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                codeAttr.emitIfIntNotZero();
                this.interpreter.emitPushBoolean(true, codeAttr);
                codeAttr.emitElse();
                this.interpreter.emitPushBoolean(false, codeAttr);
                codeAttr.emitFi();
                break;
            }
            case 'C': {
                ClassType classType = ClassType.make("gnu.text.Char");
                Method method = classType.getDeclaredMethod("make", 1);
                codeAttr.emitInvokeStatic(method);
                break;
            }
            case 'B': 
            case 'I': 
            case 'S': {
                ClassType classType = ClassType.make("gnu.math.IntNum");
                Type[] typeArray = new Type[]{Type.int_type};
                Method method = classType.getDeclaredMethod("make", typeArray);
                codeAttr.emitInvokeStatic(method);
                break;
            }
            case 'J': {
                ClassType classType = ClassType.make("gnu.math.IntNum");
                Type[] typeArray = new Type[]{Type.long_type};
                Method method = classType.getDeclaredMethod("make", typeArray);
                codeAttr.emitInvokeStatic(method);
                break;
            }
            case 'F': {
                codeAttr.emitConvert(Type.float_type, Type.double_type);
            }
            case 'D': {
                ClassType classType = ClassType.make("gnu.math.DFloNum");
                Type[] typeArray = new Type[]{Type.double_type};
                Method method = classType.getDeclaredMethod("make", typeArray);
                codeAttr.emitInvokeStatic(method);
                break;
            }
            default: {
                super.emitCoerceToObject(codeAttr);
            }
        }
    }
}

