/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Undefined;
import gnu.kawa.util.AbstractString;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class Interpreter {
    public static Interpreter defaultInterpreter = null;
    public static final Boolean trueObject = Boolean.TRUE;
    public static final Boolean falseObject = Boolean.FALSE;
    public static final Undefined undefinedObject;
    public static final Object voidObject;
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    static String[][] languages;
    protected Environment environ;

    static {
        new Undefined();
        undefinedObject = Undefined.getInstance();
        voidObject = Values.empty;
        languages = new String[][]{{"scheme", ".scm", "kawa.standard.Scheme"}, {"emacs", "elisp", "emacs-lisp", ".el", "gnu.jemacs.lang.ELisp"}, {"commonlisp", "common-lisp", "clisp", "lisp", ".lisp", ".lsp", ".cl", "gnu.commonlisp.lang.CommonLisp"}};
    }

    public Type asType(Object object2) {
        if (!(object2 instanceof Type)) {
            if (object2 instanceof Class) {
                return this.getTypeFor((Class)object2);
            }
            if (object2 instanceof String) {
                return this.getTypeFor((String)object2);
            }
            if (object2 instanceof AbstractString) {
                return ClassType.make(object2.toString());
            }
        }
        return (Type)object2;
    }

    public Object booleanObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object coerceFromObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceFromObject(object2);
    }

    public Object coerceToObject(int n) {
        return IntNum.make(n);
    }

    public Object coerceToObject(Class clazz, Object object2) {
        return this.getTypeFor(clazz).coerceToObject(object2);
    }

    public void define(String string, Object object2) {
        this.environ.define(string, object2);
    }

    public void emitCoerceToBoolean(CodeAttr codeAttr) {
        this.emitPushBoolean(false, codeAttr);
        codeAttr.emitIfNEq();
        codeAttr.emitPushInt(1);
        codeAttr.emitElse();
        codeAttr.emitPushInt(0);
        codeAttr.emitFi();
    }

    public void emitPushBoolean(boolean bl, CodeAttr codeAttr) {
        codeAttr.emitGetStatic(bl ? Compilation.trueConstant : Compilation.falseConstant);
    }

    public Environment getEnvironment() {
        return this.environ;
    }

    public static Interpreter getInstance(String string) {
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String[] stringArray = languages[n2];
            int n4 = n3 = stringArray.length - 1;
            while (--n4 >= 0) {
                Class<?> clazz;
                if (string != null && !stringArray[n4].equalsIgnoreCase(string)) continue;
                try {
                    clazz = Class.forName(stringArray[n3]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break;
                }
                return Interpreter.getInstance(string, clazz);
            }
            ++n2;
        }
        return null;
    }

    public static Interpreter getInstance(String string, Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            return (Interpreter)method.invoke(null, Values.noArgs);
        }
        catch (Exception exception) {
            if (string == null) {
                string = clazz.getName();
            }
            throw new WrappedException("getInstance for '" + string + "' failed", exception);
        }
    }

    public static Interpreter getInterpreter() {
        return defaultInterpreter;
    }

    public abstract Lexer getLexer(InPort var1, SourceMessages var2);

    public abstract String getName();

    public Environment getNewEnvironment() {
        return new Environment(this.environ);
    }

    public Type getTypeFor(Expression expression) {
        if (expression instanceof QuoteExp) {
            try {
                return this.asType(((QuoteExp)expression).getValue());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (expression instanceof ReferenceExp) {
            ReferenceExp referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration != null) {
                return this.getTypeFor(declaration.getValue());
            }
            String string = referenceExp.getName();
            int n = string.length();
            if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                return this.getTypeFor(string.substring(1, n - 1));
            }
        }
        return null;
    }

    public abstract Type getTypeFor(Class var1);

    public Type getTypeFor(String string) {
        return Interpreter.string2Type(string);
    }

    public boolean hasSeparateFunctionNamespace() {
        return false;
    }

    public boolean isTrue(Object object2) {
        return object2 != Boolean.FALSE;
    }

    public Object lookup(String string) {
        return this.environ.get(string);
    }

    public Object noValue() {
        return Values.empty;
    }

    public abstract void print(Object var1, OutPort var2);

    public abstract Object read(InPort var1) throws IOException, SyntaxException;

    public void setEnvironment(Environment environment) {
        this.environ = environment;
    }

    public static Type string2Type(String string) {
        Type type;
        if (string.endsWith("[]")) {
            type = Interpreter.string2Type(string.substring(0, string.length() - 2));
            if (type == null) {
                return null;
            }
            type = ArrayType.make(type);
        } else if (Type.isValidJavaTypeName(string)) {
            type = Type.getType(string);
        } else {
            return null;
        }
        return type;
    }
}

