// Swarm library. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#include "internal.h"
#import <tkobjc/ArchivedGeometryWidget.h>
#import <tkobjc/WindowGeometryRecord.h>
#import <tkobjc/global.h>
#import <defobj/defalloc.h> // getZone
#import <defobj.h> // Archiver methods

@implementation ArchivedGeometryWidget

PHASE(Creating)

+ createBegin: aZone
{
  ArchivedGeometryWidget *obj = [super createBegin: aZone];

  obj->windowGeometryRecordName = NULL;
  obj->destroyedFlag = NO;
  return obj;
}

+ create: (id <Zone>)aZone setWindowGeometryRecordName: (const char *)name
{
  return [[[self createBegin: aZone]
            setWindowGeometryRecordName: name]
           createEnd];
}

- setWindowGeometryRecordName: (const char *)name
{
  windowGeometryRecordName = name ? STRDUP (name) : NULL;
  return self;
}

- setSaveSizeFlag: (BOOL)theSaveSizeFlag
{
  saveSizeFlag = theSaveSizeFlag;

  return self;
}

- loadWindowGeometryRecord
{
  id windowGeometryRecord = nil;

  if (windowGeometryRecordName)
    windowGeometryRecord = [lispArchiver getObject: windowGeometryRecordName];
  return windowGeometryRecord;
}

- registerAndLoad
{
  id windowGeometryRecord;

  [lispArchiver registerClient: self];
  windowGeometryRecord = [self loadWindowGeometryRecord];
  tkobjc_setName (self, windowGeometryRecordName);
  if (windowGeometryRecord)
    {
      id topLevel = [self getTopLevel];

      if ([windowGeometryRecord getPositionFlag])
        [topLevel setX: [windowGeometryRecord getX]
                  Y: [windowGeometryRecord getY]];
    }

  return self;
}

- updateSize
{
  id windowGeometryRecord = [self loadWindowGeometryRecord];

  if (windowGeometryRecord)
    {
      if ([windowGeometryRecord getSizeFlag])
        [self setWidth: [windowGeometryRecord getWidth]
              Height: [windowGeometryRecord getHeight]];
    }
  return self;
}

- createEnd
{
  [super createEnd];
  [self registerAndLoad];

  return self;
}

PHASE(Using)

- (void)updateArchiver: archiver
{
  if (windowGeometryRecordName)
    {
      id windowGeometryRecord =
        [archiver getObject: windowGeometryRecordName];
      
      if (windowGeometryRecord == nil)
        windowGeometryRecord = [WindowGeometryRecord create: getZone (self)];

      if (saveSizeFlag)
        [windowGeometryRecord setWidth: [self getWidth]
                              Height: [self getHeight]];
      [windowGeometryRecord setX: [self getX] Y: [self getY]];
      [archiver putShallow: windowGeometryRecordName
                    object: windowGeometryRecord];
    }
}

- (void)drop
{ 
  if (windowGeometryRecordName)
    FREEBLOCK (windowGeometryRecordName);

  [lispArchiver unregisterClient: self];

  [super drop];
}
@end

