/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.CodeFragment;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;

public class ClassType
extends ObjectType
implements AttrContainer {
    public static final int minor_version = 3;
    public static final int major_version = 45;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    public int access_flags;
    Attribute attributes;
    String sourcefile;
    boolean emitDebugInfo = true;
    ConstantPool constants;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;

    public ClassType() {
    }

    public ClassType(String class_name) {
        this.setName(class_name);
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String name) {
        Field field = new Field(this);
        field.setName(name);
        return field;
    }

    public final Field addField(String name, Type type) {
        Field field = new Field(this);
        field.setName(name);
        field.setType(type);
        return field;
    }

    public final Field addField(String name, Type type, int flags) {
        Field field = this.addField(name, type);
        field.flags = flags;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fields;
        Class clas = this.getReflectClass();
        try {
            fields = clas.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            fields = clas.getFields();
        }
        int count = fields.length;
        int i = 0;
        while (i < count) {
            int modifiers;
            java.lang.reflect.Field field = fields[i];
            if (field.getDeclaringClass().equals(clas) && ((modifiers = field.getModifiers()) & 5) != 0) {
                this.addField(field.getName(), Type.make(field.getType()), modifiers);
            }
            ++i;
        }
        this.flags |= 1;
    }

    public void addInterface(ClassType newInterface) {
        int oldCount;
        if (this.interfaces == null || this.interfaces.length == 0) {
            oldCount = 0;
            this.interfaces = new ClassType[1];
        } else {
            int i = oldCount = this.interfaces.length;
            while (--i >= 0) {
                if (this.interfaces[i] != newInterface) continue;
                return;
            }
            ClassType[] newInterfaces = new ClassType[oldCount + 1];
            System.arraycopy(this.interfaces, 0, newInterfaces, 0, oldCount);
            this.interfaces = newInterfaces;
        }
        this.interfaces[oldCount] = newInterface;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String name) {
        Method method = new Method(this, 0);
        method.setName(name);
        return method;
    }

    public Method addMethod(String name, int flags) {
        Method method = new Method(this, flags);
        method.setName(name);
        return method;
    }

    public Method addMethod(String name, int flags, Type[] arg_types, Type return_type) {
        Method method = this.getDeclaredMethod(name, arg_types);
        if (method != null && return_type.equals(method.getReturnType()) && (flags & method.access_flags) == flags) {
            return method;
        }
        method = new Method(this, flags);
        method.setName(name);
        method.arg_types = arg_types;
        method.return_type = return_type;
        return method;
    }

    public Method addMethod(String name, String signature, int flags) {
        Method meth = this.addMethod(name, flags);
        meth.setSignature(signature);
        return meth;
    }

    public Method addMethod(String name, Type[] arg_types, Type return_type, int flags) {
        return this.addMethod(name, flags, arg_types, return_type);
    }

    public void addMethods(Class clas) {
        Constructor<?>[] cmethods;
        java.lang.reflect.Method[] methods;
        try {
            methods = clas.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            methods = clas.getMethods();
        }
        int count = methods.length;
        int i = 0;
        while (i < count) {
            int modifiers;
            java.lang.reflect.Method method = methods[i];
            if (method.getDeclaringClass().equals(clas) && ((modifiers = method.getModifiers()) & 5) != 0) {
                Class<?>[] paramTypes = method.getParameterTypes();
                int j = paramTypes.length;
                Type[] args = new Type[j];
                while (--j >= 0) {
                    args[j] = Type.make(paramTypes[j]);
                }
                Method meth = new Method(this, modifiers);
                meth.setName(method.getName());
                meth.arg_types = args;
                meth.return_type = Type.make(method.getReturnType());
            }
            ++i;
        }
        try {
            cmethods = clas.getDeclaredConstructors();
        }
        catch (SecurityException securityException) {
            cmethods = clas.getConstructors();
        }
        count = cmethods.length;
        int i2 = 0;
        while (i2 < count) {
            int modifiers;
            Constructor<?> method = cmethods[i2];
            if (method.getDeclaringClass().equals(clas) && ((modifiers = method.getModifiers()) & 5) != 0) {
                Class<?>[] paramTypes = method.getParameterTypes();
                int j = paramTypes.length;
                Type[] args = new Type[j];
                while (--j >= 0) {
                    args[j] = Type.make(paramTypes[j]);
                }
                Method meth = new Method(this, modifiers);
                meth.setName("<init>");
                meth.arg_types = args;
                meth.return_type = Type.void_type;
            }
            ++i2;
        }
        this.flags |= 2;
    }

    public int compare(Type other) {
        if (other == Type.nullType) {
            return 1;
        }
        if (other instanceof PrimType) {
            return Type.swappedCompareResult(((PrimType)other).compare(this));
        }
        if (other instanceof ArrayType) {
            return Type.swappedCompareResult(((ArrayType)other).compare(this));
        }
        if (!(other instanceof ClassType)) {
            return -3;
        }
        String name = this.getName();
        if (name != null && name.equals(other.getName())) {
            return 0;
        }
        ClassType cother = (ClassType)other;
        if (this.isInterface() || cother.isInterface()) {
            return -2;
        }
        if (this.isSubclass(cother)) {
            return -1;
        }
        if (cother.isSubclass(this)) {
            return 1;
        }
        return -3;
    }

    public void doFixups() {
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n = this.interfaces.length;
            this.interfaceIndexes = new int[n];
            int i = 0;
            while (i < n) {
                this.interfaceIndexes[i] = this.constants.addClass((ObjectType)this.interfaces[i]).index;
                ++i;
            }
        }
        Field field = this.fields;
        while (field != null) {
            field.assign_constants(this);
            field = field.next;
        }
        Method method = this.methods;
        while (method != null) {
            CodeAttr code = method.code;
            if (code != null) {
                CodeFragment frag;
                while ((frag = code.fragments) != null) {
                    code.fragments = frag.next;
                    frag.emit(code);
                }
                method.assign_constants();
                method.code.finalize_labels();
            }
            method = method.next;
        }
        Attribute.assignConstants(this, this);
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final CpoolEntry getConstant(int i) {
        if (this.constants == null || this.constants.pool == null || i > this.constants.count) {
            return null;
        }
        return this.constants.pool[i];
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public Field getDeclaredField(String name) {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        Field field = this.fields;
        while (field != null) {
            if (name.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String name, int argCount) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        Method result = null;
        Method method = this.methods;
        while (method != null) {
            if (name.equals(method.getName()) && argCount == method.getParameterTypes().length) {
                if (result != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + name + "\", " + argCount + ")\n - " + result + "\n - " + method);
                }
                result = method;
            }
            method = method.next;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Method getDeclaredMethod(String name, Type[] arg_types) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        method = this.methods;
        while (method != null) {
            block5: {
                if (!name.equals(method.getName())) break block5;
                method_args = method.getParameterTypes();
                if (arg_types == null || arg_types == method_args) {
                    return method;
                }
                i = arg_types.length;
                if (i == method_args.length) ** GOTO lbl-1000
                break block5;
                while (arg_types[i] == method_args[i]) lbl-1000:
                // 2 sources

                {
                    if (--i >= 0) continue;
                }
                if (i < 0) {
                    return method;
                }
            }
            method = method.next;
        }
        return null;
    }

    public Method getDeclaredMethods() {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public Field getField(String name) {
        ClassType cl = this;
        do {
            Field field;
            if ((field = cl.getDeclaredField(name)) == null) continue;
            return field;
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public final Field getFields() {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        return this.fields;
    }

    public ClassType[] getInterfaces() {
        if (this.interfaces == null && this.reflectClass != null) {
            Class<?>[] reflectInterfaces = this.reflectClass.getInterfaces();
            this.interfaces = new ClassType[reflectInterfaces.length];
            int i = 0;
            while (i < reflectInterfaces.length) {
                this.interfaces[i] = (ClassType)Type.make(reflectInterfaces[i]);
                ++i;
            }
        }
        return this.interfaces;
    }

    public Method[] getMatchingMethods(String name, Type[] paramTypes, int flags) {
        int i = this.getMethodCount();
        int nMatches = 0;
        Vector<Method> matches = new Vector<Method>(10);
        Method method = this.methods;
        while (method != null) {
            Type[] mtypes;
            if (name.equals(method.getName()) && (flags & 8) == (method.access_flags & 8) && (flags & 1) <= (method.access_flags & 1) && (mtypes = method.arg_types).length == paramTypes.length) {
                ++nMatches;
                matches.addElement(method);
            }
            method = method.getNext();
        }
        Object[] result = new Method[nMatches];
        matches.copyInto(result);
        return result;
    }

    public Method getMethod(String name, Type[] arg_types) {
        ClassType cl = this;
        do {
            Method method;
            if ((method = cl.getDeclaredMethod(name, arg_types)) == null) continue;
            return method;
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public Method[] getMethods(Filter filter, boolean searchSupers) {
        int count = 0;
        ClassType ctype = this;
        while (ctype != null) {
            Method meth = ctype.getDeclaredMethods();
            while (meth != null) {
                if (filter.select(meth)) {
                    ++count;
                }
                meth = meth.getNext();
            }
            if (!searchSupers) break;
            ctype = ctype.getSuperclass();
        }
        Method[] methods = new Method[count];
        count = 0;
        ClassType ctype2 = this;
        while (ctype2 != null) {
            Method meth = ctype2.getDeclaredMethods();
            while (meth != null) {
                if (filter.select(meth)) {
                    methods[count++] = meth;
                }
                meth = meth.getNext();
            }
            if (!searchSupers) break;
            ctype2 = ctype2.getSuperclass();
        }
        return methods;
    }

    public final int getModifiers() {
        if (this.access_flags == 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    public ClassType getSuperclass() {
        Class superReflectClass;
        if (this.superClass == null && this.reflectClass != null && (superReflectClass = this.reflectClass.getSuperclass()) != null) {
            this.superClass = (ClassType)Type.make(superReflectClass);
        }
        return this.superClass;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final boolean isSubclass(ClassType other) {
        ClassType baseClass = this;
        while (baseClass != null) {
            if (baseClass == other) {
                return true;
            }
            baseClass = baseClass.getSuperclass();
        }
        return false;
    }

    public static ClassType make(String name) {
        return (ClassType)Type.getType(name);
    }

    public static ClassType make(String name, ClassType superClass) {
        ClassType type = ClassType.make(name);
        if (type.superClass == null) {
            type.setSuper(superClass);
        }
        return type;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public void setInterfaces(ClassType[] interfaces) {
        this.interfaces = interfaces;
    }

    public final void setModifiers(int flags) {
        this.access_flags = flags;
    }

    public void setName(String name) {
        this.this_name = name;
        name = name.replace('.', '/');
        this.setSignature("L" + name + ";");
    }

    public void setSourceFile(String name) {
        SourceFileAttr.setSourceFile(this, name);
    }

    public void setSuper(ClassType superClass) {
        this.superClass = superClass;
    }

    public void setSuper(String name) {
        this.setSuper(name == null ? Type.pointer_type : ClassType.make(name));
    }

    public String toString() {
        return "ClassType " + this.getName();
    }

    public static byte[] to_utf8(String str) {
        if (str == null) {
            return null;
        }
        int str_len = str.length();
        int utf_len = 0;
        int i = 0;
        while (i < str_len) {
            char c = str.charAt(i);
            utf_len = c > '\u0000' && c <= '\u007f' ? ++utf_len : (c <= '\u07ff' ? (utf_len += 2) : (utf_len += 3));
            ++i;
        }
        byte[] buffer = new byte[utf_len];
        int j = 0;
        int i2 = 0;
        while (i2 < str_len) {
            char c = str.charAt(i2);
            if (c > '\u0000' && c <= '\u007f') {
                buffer[j++] = (byte)c;
            } else if (c <= '\u07ff') {
                buffer[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[j++] = (byte)(0x80 | c & 0x3F);
            } else {
                buffer[j++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[j++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[j++] = (byte)(0x80 | c & 0x3F);
            }
            ++i2;
        }
        return buffer;
    }

    public byte[] writeToArray() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(500);
        this.writeToStream(stream);
        return stream.toByteArray();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(String.valueOf(this.this_name.replace('.', File.separatorChar)) + ".class");
    }

    public void writeToFile(String filename) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
        this.writeToStream(stream);
        ((OutputStream)stream).close();
    }

    public void writeToStream(OutputStream stream) throws IOException {
        DataOutputStream dstr = new DataOutputStream(stream);
        this.doFixups();
        dstr.writeInt(-889275714);
        dstr.writeShort(3);
        dstr.writeShort(45);
        if (this.constants == null) {
            dstr.writeShort(1);
        } else {
            this.constants.write(dstr);
        }
        dstr.writeShort(this.access_flags);
        dstr.writeShort(this.thisClassIndex);
        dstr.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dstr.writeShort(0);
        } else {
            int interfaces_count = this.interfaceIndexes.length;
            dstr.writeShort(interfaces_count);
            int i = 0;
            while (i < interfaces_count) {
                dstr.writeShort(this.interfaceIndexes[i]);
                ++i;
            }
        }
        dstr.writeShort(this.fields_count);
        Field field = this.fields;
        while (field != null) {
            field.write(dstr, this);
            field = field.next;
        }
        dstr.writeShort(this.methods_count);
        Method method = this.methods;
        while (method != null) {
            method.write(dstr, this);
            method = method.next;
        }
        Attribute.writeAll(this, dstr);
        this.flags |= 3;
    }
}

