/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_button_stock.c
*/

#include "libkiazma.h"
#include "kiazma_button_stock.h"

static void kiazma_button_stock_class_init ( KiazmaButtonStockClass *klass ) {
	return;
}

static void kiazma_button_stock_init ( KiazmaButtonStock *ttt ) {
	return;
}

GType kiazma_button_stock_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaButtonStockClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_button_stock_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaButtonStock ),
			0,
			( GInstanceInitFunc ) kiazma_button_stock_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_BUTTON, "KiazmaButtonStock", &ttt_info, 0 );
	}

	return ttt_type;
}

GtkWidget* kiazma_button_stock_new ( const gchar *stock ) {
	GtkWidget *new_item;
	GtkWidget *image;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_button_stock_get_type (), NULL ) );

	image = gtk_image_new_from_stock ( stock, GTK_ICON_SIZE_MENU );
	gtk_container_add ( GTK_CONTAINER ( new_item ), image );

	return new_item;
}
