/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_BUTTONED_BOX_H
#define KIAZMA_BUTTONED_BOX_H

#include "libkiazma.h"

#define KIAZMA_BUTTONED_BOX_TYPE			( kiazma_buttoned_box_get_type () )
#define KIAZMA_BUTTONED_BOX(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_BUTTONED_BOX_TYPE, KiazmaButtonedBox ) )
#define KIAZMA_BUTTONED_BOX_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_BUTTONED_BOX_TYPE, KiazmaButtonedBoxClass ) )
#define IS_KIAZMA_BUTTONED_BOX(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_BUTTONED_BOX_TYPE ) )
#define IS_KIAZMA_BUTTONED_BOX_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_BUTTONED_BOX_TYPE ) )

typedef struct _KiazmaButtonedBox			KiazmaButtonedBox;
typedef struct _KiazmaButtonedBoxClass			KiazmaButtonedBoxClass;

struct _KiazmaButtonedBox {
	GtkHBox			main_win;
};

struct _KiazmaButtonedBoxClass {
	GtkHBoxClass				parent_class;
	void ( *kiazma_buttoned_box )		( KiazmaButtonedBox *synp );
};

GType		kiazma_buttoned_box_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_buttoned_box_new				( GtkWidget *item, const gchar *stock );
GtkWidget*	kiazma_buttoned_box_get_item			( KiazmaButtonedBox *box );

#endif /* KIAZMA_BUTTONED_BOX_H */
