/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_frame.c

	KiazmaFrame is a convenience container which aligns his children and
	the labels which accompaign them
*/

#include "libkiazma.h"
#include "kiazma_frame.h"

/**
	@internal

	Init the class for KiazmaFrame

	@param	klass	Instance of the class to init
*/
static void kiazma_frame_class_init ( KiazmaFrameClass *klass ) {
	return;
}

/**
	@internal

	Init the internals of KiazmaFrame

	@param	ttt	The KiazmaFrame to init
*/
static void kiazma_frame_init ( KiazmaFrame *ttt ) {
	gtk_container_set_border_width ( GTK_CONTAINER ( ttt ), 5 );
}

/**
	Register the GType for KiazmaFrame

	@return		The newly registered type for the widget
*/
GType kiazma_frame_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaFrameClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_frame_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaFrame ),
			0,
			( GInstanceInitFunc ) kiazma_frame_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_FRAME, "KiazmaFrame", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
	Builds a new KiazmaFrame

	@param	title	Title which appears of top of the frame

	@return		The new KiazmaFrame
*/
GtkWidget* kiazma_frame_new ( gchar *title ) {
	GtkWidget *new_item;
	KiazmaFrame *frame;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_frame_get_type (), NULL ) );
	gtk_frame_set_label ( GTK_FRAME ( new_item ), title );

	frame = KIAZMA_FRAME ( new_item );
	frame->box = gtk_vbox_new ( FALSE, 2 );
	gtk_container_add ( GTK_CONTAINER ( frame ), frame->box );
	frame->sg = gtk_size_group_new ( GTK_SIZE_GROUP_HORIZONTAL );

	return new_item;
}

/**
	@param	title
	@param	group

	@return
*/
GtkWidget* kiazma_frame_new_from_group ( gchar *title, GtkSizeGroup *group ) {
	GtkWidget *new_item;
	KiazmaFrame *frame;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_frame_get_type (), NULL ) );
	gtk_frame_set_label ( GTK_FRAME ( new_item ), title );

	frame = KIAZMA_FRAME ( new_item );
	frame->box = gtk_vbox_new ( FALSE, 2 );
	gtk_container_add ( GTK_CONTAINER ( frame ), frame->box );
	frame->sg = group;

	return new_item;
}

/**
	@param	title

	@return
*/
GtkWidget* kiazma_frame_new_empty ( gchar *title ) {
	GtkWidget *new_item;
	KiazmaFrame *frame;

	new_item = GTK_WIDGET ( g_object_new ( kiazma_frame_get_type (), NULL ) );
	gtk_frame_set_label ( GTK_FRAME ( new_item ), title );
	frame = KIAZMA_FRAME ( new_item );
	frame->sg = NULL;
	return new_item;
}

/**
	To add an item into the frame

	@param	frame	Frame in which add the new item
	@param	title	Text of the label which accompaign the new item
	@param	item	Widget to put in the frame
*/
void kiazma_frame_add ( KiazmaFrame *frame, gchar *title, GtkWidget *item ) {
	GtkWidget *new_item;

	if ( frame->sg == NULL ) {
		g_warning ( "Trying to add an element to a KiazmaFrame inited as empty" );
		return;
	}

	new_item = kiazma_aligned_new ( frame->sg, title, item );
	gtk_box_pack_start ( GTK_BOX ( frame->box ), new_item, TRUE, TRUE, 0 );
}

/**
	@param	frame
	@param	item
*/
void kiazma_frame_free_add ( KiazmaFrame *frame, GtkWidget *item ) {
	gtk_box_pack_start ( GTK_BOX ( frame->box ), item, TRUE, TRUE, 0 );
}

/**
	@param	frame

	@return
*/
GtkSizeGroup* kiazma_frame_get_group ( KiazmaFrame *frame ) {
	return frame->sg;
}
