/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_GIDLIST_H
#define KIAZMA_GIDLIST_H

#include "libkiazma.h"

#define KIAZMA_GIDLIST_TYPE			( kiazma_gidlist_get_type () )
#define KIAZMA_GIDLIST(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_GIDLIST_TYPE, KiazmaGidList ) )
#define KIAZMA_GIDLIST_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_GIDLIST_TYPE, KiazmaGidListClass ) )
#define IS_KIAZMA_GIDLIST(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_GIDLIST_TYPE ) )
#define IS_KIAZMA_GIDLIST_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_GIDLIST_TYPE ) )

typedef struct _KiazmaGidList			KiazmaGidList;
typedef struct _KiazmaGidListClass		KiazmaGidListClass;

struct _KiazmaGidList {
	GtkComboBox		list;
};

struct _KiazmaGidListClass {
	GtkComboBoxClass	parent_class;
	void ( *kiazma_gid_list ) ( KiazmaGidList *synp );
};

GType		kiazma_gidlist_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_gidlist_new			();
void		kiazma_gidlist_clear			( KiazmaGidList *list );
uid_t		kiazma_gidlist_get_value		( KiazmaGidList *list );
void		kiazma_gidlist_set_value		( KiazmaGidList *list, gid_t group );

#endif /* KIAZMA_GIDLIST_H */
