/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_HOUR_H
#define KIAZMA_HOUR_H

#include "libkiazma.h"

#define KIAZMA_HOUR_TYPE			( kiazma_hour_get_type () )
#define KIAZMA_HOUR(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_HOUR_TYPE, KiazmaHour ) )
#define KIAZMA_HOUR_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_HOUR_TYPE, KiazmaHourClass ) )
#define IS_KIAZMA_HOUR(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_HOUR_TYPE ) )
#define IS_KIAZMA_HOUR_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_HOUR_TYPE ) )

typedef enum {
	FORMAT_12_HOUR,
	FORMAT_24_HOUR
} KIAZMA_HOUR_FORMAT;

typedef struct _KiazmaHour			KiazmaHour;
typedef struct _KiazmaHourClass			KiazmaHourClass;

struct _KiazmaHour {
	GtkHBox			main_win;
	GtkWidget		**hour;
	KIAZMA_HOUR_FORMAT	format;
};

struct _KiazmaHourClass {
	GtkHBoxClass		parent_class;
	void ( *kiazma_hour )	( KiazmaHour *item );
};

GType		kiazma_hour_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_hour_new			();
void		kiazma_hour_clear		( KiazmaHour *item );
time_t		kiazma_hour_get_value		( KiazmaHour *item );
void		kiazma_hour_set_value		( KiazmaHour *item, time_t value );

#endif /* KIAZMA_HOUR_H */
