/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* gtkiconview.c
 * Copyright (C) 2002, 2004  Anders Carlsson <andersca@gnu.org>
 */

#ifndef KIAZMA_ICON_STACKED_VIEW_H
#define KIAZMA_ICON_STACKED_VIEW_H

#include "libkiazma.h"

#define KIAZMA_ICON_STACKED_VIEW_TYPE			( kiazma_icon_stacked_view_get_type () )
#define KIAZMA_ICON_STACKED_VIEW(obj)			( GTK_CHECK_CAST ( ( obj ), KIAZMA_ICON_STACKED_VIEW_TYPE, KiazmaIconStackedView ) )
#define KIAZMA_ICON_STACKED_VIEW_CLASS(klass)		( GTK_CHECK_CLASS_CAST ( ( klass ), KIAZMA_ICON_STACKED_VIEW_TYPE, 9KiazmaIconStackedViewClass ) )
#define IS_KIAZMA_ICON_STACKED_VIEW(obj)		( GTK_CHECK_TYPE ( ( obj ), KIAZMA_ICON_STACKED_VIEW_TYPE ) )
#define IS_KIAZMA_ICON_STACKED_VIEW_CLASS(klass)	( GTK_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_ICON_STACKED_VIEW_TYPE ) )
#define KIAZMA_ICON_STACKED_VIEW_GET_CLASS(obj)		( GTK_CHECK_GET_CLASS ( ( obj ), KIAZMA_ICON_STACKED_VIEW_TYPE, KiazmaIconStackedViewClass ) )

typedef struct _KiazmaIconStackedView           KiazmaIconStackedView;
typedef struct _KiazmaIconStackedViewClass      KiazmaIconStackedViewClass;
typedef struct _KiazmaIconStackedViewPrivate    KiazmaIconStackedViewPrivate;

typedef void ( *KiazmaIconStackedViewForeachFunc )	( KiazmaIconStackedView *icon_view, GtkTreePath *path, gpointer data );

typedef enum {
	KIAZMA_ICON_STACKED_VIEW_NO_DROP,
	KIAZMA_ICON_STACKED_VIEW_DROP_INTO,
	KIAZMA_ICON_STACKED_VIEW_DROP_LEFT,
	KIAZMA_ICON_STACKED_VIEW_DROP_RIGHT,
	KIAZMA_ICON_STACKED_VIEW_DROP_ABOVE,
	KIAZMA_ICON_STACKED_VIEW_DROP_BELOW
} KiazmaIconStackedViewDropPosition;

struct _KiazmaIconStackedView {
	GtkContainer		parent;
	KiazmaIconStackedViewPrivate *priv;
};

struct _KiazmaIconStackedViewClass {
	GtkContainerClass	parent_class;

	void			( *set_scroll_adjustments )	( KiazmaIconStackedView *icon_view, GtkAdjustment *hadjustment, GtkAdjustment *vadjustment );
	void			( *item_activated )		( KiazmaIconStackedView *icon_view, GtkTreePath *path );
	void			( *selection_changed )		( KiazmaIconStackedView *icon_view );

	/* Key binding signals */
	void			( *select_all )			( KiazmaIconStackedView *icon_view );
	void			( *unselect_all )		( KiazmaIconStackedView *icon_view );
	void			( *select_cursor_item )		( KiazmaIconStackedView *icon_view );
	void			( *toggle_cursor_item )		( KiazmaIconStackedView *icon_view );
	gboolean		( *move_cursor )		( KiazmaIconStackedView *icon_view, GtkMovementStep step, gint count );
	gboolean		( *activate_cursor_item )	( KiazmaIconStackedView *icon_view );
};

GType		kiazma_icon_stacked_view_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_icon_stacked_view_new			();
GtkWidget*	kiazma_icon_stacked_view_new_with_model		( GtkTreeModel *model );

void		kiazma_icon_stacked_view_set_model		( KiazmaIconStackedView *icon_view, GtkTreeModel *model );
GtkTreeModel*	kiazma_icon_stacked_view_get_model		( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_text_column	( KiazmaIconStackedView *icon_view, gint column );
gint		kiazma_icon_stacked_view_get_text_column	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_markup_column	( KiazmaIconStackedView *icon_view, gint column );
gint		kiazma_icon_stacked_view_get_markup_column	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_pixbuf_column	( KiazmaIconStackedView    *icon_view, gint column );
gint		kiazma_icon_stacked_view_get_pixbuf_column	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_id_column		( KiazmaIconStackedView *icon_view, gint column );
gint		kiazma_icon_stacked_view_get_id_column		( KiazmaIconStackedView *icon_view );

void		kiazma_icon_stacked_view_set_orientation	( KiazmaIconStackedView *icon_view, GtkOrientation orientation );
GtkOrientation	kiazma_icon_stacked_view_get_orientation	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_columns		( KiazmaIconStackedView *icon_view, gint columns );
gint		kiazma_icon_stacked_view_get_columns		( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_item_width		( KiazmaIconStackedView *icon_view, gint item_width );
gint		kiazma_icon_stacked_view_get_item_width		( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_spacing		( KiazmaIconStackedView *icon_view, gint spacing );
gint		kiazma_icon_stacked_view_get_spacing		( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_row_spacing	( KiazmaIconStackedView *icon_view, gint row_spacing );
gint		kiazma_icon_stacked_view_get_row_spacing	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_column_spacing	( KiazmaIconStackedView *icon_view, gint column_spacing );
gint		kiazma_icon_stacked_view_get_column_spacing	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_margin		( KiazmaIconStackedView *icon_view, gint margin );
gint		kiazma_icon_stacked_view_get_margin		( KiazmaIconStackedView *icon_view );

GtkTreePath*	kiazma_icon_stacked_view_get_path_at_pos	( KiazmaIconStackedView *icon_view, gint x, gint y );
gboolean	kiazma_icon_stacked_view_get_item_at_pos	( KiazmaIconStackedView *icon_view, gint x, gint y, GtkTreePath **path, GtkCellRenderer **cell );
gboolean	kiazma_icon_stacked_view_get_visible_range	( KiazmaIconStackedView *icon_view, GtkTreePath **start_path, GtkTreePath **end_path );

void			kiazma_icon_stacked_view_selected_foreach	( KiazmaIconStackedView *icon_view, KiazmaIconStackedViewForeachFunc func, gpointer data );
void			kiazma_icon_stacked_view_set_selection_mode	( KiazmaIconStackedView *icon_view, GtkSelectionMode mode );
GtkSelectionMode	kiazma_icon_stacked_view_get_selection_mode	( KiazmaIconStackedView *icon_view );
void			kiazma_icon_stacked_view_select_path		( KiazmaIconStackedView *icon_view, GtkTreePath *path );
void			kiazma_icon_stacked_view_unselect_path		( KiazmaIconStackedView *icon_view, GtkTreePath *path );
gboolean		kiazma_icon_stacked_view_path_is_selected	( KiazmaIconStackedView *icon_view, GtkTreePath *path );
GList*			kiazma_icon_stacked_view_get_selected_items	( KiazmaIconStackedView *icon_view );
void			kiazma_icon_stacked_view_select_all		( KiazmaIconStackedView *icon_view );
void			kiazma_icon_stacked_view_unselect_all		( KiazmaIconStackedView *icon_view );
void			kiazma_icon_stacked_view_item_activated		( KiazmaIconStackedView *icon_view, GtkTreePath *path );
void			kiazma_icon_stacked_view_set_cursor		( KiazmaIconStackedView *icon_view, GtkTreePath *path, GtkCellRenderer *cell, gboolean start_editing );
gboolean		kiazma_icon_stacked_view_get_cursor		( KiazmaIconStackedView *icon_view, GtkTreePath **path, GtkCellRenderer **cell );
void			kiazma_icon_stacked_view_scroll_to_path		( KiazmaIconStackedView *icon_view, GtkTreePath *path, gboolean use_align, gfloat row_align, gfloat col_align );

/* Drag-and-Drop support */
void		kiazma_icon_stacked_view_enable_model_drag_source	( KiazmaIconStackedView *icon_view, GdkModifierType start_button_mask, const GtkTargetEntry *targets, gint n_targets, GdkDragAction actions );
void		kiazma_icon_stacked_view_enable_model_drag_dest		( KiazmaIconStackedView *icon_view, const GtkTargetEntry *targets, gint n_targets, GdkDragAction actions );
void		kiazma_icon_stacked_view_unset_model_drag_source	( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_unset_model_drag_dest		( KiazmaIconStackedView *icon_view );
void		kiazma_icon_stacked_view_set_reorderable		( KiazmaIconStackedView *icon_view, gboolean reorderable );
gboolean	kiazma_icon_stacked_view_get_reorderable		( KiazmaIconStackedView *icon_view );

/* These are useful to implement your own custom stuff. */
void		kiazma_icon_stacked_view_set_drag_dest_item	( KiazmaIconStackedView *icon_view, GtkTreePath *path, KiazmaIconStackedViewDropPosition pos );
void		kiazma_icon_stacked_view_get_drag_dest_item	( KiazmaIconStackedView *icon_view, GtkTreePath **path, KiazmaIconStackedViewDropPosition *pos );
gboolean	kiazma_icon_stacked_view_get_dest_item_at_pos	( KiazmaIconStackedView *icon_view, gint drag_x, gint drag_y, GtkTreePath **path, KiazmaIconStackedViewDropPosition *pos );
GdkPixmap*	kiazma_icon_stacked_view_create_drag_icon	( KiazmaIconStackedView *icon_view, GtkTreePath *path );

#endif /* KIAZMA_ICON_STACKED_VIEW_H */
